/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.admin;

import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.AtlanRequest;
import com.atlan.model.admin.AtlanTagPayload;
import com.atlan.model.assets.Asset;
import java.util.ArrayList;
import java.util.UUID;
import lombok.Generated;

public class AtlanTagRequest
extends AtlanRequest {
    private static final long serialVersionUID = 2L;
    public static final String REQUEST_TYPE = "attach_classification";
    public static final String SOURCE_TYPE = "atlas";
    String requestType;
    String sourceType;
    AtlanTagPayload payload;

    public static AtlanTagRequestBuilder<?, ?> creator(Asset asset, AtlanTagPayload atlanTagDetails) throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (asset.getQualifiedName() == null || asset.getQualifiedName().isEmpty()) {
            missing.add("qualifiedName");
        }
        if (asset.getGuid() == null || asset.getGuid().isEmpty()) {
            missing.add("guid");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, asset.getTypeName(), String.join((CharSequence)",", missing));
        }
        return AtlanTagRequest.creator(asset.getGuid(), asset.getQualifiedName(), asset.getTypeName(), atlanTagDetails);
    }

    public static AtlanTagRequestBuilder<?, ?> creator(String assetGuid, String assetQualifiedName, String assetType, AtlanTagPayload atlanTagDetails) {
        return ((AtlanTagRequestBuilder)((AtlanTagRequestBuilder)((AtlanTagRequestBuilder)((AtlanTagRequestBuilder)AtlanTagRequest.builder().id(UUID.randomUUID().toString())).destinationGuid(assetGuid)).destinationQualifiedName(assetQualifiedName)).entityType(assetType)).payload(atlanTagDetails);
    }

    @Generated
    private static String $default$requestType() {
        return REQUEST_TYPE;
    }

    @Generated
    private static String $default$sourceType() {
        return SOURCE_TYPE;
    }

    @Generated
    protected AtlanTagRequest(AtlanTagRequestBuilder<?, ?> b) {
        super((AtlanRequest.AtlanRequestBuilder<?, ?>)b);
        this.requestType = b.requestType$set ? b.requestType$value : AtlanTagRequest.$default$requestType();
        this.sourceType = b.sourceType$set ? b.sourceType$value : AtlanTagRequest.$default$sourceType();
        this.payload = b.payload;
    }

    @Generated
    public static AtlanTagRequestBuilder<?, ?> builder() {
        return new AtlanTagRequestBuilderImpl();
    }

    @Generated
    public AtlanTagRequestBuilder<?, ?> toBuilder() {
        return new AtlanTagRequestBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public AtlanTagPayload getPayload() {
        return this.payload;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtlanTagRequest)) {
            return false;
        }
        AtlanTagRequest other = (AtlanTagRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$requestType = this.getRequestType();
        String other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !this$requestType.equals(other$requestType)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        AtlanTagPayload this$payload = this.getPayload();
        AtlanTagPayload other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtlanTagRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $requestType = this.getRequestType();
        result = result * 59 + ($requestType == null ? 43 : $requestType.hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        AtlanTagPayload $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AtlanTagRequest(super=" + super.toString() + ", requestType=" + this.getRequestType() + ", sourceType=" + this.getSourceType() + ", payload=" + String.valueOf(this.getPayload()) + ")";
    }

    @Override
    @Generated
    public String getRequestType() {
        return this.requestType;
    }

    @Override
    @Generated
    public String getSourceType() {
        return this.sourceType;
    }

    @Generated
    public static abstract class AtlanTagRequestBuilder<C extends AtlanTagRequest, B extends AtlanTagRequestBuilder<C, B>>
    extends AtlanRequest.AtlanRequestBuilder<C, B> {
        @Generated
        private boolean requestType$set;
        @Generated
        private String requestType$value;
        @Generated
        private boolean sourceType$set;
        @Generated
        private String sourceType$value;
        @Generated
        private AtlanTagPayload payload;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AtlanTagRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AtlanTagRequest instance, AtlanTagRequestBuilder<?, ?> b) {
            b.requestType(instance.requestType);
            b.sourceType(instance.sourceType);
            b.payload(instance.payload);
        }

        @Override
        @Generated
        public B requestType(String requestType) {
            this.requestType$value = requestType;
            this.requestType$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public B sourceType(String sourceType) {
            this.sourceType$value = sourceType;
            this.sourceType$set = true;
            return (B)this.self();
        }

        @Generated
        public B payload(AtlanTagPayload payload) {
            this.payload = payload;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AtlanTagRequest.AtlanTagRequestBuilder(super=" + super.toString() + ", requestType$value=" + this.requestType$value + ", sourceType$value=" + this.sourceType$value + ", payload=" + String.valueOf(this.payload) + ")";
        }
    }

    @Generated
    private static final class AtlanTagRequestBuilderImpl
    extends AtlanTagRequestBuilder<AtlanTagRequest, AtlanTagRequestBuilderImpl> {
        @Generated
        private AtlanTagRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected AtlanTagRequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AtlanTagRequest build() {
            return new AtlanTagRequest(this);
        }
    }
}

