/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.APISpec;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAPI;
import com.atlan.model.assets.IAPIPath;
import com.atlan.model.assets.IAPISpec;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIPath
extends Asset
implements IAPIPath,
IAPI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(APIPath.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "APIPath";
    String typeName;
    @Attribute
    Map<String, String> apiExternalDocs;
    @Attribute
    Boolean apiIsAuthOptional;
    @Attribute
    Boolean apiIsObjectReference;
    @Attribute
    String apiObjectQualifiedName;
    @Attribute
    SortedSet<String> apiPathAvailableOperations;
    @Attribute
    Map<String, String> apiPathAvailableResponseCodes;
    @Attribute
    Boolean apiPathIsIngressExposed;
    @Attribute
    Boolean apiPathIsTemplated;
    @Attribute
    String apiPathRawURI;
    @Attribute
    String apiPathSummary;
    @Attribute
    IAPISpec apiSpec;
    @Attribute
    String apiSpecName;
    @Attribute
    String apiSpecQualifiedName;
    @Attribute
    String apiSpecType;
    @Attribute
    String apiSpecVersion;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public APIPath trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return APIPath.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return APIPath.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return APIPath.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return APIPath.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static APIPath refByGuid(String guid) {
        return APIPath.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static APIPath refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((APIPathBuilder)((APIPathBuilder)APIPath._internal().guid(guid)).semantic(semantic)).build();
    }

    public static APIPath refByQualifiedName(String qualifiedName) {
        return APIPath.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static APIPath refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((APIPathBuilder)((APIPathBuilder)APIPath._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static APIPath get(AtlanClient client, String id) throws AtlanException {
        return APIPath.get(client, id, false);
    }

    @JsonIgnore
    public static APIPath get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof APIPath) {
                return (APIPath)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof APIPath) {
            return (APIPath)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static APIPath get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return APIPath.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static APIPath get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)APIPath.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof APIPath) {
                return (APIPath)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)APIPath.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof APIPath) {
            return (APIPath)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static APIPathBuilder<?, ?> creator(String name, APISpec apiSpec) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", apiSpec.getQualifiedName());
        APIPath.validateRelationship("APISpec", map);
        return APIPath.creator(name, apiSpec.getQualifiedName()).apiSpec(apiSpec.trimToReference());
    }

    public static APIPathBuilder<?, ?> creator(String pathURI, String apiSpecQualifiedName) {
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(apiSpecQualifiedName);
        Object normalizedURI = pathURI.startsWith("/") ? pathURI : "/" + pathURI;
        return (APIPathBuilder)((APIPathBuilder)((Asset.AssetBuilder)((APIPathBuilder)((APIPathBuilder)((APIPathBuilder)((APIPathBuilder)APIPath._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(apiSpecQualifiedName + (String)normalizedURI)).name((String)normalizedURI)).apiPathRawURI((String)normalizedURI)).apiSpec(APISpec.refByQualifiedName(apiSpecQualifiedName))).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.API);
    }

    public static APIPathBuilder<?, ?> updater(String qualifiedName, String name) {
        return (APIPathBuilder)((APIPathBuilder)((APIPathBuilder)APIPath._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public APIPathBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        APIPath.validateRequired(TYPE_NAME, map);
        return APIPath.updater(this.getQualifiedName(), this.getName());
    }

    public static APIPath removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APIPath)Asset.removeDescription(client, APIPath.updater(qualifiedName, name));
    }

    public static APIPath removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APIPath)Asset.removeUserDescription(client, APIPath.updater(qualifiedName, name));
    }

    public static APIPath removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APIPath)Asset.removeOwners(client, APIPath.updater(qualifiedName, name));
    }

    public static APIPath updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (APIPath)Asset.updateCertificate(client, APIPath._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static APIPath removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APIPath)Asset.removeCertificate(client, APIPath.updater(qualifiedName, name));
    }

    public static APIPath updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (APIPath)Asset.updateAnnouncement(client, APIPath._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static APIPath removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APIPath)Asset.removeAnnouncement(client, APIPath.updater(qualifiedName, name));
    }

    public static APIPath replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (APIPath)Asset.replaceTerms(client, APIPath.updater(qualifiedName, name), terms);
    }

    public static APIPath appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (APIPath)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static APIPath removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (APIPath)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static APIPath appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (APIPath)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static APIPath appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (APIPath)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected APIPath(APIPathBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> apiPathAvailableResponseCodes;
        Map<Object, Object> apiExternalDocs;
        this.typeName = b.typeName$set ? b.typeName$value : APIPath.$default$typeName();
        switch (b.apiExternalDocs$key == null ? 0 : b.apiExternalDocs$key.size()) {
            case 0: {
                apiExternalDocs = Collections.emptyMap();
                break;
            }
            case 1: {
                apiExternalDocs = Collections.singletonMap(b.apiExternalDocs$key.get(0), b.apiExternalDocs$value.get(0));
                break;
            }
            default: {
                apiExternalDocs = new LinkedHashMap(b.apiExternalDocs$key.size() < 0x40000000 ? 1 + b.apiExternalDocs$key.size() + (b.apiExternalDocs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.apiExternalDocs$key.size(); ++$i) {
                    apiExternalDocs.put(b.apiExternalDocs$key.get($i), b.apiExternalDocs$value.get($i));
                }
                apiExternalDocs = Collections.unmodifiableMap(apiExternalDocs);
            }
        }
        this.apiExternalDocs = apiExternalDocs;
        this.apiIsAuthOptional = b.apiIsAuthOptional;
        this.apiIsObjectReference = b.apiIsObjectReference;
        this.apiObjectQualifiedName = b.apiObjectQualifiedName;
        SortedSet<String> apiPathAvailableOperations = new TreeSet<String>();
        if (b.apiPathAvailableOperations != null) {
            apiPathAvailableOperations.addAll(b.apiPathAvailableOperations);
        }
        apiPathAvailableOperations = Collections.unmodifiableSortedSet(apiPathAvailableOperations);
        this.apiPathAvailableOperations = apiPathAvailableOperations;
        switch (b.apiPathAvailableResponseCodes$key == null ? 0 : b.apiPathAvailableResponseCodes$key.size()) {
            case 0: {
                apiPathAvailableResponseCodes = Collections.emptyMap();
                break;
            }
            case 1: {
                apiPathAvailableResponseCodes = Collections.singletonMap(b.apiPathAvailableResponseCodes$key.get(0), b.apiPathAvailableResponseCodes$value.get(0));
                break;
            }
            default: {
                apiPathAvailableResponseCodes = new LinkedHashMap(b.apiPathAvailableResponseCodes$key.size() < 0x40000000 ? 1 + b.apiPathAvailableResponseCodes$key.size() + (b.apiPathAvailableResponseCodes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.apiPathAvailableResponseCodes$key.size(); ++$i) {
                    apiPathAvailableResponseCodes.put(b.apiPathAvailableResponseCodes$key.get($i), b.apiPathAvailableResponseCodes$value.get($i));
                }
                apiPathAvailableResponseCodes = Collections.unmodifiableMap(apiPathAvailableResponseCodes);
            }
        }
        this.apiPathAvailableResponseCodes = apiPathAvailableResponseCodes;
        this.apiPathIsIngressExposed = b.apiPathIsIngressExposed;
        this.apiPathIsTemplated = b.apiPathIsTemplated;
        this.apiPathRawURI = b.apiPathRawURI;
        this.apiPathSummary = b.apiPathSummary;
        this.apiSpec = b.apiSpec;
        this.apiSpecName = b.apiSpecName;
        this.apiSpecQualifiedName = b.apiSpecQualifiedName;
        this.apiSpecType = b.apiSpecType;
        this.apiSpecVersion = b.apiSpecVersion;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static APIPathBuilder<?, ?> _internal() {
        return new APIPathBuilderImpl();
    }

    @Generated
    public APIPathBuilder<?, ?> toBuilder() {
        return new APIPathBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Map<String, String> getApiExternalDocs() {
        return this.apiExternalDocs;
    }

    @Override
    @Generated
    public Boolean getApiIsAuthOptional() {
        return this.apiIsAuthOptional;
    }

    @Override
    @Generated
    public Boolean getApiIsObjectReference() {
        return this.apiIsObjectReference;
    }

    @Override
    @Generated
    public String getApiObjectQualifiedName() {
        return this.apiObjectQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<String> getApiPathAvailableOperations() {
        return this.apiPathAvailableOperations;
    }

    @Override
    @Generated
    public Map<String, String> getApiPathAvailableResponseCodes() {
        return this.apiPathAvailableResponseCodes;
    }

    @Override
    @Generated
    public Boolean getApiPathIsIngressExposed() {
        return this.apiPathIsIngressExposed;
    }

    @Override
    @Generated
    public Boolean getApiPathIsTemplated() {
        return this.apiPathIsTemplated;
    }

    @Override
    @Generated
    public String getApiPathRawURI() {
        return this.apiPathRawURI;
    }

    @Override
    @Generated
    public String getApiPathSummary() {
        return this.apiPathSummary;
    }

    @Override
    @Generated
    public IAPISpec getApiSpec() {
        return this.apiSpec;
    }

    @Override
    @Generated
    public String getApiSpecName() {
        return this.apiSpecName;
    }

    @Override
    @Generated
    public String getApiSpecQualifiedName() {
        return this.apiSpecQualifiedName;
    }

    @Override
    @Generated
    public String getApiSpecType() {
        return this.apiSpecType;
    }

    @Override
    @Generated
    public String getApiSpecVersion() {
        return this.apiSpecVersion;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APIPath)) {
            return false;
        }
        APIPath other = (APIPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$apiIsAuthOptional = this.getApiIsAuthOptional();
        Boolean other$apiIsAuthOptional = other.getApiIsAuthOptional();
        if (this$apiIsAuthOptional == null ? other$apiIsAuthOptional != null : !((Object)this$apiIsAuthOptional).equals(other$apiIsAuthOptional)) {
            return false;
        }
        Boolean this$apiIsObjectReference = this.getApiIsObjectReference();
        Boolean other$apiIsObjectReference = other.getApiIsObjectReference();
        if (this$apiIsObjectReference == null ? other$apiIsObjectReference != null : !((Object)this$apiIsObjectReference).equals(other$apiIsObjectReference)) {
            return false;
        }
        Boolean this$apiPathIsIngressExposed = this.getApiPathIsIngressExposed();
        Boolean other$apiPathIsIngressExposed = other.getApiPathIsIngressExposed();
        if (this$apiPathIsIngressExposed == null ? other$apiPathIsIngressExposed != null : !((Object)this$apiPathIsIngressExposed).equals(other$apiPathIsIngressExposed)) {
            return false;
        }
        Boolean this$apiPathIsTemplated = this.getApiPathIsTemplated();
        Boolean other$apiPathIsTemplated = other.getApiPathIsTemplated();
        if (this$apiPathIsTemplated == null ? other$apiPathIsTemplated != null : !((Object)this$apiPathIsTemplated).equals(other$apiPathIsTemplated)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        Map<String, String> this$apiExternalDocs = this.getApiExternalDocs();
        Map<String, String> other$apiExternalDocs = other.getApiExternalDocs();
        if (this$apiExternalDocs == null ? other$apiExternalDocs != null : !((Object)this$apiExternalDocs).equals(other$apiExternalDocs)) {
            return false;
        }
        String this$apiObjectQualifiedName = this.getApiObjectQualifiedName();
        String other$apiObjectQualifiedName = other.getApiObjectQualifiedName();
        if (this$apiObjectQualifiedName == null ? other$apiObjectQualifiedName != null : !this$apiObjectQualifiedName.equals(other$apiObjectQualifiedName)) {
            return false;
        }
        SortedSet<String> this$apiPathAvailableOperations = this.getApiPathAvailableOperations();
        SortedSet<String> other$apiPathAvailableOperations = other.getApiPathAvailableOperations();
        if (this$apiPathAvailableOperations == null ? other$apiPathAvailableOperations != null : !this$apiPathAvailableOperations.equals(other$apiPathAvailableOperations)) {
            return false;
        }
        Map<String, String> this$apiPathAvailableResponseCodes = this.getApiPathAvailableResponseCodes();
        Map<String, String> other$apiPathAvailableResponseCodes = other.getApiPathAvailableResponseCodes();
        if (this$apiPathAvailableResponseCodes == null ? other$apiPathAvailableResponseCodes != null : !((Object)this$apiPathAvailableResponseCodes).equals(other$apiPathAvailableResponseCodes)) {
            return false;
        }
        String this$apiPathRawURI = this.getApiPathRawURI();
        String other$apiPathRawURI = other.getApiPathRawURI();
        if (this$apiPathRawURI == null ? other$apiPathRawURI != null : !this$apiPathRawURI.equals(other$apiPathRawURI)) {
            return false;
        }
        String this$apiPathSummary = this.getApiPathSummary();
        String other$apiPathSummary = other.getApiPathSummary();
        if (this$apiPathSummary == null ? other$apiPathSummary != null : !this$apiPathSummary.equals(other$apiPathSummary)) {
            return false;
        }
        IAPISpec this$apiSpec = this.getApiSpec();
        IAPISpec other$apiSpec = other.getApiSpec();
        if (this$apiSpec == null ? other$apiSpec != null : !this$apiSpec.equals(other$apiSpec)) {
            return false;
        }
        String this$apiSpecName = this.getApiSpecName();
        String other$apiSpecName = other.getApiSpecName();
        if (this$apiSpecName == null ? other$apiSpecName != null : !this$apiSpecName.equals(other$apiSpecName)) {
            return false;
        }
        String this$apiSpecQualifiedName = this.getApiSpecQualifiedName();
        String other$apiSpecQualifiedName = other.getApiSpecQualifiedName();
        if (this$apiSpecQualifiedName == null ? other$apiSpecQualifiedName != null : !this$apiSpecQualifiedName.equals(other$apiSpecQualifiedName)) {
            return false;
        }
        String this$apiSpecType = this.getApiSpecType();
        String other$apiSpecType = other.getApiSpecType();
        if (this$apiSpecType == null ? other$apiSpecType != null : !this$apiSpecType.equals(other$apiSpecType)) {
            return false;
        }
        String this$apiSpecVersion = this.getApiSpecVersion();
        String other$apiSpecVersion = other.getApiSpecVersion();
        if (this$apiSpecVersion == null ? other$apiSpecVersion != null : !this$apiSpecVersion.equals(other$apiSpecVersion)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof APIPath;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $apiIsAuthOptional = this.getApiIsAuthOptional();
        result = result * 59 + ($apiIsAuthOptional == null ? 43 : ((Object)$apiIsAuthOptional).hashCode());
        Boolean $apiIsObjectReference = this.getApiIsObjectReference();
        result = result * 59 + ($apiIsObjectReference == null ? 43 : ((Object)$apiIsObjectReference).hashCode());
        Boolean $apiPathIsIngressExposed = this.getApiPathIsIngressExposed();
        result = result * 59 + ($apiPathIsIngressExposed == null ? 43 : ((Object)$apiPathIsIngressExposed).hashCode());
        Boolean $apiPathIsTemplated = this.getApiPathIsTemplated();
        result = result * 59 + ($apiPathIsTemplated == null ? 43 : ((Object)$apiPathIsTemplated).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        Map<String, String> $apiExternalDocs = this.getApiExternalDocs();
        result = result * 59 + ($apiExternalDocs == null ? 43 : ((Object)$apiExternalDocs).hashCode());
        String $apiObjectQualifiedName = this.getApiObjectQualifiedName();
        result = result * 59 + ($apiObjectQualifiedName == null ? 43 : $apiObjectQualifiedName.hashCode());
        SortedSet<String> $apiPathAvailableOperations = this.getApiPathAvailableOperations();
        result = result * 59 + ($apiPathAvailableOperations == null ? 43 : $apiPathAvailableOperations.hashCode());
        Map<String, String> $apiPathAvailableResponseCodes = this.getApiPathAvailableResponseCodes();
        result = result * 59 + ($apiPathAvailableResponseCodes == null ? 43 : ((Object)$apiPathAvailableResponseCodes).hashCode());
        String $apiPathRawURI = this.getApiPathRawURI();
        result = result * 59 + ($apiPathRawURI == null ? 43 : $apiPathRawURI.hashCode());
        String $apiPathSummary = this.getApiPathSummary();
        result = result * 59 + ($apiPathSummary == null ? 43 : $apiPathSummary.hashCode());
        IAPISpec $apiSpec = this.getApiSpec();
        result = result * 59 + ($apiSpec == null ? 43 : $apiSpec.hashCode());
        String $apiSpecName = this.getApiSpecName();
        result = result * 59 + ($apiSpecName == null ? 43 : $apiSpecName.hashCode());
        String $apiSpecQualifiedName = this.getApiSpecQualifiedName();
        result = result * 59 + ($apiSpecQualifiedName == null ? 43 : $apiSpecQualifiedName.hashCode());
        String $apiSpecType = this.getApiSpecType();
        result = result * 59 + ($apiSpecType == null ? 43 : $apiSpecType.hashCode());
        String $apiSpecVersion = this.getApiSpecVersion();
        result = result * 59 + ($apiSpecVersion == null ? 43 : $apiSpecVersion.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "APIPath(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", apiExternalDocs=" + String.valueOf(this.getApiExternalDocs()) + ", apiIsAuthOptional=" + this.getApiIsAuthOptional() + ", apiIsObjectReference=" + this.getApiIsObjectReference() + ", apiObjectQualifiedName=" + this.getApiObjectQualifiedName() + ", apiPathAvailableOperations=" + String.valueOf(this.getApiPathAvailableOperations()) + ", apiPathAvailableResponseCodes=" + String.valueOf(this.getApiPathAvailableResponseCodes()) + ", apiPathIsIngressExposed=" + this.getApiPathIsIngressExposed() + ", apiPathIsTemplated=" + this.getApiPathIsTemplated() + ", apiPathRawURI=" + this.getApiPathRawURI() + ", apiPathSummary=" + this.getApiPathSummary() + ", apiSpec=" + String.valueOf(this.getApiSpec()) + ", apiSpecName=" + this.getApiSpecName() + ", apiSpecQualifiedName=" + this.getApiSpecQualifiedName() + ", apiSpecType=" + this.getApiSpecType() + ", apiSpecVersion=" + this.getApiSpecVersion() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class APIPathBuilder<C extends APIPath, B extends APIPathBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<String> apiExternalDocs$key;
        @Generated
        private ArrayList<String> apiExternalDocs$value;
        @Generated
        private Boolean apiIsAuthOptional;
        @Generated
        private Boolean apiIsObjectReference;
        @Generated
        private String apiObjectQualifiedName;
        @Generated
        private ArrayList<String> apiPathAvailableOperations;
        @Generated
        private ArrayList<String> apiPathAvailableResponseCodes$key;
        @Generated
        private ArrayList<String> apiPathAvailableResponseCodes$value;
        @Generated
        private Boolean apiPathIsIngressExposed;
        @Generated
        private Boolean apiPathIsTemplated;
        @Generated
        private String apiPathRawURI;
        @Generated
        private String apiPathSummary;
        @Generated
        private IAPISpec apiSpec;
        @Generated
        private String apiSpecName;
        @Generated
        private String apiSpecQualifiedName;
        @Generated
        private String apiSpecType;
        @Generated
        private String apiSpecVersion;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            APIPathBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(APIPath instance, APIPathBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.apiExternalDocs(instance.apiExternalDocs == null ? Collections.emptyMap() : instance.apiExternalDocs);
            b.apiIsAuthOptional(instance.apiIsAuthOptional);
            b.apiIsObjectReference(instance.apiIsObjectReference);
            b.apiObjectQualifiedName(instance.apiObjectQualifiedName);
            b.apiPathAvailableOperations(instance.apiPathAvailableOperations == null ? Collections.emptySortedSet() : instance.apiPathAvailableOperations);
            b.apiPathAvailableResponseCodes(instance.apiPathAvailableResponseCodes == null ? Collections.emptyMap() : instance.apiPathAvailableResponseCodes);
            b.apiPathIsIngressExposed(instance.apiPathIsIngressExposed);
            b.apiPathIsTemplated(instance.apiPathIsTemplated);
            b.apiPathRawURI(instance.apiPathRawURI);
            b.apiPathSummary(instance.apiPathSummary);
            b.apiSpec(instance.apiSpec);
            b.apiSpecName(instance.apiSpecName);
            b.apiSpecQualifiedName(instance.apiSpecQualifiedName);
            b.apiSpecType(instance.apiSpecType);
            b.apiSpecVersion(instance.apiSpecVersion);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B apiExternalDoc(String apiExternalDocKey, String apiExternalDocValue) {
            if (this.apiExternalDocs$key == null) {
                this.apiExternalDocs$key = new ArrayList();
                this.apiExternalDocs$value = new ArrayList();
            }
            this.apiExternalDocs$key.add(apiExternalDocKey);
            this.apiExternalDocs$value.add(apiExternalDocValue);
            return (B)this.self();
        }

        @Generated
        public B apiExternalDocs(Map<? extends String, ? extends String> apiExternalDocs) {
            if (apiExternalDocs == null) {
                throw new NullPointerException("apiExternalDocs cannot be null");
            }
            if (this.apiExternalDocs$key == null) {
                this.apiExternalDocs$key = new ArrayList();
                this.apiExternalDocs$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : apiExternalDocs.entrySet()) {
                this.apiExternalDocs$key.add($lombokEntry.getKey());
                this.apiExternalDocs$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearApiExternalDocs() {
            if (this.apiExternalDocs$key != null) {
                this.apiExternalDocs$key.clear();
                this.apiExternalDocs$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B apiIsAuthOptional(Boolean apiIsAuthOptional) {
            this.apiIsAuthOptional = apiIsAuthOptional;
            return (B)this.self();
        }

        @Generated
        public B apiIsObjectReference(Boolean apiIsObjectReference) {
            this.apiIsObjectReference = apiIsObjectReference;
            return (B)this.self();
        }

        @Generated
        public B apiObjectQualifiedName(String apiObjectQualifiedName) {
            this.apiObjectQualifiedName = apiObjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B apiPathAvailableOperation(String apiPathAvailableOperation) {
            if (this.apiPathAvailableOperations == null) {
                this.apiPathAvailableOperations = new ArrayList();
            }
            this.apiPathAvailableOperations.add(apiPathAvailableOperation);
            return (B)this.self();
        }

        @Generated
        public B apiPathAvailableOperations(Collection<? extends String> apiPathAvailableOperations) {
            if (apiPathAvailableOperations == null) {
                throw new NullPointerException("apiPathAvailableOperations cannot be null");
            }
            if (this.apiPathAvailableOperations == null) {
                this.apiPathAvailableOperations = new ArrayList();
            }
            this.apiPathAvailableOperations.addAll(apiPathAvailableOperations);
            return (B)this.self();
        }

        @Generated
        public B clearApiPathAvailableOperations() {
            if (this.apiPathAvailableOperations != null) {
                this.apiPathAvailableOperations.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B apiPathAvailableResponseCode(String apiPathAvailableResponseCodeKey, String apiPathAvailableResponseCodeValue) {
            if (this.apiPathAvailableResponseCodes$key == null) {
                this.apiPathAvailableResponseCodes$key = new ArrayList();
                this.apiPathAvailableResponseCodes$value = new ArrayList();
            }
            this.apiPathAvailableResponseCodes$key.add(apiPathAvailableResponseCodeKey);
            this.apiPathAvailableResponseCodes$value.add(apiPathAvailableResponseCodeValue);
            return (B)this.self();
        }

        @Generated
        public B apiPathAvailableResponseCodes(Map<? extends String, ? extends String> apiPathAvailableResponseCodes) {
            if (apiPathAvailableResponseCodes == null) {
                throw new NullPointerException("apiPathAvailableResponseCodes cannot be null");
            }
            if (this.apiPathAvailableResponseCodes$key == null) {
                this.apiPathAvailableResponseCodes$key = new ArrayList();
                this.apiPathAvailableResponseCodes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : apiPathAvailableResponseCodes.entrySet()) {
                this.apiPathAvailableResponseCodes$key.add($lombokEntry.getKey());
                this.apiPathAvailableResponseCodes$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearApiPathAvailableResponseCodes() {
            if (this.apiPathAvailableResponseCodes$key != null) {
                this.apiPathAvailableResponseCodes$key.clear();
                this.apiPathAvailableResponseCodes$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B apiPathIsIngressExposed(Boolean apiPathIsIngressExposed) {
            this.apiPathIsIngressExposed = apiPathIsIngressExposed;
            return (B)this.self();
        }

        @Generated
        public B apiPathIsTemplated(Boolean apiPathIsTemplated) {
            this.apiPathIsTemplated = apiPathIsTemplated;
            return (B)this.self();
        }

        @Generated
        public B apiPathRawURI(String apiPathRawURI) {
            this.apiPathRawURI = apiPathRawURI;
            return (B)this.self();
        }

        @Generated
        public B apiPathSummary(String apiPathSummary) {
            this.apiPathSummary = apiPathSummary;
            return (B)this.self();
        }

        @Generated
        public B apiSpec(IAPISpec apiSpec) {
            this.apiSpec = apiSpec;
            return (B)this.self();
        }

        @Generated
        public B apiSpecName(String apiSpecName) {
            this.apiSpecName = apiSpecName;
            return (B)this.self();
        }

        @Generated
        public B apiSpecQualifiedName(String apiSpecQualifiedName) {
            this.apiSpecQualifiedName = apiSpecQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B apiSpecType(String apiSpecType) {
            this.apiSpecType = apiSpecType;
            return (B)this.self();
        }

        @Generated
        public B apiSpecVersion(String apiSpecVersion) {
            this.apiSpecVersion = apiSpecVersion;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "APIPath.APIPathBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", apiExternalDocs$key=" + String.valueOf(this.apiExternalDocs$key) + ", apiExternalDocs$value=" + String.valueOf(this.apiExternalDocs$value) + ", apiIsAuthOptional=" + this.apiIsAuthOptional + ", apiIsObjectReference=" + this.apiIsObjectReference + ", apiObjectQualifiedName=" + this.apiObjectQualifiedName + ", apiPathAvailableOperations=" + String.valueOf(this.apiPathAvailableOperations) + ", apiPathAvailableResponseCodes$key=" + String.valueOf(this.apiPathAvailableResponseCodes$key) + ", apiPathAvailableResponseCodes$value=" + String.valueOf(this.apiPathAvailableResponseCodes$value) + ", apiPathIsIngressExposed=" + this.apiPathIsIngressExposed + ", apiPathIsTemplated=" + this.apiPathIsTemplated + ", apiPathRawURI=" + this.apiPathRawURI + ", apiPathSummary=" + this.apiPathSummary + ", apiSpec=" + String.valueOf(this.apiSpec) + ", apiSpecName=" + this.apiSpecName + ", apiSpecQualifiedName=" + this.apiSpecQualifiedName + ", apiSpecType=" + this.apiSpecType + ", apiSpecVersion=" + this.apiSpecVersion + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class APIPathBuilderImpl
    extends APIPathBuilder<APIPath, APIPathBuilderImpl> {
        @Generated
        private APIPathBuilderImpl() {
        }

        @Override
        @Generated
        protected APIPathBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public APIPath build() {
            return new APIPath(this);
        }
    }
}

