/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IADF;
import com.atlan.model.assets.IAdfActivity;
import com.atlan.model.assets.IAdfDataflow;
import com.atlan.model.assets.IAdfDataset;
import com.atlan.model.assets.IAdfLinkedservice;
import com.atlan.model.assets.IAdfPipeline;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdfDataset
extends Asset
implements IAdfDataset,
IADF,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdfDataset.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AdfDataset";
    String typeName;
    @Attribute
    SortedSet<IAdfActivity> adfActivities;
    @Attribute
    String adfAssetFolderPath;
    @Attribute
    SortedSet<IAdfDataflow> adfDataflows;
    @Attribute
    SortedSet<String> adfDatasetAnnotations;
    @Attribute
    String adfDatasetCollectionName;
    @Attribute
    String adfDatasetContainerName;
    @Attribute
    String adfDatasetDatabaseName;
    @Attribute
    String adfDatasetFileFolderPath;
    @Attribute
    String adfDatasetFileName;
    @Attribute
    String adfDatasetLinkedService;
    @Attribute
    String adfDatasetSchemaName;
    @Attribute
    String adfDatasetStorageType;
    @Attribute
    String adfDatasetTableName;
    @Attribute
    String adfDatasetType;
    @Attribute
    String adfFactoryName;
    @Attribute
    IAdfLinkedservice adfLinkedservice;
    @Attribute
    SortedSet<IAdfPipeline> adfPipelines;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public AdfDataset trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return AdfDataset.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return AdfDataset.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return AdfDataset.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return AdfDataset.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static AdfDataset refByGuid(String guid) {
        return AdfDataset.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static AdfDataset refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((AdfDatasetBuilder)((AdfDatasetBuilder)AdfDataset._internal().guid(guid)).semantic(semantic)).build();
    }

    public static AdfDataset refByQualifiedName(String qualifiedName) {
        return AdfDataset.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static AdfDataset refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((AdfDatasetBuilder)((AdfDatasetBuilder)AdfDataset._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static AdfDataset get(AtlanClient client, String id) throws AtlanException {
        return AdfDataset.get(client, id, false);
    }

    @JsonIgnore
    public static AdfDataset get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof AdfDataset) {
                return (AdfDataset)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof AdfDataset) {
            return (AdfDataset)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static AdfDataset get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return AdfDataset.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static AdfDataset get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AdfDataset.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof AdfDataset) {
                return (AdfDataset)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AdfDataset.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof AdfDataset) {
            return (AdfDataset)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static AdfDatasetBuilder<?, ?> updater(String qualifiedName, String name) {
        return (AdfDatasetBuilder)((AdfDatasetBuilder)((AdfDatasetBuilder)AdfDataset._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public AdfDatasetBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        AdfDataset.validateRequired(TYPE_NAME, map);
        return AdfDataset.updater(this.getQualifiedName(), this.getName());
    }

    public static AdfDataset removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfDataset)Asset.removeDescription(client, AdfDataset.updater(qualifiedName, name));
    }

    public static AdfDataset removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfDataset)Asset.removeUserDescription(client, AdfDataset.updater(qualifiedName, name));
    }

    public static AdfDataset removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfDataset)Asset.removeOwners(client, AdfDataset.updater(qualifiedName, name));
    }

    public static AdfDataset updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AdfDataset)Asset.updateCertificate(client, AdfDataset._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static AdfDataset removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfDataset)Asset.removeCertificate(client, AdfDataset.updater(qualifiedName, name));
    }

    public static AdfDataset updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AdfDataset)Asset.updateAnnouncement(client, AdfDataset._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static AdfDataset removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfDataset)Asset.removeAnnouncement(client, AdfDataset.updater(qualifiedName, name));
    }

    public static AdfDataset replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AdfDataset)Asset.replaceTerms(client, AdfDataset.updater(qualifiedName, name), terms);
    }

    public static AdfDataset appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AdfDataset)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static AdfDataset removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AdfDataset)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static AdfDataset appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AdfDataset)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static AdfDataset appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AdfDataset)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AdfDataset(AdfDatasetBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : AdfDataset.$default$typeName();
        SortedSet<IAdfActivity> adfActivities = new TreeSet<IAdfActivity>();
        if (b.adfActivities != null) {
            adfActivities.addAll(b.adfActivities);
        }
        adfActivities = Collections.unmodifiableSortedSet(adfActivities);
        this.adfActivities = adfActivities;
        this.adfAssetFolderPath = b.adfAssetFolderPath;
        SortedSet<IAdfDataflow> adfDataflows = new TreeSet<IAdfDataflow>();
        if (b.adfDataflows != null) {
            adfDataflows.addAll(b.adfDataflows);
        }
        adfDataflows = Collections.unmodifiableSortedSet(adfDataflows);
        this.adfDataflows = adfDataflows;
        SortedSet<String> adfDatasetAnnotations = new TreeSet<String>();
        if (b.adfDatasetAnnotations != null) {
            adfDatasetAnnotations.addAll(b.adfDatasetAnnotations);
        }
        adfDatasetAnnotations = Collections.unmodifiableSortedSet(adfDatasetAnnotations);
        this.adfDatasetAnnotations = adfDatasetAnnotations;
        this.adfDatasetCollectionName = b.adfDatasetCollectionName;
        this.adfDatasetContainerName = b.adfDatasetContainerName;
        this.adfDatasetDatabaseName = b.adfDatasetDatabaseName;
        this.adfDatasetFileFolderPath = b.adfDatasetFileFolderPath;
        this.adfDatasetFileName = b.adfDatasetFileName;
        this.adfDatasetLinkedService = b.adfDatasetLinkedService;
        this.adfDatasetSchemaName = b.adfDatasetSchemaName;
        this.adfDatasetStorageType = b.adfDatasetStorageType;
        this.adfDatasetTableName = b.adfDatasetTableName;
        this.adfDatasetType = b.adfDatasetType;
        this.adfFactoryName = b.adfFactoryName;
        this.adfLinkedservice = b.adfLinkedservice;
        SortedSet<IAdfPipeline> adfPipelines = new TreeSet<IAdfPipeline>();
        if (b.adfPipelines != null) {
            adfPipelines.addAll(b.adfPipelines);
        }
        adfPipelines = Collections.unmodifiableSortedSet(adfPipelines);
        this.adfPipelines = adfPipelines;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static AdfDatasetBuilder<?, ?> _internal() {
        return new AdfDatasetBuilderImpl();
    }

    @Generated
    public AdfDatasetBuilder<?, ?> toBuilder() {
        return new AdfDatasetBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAdfActivity> getAdfActivities() {
        return this.adfActivities;
    }

    @Override
    @Generated
    public String getAdfAssetFolderPath() {
        return this.adfAssetFolderPath;
    }

    @Override
    @Generated
    public SortedSet<IAdfDataflow> getAdfDataflows() {
        return this.adfDataflows;
    }

    @Override
    @Generated
    public SortedSet<String> getAdfDatasetAnnotations() {
        return this.adfDatasetAnnotations;
    }

    @Override
    @Generated
    public String getAdfDatasetCollectionName() {
        return this.adfDatasetCollectionName;
    }

    @Override
    @Generated
    public String getAdfDatasetContainerName() {
        return this.adfDatasetContainerName;
    }

    @Override
    @Generated
    public String getAdfDatasetDatabaseName() {
        return this.adfDatasetDatabaseName;
    }

    @Override
    @Generated
    public String getAdfDatasetFileFolderPath() {
        return this.adfDatasetFileFolderPath;
    }

    @Override
    @Generated
    public String getAdfDatasetFileName() {
        return this.adfDatasetFileName;
    }

    @Override
    @Generated
    public String getAdfDatasetLinkedService() {
        return this.adfDatasetLinkedService;
    }

    @Override
    @Generated
    public String getAdfDatasetSchemaName() {
        return this.adfDatasetSchemaName;
    }

    @Override
    @Generated
    public String getAdfDatasetStorageType() {
        return this.adfDatasetStorageType;
    }

    @Override
    @Generated
    public String getAdfDatasetTableName() {
        return this.adfDatasetTableName;
    }

    @Override
    @Generated
    public String getAdfDatasetType() {
        return this.adfDatasetType;
    }

    @Override
    @Generated
    public String getAdfFactoryName() {
        return this.adfFactoryName;
    }

    @Override
    @Generated
    public IAdfLinkedservice getAdfLinkedservice() {
        return this.adfLinkedservice;
    }

    @Override
    @Generated
    public SortedSet<IAdfPipeline> getAdfPipelines() {
        return this.adfPipelines;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdfDataset)) {
            return false;
        }
        AdfDataset other = (AdfDataset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAdfActivity> this$adfActivities = this.getAdfActivities();
        SortedSet<IAdfActivity> other$adfActivities = other.getAdfActivities();
        if (this$adfActivities == null ? other$adfActivities != null : !this$adfActivities.equals(other$adfActivities)) {
            return false;
        }
        String this$adfAssetFolderPath = this.getAdfAssetFolderPath();
        String other$adfAssetFolderPath = other.getAdfAssetFolderPath();
        if (this$adfAssetFolderPath == null ? other$adfAssetFolderPath != null : !this$adfAssetFolderPath.equals(other$adfAssetFolderPath)) {
            return false;
        }
        SortedSet<IAdfDataflow> this$adfDataflows = this.getAdfDataflows();
        SortedSet<IAdfDataflow> other$adfDataflows = other.getAdfDataflows();
        if (this$adfDataflows == null ? other$adfDataflows != null : !this$adfDataflows.equals(other$adfDataflows)) {
            return false;
        }
        SortedSet<String> this$adfDatasetAnnotations = this.getAdfDatasetAnnotations();
        SortedSet<String> other$adfDatasetAnnotations = other.getAdfDatasetAnnotations();
        if (this$adfDatasetAnnotations == null ? other$adfDatasetAnnotations != null : !this$adfDatasetAnnotations.equals(other$adfDatasetAnnotations)) {
            return false;
        }
        String this$adfDatasetCollectionName = this.getAdfDatasetCollectionName();
        String other$adfDatasetCollectionName = other.getAdfDatasetCollectionName();
        if (this$adfDatasetCollectionName == null ? other$adfDatasetCollectionName != null : !this$adfDatasetCollectionName.equals(other$adfDatasetCollectionName)) {
            return false;
        }
        String this$adfDatasetContainerName = this.getAdfDatasetContainerName();
        String other$adfDatasetContainerName = other.getAdfDatasetContainerName();
        if (this$adfDatasetContainerName == null ? other$adfDatasetContainerName != null : !this$adfDatasetContainerName.equals(other$adfDatasetContainerName)) {
            return false;
        }
        String this$adfDatasetDatabaseName = this.getAdfDatasetDatabaseName();
        String other$adfDatasetDatabaseName = other.getAdfDatasetDatabaseName();
        if (this$adfDatasetDatabaseName == null ? other$adfDatasetDatabaseName != null : !this$adfDatasetDatabaseName.equals(other$adfDatasetDatabaseName)) {
            return false;
        }
        String this$adfDatasetFileFolderPath = this.getAdfDatasetFileFolderPath();
        String other$adfDatasetFileFolderPath = other.getAdfDatasetFileFolderPath();
        if (this$adfDatasetFileFolderPath == null ? other$adfDatasetFileFolderPath != null : !this$adfDatasetFileFolderPath.equals(other$adfDatasetFileFolderPath)) {
            return false;
        }
        String this$adfDatasetFileName = this.getAdfDatasetFileName();
        String other$adfDatasetFileName = other.getAdfDatasetFileName();
        if (this$adfDatasetFileName == null ? other$adfDatasetFileName != null : !this$adfDatasetFileName.equals(other$adfDatasetFileName)) {
            return false;
        }
        String this$adfDatasetLinkedService = this.getAdfDatasetLinkedService();
        String other$adfDatasetLinkedService = other.getAdfDatasetLinkedService();
        if (this$adfDatasetLinkedService == null ? other$adfDatasetLinkedService != null : !this$adfDatasetLinkedService.equals(other$adfDatasetLinkedService)) {
            return false;
        }
        String this$adfDatasetSchemaName = this.getAdfDatasetSchemaName();
        String other$adfDatasetSchemaName = other.getAdfDatasetSchemaName();
        if (this$adfDatasetSchemaName == null ? other$adfDatasetSchemaName != null : !this$adfDatasetSchemaName.equals(other$adfDatasetSchemaName)) {
            return false;
        }
        String this$adfDatasetStorageType = this.getAdfDatasetStorageType();
        String other$adfDatasetStorageType = other.getAdfDatasetStorageType();
        if (this$adfDatasetStorageType == null ? other$adfDatasetStorageType != null : !this$adfDatasetStorageType.equals(other$adfDatasetStorageType)) {
            return false;
        }
        String this$adfDatasetTableName = this.getAdfDatasetTableName();
        String other$adfDatasetTableName = other.getAdfDatasetTableName();
        if (this$adfDatasetTableName == null ? other$adfDatasetTableName != null : !this$adfDatasetTableName.equals(other$adfDatasetTableName)) {
            return false;
        }
        String this$adfDatasetType = this.getAdfDatasetType();
        String other$adfDatasetType = other.getAdfDatasetType();
        if (this$adfDatasetType == null ? other$adfDatasetType != null : !this$adfDatasetType.equals(other$adfDatasetType)) {
            return false;
        }
        String this$adfFactoryName = this.getAdfFactoryName();
        String other$adfFactoryName = other.getAdfFactoryName();
        if (this$adfFactoryName == null ? other$adfFactoryName != null : !this$adfFactoryName.equals(other$adfFactoryName)) {
            return false;
        }
        IAdfLinkedservice this$adfLinkedservice = this.getAdfLinkedservice();
        IAdfLinkedservice other$adfLinkedservice = other.getAdfLinkedservice();
        if (this$adfLinkedservice == null ? other$adfLinkedservice != null : !this$adfLinkedservice.equals(other$adfLinkedservice)) {
            return false;
        }
        SortedSet<IAdfPipeline> this$adfPipelines = this.getAdfPipelines();
        SortedSet<IAdfPipeline> other$adfPipelines = other.getAdfPipelines();
        if (this$adfPipelines == null ? other$adfPipelines != null : !this$adfPipelines.equals(other$adfPipelines)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdfDataset;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAdfActivity> $adfActivities = this.getAdfActivities();
        result = result * 59 + ($adfActivities == null ? 43 : $adfActivities.hashCode());
        String $adfAssetFolderPath = this.getAdfAssetFolderPath();
        result = result * 59 + ($adfAssetFolderPath == null ? 43 : $adfAssetFolderPath.hashCode());
        SortedSet<IAdfDataflow> $adfDataflows = this.getAdfDataflows();
        result = result * 59 + ($adfDataflows == null ? 43 : $adfDataflows.hashCode());
        SortedSet<String> $adfDatasetAnnotations = this.getAdfDatasetAnnotations();
        result = result * 59 + ($adfDatasetAnnotations == null ? 43 : $adfDatasetAnnotations.hashCode());
        String $adfDatasetCollectionName = this.getAdfDatasetCollectionName();
        result = result * 59 + ($adfDatasetCollectionName == null ? 43 : $adfDatasetCollectionName.hashCode());
        String $adfDatasetContainerName = this.getAdfDatasetContainerName();
        result = result * 59 + ($adfDatasetContainerName == null ? 43 : $adfDatasetContainerName.hashCode());
        String $adfDatasetDatabaseName = this.getAdfDatasetDatabaseName();
        result = result * 59 + ($adfDatasetDatabaseName == null ? 43 : $adfDatasetDatabaseName.hashCode());
        String $adfDatasetFileFolderPath = this.getAdfDatasetFileFolderPath();
        result = result * 59 + ($adfDatasetFileFolderPath == null ? 43 : $adfDatasetFileFolderPath.hashCode());
        String $adfDatasetFileName = this.getAdfDatasetFileName();
        result = result * 59 + ($adfDatasetFileName == null ? 43 : $adfDatasetFileName.hashCode());
        String $adfDatasetLinkedService = this.getAdfDatasetLinkedService();
        result = result * 59 + ($adfDatasetLinkedService == null ? 43 : $adfDatasetLinkedService.hashCode());
        String $adfDatasetSchemaName = this.getAdfDatasetSchemaName();
        result = result * 59 + ($adfDatasetSchemaName == null ? 43 : $adfDatasetSchemaName.hashCode());
        String $adfDatasetStorageType = this.getAdfDatasetStorageType();
        result = result * 59 + ($adfDatasetStorageType == null ? 43 : $adfDatasetStorageType.hashCode());
        String $adfDatasetTableName = this.getAdfDatasetTableName();
        result = result * 59 + ($adfDatasetTableName == null ? 43 : $adfDatasetTableName.hashCode());
        String $adfDatasetType = this.getAdfDatasetType();
        result = result * 59 + ($adfDatasetType == null ? 43 : $adfDatasetType.hashCode());
        String $adfFactoryName = this.getAdfFactoryName();
        result = result * 59 + ($adfFactoryName == null ? 43 : $adfFactoryName.hashCode());
        IAdfLinkedservice $adfLinkedservice = this.getAdfLinkedservice();
        result = result * 59 + ($adfLinkedservice == null ? 43 : $adfLinkedservice.hashCode());
        SortedSet<IAdfPipeline> $adfPipelines = this.getAdfPipelines();
        result = result * 59 + ($adfPipelines == null ? 43 : $adfPipelines.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AdfDataset(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", adfActivities=" + String.valueOf(this.getAdfActivities()) + ", adfAssetFolderPath=" + this.getAdfAssetFolderPath() + ", adfDataflows=" + String.valueOf(this.getAdfDataflows()) + ", adfDatasetAnnotations=" + String.valueOf(this.getAdfDatasetAnnotations()) + ", adfDatasetCollectionName=" + this.getAdfDatasetCollectionName() + ", adfDatasetContainerName=" + this.getAdfDatasetContainerName() + ", adfDatasetDatabaseName=" + this.getAdfDatasetDatabaseName() + ", adfDatasetFileFolderPath=" + this.getAdfDatasetFileFolderPath() + ", adfDatasetFileName=" + this.getAdfDatasetFileName() + ", adfDatasetLinkedService=" + this.getAdfDatasetLinkedService() + ", adfDatasetSchemaName=" + this.getAdfDatasetSchemaName() + ", adfDatasetStorageType=" + this.getAdfDatasetStorageType() + ", adfDatasetTableName=" + this.getAdfDatasetTableName() + ", adfDatasetType=" + this.getAdfDatasetType() + ", adfFactoryName=" + this.getAdfFactoryName() + ", adfLinkedservice=" + String.valueOf(this.getAdfLinkedservice()) + ", adfPipelines=" + String.valueOf(this.getAdfPipelines()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class AdfDatasetBuilder<C extends AdfDataset, B extends AdfDatasetBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAdfActivity> adfActivities;
        @Generated
        private String adfAssetFolderPath;
        @Generated
        private ArrayList<IAdfDataflow> adfDataflows;
        @Generated
        private ArrayList<String> adfDatasetAnnotations;
        @Generated
        private String adfDatasetCollectionName;
        @Generated
        private String adfDatasetContainerName;
        @Generated
        private String adfDatasetDatabaseName;
        @Generated
        private String adfDatasetFileFolderPath;
        @Generated
        private String adfDatasetFileName;
        @Generated
        private String adfDatasetLinkedService;
        @Generated
        private String adfDatasetSchemaName;
        @Generated
        private String adfDatasetStorageType;
        @Generated
        private String adfDatasetTableName;
        @Generated
        private String adfDatasetType;
        @Generated
        private String adfFactoryName;
        @Generated
        private IAdfLinkedservice adfLinkedservice;
        @Generated
        private ArrayList<IAdfPipeline> adfPipelines;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AdfDatasetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AdfDataset instance, AdfDatasetBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.adfActivities(instance.adfActivities == null ? Collections.emptySortedSet() : instance.adfActivities);
            b.adfAssetFolderPath(instance.adfAssetFolderPath);
            b.adfDataflows(instance.adfDataflows == null ? Collections.emptySortedSet() : instance.adfDataflows);
            b.adfDatasetAnnotations(instance.adfDatasetAnnotations == null ? Collections.emptySortedSet() : instance.adfDatasetAnnotations);
            b.adfDatasetCollectionName(instance.adfDatasetCollectionName);
            b.adfDatasetContainerName(instance.adfDatasetContainerName);
            b.adfDatasetDatabaseName(instance.adfDatasetDatabaseName);
            b.adfDatasetFileFolderPath(instance.adfDatasetFileFolderPath);
            b.adfDatasetFileName(instance.adfDatasetFileName);
            b.adfDatasetLinkedService(instance.adfDatasetLinkedService);
            b.adfDatasetSchemaName(instance.adfDatasetSchemaName);
            b.adfDatasetStorageType(instance.adfDatasetStorageType);
            b.adfDatasetTableName(instance.adfDatasetTableName);
            b.adfDatasetType(instance.adfDatasetType);
            b.adfFactoryName(instance.adfFactoryName);
            b.adfLinkedservice(instance.adfLinkedservice);
            b.adfPipelines(instance.adfPipelines == null ? Collections.emptySortedSet() : instance.adfPipelines);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B adfActivity(IAdfActivity adfActivity) {
            if (this.adfActivities == null) {
                this.adfActivities = new ArrayList();
            }
            this.adfActivities.add(adfActivity);
            return (B)this.self();
        }

        @Generated
        public B adfActivities(Collection<? extends IAdfActivity> adfActivities) {
            if (adfActivities == null) {
                throw new NullPointerException("adfActivities cannot be null");
            }
            if (this.adfActivities == null) {
                this.adfActivities = new ArrayList();
            }
            this.adfActivities.addAll(adfActivities);
            return (B)this.self();
        }

        @Generated
        public B clearAdfActivities() {
            if (this.adfActivities != null) {
                this.adfActivities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfAssetFolderPath(String adfAssetFolderPath) {
            this.adfAssetFolderPath = adfAssetFolderPath;
            return (B)this.self();
        }

        @Generated
        public B adfDataflow(IAdfDataflow adfDataflow) {
            if (this.adfDataflows == null) {
                this.adfDataflows = new ArrayList();
            }
            this.adfDataflows.add(adfDataflow);
            return (B)this.self();
        }

        @Generated
        public B adfDataflows(Collection<? extends IAdfDataflow> adfDataflows) {
            if (adfDataflows == null) {
                throw new NullPointerException("adfDataflows cannot be null");
            }
            if (this.adfDataflows == null) {
                this.adfDataflows = new ArrayList();
            }
            this.adfDataflows.addAll(adfDataflows);
            return (B)this.self();
        }

        @Generated
        public B clearAdfDataflows() {
            if (this.adfDataflows != null) {
                this.adfDataflows.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfDatasetAnnotation(String adfDatasetAnnotation) {
            if (this.adfDatasetAnnotations == null) {
                this.adfDatasetAnnotations = new ArrayList();
            }
            this.adfDatasetAnnotations.add(adfDatasetAnnotation);
            return (B)this.self();
        }

        @Generated
        public B adfDatasetAnnotations(Collection<? extends String> adfDatasetAnnotations) {
            if (adfDatasetAnnotations == null) {
                throw new NullPointerException("adfDatasetAnnotations cannot be null");
            }
            if (this.adfDatasetAnnotations == null) {
                this.adfDatasetAnnotations = new ArrayList();
            }
            this.adfDatasetAnnotations.addAll(adfDatasetAnnotations);
            return (B)this.self();
        }

        @Generated
        public B clearAdfDatasetAnnotations() {
            if (this.adfDatasetAnnotations != null) {
                this.adfDatasetAnnotations.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfDatasetCollectionName(String adfDatasetCollectionName) {
            this.adfDatasetCollectionName = adfDatasetCollectionName;
            return (B)this.self();
        }

        @Generated
        public B adfDatasetContainerName(String adfDatasetContainerName) {
            this.adfDatasetContainerName = adfDatasetContainerName;
            return (B)this.self();
        }

        @Generated
        public B adfDatasetDatabaseName(String adfDatasetDatabaseName) {
            this.adfDatasetDatabaseName = adfDatasetDatabaseName;
            return (B)this.self();
        }

        @Generated
        public B adfDatasetFileFolderPath(String adfDatasetFileFolderPath) {
            this.adfDatasetFileFolderPath = adfDatasetFileFolderPath;
            return (B)this.self();
        }

        @Generated
        public B adfDatasetFileName(String adfDatasetFileName) {
            this.adfDatasetFileName = adfDatasetFileName;
            return (B)this.self();
        }

        @Generated
        public B adfDatasetLinkedService(String adfDatasetLinkedService) {
            this.adfDatasetLinkedService = adfDatasetLinkedService;
            return (B)this.self();
        }

        @Generated
        public B adfDatasetSchemaName(String adfDatasetSchemaName) {
            this.adfDatasetSchemaName = adfDatasetSchemaName;
            return (B)this.self();
        }

        @Generated
        public B adfDatasetStorageType(String adfDatasetStorageType) {
            this.adfDatasetStorageType = adfDatasetStorageType;
            return (B)this.self();
        }

        @Generated
        public B adfDatasetTableName(String adfDatasetTableName) {
            this.adfDatasetTableName = adfDatasetTableName;
            return (B)this.self();
        }

        @Generated
        public B adfDatasetType(String adfDatasetType) {
            this.adfDatasetType = adfDatasetType;
            return (B)this.self();
        }

        @Generated
        public B adfFactoryName(String adfFactoryName) {
            this.adfFactoryName = adfFactoryName;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedservice(IAdfLinkedservice adfLinkedservice) {
            this.adfLinkedservice = adfLinkedservice;
            return (B)this.self();
        }

        @Generated
        public B adfPipeline(IAdfPipeline adfPipeline) {
            if (this.adfPipelines == null) {
                this.adfPipelines = new ArrayList();
            }
            this.adfPipelines.add(adfPipeline);
            return (B)this.self();
        }

        @Generated
        public B adfPipelines(Collection<? extends IAdfPipeline> adfPipelines) {
            if (adfPipelines == null) {
                throw new NullPointerException("adfPipelines cannot be null");
            }
            if (this.adfPipelines == null) {
                this.adfPipelines = new ArrayList();
            }
            this.adfPipelines.addAll(adfPipelines);
            return (B)this.self();
        }

        @Generated
        public B clearAdfPipelines() {
            if (this.adfPipelines != null) {
                this.adfPipelines.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AdfDataset.AdfDatasetBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", adfActivities=" + String.valueOf(this.adfActivities) + ", adfAssetFolderPath=" + this.adfAssetFolderPath + ", adfDataflows=" + String.valueOf(this.adfDataflows) + ", adfDatasetAnnotations=" + String.valueOf(this.adfDatasetAnnotations) + ", adfDatasetCollectionName=" + this.adfDatasetCollectionName + ", adfDatasetContainerName=" + this.adfDatasetContainerName + ", adfDatasetDatabaseName=" + this.adfDatasetDatabaseName + ", adfDatasetFileFolderPath=" + this.adfDatasetFileFolderPath + ", adfDatasetFileName=" + this.adfDatasetFileName + ", adfDatasetLinkedService=" + this.adfDatasetLinkedService + ", adfDatasetSchemaName=" + this.adfDatasetSchemaName + ", adfDatasetStorageType=" + this.adfDatasetStorageType + ", adfDatasetTableName=" + this.adfDatasetTableName + ", adfDatasetType=" + this.adfDatasetType + ", adfFactoryName=" + this.adfFactoryName + ", adfLinkedservice=" + String.valueOf(this.adfLinkedservice) + ", adfPipelines=" + String.valueOf(this.adfPipelines) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class AdfDatasetBuilderImpl
    extends AdfDatasetBuilder<AdfDataset, AdfDatasetBuilderImpl> {
        @Generated
        private AdfDatasetBuilderImpl() {
        }

        @Override
        @Generated
        protected AdfDatasetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AdfDataset build() {
            return new AdfDataset(this);
        }
    }
}

