/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IADF;
import com.atlan.model.assets.IAdfActivity;
import com.atlan.model.assets.IAdfDataflow;
import com.atlan.model.assets.IAdfDataset;
import com.atlan.model.assets.IAdfLinkedservice;
import com.atlan.model.assets.IAdfPipeline;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdfPipeline
extends Asset
implements IAdfPipeline,
IADF,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdfPipeline.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AdfPipeline";
    String typeName;
    @Attribute
    SortedSet<IAdfActivity> adfActivities;
    @Attribute
    String adfAssetFolderPath;
    @Attribute
    SortedSet<IAdfDataflow> adfDataflows;
    @Attribute
    SortedSet<IAdfDataset> adfDatasets;
    @Attribute
    String adfFactoryName;
    @Attribute
    SortedSet<IAdfLinkedservice> adfLinkedservices;
    @Attribute
    Integer adfPipelineActivityCount;
    @Attribute
    SortedSet<String> adfPipelineAnnotations;
    @Attribute
    List<Map<String, String>> adfPipelineRuns;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public AdfPipeline trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return AdfPipeline.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return AdfPipeline.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return AdfPipeline.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return AdfPipeline.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static AdfPipeline refByGuid(String guid) {
        return AdfPipeline.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static AdfPipeline refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((AdfPipelineBuilder)((AdfPipelineBuilder)AdfPipeline._internal().guid(guid)).semantic(semantic)).build();
    }

    public static AdfPipeline refByQualifiedName(String qualifiedName) {
        return AdfPipeline.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static AdfPipeline refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((AdfPipelineBuilder)((AdfPipelineBuilder)AdfPipeline._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static AdfPipeline get(AtlanClient client, String id) throws AtlanException {
        return AdfPipeline.get(client, id, false);
    }

    @JsonIgnore
    public static AdfPipeline get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof AdfPipeline) {
                return (AdfPipeline)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof AdfPipeline) {
            return (AdfPipeline)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static AdfPipeline get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return AdfPipeline.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static AdfPipeline get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AdfPipeline.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof AdfPipeline) {
                return (AdfPipeline)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AdfPipeline.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof AdfPipeline) {
            return (AdfPipeline)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static AdfPipelineBuilder<?, ?> updater(String qualifiedName, String name) {
        return (AdfPipelineBuilder)((AdfPipelineBuilder)((AdfPipelineBuilder)AdfPipeline._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public AdfPipelineBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        AdfPipeline.validateRequired(TYPE_NAME, map);
        return AdfPipeline.updater(this.getQualifiedName(), this.getName());
    }

    public static AdfPipeline removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfPipeline)Asset.removeDescription(client, AdfPipeline.updater(qualifiedName, name));
    }

    public static AdfPipeline removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfPipeline)Asset.removeUserDescription(client, AdfPipeline.updater(qualifiedName, name));
    }

    public static AdfPipeline removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfPipeline)Asset.removeOwners(client, AdfPipeline.updater(qualifiedName, name));
    }

    public static AdfPipeline updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AdfPipeline)Asset.updateCertificate(client, AdfPipeline._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static AdfPipeline removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfPipeline)Asset.removeCertificate(client, AdfPipeline.updater(qualifiedName, name));
    }

    public static AdfPipeline updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AdfPipeline)Asset.updateAnnouncement(client, AdfPipeline._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static AdfPipeline removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfPipeline)Asset.removeAnnouncement(client, AdfPipeline.updater(qualifiedName, name));
    }

    public static AdfPipeline replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AdfPipeline)Asset.replaceTerms(client, AdfPipeline.updater(qualifiedName, name), terms);
    }

    public static AdfPipeline appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AdfPipeline)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static AdfPipeline removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AdfPipeline)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static AdfPipeline appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AdfPipeline)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static AdfPipeline appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AdfPipeline)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AdfPipeline(AdfPipelineBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : AdfPipeline.$default$typeName();
        SortedSet<IAdfActivity> adfActivities = new TreeSet<IAdfActivity>();
        if (b.adfActivities != null) {
            adfActivities.addAll(b.adfActivities);
        }
        adfActivities = Collections.unmodifiableSortedSet(adfActivities);
        this.adfActivities = adfActivities;
        this.adfAssetFolderPath = b.adfAssetFolderPath;
        SortedSet<IAdfDataflow> adfDataflows = new TreeSet<IAdfDataflow>();
        if (b.adfDataflows != null) {
            adfDataflows.addAll(b.adfDataflows);
        }
        adfDataflows = Collections.unmodifiableSortedSet(adfDataflows);
        this.adfDataflows = adfDataflows;
        SortedSet<IAdfDataset> adfDatasets = new TreeSet<IAdfDataset>();
        if (b.adfDatasets != null) {
            adfDatasets.addAll(b.adfDatasets);
        }
        adfDatasets = Collections.unmodifiableSortedSet(adfDatasets);
        this.adfDatasets = adfDatasets;
        this.adfFactoryName = b.adfFactoryName;
        SortedSet<IAdfLinkedservice> adfLinkedservices = new TreeSet<IAdfLinkedservice>();
        if (b.adfLinkedservices != null) {
            adfLinkedservices.addAll(b.adfLinkedservices);
        }
        adfLinkedservices = Collections.unmodifiableSortedSet(adfLinkedservices);
        this.adfLinkedservices = adfLinkedservices;
        this.adfPipelineActivityCount = b.adfPipelineActivityCount;
        SortedSet<String> adfPipelineAnnotations = new TreeSet<String>();
        if (b.adfPipelineAnnotations != null) {
            adfPipelineAnnotations.addAll(b.adfPipelineAnnotations);
        }
        adfPipelineAnnotations = Collections.unmodifiableSortedSet(adfPipelineAnnotations);
        this.adfPipelineAnnotations = adfPipelineAnnotations;
        this.adfPipelineRuns = switch (b.adfPipelineRuns == null ? 0 : b.adfPipelineRuns.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.adfPipelineRuns.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.adfPipelineRuns));
        };
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static AdfPipelineBuilder<?, ?> _internal() {
        return new AdfPipelineBuilderImpl();
    }

    @Generated
    public AdfPipelineBuilder<?, ?> toBuilder() {
        return new AdfPipelineBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAdfActivity> getAdfActivities() {
        return this.adfActivities;
    }

    @Override
    @Generated
    public String getAdfAssetFolderPath() {
        return this.adfAssetFolderPath;
    }

    @Override
    @Generated
    public SortedSet<IAdfDataflow> getAdfDataflows() {
        return this.adfDataflows;
    }

    @Override
    @Generated
    public SortedSet<IAdfDataset> getAdfDatasets() {
        return this.adfDatasets;
    }

    @Override
    @Generated
    public String getAdfFactoryName() {
        return this.adfFactoryName;
    }

    @Override
    @Generated
    public SortedSet<IAdfLinkedservice> getAdfLinkedservices() {
        return this.adfLinkedservices;
    }

    @Override
    @Generated
    public Integer getAdfPipelineActivityCount() {
        return this.adfPipelineActivityCount;
    }

    @Override
    @Generated
    public SortedSet<String> getAdfPipelineAnnotations() {
        return this.adfPipelineAnnotations;
    }

    @Override
    @Generated
    public List<Map<String, String>> getAdfPipelineRuns() {
        return this.adfPipelineRuns;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdfPipeline)) {
            return false;
        }
        AdfPipeline other = (AdfPipeline)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$adfPipelineActivityCount = this.getAdfPipelineActivityCount();
        Integer other$adfPipelineActivityCount = other.getAdfPipelineActivityCount();
        if (this$adfPipelineActivityCount == null ? other$adfPipelineActivityCount != null : !((Object)this$adfPipelineActivityCount).equals(other$adfPipelineActivityCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAdfActivity> this$adfActivities = this.getAdfActivities();
        SortedSet<IAdfActivity> other$adfActivities = other.getAdfActivities();
        if (this$adfActivities == null ? other$adfActivities != null : !this$adfActivities.equals(other$adfActivities)) {
            return false;
        }
        String this$adfAssetFolderPath = this.getAdfAssetFolderPath();
        String other$adfAssetFolderPath = other.getAdfAssetFolderPath();
        if (this$adfAssetFolderPath == null ? other$adfAssetFolderPath != null : !this$adfAssetFolderPath.equals(other$adfAssetFolderPath)) {
            return false;
        }
        SortedSet<IAdfDataflow> this$adfDataflows = this.getAdfDataflows();
        SortedSet<IAdfDataflow> other$adfDataflows = other.getAdfDataflows();
        if (this$adfDataflows == null ? other$adfDataflows != null : !this$adfDataflows.equals(other$adfDataflows)) {
            return false;
        }
        SortedSet<IAdfDataset> this$adfDatasets = this.getAdfDatasets();
        SortedSet<IAdfDataset> other$adfDatasets = other.getAdfDatasets();
        if (this$adfDatasets == null ? other$adfDatasets != null : !this$adfDatasets.equals(other$adfDatasets)) {
            return false;
        }
        String this$adfFactoryName = this.getAdfFactoryName();
        String other$adfFactoryName = other.getAdfFactoryName();
        if (this$adfFactoryName == null ? other$adfFactoryName != null : !this$adfFactoryName.equals(other$adfFactoryName)) {
            return false;
        }
        SortedSet<IAdfLinkedservice> this$adfLinkedservices = this.getAdfLinkedservices();
        SortedSet<IAdfLinkedservice> other$adfLinkedservices = other.getAdfLinkedservices();
        if (this$adfLinkedservices == null ? other$adfLinkedservices != null : !this$adfLinkedservices.equals(other$adfLinkedservices)) {
            return false;
        }
        SortedSet<String> this$adfPipelineAnnotations = this.getAdfPipelineAnnotations();
        SortedSet<String> other$adfPipelineAnnotations = other.getAdfPipelineAnnotations();
        if (this$adfPipelineAnnotations == null ? other$adfPipelineAnnotations != null : !this$adfPipelineAnnotations.equals(other$adfPipelineAnnotations)) {
            return false;
        }
        List<Map<String, String>> this$adfPipelineRuns = this.getAdfPipelineRuns();
        List<Map<String, String>> other$adfPipelineRuns = other.getAdfPipelineRuns();
        if (this$adfPipelineRuns == null ? other$adfPipelineRuns != null : !((Object)this$adfPipelineRuns).equals(other$adfPipelineRuns)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdfPipeline;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $adfPipelineActivityCount = this.getAdfPipelineActivityCount();
        result = result * 59 + ($adfPipelineActivityCount == null ? 43 : ((Object)$adfPipelineActivityCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAdfActivity> $adfActivities = this.getAdfActivities();
        result = result * 59 + ($adfActivities == null ? 43 : $adfActivities.hashCode());
        String $adfAssetFolderPath = this.getAdfAssetFolderPath();
        result = result * 59 + ($adfAssetFolderPath == null ? 43 : $adfAssetFolderPath.hashCode());
        SortedSet<IAdfDataflow> $adfDataflows = this.getAdfDataflows();
        result = result * 59 + ($adfDataflows == null ? 43 : $adfDataflows.hashCode());
        SortedSet<IAdfDataset> $adfDatasets = this.getAdfDatasets();
        result = result * 59 + ($adfDatasets == null ? 43 : $adfDatasets.hashCode());
        String $adfFactoryName = this.getAdfFactoryName();
        result = result * 59 + ($adfFactoryName == null ? 43 : $adfFactoryName.hashCode());
        SortedSet<IAdfLinkedservice> $adfLinkedservices = this.getAdfLinkedservices();
        result = result * 59 + ($adfLinkedservices == null ? 43 : $adfLinkedservices.hashCode());
        SortedSet<String> $adfPipelineAnnotations = this.getAdfPipelineAnnotations();
        result = result * 59 + ($adfPipelineAnnotations == null ? 43 : $adfPipelineAnnotations.hashCode());
        List<Map<String, String>> $adfPipelineRuns = this.getAdfPipelineRuns();
        result = result * 59 + ($adfPipelineRuns == null ? 43 : ((Object)$adfPipelineRuns).hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AdfPipeline(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", adfActivities=" + String.valueOf(this.getAdfActivities()) + ", adfAssetFolderPath=" + this.getAdfAssetFolderPath() + ", adfDataflows=" + String.valueOf(this.getAdfDataflows()) + ", adfDatasets=" + String.valueOf(this.getAdfDatasets()) + ", adfFactoryName=" + this.getAdfFactoryName() + ", adfLinkedservices=" + String.valueOf(this.getAdfLinkedservices()) + ", adfPipelineActivityCount=" + this.getAdfPipelineActivityCount() + ", adfPipelineAnnotations=" + String.valueOf(this.getAdfPipelineAnnotations()) + ", adfPipelineRuns=" + String.valueOf(this.getAdfPipelineRuns()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class AdfPipelineBuilder<C extends AdfPipeline, B extends AdfPipelineBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAdfActivity> adfActivities;
        @Generated
        private String adfAssetFolderPath;
        @Generated
        private ArrayList<IAdfDataflow> adfDataflows;
        @Generated
        private ArrayList<IAdfDataset> adfDatasets;
        @Generated
        private String adfFactoryName;
        @Generated
        private ArrayList<IAdfLinkedservice> adfLinkedservices;
        @Generated
        private Integer adfPipelineActivityCount;
        @Generated
        private ArrayList<String> adfPipelineAnnotations;
        @Generated
        private ArrayList<Map<String, String>> adfPipelineRuns;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AdfPipelineBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AdfPipeline instance, AdfPipelineBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.adfActivities(instance.adfActivities == null ? Collections.emptySortedSet() : instance.adfActivities);
            b.adfAssetFolderPath(instance.adfAssetFolderPath);
            b.adfDataflows(instance.adfDataflows == null ? Collections.emptySortedSet() : instance.adfDataflows);
            b.adfDatasets(instance.adfDatasets == null ? Collections.emptySortedSet() : instance.adfDatasets);
            b.adfFactoryName(instance.adfFactoryName);
            b.adfLinkedservices(instance.adfLinkedservices == null ? Collections.emptySortedSet() : instance.adfLinkedservices);
            b.adfPipelineActivityCount(instance.adfPipelineActivityCount);
            b.adfPipelineAnnotations(instance.adfPipelineAnnotations == null ? Collections.emptySortedSet() : instance.adfPipelineAnnotations);
            b.adfPipelineRuns(instance.adfPipelineRuns == null ? Collections.emptyList() : instance.adfPipelineRuns);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B adfActivity(IAdfActivity adfActivity) {
            if (this.adfActivities == null) {
                this.adfActivities = new ArrayList();
            }
            this.adfActivities.add(adfActivity);
            return (B)this.self();
        }

        @Generated
        public B adfActivities(Collection<? extends IAdfActivity> adfActivities) {
            if (adfActivities == null) {
                throw new NullPointerException("adfActivities cannot be null");
            }
            if (this.adfActivities == null) {
                this.adfActivities = new ArrayList();
            }
            this.adfActivities.addAll(adfActivities);
            return (B)this.self();
        }

        @Generated
        public B clearAdfActivities() {
            if (this.adfActivities != null) {
                this.adfActivities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfAssetFolderPath(String adfAssetFolderPath) {
            this.adfAssetFolderPath = adfAssetFolderPath;
            return (B)this.self();
        }

        @Generated
        public B adfDataflow(IAdfDataflow adfDataflow) {
            if (this.adfDataflows == null) {
                this.adfDataflows = new ArrayList();
            }
            this.adfDataflows.add(adfDataflow);
            return (B)this.self();
        }

        @Generated
        public B adfDataflows(Collection<? extends IAdfDataflow> adfDataflows) {
            if (adfDataflows == null) {
                throw new NullPointerException("adfDataflows cannot be null");
            }
            if (this.adfDataflows == null) {
                this.adfDataflows = new ArrayList();
            }
            this.adfDataflows.addAll(adfDataflows);
            return (B)this.self();
        }

        @Generated
        public B clearAdfDataflows() {
            if (this.adfDataflows != null) {
                this.adfDataflows.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfDataset(IAdfDataset adfDataset) {
            if (this.adfDatasets == null) {
                this.adfDatasets = new ArrayList();
            }
            this.adfDatasets.add(adfDataset);
            return (B)this.self();
        }

        @Generated
        public B adfDatasets(Collection<? extends IAdfDataset> adfDatasets) {
            if (adfDatasets == null) {
                throw new NullPointerException("adfDatasets cannot be null");
            }
            if (this.adfDatasets == null) {
                this.adfDatasets = new ArrayList();
            }
            this.adfDatasets.addAll(adfDatasets);
            return (B)this.self();
        }

        @Generated
        public B clearAdfDatasets() {
            if (this.adfDatasets != null) {
                this.adfDatasets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfFactoryName(String adfFactoryName) {
            this.adfFactoryName = adfFactoryName;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedservice(IAdfLinkedservice adfLinkedservice) {
            if (this.adfLinkedservices == null) {
                this.adfLinkedservices = new ArrayList();
            }
            this.adfLinkedservices.add(adfLinkedservice);
            return (B)this.self();
        }

        @Generated
        public B adfLinkedservices(Collection<? extends IAdfLinkedservice> adfLinkedservices) {
            if (adfLinkedservices == null) {
                throw new NullPointerException("adfLinkedservices cannot be null");
            }
            if (this.adfLinkedservices == null) {
                this.adfLinkedservices = new ArrayList();
            }
            this.adfLinkedservices.addAll(adfLinkedservices);
            return (B)this.self();
        }

        @Generated
        public B clearAdfLinkedservices() {
            if (this.adfLinkedservices != null) {
                this.adfLinkedservices.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfPipelineActivityCount(Integer adfPipelineActivityCount) {
            this.adfPipelineActivityCount = adfPipelineActivityCount;
            return (B)this.self();
        }

        @Generated
        public B adfPipelineAnnotation(String adfPipelineAnnotation) {
            if (this.adfPipelineAnnotations == null) {
                this.adfPipelineAnnotations = new ArrayList();
            }
            this.adfPipelineAnnotations.add(adfPipelineAnnotation);
            return (B)this.self();
        }

        @Generated
        public B adfPipelineAnnotations(Collection<? extends String> adfPipelineAnnotations) {
            if (adfPipelineAnnotations == null) {
                throw new NullPointerException("adfPipelineAnnotations cannot be null");
            }
            if (this.adfPipelineAnnotations == null) {
                this.adfPipelineAnnotations = new ArrayList();
            }
            this.adfPipelineAnnotations.addAll(adfPipelineAnnotations);
            return (B)this.self();
        }

        @Generated
        public B clearAdfPipelineAnnotations() {
            if (this.adfPipelineAnnotations != null) {
                this.adfPipelineAnnotations.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfPipelineRun(Map<String, String> adfPipelineRun) {
            if (this.adfPipelineRuns == null) {
                this.adfPipelineRuns = new ArrayList();
            }
            this.adfPipelineRuns.add(adfPipelineRun);
            return (B)this.self();
        }

        @Generated
        public B adfPipelineRuns(Collection<? extends Map<String, String>> adfPipelineRuns) {
            if (adfPipelineRuns == null) {
                throw new NullPointerException("adfPipelineRuns cannot be null");
            }
            if (this.adfPipelineRuns == null) {
                this.adfPipelineRuns = new ArrayList();
            }
            this.adfPipelineRuns.addAll(adfPipelineRuns);
            return (B)this.self();
        }

        @Generated
        public B clearAdfPipelineRuns() {
            if (this.adfPipelineRuns != null) {
                this.adfPipelineRuns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AdfPipeline.AdfPipelineBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", adfActivities=" + String.valueOf(this.adfActivities) + ", adfAssetFolderPath=" + this.adfAssetFolderPath + ", adfDataflows=" + String.valueOf(this.adfDataflows) + ", adfDatasets=" + String.valueOf(this.adfDatasets) + ", adfFactoryName=" + this.adfFactoryName + ", adfLinkedservices=" + String.valueOf(this.adfLinkedservices) + ", adfPipelineActivityCount=" + this.adfPipelineActivityCount + ", adfPipelineAnnotations=" + String.valueOf(this.adfPipelineAnnotations) + ", adfPipelineRuns=" + String.valueOf(this.adfPipelineRuns) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class AdfPipelineBuilderImpl
    extends AdfPipelineBuilder<AdfPipeline, AdfPipelineBuilderImpl> {
        @Generated
        private AdfPipelineBuilderImpl() {
        }

        @Override
        @Generated
        protected AdfPipelineBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AdfPipeline build() {
            return new AdfPipeline(this);
        }
    }
}

