/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.AnaplanModel;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAnaplan;
import com.atlan.model.assets.IAnaplanLineItem;
import com.atlan.model.assets.IAnaplanList;
import com.atlan.model.assets.IAnaplanModel;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnaplanList
extends Asset
implements IAnaplanList,
IAnaplan,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnaplanList.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AnaplanList";
    String typeName;
    @Attribute
    SortedSet<IAnaplanLineItem> anaplanLineItems;
    @Attribute
    Long anaplanListItemCount;
    @Attribute
    IAnaplanModel anaplanModel;
    @Attribute
    String anaplanModelName;
    @Attribute
    String anaplanModelQualifiedName;
    @Attribute
    String anaplanModuleName;
    @Attribute
    String anaplanModuleQualifiedName;
    @Attribute
    String anaplanSourceId;
    @Attribute
    String anaplanWorkspaceName;
    @Attribute
    String anaplanWorkspaceQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public AnaplanList trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return AnaplanList.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return AnaplanList.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return AnaplanList.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return AnaplanList.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static AnaplanList refByGuid(String guid) {
        return AnaplanList.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static AnaplanList refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((AnaplanListBuilder)((AnaplanListBuilder)AnaplanList._internal().guid(guid)).semantic(semantic)).build();
    }

    public static AnaplanList refByQualifiedName(String qualifiedName) {
        return AnaplanList.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static AnaplanList refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((AnaplanListBuilder)((AnaplanListBuilder)AnaplanList._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static AnaplanList get(AtlanClient client, String id) throws AtlanException {
        return AnaplanList.get(client, id, false);
    }

    @JsonIgnore
    public static AnaplanList get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof AnaplanList) {
                return (AnaplanList)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof AnaplanList) {
            return (AnaplanList)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static AnaplanList get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return AnaplanList.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static AnaplanList get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AnaplanList.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof AnaplanList) {
                return (AnaplanList)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AnaplanList.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof AnaplanList) {
            return (AnaplanList)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static AnaplanListBuilder<?, ?> creator(String name, AnaplanModel model) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("modelQualifiedName", model.getQualifiedName());
        map.put("modelName", model.getName());
        map.put("connectionQualifiedName", model.getConnectionQualifiedName());
        map.put("workspaceName", model.getAnaplanWorkspaceName());
        map.put("workspaceQualifiedName", model.getAnaplanWorkspaceQualifiedName());
        AnaplanList.validateRelationship("AnaplanWorkspace", map);
        return AnaplanList.creator(name, model.getConnectionQualifiedName(), model.getName(), model.getQualifiedName(), model.getAnaplanWorkspaceName(), model.getAnaplanWorkspaceQualifiedName()).anaplanModel(model.trimToReference());
    }

    public static AnaplanListBuilder<?, ?> creator(String name, String modelQualifiedName) {
        String workspaceQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(modelQualifiedName);
        String workspaceName = StringUtils.getNameFromQualifiedName(workspaceQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(workspaceQualifiedName);
        String modelName = StringUtils.getNameFromQualifiedName(modelQualifiedName);
        return AnaplanList.creator(name, connectionQualifiedName, modelName, modelQualifiedName, workspaceName, workspaceQualifiedName);
    }

    public static AnaplanListBuilder<?, ?> creator(String name, String connectionQualifiedName, String modelName, String modelQualifiedName, String workspaceName, String workspaceQualifiedName) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        return ((AnaplanListBuilder)((AnaplanListBuilder)((AnaplanListBuilder)((AnaplanListBuilder)((AnaplanListBuilder)((AnaplanListBuilder)((AnaplanListBuilder)((AnaplanListBuilder)((AnaplanListBuilder)AnaplanList._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).qualifiedName(AnaplanList.generateQualifiedName(name, modelQualifiedName))).connectionQualifiedName(connectionQualifiedName)).connectorType(connectorType)).anaplanWorkspaceName(workspaceName)).anaplanWorkspaceQualifiedName(workspaceQualifiedName)).anaplanModelName(modelName)).anaplanModelQualifiedName(modelQualifiedName)).anaplanModel(AnaplanModel.refByQualifiedName(modelQualifiedName));
    }

    public static String generateQualifiedName(String name, String modelQualifiedName) {
        return modelQualifiedName + "/" + name;
    }

    public static AnaplanListBuilder<?, ?> updater(String qualifiedName, String name) {
        return (AnaplanListBuilder)((AnaplanListBuilder)((AnaplanListBuilder)AnaplanList._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public AnaplanListBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        AnaplanList.validateRequired(TYPE_NAME, map);
        return AnaplanList.updater(this.getQualifiedName(), this.getName());
    }

    public static AnaplanList removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnaplanList)Asset.removeDescription(client, AnaplanList.updater(qualifiedName, name));
    }

    public static AnaplanList removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnaplanList)Asset.removeUserDescription(client, AnaplanList.updater(qualifiedName, name));
    }

    public static AnaplanList removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnaplanList)Asset.removeOwners(client, AnaplanList.updater(qualifiedName, name));
    }

    public static AnaplanList updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AnaplanList)Asset.updateCertificate(client, AnaplanList._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static AnaplanList removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnaplanList)Asset.removeCertificate(client, AnaplanList.updater(qualifiedName, name));
    }

    public static AnaplanList updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AnaplanList)Asset.updateAnnouncement(client, AnaplanList._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static AnaplanList removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnaplanList)Asset.removeAnnouncement(client, AnaplanList.updater(qualifiedName, name));
    }

    public static AnaplanList replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AnaplanList)Asset.replaceTerms(client, AnaplanList.updater(qualifiedName, name), terms);
    }

    public static AnaplanList appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AnaplanList)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static AnaplanList removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AnaplanList)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static AnaplanList appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AnaplanList)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static AnaplanList appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AnaplanList)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AnaplanList(AnaplanListBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : AnaplanList.$default$typeName();
        SortedSet<IAnaplanLineItem> anaplanLineItems = new TreeSet<IAnaplanLineItem>();
        if (b.anaplanLineItems != null) {
            anaplanLineItems.addAll(b.anaplanLineItems);
        }
        anaplanLineItems = Collections.unmodifiableSortedSet(anaplanLineItems);
        this.anaplanLineItems = anaplanLineItems;
        this.anaplanListItemCount = b.anaplanListItemCount;
        this.anaplanModel = b.anaplanModel;
        this.anaplanModelName = b.anaplanModelName;
        this.anaplanModelQualifiedName = b.anaplanModelQualifiedName;
        this.anaplanModuleName = b.anaplanModuleName;
        this.anaplanModuleQualifiedName = b.anaplanModuleQualifiedName;
        this.anaplanSourceId = b.anaplanSourceId;
        this.anaplanWorkspaceName = b.anaplanWorkspaceName;
        this.anaplanWorkspaceQualifiedName = b.anaplanWorkspaceQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static AnaplanListBuilder<?, ?> _internal() {
        return new AnaplanListBuilderImpl();
    }

    @Generated
    public AnaplanListBuilder<?, ?> toBuilder() {
        return new AnaplanListBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAnaplanLineItem> getAnaplanLineItems() {
        return this.anaplanLineItems;
    }

    @Override
    @Generated
    public Long getAnaplanListItemCount() {
        return this.anaplanListItemCount;
    }

    @Override
    @Generated
    public IAnaplanModel getAnaplanModel() {
        return this.anaplanModel;
    }

    @Override
    @Generated
    public String getAnaplanModelName() {
        return this.anaplanModelName;
    }

    @Override
    @Generated
    public String getAnaplanModelQualifiedName() {
        return this.anaplanModelQualifiedName;
    }

    @Override
    @Generated
    public String getAnaplanModuleName() {
        return this.anaplanModuleName;
    }

    @Override
    @Generated
    public String getAnaplanModuleQualifiedName() {
        return this.anaplanModuleQualifiedName;
    }

    @Override
    @Generated
    public String getAnaplanSourceId() {
        return this.anaplanSourceId;
    }

    @Override
    @Generated
    public String getAnaplanWorkspaceName() {
        return this.anaplanWorkspaceName;
    }

    @Override
    @Generated
    public String getAnaplanWorkspaceQualifiedName() {
        return this.anaplanWorkspaceQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnaplanList)) {
            return false;
        }
        AnaplanList other = (AnaplanList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$anaplanListItemCount = this.getAnaplanListItemCount();
        Long other$anaplanListItemCount = other.getAnaplanListItemCount();
        if (this$anaplanListItemCount == null ? other$anaplanListItemCount != null : !((Object)this$anaplanListItemCount).equals(other$anaplanListItemCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAnaplanLineItem> this$anaplanLineItems = this.getAnaplanLineItems();
        SortedSet<IAnaplanLineItem> other$anaplanLineItems = other.getAnaplanLineItems();
        if (this$anaplanLineItems == null ? other$anaplanLineItems != null : !this$anaplanLineItems.equals(other$anaplanLineItems)) {
            return false;
        }
        IAnaplanModel this$anaplanModel = this.getAnaplanModel();
        IAnaplanModel other$anaplanModel = other.getAnaplanModel();
        if (this$anaplanModel == null ? other$anaplanModel != null : !this$anaplanModel.equals(other$anaplanModel)) {
            return false;
        }
        String this$anaplanModelName = this.getAnaplanModelName();
        String other$anaplanModelName = other.getAnaplanModelName();
        if (this$anaplanModelName == null ? other$anaplanModelName != null : !this$anaplanModelName.equals(other$anaplanModelName)) {
            return false;
        }
        String this$anaplanModelQualifiedName = this.getAnaplanModelQualifiedName();
        String other$anaplanModelQualifiedName = other.getAnaplanModelQualifiedName();
        if (this$anaplanModelQualifiedName == null ? other$anaplanModelQualifiedName != null : !this$anaplanModelQualifiedName.equals(other$anaplanModelQualifiedName)) {
            return false;
        }
        String this$anaplanModuleName = this.getAnaplanModuleName();
        String other$anaplanModuleName = other.getAnaplanModuleName();
        if (this$anaplanModuleName == null ? other$anaplanModuleName != null : !this$anaplanModuleName.equals(other$anaplanModuleName)) {
            return false;
        }
        String this$anaplanModuleQualifiedName = this.getAnaplanModuleQualifiedName();
        String other$anaplanModuleQualifiedName = other.getAnaplanModuleQualifiedName();
        if (this$anaplanModuleQualifiedName == null ? other$anaplanModuleQualifiedName != null : !this$anaplanModuleQualifiedName.equals(other$anaplanModuleQualifiedName)) {
            return false;
        }
        String this$anaplanSourceId = this.getAnaplanSourceId();
        String other$anaplanSourceId = other.getAnaplanSourceId();
        if (this$anaplanSourceId == null ? other$anaplanSourceId != null : !this$anaplanSourceId.equals(other$anaplanSourceId)) {
            return false;
        }
        String this$anaplanWorkspaceName = this.getAnaplanWorkspaceName();
        String other$anaplanWorkspaceName = other.getAnaplanWorkspaceName();
        if (this$anaplanWorkspaceName == null ? other$anaplanWorkspaceName != null : !this$anaplanWorkspaceName.equals(other$anaplanWorkspaceName)) {
            return false;
        }
        String this$anaplanWorkspaceQualifiedName = this.getAnaplanWorkspaceQualifiedName();
        String other$anaplanWorkspaceQualifiedName = other.getAnaplanWorkspaceQualifiedName();
        if (this$anaplanWorkspaceQualifiedName == null ? other$anaplanWorkspaceQualifiedName != null : !this$anaplanWorkspaceQualifiedName.equals(other$anaplanWorkspaceQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnaplanList;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $anaplanListItemCount = this.getAnaplanListItemCount();
        result = result * 59 + ($anaplanListItemCount == null ? 43 : ((Object)$anaplanListItemCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAnaplanLineItem> $anaplanLineItems = this.getAnaplanLineItems();
        result = result * 59 + ($anaplanLineItems == null ? 43 : $anaplanLineItems.hashCode());
        IAnaplanModel $anaplanModel = this.getAnaplanModel();
        result = result * 59 + ($anaplanModel == null ? 43 : $anaplanModel.hashCode());
        String $anaplanModelName = this.getAnaplanModelName();
        result = result * 59 + ($anaplanModelName == null ? 43 : $anaplanModelName.hashCode());
        String $anaplanModelQualifiedName = this.getAnaplanModelQualifiedName();
        result = result * 59 + ($anaplanModelQualifiedName == null ? 43 : $anaplanModelQualifiedName.hashCode());
        String $anaplanModuleName = this.getAnaplanModuleName();
        result = result * 59 + ($anaplanModuleName == null ? 43 : $anaplanModuleName.hashCode());
        String $anaplanModuleQualifiedName = this.getAnaplanModuleQualifiedName();
        result = result * 59 + ($anaplanModuleQualifiedName == null ? 43 : $anaplanModuleQualifiedName.hashCode());
        String $anaplanSourceId = this.getAnaplanSourceId();
        result = result * 59 + ($anaplanSourceId == null ? 43 : $anaplanSourceId.hashCode());
        String $anaplanWorkspaceName = this.getAnaplanWorkspaceName();
        result = result * 59 + ($anaplanWorkspaceName == null ? 43 : $anaplanWorkspaceName.hashCode());
        String $anaplanWorkspaceQualifiedName = this.getAnaplanWorkspaceQualifiedName();
        result = result * 59 + ($anaplanWorkspaceQualifiedName == null ? 43 : $anaplanWorkspaceQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AnaplanList(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", anaplanLineItems=" + String.valueOf(this.getAnaplanLineItems()) + ", anaplanListItemCount=" + this.getAnaplanListItemCount() + ", anaplanModel=" + String.valueOf(this.getAnaplanModel()) + ", anaplanModelName=" + this.getAnaplanModelName() + ", anaplanModelQualifiedName=" + this.getAnaplanModelQualifiedName() + ", anaplanModuleName=" + this.getAnaplanModuleName() + ", anaplanModuleQualifiedName=" + this.getAnaplanModuleQualifiedName() + ", anaplanSourceId=" + this.getAnaplanSourceId() + ", anaplanWorkspaceName=" + this.getAnaplanWorkspaceName() + ", anaplanWorkspaceQualifiedName=" + this.getAnaplanWorkspaceQualifiedName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class AnaplanListBuilder<C extends AnaplanList, B extends AnaplanListBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAnaplanLineItem> anaplanLineItems;
        @Generated
        private Long anaplanListItemCount;
        @Generated
        private IAnaplanModel anaplanModel;
        @Generated
        private String anaplanModelName;
        @Generated
        private String anaplanModelQualifiedName;
        @Generated
        private String anaplanModuleName;
        @Generated
        private String anaplanModuleQualifiedName;
        @Generated
        private String anaplanSourceId;
        @Generated
        private String anaplanWorkspaceName;
        @Generated
        private String anaplanWorkspaceQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AnaplanListBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AnaplanList instance, AnaplanListBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.anaplanLineItems(instance.anaplanLineItems == null ? Collections.emptySortedSet() : instance.anaplanLineItems);
            b.anaplanListItemCount(instance.anaplanListItemCount);
            b.anaplanModel(instance.anaplanModel);
            b.anaplanModelName(instance.anaplanModelName);
            b.anaplanModelQualifiedName(instance.anaplanModelQualifiedName);
            b.anaplanModuleName(instance.anaplanModuleName);
            b.anaplanModuleQualifiedName(instance.anaplanModuleQualifiedName);
            b.anaplanSourceId(instance.anaplanSourceId);
            b.anaplanWorkspaceName(instance.anaplanWorkspaceName);
            b.anaplanWorkspaceQualifiedName(instance.anaplanWorkspaceQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B anaplanLineItem(IAnaplanLineItem anaplanLineItem) {
            if (this.anaplanLineItems == null) {
                this.anaplanLineItems = new ArrayList();
            }
            this.anaplanLineItems.add(anaplanLineItem);
            return (B)this.self();
        }

        @Generated
        public B anaplanLineItems(Collection<? extends IAnaplanLineItem> anaplanLineItems) {
            if (anaplanLineItems == null) {
                throw new NullPointerException("anaplanLineItems cannot be null");
            }
            if (this.anaplanLineItems == null) {
                this.anaplanLineItems = new ArrayList();
            }
            this.anaplanLineItems.addAll(anaplanLineItems);
            return (B)this.self();
        }

        @Generated
        public B clearAnaplanLineItems() {
            if (this.anaplanLineItems != null) {
                this.anaplanLineItems.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B anaplanListItemCount(Long anaplanListItemCount) {
            this.anaplanListItemCount = anaplanListItemCount;
            return (B)this.self();
        }

        @Generated
        public B anaplanModel(IAnaplanModel anaplanModel) {
            this.anaplanModel = anaplanModel;
            return (B)this.self();
        }

        @Generated
        public B anaplanModelName(String anaplanModelName) {
            this.anaplanModelName = anaplanModelName;
            return (B)this.self();
        }

        @Generated
        public B anaplanModelQualifiedName(String anaplanModelQualifiedName) {
            this.anaplanModelQualifiedName = anaplanModelQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B anaplanModuleName(String anaplanModuleName) {
            this.anaplanModuleName = anaplanModuleName;
            return (B)this.self();
        }

        @Generated
        public B anaplanModuleQualifiedName(String anaplanModuleQualifiedName) {
            this.anaplanModuleQualifiedName = anaplanModuleQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B anaplanSourceId(String anaplanSourceId) {
            this.anaplanSourceId = anaplanSourceId;
            return (B)this.self();
        }

        @Generated
        public B anaplanWorkspaceName(String anaplanWorkspaceName) {
            this.anaplanWorkspaceName = anaplanWorkspaceName;
            return (B)this.self();
        }

        @Generated
        public B anaplanWorkspaceQualifiedName(String anaplanWorkspaceQualifiedName) {
            this.anaplanWorkspaceQualifiedName = anaplanWorkspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AnaplanList.AnaplanListBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", anaplanLineItems=" + String.valueOf(this.anaplanLineItems) + ", anaplanListItemCount=" + this.anaplanListItemCount + ", anaplanModel=" + String.valueOf(this.anaplanModel) + ", anaplanModelName=" + this.anaplanModelName + ", anaplanModelQualifiedName=" + this.anaplanModelQualifiedName + ", anaplanModuleName=" + this.anaplanModuleName + ", anaplanModuleQualifiedName=" + this.anaplanModuleQualifiedName + ", anaplanSourceId=" + this.anaplanSourceId + ", anaplanWorkspaceName=" + this.anaplanWorkspaceName + ", anaplanWorkspaceQualifiedName=" + this.anaplanWorkspaceQualifiedName + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class AnaplanListBuilderImpl
    extends AnaplanListBuilder<AnaplanList, AnaplanListBuilderImpl> {
        @Generated
        private AnaplanListBuilderImpl() {
        }

        @Override
        @Generated
        protected AnaplanListBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AnaplanList build() {
            return new AnaplanList(this);
        }
    }
}

