/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IAtlanCollection;
import com.atlan.model.assets.IAtlanQuery;
import com.atlan.model.assets.IFolder;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.INamespace;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.AsyncCreationResponse;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.IconType;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlanCollection
extends Asset
implements IAtlanCollection,
INamespace,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtlanCollection.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Collection";
    String typeName;
    @Attribute
    SortedSet<IFolder> childrenFolders;
    @Attribute
    SortedSet<IAtlanQuery> childrenQueries;
    @Attribute
    String icon;
    @Attribute
    IconType iconType;

    @Override
    public AtlanCollection trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return AtlanCollection.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return AtlanCollection.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return AtlanCollection.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return AtlanCollection.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static AtlanCollection refByGuid(String guid) {
        return AtlanCollection.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static AtlanCollection refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((AtlanCollectionBuilder)((AtlanCollectionBuilder)AtlanCollection._internal().guid(guid)).semantic(semantic)).build();
    }

    public static AtlanCollection refByQualifiedName(String qualifiedName) {
        return AtlanCollection.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static AtlanCollection refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((AtlanCollectionBuilder)((AtlanCollectionBuilder)AtlanCollection._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static AtlanCollection get(AtlanClient client, String id) throws AtlanException {
        return AtlanCollection.get(client, id, false);
    }

    @JsonIgnore
    public static AtlanCollection get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof AtlanCollection) {
                return (AtlanCollection)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof AtlanCollection) {
            return (AtlanCollection)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static AtlanCollection get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return AtlanCollection.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static AtlanCollection get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AtlanCollection.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof AtlanCollection) {
                return (AtlanCollection)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AtlanCollection.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof AtlanCollection) {
            return (AtlanCollection)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public AssetMutationResponse addApiTokenAsAdmin(AtlanClient client, String impersonationToken) throws AtlanException {
        return Asset.addApiTokenAsAdmin(client, this.getGuid(), impersonationToken);
    }

    public AssetMutationResponse addApiTokenAsViewer(AtlanClient client, String impersonationToken) throws AtlanException {
        AssetMutationResponse response;
        block8: {
            String username = client.users.getCurrentUser().getUsername();
            response = null;
            try (AtlanClient tmp = new AtlanClient(client.getBaseUrl(), impersonationToken);){
                Optional<Asset> found = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)tmp.assets.select().where(GUID.eq(this.getGuid()))).includeOnResults(VIEWER_USERS)).stream().findFirst();
                response = null;
                if (found.isPresent()) {
                    Asset asset = found.get();
                    SortedSet<String> existingViewers = asset.getViewerUsers();
                    response = ((Asset)((Asset.AssetBuilder)((Asset.AssetBuilder)asset.trimToRequired().viewerUsers(existingViewers)).viewerUser(username)).build()).save(tmp);
                    break block8;
                }
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, this.getGuid());
            }
            catch (Exception e) {
                log.warn("Unable to remove temporary client using impersonationToken.", (Throwable)e);
            }
        }
        return response;
    }

    public static AtlanCollectionBuilder<?, ?> creator(AtlanClient client, String name) {
        return (AtlanCollectionBuilder)((AtlanCollectionBuilder)((AtlanCollectionBuilder)AtlanCollection._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).qualifiedName(AtlanCollection.generateQualifiedName(client));
    }

    public static String generateQualifiedName(AtlanClient client) {
        try {
            String username = client.users.getCurrentUser().getUsername();
            return "default/collection/" + username + "/" + String.valueOf(UUID.randomUUID());
        }
        catch (AtlanException e) {
            log.error("Unable to determine the current user.", (Throwable)e);
            return null;
        }
    }

    @Override
    public AsyncCreationResponse save(AtlanClient client) throws AtlanException {
        return client.assets.save((Asset)this, false);
    }

    @Override
    public AsyncCreationResponse save(AtlanClient client, boolean replaceAtlanTags) throws AtlanException {
        return client.assets.save((Asset)this, replaceAtlanTags);
    }

    public static AtlanCollectionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (AtlanCollectionBuilder)((AtlanCollectionBuilder)((AtlanCollectionBuilder)AtlanCollection._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public AtlanCollectionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        AtlanCollection.validateRequired(TYPE_NAME, map);
        return AtlanCollection.updater(this.getQualifiedName(), this.getName());
    }

    public static List<AtlanCollection> findByName(AtlanClient client, String name) throws AtlanException {
        return AtlanCollection.findByName(client, name, (List<AtlanField>)null);
    }

    public static List<AtlanCollection> findByName(AtlanClient client, String name, Collection<String> attributes) throws AtlanException {
        ArrayList<AtlanCollection> results = new ArrayList<AtlanCollection>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AtlanCollection.select(client).where(NAME.eq(name)))._includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof AtlanCollection).forEach(c -> results.add((AtlanCollection)c));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.COLLECTION_NOT_FOUND_BY_NAME, name);
        }
        return results;
    }

    public static List<AtlanCollection> findByName(AtlanClient client, String name, List<AtlanField> attributes) throws AtlanException {
        ArrayList<AtlanCollection> results = new ArrayList<AtlanCollection>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AtlanCollection.select(client).where(NAME.eq(name))).includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof AtlanCollection).forEach(c -> results.add((AtlanCollection)c));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.COLLECTION_NOT_FOUND_BY_NAME, name);
        }
        return results;
    }

    public static AtlanCollection removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AtlanCollection)Asset.removeDescription(client, AtlanCollection.updater(qualifiedName, name));
    }

    public static AtlanCollection removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AtlanCollection)Asset.removeUserDescription(client, AtlanCollection.updater(qualifiedName, name));
    }

    public static AtlanCollection removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AtlanCollection)Asset.removeOwners(client, AtlanCollection.updater(qualifiedName, name));
    }

    public static AtlanCollection updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AtlanCollection)Asset.updateCertificate(client, AtlanCollection._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static AtlanCollection removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AtlanCollection)Asset.removeCertificate(client, AtlanCollection.updater(qualifiedName, name));
    }

    public static AtlanCollection updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AtlanCollection)Asset.updateAnnouncement(client, AtlanCollection._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static AtlanCollection removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AtlanCollection)Asset.removeAnnouncement(client, AtlanCollection.updater(qualifiedName, name));
    }

    public static AtlanCollection replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AtlanCollection)Asset.replaceTerms(client, AtlanCollection.updater(qualifiedName, name), terms);
    }

    public static AtlanCollection appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AtlanCollection)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static AtlanCollection removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AtlanCollection)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static AtlanCollection appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AtlanCollection)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static AtlanCollection appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AtlanCollection)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AtlanCollection(AtlanCollectionBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : AtlanCollection.$default$typeName();
        SortedSet<IFolder> childrenFolders = new TreeSet<IFolder>();
        if (b.childrenFolders != null) {
            childrenFolders.addAll(b.childrenFolders);
        }
        childrenFolders = Collections.unmodifiableSortedSet(childrenFolders);
        this.childrenFolders = childrenFolders;
        SortedSet<IAtlanQuery> childrenQueries = new TreeSet<IAtlanQuery>();
        if (b.childrenQueries != null) {
            childrenQueries.addAll(b.childrenQueries);
        }
        childrenQueries = Collections.unmodifiableSortedSet(childrenQueries);
        this.childrenQueries = childrenQueries;
        this.icon = b.icon;
        this.iconType = b.iconType;
    }

    @Generated
    public static AtlanCollectionBuilder<?, ?> _internal() {
        return new AtlanCollectionBuilderImpl();
    }

    @Generated
    public AtlanCollectionBuilder<?, ?> toBuilder() {
        return new AtlanCollectionBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IFolder> getChildrenFolders() {
        return this.childrenFolders;
    }

    @Override
    @Generated
    public SortedSet<IAtlanQuery> getChildrenQueries() {
        return this.childrenQueries;
    }

    @Override
    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Override
    @Generated
    public IconType getIconType() {
        return this.iconType;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtlanCollection)) {
            return false;
        }
        AtlanCollection other = (AtlanCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IFolder> this$childrenFolders = this.getChildrenFolders();
        SortedSet<IFolder> other$childrenFolders = other.getChildrenFolders();
        if (this$childrenFolders == null ? other$childrenFolders != null : !this$childrenFolders.equals(other$childrenFolders)) {
            return false;
        }
        SortedSet<IAtlanQuery> this$childrenQueries = this.getChildrenQueries();
        SortedSet<IAtlanQuery> other$childrenQueries = other.getChildrenQueries();
        if (this$childrenQueries == null ? other$childrenQueries != null : !this$childrenQueries.equals(other$childrenQueries)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        IconType this$iconType = this.getIconType();
        IconType other$iconType = other.getIconType();
        return !(this$iconType == null ? other$iconType != null : !this$iconType.equals(other$iconType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtlanCollection;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IFolder> $childrenFolders = this.getChildrenFolders();
        result = result * 59 + ($childrenFolders == null ? 43 : $childrenFolders.hashCode());
        SortedSet<IAtlanQuery> $childrenQueries = this.getChildrenQueries();
        result = result * 59 + ($childrenQueries == null ? 43 : $childrenQueries.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        IconType $iconType = this.getIconType();
        result = result * 59 + ($iconType == null ? 43 : $iconType.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AtlanCollection(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", childrenFolders=" + String.valueOf(this.getChildrenFolders()) + ", childrenQueries=" + String.valueOf(this.getChildrenQueries()) + ", icon=" + this.getIcon() + ", iconType=" + String.valueOf(this.getIconType()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class AtlanCollectionBuilder<C extends AtlanCollection, B extends AtlanCollectionBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IFolder> childrenFolders;
        @Generated
        private ArrayList<IAtlanQuery> childrenQueries;
        @Generated
        private String icon;
        @Generated
        private IconType iconType;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AtlanCollectionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AtlanCollection instance, AtlanCollectionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.childrenFolders(instance.childrenFolders == null ? Collections.emptySortedSet() : instance.childrenFolders);
            b.childrenQueries(instance.childrenQueries == null ? Collections.emptySortedSet() : instance.childrenQueries);
            b.icon(instance.icon);
            b.iconType(instance.iconType);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B childrenFolder(IFolder childrenFolder) {
            if (this.childrenFolders == null) {
                this.childrenFolders = new ArrayList();
            }
            this.childrenFolders.add(childrenFolder);
            return (B)this.self();
        }

        @Generated
        public B childrenFolders(Collection<? extends IFolder> childrenFolders) {
            if (childrenFolders == null) {
                throw new NullPointerException("childrenFolders cannot be null");
            }
            if (this.childrenFolders == null) {
                this.childrenFolders = new ArrayList();
            }
            this.childrenFolders.addAll(childrenFolders);
            return (B)this.self();
        }

        @Generated
        public B clearChildrenFolders() {
            if (this.childrenFolders != null) {
                this.childrenFolders.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B childrenQuery(IAtlanQuery childrenQuery) {
            if (this.childrenQueries == null) {
                this.childrenQueries = new ArrayList();
            }
            this.childrenQueries.add(childrenQuery);
            return (B)this.self();
        }

        @Generated
        public B childrenQueries(Collection<? extends IAtlanQuery> childrenQueries) {
            if (childrenQueries == null) {
                throw new NullPointerException("childrenQueries cannot be null");
            }
            if (this.childrenQueries == null) {
                this.childrenQueries = new ArrayList();
            }
            this.childrenQueries.addAll(childrenQueries);
            return (B)this.self();
        }

        @Generated
        public B clearChildrenQueries() {
            if (this.childrenQueries != null) {
                this.childrenQueries.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B icon(String icon) {
            this.icon = icon;
            return (B)this.self();
        }

        @Generated
        public B iconType(IconType iconType) {
            this.iconType = iconType;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AtlanCollection.AtlanCollectionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", childrenFolders=" + String.valueOf(this.childrenFolders) + ", childrenQueries=" + String.valueOf(this.childrenQueries) + ", icon=" + this.icon + ", iconType=" + String.valueOf(this.iconType) + ")";
        }
    }

    @Generated
    private static final class AtlanCollectionBuilderImpl
    extends AtlanCollectionBuilder<AtlanCollection, AtlanCollectionBuilderImpl> {
        @Generated
        private AtlanCollectionBuilderImpl() {
        }

        @Override
        @Generated
        protected AtlanCollectionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AtlanCollection build() {
            return new AtlanCollection(this);
        }
    }
}

