/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAccessControl;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IAuthPolicy;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.enums.AtlanPolicyAction;
import com.atlan.model.enums.AuthPolicyCategory;
import com.atlan.model.enums.AuthPolicyResourceCategory;
import com.atlan.model.enums.AuthPolicyType;
import com.atlan.model.enums.DataMaskingType;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.AuthPolicyCondition;
import com.atlan.model.structs.AuthPolicyValiditySchedule;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthPolicy
extends Asset
implements IAuthPolicy,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthPolicy.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AuthPolicy";
    String typeName;
    @Attribute
    IAccessControl accessControl;
    @Attribute
    Boolean isPolicyEnabled;
    @Attribute
    SortedSet<AtlanPolicyAction> policyActions;
    @Attribute
    AuthPolicyCategory policyCategory;
    @Attribute
    List<AuthPolicyCondition> policyConditions;
    @Attribute
    Boolean policyDelegateAdmin;
    @Attribute
    SortedSet<String> policyGroups;
    @Attribute
    DataMaskingType policyMaskType;
    @Attribute
    Integer policyPriority;
    @Attribute
    AuthPolicyResourceCategory policyResourceCategory;
    @Attribute
    String policyResourceSignature;
    @Attribute
    SortedSet<String> policyResources;
    @Attribute
    SortedSet<String> policyRoles;
    @Attribute
    String policyServiceName;
    @Attribute
    String policySubCategory;
    @Attribute
    AuthPolicyType policyType;
    @Attribute
    SortedSet<String> policyUsers;
    @Attribute
    List<AuthPolicyValiditySchedule> policyValiditySchedule;

    @Override
    public AuthPolicy trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return AuthPolicy.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return AuthPolicy.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return AuthPolicy.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return AuthPolicy.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static AuthPolicy refByGuid(String guid) {
        return AuthPolicy.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static AuthPolicy refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((AuthPolicyBuilder)((AuthPolicyBuilder)AuthPolicy._internal().guid(guid)).semantic(semantic)).build();
    }

    public static AuthPolicy refByQualifiedName(String qualifiedName) {
        return AuthPolicy.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static AuthPolicy refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((AuthPolicyBuilder)((AuthPolicyBuilder)AuthPolicy._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static AuthPolicy get(AtlanClient client, String id) throws AtlanException {
        return AuthPolicy.get(client, id, false);
    }

    @JsonIgnore
    public static AuthPolicy get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof AuthPolicy) {
                return (AuthPolicy)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof AuthPolicy) {
            return (AuthPolicy)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static AuthPolicy get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return AuthPolicy.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static AuthPolicy get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AuthPolicy.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof AuthPolicy) {
                return (AuthPolicy)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AuthPolicy.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof AuthPolicy) {
            return (AuthPolicy)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static AuthPolicyBuilder<?, ?> creator(String name) {
        return (AuthPolicyBuilder)((AuthPolicyBuilder)((AuthPolicyBuilder)((AuthPolicyBuilder)AuthPolicy._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(name)).name(name)).displayName("");
    }

    public AuthPolicyBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        throw new InvalidRequestException(ErrorCode.FULL_UPDATE_ONLY, TYPE_NAME);
    }

    public static AuthPolicy appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AuthPolicy)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static AuthPolicy appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AuthPolicy)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AuthPolicy(AuthPolicyBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : AuthPolicy.$default$typeName();
        this.accessControl = b.accessControl;
        this.isPolicyEnabled = b.isPolicyEnabled;
        SortedSet<AtlanPolicyAction> policyActions = new TreeSet<AtlanPolicyAction>();
        if (b.policyActions != null) {
            policyActions.addAll(b.policyActions);
        }
        policyActions = Collections.unmodifiableSortedSet(policyActions);
        this.policyActions = policyActions;
        this.policyCategory = b.policyCategory;
        this.policyConditions = switch (b.policyConditions == null ? 0 : b.policyConditions.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.policyConditions.get(0));
            default -> Collections.unmodifiableList(new ArrayList<AuthPolicyCondition>(b.policyConditions));
        };
        this.policyDelegateAdmin = b.policyDelegateAdmin;
        SortedSet<String> policyGroups = new TreeSet<String>();
        if (b.policyGroups != null) {
            policyGroups.addAll(b.policyGroups);
        }
        policyGroups = Collections.unmodifiableSortedSet(policyGroups);
        this.policyGroups = policyGroups;
        this.policyMaskType = b.policyMaskType;
        this.policyPriority = b.policyPriority;
        this.policyResourceCategory = b.policyResourceCategory;
        this.policyResourceSignature = b.policyResourceSignature;
        SortedSet<String> policyResources = new TreeSet<String>();
        if (b.policyResources != null) {
            policyResources.addAll(b.policyResources);
        }
        policyResources = Collections.unmodifiableSortedSet(policyResources);
        this.policyResources = policyResources;
        SortedSet<String> policyRoles = new TreeSet<String>();
        if (b.policyRoles != null) {
            policyRoles.addAll(b.policyRoles);
        }
        policyRoles = Collections.unmodifiableSortedSet(policyRoles);
        this.policyRoles = policyRoles;
        this.policyServiceName = b.policyServiceName;
        this.policySubCategory = b.policySubCategory;
        this.policyType = b.policyType;
        SortedSet<String> policyUsers = new TreeSet<String>();
        if (b.policyUsers != null) {
            policyUsers.addAll(b.policyUsers);
        }
        policyUsers = Collections.unmodifiableSortedSet(policyUsers);
        this.policyUsers = policyUsers;
        this.policyValiditySchedule = switch (b.policyValiditySchedule == null ? 0 : b.policyValiditySchedule.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.policyValiditySchedule.get(0));
            default -> Collections.unmodifiableList(new ArrayList<AuthPolicyValiditySchedule>(b.policyValiditySchedule));
        };
    }

    @Generated
    public static AuthPolicyBuilder<?, ?> _internal() {
        return new AuthPolicyBuilderImpl();
    }

    @Generated
    public AuthPolicyBuilder<?, ?> toBuilder() {
        return new AuthPolicyBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IAccessControl getAccessControl() {
        return this.accessControl;
    }

    @Override
    @Generated
    public Boolean getIsPolicyEnabled() {
        return this.isPolicyEnabled;
    }

    @Override
    @Generated
    public SortedSet<AtlanPolicyAction> getPolicyActions() {
        return this.policyActions;
    }

    @Override
    @Generated
    public AuthPolicyCategory getPolicyCategory() {
        return this.policyCategory;
    }

    @Override
    @Generated
    public List<AuthPolicyCondition> getPolicyConditions() {
        return this.policyConditions;
    }

    @Override
    @Generated
    public Boolean getPolicyDelegateAdmin() {
        return this.policyDelegateAdmin;
    }

    @Override
    @Generated
    public SortedSet<String> getPolicyGroups() {
        return this.policyGroups;
    }

    @Override
    @Generated
    public DataMaskingType getPolicyMaskType() {
        return this.policyMaskType;
    }

    @Override
    @Generated
    public Integer getPolicyPriority() {
        return this.policyPriority;
    }

    @Override
    @Generated
    public AuthPolicyResourceCategory getPolicyResourceCategory() {
        return this.policyResourceCategory;
    }

    @Override
    @Generated
    public String getPolicyResourceSignature() {
        return this.policyResourceSignature;
    }

    @Override
    @Generated
    public SortedSet<String> getPolicyResources() {
        return this.policyResources;
    }

    @Override
    @Generated
    public SortedSet<String> getPolicyRoles() {
        return this.policyRoles;
    }

    @Override
    @Generated
    public String getPolicyServiceName() {
        return this.policyServiceName;
    }

    @Override
    @Generated
    public String getPolicySubCategory() {
        return this.policySubCategory;
    }

    @Override
    @Generated
    public AuthPolicyType getPolicyType() {
        return this.policyType;
    }

    @Override
    @Generated
    public SortedSet<String> getPolicyUsers() {
        return this.policyUsers;
    }

    @Override
    @Generated
    public List<AuthPolicyValiditySchedule> getPolicyValiditySchedule() {
        return this.policyValiditySchedule;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthPolicy)) {
            return false;
        }
        AuthPolicy other = (AuthPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isPolicyEnabled = this.getIsPolicyEnabled();
        Boolean other$isPolicyEnabled = other.getIsPolicyEnabled();
        if (this$isPolicyEnabled == null ? other$isPolicyEnabled != null : !((Object)this$isPolicyEnabled).equals(other$isPolicyEnabled)) {
            return false;
        }
        Boolean this$policyDelegateAdmin = this.getPolicyDelegateAdmin();
        Boolean other$policyDelegateAdmin = other.getPolicyDelegateAdmin();
        if (this$policyDelegateAdmin == null ? other$policyDelegateAdmin != null : !((Object)this$policyDelegateAdmin).equals(other$policyDelegateAdmin)) {
            return false;
        }
        Integer this$policyPriority = this.getPolicyPriority();
        Integer other$policyPriority = other.getPolicyPriority();
        if (this$policyPriority == null ? other$policyPriority != null : !((Object)this$policyPriority).equals(other$policyPriority)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IAccessControl this$accessControl = this.getAccessControl();
        IAccessControl other$accessControl = other.getAccessControl();
        if (this$accessControl == null ? other$accessControl != null : !this$accessControl.equals(other$accessControl)) {
            return false;
        }
        SortedSet<AtlanPolicyAction> this$policyActions = this.getPolicyActions();
        SortedSet<AtlanPolicyAction> other$policyActions = other.getPolicyActions();
        if (this$policyActions == null ? other$policyActions != null : !this$policyActions.equals(other$policyActions)) {
            return false;
        }
        AuthPolicyCategory this$policyCategory = this.getPolicyCategory();
        AuthPolicyCategory other$policyCategory = other.getPolicyCategory();
        if (this$policyCategory == null ? other$policyCategory != null : !this$policyCategory.equals(other$policyCategory)) {
            return false;
        }
        List<AuthPolicyCondition> this$policyConditions = this.getPolicyConditions();
        List<AuthPolicyCondition> other$policyConditions = other.getPolicyConditions();
        if (this$policyConditions == null ? other$policyConditions != null : !((Object)this$policyConditions).equals(other$policyConditions)) {
            return false;
        }
        SortedSet<String> this$policyGroups = this.getPolicyGroups();
        SortedSet<String> other$policyGroups = other.getPolicyGroups();
        if (this$policyGroups == null ? other$policyGroups != null : !this$policyGroups.equals(other$policyGroups)) {
            return false;
        }
        DataMaskingType this$policyMaskType = this.getPolicyMaskType();
        DataMaskingType other$policyMaskType = other.getPolicyMaskType();
        if (this$policyMaskType == null ? other$policyMaskType != null : !this$policyMaskType.equals(other$policyMaskType)) {
            return false;
        }
        AuthPolicyResourceCategory this$policyResourceCategory = this.getPolicyResourceCategory();
        AuthPolicyResourceCategory other$policyResourceCategory = other.getPolicyResourceCategory();
        if (this$policyResourceCategory == null ? other$policyResourceCategory != null : !this$policyResourceCategory.equals(other$policyResourceCategory)) {
            return false;
        }
        String this$policyResourceSignature = this.getPolicyResourceSignature();
        String other$policyResourceSignature = other.getPolicyResourceSignature();
        if (this$policyResourceSignature == null ? other$policyResourceSignature != null : !this$policyResourceSignature.equals(other$policyResourceSignature)) {
            return false;
        }
        SortedSet<String> this$policyResources = this.getPolicyResources();
        SortedSet<String> other$policyResources = other.getPolicyResources();
        if (this$policyResources == null ? other$policyResources != null : !this$policyResources.equals(other$policyResources)) {
            return false;
        }
        SortedSet<String> this$policyRoles = this.getPolicyRoles();
        SortedSet<String> other$policyRoles = other.getPolicyRoles();
        if (this$policyRoles == null ? other$policyRoles != null : !this$policyRoles.equals(other$policyRoles)) {
            return false;
        }
        String this$policyServiceName = this.getPolicyServiceName();
        String other$policyServiceName = other.getPolicyServiceName();
        if (this$policyServiceName == null ? other$policyServiceName != null : !this$policyServiceName.equals(other$policyServiceName)) {
            return false;
        }
        String this$policySubCategory = this.getPolicySubCategory();
        String other$policySubCategory = other.getPolicySubCategory();
        if (this$policySubCategory == null ? other$policySubCategory != null : !this$policySubCategory.equals(other$policySubCategory)) {
            return false;
        }
        AuthPolicyType this$policyType = this.getPolicyType();
        AuthPolicyType other$policyType = other.getPolicyType();
        if (this$policyType == null ? other$policyType != null : !this$policyType.equals(other$policyType)) {
            return false;
        }
        SortedSet<String> this$policyUsers = this.getPolicyUsers();
        SortedSet<String> other$policyUsers = other.getPolicyUsers();
        if (this$policyUsers == null ? other$policyUsers != null : !this$policyUsers.equals(other$policyUsers)) {
            return false;
        }
        List<AuthPolicyValiditySchedule> this$policyValiditySchedule = this.getPolicyValiditySchedule();
        List<AuthPolicyValiditySchedule> other$policyValiditySchedule = other.getPolicyValiditySchedule();
        return !(this$policyValiditySchedule == null ? other$policyValiditySchedule != null : !((Object)this$policyValiditySchedule).equals(other$policyValiditySchedule));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthPolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isPolicyEnabled = this.getIsPolicyEnabled();
        result = result * 59 + ($isPolicyEnabled == null ? 43 : ((Object)$isPolicyEnabled).hashCode());
        Boolean $policyDelegateAdmin = this.getPolicyDelegateAdmin();
        result = result * 59 + ($policyDelegateAdmin == null ? 43 : ((Object)$policyDelegateAdmin).hashCode());
        Integer $policyPriority = this.getPolicyPriority();
        result = result * 59 + ($policyPriority == null ? 43 : ((Object)$policyPriority).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IAccessControl $accessControl = this.getAccessControl();
        result = result * 59 + ($accessControl == null ? 43 : $accessControl.hashCode());
        SortedSet<AtlanPolicyAction> $policyActions = this.getPolicyActions();
        result = result * 59 + ($policyActions == null ? 43 : $policyActions.hashCode());
        AuthPolicyCategory $policyCategory = this.getPolicyCategory();
        result = result * 59 + ($policyCategory == null ? 43 : $policyCategory.hashCode());
        List<AuthPolicyCondition> $policyConditions = this.getPolicyConditions();
        result = result * 59 + ($policyConditions == null ? 43 : ((Object)$policyConditions).hashCode());
        SortedSet<String> $policyGroups = this.getPolicyGroups();
        result = result * 59 + ($policyGroups == null ? 43 : $policyGroups.hashCode());
        DataMaskingType $policyMaskType = this.getPolicyMaskType();
        result = result * 59 + ($policyMaskType == null ? 43 : $policyMaskType.hashCode());
        AuthPolicyResourceCategory $policyResourceCategory = this.getPolicyResourceCategory();
        result = result * 59 + ($policyResourceCategory == null ? 43 : $policyResourceCategory.hashCode());
        String $policyResourceSignature = this.getPolicyResourceSignature();
        result = result * 59 + ($policyResourceSignature == null ? 43 : $policyResourceSignature.hashCode());
        SortedSet<String> $policyResources = this.getPolicyResources();
        result = result * 59 + ($policyResources == null ? 43 : $policyResources.hashCode());
        SortedSet<String> $policyRoles = this.getPolicyRoles();
        result = result * 59 + ($policyRoles == null ? 43 : $policyRoles.hashCode());
        String $policyServiceName = this.getPolicyServiceName();
        result = result * 59 + ($policyServiceName == null ? 43 : $policyServiceName.hashCode());
        String $policySubCategory = this.getPolicySubCategory();
        result = result * 59 + ($policySubCategory == null ? 43 : $policySubCategory.hashCode());
        AuthPolicyType $policyType = this.getPolicyType();
        result = result * 59 + ($policyType == null ? 43 : $policyType.hashCode());
        SortedSet<String> $policyUsers = this.getPolicyUsers();
        result = result * 59 + ($policyUsers == null ? 43 : $policyUsers.hashCode());
        List<AuthPolicyValiditySchedule> $policyValiditySchedule = this.getPolicyValiditySchedule();
        result = result * 59 + ($policyValiditySchedule == null ? 43 : ((Object)$policyValiditySchedule).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AuthPolicy(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", accessControl=" + String.valueOf(this.getAccessControl()) + ", isPolicyEnabled=" + this.getIsPolicyEnabled() + ", policyActions=" + String.valueOf(this.getPolicyActions()) + ", policyCategory=" + String.valueOf(this.getPolicyCategory()) + ", policyConditions=" + String.valueOf(this.getPolicyConditions()) + ", policyDelegateAdmin=" + this.getPolicyDelegateAdmin() + ", policyGroups=" + String.valueOf(this.getPolicyGroups()) + ", policyMaskType=" + String.valueOf(this.getPolicyMaskType()) + ", policyPriority=" + this.getPolicyPriority() + ", policyResourceCategory=" + String.valueOf(this.getPolicyResourceCategory()) + ", policyResourceSignature=" + this.getPolicyResourceSignature() + ", policyResources=" + String.valueOf(this.getPolicyResources()) + ", policyRoles=" + String.valueOf(this.getPolicyRoles()) + ", policyServiceName=" + this.getPolicyServiceName() + ", policySubCategory=" + this.getPolicySubCategory() + ", policyType=" + String.valueOf(this.getPolicyType()) + ", policyUsers=" + String.valueOf(this.getPolicyUsers()) + ", policyValiditySchedule=" + String.valueOf(this.getPolicyValiditySchedule()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class AuthPolicyBuilder<C extends AuthPolicy, B extends AuthPolicyBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IAccessControl accessControl;
        @Generated
        private Boolean isPolicyEnabled;
        @Generated
        private ArrayList<AtlanPolicyAction> policyActions;
        @Generated
        private AuthPolicyCategory policyCategory;
        @Generated
        private ArrayList<AuthPolicyCondition> policyConditions;
        @Generated
        private Boolean policyDelegateAdmin;
        @Generated
        private ArrayList<String> policyGroups;
        @Generated
        private DataMaskingType policyMaskType;
        @Generated
        private Integer policyPriority;
        @Generated
        private AuthPolicyResourceCategory policyResourceCategory;
        @Generated
        private String policyResourceSignature;
        @Generated
        private ArrayList<String> policyResources;
        @Generated
        private ArrayList<String> policyRoles;
        @Generated
        private String policyServiceName;
        @Generated
        private String policySubCategory;
        @Generated
        private AuthPolicyType policyType;
        @Generated
        private ArrayList<String> policyUsers;
        @Generated
        private ArrayList<AuthPolicyValiditySchedule> policyValiditySchedule;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AuthPolicyBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AuthPolicy instance, AuthPolicyBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.accessControl(instance.accessControl);
            b.isPolicyEnabled(instance.isPolicyEnabled);
            b.policyActions(instance.policyActions == null ? Collections.emptySortedSet() : instance.policyActions);
            b.policyCategory(instance.policyCategory);
            b.policyConditions(instance.policyConditions == null ? Collections.emptyList() : instance.policyConditions);
            b.policyDelegateAdmin(instance.policyDelegateAdmin);
            b.policyGroups(instance.policyGroups == null ? Collections.emptySortedSet() : instance.policyGroups);
            b.policyMaskType(instance.policyMaskType);
            b.policyPriority(instance.policyPriority);
            b.policyResourceCategory(instance.policyResourceCategory);
            b.policyResourceSignature(instance.policyResourceSignature);
            b.policyResources(instance.policyResources == null ? Collections.emptySortedSet() : instance.policyResources);
            b.policyRoles(instance.policyRoles == null ? Collections.emptySortedSet() : instance.policyRoles);
            b.policyServiceName(instance.policyServiceName);
            b.policySubCategory(instance.policySubCategory);
            b.policyType(instance.policyType);
            b.policyUsers(instance.policyUsers == null ? Collections.emptySortedSet() : instance.policyUsers);
            b.policyValiditySchedule(instance.policyValiditySchedule == null ? Collections.emptyList() : instance.policyValiditySchedule);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B accessControl(IAccessControl accessControl) {
            this.accessControl = accessControl;
            return (B)this.self();
        }

        @Generated
        public B isPolicyEnabled(Boolean isPolicyEnabled) {
            this.isPolicyEnabled = isPolicyEnabled;
            return (B)this.self();
        }

        @Generated
        public B policyAction(AtlanPolicyAction policyAction) {
            if (this.policyActions == null) {
                this.policyActions = new ArrayList();
            }
            this.policyActions.add(policyAction);
            return (B)this.self();
        }

        @Generated
        public B policyActions(Collection<? extends AtlanPolicyAction> policyActions) {
            if (policyActions == null) {
                throw new NullPointerException("policyActions cannot be null");
            }
            if (this.policyActions == null) {
                this.policyActions = new ArrayList();
            }
            this.policyActions.addAll(policyActions);
            return (B)this.self();
        }

        @Generated
        public B clearPolicyActions() {
            if (this.policyActions != null) {
                this.policyActions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B policyCategory(AuthPolicyCategory policyCategory) {
            this.policyCategory = policyCategory;
            return (B)this.self();
        }

        @Generated
        public B policyCondition(AuthPolicyCondition policyCondition) {
            if (this.policyConditions == null) {
                this.policyConditions = new ArrayList();
            }
            this.policyConditions.add(policyCondition);
            return (B)this.self();
        }

        @Generated
        public B policyConditions(Collection<? extends AuthPolicyCondition> policyConditions) {
            if (policyConditions == null) {
                throw new NullPointerException("policyConditions cannot be null");
            }
            if (this.policyConditions == null) {
                this.policyConditions = new ArrayList();
            }
            this.policyConditions.addAll(policyConditions);
            return (B)this.self();
        }

        @Generated
        public B clearPolicyConditions() {
            if (this.policyConditions != null) {
                this.policyConditions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B policyDelegateAdmin(Boolean policyDelegateAdmin) {
            this.policyDelegateAdmin = policyDelegateAdmin;
            return (B)this.self();
        }

        @Generated
        public B policyGroup(String policyGroup) {
            if (this.policyGroups == null) {
                this.policyGroups = new ArrayList();
            }
            this.policyGroups.add(policyGroup);
            return (B)this.self();
        }

        @Generated
        public B policyGroups(Collection<? extends String> policyGroups) {
            if (policyGroups == null) {
                throw new NullPointerException("policyGroups cannot be null");
            }
            if (this.policyGroups == null) {
                this.policyGroups = new ArrayList();
            }
            this.policyGroups.addAll(policyGroups);
            return (B)this.self();
        }

        @Generated
        public B clearPolicyGroups() {
            if (this.policyGroups != null) {
                this.policyGroups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B policyMaskType(DataMaskingType policyMaskType) {
            this.policyMaskType = policyMaskType;
            return (B)this.self();
        }

        @Generated
        public B policyPriority(Integer policyPriority) {
            this.policyPriority = policyPriority;
            return (B)this.self();
        }

        @Generated
        public B policyResourceCategory(AuthPolicyResourceCategory policyResourceCategory) {
            this.policyResourceCategory = policyResourceCategory;
            return (B)this.self();
        }

        @Generated
        public B policyResourceSignature(String policyResourceSignature) {
            this.policyResourceSignature = policyResourceSignature;
            return (B)this.self();
        }

        @Generated
        public B policyResource(String policyResource) {
            if (this.policyResources == null) {
                this.policyResources = new ArrayList();
            }
            this.policyResources.add(policyResource);
            return (B)this.self();
        }

        @Generated
        public B policyResources(Collection<? extends String> policyResources) {
            if (policyResources == null) {
                throw new NullPointerException("policyResources cannot be null");
            }
            if (this.policyResources == null) {
                this.policyResources = new ArrayList();
            }
            this.policyResources.addAll(policyResources);
            return (B)this.self();
        }

        @Generated
        public B clearPolicyResources() {
            if (this.policyResources != null) {
                this.policyResources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B policyRole(String policyRole) {
            if (this.policyRoles == null) {
                this.policyRoles = new ArrayList();
            }
            this.policyRoles.add(policyRole);
            return (B)this.self();
        }

        @Generated
        public B policyRoles(Collection<? extends String> policyRoles) {
            if (policyRoles == null) {
                throw new NullPointerException("policyRoles cannot be null");
            }
            if (this.policyRoles == null) {
                this.policyRoles = new ArrayList();
            }
            this.policyRoles.addAll(policyRoles);
            return (B)this.self();
        }

        @Generated
        public B clearPolicyRoles() {
            if (this.policyRoles != null) {
                this.policyRoles.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B policyServiceName(String policyServiceName) {
            this.policyServiceName = policyServiceName;
            return (B)this.self();
        }

        @Generated
        public B policySubCategory(String policySubCategory) {
            this.policySubCategory = policySubCategory;
            return (B)this.self();
        }

        @Generated
        public B policyType(AuthPolicyType policyType) {
            this.policyType = policyType;
            return (B)this.self();
        }

        @Generated
        public B policyUser(String policyUser) {
            if (this.policyUsers == null) {
                this.policyUsers = new ArrayList();
            }
            this.policyUsers.add(policyUser);
            return (B)this.self();
        }

        @Generated
        public B policyUsers(Collection<? extends String> policyUsers) {
            if (policyUsers == null) {
                throw new NullPointerException("policyUsers cannot be null");
            }
            if (this.policyUsers == null) {
                this.policyUsers = new ArrayList();
            }
            this.policyUsers.addAll(policyUsers);
            return (B)this.self();
        }

        @Generated
        public B clearPolicyUsers() {
            if (this.policyUsers != null) {
                this.policyUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B addPolicyValiditySchedule(AuthPolicyValiditySchedule addPolicyValiditySchedule) {
            if (this.policyValiditySchedule == null) {
                this.policyValiditySchedule = new ArrayList();
            }
            this.policyValiditySchedule.add(addPolicyValiditySchedule);
            return (B)this.self();
        }

        @Generated
        public B policyValiditySchedule(Collection<? extends AuthPolicyValiditySchedule> policyValiditySchedule) {
            if (policyValiditySchedule == null) {
                throw new NullPointerException("policyValiditySchedule cannot be null");
            }
            if (this.policyValiditySchedule == null) {
                this.policyValiditySchedule = new ArrayList();
            }
            this.policyValiditySchedule.addAll(policyValiditySchedule);
            return (B)this.self();
        }

        @Generated
        public B clearPolicyValiditySchedule() {
            if (this.policyValiditySchedule != null) {
                this.policyValiditySchedule.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AuthPolicy.AuthPolicyBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", accessControl=" + String.valueOf(this.accessControl) + ", isPolicyEnabled=" + this.isPolicyEnabled + ", policyActions=" + String.valueOf(this.policyActions) + ", policyCategory=" + String.valueOf(this.policyCategory) + ", policyConditions=" + String.valueOf(this.policyConditions) + ", policyDelegateAdmin=" + this.policyDelegateAdmin + ", policyGroups=" + String.valueOf(this.policyGroups) + ", policyMaskType=" + String.valueOf(this.policyMaskType) + ", policyPriority=" + this.policyPriority + ", policyResourceCategory=" + String.valueOf(this.policyResourceCategory) + ", policyResourceSignature=" + this.policyResourceSignature + ", policyResources=" + String.valueOf(this.policyResources) + ", policyRoles=" + String.valueOf(this.policyRoles) + ", policyServiceName=" + this.policyServiceName + ", policySubCategory=" + this.policySubCategory + ", policyType=" + String.valueOf(this.policyType) + ", policyUsers=" + String.valueOf(this.policyUsers) + ", policyValiditySchedule=" + String.valueOf(this.policyValiditySchedule) + ")";
        }
    }

    @Generated
    private static final class AuthPolicyBuilderImpl
    extends AuthPolicyBuilder<AuthPolicy, AuthPolicyBuilderImpl> {
        @Generated
        private AuthPolicyBuilderImpl() {
        }

        @Override
        @Generated
        protected AuthPolicyBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AuthPolicy build() {
            return new AuthPolicy(this);
        }
    }
}

