/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.ICosmosMongoDB;
import com.atlan.model.assets.ICosmosMongoDBAccount;
import com.atlan.model.assets.ICosmosMongoDBDatabase;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.INoSQL;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosmosMongoDBAccount
extends Asset
implements ICosmosMongoDBAccount,
ICosmosMongoDB,
INoSQL,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CosmosMongoDBAccount.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CosmosMongoDBAccount";
    String typeName;
    @Attribute
    String cosmosMongoDBAccountConsistencyPolicy;
    @Attribute
    String cosmosMongoDBAccountDocumentEndpoint;
    @Attribute
    Boolean cosmosMongoDBAccountEnableAutomaticFailover;
    @Attribute
    Boolean cosmosMongoDBAccountEnableMultipleWriteLocations;
    @Attribute
    Boolean cosmosMongoDBAccountEnablePartitionKeyMonitor;
    @Attribute
    String cosmosMongoDBAccountInstanceId;
    @Attribute
    Boolean cosmosMongoDBAccountIsVirtualNetworkFilterEnabled;
    @Attribute
    SortedSet<String> cosmosMongoDBAccountLocations;
    @Attribute
    String cosmosMongoDBAccountMongoEndpoint;
    @Attribute
    String cosmosMongoDBAccountPublicNetworkAccess;
    @Attribute
    SortedSet<String> cosmosMongoDBAccountReadLocations;
    @Attribute
    String cosmosMongoDBAccountResourceGroup;
    @Attribute
    String cosmosMongoDBAccountSubscriptionId;
    @Attribute
    String cosmosMongoDBAccountType;
    @Attribute
    SortedSet<String> cosmosMongoDBAccountWriteLocations;
    @Attribute
    Long cosmosMongoDBDatabaseCount;
    @Attribute
    SortedSet<ICosmosMongoDBDatabase> cosmosMongoDBDatabases;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    String noSQLSchemaDefinition;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public CosmosMongoDBAccount trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return CosmosMongoDBAccount.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return CosmosMongoDBAccount.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return CosmosMongoDBAccount.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return CosmosMongoDBAccount.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static CosmosMongoDBAccount refByGuid(String guid) {
        return CosmosMongoDBAccount.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static CosmosMongoDBAccount refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((CosmosMongoDBAccountBuilder)((CosmosMongoDBAccountBuilder)CosmosMongoDBAccount._internal().guid(guid)).semantic(semantic)).build();
    }

    public static CosmosMongoDBAccount refByQualifiedName(String qualifiedName) {
        return CosmosMongoDBAccount.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static CosmosMongoDBAccount refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((CosmosMongoDBAccountBuilder)((CosmosMongoDBAccountBuilder)CosmosMongoDBAccount._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static CosmosMongoDBAccount get(AtlanClient client, String id) throws AtlanException {
        return CosmosMongoDBAccount.get(client, id, false);
    }

    @JsonIgnore
    public static CosmosMongoDBAccount get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof CosmosMongoDBAccount) {
                return (CosmosMongoDBAccount)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof CosmosMongoDBAccount) {
            return (CosmosMongoDBAccount)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static CosmosMongoDBAccount get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return CosmosMongoDBAccount.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static CosmosMongoDBAccount get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CosmosMongoDBAccount.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof CosmosMongoDBAccount) {
                return (CosmosMongoDBAccount)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CosmosMongoDBAccount.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof CosmosMongoDBAccount) {
            return (CosmosMongoDBAccount)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static CosmosMongoDBAccountBuilder<?, ?> updater(String qualifiedName, String name) {
        return (CosmosMongoDBAccountBuilder)((CosmosMongoDBAccountBuilder)((CosmosMongoDBAccountBuilder)CosmosMongoDBAccount._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public CosmosMongoDBAccountBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        CosmosMongoDBAccount.validateRequired(TYPE_NAME, map);
        return CosmosMongoDBAccount.updater(this.getQualifiedName(), this.getName());
    }

    public static CosmosMongoDBAccount removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CosmosMongoDBAccount)Asset.removeDescription(client, CosmosMongoDBAccount.updater(qualifiedName, name));
    }

    public static CosmosMongoDBAccount removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CosmosMongoDBAccount)Asset.removeUserDescription(client, CosmosMongoDBAccount.updater(qualifiedName, name));
    }

    public static CosmosMongoDBAccount removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CosmosMongoDBAccount)Asset.removeOwners(client, CosmosMongoDBAccount.updater(qualifiedName, name));
    }

    public static CosmosMongoDBAccount updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CosmosMongoDBAccount)Asset.updateCertificate(client, CosmosMongoDBAccount._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static CosmosMongoDBAccount removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CosmosMongoDBAccount)Asset.removeCertificate(client, CosmosMongoDBAccount.updater(qualifiedName, name));
    }

    public static CosmosMongoDBAccount updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CosmosMongoDBAccount)Asset.updateAnnouncement(client, CosmosMongoDBAccount._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static CosmosMongoDBAccount removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CosmosMongoDBAccount)Asset.removeAnnouncement(client, CosmosMongoDBAccount.updater(qualifiedName, name));
    }

    public static CosmosMongoDBAccount replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CosmosMongoDBAccount)Asset.replaceTerms(client, CosmosMongoDBAccount.updater(qualifiedName, name), terms);
    }

    public static CosmosMongoDBAccount appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CosmosMongoDBAccount)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static CosmosMongoDBAccount removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CosmosMongoDBAccount)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static CosmosMongoDBAccount appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CosmosMongoDBAccount)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static CosmosMongoDBAccount appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CosmosMongoDBAccount)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected CosmosMongoDBAccount(CosmosMongoDBAccountBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : CosmosMongoDBAccount.$default$typeName();
        this.cosmosMongoDBAccountConsistencyPolicy = b.cosmosMongoDBAccountConsistencyPolicy;
        this.cosmosMongoDBAccountDocumentEndpoint = b.cosmosMongoDBAccountDocumentEndpoint;
        this.cosmosMongoDBAccountEnableAutomaticFailover = b.cosmosMongoDBAccountEnableAutomaticFailover;
        this.cosmosMongoDBAccountEnableMultipleWriteLocations = b.cosmosMongoDBAccountEnableMultipleWriteLocations;
        this.cosmosMongoDBAccountEnablePartitionKeyMonitor = b.cosmosMongoDBAccountEnablePartitionKeyMonitor;
        this.cosmosMongoDBAccountInstanceId = b.cosmosMongoDBAccountInstanceId;
        this.cosmosMongoDBAccountIsVirtualNetworkFilterEnabled = b.cosmosMongoDBAccountIsVirtualNetworkFilterEnabled;
        SortedSet<String> cosmosMongoDBAccountLocations = new TreeSet<String>();
        if (b.cosmosMongoDBAccountLocations != null) {
            cosmosMongoDBAccountLocations.addAll(b.cosmosMongoDBAccountLocations);
        }
        cosmosMongoDBAccountLocations = Collections.unmodifiableSortedSet(cosmosMongoDBAccountLocations);
        this.cosmosMongoDBAccountLocations = cosmosMongoDBAccountLocations;
        this.cosmosMongoDBAccountMongoEndpoint = b.cosmosMongoDBAccountMongoEndpoint;
        this.cosmosMongoDBAccountPublicNetworkAccess = b.cosmosMongoDBAccountPublicNetworkAccess;
        SortedSet<String> cosmosMongoDBAccountReadLocations = new TreeSet<String>();
        if (b.cosmosMongoDBAccountReadLocations != null) {
            cosmosMongoDBAccountReadLocations.addAll(b.cosmosMongoDBAccountReadLocations);
        }
        cosmosMongoDBAccountReadLocations = Collections.unmodifiableSortedSet(cosmosMongoDBAccountReadLocations);
        this.cosmosMongoDBAccountReadLocations = cosmosMongoDBAccountReadLocations;
        this.cosmosMongoDBAccountResourceGroup = b.cosmosMongoDBAccountResourceGroup;
        this.cosmosMongoDBAccountSubscriptionId = b.cosmosMongoDBAccountSubscriptionId;
        this.cosmosMongoDBAccountType = b.cosmosMongoDBAccountType;
        SortedSet<String> cosmosMongoDBAccountWriteLocations = new TreeSet<String>();
        if (b.cosmosMongoDBAccountWriteLocations != null) {
            cosmosMongoDBAccountWriteLocations.addAll(b.cosmosMongoDBAccountWriteLocations);
        }
        cosmosMongoDBAccountWriteLocations = Collections.unmodifiableSortedSet(cosmosMongoDBAccountWriteLocations);
        this.cosmosMongoDBAccountWriteLocations = cosmosMongoDBAccountWriteLocations;
        this.cosmosMongoDBDatabaseCount = b.cosmosMongoDBDatabaseCount;
        SortedSet<ICosmosMongoDBDatabase> cosmosMongoDBDatabases = new TreeSet<ICosmosMongoDBDatabase>();
        if (b.cosmosMongoDBDatabases != null) {
            cosmosMongoDBDatabases.addAll(b.cosmosMongoDBDatabases);
        }
        cosmosMongoDBDatabases = Collections.unmodifiableSortedSet(cosmosMongoDBDatabases);
        this.cosmosMongoDBDatabases = cosmosMongoDBDatabases;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        this.noSQLSchemaDefinition = b.noSQLSchemaDefinition;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static CosmosMongoDBAccountBuilder<?, ?> _internal() {
        return new CosmosMongoDBAccountBuilderImpl();
    }

    @Generated
    public CosmosMongoDBAccountBuilder<?, ?> toBuilder() {
        return new CosmosMongoDBAccountBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getCosmosMongoDBAccountConsistencyPolicy() {
        return this.cosmosMongoDBAccountConsistencyPolicy;
    }

    @Override
    @Generated
    public String getCosmosMongoDBAccountDocumentEndpoint() {
        return this.cosmosMongoDBAccountDocumentEndpoint;
    }

    @Override
    @Generated
    public Boolean getCosmosMongoDBAccountEnableAutomaticFailover() {
        return this.cosmosMongoDBAccountEnableAutomaticFailover;
    }

    @Override
    @Generated
    public Boolean getCosmosMongoDBAccountEnableMultipleWriteLocations() {
        return this.cosmosMongoDBAccountEnableMultipleWriteLocations;
    }

    @Override
    @Generated
    public Boolean getCosmosMongoDBAccountEnablePartitionKeyMonitor() {
        return this.cosmosMongoDBAccountEnablePartitionKeyMonitor;
    }

    @Override
    @Generated
    public String getCosmosMongoDBAccountInstanceId() {
        return this.cosmosMongoDBAccountInstanceId;
    }

    @Override
    @Generated
    public Boolean getCosmosMongoDBAccountIsVirtualNetworkFilterEnabled() {
        return this.cosmosMongoDBAccountIsVirtualNetworkFilterEnabled;
    }

    @Override
    @Generated
    public SortedSet<String> getCosmosMongoDBAccountLocations() {
        return this.cosmosMongoDBAccountLocations;
    }

    @Override
    @Generated
    public String getCosmosMongoDBAccountMongoEndpoint() {
        return this.cosmosMongoDBAccountMongoEndpoint;
    }

    @Override
    @Generated
    public String getCosmosMongoDBAccountPublicNetworkAccess() {
        return this.cosmosMongoDBAccountPublicNetworkAccess;
    }

    @Override
    @Generated
    public SortedSet<String> getCosmosMongoDBAccountReadLocations() {
        return this.cosmosMongoDBAccountReadLocations;
    }

    @Override
    @Generated
    public String getCosmosMongoDBAccountResourceGroup() {
        return this.cosmosMongoDBAccountResourceGroup;
    }

    @Override
    @Generated
    public String getCosmosMongoDBAccountSubscriptionId() {
        return this.cosmosMongoDBAccountSubscriptionId;
    }

    @Override
    @Generated
    public String getCosmosMongoDBAccountType() {
        return this.cosmosMongoDBAccountType;
    }

    @Override
    @Generated
    public SortedSet<String> getCosmosMongoDBAccountWriteLocations() {
        return this.cosmosMongoDBAccountWriteLocations;
    }

    @Override
    @Generated
    public Long getCosmosMongoDBDatabaseCount() {
        return this.cosmosMongoDBDatabaseCount;
    }

    @Override
    @Generated
    public SortedSet<ICosmosMongoDBDatabase> getCosmosMongoDBDatabases() {
        return this.cosmosMongoDBDatabases;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public String getNoSQLSchemaDefinition() {
        return this.noSQLSchemaDefinition;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CosmosMongoDBAccount)) {
            return false;
        }
        CosmosMongoDBAccount other = (CosmosMongoDBAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$cosmosMongoDBAccountEnableAutomaticFailover = this.getCosmosMongoDBAccountEnableAutomaticFailover();
        Boolean other$cosmosMongoDBAccountEnableAutomaticFailover = other.getCosmosMongoDBAccountEnableAutomaticFailover();
        if (this$cosmosMongoDBAccountEnableAutomaticFailover == null ? other$cosmosMongoDBAccountEnableAutomaticFailover != null : !((Object)this$cosmosMongoDBAccountEnableAutomaticFailover).equals(other$cosmosMongoDBAccountEnableAutomaticFailover)) {
            return false;
        }
        Boolean this$cosmosMongoDBAccountEnableMultipleWriteLocations = this.getCosmosMongoDBAccountEnableMultipleWriteLocations();
        Boolean other$cosmosMongoDBAccountEnableMultipleWriteLocations = other.getCosmosMongoDBAccountEnableMultipleWriteLocations();
        if (this$cosmosMongoDBAccountEnableMultipleWriteLocations == null ? other$cosmosMongoDBAccountEnableMultipleWriteLocations != null : !((Object)this$cosmosMongoDBAccountEnableMultipleWriteLocations).equals(other$cosmosMongoDBAccountEnableMultipleWriteLocations)) {
            return false;
        }
        Boolean this$cosmosMongoDBAccountEnablePartitionKeyMonitor = this.getCosmosMongoDBAccountEnablePartitionKeyMonitor();
        Boolean other$cosmosMongoDBAccountEnablePartitionKeyMonitor = other.getCosmosMongoDBAccountEnablePartitionKeyMonitor();
        if (this$cosmosMongoDBAccountEnablePartitionKeyMonitor == null ? other$cosmosMongoDBAccountEnablePartitionKeyMonitor != null : !((Object)this$cosmosMongoDBAccountEnablePartitionKeyMonitor).equals(other$cosmosMongoDBAccountEnablePartitionKeyMonitor)) {
            return false;
        }
        Boolean this$cosmosMongoDBAccountIsVirtualNetworkFilterEnabled = this.getCosmosMongoDBAccountIsVirtualNetworkFilterEnabled();
        Boolean other$cosmosMongoDBAccountIsVirtualNetworkFilterEnabled = other.getCosmosMongoDBAccountIsVirtualNetworkFilterEnabled();
        if (this$cosmosMongoDBAccountIsVirtualNetworkFilterEnabled == null ? other$cosmosMongoDBAccountIsVirtualNetworkFilterEnabled != null : !((Object)this$cosmosMongoDBAccountIsVirtualNetworkFilterEnabled).equals(other$cosmosMongoDBAccountIsVirtualNetworkFilterEnabled)) {
            return false;
        }
        Long this$cosmosMongoDBDatabaseCount = this.getCosmosMongoDBDatabaseCount();
        Long other$cosmosMongoDBDatabaseCount = other.getCosmosMongoDBDatabaseCount();
        if (this$cosmosMongoDBDatabaseCount == null ? other$cosmosMongoDBDatabaseCount != null : !((Object)this$cosmosMongoDBDatabaseCount).equals(other$cosmosMongoDBDatabaseCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$cosmosMongoDBAccountConsistencyPolicy = this.getCosmosMongoDBAccountConsistencyPolicy();
        String other$cosmosMongoDBAccountConsistencyPolicy = other.getCosmosMongoDBAccountConsistencyPolicy();
        if (this$cosmosMongoDBAccountConsistencyPolicy == null ? other$cosmosMongoDBAccountConsistencyPolicy != null : !this$cosmosMongoDBAccountConsistencyPolicy.equals(other$cosmosMongoDBAccountConsistencyPolicy)) {
            return false;
        }
        String this$cosmosMongoDBAccountDocumentEndpoint = this.getCosmosMongoDBAccountDocumentEndpoint();
        String other$cosmosMongoDBAccountDocumentEndpoint = other.getCosmosMongoDBAccountDocumentEndpoint();
        if (this$cosmosMongoDBAccountDocumentEndpoint == null ? other$cosmosMongoDBAccountDocumentEndpoint != null : !this$cosmosMongoDBAccountDocumentEndpoint.equals(other$cosmosMongoDBAccountDocumentEndpoint)) {
            return false;
        }
        String this$cosmosMongoDBAccountInstanceId = this.getCosmosMongoDBAccountInstanceId();
        String other$cosmosMongoDBAccountInstanceId = other.getCosmosMongoDBAccountInstanceId();
        if (this$cosmosMongoDBAccountInstanceId == null ? other$cosmosMongoDBAccountInstanceId != null : !this$cosmosMongoDBAccountInstanceId.equals(other$cosmosMongoDBAccountInstanceId)) {
            return false;
        }
        SortedSet<String> this$cosmosMongoDBAccountLocations = this.getCosmosMongoDBAccountLocations();
        SortedSet<String> other$cosmosMongoDBAccountLocations = other.getCosmosMongoDBAccountLocations();
        if (this$cosmosMongoDBAccountLocations == null ? other$cosmosMongoDBAccountLocations != null : !this$cosmosMongoDBAccountLocations.equals(other$cosmosMongoDBAccountLocations)) {
            return false;
        }
        String this$cosmosMongoDBAccountMongoEndpoint = this.getCosmosMongoDBAccountMongoEndpoint();
        String other$cosmosMongoDBAccountMongoEndpoint = other.getCosmosMongoDBAccountMongoEndpoint();
        if (this$cosmosMongoDBAccountMongoEndpoint == null ? other$cosmosMongoDBAccountMongoEndpoint != null : !this$cosmosMongoDBAccountMongoEndpoint.equals(other$cosmosMongoDBAccountMongoEndpoint)) {
            return false;
        }
        String this$cosmosMongoDBAccountPublicNetworkAccess = this.getCosmosMongoDBAccountPublicNetworkAccess();
        String other$cosmosMongoDBAccountPublicNetworkAccess = other.getCosmosMongoDBAccountPublicNetworkAccess();
        if (this$cosmosMongoDBAccountPublicNetworkAccess == null ? other$cosmosMongoDBAccountPublicNetworkAccess != null : !this$cosmosMongoDBAccountPublicNetworkAccess.equals(other$cosmosMongoDBAccountPublicNetworkAccess)) {
            return false;
        }
        SortedSet<String> this$cosmosMongoDBAccountReadLocations = this.getCosmosMongoDBAccountReadLocations();
        SortedSet<String> other$cosmosMongoDBAccountReadLocations = other.getCosmosMongoDBAccountReadLocations();
        if (this$cosmosMongoDBAccountReadLocations == null ? other$cosmosMongoDBAccountReadLocations != null : !this$cosmosMongoDBAccountReadLocations.equals(other$cosmosMongoDBAccountReadLocations)) {
            return false;
        }
        String this$cosmosMongoDBAccountResourceGroup = this.getCosmosMongoDBAccountResourceGroup();
        String other$cosmosMongoDBAccountResourceGroup = other.getCosmosMongoDBAccountResourceGroup();
        if (this$cosmosMongoDBAccountResourceGroup == null ? other$cosmosMongoDBAccountResourceGroup != null : !this$cosmosMongoDBAccountResourceGroup.equals(other$cosmosMongoDBAccountResourceGroup)) {
            return false;
        }
        String this$cosmosMongoDBAccountSubscriptionId = this.getCosmosMongoDBAccountSubscriptionId();
        String other$cosmosMongoDBAccountSubscriptionId = other.getCosmosMongoDBAccountSubscriptionId();
        if (this$cosmosMongoDBAccountSubscriptionId == null ? other$cosmosMongoDBAccountSubscriptionId != null : !this$cosmosMongoDBAccountSubscriptionId.equals(other$cosmosMongoDBAccountSubscriptionId)) {
            return false;
        }
        String this$cosmosMongoDBAccountType = this.getCosmosMongoDBAccountType();
        String other$cosmosMongoDBAccountType = other.getCosmosMongoDBAccountType();
        if (this$cosmosMongoDBAccountType == null ? other$cosmosMongoDBAccountType != null : !this$cosmosMongoDBAccountType.equals(other$cosmosMongoDBAccountType)) {
            return false;
        }
        SortedSet<String> this$cosmosMongoDBAccountWriteLocations = this.getCosmosMongoDBAccountWriteLocations();
        SortedSet<String> other$cosmosMongoDBAccountWriteLocations = other.getCosmosMongoDBAccountWriteLocations();
        if (this$cosmosMongoDBAccountWriteLocations == null ? other$cosmosMongoDBAccountWriteLocations != null : !this$cosmosMongoDBAccountWriteLocations.equals(other$cosmosMongoDBAccountWriteLocations)) {
            return false;
        }
        SortedSet<ICosmosMongoDBDatabase> this$cosmosMongoDBDatabases = this.getCosmosMongoDBDatabases();
        SortedSet<ICosmosMongoDBDatabase> other$cosmosMongoDBDatabases = other.getCosmosMongoDBDatabases();
        if (this$cosmosMongoDBDatabases == null ? other$cosmosMongoDBDatabases != null : !this$cosmosMongoDBDatabases.equals(other$cosmosMongoDBDatabases)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        String this$noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        String other$noSQLSchemaDefinition = other.getNoSQLSchemaDefinition();
        if (this$noSQLSchemaDefinition == null ? other$noSQLSchemaDefinition != null : !this$noSQLSchemaDefinition.equals(other$noSQLSchemaDefinition)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CosmosMongoDBAccount;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $cosmosMongoDBAccountEnableAutomaticFailover = this.getCosmosMongoDBAccountEnableAutomaticFailover();
        result = result * 59 + ($cosmosMongoDBAccountEnableAutomaticFailover == null ? 43 : ((Object)$cosmosMongoDBAccountEnableAutomaticFailover).hashCode());
        Boolean $cosmosMongoDBAccountEnableMultipleWriteLocations = this.getCosmosMongoDBAccountEnableMultipleWriteLocations();
        result = result * 59 + ($cosmosMongoDBAccountEnableMultipleWriteLocations == null ? 43 : ((Object)$cosmosMongoDBAccountEnableMultipleWriteLocations).hashCode());
        Boolean $cosmosMongoDBAccountEnablePartitionKeyMonitor = this.getCosmosMongoDBAccountEnablePartitionKeyMonitor();
        result = result * 59 + ($cosmosMongoDBAccountEnablePartitionKeyMonitor == null ? 43 : ((Object)$cosmosMongoDBAccountEnablePartitionKeyMonitor).hashCode());
        Boolean $cosmosMongoDBAccountIsVirtualNetworkFilterEnabled = this.getCosmosMongoDBAccountIsVirtualNetworkFilterEnabled();
        result = result * 59 + ($cosmosMongoDBAccountIsVirtualNetworkFilterEnabled == null ? 43 : ((Object)$cosmosMongoDBAccountIsVirtualNetworkFilterEnabled).hashCode());
        Long $cosmosMongoDBDatabaseCount = this.getCosmosMongoDBDatabaseCount();
        result = result * 59 + ($cosmosMongoDBDatabaseCount == null ? 43 : ((Object)$cosmosMongoDBDatabaseCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $cosmosMongoDBAccountConsistencyPolicy = this.getCosmosMongoDBAccountConsistencyPolicy();
        result = result * 59 + ($cosmosMongoDBAccountConsistencyPolicy == null ? 43 : $cosmosMongoDBAccountConsistencyPolicy.hashCode());
        String $cosmosMongoDBAccountDocumentEndpoint = this.getCosmosMongoDBAccountDocumentEndpoint();
        result = result * 59 + ($cosmosMongoDBAccountDocumentEndpoint == null ? 43 : $cosmosMongoDBAccountDocumentEndpoint.hashCode());
        String $cosmosMongoDBAccountInstanceId = this.getCosmosMongoDBAccountInstanceId();
        result = result * 59 + ($cosmosMongoDBAccountInstanceId == null ? 43 : $cosmosMongoDBAccountInstanceId.hashCode());
        SortedSet<String> $cosmosMongoDBAccountLocations = this.getCosmosMongoDBAccountLocations();
        result = result * 59 + ($cosmosMongoDBAccountLocations == null ? 43 : $cosmosMongoDBAccountLocations.hashCode());
        String $cosmosMongoDBAccountMongoEndpoint = this.getCosmosMongoDBAccountMongoEndpoint();
        result = result * 59 + ($cosmosMongoDBAccountMongoEndpoint == null ? 43 : $cosmosMongoDBAccountMongoEndpoint.hashCode());
        String $cosmosMongoDBAccountPublicNetworkAccess = this.getCosmosMongoDBAccountPublicNetworkAccess();
        result = result * 59 + ($cosmosMongoDBAccountPublicNetworkAccess == null ? 43 : $cosmosMongoDBAccountPublicNetworkAccess.hashCode());
        SortedSet<String> $cosmosMongoDBAccountReadLocations = this.getCosmosMongoDBAccountReadLocations();
        result = result * 59 + ($cosmosMongoDBAccountReadLocations == null ? 43 : $cosmosMongoDBAccountReadLocations.hashCode());
        String $cosmosMongoDBAccountResourceGroup = this.getCosmosMongoDBAccountResourceGroup();
        result = result * 59 + ($cosmosMongoDBAccountResourceGroup == null ? 43 : $cosmosMongoDBAccountResourceGroup.hashCode());
        String $cosmosMongoDBAccountSubscriptionId = this.getCosmosMongoDBAccountSubscriptionId();
        result = result * 59 + ($cosmosMongoDBAccountSubscriptionId == null ? 43 : $cosmosMongoDBAccountSubscriptionId.hashCode());
        String $cosmosMongoDBAccountType = this.getCosmosMongoDBAccountType();
        result = result * 59 + ($cosmosMongoDBAccountType == null ? 43 : $cosmosMongoDBAccountType.hashCode());
        SortedSet<String> $cosmosMongoDBAccountWriteLocations = this.getCosmosMongoDBAccountWriteLocations();
        result = result * 59 + ($cosmosMongoDBAccountWriteLocations == null ? 43 : $cosmosMongoDBAccountWriteLocations.hashCode());
        SortedSet<ICosmosMongoDBDatabase> $cosmosMongoDBDatabases = this.getCosmosMongoDBDatabases();
        result = result * 59 + ($cosmosMongoDBDatabases == null ? 43 : $cosmosMongoDBDatabases.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        String $noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        result = result * 59 + ($noSQLSchemaDefinition == null ? 43 : $noSQLSchemaDefinition.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "CosmosMongoDBAccount(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", cosmosMongoDBAccountConsistencyPolicy=" + this.getCosmosMongoDBAccountConsistencyPolicy() + ", cosmosMongoDBAccountDocumentEndpoint=" + this.getCosmosMongoDBAccountDocumentEndpoint() + ", cosmosMongoDBAccountEnableAutomaticFailover=" + this.getCosmosMongoDBAccountEnableAutomaticFailover() + ", cosmosMongoDBAccountEnableMultipleWriteLocations=" + this.getCosmosMongoDBAccountEnableMultipleWriteLocations() + ", cosmosMongoDBAccountEnablePartitionKeyMonitor=" + this.getCosmosMongoDBAccountEnablePartitionKeyMonitor() + ", cosmosMongoDBAccountInstanceId=" + this.getCosmosMongoDBAccountInstanceId() + ", cosmosMongoDBAccountIsVirtualNetworkFilterEnabled=" + this.getCosmosMongoDBAccountIsVirtualNetworkFilterEnabled() + ", cosmosMongoDBAccountLocations=" + String.valueOf(this.getCosmosMongoDBAccountLocations()) + ", cosmosMongoDBAccountMongoEndpoint=" + this.getCosmosMongoDBAccountMongoEndpoint() + ", cosmosMongoDBAccountPublicNetworkAccess=" + this.getCosmosMongoDBAccountPublicNetworkAccess() + ", cosmosMongoDBAccountReadLocations=" + String.valueOf(this.getCosmosMongoDBAccountReadLocations()) + ", cosmosMongoDBAccountResourceGroup=" + this.getCosmosMongoDBAccountResourceGroup() + ", cosmosMongoDBAccountSubscriptionId=" + this.getCosmosMongoDBAccountSubscriptionId() + ", cosmosMongoDBAccountType=" + this.getCosmosMongoDBAccountType() + ", cosmosMongoDBAccountWriteLocations=" + String.valueOf(this.getCosmosMongoDBAccountWriteLocations()) + ", cosmosMongoDBDatabaseCount=" + this.getCosmosMongoDBDatabaseCount() + ", cosmosMongoDBDatabases=" + String.valueOf(this.getCosmosMongoDBDatabases()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", noSQLSchemaDefinition=" + this.getNoSQLSchemaDefinition() + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class CosmosMongoDBAccountBuilder<C extends CosmosMongoDBAccount, B extends CosmosMongoDBAccountBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String cosmosMongoDBAccountConsistencyPolicy;
        @Generated
        private String cosmosMongoDBAccountDocumentEndpoint;
        @Generated
        private Boolean cosmosMongoDBAccountEnableAutomaticFailover;
        @Generated
        private Boolean cosmosMongoDBAccountEnableMultipleWriteLocations;
        @Generated
        private Boolean cosmosMongoDBAccountEnablePartitionKeyMonitor;
        @Generated
        private String cosmosMongoDBAccountInstanceId;
        @Generated
        private Boolean cosmosMongoDBAccountIsVirtualNetworkFilterEnabled;
        @Generated
        private ArrayList<String> cosmosMongoDBAccountLocations;
        @Generated
        private String cosmosMongoDBAccountMongoEndpoint;
        @Generated
        private String cosmosMongoDBAccountPublicNetworkAccess;
        @Generated
        private ArrayList<String> cosmosMongoDBAccountReadLocations;
        @Generated
        private String cosmosMongoDBAccountResourceGroup;
        @Generated
        private String cosmosMongoDBAccountSubscriptionId;
        @Generated
        private String cosmosMongoDBAccountType;
        @Generated
        private ArrayList<String> cosmosMongoDBAccountWriteLocations;
        @Generated
        private Long cosmosMongoDBDatabaseCount;
        @Generated
        private ArrayList<ICosmosMongoDBDatabase> cosmosMongoDBDatabases;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private String noSQLSchemaDefinition;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CosmosMongoDBAccountBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CosmosMongoDBAccount instance, CosmosMongoDBAccountBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.cosmosMongoDBAccountConsistencyPolicy(instance.cosmosMongoDBAccountConsistencyPolicy);
            b.cosmosMongoDBAccountDocumentEndpoint(instance.cosmosMongoDBAccountDocumentEndpoint);
            b.cosmosMongoDBAccountEnableAutomaticFailover(instance.cosmosMongoDBAccountEnableAutomaticFailover);
            b.cosmosMongoDBAccountEnableMultipleWriteLocations(instance.cosmosMongoDBAccountEnableMultipleWriteLocations);
            b.cosmosMongoDBAccountEnablePartitionKeyMonitor(instance.cosmosMongoDBAccountEnablePartitionKeyMonitor);
            b.cosmosMongoDBAccountInstanceId(instance.cosmosMongoDBAccountInstanceId);
            b.cosmosMongoDBAccountIsVirtualNetworkFilterEnabled(instance.cosmosMongoDBAccountIsVirtualNetworkFilterEnabled);
            b.cosmosMongoDBAccountLocations(instance.cosmosMongoDBAccountLocations == null ? Collections.emptySortedSet() : instance.cosmosMongoDBAccountLocations);
            b.cosmosMongoDBAccountMongoEndpoint(instance.cosmosMongoDBAccountMongoEndpoint);
            b.cosmosMongoDBAccountPublicNetworkAccess(instance.cosmosMongoDBAccountPublicNetworkAccess);
            b.cosmosMongoDBAccountReadLocations(instance.cosmosMongoDBAccountReadLocations == null ? Collections.emptySortedSet() : instance.cosmosMongoDBAccountReadLocations);
            b.cosmosMongoDBAccountResourceGroup(instance.cosmosMongoDBAccountResourceGroup);
            b.cosmosMongoDBAccountSubscriptionId(instance.cosmosMongoDBAccountSubscriptionId);
            b.cosmosMongoDBAccountType(instance.cosmosMongoDBAccountType);
            b.cosmosMongoDBAccountWriteLocations(instance.cosmosMongoDBAccountWriteLocations == null ? Collections.emptySortedSet() : instance.cosmosMongoDBAccountWriteLocations);
            b.cosmosMongoDBDatabaseCount(instance.cosmosMongoDBDatabaseCount);
            b.cosmosMongoDBDatabases(instance.cosmosMongoDBDatabases == null ? Collections.emptySortedSet() : instance.cosmosMongoDBDatabases);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.noSQLSchemaDefinition(instance.noSQLSchemaDefinition);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountConsistencyPolicy(String cosmosMongoDBAccountConsistencyPolicy) {
            this.cosmosMongoDBAccountConsistencyPolicy = cosmosMongoDBAccountConsistencyPolicy;
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountDocumentEndpoint(String cosmosMongoDBAccountDocumentEndpoint) {
            this.cosmosMongoDBAccountDocumentEndpoint = cosmosMongoDBAccountDocumentEndpoint;
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountEnableAutomaticFailover(Boolean cosmosMongoDBAccountEnableAutomaticFailover) {
            this.cosmosMongoDBAccountEnableAutomaticFailover = cosmosMongoDBAccountEnableAutomaticFailover;
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountEnableMultipleWriteLocations(Boolean cosmosMongoDBAccountEnableMultipleWriteLocations) {
            this.cosmosMongoDBAccountEnableMultipleWriteLocations = cosmosMongoDBAccountEnableMultipleWriteLocations;
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountEnablePartitionKeyMonitor(Boolean cosmosMongoDBAccountEnablePartitionKeyMonitor) {
            this.cosmosMongoDBAccountEnablePartitionKeyMonitor = cosmosMongoDBAccountEnablePartitionKeyMonitor;
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountInstanceId(String cosmosMongoDBAccountInstanceId) {
            this.cosmosMongoDBAccountInstanceId = cosmosMongoDBAccountInstanceId;
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountIsVirtualNetworkFilterEnabled(Boolean cosmosMongoDBAccountIsVirtualNetworkFilterEnabled) {
            this.cosmosMongoDBAccountIsVirtualNetworkFilterEnabled = cosmosMongoDBAccountIsVirtualNetworkFilterEnabled;
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountLocation(String cosmosMongoDBAccountLocation) {
            if (this.cosmosMongoDBAccountLocations == null) {
                this.cosmosMongoDBAccountLocations = new ArrayList();
            }
            this.cosmosMongoDBAccountLocations.add(cosmosMongoDBAccountLocation);
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountLocations(Collection<? extends String> cosmosMongoDBAccountLocations) {
            if (cosmosMongoDBAccountLocations == null) {
                throw new NullPointerException("cosmosMongoDBAccountLocations cannot be null");
            }
            if (this.cosmosMongoDBAccountLocations == null) {
                this.cosmosMongoDBAccountLocations = new ArrayList();
            }
            this.cosmosMongoDBAccountLocations.addAll(cosmosMongoDBAccountLocations);
            return (B)this.self();
        }

        @Generated
        public B clearCosmosMongoDBAccountLocations() {
            if (this.cosmosMongoDBAccountLocations != null) {
                this.cosmosMongoDBAccountLocations.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountMongoEndpoint(String cosmosMongoDBAccountMongoEndpoint) {
            this.cosmosMongoDBAccountMongoEndpoint = cosmosMongoDBAccountMongoEndpoint;
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountPublicNetworkAccess(String cosmosMongoDBAccountPublicNetworkAccess) {
            this.cosmosMongoDBAccountPublicNetworkAccess = cosmosMongoDBAccountPublicNetworkAccess;
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountReadLocation(String cosmosMongoDBAccountReadLocation) {
            if (this.cosmosMongoDBAccountReadLocations == null) {
                this.cosmosMongoDBAccountReadLocations = new ArrayList();
            }
            this.cosmosMongoDBAccountReadLocations.add(cosmosMongoDBAccountReadLocation);
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountReadLocations(Collection<? extends String> cosmosMongoDBAccountReadLocations) {
            if (cosmosMongoDBAccountReadLocations == null) {
                throw new NullPointerException("cosmosMongoDBAccountReadLocations cannot be null");
            }
            if (this.cosmosMongoDBAccountReadLocations == null) {
                this.cosmosMongoDBAccountReadLocations = new ArrayList();
            }
            this.cosmosMongoDBAccountReadLocations.addAll(cosmosMongoDBAccountReadLocations);
            return (B)this.self();
        }

        @Generated
        public B clearCosmosMongoDBAccountReadLocations() {
            if (this.cosmosMongoDBAccountReadLocations != null) {
                this.cosmosMongoDBAccountReadLocations.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountResourceGroup(String cosmosMongoDBAccountResourceGroup) {
            this.cosmosMongoDBAccountResourceGroup = cosmosMongoDBAccountResourceGroup;
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountSubscriptionId(String cosmosMongoDBAccountSubscriptionId) {
            this.cosmosMongoDBAccountSubscriptionId = cosmosMongoDBAccountSubscriptionId;
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountType(String cosmosMongoDBAccountType) {
            this.cosmosMongoDBAccountType = cosmosMongoDBAccountType;
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountWriteLocation(String cosmosMongoDBAccountWriteLocation) {
            if (this.cosmosMongoDBAccountWriteLocations == null) {
                this.cosmosMongoDBAccountWriteLocations = new ArrayList();
            }
            this.cosmosMongoDBAccountWriteLocations.add(cosmosMongoDBAccountWriteLocation);
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBAccountWriteLocations(Collection<? extends String> cosmosMongoDBAccountWriteLocations) {
            if (cosmosMongoDBAccountWriteLocations == null) {
                throw new NullPointerException("cosmosMongoDBAccountWriteLocations cannot be null");
            }
            if (this.cosmosMongoDBAccountWriteLocations == null) {
                this.cosmosMongoDBAccountWriteLocations = new ArrayList();
            }
            this.cosmosMongoDBAccountWriteLocations.addAll(cosmosMongoDBAccountWriteLocations);
            return (B)this.self();
        }

        @Generated
        public B clearCosmosMongoDBAccountWriteLocations() {
            if (this.cosmosMongoDBAccountWriteLocations != null) {
                this.cosmosMongoDBAccountWriteLocations.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBDatabaseCount(Long cosmosMongoDBDatabaseCount) {
            this.cosmosMongoDBDatabaseCount = cosmosMongoDBDatabaseCount;
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBDatabase(ICosmosMongoDBDatabase cosmosMongoDBDatabase) {
            if (this.cosmosMongoDBDatabases == null) {
                this.cosmosMongoDBDatabases = new ArrayList();
            }
            this.cosmosMongoDBDatabases.add(cosmosMongoDBDatabase);
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBDatabases(Collection<? extends ICosmosMongoDBDatabase> cosmosMongoDBDatabases) {
            if (cosmosMongoDBDatabases == null) {
                throw new NullPointerException("cosmosMongoDBDatabases cannot be null");
            }
            if (this.cosmosMongoDBDatabases == null) {
                this.cosmosMongoDBDatabases = new ArrayList();
            }
            this.cosmosMongoDBDatabases.addAll(cosmosMongoDBDatabases);
            return (B)this.self();
        }

        @Generated
        public B clearCosmosMongoDBDatabases() {
            if (this.cosmosMongoDBDatabases != null) {
                this.cosmosMongoDBDatabases.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B noSQLSchemaDefinition(String noSQLSchemaDefinition) {
            this.noSQLSchemaDefinition = noSQLSchemaDefinition;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CosmosMongoDBAccount.CosmosMongoDBAccountBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", cosmosMongoDBAccountConsistencyPolicy=" + this.cosmosMongoDBAccountConsistencyPolicy + ", cosmosMongoDBAccountDocumentEndpoint=" + this.cosmosMongoDBAccountDocumentEndpoint + ", cosmosMongoDBAccountEnableAutomaticFailover=" + this.cosmosMongoDBAccountEnableAutomaticFailover + ", cosmosMongoDBAccountEnableMultipleWriteLocations=" + this.cosmosMongoDBAccountEnableMultipleWriteLocations + ", cosmosMongoDBAccountEnablePartitionKeyMonitor=" + this.cosmosMongoDBAccountEnablePartitionKeyMonitor + ", cosmosMongoDBAccountInstanceId=" + this.cosmosMongoDBAccountInstanceId + ", cosmosMongoDBAccountIsVirtualNetworkFilterEnabled=" + this.cosmosMongoDBAccountIsVirtualNetworkFilterEnabled + ", cosmosMongoDBAccountLocations=" + String.valueOf(this.cosmosMongoDBAccountLocations) + ", cosmosMongoDBAccountMongoEndpoint=" + this.cosmosMongoDBAccountMongoEndpoint + ", cosmosMongoDBAccountPublicNetworkAccess=" + this.cosmosMongoDBAccountPublicNetworkAccess + ", cosmosMongoDBAccountReadLocations=" + String.valueOf(this.cosmosMongoDBAccountReadLocations) + ", cosmosMongoDBAccountResourceGroup=" + this.cosmosMongoDBAccountResourceGroup + ", cosmosMongoDBAccountSubscriptionId=" + this.cosmosMongoDBAccountSubscriptionId + ", cosmosMongoDBAccountType=" + this.cosmosMongoDBAccountType + ", cosmosMongoDBAccountWriteLocations=" + String.valueOf(this.cosmosMongoDBAccountWriteLocations) + ", cosmosMongoDBDatabaseCount=" + this.cosmosMongoDBDatabaseCount + ", cosmosMongoDBDatabases=" + String.valueOf(this.cosmosMongoDBDatabases) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", noSQLSchemaDefinition=" + this.noSQLSchemaDefinition + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class CosmosMongoDBAccountBuilderImpl
    extends CosmosMongoDBAccountBuilder<CosmosMongoDBAccount, CosmosMongoDBAccountBuilderImpl> {
        @Generated
        private CosmosMongoDBAccountBuilderImpl() {
        }

        @Override
        @Generated
        protected CosmosMongoDBAccountBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CosmosMongoDBAccount build() {
            return new CosmosMongoDBAccount(this);
        }
    }
}

