/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.DataverseEntity;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDataverse;
import com.atlan.model.assets.IDataverseAttribute;
import com.atlan.model.assets.IDataverseEntity;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISaaS;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataverseAttribute
extends Asset
implements IDataverseAttribute,
IDataverse,
ISaaS,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataverseAttribute.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DataverseAttribute";
    String typeName;
    @Attribute
    Boolean dataverseAttributeIsPrimaryId;
    @Attribute
    Boolean dataverseAttributeIsSearchable;
    @Attribute
    String dataverseAttributeSchemaName;
    @Attribute
    String dataverseAttributeType;
    @Attribute
    IDataverseEntity dataverseEntity;
    @Attribute
    String dataverseEntityQualifiedName;
    @Attribute
    Boolean dataverseIsAuditEnabled;
    @Attribute
    Boolean dataverseIsCustom;
    @Attribute
    Boolean dataverseIsCustomizable;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public DataverseAttribute trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DataverseAttribute.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DataverseAttribute.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DataverseAttribute.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DataverseAttribute.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static DataverseAttribute refByGuid(String guid) {
        return DataverseAttribute.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static DataverseAttribute refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((DataverseAttributeBuilder)((DataverseAttributeBuilder)DataverseAttribute._internal().guid(guid)).semantic(semantic)).build();
    }

    public static DataverseAttribute refByQualifiedName(String qualifiedName) {
        return DataverseAttribute.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static DataverseAttribute refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((DataverseAttributeBuilder)((DataverseAttributeBuilder)DataverseAttribute._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static DataverseAttribute get(AtlanClient client, String id) throws AtlanException {
        return DataverseAttribute.get(client, id, false);
    }

    @JsonIgnore
    public static DataverseAttribute get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DataverseAttribute) {
                return (DataverseAttribute)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof DataverseAttribute) {
            return (DataverseAttribute)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static DataverseAttribute get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return DataverseAttribute.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static DataverseAttribute get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DataverseAttribute.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof DataverseAttribute) {
                return (DataverseAttribute)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DataverseAttribute.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof DataverseAttribute) {
            return (DataverseAttribute)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DataverseAttributeBuilder<?, ?> creator(String name, DataverseEntity entity) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("entityQualifiedName", entity.getQualifiedName());
        map.put("entityName", entity.getName());
        map.put("connectionQualifiedName", entity.getConnectionQualifiedName());
        DataverseAttribute.validateRelationship("DataverseEntity", map);
        return DataverseAttribute.creator(name, entity.getConnectionQualifiedName(), entity.getQualifiedName()).dataverseEntity(entity.trimToReference());
    }

    public static DataverseAttributeBuilder<?, ?> creator(String name, String entityQualifiedName) {
        String entityName = StringUtils.getNameFromQualifiedName(entityQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(entityQualifiedName);
        return DataverseAttribute.creator(name, connectionQualifiedName, entityQualifiedName);
    }

    public static DataverseAttributeBuilder<?, ?> creator(String name, String connectionQualifiedName, String entityQualifiedName) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        return ((DataverseAttributeBuilder)((DataverseAttributeBuilder)((DataverseAttributeBuilder)((DataverseAttributeBuilder)((DataverseAttributeBuilder)((DataverseAttributeBuilder)DataverseAttribute._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).qualifiedName(DataverseAttribute.generateQualifiedName(name, entityQualifiedName))).connectionQualifiedName(connectionQualifiedName)).connectorType(connectorType)).dataverseEntityQualifiedName(entityQualifiedName)).dataverseEntity(DataverseEntity.refByQualifiedName(entityQualifiedName));
    }

    public static String generateQualifiedName(String name, String entityQualifiedName) {
        return entityQualifiedName + "/" + name;
    }

    public static DataverseAttributeBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DataverseAttributeBuilder)((DataverseAttributeBuilder)((DataverseAttributeBuilder)DataverseAttribute._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public DataverseAttributeBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        DataverseAttribute.validateRequired(TYPE_NAME, map);
        return DataverseAttribute.updater(this.getQualifiedName(), this.getName());
    }

    public static DataverseAttribute removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataverseAttribute)Asset.removeDescription(client, DataverseAttribute.updater(qualifiedName, name));
    }

    public static DataverseAttribute removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataverseAttribute)Asset.removeUserDescription(client, DataverseAttribute.updater(qualifiedName, name));
    }

    public static DataverseAttribute removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataverseAttribute)Asset.removeOwners(client, DataverseAttribute.updater(qualifiedName, name));
    }

    public static DataverseAttribute updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DataverseAttribute)Asset.updateCertificate(client, DataverseAttribute._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DataverseAttribute removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataverseAttribute)Asset.removeCertificate(client, DataverseAttribute.updater(qualifiedName, name));
    }

    public static DataverseAttribute updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DataverseAttribute)Asset.updateAnnouncement(client, DataverseAttribute._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DataverseAttribute removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataverseAttribute)Asset.removeAnnouncement(client, DataverseAttribute.updater(qualifiedName, name));
    }

    public static DataverseAttribute replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataverseAttribute)Asset.replaceTerms(client, DataverseAttribute.updater(qualifiedName, name), terms);
    }

    public static DataverseAttribute appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataverseAttribute)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DataverseAttribute removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataverseAttribute)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DataverseAttribute appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DataverseAttribute)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static DataverseAttribute appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DataverseAttribute)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DataverseAttribute(DataverseAttributeBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DataverseAttribute.$default$typeName();
        this.dataverseAttributeIsPrimaryId = b.dataverseAttributeIsPrimaryId;
        this.dataverseAttributeIsSearchable = b.dataverseAttributeIsSearchable;
        this.dataverseAttributeSchemaName = b.dataverseAttributeSchemaName;
        this.dataverseAttributeType = b.dataverseAttributeType;
        this.dataverseEntity = b.dataverseEntity;
        this.dataverseEntityQualifiedName = b.dataverseEntityQualifiedName;
        this.dataverseIsAuditEnabled = b.dataverseIsAuditEnabled;
        this.dataverseIsCustom = b.dataverseIsCustom;
        this.dataverseIsCustomizable = b.dataverseIsCustomizable;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static DataverseAttributeBuilder<?, ?> _internal() {
        return new DataverseAttributeBuilderImpl();
    }

    @Generated
    public DataverseAttributeBuilder<?, ?> toBuilder() {
        return new DataverseAttributeBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Boolean getDataverseAttributeIsPrimaryId() {
        return this.dataverseAttributeIsPrimaryId;
    }

    @Override
    @Generated
    public Boolean getDataverseAttributeIsSearchable() {
        return this.dataverseAttributeIsSearchable;
    }

    @Override
    @Generated
    public String getDataverseAttributeSchemaName() {
        return this.dataverseAttributeSchemaName;
    }

    @Override
    @Generated
    public String getDataverseAttributeType() {
        return this.dataverseAttributeType;
    }

    @Override
    @Generated
    public IDataverseEntity getDataverseEntity() {
        return this.dataverseEntity;
    }

    @Override
    @Generated
    public String getDataverseEntityQualifiedName() {
        return this.dataverseEntityQualifiedName;
    }

    @Override
    @Generated
    public Boolean getDataverseIsAuditEnabled() {
        return this.dataverseIsAuditEnabled;
    }

    @Override
    @Generated
    public Boolean getDataverseIsCustom() {
        return this.dataverseIsCustom;
    }

    @Override
    @Generated
    public Boolean getDataverseIsCustomizable() {
        return this.dataverseIsCustomizable;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataverseAttribute)) {
            return false;
        }
        DataverseAttribute other = (DataverseAttribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$dataverseAttributeIsPrimaryId = this.getDataverseAttributeIsPrimaryId();
        Boolean other$dataverseAttributeIsPrimaryId = other.getDataverseAttributeIsPrimaryId();
        if (this$dataverseAttributeIsPrimaryId == null ? other$dataverseAttributeIsPrimaryId != null : !((Object)this$dataverseAttributeIsPrimaryId).equals(other$dataverseAttributeIsPrimaryId)) {
            return false;
        }
        Boolean this$dataverseAttributeIsSearchable = this.getDataverseAttributeIsSearchable();
        Boolean other$dataverseAttributeIsSearchable = other.getDataverseAttributeIsSearchable();
        if (this$dataverseAttributeIsSearchable == null ? other$dataverseAttributeIsSearchable != null : !((Object)this$dataverseAttributeIsSearchable).equals(other$dataverseAttributeIsSearchable)) {
            return false;
        }
        Boolean this$dataverseIsAuditEnabled = this.getDataverseIsAuditEnabled();
        Boolean other$dataverseIsAuditEnabled = other.getDataverseIsAuditEnabled();
        if (this$dataverseIsAuditEnabled == null ? other$dataverseIsAuditEnabled != null : !((Object)this$dataverseIsAuditEnabled).equals(other$dataverseIsAuditEnabled)) {
            return false;
        }
        Boolean this$dataverseIsCustom = this.getDataverseIsCustom();
        Boolean other$dataverseIsCustom = other.getDataverseIsCustom();
        if (this$dataverseIsCustom == null ? other$dataverseIsCustom != null : !((Object)this$dataverseIsCustom).equals(other$dataverseIsCustom)) {
            return false;
        }
        Boolean this$dataverseIsCustomizable = this.getDataverseIsCustomizable();
        Boolean other$dataverseIsCustomizable = other.getDataverseIsCustomizable();
        if (this$dataverseIsCustomizable == null ? other$dataverseIsCustomizable != null : !((Object)this$dataverseIsCustomizable).equals(other$dataverseIsCustomizable)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$dataverseAttributeSchemaName = this.getDataverseAttributeSchemaName();
        String other$dataverseAttributeSchemaName = other.getDataverseAttributeSchemaName();
        if (this$dataverseAttributeSchemaName == null ? other$dataverseAttributeSchemaName != null : !this$dataverseAttributeSchemaName.equals(other$dataverseAttributeSchemaName)) {
            return false;
        }
        String this$dataverseAttributeType = this.getDataverseAttributeType();
        String other$dataverseAttributeType = other.getDataverseAttributeType();
        if (this$dataverseAttributeType == null ? other$dataverseAttributeType != null : !this$dataverseAttributeType.equals(other$dataverseAttributeType)) {
            return false;
        }
        IDataverseEntity this$dataverseEntity = this.getDataverseEntity();
        IDataverseEntity other$dataverseEntity = other.getDataverseEntity();
        if (this$dataverseEntity == null ? other$dataverseEntity != null : !this$dataverseEntity.equals(other$dataverseEntity)) {
            return false;
        }
        String this$dataverseEntityQualifiedName = this.getDataverseEntityQualifiedName();
        String other$dataverseEntityQualifiedName = other.getDataverseEntityQualifiedName();
        if (this$dataverseEntityQualifiedName == null ? other$dataverseEntityQualifiedName != null : !this$dataverseEntityQualifiedName.equals(other$dataverseEntityQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataverseAttribute;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $dataverseAttributeIsPrimaryId = this.getDataverseAttributeIsPrimaryId();
        result = result * 59 + ($dataverseAttributeIsPrimaryId == null ? 43 : ((Object)$dataverseAttributeIsPrimaryId).hashCode());
        Boolean $dataverseAttributeIsSearchable = this.getDataverseAttributeIsSearchable();
        result = result * 59 + ($dataverseAttributeIsSearchable == null ? 43 : ((Object)$dataverseAttributeIsSearchable).hashCode());
        Boolean $dataverseIsAuditEnabled = this.getDataverseIsAuditEnabled();
        result = result * 59 + ($dataverseIsAuditEnabled == null ? 43 : ((Object)$dataverseIsAuditEnabled).hashCode());
        Boolean $dataverseIsCustom = this.getDataverseIsCustom();
        result = result * 59 + ($dataverseIsCustom == null ? 43 : ((Object)$dataverseIsCustom).hashCode());
        Boolean $dataverseIsCustomizable = this.getDataverseIsCustomizable();
        result = result * 59 + ($dataverseIsCustomizable == null ? 43 : ((Object)$dataverseIsCustomizable).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $dataverseAttributeSchemaName = this.getDataverseAttributeSchemaName();
        result = result * 59 + ($dataverseAttributeSchemaName == null ? 43 : $dataverseAttributeSchemaName.hashCode());
        String $dataverseAttributeType = this.getDataverseAttributeType();
        result = result * 59 + ($dataverseAttributeType == null ? 43 : $dataverseAttributeType.hashCode());
        IDataverseEntity $dataverseEntity = this.getDataverseEntity();
        result = result * 59 + ($dataverseEntity == null ? 43 : $dataverseEntity.hashCode());
        String $dataverseEntityQualifiedName = this.getDataverseEntityQualifiedName();
        result = result * 59 + ($dataverseEntityQualifiedName == null ? 43 : $dataverseEntityQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DataverseAttribute(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dataverseAttributeIsPrimaryId=" + this.getDataverseAttributeIsPrimaryId() + ", dataverseAttributeIsSearchable=" + this.getDataverseAttributeIsSearchable() + ", dataverseAttributeSchemaName=" + this.getDataverseAttributeSchemaName() + ", dataverseAttributeType=" + this.getDataverseAttributeType() + ", dataverseEntity=" + String.valueOf(this.getDataverseEntity()) + ", dataverseEntityQualifiedName=" + this.getDataverseEntityQualifiedName() + ", dataverseIsAuditEnabled=" + this.getDataverseIsAuditEnabled() + ", dataverseIsCustom=" + this.getDataverseIsCustom() + ", dataverseIsCustomizable=" + this.getDataverseIsCustomizable() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class DataverseAttributeBuilder<C extends DataverseAttribute, B extends DataverseAttributeBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Boolean dataverseAttributeIsPrimaryId;
        @Generated
        private Boolean dataverseAttributeIsSearchable;
        @Generated
        private String dataverseAttributeSchemaName;
        @Generated
        private String dataverseAttributeType;
        @Generated
        private IDataverseEntity dataverseEntity;
        @Generated
        private String dataverseEntityQualifiedName;
        @Generated
        private Boolean dataverseIsAuditEnabled;
        @Generated
        private Boolean dataverseIsCustom;
        @Generated
        private Boolean dataverseIsCustomizable;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DataverseAttributeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DataverseAttribute instance, DataverseAttributeBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dataverseAttributeIsPrimaryId(instance.dataverseAttributeIsPrimaryId);
            b.dataverseAttributeIsSearchable(instance.dataverseAttributeIsSearchable);
            b.dataverseAttributeSchemaName(instance.dataverseAttributeSchemaName);
            b.dataverseAttributeType(instance.dataverseAttributeType);
            b.dataverseEntity(instance.dataverseEntity);
            b.dataverseEntityQualifiedName(instance.dataverseEntityQualifiedName);
            b.dataverseIsAuditEnabled(instance.dataverseIsAuditEnabled);
            b.dataverseIsCustom(instance.dataverseIsCustom);
            b.dataverseIsCustomizable(instance.dataverseIsCustomizable);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dataverseAttributeIsPrimaryId(Boolean dataverseAttributeIsPrimaryId) {
            this.dataverseAttributeIsPrimaryId = dataverseAttributeIsPrimaryId;
            return (B)this.self();
        }

        @Generated
        public B dataverseAttributeIsSearchable(Boolean dataverseAttributeIsSearchable) {
            this.dataverseAttributeIsSearchable = dataverseAttributeIsSearchable;
            return (B)this.self();
        }

        @Generated
        public B dataverseAttributeSchemaName(String dataverseAttributeSchemaName) {
            this.dataverseAttributeSchemaName = dataverseAttributeSchemaName;
            return (B)this.self();
        }

        @Generated
        public B dataverseAttributeType(String dataverseAttributeType) {
            this.dataverseAttributeType = dataverseAttributeType;
            return (B)this.self();
        }

        @Generated
        public B dataverseEntity(IDataverseEntity dataverseEntity) {
            this.dataverseEntity = dataverseEntity;
            return (B)this.self();
        }

        @Generated
        public B dataverseEntityQualifiedName(String dataverseEntityQualifiedName) {
            this.dataverseEntityQualifiedName = dataverseEntityQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dataverseIsAuditEnabled(Boolean dataverseIsAuditEnabled) {
            this.dataverseIsAuditEnabled = dataverseIsAuditEnabled;
            return (B)this.self();
        }

        @Generated
        public B dataverseIsCustom(Boolean dataverseIsCustom) {
            this.dataverseIsCustom = dataverseIsCustom;
            return (B)this.self();
        }

        @Generated
        public B dataverseIsCustomizable(Boolean dataverseIsCustomizable) {
            this.dataverseIsCustomizable = dataverseIsCustomizable;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DataverseAttribute.DataverseAttributeBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dataverseAttributeIsPrimaryId=" + this.dataverseAttributeIsPrimaryId + ", dataverseAttributeIsSearchable=" + this.dataverseAttributeIsSearchable + ", dataverseAttributeSchemaName=" + this.dataverseAttributeSchemaName + ", dataverseAttributeType=" + this.dataverseAttributeType + ", dataverseEntity=" + String.valueOf(this.dataverseEntity) + ", dataverseEntityQualifiedName=" + this.dataverseEntityQualifiedName + ", dataverseIsAuditEnabled=" + this.dataverseIsAuditEnabled + ", dataverseIsCustom=" + this.dataverseIsCustom + ", dataverseIsCustomizable=" + this.dataverseIsCustomizable + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class DataverseAttributeBuilderImpl
    extends DataverseAttributeBuilder<DataverseAttribute, DataverseAttributeBuilderImpl> {
        @Generated
        private DataverseAttributeBuilderImpl() {
        }

        @Override
        @Generated
        protected DataverseAttributeBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DataverseAttribute build() {
            return new DataverseAttribute(this);
        }
    }
}

