/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IColumn;
import com.atlan.model.assets.IDataQuality;
import com.atlan.model.assets.IDbt;
import com.atlan.model.assets.IDbtMetric;
import com.atlan.model.assets.IDbtModel;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMetric;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.DbtJobRun;
import com.atlan.model.structs.DbtMetricFilter;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbtMetric
extends Asset
implements IDbtMetric,
IDbt,
IMetric,
ICatalog,
IAsset,
IReferenceable,
IDataQuality {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DbtMetric.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DbtMetric";
    String typeName;
    @Attribute
    SortedSet<IAsset> assets;
    @Attribute
    String dbtAccountName;
    @Attribute
    String dbtAlias;
    @Attribute
    String dbtConnectionContext;
    @Attribute
    String dbtEnvironmentDbtVersion;
    @Attribute
    String dbtEnvironmentName;
    @Attribute
    @Date
    Long dbtJobLastRun;
    @Attribute
    String dbtJobName;
    @Attribute
    @Date
    Long dbtJobNextRun;
    @Attribute
    String dbtJobNextRunHumanized;
    @Attribute
    List<DbtJobRun> dbtJobRuns;
    @Attribute
    String dbtJobSchedule;
    @Attribute
    String dbtJobScheduleCronHumanized;
    @Attribute
    String dbtJobStatus;
    @Attribute
    String dbtMeta;
    @Attribute
    SortedSet<IColumn> dbtMetricFilterColumns;
    @Attribute
    List<DbtMetricFilter> dbtMetricFilters;
    @Attribute
    IDbtModel dbtModel;
    @Attribute
    String dbtPackageName;
    @Attribute
    String dbtProjectName;
    @Attribute
    String dbtSemanticLayerProxyUrl;
    @Attribute
    SortedSet<String> dbtTags;
    @Attribute
    String dbtUniqueId;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IColumn> metricDimensionColumns;
    @Attribute
    String metricFilters;
    @Attribute
    String metricSQL;
    @Attribute
    SortedSet<String> metricTimeGrains;
    @Attribute
    IColumn metricTimestampColumn;
    @Attribute
    String metricType;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public DbtMetric trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DbtMetric.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DbtMetric.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DbtMetric.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DbtMetric.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static DbtMetric refByGuid(String guid) {
        return DbtMetric.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static DbtMetric refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((DbtMetricBuilder)((DbtMetricBuilder)DbtMetric._internal().guid(guid)).semantic(semantic)).build();
    }

    public static DbtMetric refByQualifiedName(String qualifiedName) {
        return DbtMetric.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static DbtMetric refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((DbtMetricBuilder)((DbtMetricBuilder)DbtMetric._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static DbtMetric get(AtlanClient client, String id) throws AtlanException {
        return DbtMetric.get(client, id, false);
    }

    @JsonIgnore
    public static DbtMetric get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DbtMetric) {
                return (DbtMetric)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof DbtMetric) {
            return (DbtMetric)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static DbtMetric get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return DbtMetric.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static DbtMetric get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DbtMetric.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof DbtMetric) {
                return (DbtMetric)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DbtMetric.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof DbtMetric) {
            return (DbtMetric)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DbtMetricBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DbtMetricBuilder)((DbtMetricBuilder)((DbtMetricBuilder)DbtMetric._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public DbtMetricBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        DbtMetric.validateRequired(TYPE_NAME, map);
        return DbtMetric.updater(this.getQualifiedName(), this.getName());
    }

    public static DbtMetric removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtMetric)Asset.removeDescription(client, DbtMetric.updater(qualifiedName, name));
    }

    public static DbtMetric removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtMetric)Asset.removeUserDescription(client, DbtMetric.updater(qualifiedName, name));
    }

    public static DbtMetric removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtMetric)Asset.removeOwners(client, DbtMetric.updater(qualifiedName, name));
    }

    public static DbtMetric updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DbtMetric)Asset.updateCertificate(client, DbtMetric._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DbtMetric removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtMetric)Asset.removeCertificate(client, DbtMetric.updater(qualifiedName, name));
    }

    public static DbtMetric updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DbtMetric)Asset.updateAnnouncement(client, DbtMetric._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DbtMetric removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtMetric)Asset.removeAnnouncement(client, DbtMetric.updater(qualifiedName, name));
    }

    public static DbtMetric replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtMetric)Asset.replaceTerms(client, DbtMetric.updater(qualifiedName, name), terms);
    }

    public static DbtMetric appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtMetric)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DbtMetric removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtMetric)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DbtMetric appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DbtMetric)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static DbtMetric appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DbtMetric)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DbtMetric(DbtMetricBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DbtMetric.$default$typeName();
        SortedSet<IAsset> assets = new TreeSet<IAsset>();
        if (b.assets != null) {
            assets.addAll(b.assets);
        }
        assets = Collections.unmodifiableSortedSet(assets);
        this.assets = assets;
        this.dbtAccountName = b.dbtAccountName;
        this.dbtAlias = b.dbtAlias;
        this.dbtConnectionContext = b.dbtConnectionContext;
        this.dbtEnvironmentDbtVersion = b.dbtEnvironmentDbtVersion;
        this.dbtEnvironmentName = b.dbtEnvironmentName;
        this.dbtJobLastRun = b.dbtJobLastRun;
        this.dbtJobName = b.dbtJobName;
        this.dbtJobNextRun = b.dbtJobNextRun;
        this.dbtJobNextRunHumanized = b.dbtJobNextRunHumanized;
        this.dbtJobRuns = switch (b.dbtJobRuns == null ? 0 : b.dbtJobRuns.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.dbtJobRuns.get(0));
            default -> Collections.unmodifiableList(new ArrayList<DbtJobRun>(b.dbtJobRuns));
        };
        this.dbtJobSchedule = b.dbtJobSchedule;
        this.dbtJobScheduleCronHumanized = b.dbtJobScheduleCronHumanized;
        this.dbtJobStatus = b.dbtJobStatus;
        this.dbtMeta = b.dbtMeta;
        SortedSet<IColumn> dbtMetricFilterColumns = new TreeSet<IColumn>();
        if (b.dbtMetricFilterColumns != null) {
            dbtMetricFilterColumns.addAll(b.dbtMetricFilterColumns);
        }
        dbtMetricFilterColumns = Collections.unmodifiableSortedSet(dbtMetricFilterColumns);
        this.dbtMetricFilterColumns = dbtMetricFilterColumns;
        this.dbtMetricFilters = switch (b.dbtMetricFilters == null ? 0 : b.dbtMetricFilters.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.dbtMetricFilters.get(0));
            default -> Collections.unmodifiableList(new ArrayList<DbtMetricFilter>(b.dbtMetricFilters));
        };
        this.dbtModel = b.dbtModel;
        this.dbtPackageName = b.dbtPackageName;
        this.dbtProjectName = b.dbtProjectName;
        this.dbtSemanticLayerProxyUrl = b.dbtSemanticLayerProxyUrl;
        SortedSet<String> dbtTags = new TreeSet<String>();
        if (b.dbtTags != null) {
            dbtTags.addAll(b.dbtTags);
        }
        dbtTags = Collections.unmodifiableSortedSet(dbtTags);
        this.dbtTags = dbtTags;
        this.dbtUniqueId = b.dbtUniqueId;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IColumn> metricDimensionColumns = new TreeSet<IColumn>();
        if (b.metricDimensionColumns != null) {
            metricDimensionColumns.addAll(b.metricDimensionColumns);
        }
        metricDimensionColumns = Collections.unmodifiableSortedSet(metricDimensionColumns);
        this.metricDimensionColumns = metricDimensionColumns;
        this.metricFilters = b.metricFilters;
        this.metricSQL = b.metricSQL;
        SortedSet<String> metricTimeGrains = new TreeSet<String>();
        if (b.metricTimeGrains != null) {
            metricTimeGrains.addAll(b.metricTimeGrains);
        }
        metricTimeGrains = Collections.unmodifiableSortedSet(metricTimeGrains);
        this.metricTimeGrains = metricTimeGrains;
        this.metricTimestampColumn = b.metricTimestampColumn;
        this.metricType = b.metricType;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static DbtMetricBuilder<?, ?> _internal() {
        return new DbtMetricBuilderImpl();
    }

    @Generated
    public DbtMetricBuilder<?, ?> toBuilder() {
        return new DbtMetricBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAsset> getAssets() {
        return this.assets;
    }

    @Override
    @Generated
    public String getDbtAccountName() {
        return this.dbtAccountName;
    }

    @Override
    @Generated
    public String getDbtAlias() {
        return this.dbtAlias;
    }

    @Override
    @Generated
    public String getDbtConnectionContext() {
        return this.dbtConnectionContext;
    }

    @Override
    @Generated
    public String getDbtEnvironmentDbtVersion() {
        return this.dbtEnvironmentDbtVersion;
    }

    @Override
    @Generated
    public String getDbtEnvironmentName() {
        return this.dbtEnvironmentName;
    }

    @Override
    @Generated
    public Long getDbtJobLastRun() {
        return this.dbtJobLastRun;
    }

    @Override
    @Generated
    public String getDbtJobName() {
        return this.dbtJobName;
    }

    @Override
    @Generated
    public Long getDbtJobNextRun() {
        return this.dbtJobNextRun;
    }

    @Override
    @Generated
    public String getDbtJobNextRunHumanized() {
        return this.dbtJobNextRunHumanized;
    }

    @Override
    @Generated
    public List<DbtJobRun> getDbtJobRuns() {
        return this.dbtJobRuns;
    }

    @Override
    @Generated
    public String getDbtJobSchedule() {
        return this.dbtJobSchedule;
    }

    @Override
    @Generated
    public String getDbtJobScheduleCronHumanized() {
        return this.dbtJobScheduleCronHumanized;
    }

    @Override
    @Generated
    public String getDbtJobStatus() {
        return this.dbtJobStatus;
    }

    @Override
    @Generated
    public String getDbtMeta() {
        return this.dbtMeta;
    }

    @Override
    @Generated
    public SortedSet<IColumn> getDbtMetricFilterColumns() {
        return this.dbtMetricFilterColumns;
    }

    @Override
    @Generated
    public List<DbtMetricFilter> getDbtMetricFilters() {
        return this.dbtMetricFilters;
    }

    @Override
    @Generated
    public IDbtModel getDbtModel() {
        return this.dbtModel;
    }

    @Override
    @Generated
    public String getDbtPackageName() {
        return this.dbtPackageName;
    }

    @Override
    @Generated
    public String getDbtProjectName() {
        return this.dbtProjectName;
    }

    @Override
    @Generated
    public String getDbtSemanticLayerProxyUrl() {
        return this.dbtSemanticLayerProxyUrl;
    }

    @Override
    @Generated
    public SortedSet<String> getDbtTags() {
        return this.dbtTags;
    }

    @Override
    @Generated
    public String getDbtUniqueId() {
        return this.dbtUniqueId;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IColumn> getMetricDimensionColumns() {
        return this.metricDimensionColumns;
    }

    @Override
    @Generated
    public String getMetricFilters() {
        return this.metricFilters;
    }

    @Override
    @Generated
    public String getMetricSQL() {
        return this.metricSQL;
    }

    @Override
    @Generated
    public SortedSet<String> getMetricTimeGrains() {
        return this.metricTimeGrains;
    }

    @Override
    @Generated
    public IColumn getMetricTimestampColumn() {
        return this.metricTimestampColumn;
    }

    @Override
    @Generated
    public String getMetricType() {
        return this.metricType;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbtMetric)) {
            return false;
        }
        DbtMetric other = (DbtMetric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$dbtJobLastRun = this.getDbtJobLastRun();
        Long other$dbtJobLastRun = other.getDbtJobLastRun();
        if (this$dbtJobLastRun == null ? other$dbtJobLastRun != null : !((Object)this$dbtJobLastRun).equals(other$dbtJobLastRun)) {
            return false;
        }
        Long this$dbtJobNextRun = this.getDbtJobNextRun();
        Long other$dbtJobNextRun = other.getDbtJobNextRun();
        if (this$dbtJobNextRun == null ? other$dbtJobNextRun != null : !((Object)this$dbtJobNextRun).equals(other$dbtJobNextRun)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAsset> this$assets = this.getAssets();
        SortedSet<IAsset> other$assets = other.getAssets();
        if (this$assets == null ? other$assets != null : !this$assets.equals(other$assets)) {
            return false;
        }
        String this$dbtAccountName = this.getDbtAccountName();
        String other$dbtAccountName = other.getDbtAccountName();
        if (this$dbtAccountName == null ? other$dbtAccountName != null : !this$dbtAccountName.equals(other$dbtAccountName)) {
            return false;
        }
        String this$dbtAlias = this.getDbtAlias();
        String other$dbtAlias = other.getDbtAlias();
        if (this$dbtAlias == null ? other$dbtAlias != null : !this$dbtAlias.equals(other$dbtAlias)) {
            return false;
        }
        String this$dbtConnectionContext = this.getDbtConnectionContext();
        String other$dbtConnectionContext = other.getDbtConnectionContext();
        if (this$dbtConnectionContext == null ? other$dbtConnectionContext != null : !this$dbtConnectionContext.equals(other$dbtConnectionContext)) {
            return false;
        }
        String this$dbtEnvironmentDbtVersion = this.getDbtEnvironmentDbtVersion();
        String other$dbtEnvironmentDbtVersion = other.getDbtEnvironmentDbtVersion();
        if (this$dbtEnvironmentDbtVersion == null ? other$dbtEnvironmentDbtVersion != null : !this$dbtEnvironmentDbtVersion.equals(other$dbtEnvironmentDbtVersion)) {
            return false;
        }
        String this$dbtEnvironmentName = this.getDbtEnvironmentName();
        String other$dbtEnvironmentName = other.getDbtEnvironmentName();
        if (this$dbtEnvironmentName == null ? other$dbtEnvironmentName != null : !this$dbtEnvironmentName.equals(other$dbtEnvironmentName)) {
            return false;
        }
        String this$dbtJobName = this.getDbtJobName();
        String other$dbtJobName = other.getDbtJobName();
        if (this$dbtJobName == null ? other$dbtJobName != null : !this$dbtJobName.equals(other$dbtJobName)) {
            return false;
        }
        String this$dbtJobNextRunHumanized = this.getDbtJobNextRunHumanized();
        String other$dbtJobNextRunHumanized = other.getDbtJobNextRunHumanized();
        if (this$dbtJobNextRunHumanized == null ? other$dbtJobNextRunHumanized != null : !this$dbtJobNextRunHumanized.equals(other$dbtJobNextRunHumanized)) {
            return false;
        }
        List<DbtJobRun> this$dbtJobRuns = this.getDbtJobRuns();
        List<DbtJobRun> other$dbtJobRuns = other.getDbtJobRuns();
        if (this$dbtJobRuns == null ? other$dbtJobRuns != null : !((Object)this$dbtJobRuns).equals(other$dbtJobRuns)) {
            return false;
        }
        String this$dbtJobSchedule = this.getDbtJobSchedule();
        String other$dbtJobSchedule = other.getDbtJobSchedule();
        if (this$dbtJobSchedule == null ? other$dbtJobSchedule != null : !this$dbtJobSchedule.equals(other$dbtJobSchedule)) {
            return false;
        }
        String this$dbtJobScheduleCronHumanized = this.getDbtJobScheduleCronHumanized();
        String other$dbtJobScheduleCronHumanized = other.getDbtJobScheduleCronHumanized();
        if (this$dbtJobScheduleCronHumanized == null ? other$dbtJobScheduleCronHumanized != null : !this$dbtJobScheduleCronHumanized.equals(other$dbtJobScheduleCronHumanized)) {
            return false;
        }
        String this$dbtJobStatus = this.getDbtJobStatus();
        String other$dbtJobStatus = other.getDbtJobStatus();
        if (this$dbtJobStatus == null ? other$dbtJobStatus != null : !this$dbtJobStatus.equals(other$dbtJobStatus)) {
            return false;
        }
        String this$dbtMeta = this.getDbtMeta();
        String other$dbtMeta = other.getDbtMeta();
        if (this$dbtMeta == null ? other$dbtMeta != null : !this$dbtMeta.equals(other$dbtMeta)) {
            return false;
        }
        SortedSet<IColumn> this$dbtMetricFilterColumns = this.getDbtMetricFilterColumns();
        SortedSet<IColumn> other$dbtMetricFilterColumns = other.getDbtMetricFilterColumns();
        if (this$dbtMetricFilterColumns == null ? other$dbtMetricFilterColumns != null : !this$dbtMetricFilterColumns.equals(other$dbtMetricFilterColumns)) {
            return false;
        }
        List<DbtMetricFilter> this$dbtMetricFilters = this.getDbtMetricFilters();
        List<DbtMetricFilter> other$dbtMetricFilters = other.getDbtMetricFilters();
        if (this$dbtMetricFilters == null ? other$dbtMetricFilters != null : !((Object)this$dbtMetricFilters).equals(other$dbtMetricFilters)) {
            return false;
        }
        IDbtModel this$dbtModel = this.getDbtModel();
        IDbtModel other$dbtModel = other.getDbtModel();
        if (this$dbtModel == null ? other$dbtModel != null : !this$dbtModel.equals(other$dbtModel)) {
            return false;
        }
        String this$dbtPackageName = this.getDbtPackageName();
        String other$dbtPackageName = other.getDbtPackageName();
        if (this$dbtPackageName == null ? other$dbtPackageName != null : !this$dbtPackageName.equals(other$dbtPackageName)) {
            return false;
        }
        String this$dbtProjectName = this.getDbtProjectName();
        String other$dbtProjectName = other.getDbtProjectName();
        if (this$dbtProjectName == null ? other$dbtProjectName != null : !this$dbtProjectName.equals(other$dbtProjectName)) {
            return false;
        }
        String this$dbtSemanticLayerProxyUrl = this.getDbtSemanticLayerProxyUrl();
        String other$dbtSemanticLayerProxyUrl = other.getDbtSemanticLayerProxyUrl();
        if (this$dbtSemanticLayerProxyUrl == null ? other$dbtSemanticLayerProxyUrl != null : !this$dbtSemanticLayerProxyUrl.equals(other$dbtSemanticLayerProxyUrl)) {
            return false;
        }
        SortedSet<String> this$dbtTags = this.getDbtTags();
        SortedSet<String> other$dbtTags = other.getDbtTags();
        if (this$dbtTags == null ? other$dbtTags != null : !this$dbtTags.equals(other$dbtTags)) {
            return false;
        }
        String this$dbtUniqueId = this.getDbtUniqueId();
        String other$dbtUniqueId = other.getDbtUniqueId();
        if (this$dbtUniqueId == null ? other$dbtUniqueId != null : !this$dbtUniqueId.equals(other$dbtUniqueId)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IColumn> this$metricDimensionColumns = this.getMetricDimensionColumns();
        SortedSet<IColumn> other$metricDimensionColumns = other.getMetricDimensionColumns();
        if (this$metricDimensionColumns == null ? other$metricDimensionColumns != null : !this$metricDimensionColumns.equals(other$metricDimensionColumns)) {
            return false;
        }
        String this$metricFilters = this.getMetricFilters();
        String other$metricFilters = other.getMetricFilters();
        if (this$metricFilters == null ? other$metricFilters != null : !this$metricFilters.equals(other$metricFilters)) {
            return false;
        }
        String this$metricSQL = this.getMetricSQL();
        String other$metricSQL = other.getMetricSQL();
        if (this$metricSQL == null ? other$metricSQL != null : !this$metricSQL.equals(other$metricSQL)) {
            return false;
        }
        SortedSet<String> this$metricTimeGrains = this.getMetricTimeGrains();
        SortedSet<String> other$metricTimeGrains = other.getMetricTimeGrains();
        if (this$metricTimeGrains == null ? other$metricTimeGrains != null : !this$metricTimeGrains.equals(other$metricTimeGrains)) {
            return false;
        }
        IColumn this$metricTimestampColumn = this.getMetricTimestampColumn();
        IColumn other$metricTimestampColumn = other.getMetricTimestampColumn();
        if (this$metricTimestampColumn == null ? other$metricTimestampColumn != null : !this$metricTimestampColumn.equals(other$metricTimestampColumn)) {
            return false;
        }
        String this$metricType = this.getMetricType();
        String other$metricType = other.getMetricType();
        if (this$metricType == null ? other$metricType != null : !this$metricType.equals(other$metricType)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DbtMetric;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $dbtJobLastRun = this.getDbtJobLastRun();
        result = result * 59 + ($dbtJobLastRun == null ? 43 : ((Object)$dbtJobLastRun).hashCode());
        Long $dbtJobNextRun = this.getDbtJobNextRun();
        result = result * 59 + ($dbtJobNextRun == null ? 43 : ((Object)$dbtJobNextRun).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAsset> $assets = this.getAssets();
        result = result * 59 + ($assets == null ? 43 : $assets.hashCode());
        String $dbtAccountName = this.getDbtAccountName();
        result = result * 59 + ($dbtAccountName == null ? 43 : $dbtAccountName.hashCode());
        String $dbtAlias = this.getDbtAlias();
        result = result * 59 + ($dbtAlias == null ? 43 : $dbtAlias.hashCode());
        String $dbtConnectionContext = this.getDbtConnectionContext();
        result = result * 59 + ($dbtConnectionContext == null ? 43 : $dbtConnectionContext.hashCode());
        String $dbtEnvironmentDbtVersion = this.getDbtEnvironmentDbtVersion();
        result = result * 59 + ($dbtEnvironmentDbtVersion == null ? 43 : $dbtEnvironmentDbtVersion.hashCode());
        String $dbtEnvironmentName = this.getDbtEnvironmentName();
        result = result * 59 + ($dbtEnvironmentName == null ? 43 : $dbtEnvironmentName.hashCode());
        String $dbtJobName = this.getDbtJobName();
        result = result * 59 + ($dbtJobName == null ? 43 : $dbtJobName.hashCode());
        String $dbtJobNextRunHumanized = this.getDbtJobNextRunHumanized();
        result = result * 59 + ($dbtJobNextRunHumanized == null ? 43 : $dbtJobNextRunHumanized.hashCode());
        List<DbtJobRun> $dbtJobRuns = this.getDbtJobRuns();
        result = result * 59 + ($dbtJobRuns == null ? 43 : ((Object)$dbtJobRuns).hashCode());
        String $dbtJobSchedule = this.getDbtJobSchedule();
        result = result * 59 + ($dbtJobSchedule == null ? 43 : $dbtJobSchedule.hashCode());
        String $dbtJobScheduleCronHumanized = this.getDbtJobScheduleCronHumanized();
        result = result * 59 + ($dbtJobScheduleCronHumanized == null ? 43 : $dbtJobScheduleCronHumanized.hashCode());
        String $dbtJobStatus = this.getDbtJobStatus();
        result = result * 59 + ($dbtJobStatus == null ? 43 : $dbtJobStatus.hashCode());
        String $dbtMeta = this.getDbtMeta();
        result = result * 59 + ($dbtMeta == null ? 43 : $dbtMeta.hashCode());
        SortedSet<IColumn> $dbtMetricFilterColumns = this.getDbtMetricFilterColumns();
        result = result * 59 + ($dbtMetricFilterColumns == null ? 43 : $dbtMetricFilterColumns.hashCode());
        List<DbtMetricFilter> $dbtMetricFilters = this.getDbtMetricFilters();
        result = result * 59 + ($dbtMetricFilters == null ? 43 : ((Object)$dbtMetricFilters).hashCode());
        IDbtModel $dbtModel = this.getDbtModel();
        result = result * 59 + ($dbtModel == null ? 43 : $dbtModel.hashCode());
        String $dbtPackageName = this.getDbtPackageName();
        result = result * 59 + ($dbtPackageName == null ? 43 : $dbtPackageName.hashCode());
        String $dbtProjectName = this.getDbtProjectName();
        result = result * 59 + ($dbtProjectName == null ? 43 : $dbtProjectName.hashCode());
        String $dbtSemanticLayerProxyUrl = this.getDbtSemanticLayerProxyUrl();
        result = result * 59 + ($dbtSemanticLayerProxyUrl == null ? 43 : $dbtSemanticLayerProxyUrl.hashCode());
        SortedSet<String> $dbtTags = this.getDbtTags();
        result = result * 59 + ($dbtTags == null ? 43 : $dbtTags.hashCode());
        String $dbtUniqueId = this.getDbtUniqueId();
        result = result * 59 + ($dbtUniqueId == null ? 43 : $dbtUniqueId.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IColumn> $metricDimensionColumns = this.getMetricDimensionColumns();
        result = result * 59 + ($metricDimensionColumns == null ? 43 : $metricDimensionColumns.hashCode());
        String $metricFilters = this.getMetricFilters();
        result = result * 59 + ($metricFilters == null ? 43 : $metricFilters.hashCode());
        String $metricSQL = this.getMetricSQL();
        result = result * 59 + ($metricSQL == null ? 43 : $metricSQL.hashCode());
        SortedSet<String> $metricTimeGrains = this.getMetricTimeGrains();
        result = result * 59 + ($metricTimeGrains == null ? 43 : $metricTimeGrains.hashCode());
        IColumn $metricTimestampColumn = this.getMetricTimestampColumn();
        result = result * 59 + ($metricTimestampColumn == null ? 43 : $metricTimestampColumn.hashCode());
        String $metricType = this.getMetricType();
        result = result * 59 + ($metricType == null ? 43 : $metricType.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DbtMetric(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", assets=" + String.valueOf(this.getAssets()) + ", dbtAccountName=" + this.getDbtAccountName() + ", dbtAlias=" + this.getDbtAlias() + ", dbtConnectionContext=" + this.getDbtConnectionContext() + ", dbtEnvironmentDbtVersion=" + this.getDbtEnvironmentDbtVersion() + ", dbtEnvironmentName=" + this.getDbtEnvironmentName() + ", dbtJobLastRun=" + this.getDbtJobLastRun() + ", dbtJobName=" + this.getDbtJobName() + ", dbtJobNextRun=" + this.getDbtJobNextRun() + ", dbtJobNextRunHumanized=" + this.getDbtJobNextRunHumanized() + ", dbtJobRuns=" + String.valueOf(this.getDbtJobRuns()) + ", dbtJobSchedule=" + this.getDbtJobSchedule() + ", dbtJobScheduleCronHumanized=" + this.getDbtJobScheduleCronHumanized() + ", dbtJobStatus=" + this.getDbtJobStatus() + ", dbtMeta=" + this.getDbtMeta() + ", dbtMetricFilterColumns=" + String.valueOf(this.getDbtMetricFilterColumns()) + ", dbtMetricFilters=" + String.valueOf(this.getDbtMetricFilters()) + ", dbtModel=" + String.valueOf(this.getDbtModel()) + ", dbtPackageName=" + this.getDbtPackageName() + ", dbtProjectName=" + this.getDbtProjectName() + ", dbtSemanticLayerProxyUrl=" + this.getDbtSemanticLayerProxyUrl() + ", dbtTags=" + String.valueOf(this.getDbtTags()) + ", dbtUniqueId=" + this.getDbtUniqueId() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", metricDimensionColumns=" + String.valueOf(this.getMetricDimensionColumns()) + ", metricFilters=" + this.getMetricFilters() + ", metricSQL=" + this.getMetricSQL() + ", metricTimeGrains=" + String.valueOf(this.getMetricTimeGrains()) + ", metricTimestampColumn=" + String.valueOf(this.getMetricTimestampColumn()) + ", metricType=" + this.getMetricType() + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class DbtMetricBuilder<C extends DbtMetric, B extends DbtMetricBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAsset> assets;
        @Generated
        private String dbtAccountName;
        @Generated
        private String dbtAlias;
        @Generated
        private String dbtConnectionContext;
        @Generated
        private String dbtEnvironmentDbtVersion;
        @Generated
        private String dbtEnvironmentName;
        @Generated
        private Long dbtJobLastRun;
        @Generated
        private String dbtJobName;
        @Generated
        private Long dbtJobNextRun;
        @Generated
        private String dbtJobNextRunHumanized;
        @Generated
        private ArrayList<DbtJobRun> dbtJobRuns;
        @Generated
        private String dbtJobSchedule;
        @Generated
        private String dbtJobScheduleCronHumanized;
        @Generated
        private String dbtJobStatus;
        @Generated
        private String dbtMeta;
        @Generated
        private ArrayList<IColumn> dbtMetricFilterColumns;
        @Generated
        private ArrayList<DbtMetricFilter> dbtMetricFilters;
        @Generated
        private IDbtModel dbtModel;
        @Generated
        private String dbtPackageName;
        @Generated
        private String dbtProjectName;
        @Generated
        private String dbtSemanticLayerProxyUrl;
        @Generated
        private ArrayList<String> dbtTags;
        @Generated
        private String dbtUniqueId;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IColumn> metricDimensionColumns;
        @Generated
        private String metricFilters;
        @Generated
        private String metricSQL;
        @Generated
        private ArrayList<String> metricTimeGrains;
        @Generated
        private IColumn metricTimestampColumn;
        @Generated
        private String metricType;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DbtMetricBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DbtMetric instance, DbtMetricBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.assets(instance.assets == null ? Collections.emptySortedSet() : instance.assets);
            b.dbtAccountName(instance.dbtAccountName);
            b.dbtAlias(instance.dbtAlias);
            b.dbtConnectionContext(instance.dbtConnectionContext);
            b.dbtEnvironmentDbtVersion(instance.dbtEnvironmentDbtVersion);
            b.dbtEnvironmentName(instance.dbtEnvironmentName);
            b.dbtJobLastRun(instance.dbtJobLastRun);
            b.dbtJobName(instance.dbtJobName);
            b.dbtJobNextRun(instance.dbtJobNextRun);
            b.dbtJobNextRunHumanized(instance.dbtJobNextRunHumanized);
            b.dbtJobRuns(instance.dbtJobRuns == null ? Collections.emptyList() : instance.dbtJobRuns);
            b.dbtJobSchedule(instance.dbtJobSchedule);
            b.dbtJobScheduleCronHumanized(instance.dbtJobScheduleCronHumanized);
            b.dbtJobStatus(instance.dbtJobStatus);
            b.dbtMeta(instance.dbtMeta);
            b.dbtMetricFilterColumns(instance.dbtMetricFilterColumns == null ? Collections.emptySortedSet() : instance.dbtMetricFilterColumns);
            b.dbtMetricFilters(instance.dbtMetricFilters == null ? Collections.emptyList() : instance.dbtMetricFilters);
            b.dbtModel(instance.dbtModel);
            b.dbtPackageName(instance.dbtPackageName);
            b.dbtProjectName(instance.dbtProjectName);
            b.dbtSemanticLayerProxyUrl(instance.dbtSemanticLayerProxyUrl);
            b.dbtTags(instance.dbtTags == null ? Collections.emptySortedSet() : instance.dbtTags);
            b.dbtUniqueId(instance.dbtUniqueId);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.metricDimensionColumns(instance.metricDimensionColumns == null ? Collections.emptySortedSet() : instance.metricDimensionColumns);
            b.metricFilters(instance.metricFilters);
            b.metricSQL(instance.metricSQL);
            b.metricTimeGrains(instance.metricTimeGrains == null ? Collections.emptySortedSet() : instance.metricTimeGrains);
            b.metricTimestampColumn(instance.metricTimestampColumn);
            b.metricType(instance.metricType);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B asset(IAsset asset) {
            if (this.assets == null) {
                this.assets = new ArrayList();
            }
            this.assets.add(asset);
            return (B)this.self();
        }

        @Generated
        public B assets(Collection<? extends IAsset> assets) {
            if (assets == null) {
                throw new NullPointerException("assets cannot be null");
            }
            if (this.assets == null) {
                this.assets = new ArrayList();
            }
            this.assets.addAll(assets);
            return (B)this.self();
        }

        @Generated
        public B clearAssets() {
            if (this.assets != null) {
                this.assets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtAccountName(String dbtAccountName) {
            this.dbtAccountName = dbtAccountName;
            return (B)this.self();
        }

        @Generated
        public B dbtAlias(String dbtAlias) {
            this.dbtAlias = dbtAlias;
            return (B)this.self();
        }

        @Generated
        public B dbtConnectionContext(String dbtConnectionContext) {
            this.dbtConnectionContext = dbtConnectionContext;
            return (B)this.self();
        }

        @Generated
        public B dbtEnvironmentDbtVersion(String dbtEnvironmentDbtVersion) {
            this.dbtEnvironmentDbtVersion = dbtEnvironmentDbtVersion;
            return (B)this.self();
        }

        @Generated
        public B dbtEnvironmentName(String dbtEnvironmentName) {
            this.dbtEnvironmentName = dbtEnvironmentName;
            return (B)this.self();
        }

        @Generated
        public B dbtJobLastRun(Long dbtJobLastRun) {
            this.dbtJobLastRun = dbtJobLastRun;
            return (B)this.self();
        }

        @Generated
        public B dbtJobName(String dbtJobName) {
            this.dbtJobName = dbtJobName;
            return (B)this.self();
        }

        @Generated
        public B dbtJobNextRun(Long dbtJobNextRun) {
            this.dbtJobNextRun = dbtJobNextRun;
            return (B)this.self();
        }

        @Generated
        public B dbtJobNextRunHumanized(String dbtJobNextRunHumanized) {
            this.dbtJobNextRunHumanized = dbtJobNextRunHumanized;
            return (B)this.self();
        }

        @Generated
        public B dbtJobRun(DbtJobRun dbtJobRun) {
            if (this.dbtJobRuns == null) {
                this.dbtJobRuns = new ArrayList();
            }
            this.dbtJobRuns.add(dbtJobRun);
            return (B)this.self();
        }

        @Generated
        public B dbtJobRuns(Collection<? extends DbtJobRun> dbtJobRuns) {
            if (dbtJobRuns == null) {
                throw new NullPointerException("dbtJobRuns cannot be null");
            }
            if (this.dbtJobRuns == null) {
                this.dbtJobRuns = new ArrayList();
            }
            this.dbtJobRuns.addAll(dbtJobRuns);
            return (B)this.self();
        }

        @Generated
        public B clearDbtJobRuns() {
            if (this.dbtJobRuns != null) {
                this.dbtJobRuns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtJobSchedule(String dbtJobSchedule) {
            this.dbtJobSchedule = dbtJobSchedule;
            return (B)this.self();
        }

        @Generated
        public B dbtJobScheduleCronHumanized(String dbtJobScheduleCronHumanized) {
            this.dbtJobScheduleCronHumanized = dbtJobScheduleCronHumanized;
            return (B)this.self();
        }

        @Generated
        public B dbtJobStatus(String dbtJobStatus) {
            this.dbtJobStatus = dbtJobStatus;
            return (B)this.self();
        }

        @Generated
        public B dbtMeta(String dbtMeta) {
            this.dbtMeta = dbtMeta;
            return (B)this.self();
        }

        @Generated
        public B dbtMetricFilterColumn(IColumn dbtMetricFilterColumn) {
            if (this.dbtMetricFilterColumns == null) {
                this.dbtMetricFilterColumns = new ArrayList();
            }
            this.dbtMetricFilterColumns.add(dbtMetricFilterColumn);
            return (B)this.self();
        }

        @Generated
        public B dbtMetricFilterColumns(Collection<? extends IColumn> dbtMetricFilterColumns) {
            if (dbtMetricFilterColumns == null) {
                throw new NullPointerException("dbtMetricFilterColumns cannot be null");
            }
            if (this.dbtMetricFilterColumns == null) {
                this.dbtMetricFilterColumns = new ArrayList();
            }
            this.dbtMetricFilterColumns.addAll(dbtMetricFilterColumns);
            return (B)this.self();
        }

        @Generated
        public B clearDbtMetricFilterColumns() {
            if (this.dbtMetricFilterColumns != null) {
                this.dbtMetricFilterColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtMetricFilter(DbtMetricFilter dbtMetricFilter) {
            if (this.dbtMetricFilters == null) {
                this.dbtMetricFilters = new ArrayList();
            }
            this.dbtMetricFilters.add(dbtMetricFilter);
            return (B)this.self();
        }

        @Generated
        public B dbtMetricFilters(Collection<? extends DbtMetricFilter> dbtMetricFilters) {
            if (dbtMetricFilters == null) {
                throw new NullPointerException("dbtMetricFilters cannot be null");
            }
            if (this.dbtMetricFilters == null) {
                this.dbtMetricFilters = new ArrayList();
            }
            this.dbtMetricFilters.addAll(dbtMetricFilters);
            return (B)this.self();
        }

        @Generated
        public B clearDbtMetricFilters() {
            if (this.dbtMetricFilters != null) {
                this.dbtMetricFilters.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtModel(IDbtModel dbtModel) {
            this.dbtModel = dbtModel;
            return (B)this.self();
        }

        @Generated
        public B dbtPackageName(String dbtPackageName) {
            this.dbtPackageName = dbtPackageName;
            return (B)this.self();
        }

        @Generated
        public B dbtProjectName(String dbtProjectName) {
            this.dbtProjectName = dbtProjectName;
            return (B)this.self();
        }

        @Generated
        public B dbtSemanticLayerProxyUrl(String dbtSemanticLayerProxyUrl) {
            this.dbtSemanticLayerProxyUrl = dbtSemanticLayerProxyUrl;
            return (B)this.self();
        }

        @Generated
        public B dbtTag(String dbtTag) {
            if (this.dbtTags == null) {
                this.dbtTags = new ArrayList();
            }
            this.dbtTags.add(dbtTag);
            return (B)this.self();
        }

        @Generated
        public B dbtTags(Collection<? extends String> dbtTags) {
            if (dbtTags == null) {
                throw new NullPointerException("dbtTags cannot be null");
            }
            if (this.dbtTags == null) {
                this.dbtTags = new ArrayList();
            }
            this.dbtTags.addAll(dbtTags);
            return (B)this.self();
        }

        @Generated
        public B clearDbtTags() {
            if (this.dbtTags != null) {
                this.dbtTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtUniqueId(String dbtUniqueId) {
            this.dbtUniqueId = dbtUniqueId;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metricDimensionColumn(IColumn metricDimensionColumn) {
            if (this.metricDimensionColumns == null) {
                this.metricDimensionColumns = new ArrayList();
            }
            this.metricDimensionColumns.add(metricDimensionColumn);
            return (B)this.self();
        }

        @Generated
        public B metricDimensionColumns(Collection<? extends IColumn> metricDimensionColumns) {
            if (metricDimensionColumns == null) {
                throw new NullPointerException("metricDimensionColumns cannot be null");
            }
            if (this.metricDimensionColumns == null) {
                this.metricDimensionColumns = new ArrayList();
            }
            this.metricDimensionColumns.addAll(metricDimensionColumns);
            return (B)this.self();
        }

        @Generated
        public B clearMetricDimensionColumns() {
            if (this.metricDimensionColumns != null) {
                this.metricDimensionColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metricFilters(String metricFilters) {
            this.metricFilters = metricFilters;
            return (B)this.self();
        }

        @Generated
        public B metricSQL(String metricSQL) {
            this.metricSQL = metricSQL;
            return (B)this.self();
        }

        @Generated
        public B metricTimeGrain(String metricTimeGrain) {
            if (this.metricTimeGrains == null) {
                this.metricTimeGrains = new ArrayList();
            }
            this.metricTimeGrains.add(metricTimeGrain);
            return (B)this.self();
        }

        @Generated
        public B metricTimeGrains(Collection<? extends String> metricTimeGrains) {
            if (metricTimeGrains == null) {
                throw new NullPointerException("metricTimeGrains cannot be null");
            }
            if (this.metricTimeGrains == null) {
                this.metricTimeGrains = new ArrayList();
            }
            this.metricTimeGrains.addAll(metricTimeGrains);
            return (B)this.self();
        }

        @Generated
        public B clearMetricTimeGrains() {
            if (this.metricTimeGrains != null) {
                this.metricTimeGrains.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metricTimestampColumn(IColumn metricTimestampColumn) {
            this.metricTimestampColumn = metricTimestampColumn;
            return (B)this.self();
        }

        @Generated
        public B metricType(String metricType) {
            this.metricType = metricType;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DbtMetric.DbtMetricBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", assets=" + String.valueOf(this.assets) + ", dbtAccountName=" + this.dbtAccountName + ", dbtAlias=" + this.dbtAlias + ", dbtConnectionContext=" + this.dbtConnectionContext + ", dbtEnvironmentDbtVersion=" + this.dbtEnvironmentDbtVersion + ", dbtEnvironmentName=" + this.dbtEnvironmentName + ", dbtJobLastRun=" + this.dbtJobLastRun + ", dbtJobName=" + this.dbtJobName + ", dbtJobNextRun=" + this.dbtJobNextRun + ", dbtJobNextRunHumanized=" + this.dbtJobNextRunHumanized + ", dbtJobRuns=" + String.valueOf(this.dbtJobRuns) + ", dbtJobSchedule=" + this.dbtJobSchedule + ", dbtJobScheduleCronHumanized=" + this.dbtJobScheduleCronHumanized + ", dbtJobStatus=" + this.dbtJobStatus + ", dbtMeta=" + this.dbtMeta + ", dbtMetricFilterColumns=" + String.valueOf(this.dbtMetricFilterColumns) + ", dbtMetricFilters=" + String.valueOf(this.dbtMetricFilters) + ", dbtModel=" + String.valueOf(this.dbtModel) + ", dbtPackageName=" + this.dbtPackageName + ", dbtProjectName=" + this.dbtProjectName + ", dbtSemanticLayerProxyUrl=" + this.dbtSemanticLayerProxyUrl + ", dbtTags=" + String.valueOf(this.dbtTags) + ", dbtUniqueId=" + this.dbtUniqueId + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", metricDimensionColumns=" + String.valueOf(this.metricDimensionColumns) + ", metricFilters=" + this.metricFilters + ", metricSQL=" + this.metricSQL + ", metricTimeGrains=" + String.valueOf(this.metricTimeGrains) + ", metricTimestampColumn=" + String.valueOf(this.metricTimestampColumn) + ", metricType=" + this.metricType + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class DbtMetricBuilderImpl
    extends DbtMetricBuilder<DbtMetric, DbtMetricBuilderImpl> {
        @Generated
        private DbtMetricBuilderImpl() {
        }

        @Override
        @Generated
        protected DbtMetricBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DbtMetric build() {
            return new DbtMetric(this);
        }
    }
}

