/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMatillion;
import com.atlan.model.assets.IMatillionComponent;
import com.atlan.model.assets.IMatillionJob;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatillionComponent
extends Asset
implements IMatillionComponent,
IMatillion,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MatillionComponent.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MatillionComponent";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    String matillionComponentId;
    @Attribute
    String matillionComponentImplementationId;
    @Attribute
    String matillionComponentLastFiveRunStatus;
    @Attribute
    String matillionComponentLastRunStatus;
    @Attribute
    Map<String, String> matillionComponentLinkedJob;
    @Attribute
    SortedSet<String> matillionComponentSqls;
    @Attribute
    IMatillionJob matillionJob;
    @Attribute
    String matillionJobName;
    @Attribute
    String matillionJobQualifiedName;
    @Attribute
    ILineageProcess matillionProcess;
    @Attribute
    String matillionVersion;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public MatillionComponent trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return MatillionComponent.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return MatillionComponent.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return MatillionComponent.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return MatillionComponent.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static MatillionComponent refByGuid(String guid) {
        return MatillionComponent.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static MatillionComponent refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((MatillionComponentBuilder)((MatillionComponentBuilder)MatillionComponent._internal().guid(guid)).semantic(semantic)).build();
    }

    public static MatillionComponent refByQualifiedName(String qualifiedName) {
        return MatillionComponent.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static MatillionComponent refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((MatillionComponentBuilder)((MatillionComponentBuilder)MatillionComponent._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static MatillionComponent get(AtlanClient client, String id) throws AtlanException {
        return MatillionComponent.get(client, id, false);
    }

    @JsonIgnore
    public static MatillionComponent get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof MatillionComponent) {
                return (MatillionComponent)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof MatillionComponent) {
            return (MatillionComponent)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static MatillionComponent get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return MatillionComponent.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static MatillionComponent get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)MatillionComponent.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof MatillionComponent) {
                return (MatillionComponent)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)MatillionComponent.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof MatillionComponent) {
            return (MatillionComponent)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static MatillionComponentBuilder<?, ?> updater(String qualifiedName, String name) {
        return (MatillionComponentBuilder)((MatillionComponentBuilder)((MatillionComponentBuilder)MatillionComponent._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public MatillionComponentBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        MatillionComponent.validateRequired(TYPE_NAME, map);
        return MatillionComponent.updater(this.getQualifiedName(), this.getName());
    }

    public static MatillionComponent removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionComponent)Asset.removeDescription(client, MatillionComponent.updater(qualifiedName, name));
    }

    public static MatillionComponent removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionComponent)Asset.removeUserDescription(client, MatillionComponent.updater(qualifiedName, name));
    }

    public static MatillionComponent removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionComponent)Asset.removeOwners(client, MatillionComponent.updater(qualifiedName, name));
    }

    public static MatillionComponent updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MatillionComponent)Asset.updateCertificate(client, MatillionComponent._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static MatillionComponent removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionComponent)Asset.removeCertificate(client, MatillionComponent.updater(qualifiedName, name));
    }

    public static MatillionComponent updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MatillionComponent)Asset.updateAnnouncement(client, MatillionComponent._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static MatillionComponent removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionComponent)Asset.removeAnnouncement(client, MatillionComponent.updater(qualifiedName, name));
    }

    public static MatillionComponent replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MatillionComponent)Asset.replaceTerms(client, MatillionComponent.updater(qualifiedName, name), terms);
    }

    public static MatillionComponent appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MatillionComponent)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static MatillionComponent removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MatillionComponent)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static MatillionComponent appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MatillionComponent)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static MatillionComponent appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MatillionComponent)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected MatillionComponent(MatillionComponentBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> matillionComponentLinkedJob;
        this.typeName = b.typeName$set ? b.typeName$value : MatillionComponent.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.matillionComponentId = b.matillionComponentId;
        this.matillionComponentImplementationId = b.matillionComponentImplementationId;
        this.matillionComponentLastFiveRunStatus = b.matillionComponentLastFiveRunStatus;
        this.matillionComponentLastRunStatus = b.matillionComponentLastRunStatus;
        switch (b.matillionComponentLinkedJob$key == null ? 0 : b.matillionComponentLinkedJob$key.size()) {
            case 0: {
                matillionComponentLinkedJob = Collections.emptyMap();
                break;
            }
            case 1: {
                matillionComponentLinkedJob = Collections.singletonMap(b.matillionComponentLinkedJob$key.get(0), b.matillionComponentLinkedJob$value.get(0));
                break;
            }
            default: {
                matillionComponentLinkedJob = new LinkedHashMap(b.matillionComponentLinkedJob$key.size() < 0x40000000 ? 1 + b.matillionComponentLinkedJob$key.size() + (b.matillionComponentLinkedJob$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.matillionComponentLinkedJob$key.size(); ++$i) {
                    matillionComponentLinkedJob.put(b.matillionComponentLinkedJob$key.get($i), b.matillionComponentLinkedJob$value.get($i));
                }
                matillionComponentLinkedJob = Collections.unmodifiableMap(matillionComponentLinkedJob);
            }
        }
        this.matillionComponentLinkedJob = matillionComponentLinkedJob;
        SortedSet<String> matillionComponentSqls = new TreeSet<String>();
        if (b.matillionComponentSqls != null) {
            matillionComponentSqls.addAll(b.matillionComponentSqls);
        }
        matillionComponentSqls = Collections.unmodifiableSortedSet(matillionComponentSqls);
        this.matillionComponentSqls = matillionComponentSqls;
        this.matillionJob = b.matillionJob;
        this.matillionJobName = b.matillionJobName;
        this.matillionJobQualifiedName = b.matillionJobQualifiedName;
        this.matillionProcess = b.matillionProcess;
        this.matillionVersion = b.matillionVersion;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static MatillionComponentBuilder<?, ?> _internal() {
        return new MatillionComponentBuilderImpl();
    }

    @Generated
    public MatillionComponentBuilder<?, ?> toBuilder() {
        return new MatillionComponentBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public String getMatillionComponentId() {
        return this.matillionComponentId;
    }

    @Override
    @Generated
    public String getMatillionComponentImplementationId() {
        return this.matillionComponentImplementationId;
    }

    @Override
    @Generated
    public String getMatillionComponentLastFiveRunStatus() {
        return this.matillionComponentLastFiveRunStatus;
    }

    @Override
    @Generated
    public String getMatillionComponentLastRunStatus() {
        return this.matillionComponentLastRunStatus;
    }

    @Override
    @Generated
    public Map<String, String> getMatillionComponentLinkedJob() {
        return this.matillionComponentLinkedJob;
    }

    @Override
    @Generated
    public SortedSet<String> getMatillionComponentSqls() {
        return this.matillionComponentSqls;
    }

    @Override
    @Generated
    public IMatillionJob getMatillionJob() {
        return this.matillionJob;
    }

    @Override
    @Generated
    public String getMatillionJobName() {
        return this.matillionJobName;
    }

    @Override
    @Generated
    public String getMatillionJobQualifiedName() {
        return this.matillionJobQualifiedName;
    }

    @Override
    @Generated
    public ILineageProcess getMatillionProcess() {
        return this.matillionProcess;
    }

    @Override
    @Generated
    public String getMatillionVersion() {
        return this.matillionVersion;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MatillionComponent)) {
            return false;
        }
        MatillionComponent other = (MatillionComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        String this$matillionComponentId = this.getMatillionComponentId();
        String other$matillionComponentId = other.getMatillionComponentId();
        if (this$matillionComponentId == null ? other$matillionComponentId != null : !this$matillionComponentId.equals(other$matillionComponentId)) {
            return false;
        }
        String this$matillionComponentImplementationId = this.getMatillionComponentImplementationId();
        String other$matillionComponentImplementationId = other.getMatillionComponentImplementationId();
        if (this$matillionComponentImplementationId == null ? other$matillionComponentImplementationId != null : !this$matillionComponentImplementationId.equals(other$matillionComponentImplementationId)) {
            return false;
        }
        String this$matillionComponentLastFiveRunStatus = this.getMatillionComponentLastFiveRunStatus();
        String other$matillionComponentLastFiveRunStatus = other.getMatillionComponentLastFiveRunStatus();
        if (this$matillionComponentLastFiveRunStatus == null ? other$matillionComponentLastFiveRunStatus != null : !this$matillionComponentLastFiveRunStatus.equals(other$matillionComponentLastFiveRunStatus)) {
            return false;
        }
        String this$matillionComponentLastRunStatus = this.getMatillionComponentLastRunStatus();
        String other$matillionComponentLastRunStatus = other.getMatillionComponentLastRunStatus();
        if (this$matillionComponentLastRunStatus == null ? other$matillionComponentLastRunStatus != null : !this$matillionComponentLastRunStatus.equals(other$matillionComponentLastRunStatus)) {
            return false;
        }
        Map<String, String> this$matillionComponentLinkedJob = this.getMatillionComponentLinkedJob();
        Map<String, String> other$matillionComponentLinkedJob = other.getMatillionComponentLinkedJob();
        if (this$matillionComponentLinkedJob == null ? other$matillionComponentLinkedJob != null : !((Object)this$matillionComponentLinkedJob).equals(other$matillionComponentLinkedJob)) {
            return false;
        }
        SortedSet<String> this$matillionComponentSqls = this.getMatillionComponentSqls();
        SortedSet<String> other$matillionComponentSqls = other.getMatillionComponentSqls();
        if (this$matillionComponentSqls == null ? other$matillionComponentSqls != null : !this$matillionComponentSqls.equals(other$matillionComponentSqls)) {
            return false;
        }
        IMatillionJob this$matillionJob = this.getMatillionJob();
        IMatillionJob other$matillionJob = other.getMatillionJob();
        if (this$matillionJob == null ? other$matillionJob != null : !this$matillionJob.equals(other$matillionJob)) {
            return false;
        }
        String this$matillionJobName = this.getMatillionJobName();
        String other$matillionJobName = other.getMatillionJobName();
        if (this$matillionJobName == null ? other$matillionJobName != null : !this$matillionJobName.equals(other$matillionJobName)) {
            return false;
        }
        String this$matillionJobQualifiedName = this.getMatillionJobQualifiedName();
        String other$matillionJobQualifiedName = other.getMatillionJobQualifiedName();
        if (this$matillionJobQualifiedName == null ? other$matillionJobQualifiedName != null : !this$matillionJobQualifiedName.equals(other$matillionJobQualifiedName)) {
            return false;
        }
        ILineageProcess this$matillionProcess = this.getMatillionProcess();
        ILineageProcess other$matillionProcess = other.getMatillionProcess();
        if (this$matillionProcess == null ? other$matillionProcess != null : !this$matillionProcess.equals(other$matillionProcess)) {
            return false;
        }
        String this$matillionVersion = this.getMatillionVersion();
        String other$matillionVersion = other.getMatillionVersion();
        if (this$matillionVersion == null ? other$matillionVersion != null : !this$matillionVersion.equals(other$matillionVersion)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MatillionComponent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        String $matillionComponentId = this.getMatillionComponentId();
        result = result * 59 + ($matillionComponentId == null ? 43 : $matillionComponentId.hashCode());
        String $matillionComponentImplementationId = this.getMatillionComponentImplementationId();
        result = result * 59 + ($matillionComponentImplementationId == null ? 43 : $matillionComponentImplementationId.hashCode());
        String $matillionComponentLastFiveRunStatus = this.getMatillionComponentLastFiveRunStatus();
        result = result * 59 + ($matillionComponentLastFiveRunStatus == null ? 43 : $matillionComponentLastFiveRunStatus.hashCode());
        String $matillionComponentLastRunStatus = this.getMatillionComponentLastRunStatus();
        result = result * 59 + ($matillionComponentLastRunStatus == null ? 43 : $matillionComponentLastRunStatus.hashCode());
        Map<String, String> $matillionComponentLinkedJob = this.getMatillionComponentLinkedJob();
        result = result * 59 + ($matillionComponentLinkedJob == null ? 43 : ((Object)$matillionComponentLinkedJob).hashCode());
        SortedSet<String> $matillionComponentSqls = this.getMatillionComponentSqls();
        result = result * 59 + ($matillionComponentSqls == null ? 43 : $matillionComponentSqls.hashCode());
        IMatillionJob $matillionJob = this.getMatillionJob();
        result = result * 59 + ($matillionJob == null ? 43 : $matillionJob.hashCode());
        String $matillionJobName = this.getMatillionJobName();
        result = result * 59 + ($matillionJobName == null ? 43 : $matillionJobName.hashCode());
        String $matillionJobQualifiedName = this.getMatillionJobQualifiedName();
        result = result * 59 + ($matillionJobQualifiedName == null ? 43 : $matillionJobQualifiedName.hashCode());
        ILineageProcess $matillionProcess = this.getMatillionProcess();
        result = result * 59 + ($matillionProcess == null ? 43 : $matillionProcess.hashCode());
        String $matillionVersion = this.getMatillionVersion();
        result = result * 59 + ($matillionVersion == null ? 43 : $matillionVersion.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "MatillionComponent(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", matillionComponentId=" + this.getMatillionComponentId() + ", matillionComponentImplementationId=" + this.getMatillionComponentImplementationId() + ", matillionComponentLastFiveRunStatus=" + this.getMatillionComponentLastFiveRunStatus() + ", matillionComponentLastRunStatus=" + this.getMatillionComponentLastRunStatus() + ", matillionComponentLinkedJob=" + String.valueOf(this.getMatillionComponentLinkedJob()) + ", matillionComponentSqls=" + String.valueOf(this.getMatillionComponentSqls()) + ", matillionJob=" + String.valueOf(this.getMatillionJob()) + ", matillionJobName=" + this.getMatillionJobName() + ", matillionJobQualifiedName=" + this.getMatillionJobQualifiedName() + ", matillionProcess=" + String.valueOf(this.getMatillionProcess()) + ", matillionVersion=" + this.getMatillionVersion() + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class MatillionComponentBuilder<C extends MatillionComponent, B extends MatillionComponentBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private String matillionComponentId;
        @Generated
        private String matillionComponentImplementationId;
        @Generated
        private String matillionComponentLastFiveRunStatus;
        @Generated
        private String matillionComponentLastRunStatus;
        @Generated
        private ArrayList<String> matillionComponentLinkedJob$key;
        @Generated
        private ArrayList<String> matillionComponentLinkedJob$value;
        @Generated
        private ArrayList<String> matillionComponentSqls;
        @Generated
        private IMatillionJob matillionJob;
        @Generated
        private String matillionJobName;
        @Generated
        private String matillionJobQualifiedName;
        @Generated
        private ILineageProcess matillionProcess;
        @Generated
        private String matillionVersion;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MatillionComponentBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MatillionComponent instance, MatillionComponentBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.matillionComponentId(instance.matillionComponentId);
            b.matillionComponentImplementationId(instance.matillionComponentImplementationId);
            b.matillionComponentLastFiveRunStatus(instance.matillionComponentLastFiveRunStatus);
            b.matillionComponentLastRunStatus(instance.matillionComponentLastRunStatus);
            b.matillionComponentLinkedJob(instance.matillionComponentLinkedJob == null ? Collections.emptyMap() : instance.matillionComponentLinkedJob);
            b.matillionComponentSqls(instance.matillionComponentSqls == null ? Collections.emptySortedSet() : instance.matillionComponentSqls);
            b.matillionJob(instance.matillionJob);
            b.matillionJobName(instance.matillionJobName);
            b.matillionJobQualifiedName(instance.matillionJobQualifiedName);
            b.matillionProcess(instance.matillionProcess);
            b.matillionVersion(instance.matillionVersion);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B matillionComponentId(String matillionComponentId) {
            this.matillionComponentId = matillionComponentId;
            return (B)this.self();
        }

        @Generated
        public B matillionComponentImplementationId(String matillionComponentImplementationId) {
            this.matillionComponentImplementationId = matillionComponentImplementationId;
            return (B)this.self();
        }

        @Generated
        public B matillionComponentLastFiveRunStatus(String matillionComponentLastFiveRunStatus) {
            this.matillionComponentLastFiveRunStatus = matillionComponentLastFiveRunStatus;
            return (B)this.self();
        }

        @Generated
        public B matillionComponentLastRunStatus(String matillionComponentLastRunStatus) {
            this.matillionComponentLastRunStatus = matillionComponentLastRunStatus;
            return (B)this.self();
        }

        @Generated
        public B putMatillionComponentLinkedJob(String putMatillionComponentLinkedJobKey, String putMatillionComponentLinkedJobValue) {
            if (this.matillionComponentLinkedJob$key == null) {
                this.matillionComponentLinkedJob$key = new ArrayList();
                this.matillionComponentLinkedJob$value = new ArrayList();
            }
            this.matillionComponentLinkedJob$key.add(putMatillionComponentLinkedJobKey);
            this.matillionComponentLinkedJob$value.add(putMatillionComponentLinkedJobValue);
            return (B)this.self();
        }

        @Generated
        public B matillionComponentLinkedJob(Map<? extends String, ? extends String> matillionComponentLinkedJob) {
            if (matillionComponentLinkedJob == null) {
                throw new NullPointerException("matillionComponentLinkedJob cannot be null");
            }
            if (this.matillionComponentLinkedJob$key == null) {
                this.matillionComponentLinkedJob$key = new ArrayList();
                this.matillionComponentLinkedJob$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : matillionComponentLinkedJob.entrySet()) {
                this.matillionComponentLinkedJob$key.add($lombokEntry.getKey());
                this.matillionComponentLinkedJob$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearMatillionComponentLinkedJob() {
            if (this.matillionComponentLinkedJob$key != null) {
                this.matillionComponentLinkedJob$key.clear();
                this.matillionComponentLinkedJob$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B matillionComponentSql(String matillionComponentSql) {
            if (this.matillionComponentSqls == null) {
                this.matillionComponentSqls = new ArrayList();
            }
            this.matillionComponentSqls.add(matillionComponentSql);
            return (B)this.self();
        }

        @Generated
        public B matillionComponentSqls(Collection<? extends String> matillionComponentSqls) {
            if (matillionComponentSqls == null) {
                throw new NullPointerException("matillionComponentSqls cannot be null");
            }
            if (this.matillionComponentSqls == null) {
                this.matillionComponentSqls = new ArrayList();
            }
            this.matillionComponentSqls.addAll(matillionComponentSqls);
            return (B)this.self();
        }

        @Generated
        public B clearMatillionComponentSqls() {
            if (this.matillionComponentSqls != null) {
                this.matillionComponentSqls.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B matillionJob(IMatillionJob matillionJob) {
            this.matillionJob = matillionJob;
            return (B)this.self();
        }

        @Generated
        public B matillionJobName(String matillionJobName) {
            this.matillionJobName = matillionJobName;
            return (B)this.self();
        }

        @Generated
        public B matillionJobQualifiedName(String matillionJobQualifiedName) {
            this.matillionJobQualifiedName = matillionJobQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B matillionProcess(ILineageProcess matillionProcess) {
            this.matillionProcess = matillionProcess;
            return (B)this.self();
        }

        @Generated
        public B matillionVersion(String matillionVersion) {
            this.matillionVersion = matillionVersion;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "MatillionComponent.MatillionComponentBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", matillionComponentId=" + this.matillionComponentId + ", matillionComponentImplementationId=" + this.matillionComponentImplementationId + ", matillionComponentLastFiveRunStatus=" + this.matillionComponentLastFiveRunStatus + ", matillionComponentLastRunStatus=" + this.matillionComponentLastRunStatus + ", matillionComponentLinkedJob$key=" + String.valueOf(this.matillionComponentLinkedJob$key) + ", matillionComponentLinkedJob$value=" + String.valueOf(this.matillionComponentLinkedJob$value) + ", matillionComponentSqls=" + String.valueOf(this.matillionComponentSqls) + ", matillionJob=" + String.valueOf(this.matillionJob) + ", matillionJobName=" + this.matillionJobName + ", matillionJobQualifiedName=" + this.matillionJobQualifiedName + ", matillionProcess=" + String.valueOf(this.matillionProcess) + ", matillionVersion=" + this.matillionVersion + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class MatillionComponentBuilderImpl
    extends MatillionComponentBuilder<MatillionComponent, MatillionComponentBuilderImpl> {
        @Generated
        private MatillionComponentBuilderImpl() {
        }

        @Override
        @Generated
        protected MatillionComponentBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MatillionComponent build() {
            return new MatillionComponent(this);
        }
    }
}

