/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMatillion;
import com.atlan.model.assets.IMatillionComponent;
import com.atlan.model.assets.IMatillionJob;
import com.atlan.model.assets.IMatillionProject;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.MatillionJobType;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatillionJob
extends Asset
implements IMatillionJob,
IMatillion,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MatillionJob.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MatillionJob";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IMatillionComponent> matillionComponents;
    @Attribute
    Long matillionJobComponentCount;
    @Attribute
    String matillionJobPath;
    @Attribute
    String matillionJobSchedule;
    @Attribute
    MatillionJobType matillionJobType;
    @Attribute
    IMatillionProject matillionProject;
    @Attribute
    String matillionProjectName;
    @Attribute
    String matillionProjectQualifiedName;
    @Attribute
    String matillionVersion;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public MatillionJob trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return MatillionJob.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return MatillionJob.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return MatillionJob.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return MatillionJob.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static MatillionJob refByGuid(String guid) {
        return MatillionJob.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static MatillionJob refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((MatillionJobBuilder)((MatillionJobBuilder)MatillionJob._internal().guid(guid)).semantic(semantic)).build();
    }

    public static MatillionJob refByQualifiedName(String qualifiedName) {
        return MatillionJob.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static MatillionJob refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((MatillionJobBuilder)((MatillionJobBuilder)MatillionJob._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static MatillionJob get(AtlanClient client, String id) throws AtlanException {
        return MatillionJob.get(client, id, false);
    }

    @JsonIgnore
    public static MatillionJob get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof MatillionJob) {
                return (MatillionJob)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof MatillionJob) {
            return (MatillionJob)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static MatillionJob get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return MatillionJob.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static MatillionJob get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)MatillionJob.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof MatillionJob) {
                return (MatillionJob)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)MatillionJob.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof MatillionJob) {
            return (MatillionJob)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static MatillionJobBuilder<?, ?> updater(String qualifiedName, String name) {
        return (MatillionJobBuilder)((MatillionJobBuilder)((MatillionJobBuilder)MatillionJob._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public MatillionJobBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        MatillionJob.validateRequired(TYPE_NAME, map);
        return MatillionJob.updater(this.getQualifiedName(), this.getName());
    }

    public static MatillionJob removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionJob)Asset.removeDescription(client, MatillionJob.updater(qualifiedName, name));
    }

    public static MatillionJob removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionJob)Asset.removeUserDescription(client, MatillionJob.updater(qualifiedName, name));
    }

    public static MatillionJob removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionJob)Asset.removeOwners(client, MatillionJob.updater(qualifiedName, name));
    }

    public static MatillionJob updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MatillionJob)Asset.updateCertificate(client, MatillionJob._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static MatillionJob removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionJob)Asset.removeCertificate(client, MatillionJob.updater(qualifiedName, name));
    }

    public static MatillionJob updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MatillionJob)Asset.updateAnnouncement(client, MatillionJob._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static MatillionJob removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionJob)Asset.removeAnnouncement(client, MatillionJob.updater(qualifiedName, name));
    }

    public static MatillionJob replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MatillionJob)Asset.replaceTerms(client, MatillionJob.updater(qualifiedName, name), terms);
    }

    public static MatillionJob appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MatillionJob)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static MatillionJob removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MatillionJob)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static MatillionJob appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MatillionJob)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static MatillionJob appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MatillionJob)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected MatillionJob(MatillionJobBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : MatillionJob.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IMatillionComponent> matillionComponents = new TreeSet<IMatillionComponent>();
        if (b.matillionComponents != null) {
            matillionComponents.addAll(b.matillionComponents);
        }
        matillionComponents = Collections.unmodifiableSortedSet(matillionComponents);
        this.matillionComponents = matillionComponents;
        this.matillionJobComponentCount = b.matillionJobComponentCount;
        this.matillionJobPath = b.matillionJobPath;
        this.matillionJobSchedule = b.matillionJobSchedule;
        this.matillionJobType = b.matillionJobType;
        this.matillionProject = b.matillionProject;
        this.matillionProjectName = b.matillionProjectName;
        this.matillionProjectQualifiedName = b.matillionProjectQualifiedName;
        this.matillionVersion = b.matillionVersion;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static MatillionJobBuilder<?, ?> _internal() {
        return new MatillionJobBuilderImpl();
    }

    @Generated
    public MatillionJobBuilder<?, ?> toBuilder() {
        return new MatillionJobBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IMatillionComponent> getMatillionComponents() {
        return this.matillionComponents;
    }

    @Override
    @Generated
    public Long getMatillionJobComponentCount() {
        return this.matillionJobComponentCount;
    }

    @Override
    @Generated
    public String getMatillionJobPath() {
        return this.matillionJobPath;
    }

    @Override
    @Generated
    public String getMatillionJobSchedule() {
        return this.matillionJobSchedule;
    }

    @Override
    @Generated
    public MatillionJobType getMatillionJobType() {
        return this.matillionJobType;
    }

    @Override
    @Generated
    public IMatillionProject getMatillionProject() {
        return this.matillionProject;
    }

    @Override
    @Generated
    public String getMatillionProjectName() {
        return this.matillionProjectName;
    }

    @Override
    @Generated
    public String getMatillionProjectQualifiedName() {
        return this.matillionProjectQualifiedName;
    }

    @Override
    @Generated
    public String getMatillionVersion() {
        return this.matillionVersion;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MatillionJob)) {
            return false;
        }
        MatillionJob other = (MatillionJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$matillionJobComponentCount = this.getMatillionJobComponentCount();
        Long other$matillionJobComponentCount = other.getMatillionJobComponentCount();
        if (this$matillionJobComponentCount == null ? other$matillionJobComponentCount != null : !((Object)this$matillionJobComponentCount).equals(other$matillionJobComponentCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IMatillionComponent> this$matillionComponents = this.getMatillionComponents();
        SortedSet<IMatillionComponent> other$matillionComponents = other.getMatillionComponents();
        if (this$matillionComponents == null ? other$matillionComponents != null : !this$matillionComponents.equals(other$matillionComponents)) {
            return false;
        }
        String this$matillionJobPath = this.getMatillionJobPath();
        String other$matillionJobPath = other.getMatillionJobPath();
        if (this$matillionJobPath == null ? other$matillionJobPath != null : !this$matillionJobPath.equals(other$matillionJobPath)) {
            return false;
        }
        String this$matillionJobSchedule = this.getMatillionJobSchedule();
        String other$matillionJobSchedule = other.getMatillionJobSchedule();
        if (this$matillionJobSchedule == null ? other$matillionJobSchedule != null : !this$matillionJobSchedule.equals(other$matillionJobSchedule)) {
            return false;
        }
        MatillionJobType this$matillionJobType = this.getMatillionJobType();
        MatillionJobType other$matillionJobType = other.getMatillionJobType();
        if (this$matillionJobType == null ? other$matillionJobType != null : !this$matillionJobType.equals(other$matillionJobType)) {
            return false;
        }
        IMatillionProject this$matillionProject = this.getMatillionProject();
        IMatillionProject other$matillionProject = other.getMatillionProject();
        if (this$matillionProject == null ? other$matillionProject != null : !this$matillionProject.equals(other$matillionProject)) {
            return false;
        }
        String this$matillionProjectName = this.getMatillionProjectName();
        String other$matillionProjectName = other.getMatillionProjectName();
        if (this$matillionProjectName == null ? other$matillionProjectName != null : !this$matillionProjectName.equals(other$matillionProjectName)) {
            return false;
        }
        String this$matillionProjectQualifiedName = this.getMatillionProjectQualifiedName();
        String other$matillionProjectQualifiedName = other.getMatillionProjectQualifiedName();
        if (this$matillionProjectQualifiedName == null ? other$matillionProjectQualifiedName != null : !this$matillionProjectQualifiedName.equals(other$matillionProjectQualifiedName)) {
            return false;
        }
        String this$matillionVersion = this.getMatillionVersion();
        String other$matillionVersion = other.getMatillionVersion();
        if (this$matillionVersion == null ? other$matillionVersion != null : !this$matillionVersion.equals(other$matillionVersion)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MatillionJob;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $matillionJobComponentCount = this.getMatillionJobComponentCount();
        result = result * 59 + ($matillionJobComponentCount == null ? 43 : ((Object)$matillionJobComponentCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IMatillionComponent> $matillionComponents = this.getMatillionComponents();
        result = result * 59 + ($matillionComponents == null ? 43 : $matillionComponents.hashCode());
        String $matillionJobPath = this.getMatillionJobPath();
        result = result * 59 + ($matillionJobPath == null ? 43 : $matillionJobPath.hashCode());
        String $matillionJobSchedule = this.getMatillionJobSchedule();
        result = result * 59 + ($matillionJobSchedule == null ? 43 : $matillionJobSchedule.hashCode());
        MatillionJobType $matillionJobType = this.getMatillionJobType();
        result = result * 59 + ($matillionJobType == null ? 43 : $matillionJobType.hashCode());
        IMatillionProject $matillionProject = this.getMatillionProject();
        result = result * 59 + ($matillionProject == null ? 43 : $matillionProject.hashCode());
        String $matillionProjectName = this.getMatillionProjectName();
        result = result * 59 + ($matillionProjectName == null ? 43 : $matillionProjectName.hashCode());
        String $matillionProjectQualifiedName = this.getMatillionProjectQualifiedName();
        result = result * 59 + ($matillionProjectQualifiedName == null ? 43 : $matillionProjectQualifiedName.hashCode());
        String $matillionVersion = this.getMatillionVersion();
        result = result * 59 + ($matillionVersion == null ? 43 : $matillionVersion.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "MatillionJob(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", matillionComponents=" + String.valueOf(this.getMatillionComponents()) + ", matillionJobComponentCount=" + this.getMatillionJobComponentCount() + ", matillionJobPath=" + this.getMatillionJobPath() + ", matillionJobSchedule=" + this.getMatillionJobSchedule() + ", matillionJobType=" + String.valueOf(this.getMatillionJobType()) + ", matillionProject=" + String.valueOf(this.getMatillionProject()) + ", matillionProjectName=" + this.getMatillionProjectName() + ", matillionProjectQualifiedName=" + this.getMatillionProjectQualifiedName() + ", matillionVersion=" + this.getMatillionVersion() + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class MatillionJobBuilder<C extends MatillionJob, B extends MatillionJobBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IMatillionComponent> matillionComponents;
        @Generated
        private Long matillionJobComponentCount;
        @Generated
        private String matillionJobPath;
        @Generated
        private String matillionJobSchedule;
        @Generated
        private MatillionJobType matillionJobType;
        @Generated
        private IMatillionProject matillionProject;
        @Generated
        private String matillionProjectName;
        @Generated
        private String matillionProjectQualifiedName;
        @Generated
        private String matillionVersion;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MatillionJobBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MatillionJob instance, MatillionJobBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.matillionComponents(instance.matillionComponents == null ? Collections.emptySortedSet() : instance.matillionComponents);
            b.matillionJobComponentCount(instance.matillionJobComponentCount);
            b.matillionJobPath(instance.matillionJobPath);
            b.matillionJobSchedule(instance.matillionJobSchedule);
            b.matillionJobType(instance.matillionJobType);
            b.matillionProject(instance.matillionProject);
            b.matillionProjectName(instance.matillionProjectName);
            b.matillionProjectQualifiedName(instance.matillionProjectQualifiedName);
            b.matillionVersion(instance.matillionVersion);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B matillionComponent(IMatillionComponent matillionComponent) {
            if (this.matillionComponents == null) {
                this.matillionComponents = new ArrayList();
            }
            this.matillionComponents.add(matillionComponent);
            return (B)this.self();
        }

        @Generated
        public B matillionComponents(Collection<? extends IMatillionComponent> matillionComponents) {
            if (matillionComponents == null) {
                throw new NullPointerException("matillionComponents cannot be null");
            }
            if (this.matillionComponents == null) {
                this.matillionComponents = new ArrayList();
            }
            this.matillionComponents.addAll(matillionComponents);
            return (B)this.self();
        }

        @Generated
        public B clearMatillionComponents() {
            if (this.matillionComponents != null) {
                this.matillionComponents.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B matillionJobComponentCount(Long matillionJobComponentCount) {
            this.matillionJobComponentCount = matillionJobComponentCount;
            return (B)this.self();
        }

        @Generated
        public B matillionJobPath(String matillionJobPath) {
            this.matillionJobPath = matillionJobPath;
            return (B)this.self();
        }

        @Generated
        public B matillionJobSchedule(String matillionJobSchedule) {
            this.matillionJobSchedule = matillionJobSchedule;
            return (B)this.self();
        }

        @Generated
        public B matillionJobType(MatillionJobType matillionJobType) {
            this.matillionJobType = matillionJobType;
            return (B)this.self();
        }

        @Generated
        public B matillionProject(IMatillionProject matillionProject) {
            this.matillionProject = matillionProject;
            return (B)this.self();
        }

        @Generated
        public B matillionProjectName(String matillionProjectName) {
            this.matillionProjectName = matillionProjectName;
            return (B)this.self();
        }

        @Generated
        public B matillionProjectQualifiedName(String matillionProjectQualifiedName) {
            this.matillionProjectQualifiedName = matillionProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B matillionVersion(String matillionVersion) {
            this.matillionVersion = matillionVersion;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "MatillionJob.MatillionJobBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", matillionComponents=" + String.valueOf(this.matillionComponents) + ", matillionJobComponentCount=" + this.matillionJobComponentCount + ", matillionJobPath=" + this.matillionJobPath + ", matillionJobSchedule=" + this.matillionJobSchedule + ", matillionJobType=" + String.valueOf(this.matillionJobType) + ", matillionProject=" + String.valueOf(this.matillionProject) + ", matillionProjectName=" + this.matillionProjectName + ", matillionProjectQualifiedName=" + this.matillionProjectQualifiedName + ", matillionVersion=" + this.matillionVersion + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class MatillionJobBuilderImpl
    extends MatillionJobBuilder<MatillionJob, MatillionJobBuilderImpl> {
        @Generated
        private MatillionJobBuilderImpl() {
        }

        @Override
        @Generated
        protected MatillionJobBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MatillionJob build() {
            return new MatillionJob(this);
        }
    }
}

