/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMode;
import com.atlan.model.assets.IModeCollection;
import com.atlan.model.assets.IModeQuery;
import com.atlan.model.assets.IModeReport;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeReport
extends Asset
implements IModeReport,
IMode,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModeReport.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ModeReport";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    Long modeChartCount;
    @Attribute
    String modeCollectionToken;
    @Attribute
    SortedSet<IModeCollection> modeCollections;
    @Attribute
    String modeId;
    @Attribute
    Boolean modeIsPublic;
    @Attribute
    Boolean modeIsShared;
    @Attribute
    SortedSet<IModeQuery> modeQueries;
    @Attribute
    Long modeQueryCount;
    @Attribute
    String modeQueryName;
    @Attribute
    String modeQueryPreview;
    @Attribute
    String modeQueryQualifiedName;
    @Attribute
    String modeReportName;
    @Attribute
    @Date
    Long modeReportPublishedAt;
    @Attribute
    String modeReportQualifiedName;
    @Attribute
    String modeToken;
    @Attribute
    String modeWorkspaceName;
    @Attribute
    String modeWorkspaceQualifiedName;
    @Attribute
    String modeWorkspaceUsername;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public ModeReport trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ModeReport.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ModeReport.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ModeReport.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ModeReport.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static ModeReport refByGuid(String guid) {
        return ModeReport.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static ModeReport refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((ModeReportBuilder)((ModeReportBuilder)ModeReport._internal().guid(guid)).semantic(semantic)).build();
    }

    public static ModeReport refByQualifiedName(String qualifiedName) {
        return ModeReport.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static ModeReport refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((ModeReportBuilder)((ModeReportBuilder)ModeReport._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static ModeReport get(AtlanClient client, String id) throws AtlanException {
        return ModeReport.get(client, id, false);
    }

    @JsonIgnore
    public static ModeReport get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ModeReport) {
                return (ModeReport)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof ModeReport) {
            return (ModeReport)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static ModeReport get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return ModeReport.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static ModeReport get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)ModeReport.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof ModeReport) {
                return (ModeReport)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)ModeReport.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof ModeReport) {
            return (ModeReport)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ModeReportBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ModeReportBuilder)((ModeReportBuilder)((ModeReportBuilder)ModeReport._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ModeReportBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        ModeReport.validateRequired(TYPE_NAME, map);
        return ModeReport.updater(this.getQualifiedName(), this.getName());
    }

    public static ModeReport removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeReport)Asset.removeDescription(client, ModeReport.updater(qualifiedName, name));
    }

    public static ModeReport removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeReport)Asset.removeUserDescription(client, ModeReport.updater(qualifiedName, name));
    }

    public static ModeReport removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeReport)Asset.removeOwners(client, ModeReport.updater(qualifiedName, name));
    }

    public static ModeReport updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ModeReport)Asset.updateCertificate(client, ModeReport._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ModeReport removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeReport)Asset.removeCertificate(client, ModeReport.updater(qualifiedName, name));
    }

    public static ModeReport updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ModeReport)Asset.updateAnnouncement(client, ModeReport._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ModeReport removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeReport)Asset.removeAnnouncement(client, ModeReport.updater(qualifiedName, name));
    }

    public static ModeReport replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModeReport)Asset.replaceTerms(client, ModeReport.updater(qualifiedName, name), terms);
    }

    public static ModeReport appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModeReport)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ModeReport removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModeReport)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ModeReport appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ModeReport)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static ModeReport appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ModeReport)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ModeReport(ModeReportBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ModeReport.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.modeChartCount = b.modeChartCount;
        this.modeCollectionToken = b.modeCollectionToken;
        SortedSet<IModeCollection> modeCollections = new TreeSet<IModeCollection>();
        if (b.modeCollections != null) {
            modeCollections.addAll(b.modeCollections);
        }
        modeCollections = Collections.unmodifiableSortedSet(modeCollections);
        this.modeCollections = modeCollections;
        this.modeId = b.modeId;
        this.modeIsPublic = b.modeIsPublic;
        this.modeIsShared = b.modeIsShared;
        SortedSet<IModeQuery> modeQueries = new TreeSet<IModeQuery>();
        if (b.modeQueries != null) {
            modeQueries.addAll(b.modeQueries);
        }
        modeQueries = Collections.unmodifiableSortedSet(modeQueries);
        this.modeQueries = modeQueries;
        this.modeQueryCount = b.modeQueryCount;
        this.modeQueryName = b.modeQueryName;
        this.modeQueryPreview = b.modeQueryPreview;
        this.modeQueryQualifiedName = b.modeQueryQualifiedName;
        this.modeReportName = b.modeReportName;
        this.modeReportPublishedAt = b.modeReportPublishedAt;
        this.modeReportQualifiedName = b.modeReportQualifiedName;
        this.modeToken = b.modeToken;
        this.modeWorkspaceName = b.modeWorkspaceName;
        this.modeWorkspaceQualifiedName = b.modeWorkspaceQualifiedName;
        this.modeWorkspaceUsername = b.modeWorkspaceUsername;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static ModeReportBuilder<?, ?> _internal() {
        return new ModeReportBuilderImpl();
    }

    @Generated
    public ModeReportBuilder<?, ?> toBuilder() {
        return new ModeReportBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public Long getModeChartCount() {
        return this.modeChartCount;
    }

    @Override
    @Generated
    public String getModeCollectionToken() {
        return this.modeCollectionToken;
    }

    @Override
    @Generated
    public SortedSet<IModeCollection> getModeCollections() {
        return this.modeCollections;
    }

    @Override
    @Generated
    public String getModeId() {
        return this.modeId;
    }

    @Override
    @Generated
    public Boolean getModeIsPublic() {
        return this.modeIsPublic;
    }

    @Override
    @Generated
    public Boolean getModeIsShared() {
        return this.modeIsShared;
    }

    @Override
    @Generated
    public SortedSet<IModeQuery> getModeQueries() {
        return this.modeQueries;
    }

    @Override
    @Generated
    public Long getModeQueryCount() {
        return this.modeQueryCount;
    }

    @Override
    @Generated
    public String getModeQueryName() {
        return this.modeQueryName;
    }

    @Override
    @Generated
    public String getModeQueryPreview() {
        return this.modeQueryPreview;
    }

    @Override
    @Generated
    public String getModeQueryQualifiedName() {
        return this.modeQueryQualifiedName;
    }

    @Override
    @Generated
    public String getModeReportName() {
        return this.modeReportName;
    }

    @Override
    @Generated
    public Long getModeReportPublishedAt() {
        return this.modeReportPublishedAt;
    }

    @Override
    @Generated
    public String getModeReportQualifiedName() {
        return this.modeReportQualifiedName;
    }

    @Override
    @Generated
    public String getModeToken() {
        return this.modeToken;
    }

    @Override
    @Generated
    public String getModeWorkspaceName() {
        return this.modeWorkspaceName;
    }

    @Override
    @Generated
    public String getModeWorkspaceQualifiedName() {
        return this.modeWorkspaceQualifiedName;
    }

    @Override
    @Generated
    public String getModeWorkspaceUsername() {
        return this.modeWorkspaceUsername;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModeReport)) {
            return false;
        }
        ModeReport other = (ModeReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$modeChartCount = this.getModeChartCount();
        Long other$modeChartCount = other.getModeChartCount();
        if (this$modeChartCount == null ? other$modeChartCount != null : !((Object)this$modeChartCount).equals(other$modeChartCount)) {
            return false;
        }
        Boolean this$modeIsPublic = this.getModeIsPublic();
        Boolean other$modeIsPublic = other.getModeIsPublic();
        if (this$modeIsPublic == null ? other$modeIsPublic != null : !((Object)this$modeIsPublic).equals(other$modeIsPublic)) {
            return false;
        }
        Boolean this$modeIsShared = this.getModeIsShared();
        Boolean other$modeIsShared = other.getModeIsShared();
        if (this$modeIsShared == null ? other$modeIsShared != null : !((Object)this$modeIsShared).equals(other$modeIsShared)) {
            return false;
        }
        Long this$modeQueryCount = this.getModeQueryCount();
        Long other$modeQueryCount = other.getModeQueryCount();
        if (this$modeQueryCount == null ? other$modeQueryCount != null : !((Object)this$modeQueryCount).equals(other$modeQueryCount)) {
            return false;
        }
        Long this$modeReportPublishedAt = this.getModeReportPublishedAt();
        Long other$modeReportPublishedAt = other.getModeReportPublishedAt();
        if (this$modeReportPublishedAt == null ? other$modeReportPublishedAt != null : !((Object)this$modeReportPublishedAt).equals(other$modeReportPublishedAt)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        String this$modeCollectionToken = this.getModeCollectionToken();
        String other$modeCollectionToken = other.getModeCollectionToken();
        if (this$modeCollectionToken == null ? other$modeCollectionToken != null : !this$modeCollectionToken.equals(other$modeCollectionToken)) {
            return false;
        }
        SortedSet<IModeCollection> this$modeCollections = this.getModeCollections();
        SortedSet<IModeCollection> other$modeCollections = other.getModeCollections();
        if (this$modeCollections == null ? other$modeCollections != null : !this$modeCollections.equals(other$modeCollections)) {
            return false;
        }
        String this$modeId = this.getModeId();
        String other$modeId = other.getModeId();
        if (this$modeId == null ? other$modeId != null : !this$modeId.equals(other$modeId)) {
            return false;
        }
        SortedSet<IModeQuery> this$modeQueries = this.getModeQueries();
        SortedSet<IModeQuery> other$modeQueries = other.getModeQueries();
        if (this$modeQueries == null ? other$modeQueries != null : !this$modeQueries.equals(other$modeQueries)) {
            return false;
        }
        String this$modeQueryName = this.getModeQueryName();
        String other$modeQueryName = other.getModeQueryName();
        if (this$modeQueryName == null ? other$modeQueryName != null : !this$modeQueryName.equals(other$modeQueryName)) {
            return false;
        }
        String this$modeQueryPreview = this.getModeQueryPreview();
        String other$modeQueryPreview = other.getModeQueryPreview();
        if (this$modeQueryPreview == null ? other$modeQueryPreview != null : !this$modeQueryPreview.equals(other$modeQueryPreview)) {
            return false;
        }
        String this$modeQueryQualifiedName = this.getModeQueryQualifiedName();
        String other$modeQueryQualifiedName = other.getModeQueryQualifiedName();
        if (this$modeQueryQualifiedName == null ? other$modeQueryQualifiedName != null : !this$modeQueryQualifiedName.equals(other$modeQueryQualifiedName)) {
            return false;
        }
        String this$modeReportName = this.getModeReportName();
        String other$modeReportName = other.getModeReportName();
        if (this$modeReportName == null ? other$modeReportName != null : !this$modeReportName.equals(other$modeReportName)) {
            return false;
        }
        String this$modeReportQualifiedName = this.getModeReportQualifiedName();
        String other$modeReportQualifiedName = other.getModeReportQualifiedName();
        if (this$modeReportQualifiedName == null ? other$modeReportQualifiedName != null : !this$modeReportQualifiedName.equals(other$modeReportQualifiedName)) {
            return false;
        }
        String this$modeToken = this.getModeToken();
        String other$modeToken = other.getModeToken();
        if (this$modeToken == null ? other$modeToken != null : !this$modeToken.equals(other$modeToken)) {
            return false;
        }
        String this$modeWorkspaceName = this.getModeWorkspaceName();
        String other$modeWorkspaceName = other.getModeWorkspaceName();
        if (this$modeWorkspaceName == null ? other$modeWorkspaceName != null : !this$modeWorkspaceName.equals(other$modeWorkspaceName)) {
            return false;
        }
        String this$modeWorkspaceQualifiedName = this.getModeWorkspaceQualifiedName();
        String other$modeWorkspaceQualifiedName = other.getModeWorkspaceQualifiedName();
        if (this$modeWorkspaceQualifiedName == null ? other$modeWorkspaceQualifiedName != null : !this$modeWorkspaceQualifiedName.equals(other$modeWorkspaceQualifiedName)) {
            return false;
        }
        String this$modeWorkspaceUsername = this.getModeWorkspaceUsername();
        String other$modeWorkspaceUsername = other.getModeWorkspaceUsername();
        if (this$modeWorkspaceUsername == null ? other$modeWorkspaceUsername != null : !this$modeWorkspaceUsername.equals(other$modeWorkspaceUsername)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModeReport;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $modeChartCount = this.getModeChartCount();
        result = result * 59 + ($modeChartCount == null ? 43 : ((Object)$modeChartCount).hashCode());
        Boolean $modeIsPublic = this.getModeIsPublic();
        result = result * 59 + ($modeIsPublic == null ? 43 : ((Object)$modeIsPublic).hashCode());
        Boolean $modeIsShared = this.getModeIsShared();
        result = result * 59 + ($modeIsShared == null ? 43 : ((Object)$modeIsShared).hashCode());
        Long $modeQueryCount = this.getModeQueryCount();
        result = result * 59 + ($modeQueryCount == null ? 43 : ((Object)$modeQueryCount).hashCode());
        Long $modeReportPublishedAt = this.getModeReportPublishedAt();
        result = result * 59 + ($modeReportPublishedAt == null ? 43 : ((Object)$modeReportPublishedAt).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        String $modeCollectionToken = this.getModeCollectionToken();
        result = result * 59 + ($modeCollectionToken == null ? 43 : $modeCollectionToken.hashCode());
        SortedSet<IModeCollection> $modeCollections = this.getModeCollections();
        result = result * 59 + ($modeCollections == null ? 43 : $modeCollections.hashCode());
        String $modeId = this.getModeId();
        result = result * 59 + ($modeId == null ? 43 : $modeId.hashCode());
        SortedSet<IModeQuery> $modeQueries = this.getModeQueries();
        result = result * 59 + ($modeQueries == null ? 43 : $modeQueries.hashCode());
        String $modeQueryName = this.getModeQueryName();
        result = result * 59 + ($modeQueryName == null ? 43 : $modeQueryName.hashCode());
        String $modeQueryPreview = this.getModeQueryPreview();
        result = result * 59 + ($modeQueryPreview == null ? 43 : $modeQueryPreview.hashCode());
        String $modeQueryQualifiedName = this.getModeQueryQualifiedName();
        result = result * 59 + ($modeQueryQualifiedName == null ? 43 : $modeQueryQualifiedName.hashCode());
        String $modeReportName = this.getModeReportName();
        result = result * 59 + ($modeReportName == null ? 43 : $modeReportName.hashCode());
        String $modeReportQualifiedName = this.getModeReportQualifiedName();
        result = result * 59 + ($modeReportQualifiedName == null ? 43 : $modeReportQualifiedName.hashCode());
        String $modeToken = this.getModeToken();
        result = result * 59 + ($modeToken == null ? 43 : $modeToken.hashCode());
        String $modeWorkspaceName = this.getModeWorkspaceName();
        result = result * 59 + ($modeWorkspaceName == null ? 43 : $modeWorkspaceName.hashCode());
        String $modeWorkspaceQualifiedName = this.getModeWorkspaceQualifiedName();
        result = result * 59 + ($modeWorkspaceQualifiedName == null ? 43 : $modeWorkspaceQualifiedName.hashCode());
        String $modeWorkspaceUsername = this.getModeWorkspaceUsername();
        result = result * 59 + ($modeWorkspaceUsername == null ? 43 : $modeWorkspaceUsername.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ModeReport(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modeChartCount=" + this.getModeChartCount() + ", modeCollectionToken=" + this.getModeCollectionToken() + ", modeCollections=" + String.valueOf(this.getModeCollections()) + ", modeId=" + this.getModeId() + ", modeIsPublic=" + this.getModeIsPublic() + ", modeIsShared=" + this.getModeIsShared() + ", modeQueries=" + String.valueOf(this.getModeQueries()) + ", modeQueryCount=" + this.getModeQueryCount() + ", modeQueryName=" + this.getModeQueryName() + ", modeQueryPreview=" + this.getModeQueryPreview() + ", modeQueryQualifiedName=" + this.getModeQueryQualifiedName() + ", modeReportName=" + this.getModeReportName() + ", modeReportPublishedAt=" + this.getModeReportPublishedAt() + ", modeReportQualifiedName=" + this.getModeReportQualifiedName() + ", modeToken=" + this.getModeToken() + ", modeWorkspaceName=" + this.getModeWorkspaceName() + ", modeWorkspaceQualifiedName=" + this.getModeWorkspaceQualifiedName() + ", modeWorkspaceUsername=" + this.getModeWorkspaceUsername() + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class ModeReportBuilder<C extends ModeReport, B extends ModeReportBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private Long modeChartCount;
        @Generated
        private String modeCollectionToken;
        @Generated
        private ArrayList<IModeCollection> modeCollections;
        @Generated
        private String modeId;
        @Generated
        private Boolean modeIsPublic;
        @Generated
        private Boolean modeIsShared;
        @Generated
        private ArrayList<IModeQuery> modeQueries;
        @Generated
        private Long modeQueryCount;
        @Generated
        private String modeQueryName;
        @Generated
        private String modeQueryPreview;
        @Generated
        private String modeQueryQualifiedName;
        @Generated
        private String modeReportName;
        @Generated
        private Long modeReportPublishedAt;
        @Generated
        private String modeReportQualifiedName;
        @Generated
        private String modeToken;
        @Generated
        private String modeWorkspaceName;
        @Generated
        private String modeWorkspaceQualifiedName;
        @Generated
        private String modeWorkspaceUsername;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModeReportBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ModeReport instance, ModeReportBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modeChartCount(instance.modeChartCount);
            b.modeCollectionToken(instance.modeCollectionToken);
            b.modeCollections(instance.modeCollections == null ? Collections.emptySortedSet() : instance.modeCollections);
            b.modeId(instance.modeId);
            b.modeIsPublic(instance.modeIsPublic);
            b.modeIsShared(instance.modeIsShared);
            b.modeQueries(instance.modeQueries == null ? Collections.emptySortedSet() : instance.modeQueries);
            b.modeQueryCount(instance.modeQueryCount);
            b.modeQueryName(instance.modeQueryName);
            b.modeQueryPreview(instance.modeQueryPreview);
            b.modeQueryQualifiedName(instance.modeQueryQualifiedName);
            b.modeReportName(instance.modeReportName);
            b.modeReportPublishedAt(instance.modeReportPublishedAt);
            b.modeReportQualifiedName(instance.modeReportQualifiedName);
            b.modeToken(instance.modeToken);
            b.modeWorkspaceName(instance.modeWorkspaceName);
            b.modeWorkspaceQualifiedName(instance.modeWorkspaceQualifiedName);
            b.modeWorkspaceUsername(instance.modeWorkspaceUsername);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modeChartCount(Long modeChartCount) {
            this.modeChartCount = modeChartCount;
            return (B)this.self();
        }

        @Generated
        public B modeCollectionToken(String modeCollectionToken) {
            this.modeCollectionToken = modeCollectionToken;
            return (B)this.self();
        }

        @Generated
        public B modeCollection(IModeCollection modeCollection) {
            if (this.modeCollections == null) {
                this.modeCollections = new ArrayList();
            }
            this.modeCollections.add(modeCollection);
            return (B)this.self();
        }

        @Generated
        public B modeCollections(Collection<? extends IModeCollection> modeCollections) {
            if (modeCollections == null) {
                throw new NullPointerException("modeCollections cannot be null");
            }
            if (this.modeCollections == null) {
                this.modeCollections = new ArrayList();
            }
            this.modeCollections.addAll(modeCollections);
            return (B)this.self();
        }

        @Generated
        public B clearModeCollections() {
            if (this.modeCollections != null) {
                this.modeCollections.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modeId(String modeId) {
            this.modeId = modeId;
            return (B)this.self();
        }

        @Generated
        public B modeIsPublic(Boolean modeIsPublic) {
            this.modeIsPublic = modeIsPublic;
            return (B)this.self();
        }

        @Generated
        public B modeIsShared(Boolean modeIsShared) {
            this.modeIsShared = modeIsShared;
            return (B)this.self();
        }

        @Generated
        public B modeQuery(IModeQuery modeQuery) {
            if (this.modeQueries == null) {
                this.modeQueries = new ArrayList();
            }
            this.modeQueries.add(modeQuery);
            return (B)this.self();
        }

        @Generated
        public B modeQueries(Collection<? extends IModeQuery> modeQueries) {
            if (modeQueries == null) {
                throw new NullPointerException("modeQueries cannot be null");
            }
            if (this.modeQueries == null) {
                this.modeQueries = new ArrayList();
            }
            this.modeQueries.addAll(modeQueries);
            return (B)this.self();
        }

        @Generated
        public B clearModeQueries() {
            if (this.modeQueries != null) {
                this.modeQueries.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modeQueryCount(Long modeQueryCount) {
            this.modeQueryCount = modeQueryCount;
            return (B)this.self();
        }

        @Generated
        public B modeQueryName(String modeQueryName) {
            this.modeQueryName = modeQueryName;
            return (B)this.self();
        }

        @Generated
        public B modeQueryPreview(String modeQueryPreview) {
            this.modeQueryPreview = modeQueryPreview;
            return (B)this.self();
        }

        @Generated
        public B modeQueryQualifiedName(String modeQueryQualifiedName) {
            this.modeQueryQualifiedName = modeQueryQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modeReportName(String modeReportName) {
            this.modeReportName = modeReportName;
            return (B)this.self();
        }

        @Generated
        public B modeReportPublishedAt(Long modeReportPublishedAt) {
            this.modeReportPublishedAt = modeReportPublishedAt;
            return (B)this.self();
        }

        @Generated
        public B modeReportQualifiedName(String modeReportQualifiedName) {
            this.modeReportQualifiedName = modeReportQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modeToken(String modeToken) {
            this.modeToken = modeToken;
            return (B)this.self();
        }

        @Generated
        public B modeWorkspaceName(String modeWorkspaceName) {
            this.modeWorkspaceName = modeWorkspaceName;
            return (B)this.self();
        }

        @Generated
        public B modeWorkspaceQualifiedName(String modeWorkspaceQualifiedName) {
            this.modeWorkspaceQualifiedName = modeWorkspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modeWorkspaceUsername(String modeWorkspaceUsername) {
            this.modeWorkspaceUsername = modeWorkspaceUsername;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ModeReport.ModeReportBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modeChartCount=" + this.modeChartCount + ", modeCollectionToken=" + this.modeCollectionToken + ", modeCollections=" + String.valueOf(this.modeCollections) + ", modeId=" + this.modeId + ", modeIsPublic=" + this.modeIsPublic + ", modeIsShared=" + this.modeIsShared + ", modeQueries=" + String.valueOf(this.modeQueries) + ", modeQueryCount=" + this.modeQueryCount + ", modeQueryName=" + this.modeQueryName + ", modeQueryPreview=" + this.modeQueryPreview + ", modeQueryQualifiedName=" + this.modeQueryQualifiedName + ", modeReportName=" + this.modeReportName + ", modeReportPublishedAt=" + this.modeReportPublishedAt + ", modeReportQualifiedName=" + this.modeReportQualifiedName + ", modeToken=" + this.modeToken + ", modeWorkspaceName=" + this.modeWorkspaceName + ", modeWorkspaceQualifiedName=" + this.modeWorkspaceQualifiedName + ", modeWorkspaceUsername=" + this.modeWorkspaceUsername + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class ModeReportBuilderImpl
    extends ModeReportBuilder<ModeReport, ModeReportBuilderImpl> {
        @Generated
        private ModeReportBuilderImpl() {
        }

        @Override
        @Generated
        protected ModeReportBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ModeReport build() {
            return new ModeReport(this);
        }
    }
}

