/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IPowerBI;
import com.atlan.model.assets.IPowerBIDataflow;
import com.atlan.model.assets.IPowerBIDataflowEntityColumn;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.PowerBIEndorsementType;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerBIDataflowEntityColumn
extends Asset
implements IPowerBIDataflowEntityColumn,
IPowerBI,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PowerBIDataflowEntityColumn.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIDataflowEntityColumn";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    IPowerBIDataflow powerBIDataflow;
    @Attribute
    String powerBIDataflowEntityColumnDataType;
    @Attribute
    String powerBIDataflowEntityName;
    @Attribute
    String powerBIDataflowQualifiedName;
    @Attribute
    PowerBIEndorsementType powerBIEndorsement;
    @Attribute
    String powerBIFormatString;
    @Attribute
    Boolean powerBIIsHidden;
    @Attribute
    String powerBITableQualifiedName;
    @Attribute
    String powerBIWorkspaceQualifiedName;

    @Override
    public PowerBIDataflowEntityColumn trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return PowerBIDataflowEntityColumn.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return PowerBIDataflowEntityColumn.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return PowerBIDataflowEntityColumn.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return PowerBIDataflowEntityColumn.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static PowerBIDataflowEntityColumn refByGuid(String guid) {
        return PowerBIDataflowEntityColumn.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static PowerBIDataflowEntityColumn refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((PowerBIDataflowEntityColumnBuilder)((PowerBIDataflowEntityColumnBuilder)PowerBIDataflowEntityColumn._internal().guid(guid)).semantic(semantic)).build();
    }

    public static PowerBIDataflowEntityColumn refByQualifiedName(String qualifiedName) {
        return PowerBIDataflowEntityColumn.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static PowerBIDataflowEntityColumn refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((PowerBIDataflowEntityColumnBuilder)((PowerBIDataflowEntityColumnBuilder)PowerBIDataflowEntityColumn._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static PowerBIDataflowEntityColumn get(AtlanClient client, String id) throws AtlanException {
        return PowerBIDataflowEntityColumn.get(client, id, false);
    }

    @JsonIgnore
    public static PowerBIDataflowEntityColumn get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof PowerBIDataflowEntityColumn) {
                return (PowerBIDataflowEntityColumn)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof PowerBIDataflowEntityColumn) {
            return (PowerBIDataflowEntityColumn)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static PowerBIDataflowEntityColumn get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return PowerBIDataflowEntityColumn.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static PowerBIDataflowEntityColumn get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)PowerBIDataflowEntityColumn.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof PowerBIDataflowEntityColumn) {
                return (PowerBIDataflowEntityColumn)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)PowerBIDataflowEntityColumn.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof PowerBIDataflowEntityColumn) {
            return (PowerBIDataflowEntityColumn)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static PowerBIDataflowEntityColumnBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBIDataflowEntityColumnBuilder)((PowerBIDataflowEntityColumnBuilder)((PowerBIDataflowEntityColumnBuilder)PowerBIDataflowEntityColumn._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public PowerBIDataflowEntityColumnBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        PowerBIDataflowEntityColumn.validateRequired(TYPE_NAME, map);
        return PowerBIDataflowEntityColumn.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBIDataflowEntityColumn removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflowEntityColumn)Asset.removeDescription(client, PowerBIDataflowEntityColumn.updater(qualifiedName, name));
    }

    public static PowerBIDataflowEntityColumn removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflowEntityColumn)Asset.removeUserDescription(client, PowerBIDataflowEntityColumn.updater(qualifiedName, name));
    }

    public static PowerBIDataflowEntityColumn removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflowEntityColumn)Asset.removeOwners(client, PowerBIDataflowEntityColumn.updater(qualifiedName, name));
    }

    public static PowerBIDataflowEntityColumn updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIDataflowEntityColumn)Asset.updateCertificate(client, PowerBIDataflowEntityColumn._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBIDataflowEntityColumn removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflowEntityColumn)Asset.removeCertificate(client, PowerBIDataflowEntityColumn.updater(qualifiedName, name));
    }

    public static PowerBIDataflowEntityColumn updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIDataflowEntityColumn)Asset.updateAnnouncement(client, PowerBIDataflowEntityColumn._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBIDataflowEntityColumn removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflowEntityColumn)Asset.removeAnnouncement(client, PowerBIDataflowEntityColumn.updater(qualifiedName, name));
    }

    public static PowerBIDataflowEntityColumn replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIDataflowEntityColumn)Asset.replaceTerms(client, PowerBIDataflowEntityColumn.updater(qualifiedName, name), terms);
    }

    public static PowerBIDataflowEntityColumn appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIDataflowEntityColumn)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBIDataflowEntityColumn removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIDataflowEntityColumn)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBIDataflowEntityColumn appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (PowerBIDataflowEntityColumn)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static PowerBIDataflowEntityColumn appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (PowerBIDataflowEntityColumn)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBIDataflowEntityColumn(PowerBIDataflowEntityColumnBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PowerBIDataflowEntityColumn.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.powerBIDataflow = b.powerBIDataflow;
        this.powerBIDataflowEntityColumnDataType = b.powerBIDataflowEntityColumnDataType;
        this.powerBIDataflowEntityName = b.powerBIDataflowEntityName;
        this.powerBIDataflowQualifiedName = b.powerBIDataflowQualifiedName;
        this.powerBIEndorsement = b.powerBIEndorsement;
        this.powerBIFormatString = b.powerBIFormatString;
        this.powerBIIsHidden = b.powerBIIsHidden;
        this.powerBITableQualifiedName = b.powerBITableQualifiedName;
        this.powerBIWorkspaceQualifiedName = b.powerBIWorkspaceQualifiedName;
    }

    @Generated
    public static PowerBIDataflowEntityColumnBuilder<?, ?> _internal() {
        return new PowerBIDataflowEntityColumnBuilderImpl();
    }

    @Generated
    public PowerBIDataflowEntityColumnBuilder<?, ?> toBuilder() {
        return new PowerBIDataflowEntityColumnBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public IPowerBIDataflow getPowerBIDataflow() {
        return this.powerBIDataflow;
    }

    @Override
    @Generated
    public String getPowerBIDataflowEntityColumnDataType() {
        return this.powerBIDataflowEntityColumnDataType;
    }

    @Override
    @Generated
    public String getPowerBIDataflowEntityName() {
        return this.powerBIDataflowEntityName;
    }

    @Override
    @Generated
    public String getPowerBIDataflowQualifiedName() {
        return this.powerBIDataflowQualifiedName;
    }

    @Override
    @Generated
    public PowerBIEndorsementType getPowerBIEndorsement() {
        return this.powerBIEndorsement;
    }

    @Override
    @Generated
    public String getPowerBIFormatString() {
        return this.powerBIFormatString;
    }

    @Override
    @Generated
    public Boolean getPowerBIIsHidden() {
        return this.powerBIIsHidden;
    }

    @Override
    @Generated
    public String getPowerBITableQualifiedName() {
        return this.powerBITableQualifiedName;
    }

    @Override
    @Generated
    public String getPowerBIWorkspaceQualifiedName() {
        return this.powerBIWorkspaceQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBIDataflowEntityColumn)) {
            return false;
        }
        PowerBIDataflowEntityColumn other = (PowerBIDataflowEntityColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$powerBIIsHidden = this.getPowerBIIsHidden();
        Boolean other$powerBIIsHidden = other.getPowerBIIsHidden();
        if (this$powerBIIsHidden == null ? other$powerBIIsHidden != null : !((Object)this$powerBIIsHidden).equals(other$powerBIIsHidden)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        IPowerBIDataflow this$powerBIDataflow = this.getPowerBIDataflow();
        IPowerBIDataflow other$powerBIDataflow = other.getPowerBIDataflow();
        if (this$powerBIDataflow == null ? other$powerBIDataflow != null : !this$powerBIDataflow.equals(other$powerBIDataflow)) {
            return false;
        }
        String this$powerBIDataflowEntityColumnDataType = this.getPowerBIDataflowEntityColumnDataType();
        String other$powerBIDataflowEntityColumnDataType = other.getPowerBIDataflowEntityColumnDataType();
        if (this$powerBIDataflowEntityColumnDataType == null ? other$powerBIDataflowEntityColumnDataType != null : !this$powerBIDataflowEntityColumnDataType.equals(other$powerBIDataflowEntityColumnDataType)) {
            return false;
        }
        String this$powerBIDataflowEntityName = this.getPowerBIDataflowEntityName();
        String other$powerBIDataflowEntityName = other.getPowerBIDataflowEntityName();
        if (this$powerBIDataflowEntityName == null ? other$powerBIDataflowEntityName != null : !this$powerBIDataflowEntityName.equals(other$powerBIDataflowEntityName)) {
            return false;
        }
        String this$powerBIDataflowQualifiedName = this.getPowerBIDataflowQualifiedName();
        String other$powerBIDataflowQualifiedName = other.getPowerBIDataflowQualifiedName();
        if (this$powerBIDataflowQualifiedName == null ? other$powerBIDataflowQualifiedName != null : !this$powerBIDataflowQualifiedName.equals(other$powerBIDataflowQualifiedName)) {
            return false;
        }
        PowerBIEndorsementType this$powerBIEndorsement = this.getPowerBIEndorsement();
        PowerBIEndorsementType other$powerBIEndorsement = other.getPowerBIEndorsement();
        if (this$powerBIEndorsement == null ? other$powerBIEndorsement != null : !this$powerBIEndorsement.equals(other$powerBIEndorsement)) {
            return false;
        }
        String this$powerBIFormatString = this.getPowerBIFormatString();
        String other$powerBIFormatString = other.getPowerBIFormatString();
        if (this$powerBIFormatString == null ? other$powerBIFormatString != null : !this$powerBIFormatString.equals(other$powerBIFormatString)) {
            return false;
        }
        String this$powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        String other$powerBITableQualifiedName = other.getPowerBITableQualifiedName();
        if (this$powerBITableQualifiedName == null ? other$powerBITableQualifiedName != null : !this$powerBITableQualifiedName.equals(other$powerBITableQualifiedName)) {
            return false;
        }
        String this$powerBIWorkspaceQualifiedName = this.getPowerBIWorkspaceQualifiedName();
        String other$powerBIWorkspaceQualifiedName = other.getPowerBIWorkspaceQualifiedName();
        return !(this$powerBIWorkspaceQualifiedName == null ? other$powerBIWorkspaceQualifiedName != null : !this$powerBIWorkspaceQualifiedName.equals(other$powerBIWorkspaceQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBIDataflowEntityColumn;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $powerBIIsHidden = this.getPowerBIIsHidden();
        result = result * 59 + ($powerBIIsHidden == null ? 43 : ((Object)$powerBIIsHidden).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        IPowerBIDataflow $powerBIDataflow = this.getPowerBIDataflow();
        result = result * 59 + ($powerBIDataflow == null ? 43 : $powerBIDataflow.hashCode());
        String $powerBIDataflowEntityColumnDataType = this.getPowerBIDataflowEntityColumnDataType();
        result = result * 59 + ($powerBIDataflowEntityColumnDataType == null ? 43 : $powerBIDataflowEntityColumnDataType.hashCode());
        String $powerBIDataflowEntityName = this.getPowerBIDataflowEntityName();
        result = result * 59 + ($powerBIDataflowEntityName == null ? 43 : $powerBIDataflowEntityName.hashCode());
        String $powerBIDataflowQualifiedName = this.getPowerBIDataflowQualifiedName();
        result = result * 59 + ($powerBIDataflowQualifiedName == null ? 43 : $powerBIDataflowQualifiedName.hashCode());
        PowerBIEndorsementType $powerBIEndorsement = this.getPowerBIEndorsement();
        result = result * 59 + ($powerBIEndorsement == null ? 43 : $powerBIEndorsement.hashCode());
        String $powerBIFormatString = this.getPowerBIFormatString();
        result = result * 59 + ($powerBIFormatString == null ? 43 : $powerBIFormatString.hashCode());
        String $powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        result = result * 59 + ($powerBITableQualifiedName == null ? 43 : $powerBITableQualifiedName.hashCode());
        String $powerBIWorkspaceQualifiedName = this.getPowerBIWorkspaceQualifiedName();
        result = result * 59 + ($powerBIWorkspaceQualifiedName == null ? 43 : $powerBIWorkspaceQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PowerBIDataflowEntityColumn(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", powerBIDataflow=" + String.valueOf(this.getPowerBIDataflow()) + ", powerBIDataflowEntityColumnDataType=" + this.getPowerBIDataflowEntityColumnDataType() + ", powerBIDataflowEntityName=" + this.getPowerBIDataflowEntityName() + ", powerBIDataflowQualifiedName=" + this.getPowerBIDataflowQualifiedName() + ", powerBIEndorsement=" + String.valueOf(this.getPowerBIEndorsement()) + ", powerBIFormatString=" + this.getPowerBIFormatString() + ", powerBIIsHidden=" + this.getPowerBIIsHidden() + ", powerBITableQualifiedName=" + this.getPowerBITableQualifiedName() + ", powerBIWorkspaceQualifiedName=" + this.getPowerBIWorkspaceQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class PowerBIDataflowEntityColumnBuilder<C extends PowerBIDataflowEntityColumn, B extends PowerBIDataflowEntityColumnBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private IPowerBIDataflow powerBIDataflow;
        @Generated
        private String powerBIDataflowEntityColumnDataType;
        @Generated
        private String powerBIDataflowEntityName;
        @Generated
        private String powerBIDataflowQualifiedName;
        @Generated
        private PowerBIEndorsementType powerBIEndorsement;
        @Generated
        private String powerBIFormatString;
        @Generated
        private Boolean powerBIIsHidden;
        @Generated
        private String powerBITableQualifiedName;
        @Generated
        private String powerBIWorkspaceQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBIDataflowEntityColumnBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBIDataflowEntityColumn instance, PowerBIDataflowEntityColumnBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.powerBIDataflow(instance.powerBIDataflow);
            b.powerBIDataflowEntityColumnDataType(instance.powerBIDataflowEntityColumnDataType);
            b.powerBIDataflowEntityName(instance.powerBIDataflowEntityName);
            b.powerBIDataflowQualifiedName(instance.powerBIDataflowQualifiedName);
            b.powerBIEndorsement(instance.powerBIEndorsement);
            b.powerBIFormatString(instance.powerBIFormatString);
            b.powerBIIsHidden(instance.powerBIIsHidden);
            b.powerBITableQualifiedName(instance.powerBITableQualifiedName);
            b.powerBIWorkspaceQualifiedName(instance.powerBIWorkspaceQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflow(IPowerBIDataflow powerBIDataflow) {
            this.powerBIDataflow = powerBIDataflow;
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflowEntityColumnDataType(String powerBIDataflowEntityColumnDataType) {
            this.powerBIDataflowEntityColumnDataType = powerBIDataflowEntityColumnDataType;
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflowEntityName(String powerBIDataflowEntityName) {
            this.powerBIDataflowEntityName = powerBIDataflowEntityName;
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflowQualifiedName(String powerBIDataflowQualifiedName) {
            this.powerBIDataflowQualifiedName = powerBIDataflowQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B powerBIEndorsement(PowerBIEndorsementType powerBIEndorsement) {
            this.powerBIEndorsement = powerBIEndorsement;
            return (B)this.self();
        }

        @Generated
        public B powerBIFormatString(String powerBIFormatString) {
            this.powerBIFormatString = powerBIFormatString;
            return (B)this.self();
        }

        @Generated
        public B powerBIIsHidden(Boolean powerBIIsHidden) {
            this.powerBIIsHidden = powerBIIsHidden;
            return (B)this.self();
        }

        @Generated
        public B powerBITableQualifiedName(String powerBITableQualifiedName) {
            this.powerBITableQualifiedName = powerBITableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B powerBIWorkspaceQualifiedName(String powerBIWorkspaceQualifiedName) {
            this.powerBIWorkspaceQualifiedName = powerBIWorkspaceQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PowerBIDataflowEntityColumn.PowerBIDataflowEntityColumnBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", powerBIDataflow=" + String.valueOf(this.powerBIDataflow) + ", powerBIDataflowEntityColumnDataType=" + this.powerBIDataflowEntityColumnDataType + ", powerBIDataflowEntityName=" + this.powerBIDataflowEntityName + ", powerBIDataflowQualifiedName=" + this.powerBIDataflowQualifiedName + ", powerBIEndorsement=" + String.valueOf(this.powerBIEndorsement) + ", powerBIFormatString=" + this.powerBIFormatString + ", powerBIIsHidden=" + this.powerBIIsHidden + ", powerBITableQualifiedName=" + this.powerBITableQualifiedName + ", powerBIWorkspaceQualifiedName=" + this.powerBIWorkspaceQualifiedName + ")";
        }
    }

    @Generated
    private static final class PowerBIDataflowEntityColumnBuilderImpl
    extends PowerBIDataflowEntityColumnBuilder<PowerBIDataflowEntityColumn, PowerBIDataflowEntityColumnBuilderImpl> {
        @Generated
        private PowerBIDataflowEntityColumnBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBIDataflowEntityColumnBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBIDataflowEntityColumn build() {
            return new PowerBIDataflowEntityColumn(this);
        }
    }
}

