/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IQlik;
import com.atlan.model.assets.IQlikDataset;
import com.atlan.model.assets.IQlikSpace;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QlikDataset
extends Asset
implements IQlikDataset,
IQlik,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QlikDataset.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "QlikDataset";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    String qlikAppId;
    @Attribute
    String qlikAppQualifiedName;
    @Attribute
    String qlikDatasetSubtype;
    @Attribute
    String qlikDatasetTechnicalName;
    @Attribute
    String qlikDatasetType;
    @Attribute
    String qlikDatasetUri;
    @Attribute
    String qlikId;
    @Attribute
    Boolean qlikIsPublished;
    @Attribute
    String qlikOwnerId;
    @Attribute
    String qlikQRI;
    @Attribute
    IQlikSpace qlikSpace;
    @Attribute
    String qlikSpaceId;
    @Attribute
    String qlikSpaceQualifiedName;

    @Override
    public QlikDataset trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return QlikDataset.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return QlikDataset.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return QlikDataset.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return QlikDataset.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static QlikDataset refByGuid(String guid) {
        return QlikDataset.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static QlikDataset refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((QlikDatasetBuilder)((QlikDatasetBuilder)QlikDataset._internal().guid(guid)).semantic(semantic)).build();
    }

    public static QlikDataset refByQualifiedName(String qualifiedName) {
        return QlikDataset.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static QlikDataset refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((QlikDatasetBuilder)((QlikDatasetBuilder)QlikDataset._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static QlikDataset get(AtlanClient client, String id) throws AtlanException {
        return QlikDataset.get(client, id, false);
    }

    @JsonIgnore
    public static QlikDataset get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof QlikDataset) {
                return (QlikDataset)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof QlikDataset) {
            return (QlikDataset)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static QlikDataset get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return QlikDataset.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static QlikDataset get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)QlikDataset.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof QlikDataset) {
                return (QlikDataset)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)QlikDataset.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof QlikDataset) {
            return (QlikDataset)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static QlikDatasetBuilder<?, ?> updater(String qualifiedName, String name) {
        return (QlikDatasetBuilder)((QlikDatasetBuilder)((QlikDatasetBuilder)QlikDataset._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public QlikDatasetBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        QlikDataset.validateRequired(TYPE_NAME, map);
        return QlikDataset.updater(this.getQualifiedName(), this.getName());
    }

    public static QlikDataset removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikDataset)Asset.removeDescription(client, QlikDataset.updater(qualifiedName, name));
    }

    public static QlikDataset removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikDataset)Asset.removeUserDescription(client, QlikDataset.updater(qualifiedName, name));
    }

    public static QlikDataset removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikDataset)Asset.removeOwners(client, QlikDataset.updater(qualifiedName, name));
    }

    public static QlikDataset updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (QlikDataset)Asset.updateCertificate(client, QlikDataset._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static QlikDataset removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikDataset)Asset.removeCertificate(client, QlikDataset.updater(qualifiedName, name));
    }

    public static QlikDataset updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (QlikDataset)Asset.updateAnnouncement(client, QlikDataset._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static QlikDataset removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikDataset)Asset.removeAnnouncement(client, QlikDataset.updater(qualifiedName, name));
    }

    public static QlikDataset replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (QlikDataset)Asset.replaceTerms(client, QlikDataset.updater(qualifiedName, name), terms);
    }

    public static QlikDataset appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QlikDataset)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static QlikDataset removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QlikDataset)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static QlikDataset appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (QlikDataset)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static QlikDataset appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (QlikDataset)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected QlikDataset(QlikDatasetBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : QlikDataset.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.qlikAppId = b.qlikAppId;
        this.qlikAppQualifiedName = b.qlikAppQualifiedName;
        this.qlikDatasetSubtype = b.qlikDatasetSubtype;
        this.qlikDatasetTechnicalName = b.qlikDatasetTechnicalName;
        this.qlikDatasetType = b.qlikDatasetType;
        this.qlikDatasetUri = b.qlikDatasetUri;
        this.qlikId = b.qlikId;
        this.qlikIsPublished = b.qlikIsPublished;
        this.qlikOwnerId = b.qlikOwnerId;
        this.qlikQRI = b.qlikQRI;
        this.qlikSpace = b.qlikSpace;
        this.qlikSpaceId = b.qlikSpaceId;
        this.qlikSpaceQualifiedName = b.qlikSpaceQualifiedName;
    }

    @Generated
    public static QlikDatasetBuilder<?, ?> _internal() {
        return new QlikDatasetBuilderImpl();
    }

    @Generated
    public QlikDatasetBuilder<?, ?> toBuilder() {
        return new QlikDatasetBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public String getQlikAppId() {
        return this.qlikAppId;
    }

    @Override
    @Generated
    public String getQlikAppQualifiedName() {
        return this.qlikAppQualifiedName;
    }

    @Override
    @Generated
    public String getQlikDatasetSubtype() {
        return this.qlikDatasetSubtype;
    }

    @Override
    @Generated
    public String getQlikDatasetTechnicalName() {
        return this.qlikDatasetTechnicalName;
    }

    @Override
    @Generated
    public String getQlikDatasetType() {
        return this.qlikDatasetType;
    }

    @Override
    @Generated
    public String getQlikDatasetUri() {
        return this.qlikDatasetUri;
    }

    @Override
    @Generated
    public String getQlikId() {
        return this.qlikId;
    }

    @Override
    @Generated
    public Boolean getQlikIsPublished() {
        return this.qlikIsPublished;
    }

    @Override
    @Generated
    public String getQlikOwnerId() {
        return this.qlikOwnerId;
    }

    @Override
    @Generated
    public String getQlikQRI() {
        return this.qlikQRI;
    }

    @Override
    @Generated
    public IQlikSpace getQlikSpace() {
        return this.qlikSpace;
    }

    @Override
    @Generated
    public String getQlikSpaceId() {
        return this.qlikSpaceId;
    }

    @Override
    @Generated
    public String getQlikSpaceQualifiedName() {
        return this.qlikSpaceQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QlikDataset)) {
            return false;
        }
        QlikDataset other = (QlikDataset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$qlikIsPublished = this.getQlikIsPublished();
        Boolean other$qlikIsPublished = other.getQlikIsPublished();
        if (this$qlikIsPublished == null ? other$qlikIsPublished != null : !((Object)this$qlikIsPublished).equals(other$qlikIsPublished)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$qlikAppId = this.getQlikAppId();
        String other$qlikAppId = other.getQlikAppId();
        if (this$qlikAppId == null ? other$qlikAppId != null : !this$qlikAppId.equals(other$qlikAppId)) {
            return false;
        }
        String this$qlikAppQualifiedName = this.getQlikAppQualifiedName();
        String other$qlikAppQualifiedName = other.getQlikAppQualifiedName();
        if (this$qlikAppQualifiedName == null ? other$qlikAppQualifiedName != null : !this$qlikAppQualifiedName.equals(other$qlikAppQualifiedName)) {
            return false;
        }
        String this$qlikDatasetSubtype = this.getQlikDatasetSubtype();
        String other$qlikDatasetSubtype = other.getQlikDatasetSubtype();
        if (this$qlikDatasetSubtype == null ? other$qlikDatasetSubtype != null : !this$qlikDatasetSubtype.equals(other$qlikDatasetSubtype)) {
            return false;
        }
        String this$qlikDatasetTechnicalName = this.getQlikDatasetTechnicalName();
        String other$qlikDatasetTechnicalName = other.getQlikDatasetTechnicalName();
        if (this$qlikDatasetTechnicalName == null ? other$qlikDatasetTechnicalName != null : !this$qlikDatasetTechnicalName.equals(other$qlikDatasetTechnicalName)) {
            return false;
        }
        String this$qlikDatasetType = this.getQlikDatasetType();
        String other$qlikDatasetType = other.getQlikDatasetType();
        if (this$qlikDatasetType == null ? other$qlikDatasetType != null : !this$qlikDatasetType.equals(other$qlikDatasetType)) {
            return false;
        }
        String this$qlikDatasetUri = this.getQlikDatasetUri();
        String other$qlikDatasetUri = other.getQlikDatasetUri();
        if (this$qlikDatasetUri == null ? other$qlikDatasetUri != null : !this$qlikDatasetUri.equals(other$qlikDatasetUri)) {
            return false;
        }
        String this$qlikId = this.getQlikId();
        String other$qlikId = other.getQlikId();
        if (this$qlikId == null ? other$qlikId != null : !this$qlikId.equals(other$qlikId)) {
            return false;
        }
        String this$qlikOwnerId = this.getQlikOwnerId();
        String other$qlikOwnerId = other.getQlikOwnerId();
        if (this$qlikOwnerId == null ? other$qlikOwnerId != null : !this$qlikOwnerId.equals(other$qlikOwnerId)) {
            return false;
        }
        String this$qlikQRI = this.getQlikQRI();
        String other$qlikQRI = other.getQlikQRI();
        if (this$qlikQRI == null ? other$qlikQRI != null : !this$qlikQRI.equals(other$qlikQRI)) {
            return false;
        }
        IQlikSpace this$qlikSpace = this.getQlikSpace();
        IQlikSpace other$qlikSpace = other.getQlikSpace();
        if (this$qlikSpace == null ? other$qlikSpace != null : !this$qlikSpace.equals(other$qlikSpace)) {
            return false;
        }
        String this$qlikSpaceId = this.getQlikSpaceId();
        String other$qlikSpaceId = other.getQlikSpaceId();
        if (this$qlikSpaceId == null ? other$qlikSpaceId != null : !this$qlikSpaceId.equals(other$qlikSpaceId)) {
            return false;
        }
        String this$qlikSpaceQualifiedName = this.getQlikSpaceQualifiedName();
        String other$qlikSpaceQualifiedName = other.getQlikSpaceQualifiedName();
        return !(this$qlikSpaceQualifiedName == null ? other$qlikSpaceQualifiedName != null : !this$qlikSpaceQualifiedName.equals(other$qlikSpaceQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QlikDataset;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $qlikIsPublished = this.getQlikIsPublished();
        result = result * 59 + ($qlikIsPublished == null ? 43 : ((Object)$qlikIsPublished).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $qlikAppId = this.getQlikAppId();
        result = result * 59 + ($qlikAppId == null ? 43 : $qlikAppId.hashCode());
        String $qlikAppQualifiedName = this.getQlikAppQualifiedName();
        result = result * 59 + ($qlikAppQualifiedName == null ? 43 : $qlikAppQualifiedName.hashCode());
        String $qlikDatasetSubtype = this.getQlikDatasetSubtype();
        result = result * 59 + ($qlikDatasetSubtype == null ? 43 : $qlikDatasetSubtype.hashCode());
        String $qlikDatasetTechnicalName = this.getQlikDatasetTechnicalName();
        result = result * 59 + ($qlikDatasetTechnicalName == null ? 43 : $qlikDatasetTechnicalName.hashCode());
        String $qlikDatasetType = this.getQlikDatasetType();
        result = result * 59 + ($qlikDatasetType == null ? 43 : $qlikDatasetType.hashCode());
        String $qlikDatasetUri = this.getQlikDatasetUri();
        result = result * 59 + ($qlikDatasetUri == null ? 43 : $qlikDatasetUri.hashCode());
        String $qlikId = this.getQlikId();
        result = result * 59 + ($qlikId == null ? 43 : $qlikId.hashCode());
        String $qlikOwnerId = this.getQlikOwnerId();
        result = result * 59 + ($qlikOwnerId == null ? 43 : $qlikOwnerId.hashCode());
        String $qlikQRI = this.getQlikQRI();
        result = result * 59 + ($qlikQRI == null ? 43 : $qlikQRI.hashCode());
        IQlikSpace $qlikSpace = this.getQlikSpace();
        result = result * 59 + ($qlikSpace == null ? 43 : $qlikSpace.hashCode());
        String $qlikSpaceId = this.getQlikSpaceId();
        result = result * 59 + ($qlikSpaceId == null ? 43 : $qlikSpaceId.hashCode());
        String $qlikSpaceQualifiedName = this.getQlikSpaceQualifiedName();
        result = result * 59 + ($qlikSpaceQualifiedName == null ? 43 : $qlikSpaceQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "QlikDataset(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", qlikAppId=" + this.getQlikAppId() + ", qlikAppQualifiedName=" + this.getQlikAppQualifiedName() + ", qlikDatasetSubtype=" + this.getQlikDatasetSubtype() + ", qlikDatasetTechnicalName=" + this.getQlikDatasetTechnicalName() + ", qlikDatasetType=" + this.getQlikDatasetType() + ", qlikDatasetUri=" + this.getQlikDatasetUri() + ", qlikId=" + this.getQlikId() + ", qlikIsPublished=" + this.getQlikIsPublished() + ", qlikOwnerId=" + this.getQlikOwnerId() + ", qlikQRI=" + this.getQlikQRI() + ", qlikSpace=" + String.valueOf(this.getQlikSpace()) + ", qlikSpaceId=" + this.getQlikSpaceId() + ", qlikSpaceQualifiedName=" + this.getQlikSpaceQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class QlikDatasetBuilder<C extends QlikDataset, B extends QlikDatasetBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private String qlikAppId;
        @Generated
        private String qlikAppQualifiedName;
        @Generated
        private String qlikDatasetSubtype;
        @Generated
        private String qlikDatasetTechnicalName;
        @Generated
        private String qlikDatasetType;
        @Generated
        private String qlikDatasetUri;
        @Generated
        private String qlikId;
        @Generated
        private Boolean qlikIsPublished;
        @Generated
        private String qlikOwnerId;
        @Generated
        private String qlikQRI;
        @Generated
        private IQlikSpace qlikSpace;
        @Generated
        private String qlikSpaceId;
        @Generated
        private String qlikSpaceQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            QlikDatasetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(QlikDataset instance, QlikDatasetBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.qlikAppId(instance.qlikAppId);
            b.qlikAppQualifiedName(instance.qlikAppQualifiedName);
            b.qlikDatasetSubtype(instance.qlikDatasetSubtype);
            b.qlikDatasetTechnicalName(instance.qlikDatasetTechnicalName);
            b.qlikDatasetType(instance.qlikDatasetType);
            b.qlikDatasetUri(instance.qlikDatasetUri);
            b.qlikId(instance.qlikId);
            b.qlikIsPublished(instance.qlikIsPublished);
            b.qlikOwnerId(instance.qlikOwnerId);
            b.qlikQRI(instance.qlikQRI);
            b.qlikSpace(instance.qlikSpace);
            b.qlikSpaceId(instance.qlikSpaceId);
            b.qlikSpaceQualifiedName(instance.qlikSpaceQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B qlikAppId(String qlikAppId) {
            this.qlikAppId = qlikAppId;
            return (B)this.self();
        }

        @Generated
        public B qlikAppQualifiedName(String qlikAppQualifiedName) {
            this.qlikAppQualifiedName = qlikAppQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B qlikDatasetSubtype(String qlikDatasetSubtype) {
            this.qlikDatasetSubtype = qlikDatasetSubtype;
            return (B)this.self();
        }

        @Generated
        public B qlikDatasetTechnicalName(String qlikDatasetTechnicalName) {
            this.qlikDatasetTechnicalName = qlikDatasetTechnicalName;
            return (B)this.self();
        }

        @Generated
        public B qlikDatasetType(String qlikDatasetType) {
            this.qlikDatasetType = qlikDatasetType;
            return (B)this.self();
        }

        @Generated
        public B qlikDatasetUri(String qlikDatasetUri) {
            this.qlikDatasetUri = qlikDatasetUri;
            return (B)this.self();
        }

        @Generated
        public B qlikId(String qlikId) {
            this.qlikId = qlikId;
            return (B)this.self();
        }

        @Generated
        public B qlikIsPublished(Boolean qlikIsPublished) {
            this.qlikIsPublished = qlikIsPublished;
            return (B)this.self();
        }

        @Generated
        public B qlikOwnerId(String qlikOwnerId) {
            this.qlikOwnerId = qlikOwnerId;
            return (B)this.self();
        }

        @Generated
        public B qlikQRI(String qlikQRI) {
            this.qlikQRI = qlikQRI;
            return (B)this.self();
        }

        @Generated
        public B qlikSpace(IQlikSpace qlikSpace) {
            this.qlikSpace = qlikSpace;
            return (B)this.self();
        }

        @Generated
        public B qlikSpaceId(String qlikSpaceId) {
            this.qlikSpaceId = qlikSpaceId;
            return (B)this.self();
        }

        @Generated
        public B qlikSpaceQualifiedName(String qlikSpaceQualifiedName) {
            this.qlikSpaceQualifiedName = qlikSpaceQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "QlikDataset.QlikDatasetBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", qlikAppId=" + this.qlikAppId + ", qlikAppQualifiedName=" + this.qlikAppQualifiedName + ", qlikDatasetSubtype=" + this.qlikDatasetSubtype + ", qlikDatasetTechnicalName=" + this.qlikDatasetTechnicalName + ", qlikDatasetType=" + this.qlikDatasetType + ", qlikDatasetUri=" + this.qlikDatasetUri + ", qlikId=" + this.qlikId + ", qlikIsPublished=" + this.qlikIsPublished + ", qlikOwnerId=" + this.qlikOwnerId + ", qlikQRI=" + this.qlikQRI + ", qlikSpace=" + String.valueOf(this.qlikSpace) + ", qlikSpaceId=" + this.qlikSpaceId + ", qlikSpaceQualifiedName=" + this.qlikSpaceQualifiedName + ")";
        }
    }

    @Generated
    private static final class QlikDatasetBuilderImpl
    extends QlikDatasetBuilder<QlikDataset, QlikDatasetBuilderImpl> {
        @Generated
        private QlikDatasetBuilderImpl() {
        }

        @Override
        @Generated
        protected QlikDatasetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public QlikDataset build() {
            return new QlikDataset(this);
        }
    }
}

