/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IRedash;
import com.atlan.model.assets.IRedashQuery;
import com.atlan.model.assets.IRedashVisualization;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedashQuery
extends Asset
implements IRedashQuery,
IRedash,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedashQuery.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "RedashQuery";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    Boolean redashIsPublished;
    @Attribute
    @Date
    Long redashQueryLastExecutedAt;
    @Attribute
    Double redashQueryLastExecutionRuntime;
    @Attribute
    String redashQueryParameters;
    @Attribute
    String redashQuerySQL;
    @Attribute
    Map<String, String> redashQuerySchedule;
    @Attribute
    String redashQueryScheduleHumanized;
    @Attribute
    SortedSet<IRedashVisualization> redashVisualizations;

    @Override
    public RedashQuery trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return RedashQuery.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return RedashQuery.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return RedashQuery.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return RedashQuery.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static RedashQuery refByGuid(String guid) {
        return RedashQuery.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static RedashQuery refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((RedashQueryBuilder)((RedashQueryBuilder)RedashQuery._internal().guid(guid)).semantic(semantic)).build();
    }

    public static RedashQuery refByQualifiedName(String qualifiedName) {
        return RedashQuery.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static RedashQuery refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((RedashQueryBuilder)((RedashQueryBuilder)RedashQuery._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static RedashQuery get(AtlanClient client, String id) throws AtlanException {
        return RedashQuery.get(client, id, false);
    }

    @JsonIgnore
    public static RedashQuery get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof RedashQuery) {
                return (RedashQuery)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof RedashQuery) {
            return (RedashQuery)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static RedashQuery get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return RedashQuery.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static RedashQuery get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)RedashQuery.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof RedashQuery) {
                return (RedashQuery)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)RedashQuery.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof RedashQuery) {
            return (RedashQuery)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static RedashQueryBuilder<?, ?> updater(String qualifiedName, String name) {
        return (RedashQueryBuilder)((RedashQueryBuilder)((RedashQueryBuilder)RedashQuery._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public RedashQueryBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        RedashQuery.validateRequired(TYPE_NAME, map);
        return RedashQuery.updater(this.getQualifiedName(), this.getName());
    }

    public static RedashQuery removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashQuery)Asset.removeDescription(client, RedashQuery.updater(qualifiedName, name));
    }

    public static RedashQuery removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashQuery)Asset.removeUserDescription(client, RedashQuery.updater(qualifiedName, name));
    }

    public static RedashQuery removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashQuery)Asset.removeOwners(client, RedashQuery.updater(qualifiedName, name));
    }

    public static RedashQuery updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (RedashQuery)Asset.updateCertificate(client, RedashQuery._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static RedashQuery removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashQuery)Asset.removeCertificate(client, RedashQuery.updater(qualifiedName, name));
    }

    public static RedashQuery updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (RedashQuery)Asset.updateAnnouncement(client, RedashQuery._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static RedashQuery removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashQuery)Asset.removeAnnouncement(client, RedashQuery.updater(qualifiedName, name));
    }

    public static RedashQuery replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (RedashQuery)Asset.replaceTerms(client, RedashQuery.updater(qualifiedName, name), terms);
    }

    public static RedashQuery appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (RedashQuery)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static RedashQuery removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (RedashQuery)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static RedashQuery appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (RedashQuery)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static RedashQuery appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (RedashQuery)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected RedashQuery(RedashQueryBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> redashQuerySchedule;
        this.typeName = b.typeName$set ? b.typeName$value : RedashQuery.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.redashIsPublished = b.redashIsPublished;
        this.redashQueryLastExecutedAt = b.redashQueryLastExecutedAt;
        this.redashQueryLastExecutionRuntime = b.redashQueryLastExecutionRuntime;
        this.redashQueryParameters = b.redashQueryParameters;
        this.redashQuerySQL = b.redashQuerySQL;
        switch (b.redashQuerySchedule$key == null ? 0 : b.redashQuerySchedule$key.size()) {
            case 0: {
                redashQuerySchedule = Collections.emptyMap();
                break;
            }
            case 1: {
                redashQuerySchedule = Collections.singletonMap(b.redashQuerySchedule$key.get(0), b.redashQuerySchedule$value.get(0));
                break;
            }
            default: {
                redashQuerySchedule = new LinkedHashMap(b.redashQuerySchedule$key.size() < 0x40000000 ? 1 + b.redashQuerySchedule$key.size() + (b.redashQuerySchedule$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.redashQuerySchedule$key.size(); ++$i) {
                    redashQuerySchedule.put(b.redashQuerySchedule$key.get($i), b.redashQuerySchedule$value.get($i));
                }
                redashQuerySchedule = Collections.unmodifiableMap(redashQuerySchedule);
            }
        }
        this.redashQuerySchedule = redashQuerySchedule;
        this.redashQueryScheduleHumanized = b.redashQueryScheduleHumanized;
        SortedSet<IRedashVisualization> redashVisualizations = new TreeSet<IRedashVisualization>();
        if (b.redashVisualizations != null) {
            redashVisualizations.addAll(b.redashVisualizations);
        }
        redashVisualizations = Collections.unmodifiableSortedSet(redashVisualizations);
        this.redashVisualizations = redashVisualizations;
    }

    @Generated
    public static RedashQueryBuilder<?, ?> _internal() {
        return new RedashQueryBuilderImpl();
    }

    @Generated
    public RedashQueryBuilder<?, ?> toBuilder() {
        return new RedashQueryBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public Boolean getRedashIsPublished() {
        return this.redashIsPublished;
    }

    @Override
    @Generated
    public Long getRedashQueryLastExecutedAt() {
        return this.redashQueryLastExecutedAt;
    }

    @Override
    @Generated
    public Double getRedashQueryLastExecutionRuntime() {
        return this.redashQueryLastExecutionRuntime;
    }

    @Override
    @Generated
    public String getRedashQueryParameters() {
        return this.redashQueryParameters;
    }

    @Override
    @Generated
    public String getRedashQuerySQL() {
        return this.redashQuerySQL;
    }

    @Override
    @Generated
    public Map<String, String> getRedashQuerySchedule() {
        return this.redashQuerySchedule;
    }

    @Override
    @Generated
    public String getRedashQueryScheduleHumanized() {
        return this.redashQueryScheduleHumanized;
    }

    @Override
    @Generated
    public SortedSet<IRedashVisualization> getRedashVisualizations() {
        return this.redashVisualizations;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedashQuery)) {
            return false;
        }
        RedashQuery other = (RedashQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$redashIsPublished = this.getRedashIsPublished();
        Boolean other$redashIsPublished = other.getRedashIsPublished();
        if (this$redashIsPublished == null ? other$redashIsPublished != null : !((Object)this$redashIsPublished).equals(other$redashIsPublished)) {
            return false;
        }
        Long this$redashQueryLastExecutedAt = this.getRedashQueryLastExecutedAt();
        Long other$redashQueryLastExecutedAt = other.getRedashQueryLastExecutedAt();
        if (this$redashQueryLastExecutedAt == null ? other$redashQueryLastExecutedAt != null : !((Object)this$redashQueryLastExecutedAt).equals(other$redashQueryLastExecutedAt)) {
            return false;
        }
        Double this$redashQueryLastExecutionRuntime = this.getRedashQueryLastExecutionRuntime();
        Double other$redashQueryLastExecutionRuntime = other.getRedashQueryLastExecutionRuntime();
        if (this$redashQueryLastExecutionRuntime == null ? other$redashQueryLastExecutionRuntime != null : !((Object)this$redashQueryLastExecutionRuntime).equals(other$redashQueryLastExecutionRuntime)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$redashQueryParameters = this.getRedashQueryParameters();
        String other$redashQueryParameters = other.getRedashQueryParameters();
        if (this$redashQueryParameters == null ? other$redashQueryParameters != null : !this$redashQueryParameters.equals(other$redashQueryParameters)) {
            return false;
        }
        String this$redashQuerySQL = this.getRedashQuerySQL();
        String other$redashQuerySQL = other.getRedashQuerySQL();
        if (this$redashQuerySQL == null ? other$redashQuerySQL != null : !this$redashQuerySQL.equals(other$redashQuerySQL)) {
            return false;
        }
        Map<String, String> this$redashQuerySchedule = this.getRedashQuerySchedule();
        Map<String, String> other$redashQuerySchedule = other.getRedashQuerySchedule();
        if (this$redashQuerySchedule == null ? other$redashQuerySchedule != null : !((Object)this$redashQuerySchedule).equals(other$redashQuerySchedule)) {
            return false;
        }
        String this$redashQueryScheduleHumanized = this.getRedashQueryScheduleHumanized();
        String other$redashQueryScheduleHumanized = other.getRedashQueryScheduleHumanized();
        if (this$redashQueryScheduleHumanized == null ? other$redashQueryScheduleHumanized != null : !this$redashQueryScheduleHumanized.equals(other$redashQueryScheduleHumanized)) {
            return false;
        }
        SortedSet<IRedashVisualization> this$redashVisualizations = this.getRedashVisualizations();
        SortedSet<IRedashVisualization> other$redashVisualizations = other.getRedashVisualizations();
        return !(this$redashVisualizations == null ? other$redashVisualizations != null : !this$redashVisualizations.equals(other$redashVisualizations));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RedashQuery;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $redashIsPublished = this.getRedashIsPublished();
        result = result * 59 + ($redashIsPublished == null ? 43 : ((Object)$redashIsPublished).hashCode());
        Long $redashQueryLastExecutedAt = this.getRedashQueryLastExecutedAt();
        result = result * 59 + ($redashQueryLastExecutedAt == null ? 43 : ((Object)$redashQueryLastExecutedAt).hashCode());
        Double $redashQueryLastExecutionRuntime = this.getRedashQueryLastExecutionRuntime();
        result = result * 59 + ($redashQueryLastExecutionRuntime == null ? 43 : ((Object)$redashQueryLastExecutionRuntime).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $redashQueryParameters = this.getRedashQueryParameters();
        result = result * 59 + ($redashQueryParameters == null ? 43 : $redashQueryParameters.hashCode());
        String $redashQuerySQL = this.getRedashQuerySQL();
        result = result * 59 + ($redashQuerySQL == null ? 43 : $redashQuerySQL.hashCode());
        Map<String, String> $redashQuerySchedule = this.getRedashQuerySchedule();
        result = result * 59 + ($redashQuerySchedule == null ? 43 : ((Object)$redashQuerySchedule).hashCode());
        String $redashQueryScheduleHumanized = this.getRedashQueryScheduleHumanized();
        result = result * 59 + ($redashQueryScheduleHumanized == null ? 43 : $redashQueryScheduleHumanized.hashCode());
        SortedSet<IRedashVisualization> $redashVisualizations = this.getRedashVisualizations();
        result = result * 59 + ($redashVisualizations == null ? 43 : $redashVisualizations.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "RedashQuery(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", redashIsPublished=" + this.getRedashIsPublished() + ", redashQueryLastExecutedAt=" + this.getRedashQueryLastExecutedAt() + ", redashQueryLastExecutionRuntime=" + this.getRedashQueryLastExecutionRuntime() + ", redashQueryParameters=" + this.getRedashQueryParameters() + ", redashQuerySQL=" + this.getRedashQuerySQL() + ", redashQuerySchedule=" + String.valueOf(this.getRedashQuerySchedule()) + ", redashQueryScheduleHumanized=" + this.getRedashQueryScheduleHumanized() + ", redashVisualizations=" + String.valueOf(this.getRedashVisualizations()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class RedashQueryBuilder<C extends RedashQuery, B extends RedashQueryBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private Boolean redashIsPublished;
        @Generated
        private Long redashQueryLastExecutedAt;
        @Generated
        private Double redashQueryLastExecutionRuntime;
        @Generated
        private String redashQueryParameters;
        @Generated
        private String redashQuerySQL;
        @Generated
        private ArrayList<String> redashQuerySchedule$key;
        @Generated
        private ArrayList<String> redashQuerySchedule$value;
        @Generated
        private String redashQueryScheduleHumanized;
        @Generated
        private ArrayList<IRedashVisualization> redashVisualizations;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RedashQueryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(RedashQuery instance, RedashQueryBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.redashIsPublished(instance.redashIsPublished);
            b.redashQueryLastExecutedAt(instance.redashQueryLastExecutedAt);
            b.redashQueryLastExecutionRuntime(instance.redashQueryLastExecutionRuntime);
            b.redashQueryParameters(instance.redashQueryParameters);
            b.redashQuerySQL(instance.redashQuerySQL);
            b.redashQuerySchedule(instance.redashQuerySchedule == null ? Collections.emptyMap() : instance.redashQuerySchedule);
            b.redashQueryScheduleHumanized(instance.redashQueryScheduleHumanized);
            b.redashVisualizations(instance.redashVisualizations == null ? Collections.emptySortedSet() : instance.redashVisualizations);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B redashIsPublished(Boolean redashIsPublished) {
            this.redashIsPublished = redashIsPublished;
            return (B)this.self();
        }

        @Generated
        public B redashQueryLastExecutedAt(Long redashQueryLastExecutedAt) {
            this.redashQueryLastExecutedAt = redashQueryLastExecutedAt;
            return (B)this.self();
        }

        @Generated
        public B redashQueryLastExecutionRuntime(Double redashQueryLastExecutionRuntime) {
            this.redashQueryLastExecutionRuntime = redashQueryLastExecutionRuntime;
            return (B)this.self();
        }

        @Generated
        public B redashQueryParameters(String redashQueryParameters) {
            this.redashQueryParameters = redashQueryParameters;
            return (B)this.self();
        }

        @Generated
        public B redashQuerySQL(String redashQuerySQL) {
            this.redashQuerySQL = redashQuerySQL;
            return (B)this.self();
        }

        @Generated
        public B putRedashQuerySchedule(String putRedashQueryScheduleKey, String putRedashQueryScheduleValue) {
            if (this.redashQuerySchedule$key == null) {
                this.redashQuerySchedule$key = new ArrayList();
                this.redashQuerySchedule$value = new ArrayList();
            }
            this.redashQuerySchedule$key.add(putRedashQueryScheduleKey);
            this.redashQuerySchedule$value.add(putRedashQueryScheduleValue);
            return (B)this.self();
        }

        @Generated
        public B redashQuerySchedule(Map<? extends String, ? extends String> redashQuerySchedule) {
            if (redashQuerySchedule == null) {
                throw new NullPointerException("redashQuerySchedule cannot be null");
            }
            if (this.redashQuerySchedule$key == null) {
                this.redashQuerySchedule$key = new ArrayList();
                this.redashQuerySchedule$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : redashQuerySchedule.entrySet()) {
                this.redashQuerySchedule$key.add($lombokEntry.getKey());
                this.redashQuerySchedule$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearRedashQuerySchedule() {
            if (this.redashQuerySchedule$key != null) {
                this.redashQuerySchedule$key.clear();
                this.redashQuerySchedule$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B redashQueryScheduleHumanized(String redashQueryScheduleHumanized) {
            this.redashQueryScheduleHumanized = redashQueryScheduleHumanized;
            return (B)this.self();
        }

        @Generated
        public B redashVisualization(IRedashVisualization redashVisualization) {
            if (this.redashVisualizations == null) {
                this.redashVisualizations = new ArrayList();
            }
            this.redashVisualizations.add(redashVisualization);
            return (B)this.self();
        }

        @Generated
        public B redashVisualizations(Collection<? extends IRedashVisualization> redashVisualizations) {
            if (redashVisualizations == null) {
                throw new NullPointerException("redashVisualizations cannot be null");
            }
            if (this.redashVisualizations == null) {
                this.redashVisualizations = new ArrayList();
            }
            this.redashVisualizations.addAll(redashVisualizations);
            return (B)this.self();
        }

        @Generated
        public B clearRedashVisualizations() {
            if (this.redashVisualizations != null) {
                this.redashVisualizations.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RedashQuery.RedashQueryBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", redashIsPublished=" + this.redashIsPublished + ", redashQueryLastExecutedAt=" + this.redashQueryLastExecutedAt + ", redashQueryLastExecutionRuntime=" + this.redashQueryLastExecutionRuntime + ", redashQueryParameters=" + this.redashQueryParameters + ", redashQuerySQL=" + this.redashQuerySQL + ", redashQuerySchedule$key=" + String.valueOf(this.redashQuerySchedule$key) + ", redashQuerySchedule$value=" + String.valueOf(this.redashQuerySchedule$value) + ", redashQueryScheduleHumanized=" + this.redashQueryScheduleHumanized + ", redashVisualizations=" + String.valueOf(this.redashVisualizations) + ")";
        }
    }

    @Generated
    private static final class RedashQueryBuilderImpl
    extends RedashQueryBuilder<RedashQuery, RedashQueryBuilderImpl> {
        @Generated
        private RedashQueryBuilderImpl() {
        }

        @Override
        @Generated
        protected RedashQueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RedashQuery build() {
            return new RedashQuery(this);
        }
    }
}

