/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISaaS;
import com.atlan.model.assets.ISalesforce;
import com.atlan.model.assets.ISalesforceField;
import com.atlan.model.assets.ISalesforceObject;
import com.atlan.model.assets.ISalesforceOrganization;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.SalesforceOrganization;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceObject
extends Asset
implements ISalesforceObject,
ISalesforce,
ISaaS,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SalesforceObject.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SalesforceObject";
    String typeName;
    @Attribute
    String apiName;
    @Attribute
    Long fieldCount;
    @Attribute
    SortedSet<ISalesforceField> fields;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    Boolean isCustom;
    @Attribute
    Boolean isMergable;
    @Attribute
    Boolean isQueryable;
    @Attribute
    SortedSet<ISalesforceField> lookupFields;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    ISalesforceOrganization organization;
    @Attribute
    String organizationQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public SalesforceObject trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SalesforceObject.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SalesforceObject.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SalesforceObject.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SalesforceObject.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static SalesforceObject refByGuid(String guid) {
        return SalesforceObject.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static SalesforceObject refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((SalesforceObjectBuilder)((SalesforceObjectBuilder)SalesforceObject._internal().guid(guid)).semantic(semantic)).build();
    }

    public static SalesforceObject refByQualifiedName(String qualifiedName) {
        return SalesforceObject.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static SalesforceObject refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((SalesforceObjectBuilder)((SalesforceObjectBuilder)SalesforceObject._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static SalesforceObject get(AtlanClient client, String id) throws AtlanException {
        return SalesforceObject.get(client, id, false);
    }

    @JsonIgnore
    public static SalesforceObject get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SalesforceObject) {
                return (SalesforceObject)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof SalesforceObject) {
            return (SalesforceObject)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static SalesforceObject get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return SalesforceObject.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static SalesforceObject get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)SalesforceObject.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof SalesforceObject) {
                return (SalesforceObject)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)SalesforceObject.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof SalesforceObject) {
            return (SalesforceObject)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SalesforceObjectBuilder<?, ?> creator(String name, SalesforceOrganization organization) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", organization.getQualifiedName());
        map.put("connectionQualifiedName", organization.getConnectionQualifiedName());
        SalesforceObject.validateRelationship("SalesforceOrganization", map);
        return SalesforceObject.creator(name, organization.getConnectionQualifiedName(), organization.getQualifiedName()).organization(organization.trimToReference());
    }

    public static SalesforceObjectBuilder<?, ?> creator(String name, String organizationQualifiedName) {
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(organizationQualifiedName);
        return SalesforceObject.creator(name, connectionQualifiedName, organizationQualifiedName);
    }

    public static SalesforceObjectBuilder<?, ?> creator(String name, String connectionQualifiedName, String organizationQualifiedName) {
        return ((SalesforceObjectBuilder)((SalesforceObjectBuilder)((SalesforceObjectBuilder)((SalesforceObjectBuilder)((SalesforceObjectBuilder)((SalesforceObjectBuilder)SalesforceObject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(SalesforceObject.generateQualifiedName(name, organizationQualifiedName))).name(name)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.SALESFORCE)).organization(SalesforceOrganization.refByQualifiedName(organizationQualifiedName))).organizationQualifiedName(organizationQualifiedName);
    }

    public static String generateQualifiedName(String name, String organizationQualifiedName) {
        return organizationQualifiedName + "/" + name;
    }

    public static SalesforceObjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SalesforceObjectBuilder)((SalesforceObjectBuilder)((SalesforceObjectBuilder)SalesforceObject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SalesforceObjectBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        SalesforceObject.validateRequired(TYPE_NAME, map);
        return SalesforceObject.updater(this.getQualifiedName(), this.getName());
    }

    public static SalesforceObject removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceObject)Asset.removeDescription(client, SalesforceObject.updater(qualifiedName, name));
    }

    public static SalesforceObject removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceObject)Asset.removeUserDescription(client, SalesforceObject.updater(qualifiedName, name));
    }

    public static SalesforceObject removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceObject)Asset.removeOwners(client, SalesforceObject.updater(qualifiedName, name));
    }

    public static SalesforceObject updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SalesforceObject)Asset.updateCertificate(client, SalesforceObject._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SalesforceObject removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceObject)Asset.removeCertificate(client, SalesforceObject.updater(qualifiedName, name));
    }

    public static SalesforceObject updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SalesforceObject)Asset.updateAnnouncement(client, SalesforceObject._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SalesforceObject removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceObject)Asset.removeAnnouncement(client, SalesforceObject.updater(qualifiedName, name));
    }

    public static SalesforceObject replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SalesforceObject)Asset.replaceTerms(client, SalesforceObject.updater(qualifiedName, name), terms);
    }

    public static SalesforceObject appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SalesforceObject)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SalesforceObject removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SalesforceObject)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SalesforceObject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SalesforceObject)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static SalesforceObject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SalesforceObject)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SalesforceObject(SalesforceObjectBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SalesforceObject.$default$typeName();
        this.apiName = b.apiName;
        this.fieldCount = b.fieldCount;
        SortedSet<ISalesforceField> fields = new TreeSet<ISalesforceField>();
        if (b.fields != null) {
            fields.addAll(b.fields);
        }
        fields = Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isCustom = b.isCustom;
        this.isMergable = b.isMergable;
        this.isQueryable = b.isQueryable;
        SortedSet<ISalesforceField> lookupFields = new TreeSet<ISalesforceField>();
        if (b.lookupFields != null) {
            lookupFields.addAll(b.lookupFields);
        }
        lookupFields = Collections.unmodifiableSortedSet(lookupFields);
        this.lookupFields = lookupFields;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        this.organization = b.organization;
        this.organizationQualifiedName = b.organizationQualifiedName;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static SalesforceObjectBuilder<?, ?> _internal() {
        return new SalesforceObjectBuilderImpl();
    }

    @Generated
    public SalesforceObjectBuilder<?, ?> toBuilder() {
        return new SalesforceObjectBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getApiName() {
        return this.apiName;
    }

    @Override
    @Generated
    public Long getFieldCount() {
        return this.fieldCount;
    }

    @Override
    @Generated
    public SortedSet<ISalesforceField> getFields() {
        return this.fields;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public Boolean getIsCustom() {
        return this.isCustom;
    }

    @Override
    @Generated
    public Boolean getIsMergable() {
        return this.isMergable;
    }

    @Override
    @Generated
    public Boolean getIsQueryable() {
        return this.isQueryable;
    }

    @Override
    @Generated
    public SortedSet<ISalesforceField> getLookupFields() {
        return this.lookupFields;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public ISalesforceOrganization getOrganization() {
        return this.organization;
    }

    @Override
    @Generated
    public String getOrganizationQualifiedName() {
        return this.organizationQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SalesforceObject)) {
            return false;
        }
        SalesforceObject other = (SalesforceObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$fieldCount = this.getFieldCount();
        Long other$fieldCount = other.getFieldCount();
        if (this$fieldCount == null ? other$fieldCount != null : !((Object)this$fieldCount).equals(other$fieldCount)) {
            return false;
        }
        Boolean this$isCustom = this.getIsCustom();
        Boolean other$isCustom = other.getIsCustom();
        if (this$isCustom == null ? other$isCustom != null : !((Object)this$isCustom).equals(other$isCustom)) {
            return false;
        }
        Boolean this$isMergable = this.getIsMergable();
        Boolean other$isMergable = other.getIsMergable();
        if (this$isMergable == null ? other$isMergable != null : !((Object)this$isMergable).equals(other$isMergable)) {
            return false;
        }
        Boolean this$isQueryable = this.getIsQueryable();
        Boolean other$isQueryable = other.getIsQueryable();
        if (this$isQueryable == null ? other$isQueryable != null : !((Object)this$isQueryable).equals(other$isQueryable)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$apiName = this.getApiName();
        String other$apiName = other.getApiName();
        if (this$apiName == null ? other$apiName != null : !this$apiName.equals(other$apiName)) {
            return false;
        }
        SortedSet<ISalesforceField> this$fields = this.getFields();
        SortedSet<ISalesforceField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<ISalesforceField> this$lookupFields = this.getLookupFields();
        SortedSet<ISalesforceField> other$lookupFields = other.getLookupFields();
        if (this$lookupFields == null ? other$lookupFields != null : !this$lookupFields.equals(other$lookupFields)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        ISalesforceOrganization this$organization = this.getOrganization();
        ISalesforceOrganization other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        String this$organizationQualifiedName = this.getOrganizationQualifiedName();
        String other$organizationQualifiedName = other.getOrganizationQualifiedName();
        if (this$organizationQualifiedName == null ? other$organizationQualifiedName != null : !this$organizationQualifiedName.equals(other$organizationQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SalesforceObject;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $fieldCount = this.getFieldCount();
        result = result * 59 + ($fieldCount == null ? 43 : ((Object)$fieldCount).hashCode());
        Boolean $isCustom = this.getIsCustom();
        result = result * 59 + ($isCustom == null ? 43 : ((Object)$isCustom).hashCode());
        Boolean $isMergable = this.getIsMergable();
        result = result * 59 + ($isMergable == null ? 43 : ((Object)$isMergable).hashCode());
        Boolean $isQueryable = this.getIsQueryable();
        result = result * 59 + ($isQueryable == null ? 43 : ((Object)$isQueryable).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $apiName = this.getApiName();
        result = result * 59 + ($apiName == null ? 43 : $apiName.hashCode());
        SortedSet<ISalesforceField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<ISalesforceField> $lookupFields = this.getLookupFields();
        result = result * 59 + ($lookupFields == null ? 43 : $lookupFields.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        ISalesforceOrganization $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        String $organizationQualifiedName = this.getOrganizationQualifiedName();
        result = result * 59 + ($organizationQualifiedName == null ? 43 : $organizationQualifiedName.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SalesforceObject(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", apiName=" + this.getApiName() + ", fieldCount=" + this.getFieldCount() + ", fields=" + String.valueOf(this.getFields()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", isCustom=" + this.getIsCustom() + ", isMergable=" + this.getIsMergable() + ", isQueryable=" + this.getIsQueryable() + ", lookupFields=" + String.valueOf(this.getLookupFields()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", organization=" + String.valueOf(this.getOrganization()) + ", organizationQualifiedName=" + this.getOrganizationQualifiedName() + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class SalesforceObjectBuilder<C extends SalesforceObject, B extends SalesforceObjectBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String apiName;
        @Generated
        private Long fieldCount;
        @Generated
        private ArrayList<ISalesforceField> fields;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private Boolean isCustom;
        @Generated
        private Boolean isMergable;
        @Generated
        private Boolean isQueryable;
        @Generated
        private ArrayList<ISalesforceField> lookupFields;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ISalesforceOrganization organization;
        @Generated
        private String organizationQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SalesforceObjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SalesforceObject instance, SalesforceObjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.apiName(instance.apiName);
            b.fieldCount(instance.fieldCount);
            b.fields(instance.fields == null ? Collections.emptySortedSet() : instance.fields);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.isCustom(instance.isCustom);
            b.isMergable(instance.isMergable);
            b.isQueryable(instance.isQueryable);
            b.lookupFields(instance.lookupFields == null ? Collections.emptySortedSet() : instance.lookupFields);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.organization(instance.organization);
            b.organizationQualifiedName(instance.organizationQualifiedName);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B apiName(String apiName) {
            this.apiName = apiName;
            return (B)this.self();
        }

        @Generated
        public B fieldCount(Long fieldCount) {
            this.fieldCount = fieldCount;
            return (B)this.self();
        }

        @Generated
        public B field(ISalesforceField field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return (B)this.self();
        }

        @Generated
        public B fields(Collection<? extends ISalesforceField> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return (B)this.self();
        }

        @Generated
        public B clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isCustom(Boolean isCustom) {
            this.isCustom = isCustom;
            return (B)this.self();
        }

        @Generated
        public B isMergable(Boolean isMergable) {
            this.isMergable = isMergable;
            return (B)this.self();
        }

        @Generated
        public B isQueryable(Boolean isQueryable) {
            this.isQueryable = isQueryable;
            return (B)this.self();
        }

        @Generated
        public B lookupField(ISalesforceField lookupField) {
            if (this.lookupFields == null) {
                this.lookupFields = new ArrayList();
            }
            this.lookupFields.add(lookupField);
            return (B)this.self();
        }

        @Generated
        public B lookupFields(Collection<? extends ISalesforceField> lookupFields) {
            if (lookupFields == null) {
                throw new NullPointerException("lookupFields cannot be null");
            }
            if (this.lookupFields == null) {
                this.lookupFields = new ArrayList();
            }
            this.lookupFields.addAll(lookupFields);
            return (B)this.self();
        }

        @Generated
        public B clearLookupFields() {
            if (this.lookupFields != null) {
                this.lookupFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B organization(ISalesforceOrganization organization) {
            this.organization = organization;
            return (B)this.self();
        }

        @Generated
        public B organizationQualifiedName(String organizationQualifiedName) {
            this.organizationQualifiedName = organizationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SalesforceObject.SalesforceObjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", apiName=" + this.apiName + ", fieldCount=" + this.fieldCount + ", fields=" + String.valueOf(this.fields) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", isCustom=" + this.isCustom + ", isMergable=" + this.isMergable + ", isQueryable=" + this.isQueryable + ", lookupFields=" + String.valueOf(this.lookupFields) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", organization=" + String.valueOf(this.organization) + ", organizationQualifiedName=" + this.organizationQualifiedName + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class SalesforceObjectBuilderImpl
    extends SalesforceObjectBuilder<SalesforceObject, SalesforceObjectBuilderImpl> {
        @Generated
        private SalesforceObjectBuilderImpl() {
        }

        @Override
        @Generated
        protected SalesforceObjectBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SalesforceObject build() {
            return new SalesforceObject(this);
        }
    }
}

