/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISpark;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.OpenLineageRunState;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkJob
extends Asset
implements ISparkJob,
ISpark,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SparkJob.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SparkJob";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<ICatalog> inputs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    SortedSet<ICatalog> outputs;
    @Attribute
    ILineageProcess process;
    @Attribute
    String sparkAppName;
    @Attribute
    String sparkMaster;
    @Attribute
    @Date
    Long sparkRunEndTime;
    @Attribute
    OpenLineageRunState sparkRunOpenLineageState;
    @Attribute
    String sparkRunOpenLineageVersion;
    @Attribute
    @Date
    Long sparkRunStartTime;
    @Attribute
    String sparkRunVersion;

    @Override
    public SparkJob trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SparkJob.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SparkJob.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SparkJob.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SparkJob.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static SparkJob refByGuid(String guid) {
        return SparkJob.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static SparkJob refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((SparkJobBuilder)((SparkJobBuilder)SparkJob._internal().guid(guid)).semantic(semantic)).build();
    }

    public static SparkJob refByQualifiedName(String qualifiedName) {
        return SparkJob.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static SparkJob refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((SparkJobBuilder)((SparkJobBuilder)SparkJob._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static SparkJob get(AtlanClient client, String id) throws AtlanException {
        return SparkJob.get(client, id, false);
    }

    @JsonIgnore
    public static SparkJob get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SparkJob) {
                return (SparkJob)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof SparkJob) {
            return (SparkJob)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static SparkJob get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return SparkJob.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static SparkJob get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)SparkJob.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof SparkJob) {
                return (SparkJob)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)SparkJob.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof SparkJob) {
            return (SparkJob)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SparkJobBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SparkJobBuilder)((SparkJobBuilder)((SparkJobBuilder)SparkJob._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SparkJobBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        SparkJob.validateRequired(TYPE_NAME, map);
        return SparkJob.updater(this.getQualifiedName(), this.getName());
    }

    public static SparkJob removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SparkJob)Asset.removeDescription(client, SparkJob.updater(qualifiedName, name));
    }

    public static SparkJob removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SparkJob)Asset.removeUserDescription(client, SparkJob.updater(qualifiedName, name));
    }

    public static SparkJob removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SparkJob)Asset.removeOwners(client, SparkJob.updater(qualifiedName, name));
    }

    public static SparkJob updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SparkJob)Asset.updateCertificate(client, SparkJob._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SparkJob removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SparkJob)Asset.removeCertificate(client, SparkJob.updater(qualifiedName, name));
    }

    public static SparkJob updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SparkJob)Asset.updateAnnouncement(client, SparkJob._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SparkJob removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SparkJob)Asset.removeAnnouncement(client, SparkJob.updater(qualifiedName, name));
    }

    public static SparkJob replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SparkJob)Asset.replaceTerms(client, SparkJob.updater(qualifiedName, name), terms);
    }

    public static SparkJob appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SparkJob)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SparkJob removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SparkJob)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SparkJob appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SparkJob)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static SparkJob appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SparkJob)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SparkJob(SparkJobBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SparkJob.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<ICatalog> inputs = new TreeSet<ICatalog>();
        if (b.inputs != null) {
            inputs.addAll(b.inputs);
        }
        inputs = Collections.unmodifiableSortedSet(inputs);
        this.inputs = inputs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        SortedSet<ICatalog> outputs = new TreeSet<ICatalog>();
        if (b.outputs != null) {
            outputs.addAll(b.outputs);
        }
        outputs = Collections.unmodifiableSortedSet(outputs);
        this.outputs = outputs;
        this.process = b.process;
        this.sparkAppName = b.sparkAppName;
        this.sparkMaster = b.sparkMaster;
        this.sparkRunEndTime = b.sparkRunEndTime;
        this.sparkRunOpenLineageState = b.sparkRunOpenLineageState;
        this.sparkRunOpenLineageVersion = b.sparkRunOpenLineageVersion;
        this.sparkRunStartTime = b.sparkRunStartTime;
        this.sparkRunVersion = b.sparkRunVersion;
    }

    @Generated
    public static SparkJobBuilder<?, ?> _internal() {
        return new SparkJobBuilderImpl();
    }

    @Generated
    public SparkJobBuilder<?, ?> toBuilder() {
        return new SparkJobBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<ICatalog> getInputs() {
        return this.inputs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<ICatalog> getOutputs() {
        return this.outputs;
    }

    @Override
    @Generated
    public ILineageProcess getProcess() {
        return this.process;
    }

    @Override
    @Generated
    public String getSparkAppName() {
        return this.sparkAppName;
    }

    @Override
    @Generated
    public String getSparkMaster() {
        return this.sparkMaster;
    }

    @Override
    @Generated
    public Long getSparkRunEndTime() {
        return this.sparkRunEndTime;
    }

    @Override
    @Generated
    public OpenLineageRunState getSparkRunOpenLineageState() {
        return this.sparkRunOpenLineageState;
    }

    @Override
    @Generated
    public String getSparkRunOpenLineageVersion() {
        return this.sparkRunOpenLineageVersion;
    }

    @Override
    @Generated
    public Long getSparkRunStartTime() {
        return this.sparkRunStartTime;
    }

    @Override
    @Generated
    public String getSparkRunVersion() {
        return this.sparkRunVersion;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SparkJob)) {
            return false;
        }
        SparkJob other = (SparkJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$sparkRunEndTime = this.getSparkRunEndTime();
        Long other$sparkRunEndTime = other.getSparkRunEndTime();
        if (this$sparkRunEndTime == null ? other$sparkRunEndTime != null : !((Object)this$sparkRunEndTime).equals(other$sparkRunEndTime)) {
            return false;
        }
        Long this$sparkRunStartTime = this.getSparkRunStartTime();
        Long other$sparkRunStartTime = other.getSparkRunStartTime();
        if (this$sparkRunStartTime == null ? other$sparkRunStartTime != null : !((Object)this$sparkRunStartTime).equals(other$sparkRunStartTime)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<ICatalog> this$inputs = this.getInputs();
        SortedSet<ICatalog> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<ICatalog> this$outputs = this.getOutputs();
        SortedSet<ICatalog> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !this$outputs.equals(other$outputs)) {
            return false;
        }
        ILineageProcess this$process = this.getProcess();
        ILineageProcess other$process = other.getProcess();
        if (this$process == null ? other$process != null : !this$process.equals(other$process)) {
            return false;
        }
        String this$sparkAppName = this.getSparkAppName();
        String other$sparkAppName = other.getSparkAppName();
        if (this$sparkAppName == null ? other$sparkAppName != null : !this$sparkAppName.equals(other$sparkAppName)) {
            return false;
        }
        String this$sparkMaster = this.getSparkMaster();
        String other$sparkMaster = other.getSparkMaster();
        if (this$sparkMaster == null ? other$sparkMaster != null : !this$sparkMaster.equals(other$sparkMaster)) {
            return false;
        }
        OpenLineageRunState this$sparkRunOpenLineageState = this.getSparkRunOpenLineageState();
        OpenLineageRunState other$sparkRunOpenLineageState = other.getSparkRunOpenLineageState();
        if (this$sparkRunOpenLineageState == null ? other$sparkRunOpenLineageState != null : !this$sparkRunOpenLineageState.equals(other$sparkRunOpenLineageState)) {
            return false;
        }
        String this$sparkRunOpenLineageVersion = this.getSparkRunOpenLineageVersion();
        String other$sparkRunOpenLineageVersion = other.getSparkRunOpenLineageVersion();
        if (this$sparkRunOpenLineageVersion == null ? other$sparkRunOpenLineageVersion != null : !this$sparkRunOpenLineageVersion.equals(other$sparkRunOpenLineageVersion)) {
            return false;
        }
        String this$sparkRunVersion = this.getSparkRunVersion();
        String other$sparkRunVersion = other.getSparkRunVersion();
        return !(this$sparkRunVersion == null ? other$sparkRunVersion != null : !this$sparkRunVersion.equals(other$sparkRunVersion));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SparkJob;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $sparkRunEndTime = this.getSparkRunEndTime();
        result = result * 59 + ($sparkRunEndTime == null ? 43 : ((Object)$sparkRunEndTime).hashCode());
        Long $sparkRunStartTime = this.getSparkRunStartTime();
        result = result * 59 + ($sparkRunStartTime == null ? 43 : ((Object)$sparkRunStartTime).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<ICatalog> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : $inputs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<ICatalog> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : $outputs.hashCode());
        ILineageProcess $process = this.getProcess();
        result = result * 59 + ($process == null ? 43 : $process.hashCode());
        String $sparkAppName = this.getSparkAppName();
        result = result * 59 + ($sparkAppName == null ? 43 : $sparkAppName.hashCode());
        String $sparkMaster = this.getSparkMaster();
        result = result * 59 + ($sparkMaster == null ? 43 : $sparkMaster.hashCode());
        OpenLineageRunState $sparkRunOpenLineageState = this.getSparkRunOpenLineageState();
        result = result * 59 + ($sparkRunOpenLineageState == null ? 43 : $sparkRunOpenLineageState.hashCode());
        String $sparkRunOpenLineageVersion = this.getSparkRunOpenLineageVersion();
        result = result * 59 + ($sparkRunOpenLineageVersion == null ? 43 : $sparkRunOpenLineageVersion.hashCode());
        String $sparkRunVersion = this.getSparkRunVersion();
        result = result * 59 + ($sparkRunVersion == null ? 43 : $sparkRunVersion.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SparkJob(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", inputs=" + String.valueOf(this.getInputs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", outputs=" + String.valueOf(this.getOutputs()) + ", process=" + String.valueOf(this.getProcess()) + ", sparkAppName=" + this.getSparkAppName() + ", sparkMaster=" + this.getSparkMaster() + ", sparkRunEndTime=" + this.getSparkRunEndTime() + ", sparkRunOpenLineageState=" + String.valueOf(this.getSparkRunOpenLineageState()) + ", sparkRunOpenLineageVersion=" + this.getSparkRunOpenLineageVersion() + ", sparkRunStartTime=" + this.getSparkRunStartTime() + ", sparkRunVersion=" + this.getSparkRunVersion() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class SparkJobBuilder<C extends SparkJob, B extends SparkJobBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<ICatalog> inputs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<ICatalog> outputs;
        @Generated
        private ILineageProcess process;
        @Generated
        private String sparkAppName;
        @Generated
        private String sparkMaster;
        @Generated
        private Long sparkRunEndTime;
        @Generated
        private OpenLineageRunState sparkRunOpenLineageState;
        @Generated
        private String sparkRunOpenLineageVersion;
        @Generated
        private Long sparkRunStartTime;
        @Generated
        private String sparkRunVersion;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SparkJobBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SparkJob instance, SparkJobBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.inputs(instance.inputs == null ? Collections.emptySortedSet() : instance.inputs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.outputs(instance.outputs == null ? Collections.emptySortedSet() : instance.outputs);
            b.process(instance.process);
            b.sparkAppName(instance.sparkAppName);
            b.sparkMaster(instance.sparkMaster);
            b.sparkRunEndTime(instance.sparkRunEndTime);
            b.sparkRunOpenLineageState(instance.sparkRunOpenLineageState);
            b.sparkRunOpenLineageVersion(instance.sparkRunOpenLineageVersion);
            b.sparkRunStartTime(instance.sparkRunStartTime);
            b.sparkRunVersion(instance.sparkRunVersion);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B input(ICatalog input) {
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.add(input);
            return (B)this.self();
        }

        @Generated
        public B inputs(Collection<? extends ICatalog> inputs) {
            if (inputs == null) {
                throw new NullPointerException("inputs cannot be null");
            }
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.addAll(inputs);
            return (B)this.self();
        }

        @Generated
        public B clearInputs() {
            if (this.inputs != null) {
                this.inputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B output(ICatalog output) {
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.add(output);
            return (B)this.self();
        }

        @Generated
        public B outputs(Collection<? extends ICatalog> outputs) {
            if (outputs == null) {
                throw new NullPointerException("outputs cannot be null");
            }
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.addAll(outputs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputs() {
            if (this.outputs != null) {
                this.outputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B process(ILineageProcess process) {
            this.process = process;
            return (B)this.self();
        }

        @Generated
        public B sparkAppName(String sparkAppName) {
            this.sparkAppName = sparkAppName;
            return (B)this.self();
        }

        @Generated
        public B sparkMaster(String sparkMaster) {
            this.sparkMaster = sparkMaster;
            return (B)this.self();
        }

        @Generated
        public B sparkRunEndTime(Long sparkRunEndTime) {
            this.sparkRunEndTime = sparkRunEndTime;
            return (B)this.self();
        }

        @Generated
        public B sparkRunOpenLineageState(OpenLineageRunState sparkRunOpenLineageState) {
            this.sparkRunOpenLineageState = sparkRunOpenLineageState;
            return (B)this.self();
        }

        @Generated
        public B sparkRunOpenLineageVersion(String sparkRunOpenLineageVersion) {
            this.sparkRunOpenLineageVersion = sparkRunOpenLineageVersion;
            return (B)this.self();
        }

        @Generated
        public B sparkRunStartTime(Long sparkRunStartTime) {
            this.sparkRunStartTime = sparkRunStartTime;
            return (B)this.self();
        }

        @Generated
        public B sparkRunVersion(String sparkRunVersion) {
            this.sparkRunVersion = sparkRunVersion;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SparkJob.SparkJobBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", inputs=" + String.valueOf(this.inputs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", outputs=" + String.valueOf(this.outputs) + ", process=" + String.valueOf(this.process) + ", sparkAppName=" + this.sparkAppName + ", sparkMaster=" + this.sparkMaster + ", sparkRunEndTime=" + this.sparkRunEndTime + ", sparkRunOpenLineageState=" + String.valueOf(this.sparkRunOpenLineageState) + ", sparkRunOpenLineageVersion=" + this.sparkRunOpenLineageVersion + ", sparkRunStartTime=" + this.sparkRunStartTime + ", sparkRunVersion=" + this.sparkRunVersion + ")";
        }
    }

    @Generated
    private static final class SparkJobBuilderImpl
    extends SparkJobBuilder<SparkJob, SparkJobBuilderImpl> {
        @Generated
        private SparkJobBuilderImpl() {
        }

        @Override
        @Generated
        protected SparkJobBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SparkJob build() {
            return new SparkJob(this);
        }
    }
}

