/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.IThoughtspot;
import com.atlan.model.assets.IThoughtspotColumn;
import com.atlan.model.assets.IThoughtspotTable;
import com.atlan.model.assets.IThoughtspotView;
import com.atlan.model.assets.IThoughtspotWorksheet;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThoughtspotColumn
extends Asset
implements IThoughtspotColumn,
IThoughtspot,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThoughtspotColumn.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ThoughtspotColumn";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    String thoughtspotChartType;
    @Attribute
    Long thoughtspotColumnCount;
    @Attribute
    String thoughtspotColumnDataType;
    @Attribute
    String thoughtspotColumnType;
    @Attribute
    Long thoughtspotJoinCount;
    @Attribute
    String thoughtspotQuestionText;
    @Attribute
    IThoughtspotTable thoughtspotTable;
    @Attribute
    String thoughtspotTableQualifiedName;
    @Attribute
    IThoughtspotView thoughtspotView;
    @Attribute
    String thoughtspotViewQualifiedName;
    @Attribute
    IThoughtspotWorksheet thoughtspotWorksheet;
    @Attribute
    String thoughtspotWorksheetQualifiedName;

    @Override
    public ThoughtspotColumn trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ThoughtspotColumn.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ThoughtspotColumn.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ThoughtspotColumn.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ThoughtspotColumn.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static ThoughtspotColumn refByGuid(String guid) {
        return ThoughtspotColumn.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static ThoughtspotColumn refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((ThoughtspotColumnBuilder)((ThoughtspotColumnBuilder)ThoughtspotColumn._internal().guid(guid)).semantic(semantic)).build();
    }

    public static ThoughtspotColumn refByQualifiedName(String qualifiedName) {
        return ThoughtspotColumn.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static ThoughtspotColumn refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((ThoughtspotColumnBuilder)((ThoughtspotColumnBuilder)ThoughtspotColumn._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static ThoughtspotColumn get(AtlanClient client, String id) throws AtlanException {
        return ThoughtspotColumn.get(client, id, false);
    }

    @JsonIgnore
    public static ThoughtspotColumn get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ThoughtspotColumn) {
                return (ThoughtspotColumn)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof ThoughtspotColumn) {
            return (ThoughtspotColumn)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static ThoughtspotColumn get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return ThoughtspotColumn.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static ThoughtspotColumn get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)ThoughtspotColumn.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof ThoughtspotColumn) {
                return (ThoughtspotColumn)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)ThoughtspotColumn.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof ThoughtspotColumn) {
            return (ThoughtspotColumn)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ThoughtspotColumnBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ThoughtspotColumnBuilder)((ThoughtspotColumnBuilder)((ThoughtspotColumnBuilder)ThoughtspotColumn._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ThoughtspotColumnBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        ThoughtspotColumn.validateRequired(TYPE_NAME, map);
        return ThoughtspotColumn.updater(this.getQualifiedName(), this.getName());
    }

    public static ThoughtspotColumn removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotColumn)Asset.removeDescription(client, ThoughtspotColumn.updater(qualifiedName, name));
    }

    public static ThoughtspotColumn removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotColumn)Asset.removeUserDescription(client, ThoughtspotColumn.updater(qualifiedName, name));
    }

    public static ThoughtspotColumn removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotColumn)Asset.removeOwners(client, ThoughtspotColumn.updater(qualifiedName, name));
    }

    public static ThoughtspotColumn updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ThoughtspotColumn)Asset.updateCertificate(client, ThoughtspotColumn._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ThoughtspotColumn removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotColumn)Asset.removeCertificate(client, ThoughtspotColumn.updater(qualifiedName, name));
    }

    public static ThoughtspotColumn updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ThoughtspotColumn)Asset.updateAnnouncement(client, ThoughtspotColumn._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ThoughtspotColumn removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotColumn)Asset.removeAnnouncement(client, ThoughtspotColumn.updater(qualifiedName, name));
    }

    public static ThoughtspotColumn replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotColumn)Asset.replaceTerms(client, ThoughtspotColumn.updater(qualifiedName, name), terms);
    }

    public static ThoughtspotColumn appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotColumn)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ThoughtspotColumn removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotColumn)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ThoughtspotColumn appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ThoughtspotColumn)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static ThoughtspotColumn appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ThoughtspotColumn)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ThoughtspotColumn(ThoughtspotColumnBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ThoughtspotColumn.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.thoughtspotChartType = b.thoughtspotChartType;
        this.thoughtspotColumnCount = b.thoughtspotColumnCount;
        this.thoughtspotColumnDataType = b.thoughtspotColumnDataType;
        this.thoughtspotColumnType = b.thoughtspotColumnType;
        this.thoughtspotJoinCount = b.thoughtspotJoinCount;
        this.thoughtspotQuestionText = b.thoughtspotQuestionText;
        this.thoughtspotTable = b.thoughtspotTable;
        this.thoughtspotTableQualifiedName = b.thoughtspotTableQualifiedName;
        this.thoughtspotView = b.thoughtspotView;
        this.thoughtspotViewQualifiedName = b.thoughtspotViewQualifiedName;
        this.thoughtspotWorksheet = b.thoughtspotWorksheet;
        this.thoughtspotWorksheetQualifiedName = b.thoughtspotWorksheetQualifiedName;
    }

    @Generated
    public static ThoughtspotColumnBuilder<?, ?> _internal() {
        return new ThoughtspotColumnBuilderImpl();
    }

    @Generated
    public ThoughtspotColumnBuilder<?, ?> toBuilder() {
        return new ThoughtspotColumnBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public String getThoughtspotChartType() {
        return this.thoughtspotChartType;
    }

    @Override
    @Generated
    public Long getThoughtspotColumnCount() {
        return this.thoughtspotColumnCount;
    }

    @Override
    @Generated
    public String getThoughtspotColumnDataType() {
        return this.thoughtspotColumnDataType;
    }

    @Override
    @Generated
    public String getThoughtspotColumnType() {
        return this.thoughtspotColumnType;
    }

    @Override
    @Generated
    public Long getThoughtspotJoinCount() {
        return this.thoughtspotJoinCount;
    }

    @Override
    @Generated
    public String getThoughtspotQuestionText() {
        return this.thoughtspotQuestionText;
    }

    @Override
    @Generated
    public IThoughtspotTable getThoughtspotTable() {
        return this.thoughtspotTable;
    }

    @Override
    @Generated
    public String getThoughtspotTableQualifiedName() {
        return this.thoughtspotTableQualifiedName;
    }

    @Override
    @Generated
    public IThoughtspotView getThoughtspotView() {
        return this.thoughtspotView;
    }

    @Override
    @Generated
    public String getThoughtspotViewQualifiedName() {
        return this.thoughtspotViewQualifiedName;
    }

    @Override
    @Generated
    public IThoughtspotWorksheet getThoughtspotWorksheet() {
        return this.thoughtspotWorksheet;
    }

    @Override
    @Generated
    public String getThoughtspotWorksheetQualifiedName() {
        return this.thoughtspotWorksheetQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThoughtspotColumn)) {
            return false;
        }
        ThoughtspotColumn other = (ThoughtspotColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$thoughtspotColumnCount = this.getThoughtspotColumnCount();
        Long other$thoughtspotColumnCount = other.getThoughtspotColumnCount();
        if (this$thoughtspotColumnCount == null ? other$thoughtspotColumnCount != null : !((Object)this$thoughtspotColumnCount).equals(other$thoughtspotColumnCount)) {
            return false;
        }
        Long this$thoughtspotJoinCount = this.getThoughtspotJoinCount();
        Long other$thoughtspotJoinCount = other.getThoughtspotJoinCount();
        if (this$thoughtspotJoinCount == null ? other$thoughtspotJoinCount != null : !((Object)this$thoughtspotJoinCount).equals(other$thoughtspotJoinCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$thoughtspotChartType = this.getThoughtspotChartType();
        String other$thoughtspotChartType = other.getThoughtspotChartType();
        if (this$thoughtspotChartType == null ? other$thoughtspotChartType != null : !this$thoughtspotChartType.equals(other$thoughtspotChartType)) {
            return false;
        }
        String this$thoughtspotColumnDataType = this.getThoughtspotColumnDataType();
        String other$thoughtspotColumnDataType = other.getThoughtspotColumnDataType();
        if (this$thoughtspotColumnDataType == null ? other$thoughtspotColumnDataType != null : !this$thoughtspotColumnDataType.equals(other$thoughtspotColumnDataType)) {
            return false;
        }
        String this$thoughtspotColumnType = this.getThoughtspotColumnType();
        String other$thoughtspotColumnType = other.getThoughtspotColumnType();
        if (this$thoughtspotColumnType == null ? other$thoughtspotColumnType != null : !this$thoughtspotColumnType.equals(other$thoughtspotColumnType)) {
            return false;
        }
        String this$thoughtspotQuestionText = this.getThoughtspotQuestionText();
        String other$thoughtspotQuestionText = other.getThoughtspotQuestionText();
        if (this$thoughtspotQuestionText == null ? other$thoughtspotQuestionText != null : !this$thoughtspotQuestionText.equals(other$thoughtspotQuestionText)) {
            return false;
        }
        IThoughtspotTable this$thoughtspotTable = this.getThoughtspotTable();
        IThoughtspotTable other$thoughtspotTable = other.getThoughtspotTable();
        if (this$thoughtspotTable == null ? other$thoughtspotTable != null : !this$thoughtspotTable.equals(other$thoughtspotTable)) {
            return false;
        }
        String this$thoughtspotTableQualifiedName = this.getThoughtspotTableQualifiedName();
        String other$thoughtspotTableQualifiedName = other.getThoughtspotTableQualifiedName();
        if (this$thoughtspotTableQualifiedName == null ? other$thoughtspotTableQualifiedName != null : !this$thoughtspotTableQualifiedName.equals(other$thoughtspotTableQualifiedName)) {
            return false;
        }
        IThoughtspotView this$thoughtspotView = this.getThoughtspotView();
        IThoughtspotView other$thoughtspotView = other.getThoughtspotView();
        if (this$thoughtspotView == null ? other$thoughtspotView != null : !this$thoughtspotView.equals(other$thoughtspotView)) {
            return false;
        }
        String this$thoughtspotViewQualifiedName = this.getThoughtspotViewQualifiedName();
        String other$thoughtspotViewQualifiedName = other.getThoughtspotViewQualifiedName();
        if (this$thoughtspotViewQualifiedName == null ? other$thoughtspotViewQualifiedName != null : !this$thoughtspotViewQualifiedName.equals(other$thoughtspotViewQualifiedName)) {
            return false;
        }
        IThoughtspotWorksheet this$thoughtspotWorksheet = this.getThoughtspotWorksheet();
        IThoughtspotWorksheet other$thoughtspotWorksheet = other.getThoughtspotWorksheet();
        if (this$thoughtspotWorksheet == null ? other$thoughtspotWorksheet != null : !this$thoughtspotWorksheet.equals(other$thoughtspotWorksheet)) {
            return false;
        }
        String this$thoughtspotWorksheetQualifiedName = this.getThoughtspotWorksheetQualifiedName();
        String other$thoughtspotWorksheetQualifiedName = other.getThoughtspotWorksheetQualifiedName();
        return !(this$thoughtspotWorksheetQualifiedName == null ? other$thoughtspotWorksheetQualifiedName != null : !this$thoughtspotWorksheetQualifiedName.equals(other$thoughtspotWorksheetQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ThoughtspotColumn;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $thoughtspotColumnCount = this.getThoughtspotColumnCount();
        result = result * 59 + ($thoughtspotColumnCount == null ? 43 : ((Object)$thoughtspotColumnCount).hashCode());
        Long $thoughtspotJoinCount = this.getThoughtspotJoinCount();
        result = result * 59 + ($thoughtspotJoinCount == null ? 43 : ((Object)$thoughtspotJoinCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $thoughtspotChartType = this.getThoughtspotChartType();
        result = result * 59 + ($thoughtspotChartType == null ? 43 : $thoughtspotChartType.hashCode());
        String $thoughtspotColumnDataType = this.getThoughtspotColumnDataType();
        result = result * 59 + ($thoughtspotColumnDataType == null ? 43 : $thoughtspotColumnDataType.hashCode());
        String $thoughtspotColumnType = this.getThoughtspotColumnType();
        result = result * 59 + ($thoughtspotColumnType == null ? 43 : $thoughtspotColumnType.hashCode());
        String $thoughtspotQuestionText = this.getThoughtspotQuestionText();
        result = result * 59 + ($thoughtspotQuestionText == null ? 43 : $thoughtspotQuestionText.hashCode());
        IThoughtspotTable $thoughtspotTable = this.getThoughtspotTable();
        result = result * 59 + ($thoughtspotTable == null ? 43 : $thoughtspotTable.hashCode());
        String $thoughtspotTableQualifiedName = this.getThoughtspotTableQualifiedName();
        result = result * 59 + ($thoughtspotTableQualifiedName == null ? 43 : $thoughtspotTableQualifiedName.hashCode());
        IThoughtspotView $thoughtspotView = this.getThoughtspotView();
        result = result * 59 + ($thoughtspotView == null ? 43 : $thoughtspotView.hashCode());
        String $thoughtspotViewQualifiedName = this.getThoughtspotViewQualifiedName();
        result = result * 59 + ($thoughtspotViewQualifiedName == null ? 43 : $thoughtspotViewQualifiedName.hashCode());
        IThoughtspotWorksheet $thoughtspotWorksheet = this.getThoughtspotWorksheet();
        result = result * 59 + ($thoughtspotWorksheet == null ? 43 : $thoughtspotWorksheet.hashCode());
        String $thoughtspotWorksheetQualifiedName = this.getThoughtspotWorksheetQualifiedName();
        result = result * 59 + ($thoughtspotWorksheetQualifiedName == null ? 43 : $thoughtspotWorksheetQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ThoughtspotColumn(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", thoughtspotChartType=" + this.getThoughtspotChartType() + ", thoughtspotColumnCount=" + this.getThoughtspotColumnCount() + ", thoughtspotColumnDataType=" + this.getThoughtspotColumnDataType() + ", thoughtspotColumnType=" + this.getThoughtspotColumnType() + ", thoughtspotJoinCount=" + this.getThoughtspotJoinCount() + ", thoughtspotQuestionText=" + this.getThoughtspotQuestionText() + ", thoughtspotTable=" + String.valueOf(this.getThoughtspotTable()) + ", thoughtspotTableQualifiedName=" + this.getThoughtspotTableQualifiedName() + ", thoughtspotView=" + String.valueOf(this.getThoughtspotView()) + ", thoughtspotViewQualifiedName=" + this.getThoughtspotViewQualifiedName() + ", thoughtspotWorksheet=" + String.valueOf(this.getThoughtspotWorksheet()) + ", thoughtspotWorksheetQualifiedName=" + this.getThoughtspotWorksheetQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class ThoughtspotColumnBuilder<C extends ThoughtspotColumn, B extends ThoughtspotColumnBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private String thoughtspotChartType;
        @Generated
        private Long thoughtspotColumnCount;
        @Generated
        private String thoughtspotColumnDataType;
        @Generated
        private String thoughtspotColumnType;
        @Generated
        private Long thoughtspotJoinCount;
        @Generated
        private String thoughtspotQuestionText;
        @Generated
        private IThoughtspotTable thoughtspotTable;
        @Generated
        private String thoughtspotTableQualifiedName;
        @Generated
        private IThoughtspotView thoughtspotView;
        @Generated
        private String thoughtspotViewQualifiedName;
        @Generated
        private IThoughtspotWorksheet thoughtspotWorksheet;
        @Generated
        private String thoughtspotWorksheetQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ThoughtspotColumnBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ThoughtspotColumn instance, ThoughtspotColumnBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.thoughtspotChartType(instance.thoughtspotChartType);
            b.thoughtspotColumnCount(instance.thoughtspotColumnCount);
            b.thoughtspotColumnDataType(instance.thoughtspotColumnDataType);
            b.thoughtspotColumnType(instance.thoughtspotColumnType);
            b.thoughtspotJoinCount(instance.thoughtspotJoinCount);
            b.thoughtspotQuestionText(instance.thoughtspotQuestionText);
            b.thoughtspotTable(instance.thoughtspotTable);
            b.thoughtspotTableQualifiedName(instance.thoughtspotTableQualifiedName);
            b.thoughtspotView(instance.thoughtspotView);
            b.thoughtspotViewQualifiedName(instance.thoughtspotViewQualifiedName);
            b.thoughtspotWorksheet(instance.thoughtspotWorksheet);
            b.thoughtspotWorksheetQualifiedName(instance.thoughtspotWorksheetQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B thoughtspotChartType(String thoughtspotChartType) {
            this.thoughtspotChartType = thoughtspotChartType;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotColumnCount(Long thoughtspotColumnCount) {
            this.thoughtspotColumnCount = thoughtspotColumnCount;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotColumnDataType(String thoughtspotColumnDataType) {
            this.thoughtspotColumnDataType = thoughtspotColumnDataType;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotColumnType(String thoughtspotColumnType) {
            this.thoughtspotColumnType = thoughtspotColumnType;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotJoinCount(Long thoughtspotJoinCount) {
            this.thoughtspotJoinCount = thoughtspotJoinCount;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotQuestionText(String thoughtspotQuestionText) {
            this.thoughtspotQuestionText = thoughtspotQuestionText;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotTable(IThoughtspotTable thoughtspotTable) {
            this.thoughtspotTable = thoughtspotTable;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotTableQualifiedName(String thoughtspotTableQualifiedName) {
            this.thoughtspotTableQualifiedName = thoughtspotTableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotView(IThoughtspotView thoughtspotView) {
            this.thoughtspotView = thoughtspotView;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotViewQualifiedName(String thoughtspotViewQualifiedName) {
            this.thoughtspotViewQualifiedName = thoughtspotViewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotWorksheet(IThoughtspotWorksheet thoughtspotWorksheet) {
            this.thoughtspotWorksheet = thoughtspotWorksheet;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotWorksheetQualifiedName(String thoughtspotWorksheetQualifiedName) {
            this.thoughtspotWorksheetQualifiedName = thoughtspotWorksheetQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ThoughtspotColumn.ThoughtspotColumnBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", thoughtspotChartType=" + this.thoughtspotChartType + ", thoughtspotColumnCount=" + this.thoughtspotColumnCount + ", thoughtspotColumnDataType=" + this.thoughtspotColumnDataType + ", thoughtspotColumnType=" + this.thoughtspotColumnType + ", thoughtspotJoinCount=" + this.thoughtspotJoinCount + ", thoughtspotQuestionText=" + this.thoughtspotQuestionText + ", thoughtspotTable=" + String.valueOf(this.thoughtspotTable) + ", thoughtspotTableQualifiedName=" + this.thoughtspotTableQualifiedName + ", thoughtspotView=" + String.valueOf(this.thoughtspotView) + ", thoughtspotViewQualifiedName=" + this.thoughtspotViewQualifiedName + ", thoughtspotWorksheet=" + String.valueOf(this.thoughtspotWorksheet) + ", thoughtspotWorksheetQualifiedName=" + this.thoughtspotWorksheetQualifiedName + ")";
        }
    }

    @Generated
    private static final class ThoughtspotColumnBuilderImpl
    extends ThoughtspotColumnBuilder<ThoughtspotColumn, ThoughtspotColumnBuilderImpl> {
        @Generated
        private ThoughtspotColumnBuilderImpl() {
        }

        @Override
        @Generated
        protected ThoughtspotColumnBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ThoughtspotColumn build() {
            return new ThoughtspotColumn(this);
        }
    }
}

