/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.contracts;

import com.atlan.model.contracts.DCS_V_0_0_2;
import com.atlan.model.contracts.DataContractStatus;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.serde.ReadableCustomMetadataDeserializer;
import com.atlan.serde.ReadableCustomMetadataSerializer;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="template_version")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DCS_V_0_0_2.class, name="0.0.2")})
public class DataContractSpec
extends AtlanObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataContractSpec.class);
    private static final long serialVersionUID = 2L;
    String kind;
    DataContractStatus status;
    @JsonProperty(value="template_version")
    String templateVersion;
    String dataset;
    String type;
    String description;
    String datasource;
    Owners owners;
    Certification certification;
    Announcement announcement;
    List<String> terms;
    List<DCTag> tags;
    @JsonProperty(value="custom_metadata")
    @JsonSerialize(using=ReadableCustomMetadataSerializer.class)
    @JsonDeserialize(using=ReadableCustomMetadataDeserializer.class)
    Map<String, CustomMetadataAttributes> customMetadataSets;
    List<DCColumn> columns;
    List<String> checks;
    @JsonAnySetter
    Map<String, Object> extraProperties;

    @JsonAnyGetter
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    public static DataContractSpec fromString(String spec) throws IOException {
        return (DataContractSpec)Serde.yamlMapper.readValue(spec, DataContractSpec.class);
    }

    @Override
    public String toString() {
        try {
            return Serde.yamlMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            log.error("Error translating DataContractSpec into string.", (Throwable)e);
            return "";
        }
    }

    @Generated
    private static String $default$kind() {
        return "DataContract";
    }

    @Generated
    protected DataContractSpec(DataContractSpecBuilder<?, ?> b) {
        super(b);
        Map<Object, Object> extraProperties;
        Map<Object, Object> customMetadataSets;
        this.kind = b.kind$set ? b.kind$value : DataContractSpec.$default$kind();
        this.status = b.status;
        this.templateVersion = b.templateVersion;
        this.dataset = b.dataset;
        this.type = b.type;
        this.description = b.description;
        this.datasource = b.datasource;
        this.owners = b.owners;
        this.certification = b.certification;
        this.announcement = b.announcement;
        this.terms = switch (b.terms == null ? 0 : b.terms.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.terms.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.terms));
        };
        this.tags = switch (b.tags == null ? 0 : b.tags.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.tags.get(0));
            default -> Collections.unmodifiableList(new ArrayList<DCTag>(b.tags));
        };
        switch (b.customMetadataSets$key == null ? 0 : b.customMetadataSets$key.size()) {
            case 0: {
                customMetadataSets = Collections.emptyMap();
                break;
            }
            case 1: {
                customMetadataSets = Collections.singletonMap(b.customMetadataSets$key.get(0), b.customMetadataSets$value.get(0));
                break;
            }
            default: {
                customMetadataSets = new LinkedHashMap(b.customMetadataSets$key.size() < 0x40000000 ? 1 + b.customMetadataSets$key.size() + (b.customMetadataSets$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.customMetadataSets$key.size(); ++$i) {
                    customMetadataSets.put(b.customMetadataSets$key.get($i), b.customMetadataSets$value.get($i));
                }
                customMetadataSets = Collections.unmodifiableMap(customMetadataSets);
            }
        }
        this.customMetadataSets = customMetadataSets;
        this.columns = switch (b.columns == null ? 0 : b.columns.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.columns.get(0));
            default -> Collections.unmodifiableList(new ArrayList<DCColumn>(b.columns));
        };
        this.checks = switch (b.checks == null ? 0 : b.checks.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.checks.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.checks));
        };
        switch (b.extraProperties$key == null ? 0 : b.extraProperties$key.size()) {
            case 0: {
                extraProperties = Collections.emptyMap();
                break;
            }
            case 1: {
                extraProperties = Collections.singletonMap(b.extraProperties$key.get(0), b.extraProperties$value.get(0));
                break;
            }
            default: {
                extraProperties = new LinkedHashMap(b.extraProperties$key.size() < 0x40000000 ? 1 + b.extraProperties$key.size() + (b.extraProperties$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.extraProperties$key.size(); ++$i) {
                    extraProperties.put(b.extraProperties$key.get($i), b.extraProperties$value.get($i));
                }
                extraProperties = Collections.unmodifiableMap(extraProperties);
            }
        }
        this.extraProperties = extraProperties;
    }

    @Generated
    public static DataContractSpecBuilder<?, ?> _internal() {
        return new DataContractSpecBuilderImpl();
    }

    @Generated
    public DataContractSpecBuilder<?, ?> toBuilder() {
        return new DataContractSpecBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getKind() {
        return this.kind;
    }

    @Generated
    public DataContractStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getTemplateVersion() {
        return this.templateVersion;
    }

    @Generated
    public String getDataset() {
        return this.dataset;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getDatasource() {
        return this.datasource;
    }

    @Generated
    public Owners getOwners() {
        return this.owners;
    }

    @Generated
    public Certification getCertification() {
        return this.certification;
    }

    @Generated
    public Announcement getAnnouncement() {
        return this.announcement;
    }

    @Generated
    public List<String> getTerms() {
        return this.terms;
    }

    @Generated
    public List<DCTag> getTags() {
        return this.tags;
    }

    @Generated
    public Map<String, CustomMetadataAttributes> getCustomMetadataSets() {
        return this.customMetadataSets;
    }

    @Generated
    public List<DCColumn> getColumns() {
        return this.columns;
    }

    @Generated
    public List<String> getChecks() {
        return this.checks;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataContractSpec)) {
            return false;
        }
        DataContractSpec other = (DataContractSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        DataContractStatus this$status = this.getStatus();
        DataContractStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$templateVersion = this.getTemplateVersion();
        String other$templateVersion = other.getTemplateVersion();
        if (this$templateVersion == null ? other$templateVersion != null : !this$templateVersion.equals(other$templateVersion)) {
            return false;
        }
        String this$dataset = this.getDataset();
        String other$dataset = other.getDataset();
        if (this$dataset == null ? other$dataset != null : !this$dataset.equals(other$dataset)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$datasource = this.getDatasource();
        String other$datasource = other.getDatasource();
        if (this$datasource == null ? other$datasource != null : !this$datasource.equals(other$datasource)) {
            return false;
        }
        Owners this$owners = this.getOwners();
        Owners other$owners = other.getOwners();
        if (this$owners == null ? other$owners != null : !((Object)this$owners).equals(other$owners)) {
            return false;
        }
        Certification this$certification = this.getCertification();
        Certification other$certification = other.getCertification();
        if (this$certification == null ? other$certification != null : !((Object)this$certification).equals(other$certification)) {
            return false;
        }
        Announcement this$announcement = this.getAnnouncement();
        Announcement other$announcement = other.getAnnouncement();
        if (this$announcement == null ? other$announcement != null : !((Object)this$announcement).equals(other$announcement)) {
            return false;
        }
        List<String> this$terms = this.getTerms();
        List<String> other$terms = other.getTerms();
        if (this$terms == null ? other$terms != null : !((Object)this$terms).equals(other$terms)) {
            return false;
        }
        List<DCTag> this$tags = this.getTags();
        List<DCTag> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Map<String, CustomMetadataAttributes> this$customMetadataSets = this.getCustomMetadataSets();
        Map<String, CustomMetadataAttributes> other$customMetadataSets = other.getCustomMetadataSets();
        if (this$customMetadataSets == null ? other$customMetadataSets != null : !((Object)this$customMetadataSets).equals(other$customMetadataSets)) {
            return false;
        }
        List<DCColumn> this$columns = this.getColumns();
        List<DCColumn> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        List<String> this$checks = this.getChecks();
        List<String> other$checks = other.getChecks();
        if (this$checks == null ? other$checks != null : !((Object)this$checks).equals(other$checks)) {
            return false;
        }
        Map<String, Object> this$extraProperties = this.getExtraProperties();
        Map<String, Object> other$extraProperties = other.getExtraProperties();
        return !(this$extraProperties == null ? other$extraProperties != null : !((Object)this$extraProperties).equals(other$extraProperties));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataContractSpec;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        DataContractStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $templateVersion = this.getTemplateVersion();
        result = result * 59 + ($templateVersion == null ? 43 : $templateVersion.hashCode());
        String $dataset = this.getDataset();
        result = result * 59 + ($dataset == null ? 43 : $dataset.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $datasource = this.getDatasource();
        result = result * 59 + ($datasource == null ? 43 : $datasource.hashCode());
        Owners $owners = this.getOwners();
        result = result * 59 + ($owners == null ? 43 : ((Object)$owners).hashCode());
        Certification $certification = this.getCertification();
        result = result * 59 + ($certification == null ? 43 : ((Object)$certification).hashCode());
        Announcement $announcement = this.getAnnouncement();
        result = result * 59 + ($announcement == null ? 43 : ((Object)$announcement).hashCode());
        List<String> $terms = this.getTerms();
        result = result * 59 + ($terms == null ? 43 : ((Object)$terms).hashCode());
        List<DCTag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Map<String, CustomMetadataAttributes> $customMetadataSets = this.getCustomMetadataSets();
        result = result * 59 + ($customMetadataSets == null ? 43 : ((Object)$customMetadataSets).hashCode());
        List<DCColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        List<String> $checks = this.getChecks();
        result = result * 59 + ($checks == null ? 43 : ((Object)$checks).hashCode());
        Map<String, Object> $extraProperties = this.getExtraProperties();
        result = result * 59 + ($extraProperties == null ? 43 : ((Object)$extraProperties).hashCode());
        return result;
    }

    @Generated
    public static abstract class DataContractSpecBuilder<C extends DataContractSpec, B extends DataContractSpecBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private boolean kind$set;
        @Generated
        private String kind$value;
        @Generated
        private DataContractStatus status;
        @Generated
        private String templateVersion;
        @Generated
        private String dataset;
        @Generated
        private String type;
        @Generated
        private String description;
        @Generated
        private String datasource;
        @Generated
        private Owners owners;
        @Generated
        private Certification certification;
        @Generated
        private Announcement announcement;
        @Generated
        private ArrayList<String> terms;
        @Generated
        private ArrayList<DCTag> tags;
        @Generated
        private ArrayList<String> customMetadataSets$key;
        @Generated
        private ArrayList<CustomMetadataAttributes> customMetadataSets$value;
        @Generated
        private ArrayList<DCColumn> columns;
        @Generated
        private ArrayList<String> checks;
        @Generated
        private ArrayList<String> extraProperties$key;
        @Generated
        private ArrayList<Object> extraProperties$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DataContractSpecBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DataContractSpec instance, DataContractSpecBuilder<?, ?> b) {
            b.kind(instance.kind);
            b.status(instance.status);
            b.templateVersion(instance.templateVersion);
            b.dataset(instance.dataset);
            b.type(instance.type);
            b.description(instance.description);
            b.datasource(instance.datasource);
            b.owners(instance.owners);
            b.certification(instance.certification);
            b.announcement(instance.announcement);
            b.terms(instance.terms == null ? Collections.emptyList() : instance.terms);
            b.tags(instance.tags == null ? Collections.emptyList() : instance.tags);
            b.customMetadataSets(instance.customMetadataSets == null ? Collections.emptyMap() : instance.customMetadataSets);
            b.columns(instance.columns == null ? Collections.emptyList() : instance.columns);
            b.checks(instance.checks == null ? Collections.emptyList() : instance.checks);
            b.extraProperties(instance.extraProperties == null ? Collections.emptyMap() : instance.extraProperties);
        }

        @Generated
        public B kind(String kind) {
            this.kind$value = kind;
            this.kind$set = true;
            return (B)this.self();
        }

        @Generated
        public B status(DataContractStatus status) {
            this.status = status;
            return (B)this.self();
        }

        @JsonProperty(value="template_version")
        @Generated
        public B templateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
            return (B)this.self();
        }

        @Generated
        public B dataset(String dataset) {
            this.dataset = dataset;
            return (B)this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return (B)this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return (B)this.self();
        }

        @Generated
        public B datasource(String datasource) {
            this.datasource = datasource;
            return (B)this.self();
        }

        @Generated
        public B owners(Owners owners) {
            this.owners = owners;
            return (B)this.self();
        }

        @Generated
        public B certification(Certification certification) {
            this.certification = certification;
            return (B)this.self();
        }

        @Generated
        public B announcement(Announcement announcement) {
            this.announcement = announcement;
            return (B)this.self();
        }

        @Generated
        public B term(String term) {
            if (this.terms == null) {
                this.terms = new ArrayList();
            }
            this.terms.add(term);
            return (B)this.self();
        }

        @Generated
        public B terms(Collection<? extends String> terms) {
            if (terms == null) {
                throw new NullPointerException("terms cannot be null");
            }
            if (this.terms == null) {
                this.terms = new ArrayList();
            }
            this.terms.addAll(terms);
            return (B)this.self();
        }

        @Generated
        public B clearTerms() {
            if (this.terms != null) {
                this.terms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tag(DCTag tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return (B)this.self();
        }

        @Generated
        public B tags(Collection<? extends DCTag> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return (B)this.self();
        }

        @Generated
        public B clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B customMetadataSet(String customMetadataSetKey, CustomMetadataAttributes customMetadataSetValue) {
            if (this.customMetadataSets$key == null) {
                this.customMetadataSets$key = new ArrayList();
                this.customMetadataSets$value = new ArrayList();
            }
            this.customMetadataSets$key.add(customMetadataSetKey);
            this.customMetadataSets$value.add(customMetadataSetValue);
            return (B)this.self();
        }

        @JsonProperty(value="custom_metadata")
        @JsonDeserialize(using=ReadableCustomMetadataDeserializer.class)
        @Generated
        public B customMetadataSets(Map<? extends String, ? extends CustomMetadataAttributes> customMetadataSets) {
            if (customMetadataSets == null) {
                throw new NullPointerException("customMetadataSets cannot be null");
            }
            if (this.customMetadataSets$key == null) {
                this.customMetadataSets$key = new ArrayList();
                this.customMetadataSets$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends CustomMetadataAttributes> $lombokEntry : customMetadataSets.entrySet()) {
                this.customMetadataSets$key.add($lombokEntry.getKey());
                this.customMetadataSets$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearCustomMetadataSets() {
            if (this.customMetadataSets$key != null) {
                this.customMetadataSets$key.clear();
                this.customMetadataSets$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B column(DCColumn column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return (B)this.self();
        }

        @Generated
        public B columns(Collection<? extends DCColumn> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return (B)this.self();
        }

        @Generated
        public B clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B check(String check) {
            if (this.checks == null) {
                this.checks = new ArrayList();
            }
            this.checks.add(check);
            return (B)this.self();
        }

        @Generated
        public B checks(Collection<? extends String> checks) {
            if (checks == null) {
                throw new NullPointerException("checks cannot be null");
            }
            if (this.checks == null) {
                this.checks = new ArrayList();
            }
            this.checks.addAll(checks);
            return (B)this.self();
        }

        @Generated
        public B clearChecks() {
            if (this.checks != null) {
                this.checks.clear();
            }
            return (B)this.self();
        }

        @JsonAnySetter
        @Generated
        public B extraProperty(String extraPropertyKey, Object extraPropertyValue) {
            if (this.extraProperties$key == null) {
                this.extraProperties$key = new ArrayList();
                this.extraProperties$value = new ArrayList();
            }
            this.extraProperties$key.add(extraPropertyKey);
            this.extraProperties$value.add(extraPropertyValue);
            return (B)this.self();
        }

        @Generated
        public B extraProperties(Map<? extends String, ? extends Object> extraProperties) {
            if (extraProperties == null) {
                throw new NullPointerException("extraProperties cannot be null");
            }
            if (this.extraProperties$key == null) {
                this.extraProperties$key = new ArrayList();
                this.extraProperties$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : extraProperties.entrySet()) {
                this.extraProperties$key.add($lombokEntry.getKey());
                this.extraProperties$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearExtraProperties() {
            if (this.extraProperties$key != null) {
                this.extraProperties$key.clear();
                this.extraProperties$value.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DataContractSpec.DataContractSpecBuilder(super=" + super.toString() + ", kind$value=" + this.kind$value + ", status=" + String.valueOf(this.status) + ", templateVersion=" + this.templateVersion + ", dataset=" + this.dataset + ", type=" + this.type + ", description=" + this.description + ", datasource=" + this.datasource + ", owners=" + String.valueOf(this.owners) + ", certification=" + String.valueOf(this.certification) + ", announcement=" + String.valueOf(this.announcement) + ", terms=" + String.valueOf(this.terms) + ", tags=" + String.valueOf(this.tags) + ", customMetadataSets$key=" + String.valueOf(this.customMetadataSets$key) + ", customMetadataSets$value=" + String.valueOf(this.customMetadataSets$value) + ", columns=" + String.valueOf(this.columns) + ", checks=" + String.valueOf(this.checks) + ", extraProperties$key=" + String.valueOf(this.extraProperties$key) + ", extraProperties$value=" + String.valueOf(this.extraProperties$value) + ")";
        }
    }

    @JsonDeserialize(builder=OwnersBuilderImpl.class)
    public static final class Owners {
        List<String> users;
        List<String> groups;

        @Generated
        protected Owners(OwnersBuilder<?, ?> b) {
            this.users = switch (b.users == null ? 0 : b.users.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(b.users.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(b.users));
            };
            this.groups = switch (b.groups == null ? 0 : b.groups.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(b.groups.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(b.groups));
            };
        }

        @Generated
        public static OwnersBuilder<?, ?> builder() {
            return new OwnersBuilderImpl();
        }

        @Generated
        public OwnersBuilder<?, ?> toBuilder() {
            return new OwnersBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public List<String> getUsers() {
            return this.users;
        }

        @Generated
        public List<String> getGroups() {
            return this.groups;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Owners)) {
                return false;
            }
            Owners other = (Owners)o;
            List<String> this$users = this.getUsers();
            List<String> other$users = other.getUsers();
            if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
                return false;
            }
            List<String> this$groups = this.getGroups();
            List<String> other$groups = other.getGroups();
            return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $users = this.getUsers();
            result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
            List<String> $groups = this.getGroups();
            result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
            return result;
        }

        @Generated
        public static abstract class OwnersBuilder<C extends Owners, B extends OwnersBuilder<C, B>> {
            @Generated
            private ArrayList<String> users;
            @Generated
            private ArrayList<String> groups;

            @Generated
            protected B $fillValuesFrom(C instance) {
                OwnersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(Owners instance, OwnersBuilder<?, ?> b) {
                b.users(instance.users == null ? Collections.emptyList() : instance.users);
                b.groups(instance.groups == null ? Collections.emptyList() : instance.groups);
            }

            @Generated
            public B user(String user) {
                if (this.users == null) {
                    this.users = new ArrayList();
                }
                this.users.add(user);
                return this.self();
            }

            @Generated
            public B users(Collection<? extends String> users) {
                if (users == null) {
                    throw new NullPointerException("users cannot be null");
                }
                if (this.users == null) {
                    this.users = new ArrayList();
                }
                this.users.addAll(users);
                return this.self();
            }

            @Generated
            public B clearUsers() {
                if (this.users != null) {
                    this.users.clear();
                }
                return this.self();
            }

            @Generated
            public B group(String group) {
                if (this.groups == null) {
                    this.groups = new ArrayList();
                }
                this.groups.add(group);
                return this.self();
            }

            @Generated
            public B groups(Collection<? extends String> groups) {
                if (groups == null) {
                    throw new NullPointerException("groups cannot be null");
                }
                if (this.groups == null) {
                    this.groups = new ArrayList();
                }
                this.groups.addAll(groups);
                return this.self();
            }

            @Generated
            public B clearGroups() {
                if (this.groups != null) {
                    this.groups.clear();
                }
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "DataContractSpec.Owners.OwnersBuilder(users=" + String.valueOf(this.users) + ", groups=" + String.valueOf(this.groups) + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class OwnersBuilderImpl
        extends OwnersBuilder<Owners, OwnersBuilderImpl> {
            @Generated
            private OwnersBuilderImpl() {
            }

            @Override
            @Generated
            protected OwnersBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Owners build() {
                return new Owners(this);
            }
        }
    }

    @JsonDeserialize(builder=CertificationBuilderImpl.class)
    public static final class Certification {
        CertificateStatus status;
        String message;

        @Generated
        protected Certification(CertificationBuilder<?, ?> b) {
            this.status = b.status;
            this.message = b.message;
        }

        @Generated
        public static CertificationBuilder<?, ?> builder() {
            return new CertificationBuilderImpl();
        }

        @Generated
        public CertificationBuilder<?, ?> toBuilder() {
            return new CertificationBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public CertificateStatus getStatus() {
            return this.status;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Certification)) {
                return false;
            }
            Certification other = (Certification)o;
            CertificateStatus this$status = this.getStatus();
            CertificateStatus other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CertificateStatus $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public static abstract class CertificationBuilder<C extends Certification, B extends CertificationBuilder<C, B>> {
            @Generated
            private CertificateStatus status;
            @Generated
            private String message;

            @Generated
            protected B $fillValuesFrom(C instance) {
                CertificationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(Certification instance, CertificationBuilder<?, ?> b) {
                b.status(instance.status);
                b.message(instance.message);
            }

            @Generated
            public B status(CertificateStatus status) {
                this.status = status;
                return this.self();
            }

            @Generated
            public B message(String message) {
                this.message = message;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "DataContractSpec.Certification.CertificationBuilder(status=" + String.valueOf(this.status) + ", message=" + this.message + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class CertificationBuilderImpl
        extends CertificationBuilder<Certification, CertificationBuilderImpl> {
            @Generated
            private CertificationBuilderImpl() {
            }

            @Override
            @Generated
            protected CertificationBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Certification build() {
                return new Certification(this);
            }
        }
    }

    @JsonDeserialize(builder=AnnouncementBuilderImpl.class)
    public static final class Announcement {
        AtlanAnnouncementType type;
        String title;
        String description;

        @Generated
        protected Announcement(AnnouncementBuilder<?, ?> b) {
            this.type = b.type;
            this.title = b.title;
            this.description = b.description;
        }

        @Generated
        public static AnnouncementBuilder<?, ?> builder() {
            return new AnnouncementBuilderImpl();
        }

        @Generated
        public AnnouncementBuilder<?, ?> toBuilder() {
            return new AnnouncementBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public AtlanAnnouncementType getType() {
            return this.type;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Announcement)) {
                return false;
            }
            Announcement other = (Announcement)o;
            AtlanAnnouncementType this$type = this.getType();
            AtlanAnnouncementType other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AtlanAnnouncementType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public static abstract class AnnouncementBuilder<C extends Announcement, B extends AnnouncementBuilder<C, B>> {
            @Generated
            private AtlanAnnouncementType type;
            @Generated
            private String title;
            @Generated
            private String description;

            @Generated
            protected B $fillValuesFrom(C instance) {
                AnnouncementBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(Announcement instance, AnnouncementBuilder<?, ?> b) {
                b.type(instance.type);
                b.title(instance.title);
                b.description(instance.description);
            }

            @Generated
            public B type(AtlanAnnouncementType type) {
                this.type = type;
                return this.self();
            }

            @Generated
            public B title(String title) {
                this.title = title;
                return this.self();
            }

            @Generated
            public B description(String description) {
                this.description = description;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "DataContractSpec.Announcement.AnnouncementBuilder(type=" + String.valueOf(this.type) + ", title=" + this.title + ", description=" + this.description + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class AnnouncementBuilderImpl
        extends AnnouncementBuilder<Announcement, AnnouncementBuilderImpl> {
            @Generated
            private AnnouncementBuilderImpl() {
            }

            @Override
            @Generated
            protected AnnouncementBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Announcement build() {
                return new Announcement(this);
            }
        }
    }

    @JsonDeserialize(builder=DCTagBuilderImpl.class)
    public static final class DCTag {
        String name;
        Boolean propagate;
        @JsonProperty(value="restrict_propagation_through_lineage")
        Boolean propagateThroughLineage;
        @JsonProperty(value="restrict_propagation_through_hierarchy")
        Boolean propagateThroughHierarchy;

        @Generated
        protected DCTag(DCTagBuilder<?, ?> b) {
            this.name = b.name;
            this.propagate = b.propagate;
            this.propagateThroughLineage = b.propagateThroughLineage;
            this.propagateThroughHierarchy = b.propagateThroughHierarchy;
        }

        @Generated
        public static DCTagBuilder<?, ?> builder() {
            return new DCTagBuilderImpl();
        }

        @Generated
        public DCTagBuilder<?, ?> toBuilder() {
            return new DCTagBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Boolean getPropagate() {
            return this.propagate;
        }

        @Generated
        public Boolean getPropagateThroughLineage() {
            return this.propagateThroughLineage;
        }

        @Generated
        public Boolean getPropagateThroughHierarchy() {
            return this.propagateThroughHierarchy;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DCTag)) {
                return false;
            }
            DCTag other = (DCTag)o;
            Boolean this$propagate = this.getPropagate();
            Boolean other$propagate = other.getPropagate();
            if (this$propagate == null ? other$propagate != null : !((Object)this$propagate).equals(other$propagate)) {
                return false;
            }
            Boolean this$propagateThroughLineage = this.getPropagateThroughLineage();
            Boolean other$propagateThroughLineage = other.getPropagateThroughLineage();
            if (this$propagateThroughLineage == null ? other$propagateThroughLineage != null : !((Object)this$propagateThroughLineage).equals(other$propagateThroughLineage)) {
                return false;
            }
            Boolean this$propagateThroughHierarchy = this.getPropagateThroughHierarchy();
            Boolean other$propagateThroughHierarchy = other.getPropagateThroughHierarchy();
            if (this$propagateThroughHierarchy == null ? other$propagateThroughHierarchy != null : !((Object)this$propagateThroughHierarchy).equals(other$propagateThroughHierarchy)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $propagate = this.getPropagate();
            result = result * 59 + ($propagate == null ? 43 : ((Object)$propagate).hashCode());
            Boolean $propagateThroughLineage = this.getPropagateThroughLineage();
            result = result * 59 + ($propagateThroughLineage == null ? 43 : ((Object)$propagateThroughLineage).hashCode());
            Boolean $propagateThroughHierarchy = this.getPropagateThroughHierarchy();
            result = result * 59 + ($propagateThroughHierarchy == null ? 43 : ((Object)$propagateThroughHierarchy).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public static abstract class DCTagBuilder<C extends DCTag, B extends DCTagBuilder<C, B>> {
            @Generated
            private String name;
            @Generated
            private Boolean propagate;
            @Generated
            private Boolean propagateThroughLineage;
            @Generated
            private Boolean propagateThroughHierarchy;

            @Generated
            protected B $fillValuesFrom(C instance) {
                DCTagBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(DCTag instance, DCTagBuilder<?, ?> b) {
                b.name(instance.name);
                b.propagate(instance.propagate);
                b.propagateThroughLineage(instance.propagateThroughLineage);
                b.propagateThroughHierarchy(instance.propagateThroughHierarchy);
            }

            @Generated
            public B name(String name) {
                this.name = name;
                return this.self();
            }

            @Generated
            public B propagate(Boolean propagate) {
                this.propagate = propagate;
                return this.self();
            }

            @JsonProperty(value="restrict_propagation_through_lineage")
            @Generated
            public B propagateThroughLineage(Boolean propagateThroughLineage) {
                this.propagateThroughLineage = propagateThroughLineage;
                return this.self();
            }

            @JsonProperty(value="restrict_propagation_through_hierarchy")
            @Generated
            public B propagateThroughHierarchy(Boolean propagateThroughHierarchy) {
                this.propagateThroughHierarchy = propagateThroughHierarchy;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "DataContractSpec.DCTag.DCTagBuilder(name=" + this.name + ", propagate=" + this.propagate + ", propagateThroughLineage=" + this.propagateThroughLineage + ", propagateThroughHierarchy=" + this.propagateThroughHierarchy + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class DCTagBuilderImpl
        extends DCTagBuilder<DCTag, DCTagBuilderImpl> {
            @Generated
            private DCTagBuilderImpl() {
            }

            @Override
            @Generated
            protected DCTagBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DCTag build() {
                return new DCTag(this);
            }
        }
    }

    @JsonDeserialize(builder=DCColumnBuilderImpl.class)
    public static final class DCColumn {
        String name;
        @JsonProperty(value="business_name")
        String displayName;
        String description;
        @JsonProperty(value="is_primary")
        Boolean isPrimary;
        @JsonProperty(value="data_type")
        String dataType;
        @JsonProperty(value="logical_type")
        String logicalType;
        @JsonProperty(value="invalid_format")
        String invalidFormat;
        @JsonProperty(value="valid_format")
        String validFormat;
        @JsonProperty(value="invalid_regex")
        String invalidRegex;
        @JsonProperty(value="valid_regex")
        String validRegex;
        @JsonProperty(value="missing_regex")
        String missingRegex;
        @JsonProperty(value="invalid_values")
        List<String> invalidValues;
        @JsonProperty(value="valid_values")
        List<String> validValues;
        @JsonProperty(value="missing_values")
        List<String> missingValues;
        @JsonProperty(value="not_null")
        Boolean notNull;
        @JsonProperty(value="valid_length")
        Long validLength;
        @JsonProperty(value="valid_max_length")
        Long validMaxLength;
        @JsonProperty(value="valid_min")
        Double validMin;
        @JsonProperty(value="valid_max")
        Double validMax;
        @JsonProperty(value="valid_min_length")
        Long validMinLength;
        Boolean unique;

        @Generated
        protected DCColumn(DCColumnBuilder<?, ?> b) {
            this.name = b.name;
            this.displayName = b.displayName;
            this.description = b.description;
            this.isPrimary = b.isPrimary;
            this.dataType = b.dataType;
            this.logicalType = b.logicalType;
            this.invalidFormat = b.invalidFormat;
            this.validFormat = b.validFormat;
            this.invalidRegex = b.invalidRegex;
            this.validRegex = b.validRegex;
            this.missingRegex = b.missingRegex;
            this.invalidValues = switch (b.invalidValues == null ? 0 : b.invalidValues.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(b.invalidValues.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(b.invalidValues));
            };
            this.validValues = switch (b.validValues == null ? 0 : b.validValues.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(b.validValues.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(b.validValues));
            };
            this.missingValues = switch (b.missingValues == null ? 0 : b.missingValues.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(b.missingValues.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(b.missingValues));
            };
            this.notNull = b.notNull;
            this.validLength = b.validLength;
            this.validMaxLength = b.validMaxLength;
            this.validMin = b.validMin;
            this.validMax = b.validMax;
            this.validMinLength = b.validMinLength;
            this.unique = b.unique;
        }

        @Generated
        public static DCColumnBuilder<?, ?> builder() {
            return new DCColumnBuilderImpl();
        }

        @Generated
        public DCColumnBuilder<?, ?> toBuilder() {
            return new DCColumnBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Boolean getIsPrimary() {
            return this.isPrimary;
        }

        @Generated
        public String getDataType() {
            return this.dataType;
        }

        @Generated
        public String getLogicalType() {
            return this.logicalType;
        }

        @Generated
        public String getInvalidFormat() {
            return this.invalidFormat;
        }

        @Generated
        public String getValidFormat() {
            return this.validFormat;
        }

        @Generated
        public String getInvalidRegex() {
            return this.invalidRegex;
        }

        @Generated
        public String getValidRegex() {
            return this.validRegex;
        }

        @Generated
        public String getMissingRegex() {
            return this.missingRegex;
        }

        @Generated
        public List<String> getInvalidValues() {
            return this.invalidValues;
        }

        @Generated
        public List<String> getValidValues() {
            return this.validValues;
        }

        @Generated
        public List<String> getMissingValues() {
            return this.missingValues;
        }

        @Generated
        public Boolean getNotNull() {
            return this.notNull;
        }

        @Generated
        public Long getValidLength() {
            return this.validLength;
        }

        @Generated
        public Long getValidMaxLength() {
            return this.validMaxLength;
        }

        @Generated
        public Double getValidMin() {
            return this.validMin;
        }

        @Generated
        public Double getValidMax() {
            return this.validMax;
        }

        @Generated
        public Long getValidMinLength() {
            return this.validMinLength;
        }

        @Generated
        public Boolean getUnique() {
            return this.unique;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DCColumn)) {
                return false;
            }
            DCColumn other = (DCColumn)o;
            Boolean this$isPrimary = this.getIsPrimary();
            Boolean other$isPrimary = other.getIsPrimary();
            if (this$isPrimary == null ? other$isPrimary != null : !((Object)this$isPrimary).equals(other$isPrimary)) {
                return false;
            }
            Boolean this$notNull = this.getNotNull();
            Boolean other$notNull = other.getNotNull();
            if (this$notNull == null ? other$notNull != null : !((Object)this$notNull).equals(other$notNull)) {
                return false;
            }
            Long this$validLength = this.getValidLength();
            Long other$validLength = other.getValidLength();
            if (this$validLength == null ? other$validLength != null : !((Object)this$validLength).equals(other$validLength)) {
                return false;
            }
            Long this$validMaxLength = this.getValidMaxLength();
            Long other$validMaxLength = other.getValidMaxLength();
            if (this$validMaxLength == null ? other$validMaxLength != null : !((Object)this$validMaxLength).equals(other$validMaxLength)) {
                return false;
            }
            Double this$validMin = this.getValidMin();
            Double other$validMin = other.getValidMin();
            if (this$validMin == null ? other$validMin != null : !((Object)this$validMin).equals(other$validMin)) {
                return false;
            }
            Double this$validMax = this.getValidMax();
            Double other$validMax = other.getValidMax();
            if (this$validMax == null ? other$validMax != null : !((Object)this$validMax).equals(other$validMax)) {
                return false;
            }
            Long this$validMinLength = this.getValidMinLength();
            Long other$validMinLength = other.getValidMinLength();
            if (this$validMinLength == null ? other$validMinLength != null : !((Object)this$validMinLength).equals(other$validMinLength)) {
                return false;
            }
            Boolean this$unique = this.getUnique();
            Boolean other$unique = other.getUnique();
            if (this$unique == null ? other$unique != null : !((Object)this$unique).equals(other$unique)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$dataType = this.getDataType();
            String other$dataType = other.getDataType();
            if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
                return false;
            }
            String this$logicalType = this.getLogicalType();
            String other$logicalType = other.getLogicalType();
            if (this$logicalType == null ? other$logicalType != null : !this$logicalType.equals(other$logicalType)) {
                return false;
            }
            String this$invalidFormat = this.getInvalidFormat();
            String other$invalidFormat = other.getInvalidFormat();
            if (this$invalidFormat == null ? other$invalidFormat != null : !this$invalidFormat.equals(other$invalidFormat)) {
                return false;
            }
            String this$validFormat = this.getValidFormat();
            String other$validFormat = other.getValidFormat();
            if (this$validFormat == null ? other$validFormat != null : !this$validFormat.equals(other$validFormat)) {
                return false;
            }
            String this$invalidRegex = this.getInvalidRegex();
            String other$invalidRegex = other.getInvalidRegex();
            if (this$invalidRegex == null ? other$invalidRegex != null : !this$invalidRegex.equals(other$invalidRegex)) {
                return false;
            }
            String this$validRegex = this.getValidRegex();
            String other$validRegex = other.getValidRegex();
            if (this$validRegex == null ? other$validRegex != null : !this$validRegex.equals(other$validRegex)) {
                return false;
            }
            String this$missingRegex = this.getMissingRegex();
            String other$missingRegex = other.getMissingRegex();
            if (this$missingRegex == null ? other$missingRegex != null : !this$missingRegex.equals(other$missingRegex)) {
                return false;
            }
            List<String> this$invalidValues = this.getInvalidValues();
            List<String> other$invalidValues = other.getInvalidValues();
            if (this$invalidValues == null ? other$invalidValues != null : !((Object)this$invalidValues).equals(other$invalidValues)) {
                return false;
            }
            List<String> this$validValues = this.getValidValues();
            List<String> other$validValues = other.getValidValues();
            if (this$validValues == null ? other$validValues != null : !((Object)this$validValues).equals(other$validValues)) {
                return false;
            }
            List<String> this$missingValues = this.getMissingValues();
            List<String> other$missingValues = other.getMissingValues();
            return !(this$missingValues == null ? other$missingValues != null : !((Object)this$missingValues).equals(other$missingValues));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isPrimary = this.getIsPrimary();
            result = result * 59 + ($isPrimary == null ? 43 : ((Object)$isPrimary).hashCode());
            Boolean $notNull = this.getNotNull();
            result = result * 59 + ($notNull == null ? 43 : ((Object)$notNull).hashCode());
            Long $validLength = this.getValidLength();
            result = result * 59 + ($validLength == null ? 43 : ((Object)$validLength).hashCode());
            Long $validMaxLength = this.getValidMaxLength();
            result = result * 59 + ($validMaxLength == null ? 43 : ((Object)$validMaxLength).hashCode());
            Double $validMin = this.getValidMin();
            result = result * 59 + ($validMin == null ? 43 : ((Object)$validMin).hashCode());
            Double $validMax = this.getValidMax();
            result = result * 59 + ($validMax == null ? 43 : ((Object)$validMax).hashCode());
            Long $validMinLength = this.getValidMinLength();
            result = result * 59 + ($validMinLength == null ? 43 : ((Object)$validMinLength).hashCode());
            Boolean $unique = this.getUnique();
            result = result * 59 + ($unique == null ? 43 : ((Object)$unique).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $dataType = this.getDataType();
            result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
            String $logicalType = this.getLogicalType();
            result = result * 59 + ($logicalType == null ? 43 : $logicalType.hashCode());
            String $invalidFormat = this.getInvalidFormat();
            result = result * 59 + ($invalidFormat == null ? 43 : $invalidFormat.hashCode());
            String $validFormat = this.getValidFormat();
            result = result * 59 + ($validFormat == null ? 43 : $validFormat.hashCode());
            String $invalidRegex = this.getInvalidRegex();
            result = result * 59 + ($invalidRegex == null ? 43 : $invalidRegex.hashCode());
            String $validRegex = this.getValidRegex();
            result = result * 59 + ($validRegex == null ? 43 : $validRegex.hashCode());
            String $missingRegex = this.getMissingRegex();
            result = result * 59 + ($missingRegex == null ? 43 : $missingRegex.hashCode());
            List<String> $invalidValues = this.getInvalidValues();
            result = result * 59 + ($invalidValues == null ? 43 : ((Object)$invalidValues).hashCode());
            List<String> $validValues = this.getValidValues();
            result = result * 59 + ($validValues == null ? 43 : ((Object)$validValues).hashCode());
            List<String> $missingValues = this.getMissingValues();
            result = result * 59 + ($missingValues == null ? 43 : ((Object)$missingValues).hashCode());
            return result;
        }

        @Generated
        public static abstract class DCColumnBuilder<C extends DCColumn, B extends DCColumnBuilder<C, B>> {
            @Generated
            private String name;
            @Generated
            private String displayName;
            @Generated
            private String description;
            @Generated
            private Boolean isPrimary;
            @Generated
            private String dataType;
            @Generated
            private String logicalType;
            @Generated
            private String invalidFormat;
            @Generated
            private String validFormat;
            @Generated
            private String invalidRegex;
            @Generated
            private String validRegex;
            @Generated
            private String missingRegex;
            @Generated
            private ArrayList<String> invalidValues;
            @Generated
            private ArrayList<String> validValues;
            @Generated
            private ArrayList<String> missingValues;
            @Generated
            private Boolean notNull;
            @Generated
            private Long validLength;
            @Generated
            private Long validMaxLength;
            @Generated
            private Double validMin;
            @Generated
            private Double validMax;
            @Generated
            private Long validMinLength;
            @Generated
            private Boolean unique;

            @Generated
            protected B $fillValuesFrom(C instance) {
                DCColumnBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(DCColumn instance, DCColumnBuilder<?, ?> b) {
                b.name(instance.name);
                b.displayName(instance.displayName);
                b.description(instance.description);
                b.isPrimary(instance.isPrimary);
                b.dataType(instance.dataType);
                b.logicalType(instance.logicalType);
                b.invalidFormat(instance.invalidFormat);
                b.validFormat(instance.validFormat);
                b.invalidRegex(instance.invalidRegex);
                b.validRegex(instance.validRegex);
                b.missingRegex(instance.missingRegex);
                b.invalidValues(instance.invalidValues == null ? Collections.emptyList() : instance.invalidValues);
                b.validValues(instance.validValues == null ? Collections.emptyList() : instance.validValues);
                b.missingValues(instance.missingValues == null ? Collections.emptyList() : instance.missingValues);
                b.notNull(instance.notNull);
                b.validLength(instance.validLength);
                b.validMaxLength(instance.validMaxLength);
                b.validMin(instance.validMin);
                b.validMax(instance.validMax);
                b.validMinLength(instance.validMinLength);
                b.unique(instance.unique);
            }

            @Generated
            public B name(String name) {
                this.name = name;
                return this.self();
            }

            @JsonProperty(value="business_name")
            @Generated
            public B displayName(String displayName) {
                this.displayName = displayName;
                return this.self();
            }

            @Generated
            public B description(String description) {
                this.description = description;
                return this.self();
            }

            @JsonProperty(value="is_primary")
            @Generated
            public B isPrimary(Boolean isPrimary) {
                this.isPrimary = isPrimary;
                return this.self();
            }

            @JsonProperty(value="data_type")
            @Generated
            public B dataType(String dataType) {
                this.dataType = dataType;
                return this.self();
            }

            @JsonProperty(value="logical_type")
            @Generated
            public B logicalType(String logicalType) {
                this.logicalType = logicalType;
                return this.self();
            }

            @JsonProperty(value="invalid_format")
            @Generated
            public B invalidFormat(String invalidFormat) {
                this.invalidFormat = invalidFormat;
                return this.self();
            }

            @JsonProperty(value="valid_format")
            @Generated
            public B validFormat(String validFormat) {
                this.validFormat = validFormat;
                return this.self();
            }

            @JsonProperty(value="invalid_regex")
            @Generated
            public B invalidRegex(String invalidRegex) {
                this.invalidRegex = invalidRegex;
                return this.self();
            }

            @JsonProperty(value="valid_regex")
            @Generated
            public B validRegex(String validRegex) {
                this.validRegex = validRegex;
                return this.self();
            }

            @JsonProperty(value="missing_regex")
            @Generated
            public B missingRegex(String missingRegex) {
                this.missingRegex = missingRegex;
                return this.self();
            }

            @Generated
            public B invalidValue(String invalidValue) {
                if (this.invalidValues == null) {
                    this.invalidValues = new ArrayList();
                }
                this.invalidValues.add(invalidValue);
                return this.self();
            }

            @JsonProperty(value="invalid_values")
            @Generated
            public B invalidValues(Collection<? extends String> invalidValues) {
                if (invalidValues == null) {
                    throw new NullPointerException("invalidValues cannot be null");
                }
                if (this.invalidValues == null) {
                    this.invalidValues = new ArrayList();
                }
                this.invalidValues.addAll(invalidValues);
                return this.self();
            }

            @Generated
            public B clearInvalidValues() {
                if (this.invalidValues != null) {
                    this.invalidValues.clear();
                }
                return this.self();
            }

            @Generated
            public B validValue(String validValue) {
                if (this.validValues == null) {
                    this.validValues = new ArrayList();
                }
                this.validValues.add(validValue);
                return this.self();
            }

            @JsonProperty(value="valid_values")
            @Generated
            public B validValues(Collection<? extends String> validValues) {
                if (validValues == null) {
                    throw new NullPointerException("validValues cannot be null");
                }
                if (this.validValues == null) {
                    this.validValues = new ArrayList();
                }
                this.validValues.addAll(validValues);
                return this.self();
            }

            @Generated
            public B clearValidValues() {
                if (this.validValues != null) {
                    this.validValues.clear();
                }
                return this.self();
            }

            @Generated
            public B missingValue(String missingValue) {
                if (this.missingValues == null) {
                    this.missingValues = new ArrayList();
                }
                this.missingValues.add(missingValue);
                return this.self();
            }

            @JsonProperty(value="missing_values")
            @Generated
            public B missingValues(Collection<? extends String> missingValues) {
                if (missingValues == null) {
                    throw new NullPointerException("missingValues cannot be null");
                }
                if (this.missingValues == null) {
                    this.missingValues = new ArrayList();
                }
                this.missingValues.addAll(missingValues);
                return this.self();
            }

            @Generated
            public B clearMissingValues() {
                if (this.missingValues != null) {
                    this.missingValues.clear();
                }
                return this.self();
            }

            @JsonProperty(value="not_null")
            @Generated
            public B notNull(Boolean notNull) {
                this.notNull = notNull;
                return this.self();
            }

            @JsonProperty(value="valid_length")
            @Generated
            public B validLength(Long validLength) {
                this.validLength = validLength;
                return this.self();
            }

            @JsonProperty(value="valid_max_length")
            @Generated
            public B validMaxLength(Long validMaxLength) {
                this.validMaxLength = validMaxLength;
                return this.self();
            }

            @JsonProperty(value="valid_min")
            @Generated
            public B validMin(Double validMin) {
                this.validMin = validMin;
                return this.self();
            }

            @JsonProperty(value="valid_max")
            @Generated
            public B validMax(Double validMax) {
                this.validMax = validMax;
                return this.self();
            }

            @JsonProperty(value="valid_min_length")
            @Generated
            public B validMinLength(Long validMinLength) {
                this.validMinLength = validMinLength;
                return this.self();
            }

            @Generated
            public B unique(Boolean unique) {
                this.unique = unique;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "DataContractSpec.DCColumn.DCColumnBuilder(name=" + this.name + ", displayName=" + this.displayName + ", description=" + this.description + ", isPrimary=" + this.isPrimary + ", dataType=" + this.dataType + ", logicalType=" + this.logicalType + ", invalidFormat=" + this.invalidFormat + ", validFormat=" + this.validFormat + ", invalidRegex=" + this.invalidRegex + ", validRegex=" + this.validRegex + ", missingRegex=" + this.missingRegex + ", invalidValues=" + String.valueOf(this.invalidValues) + ", validValues=" + String.valueOf(this.validValues) + ", missingValues=" + String.valueOf(this.missingValues) + ", notNull=" + this.notNull + ", validLength=" + this.validLength + ", validMaxLength=" + this.validMaxLength + ", validMin=" + this.validMin + ", validMax=" + this.validMax + ", validMinLength=" + this.validMinLength + ", unique=" + this.unique + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class DCColumnBuilderImpl
        extends DCColumnBuilder<DCColumn, DCColumnBuilderImpl> {
            @Generated
            private DCColumnBuilderImpl() {
            }

            @Override
            @Generated
            protected DCColumnBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DCColumn build() {
                return new DCColumn(this);
            }
        }
    }

    @Generated
    private static final class DataContractSpecBuilderImpl
    extends DataContractSpecBuilder<DataContractSpec, DataContractSpecBuilderImpl> {
        @Generated
        private DataContractSpecBuilderImpl() {
        }

        @Override
        @Generated
        protected DataContractSpecBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DataContractSpec build() {
            return new DataContractSpec(this);
        }
    }
}

