/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.discovery;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AtlanGroup;
import com.atlan.model.admin.AtlanUser;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.discovery.DiscoveryFilter;
import com.atlan.model.discovery.TagFilter;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.serde.Removable;
import com.atlan.serde.Serde;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkableQuery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LinkableQuery.class);
    private AtlanClient client;
    private List<CertificateStatus> certificateStatuses;
    private AssetHierarchy hierarchy;
    private Owners owners;
    private List<DiscoveryFilter> properties;
    private List<TagFilter> tags;
    private Terms terms;
    private List<String> typeNames;

    public static LinkableQueryBuilder<?, ?> builder(AtlanClient client) {
        return LinkableQuery._internal().client(client);
    }

    public String toString() {
        FilterParams fp = new FilterParams(this);
        try {
            return Serde.allInclusiveMapper.writeValueAsString((Object)fp);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to convert parameters to a linkable query.", (Throwable)e);
            return "";
        }
    }

    public String getUrl() {
        String params = this.toString();
        String encoded = StringUtils.encodeContent(StringUtils.encodeContent(params));
        return "/assets?searchAndFilterCriteria=" + encoded;
    }

    public String getFullUrl() {
        return this.client.getBaseUrl() + this.getUrl();
    }

    @Generated
    protected LinkableQuery(LinkableQueryBuilder<?, ?> b) {
        this.client = b.client;
        this.certificateStatuses = switch (b.certificateStatuses == null ? 0 : b.certificateStatuses.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.certificateStatuses.get(0));
            default -> Collections.unmodifiableList(new ArrayList<CertificateStatus>(b.certificateStatuses));
        };
        this.hierarchy = b.hierarchy;
        this.owners = b.owners;
        this.properties = switch (b.properties == null ? 0 : b.properties.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.properties.get(0));
            default -> Collections.unmodifiableList(new ArrayList<DiscoveryFilter>(b.properties));
        };
        this.tags = switch (b.tags == null ? 0 : b.tags.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.tags.get(0));
            default -> Collections.unmodifiableList(new ArrayList<TagFilter>(b.tags));
        };
        this.terms = b.terms;
        this.typeNames = switch (b.typeNames == null ? 0 : b.typeNames.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.typeNames.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.typeNames));
        };
    }

    @Generated
    public static LinkableQueryBuilder<?, ?> _internal() {
        return new LinkableQueryBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkableQuery)) {
            return false;
        }
        LinkableQuery other = (LinkableQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AtlanClient this$client = this.client;
        AtlanClient other$client = other.client;
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        List<CertificateStatus> this$certificateStatuses = this.certificateStatuses;
        List<CertificateStatus> other$certificateStatuses = other.certificateStatuses;
        if (this$certificateStatuses == null ? other$certificateStatuses != null : !((Object)this$certificateStatuses).equals(other$certificateStatuses)) {
            return false;
        }
        AssetHierarchy this$hierarchy = this.hierarchy;
        AssetHierarchy other$hierarchy = other.hierarchy;
        if (this$hierarchy == null ? other$hierarchy != null : !((Object)this$hierarchy).equals(other$hierarchy)) {
            return false;
        }
        Owners this$owners = this.owners;
        Owners other$owners = other.owners;
        if (this$owners == null ? other$owners != null : !((Object)this$owners).equals(other$owners)) {
            return false;
        }
        List<DiscoveryFilter> this$properties = this.properties;
        List<DiscoveryFilter> other$properties = other.properties;
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<TagFilter> this$tags = this.tags;
        List<TagFilter> other$tags = other.tags;
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Terms this$terms = this.terms;
        Terms other$terms = other.terms;
        if (this$terms == null ? other$terms != null : !((Object)this$terms).equals(other$terms)) {
            return false;
        }
        List<String> this$typeNames = this.typeNames;
        List<String> other$typeNames = other.typeNames;
        return !(this$typeNames == null ? other$typeNames != null : !((Object)this$typeNames).equals(other$typeNames));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LinkableQuery;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AtlanClient $client = this.client;
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        List<CertificateStatus> $certificateStatuses = this.certificateStatuses;
        result = result * 59 + ($certificateStatuses == null ? 43 : ((Object)$certificateStatuses).hashCode());
        AssetHierarchy $hierarchy = this.hierarchy;
        result = result * 59 + ($hierarchy == null ? 43 : ((Object)$hierarchy).hashCode());
        Owners $owners = this.owners;
        result = result * 59 + ($owners == null ? 43 : ((Object)$owners).hashCode());
        List<DiscoveryFilter> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<TagFilter> $tags = this.tags;
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Terms $terms = this.terms;
        result = result * 59 + ($terms == null ? 43 : ((Object)$terms).hashCode());
        List<String> $typeNames = this.typeNames;
        result = result * 59 + ($typeNames == null ? 43 : ((Object)$typeNames).hashCode());
        return result;
    }

    public static abstract class LinkableQueryBuilder<C extends LinkableQuery, B extends LinkableQueryBuilder<C, B>> {
        @Generated
        private AtlanClient client;
        @Generated
        private ArrayList<CertificateStatus> certificateStatuses;
        @Generated
        private AssetHierarchy hierarchy;
        @Generated
        private Owners owners;
        @Generated
        private ArrayList<DiscoveryFilter> properties;
        @Generated
        private ArrayList<TagFilter> tags;
        @Generated
        private Terms terms;
        @Generated
        private ArrayList<String> typeNames;

        public B forConnection(Connection connection) {
            String qn = connection.getQualifiedName();
            return this.hierarchy((AssetHierarchy)((AssetHierarchy.AssetHierarchyBuilder)((AssetHierarchy.AssetHierarchyBuilder)((AssetHierarchy.AssetHierarchyBuilder)((AssetHierarchy.AssetHierarchyBuilder)AssetHierarchy.builder().connectionQualifiedName(connection.getQualifiedName())).connectorName(Connection.getConnectorTypeFromQualifiedName(qn).getValue())).attributeName("")).attributeValue("")).build());
        }

        public B forPrefix(String qualifiedNamePrefix, String denormalizedAttributeName) {
            String connectionQN = StringUtils.getConnectionQualifiedName(qualifiedNamePrefix);
            if (connectionQN != null) {
                return this.hierarchy((AssetHierarchy)((AssetHierarchy.AssetHierarchyBuilder)((AssetHierarchy.AssetHierarchyBuilder)((AssetHierarchy.AssetHierarchyBuilder)((AssetHierarchy.AssetHierarchyBuilder)AssetHierarchy.builder().connectionQualifiedName(connectionQN)).connectorName(Connection.getConnectorTypeFromQualifiedName(connectionQN).getValue())).attributeName(denormalizedAttributeName)).attributeValue(qualifiedNamePrefix)).build());
            }
            return this.hierarchy((AssetHierarchy)AssetHierarchy.builder().build());
        }

        public B withTag(String tagName) {
            return this.tag(TagFilter.of(this.client, tagName));
        }

        public B withTagValue(String tagName, String value) {
            return this.tag(TagFilter.of(this.client, tagName, value));
        }

        public B withoutOwners() {
            return this.owners((Owners)((Owners.OwnersBuilder)Owners.builder().empty(true)).build());
        }

        public B withOwners(List<String> usernames, List<String> groups) throws AtlanException {
            if ((usernames == null || usernames.isEmpty()) && (groups == null || groups.isEmpty())) {
                return this.withoutOwners();
            }
            Owners.OwnersBuilder<?, ?> builder = Owners.builder();
            if (usernames != null) {
                for (String username : usernames) {
                    AtlanUser user = (AtlanUser)this.client.getUserCache().getByName(username, true);
                    ((Owners.OwnersBuilder)((Owners.OwnersBuilder)builder.ownerUser(username)).ownerId(user.getId())).selectedOwner(username, OwnerDetails.from(user));
                }
            }
            if (groups != null) {
                for (String alias : groups) {
                    AtlanGroup group = (AtlanGroup)this.client.getGroupCache().getByName(alias, true);
                    ((Owners.OwnersBuilder)builder.ownerGroup(alias)).selectedGroup(alias, group);
                }
            }
            return this.owners((Owners)builder.build());
        }

        public B withAnyOf(List<GlossaryTerm> terms) {
            return this.withTerms("equals", terms);
        }

        public B withAll(List<GlossaryTerm> terms) {
            return this.withTerms("AND", terms);
        }

        public B withNoneOf(List<GlossaryTerm> terms) {
            return this.withTerms("NAND", terms);
        }

        public B withoutTerms() {
            return this.terms((Terms)((Terms.TermsBuilder)Terms.builder().operator("isNull")).build());
        }

        public B withAnyTerm() {
            return this.terms((Terms)((Terms.TermsBuilder)Terms.builder().operator("isNotNull")).build());
        }

        private B withTerms(String operator, List<GlossaryTerm> terms) {
            Object builder = Terms.builder().operator(operator);
            for (GlossaryTerm term : terms) {
                ((Terms.TermsBuilder)builder).term((TermDetails)((TermDetails.TermDetailsBuilder)((TermDetails.TermDetailsBuilder)((TermDetails.TermDetailsBuilder)TermDetails.builder().guid(term.getGuid())).qualifiedName(term.getQualifiedName())).attributes(Map.of("name", term.getName()))).build());
            }
            return this.terms((Terms)((Terms.TermsBuilder)builder).build());
        }

        public String toUrl() {
            return ((LinkableQuery)this.build()).getUrl();
        }

        public String toFullUrl() {
            return ((LinkableQuery)this.build()).getFullUrl();
        }

        @Generated
        public B client(AtlanClient client) {
            this.client = client;
            return this.self();
        }

        @Generated
        public B certificateStatus(CertificateStatus certificateStatus) {
            if (this.certificateStatuses == null) {
                this.certificateStatuses = new ArrayList();
            }
            this.certificateStatuses.add(certificateStatus);
            return this.self();
        }

        @Generated
        public B certificateStatuses(Collection<? extends CertificateStatus> certificateStatuses) {
            if (certificateStatuses == null) {
                throw new NullPointerException("certificateStatuses cannot be null");
            }
            if (this.certificateStatuses == null) {
                this.certificateStatuses = new ArrayList();
            }
            this.certificateStatuses.addAll(certificateStatuses);
            return this.self();
        }

        @Generated
        public B clearCertificateStatuses() {
            if (this.certificateStatuses != null) {
                this.certificateStatuses.clear();
            }
            return this.self();
        }

        @Generated
        public B hierarchy(AssetHierarchy hierarchy) {
            this.hierarchy = hierarchy;
            return this.self();
        }

        @Generated
        public B owners(Owners owners) {
            this.owners = owners;
            return this.self();
        }

        @Generated
        public B property(DiscoveryFilter property) {
            if (this.properties == null) {
                this.properties = new ArrayList();
            }
            this.properties.add(property);
            return this.self();
        }

        @Generated
        public B properties(Collection<? extends DiscoveryFilter> properties) {
            if (properties == null) {
                throw new NullPointerException("properties cannot be null");
            }
            if (this.properties == null) {
                this.properties = new ArrayList();
            }
            this.properties.addAll(properties);
            return this.self();
        }

        @Generated
        public B clearProperties() {
            if (this.properties != null) {
                this.properties.clear();
            }
            return this.self();
        }

        @Generated
        public B tag(TagFilter tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this.self();
        }

        @Generated
        public B tags(Collection<? extends TagFilter> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this.self();
        }

        @Generated
        public B clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this.self();
        }

        @Generated
        public B terms(Terms terms) {
            this.terms = terms;
            return this.self();
        }

        @Generated
        public B typeName(String typeName) {
            if (this.typeNames == null) {
                this.typeNames = new ArrayList();
            }
            this.typeNames.add(typeName);
            return this.self();
        }

        @Generated
        public B typeNames(Collection<? extends String> typeNames) {
            if (typeNames == null) {
                throw new NullPointerException("typeNames cannot be null");
            }
            if (this.typeNames == null) {
                this.typeNames = new ArrayList();
            }
            this.typeNames.addAll(typeNames);
            return this.self();
        }

        @Generated
        public B clearTypeNames() {
            if (this.typeNames != null) {
                this.typeNames.clear();
            }
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "LinkableQuery.LinkableQueryBuilder(client=" + String.valueOf(this.client) + ", certificateStatuses=" + String.valueOf(this.certificateStatuses) + ", hierarchy=" + String.valueOf(this.hierarchy) + ", owners=" + String.valueOf(this.owners) + ", properties=" + String.valueOf(this.properties) + ", tags=" + String.valueOf(this.tags) + ", terms=" + String.valueOf(this.terms) + ", typeNames=" + String.valueOf(this.typeNames) + ")";
        }
    }

    private static final class FilterParams {
        private final Map<String, Object> filters = new LinkedHashMap<String, Object>();
        private final Map<String, Object> postFilters = new LinkedHashMap<String, Object>();

        FilterParams(LinkableQuery query) {
            if (query.certificateStatuses != null) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (CertificateStatus status : query.certificateStatuses) {
                    if (status == null) {
                        list.add(Removable.NULL);
                        continue;
                    }
                    list.add(status.getValue());
                }
                this.filters.put("certificateStatus", list);
            }
            if (query.hierarchy != null) {
                this.filters.put("hierarchy", query.hierarchy);
            }
            if (query.properties != null) {
                LinkedHashMap<String, List<DiscoveryFilter>> propertyMap = new LinkedHashMap<String, List<DiscoveryFilter>>();
                for (DiscoveryFilter filter : query.properties) {
                    propertyMap.put(filter.filterKey, List.of(filter));
                }
                this.filters.put("properties", propertyMap);
            }
            if (query.tags != null) {
                this.filters.put("__traitNames", Map.of("classifications", query.tags));
            }
            if (query.typeNames != null) {
                ArrayList<TypeName> types = new ArrayList<TypeName>();
                for (String typeName : query.typeNames) {
                    types.add(new TypeName(typeName));
                }
                this.postFilters.put("typeName", types);
            }
        }

        @Generated
        public Map<String, Object> getFilters() {
            return this.filters;
        }

        @Generated
        public Map<String, Object> getPostFilters() {
            return this.postFilters;
        }
    }

    static final class AssetHierarchy {
        String connectorName;
        String connectionQualifiedName;
        String attributeName;
        String attributeValue;

        @Generated
        protected AssetHierarchy(AssetHierarchyBuilder<?, ?> b) {
            this.connectorName = b.connectorName;
            this.connectionQualifiedName = b.connectionQualifiedName;
            this.attributeName = b.attributeName;
            this.attributeValue = b.attributeValue;
        }

        @Generated
        public static AssetHierarchyBuilder<?, ?> builder() {
            return new AssetHierarchyBuilderImpl();
        }

        @Generated
        public String getConnectorName() {
            return this.connectorName;
        }

        @Generated
        public String getConnectionQualifiedName() {
            return this.connectionQualifiedName;
        }

        @Generated
        public String getAttributeName() {
            return this.attributeName;
        }

        @Generated
        public String getAttributeValue() {
            return this.attributeValue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssetHierarchy)) {
                return false;
            }
            AssetHierarchy other = (AssetHierarchy)o;
            String this$connectorName = this.getConnectorName();
            String other$connectorName = other.getConnectorName();
            if (this$connectorName == null ? other$connectorName != null : !this$connectorName.equals(other$connectorName)) {
                return false;
            }
            String this$connectionQualifiedName = this.getConnectionQualifiedName();
            String other$connectionQualifiedName = other.getConnectionQualifiedName();
            if (this$connectionQualifiedName == null ? other$connectionQualifiedName != null : !this$connectionQualifiedName.equals(other$connectionQualifiedName)) {
                return false;
            }
            String this$attributeName = this.getAttributeName();
            String other$attributeName = other.getAttributeName();
            if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName)) {
                return false;
            }
            String this$attributeValue = this.getAttributeValue();
            String other$attributeValue = other.getAttributeValue();
            return !(this$attributeValue == null ? other$attributeValue != null : !this$attributeValue.equals(other$attributeValue));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $connectorName = this.getConnectorName();
            result = result * 59 + ($connectorName == null ? 43 : $connectorName.hashCode());
            String $connectionQualifiedName = this.getConnectionQualifiedName();
            result = result * 59 + ($connectionQualifiedName == null ? 43 : $connectionQualifiedName.hashCode());
            String $attributeName = this.getAttributeName();
            result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
            String $attributeValue = this.getAttributeValue();
            result = result * 59 + ($attributeValue == null ? 43 : $attributeValue.hashCode());
            return result;
        }

        @Generated
        public static abstract class AssetHierarchyBuilder<C extends AssetHierarchy, B extends AssetHierarchyBuilder<C, B>> {
            @Generated
            private String connectorName;
            @Generated
            private String connectionQualifiedName;
            @Generated
            private String attributeName;
            @Generated
            private String attributeValue;

            @Generated
            public B connectorName(String connectorName) {
                this.connectorName = connectorName;
                return this.self();
            }

            @Generated
            public B connectionQualifiedName(String connectionQualifiedName) {
                this.connectionQualifiedName = connectionQualifiedName;
                return this.self();
            }

            @Generated
            public B attributeName(String attributeName) {
                this.attributeName = attributeName;
                return this.self();
            }

            @Generated
            public B attributeValue(String attributeValue) {
                this.attributeValue = attributeValue;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "LinkableQuery.AssetHierarchy.AssetHierarchyBuilder(connectorName=" + this.connectorName + ", connectionQualifiedName=" + this.connectionQualifiedName + ", attributeName=" + this.attributeName + ", attributeValue=" + this.attributeValue + ")";
            }
        }

        @Generated
        private static final class AssetHierarchyBuilderImpl
        extends AssetHierarchyBuilder<AssetHierarchy, AssetHierarchyBuilderImpl> {
            @Generated
            private AssetHierarchyBuilderImpl() {
            }

            @Override
            @Generated
            protected AssetHierarchyBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public AssetHierarchy build() {
                return new AssetHierarchy(this);
            }
        }
    }

    static final class Owners {
        List<String> ownerIds;
        Map<String, OwnerDetails> selectedOwners;
        List<String> ownerUsers;
        Map<String, AtlanGroup> selectedGroups;
        List<String> ownerGroups;
        Boolean empty;

        @Generated
        protected Owners(OwnersBuilder<?, ?> b) {
            Map<Object, Object> selectedGroups;
            Map<Object, Object> selectedOwners;
            this.ownerIds = switch (b.ownerIds == null ? 0 : b.ownerIds.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(b.ownerIds.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(b.ownerIds));
            };
            switch (b.selectedOwners$key == null ? 0 : b.selectedOwners$key.size()) {
                case 0: {
                    selectedOwners = Collections.emptyMap();
                    break;
                }
                case 1: {
                    selectedOwners = Collections.singletonMap(b.selectedOwners$key.get(0), b.selectedOwners$value.get(0));
                    break;
                }
                default: {
                    selectedOwners = new LinkedHashMap(b.selectedOwners$key.size() < 0x40000000 ? 1 + b.selectedOwners$key.size() + (b.selectedOwners$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < b.selectedOwners$key.size(); ++$i) {
                        selectedOwners.put(b.selectedOwners$key.get($i), b.selectedOwners$value.get($i));
                    }
                    selectedOwners = Collections.unmodifiableMap(selectedOwners);
                }
            }
            this.selectedOwners = selectedOwners;
            this.ownerUsers = switch (b.ownerUsers == null ? 0 : b.ownerUsers.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(b.ownerUsers.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(b.ownerUsers));
            };
            switch (b.selectedGroups$key == null ? 0 : b.selectedGroups$key.size()) {
                case 0: {
                    selectedGroups = Collections.emptyMap();
                    break;
                }
                case 1: {
                    selectedGroups = Collections.singletonMap(b.selectedGroups$key.get(0), b.selectedGroups$value.get(0));
                    break;
                }
                default: {
                    selectedGroups = new LinkedHashMap(b.selectedGroups$key.size() < 0x40000000 ? 1 + b.selectedGroups$key.size() + (b.selectedGroups$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < b.selectedGroups$key.size(); ++$i) {
                        selectedGroups.put(b.selectedGroups$key.get($i), b.selectedGroups$value.get($i));
                    }
                    selectedGroups = Collections.unmodifiableMap(selectedGroups);
                }
            }
            this.selectedGroups = selectedGroups;
            this.ownerGroups = switch (b.ownerGroups == null ? 0 : b.ownerGroups.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(b.ownerGroups.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(b.ownerGroups));
            };
            this.empty = b.empty;
        }

        @Generated
        public static OwnersBuilder<?, ?> builder() {
            return new OwnersBuilderImpl();
        }

        @Generated
        public List<String> getOwnerIds() {
            return this.ownerIds;
        }

        @Generated
        public Map<String, OwnerDetails> getSelectedOwners() {
            return this.selectedOwners;
        }

        @Generated
        public List<String> getOwnerUsers() {
            return this.ownerUsers;
        }

        @Generated
        public Map<String, AtlanGroup> getSelectedGroups() {
            return this.selectedGroups;
        }

        @Generated
        public List<String> getOwnerGroups() {
            return this.ownerGroups;
        }

        @Generated
        public Boolean getEmpty() {
            return this.empty;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Owners)) {
                return false;
            }
            Owners other = (Owners)o;
            Boolean this$empty = this.getEmpty();
            Boolean other$empty = other.getEmpty();
            if (this$empty == null ? other$empty != null : !((Object)this$empty).equals(other$empty)) {
                return false;
            }
            List<String> this$ownerIds = this.getOwnerIds();
            List<String> other$ownerIds = other.getOwnerIds();
            if (this$ownerIds == null ? other$ownerIds != null : !((Object)this$ownerIds).equals(other$ownerIds)) {
                return false;
            }
            Map<String, OwnerDetails> this$selectedOwners = this.getSelectedOwners();
            Map<String, OwnerDetails> other$selectedOwners = other.getSelectedOwners();
            if (this$selectedOwners == null ? other$selectedOwners != null : !((Object)this$selectedOwners).equals(other$selectedOwners)) {
                return false;
            }
            List<String> this$ownerUsers = this.getOwnerUsers();
            List<String> other$ownerUsers = other.getOwnerUsers();
            if (this$ownerUsers == null ? other$ownerUsers != null : !((Object)this$ownerUsers).equals(other$ownerUsers)) {
                return false;
            }
            Map<String, AtlanGroup> this$selectedGroups = this.getSelectedGroups();
            Map<String, AtlanGroup> other$selectedGroups = other.getSelectedGroups();
            if (this$selectedGroups == null ? other$selectedGroups != null : !((Object)this$selectedGroups).equals(other$selectedGroups)) {
                return false;
            }
            List<String> this$ownerGroups = this.getOwnerGroups();
            List<String> other$ownerGroups = other.getOwnerGroups();
            return !(this$ownerGroups == null ? other$ownerGroups != null : !((Object)this$ownerGroups).equals(other$ownerGroups));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $empty = this.getEmpty();
            result = result * 59 + ($empty == null ? 43 : ((Object)$empty).hashCode());
            List<String> $ownerIds = this.getOwnerIds();
            result = result * 59 + ($ownerIds == null ? 43 : ((Object)$ownerIds).hashCode());
            Map<String, OwnerDetails> $selectedOwners = this.getSelectedOwners();
            result = result * 59 + ($selectedOwners == null ? 43 : ((Object)$selectedOwners).hashCode());
            List<String> $ownerUsers = this.getOwnerUsers();
            result = result * 59 + ($ownerUsers == null ? 43 : ((Object)$ownerUsers).hashCode());
            Map<String, AtlanGroup> $selectedGroups = this.getSelectedGroups();
            result = result * 59 + ($selectedGroups == null ? 43 : ((Object)$selectedGroups).hashCode());
            List<String> $ownerGroups = this.getOwnerGroups();
            result = result * 59 + ($ownerGroups == null ? 43 : ((Object)$ownerGroups).hashCode());
            return result;
        }

        @Generated
        public static abstract class OwnersBuilder<C extends Owners, B extends OwnersBuilder<C, B>> {
            @Generated
            private ArrayList<String> ownerIds;
            @Generated
            private ArrayList<String> selectedOwners$key;
            @Generated
            private ArrayList<OwnerDetails> selectedOwners$value;
            @Generated
            private ArrayList<String> ownerUsers;
            @Generated
            private ArrayList<String> selectedGroups$key;
            @Generated
            private ArrayList<AtlanGroup> selectedGroups$value;
            @Generated
            private ArrayList<String> ownerGroups;
            @Generated
            private Boolean empty;

            @Generated
            public B ownerId(String ownerId) {
                if (this.ownerIds == null) {
                    this.ownerIds = new ArrayList();
                }
                this.ownerIds.add(ownerId);
                return this.self();
            }

            @Generated
            public B ownerIds(Collection<? extends String> ownerIds) {
                if (ownerIds == null) {
                    throw new NullPointerException("ownerIds cannot be null");
                }
                if (this.ownerIds == null) {
                    this.ownerIds = new ArrayList();
                }
                this.ownerIds.addAll(ownerIds);
                return this.self();
            }

            @Generated
            public B clearOwnerIds() {
                if (this.ownerIds != null) {
                    this.ownerIds.clear();
                }
                return this.self();
            }

            @Generated
            public B selectedOwner(String selectedOwnerKey, OwnerDetails selectedOwnerValue) {
                if (this.selectedOwners$key == null) {
                    this.selectedOwners$key = new ArrayList();
                    this.selectedOwners$value = new ArrayList();
                }
                this.selectedOwners$key.add(selectedOwnerKey);
                this.selectedOwners$value.add(selectedOwnerValue);
                return this.self();
            }

            @Generated
            public B selectedOwners(Map<? extends String, ? extends OwnerDetails> selectedOwners) {
                if (selectedOwners == null) {
                    throw new NullPointerException("selectedOwners cannot be null");
                }
                if (this.selectedOwners$key == null) {
                    this.selectedOwners$key = new ArrayList();
                    this.selectedOwners$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends OwnerDetails> $lombokEntry : selectedOwners.entrySet()) {
                    this.selectedOwners$key.add($lombokEntry.getKey());
                    this.selectedOwners$value.add($lombokEntry.getValue());
                }
                return this.self();
            }

            @Generated
            public B clearSelectedOwners() {
                if (this.selectedOwners$key != null) {
                    this.selectedOwners$key.clear();
                    this.selectedOwners$value.clear();
                }
                return this.self();
            }

            @Generated
            public B ownerUser(String ownerUser) {
                if (this.ownerUsers == null) {
                    this.ownerUsers = new ArrayList();
                }
                this.ownerUsers.add(ownerUser);
                return this.self();
            }

            @Generated
            public B ownerUsers(Collection<? extends String> ownerUsers) {
                if (ownerUsers == null) {
                    throw new NullPointerException("ownerUsers cannot be null");
                }
                if (this.ownerUsers == null) {
                    this.ownerUsers = new ArrayList();
                }
                this.ownerUsers.addAll(ownerUsers);
                return this.self();
            }

            @Generated
            public B clearOwnerUsers() {
                if (this.ownerUsers != null) {
                    this.ownerUsers.clear();
                }
                return this.self();
            }

            @Generated
            public B selectedGroup(String selectedGroupKey, AtlanGroup selectedGroupValue) {
                if (this.selectedGroups$key == null) {
                    this.selectedGroups$key = new ArrayList();
                    this.selectedGroups$value = new ArrayList();
                }
                this.selectedGroups$key.add(selectedGroupKey);
                this.selectedGroups$value.add(selectedGroupValue);
                return this.self();
            }

            @Generated
            public B selectedGroups(Map<? extends String, ? extends AtlanGroup> selectedGroups) {
                if (selectedGroups == null) {
                    throw new NullPointerException("selectedGroups cannot be null");
                }
                if (this.selectedGroups$key == null) {
                    this.selectedGroups$key = new ArrayList();
                    this.selectedGroups$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends AtlanGroup> $lombokEntry : selectedGroups.entrySet()) {
                    this.selectedGroups$key.add($lombokEntry.getKey());
                    this.selectedGroups$value.add($lombokEntry.getValue());
                }
                return this.self();
            }

            @Generated
            public B clearSelectedGroups() {
                if (this.selectedGroups$key != null) {
                    this.selectedGroups$key.clear();
                    this.selectedGroups$value.clear();
                }
                return this.self();
            }

            @Generated
            public B ownerGroup(String ownerGroup) {
                if (this.ownerGroups == null) {
                    this.ownerGroups = new ArrayList();
                }
                this.ownerGroups.add(ownerGroup);
                return this.self();
            }

            @Generated
            public B ownerGroups(Collection<? extends String> ownerGroups) {
                if (ownerGroups == null) {
                    throw new NullPointerException("ownerGroups cannot be null");
                }
                if (this.ownerGroups == null) {
                    this.ownerGroups = new ArrayList();
                }
                this.ownerGroups.addAll(ownerGroups);
                return this.self();
            }

            @Generated
            public B clearOwnerGroups() {
                if (this.ownerGroups != null) {
                    this.ownerGroups.clear();
                }
                return this.self();
            }

            @Generated
            public B empty(Boolean empty) {
                this.empty = empty;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "LinkableQuery.Owners.OwnersBuilder(ownerIds=" + String.valueOf(this.ownerIds) + ", selectedOwners$key=" + String.valueOf(this.selectedOwners$key) + ", selectedOwners$value=" + String.valueOf(this.selectedOwners$value) + ", ownerUsers=" + String.valueOf(this.ownerUsers) + ", selectedGroups$key=" + String.valueOf(this.selectedGroups$key) + ", selectedGroups$value=" + String.valueOf(this.selectedGroups$value) + ", ownerGroups=" + String.valueOf(this.ownerGroups) + ", empty=" + this.empty + ")";
            }
        }

        @Generated
        private static final class OwnersBuilderImpl
        extends OwnersBuilder<Owners, OwnersBuilderImpl> {
            @Generated
            private OwnersBuilderImpl() {
            }

            @Override
            @Generated
            protected OwnersBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Owners build() {
                return new Owners(this);
            }
        }
    }

    static final class Terms {
        Boolean empty;
        String operator;
        List<TermDetails> terms;

        @Generated
        protected Terms(TermsBuilder<?, ?> b) {
            this.empty = b.empty;
            this.operator = b.operator;
            this.terms = switch (b.terms == null ? 0 : b.terms.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(b.terms.get(0));
                default -> Collections.unmodifiableList(new ArrayList<TermDetails>(b.terms));
            };
        }

        @Generated
        public static TermsBuilder<?, ?> builder() {
            return new TermsBuilderImpl();
        }

        @Generated
        public Boolean getEmpty() {
            return this.empty;
        }

        @Generated
        public String getOperator() {
            return this.operator;
        }

        @Generated
        public List<TermDetails> getTerms() {
            return this.terms;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Terms)) {
                return false;
            }
            Terms other = (Terms)o;
            Boolean this$empty = this.getEmpty();
            Boolean other$empty = other.getEmpty();
            if (this$empty == null ? other$empty != null : !((Object)this$empty).equals(other$empty)) {
                return false;
            }
            String this$operator = this.getOperator();
            String other$operator = other.getOperator();
            if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
                return false;
            }
            List<TermDetails> this$terms = this.getTerms();
            List<TermDetails> other$terms = other.getTerms();
            return !(this$terms == null ? other$terms != null : !((Object)this$terms).equals(other$terms));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $empty = this.getEmpty();
            result = result * 59 + ($empty == null ? 43 : ((Object)$empty).hashCode());
            String $operator = this.getOperator();
            result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
            List<TermDetails> $terms = this.getTerms();
            result = result * 59 + ($terms == null ? 43 : ((Object)$terms).hashCode());
            return result;
        }

        @Generated
        public static abstract class TermsBuilder<C extends Terms, B extends TermsBuilder<C, B>> {
            @Generated
            private Boolean empty;
            @Generated
            private String operator;
            @Generated
            private ArrayList<TermDetails> terms;

            @Generated
            public B empty(Boolean empty) {
                this.empty = empty;
                return this.self();
            }

            @Generated
            public B operator(String operator) {
                this.operator = operator;
                return this.self();
            }

            @Generated
            public B term(TermDetails term) {
                if (this.terms == null) {
                    this.terms = new ArrayList();
                }
                this.terms.add(term);
                return this.self();
            }

            @Generated
            public B terms(Collection<? extends TermDetails> terms) {
                if (terms == null) {
                    throw new NullPointerException("terms cannot be null");
                }
                if (this.terms == null) {
                    this.terms = new ArrayList();
                }
                this.terms.addAll(terms);
                return this.self();
            }

            @Generated
            public B clearTerms() {
                if (this.terms != null) {
                    this.terms.clear();
                }
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "LinkableQuery.Terms.TermsBuilder(empty=" + this.empty + ", operator=" + this.operator + ", terms=" + String.valueOf(this.terms) + ")";
            }
        }

        @Generated
        private static final class TermsBuilderImpl
        extends TermsBuilder<Terms, TermsBuilderImpl> {
            @Generated
            private TermsBuilderImpl() {
            }

            @Override
            @Generated
            protected TermsBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Terms build() {
                return new Terms(this);
            }
        }
    }

    @Generated
    private static final class LinkableQueryBuilderImpl
    extends LinkableQueryBuilder<LinkableQuery, LinkableQueryBuilderImpl> {
        @Generated
        private LinkableQueryBuilderImpl() {
        }

        @Override
        @Generated
        protected LinkableQueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LinkableQuery build() {
            return new LinkableQuery(this);
        }
    }

    private static final class TypeName {
        String id;
        String label;

        TypeName(String typeName) {
            this.id = typeName;
            this.label = StringUtils.getTitleCase(typeName);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }
    }

    static final class TermDetails {
        String guid;
        String qualifiedName;
        final String typeName = "AtlasGlossaryTerm";
        Map<String, String> attributes;

        @Generated
        protected TermDetails(TermDetailsBuilder<?, ?> b) {
            this.guid = b.guid;
            this.qualifiedName = b.qualifiedName;
            this.attributes = b.attributes;
        }

        @Generated
        public static TermDetailsBuilder<?, ?> builder() {
            return new TermDetailsBuilderImpl();
        }

        @Generated
        public String getGuid() {
            return this.guid;
        }

        @Generated
        public String getQualifiedName() {
            return this.qualifiedName;
        }

        @Generated
        public String getTypeName() {
            return this.typeName;
        }

        @Generated
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TermDetails)) {
                return false;
            }
            TermDetails other = (TermDetails)o;
            String this$guid = this.getGuid();
            String other$guid = other.getGuid();
            if (this$guid == null ? other$guid != null : !this$guid.equals(other$guid)) {
                return false;
            }
            String this$qualifiedName = this.getQualifiedName();
            String other$qualifiedName = other.getQualifiedName();
            if (this$qualifiedName == null ? other$qualifiedName != null : !this$qualifiedName.equals(other$qualifiedName)) {
                return false;
            }
            String this$typeName = this.getTypeName();
            String other$typeName = other.getTypeName();
            if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
                return false;
            }
            Map<String, String> this$attributes = this.getAttributes();
            Map<String, String> other$attributes = other.getAttributes();
            return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $guid = this.getGuid();
            result = result * 59 + ($guid == null ? 43 : $guid.hashCode());
            String $qualifiedName = this.getQualifiedName();
            result = result * 59 + ($qualifiedName == null ? 43 : $qualifiedName.hashCode());
            String $typeName = this.getTypeName();
            result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
            Map<String, String> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            return result;
        }

        @Generated
        public static abstract class TermDetailsBuilder<C extends TermDetails, B extends TermDetailsBuilder<C, B>> {
            @Generated
            private String guid;
            @Generated
            private String qualifiedName;
            @Generated
            private Map<String, String> attributes;

            @Generated
            public B guid(String guid) {
                this.guid = guid;
                return this.self();
            }

            @Generated
            public B qualifiedName(String qualifiedName) {
                this.qualifiedName = qualifiedName;
                return this.self();
            }

            @Generated
            public B attributes(Map<String, String> attributes) {
                this.attributes = attributes;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "LinkableQuery.TermDetails.TermDetailsBuilder(guid=" + this.guid + ", qualifiedName=" + this.qualifiedName + ", attributes=" + String.valueOf(this.attributes) + ")";
            }
        }

        @Generated
        private static final class TermDetailsBuilderImpl
        extends TermDetailsBuilder<TermDetails, TermDetailsBuilderImpl> {
            @Generated
            private TermDetailsBuilderImpl() {
            }

            @Override
            @Generated
            protected TermDetailsBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public TermDetails build() {
                return new TermDetails(this);
            }
        }
    }

    static final class OwnerDetails {
        String firstName;
        String id;
        String username;
        String lastName;
        Boolean enabled;
        String email;

        public static OwnerDetails from(AtlanUser user) {
            if (user == null) {
                return null;
            }
            return ((OwnerDetailsBuilder)((OwnerDetailsBuilder)((OwnerDetailsBuilder)((OwnerDetailsBuilder)((OwnerDetailsBuilder)((OwnerDetailsBuilder)OwnerDetails.builder().firstName(user.getFirstName())).id(user.getId())).username(user.getUsername())).lastName(user.getLastName())).enabled(user.getEnabled())).email(user.getEmail())).build();
        }

        @Generated
        protected OwnerDetails(OwnerDetailsBuilder<?, ?> b) {
            this.firstName = b.firstName;
            this.id = b.id;
            this.username = b.username;
            this.lastName = b.lastName;
            this.enabled = b.enabled;
            this.email = b.email;
        }

        @Generated
        public static OwnerDetailsBuilder<?, ?> builder() {
            return new OwnerDetailsBuilderImpl();
        }

        @Generated
        public String getFirstName() {
            return this.firstName;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getLastName() {
            return this.lastName;
        }

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OwnerDetails)) {
                return false;
            }
            OwnerDetails other = (OwnerDetails)o;
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            String this$firstName = this.getFirstName();
            String other$firstName = other.getFirstName();
            if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$lastName = this.getLastName();
            String other$lastName = other.getLastName();
            if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            return !(this$email == null ? other$email != null : !this$email.equals(other$email));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            String $firstName = this.getFirstName();
            result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $lastName = this.getLastName();
            result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            return result;
        }

        @Generated
        public static abstract class OwnerDetailsBuilder<C extends OwnerDetails, B extends OwnerDetailsBuilder<C, B>> {
            @Generated
            private String firstName;
            @Generated
            private String id;
            @Generated
            private String username;
            @Generated
            private String lastName;
            @Generated
            private Boolean enabled;
            @Generated
            private String email;

            @Generated
            public B firstName(String firstName) {
                this.firstName = firstName;
                return this.self();
            }

            @Generated
            public B id(String id) {
                this.id = id;
                return this.self();
            }

            @Generated
            public B username(String username) {
                this.username = username;
                return this.self();
            }

            @Generated
            public B lastName(String lastName) {
                this.lastName = lastName;
                return this.self();
            }

            @Generated
            public B enabled(Boolean enabled) {
                this.enabled = enabled;
                return this.self();
            }

            @Generated
            public B email(String email) {
                this.email = email;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "LinkableQuery.OwnerDetails.OwnerDetailsBuilder(firstName=" + this.firstName + ", id=" + this.id + ", username=" + this.username + ", lastName=" + this.lastName + ", enabled=" + this.enabled + ", email=" + this.email + ")";
            }
        }

        @Generated
        private static final class OwnerDetailsBuilderImpl
        extends OwnerDetailsBuilder<OwnerDetails, OwnerDetailsBuilderImpl> {
            @Generated
            private OwnerDetailsBuilderImpl() {
            }

            @Override
            @Generated
            protected OwnerDetailsBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public OwnerDetails build() {
                return new OwnerDetails(this);
            }
        }
    }
}

