/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.graph;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.IModel;
import com.atlan.model.assets.ModelAttribute;
import com.atlan.model.assets.ModelDataModel;
import com.atlan.model.assets.ModelEntity;
import com.atlan.model.assets.ModelEntityAssociation;
import com.atlan.model.assets.ModelVersion;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.graph.ModelEntityGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

public class ModelGraph {
    private ModelDataModel model;
    private ModelVersion version;
    private List<ModelEntityGraph> entities;
    private long asOfTime;
    private static final List<AtlanField> INCLUDES = List.of(ModelEntity.MODEL_ENTITY_MAPPED_TO_ENTITIES, ModelEntity.MODEL_ENTITY_MAPPED_FROM_ENTITIES, ModelAttribute.MODEL_ATTRIBUTE_DATA_TYPE, ModelAttribute.MODEL_ATTRIBUTE_IS_NULLABLE, ModelAttribute.MODEL_ATTRIBUTE_IS_PRIMARY, ModelAttribute.MODEL_ATTRIBUTE_IS_FOREIGN, ModelAttribute.MODEL_ATTRIBUTE_IS_DERIVED, ModelEntityAssociation.MODEL_ENTITY_ASSOCIATION_CARDINALITY, ModelEntityAssociation.MODEL_ENTITY_ASSOCIATION_LABEL, ModelEntityAssociation.MODEL_ENTITY_ASSOCIATION_TO_QUALIFIED_NAME, ModelEntityAssociation.MODEL_ENTITY_ASSOCIATION_FROM_QUALIFIED_NAME);

    public static ModelGraph from(AtlanClient client, long time, String prefix) throws AtlanException {
        List<Asset> assets = IModel.findByTime(client, time, prefix, INCLUDES);
        ModelGraphBuilder builder = ModelGraph.builder();
        HashMap eg = new HashMap();
        assets.forEach(it -> {
            if (it instanceof ModelDataModel) {
                ModelDataModel dm = (ModelDataModel)it;
                builder.model(dm);
            } else if (it instanceof ModelVersion) {
                ModelVersion mv = (ModelVersion)it;
                builder.version(mv);
            } else if (it instanceof ModelEntity) {
                ModelEntity me = (ModelEntity)it;
                if (!eg.containsKey(me.getModelVersionAgnosticQualifiedName())) {
                    eg.put(me.getModelVersionAgnosticQualifiedName(), ModelEntityGraph.builder());
                }
                ((ModelEntityGraph.ModelEntityGraphBuilder)eg.get(me.getModelVersionAgnosticQualifiedName())).details(me);
            } else if (it instanceof ModelAttribute) {
                ModelAttribute ma = (ModelAttribute)it;
                if (!eg.containsKey(ma.getModelEntityQualifiedName())) {
                    eg.put(ma.getModelEntityQualifiedName(), ModelEntityGraph.builder());
                }
                ((ModelEntityGraph.ModelEntityGraphBuilder)eg.get(ma.getModelEntityQualifiedName())).attribute(ma);
            } else if (it instanceof ModelEntityAssociation) {
                ModelEntityAssociation mea = (ModelEntityAssociation)it;
                String from = mea.getModelEntityAssociationFromQualifiedName();
                String to = mea.getModelEntityAssociationToQualifiedName();
                if (!eg.containsKey(from)) {
                    eg.put(from, ModelEntityGraph.builder());
                }
                if (!eg.containsKey(to)) {
                    eg.put(to, ModelEntityGraph.builder());
                }
                ((ModelEntityGraph.ModelEntityGraphBuilder)eg.get(from)).associatedTo(ModelEntityGraph.AssociatedEntity.builder().entity(ModelEntity.refByQualifiedName(to)).cardinality(mea.getModelEntityAssociationCardinality()).label(mea.getModelEntityAssociationLabel()).build());
                ((ModelEntityGraph.ModelEntityGraphBuilder)eg.get(to)).associatedFrom(ModelEntityGraph.AssociatedEntity.builder().entity(ModelEntity.refByQualifiedName(from)).cardinality(mea.getModelEntityAssociationCardinality()).label(mea.getModelEntityAssociationLabel()).build());
            }
        });
        return builder.entities(eg.values().stream().map(ModelEntityGraph.ModelEntityGraphBuilder::build).toList()).build();
    }

    @Generated
    ModelGraph(ModelDataModel model, ModelVersion version, List<ModelEntityGraph> entities, long asOfTime) {
        this.model = model;
        this.version = version;
        this.entities = entities;
        this.asOfTime = asOfTime;
    }

    @Generated
    private static ModelGraphBuilder builder() {
        return new ModelGraphBuilder();
    }

    @Generated
    public ModelDataModel getModel() {
        return this.model;
    }

    @Generated
    public ModelVersion getVersion() {
        return this.version;
    }

    @Generated
    public List<ModelEntityGraph> getEntities() {
        return this.entities;
    }

    @Generated
    public long getAsOfTime() {
        return this.asOfTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelGraph)) {
            return false;
        }
        ModelGraph other = (ModelGraph)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAsOfTime() != other.getAsOfTime()) {
            return false;
        }
        ModelDataModel this$model = this.getModel();
        ModelDataModel other$model = other.getModel();
        if (this$model == null ? other$model != null : !((Object)this$model).equals(other$model)) {
            return false;
        }
        ModelVersion this$version = this.getVersion();
        ModelVersion other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        List<ModelEntityGraph> this$entities = this.getEntities();
        List<ModelEntityGraph> other$entities = other.getEntities();
        return !(this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModelGraph;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $asOfTime = this.getAsOfTime();
        result = result * 59 + (int)($asOfTime >>> 32 ^ $asOfTime);
        ModelDataModel $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : ((Object)$model).hashCode());
        ModelVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        List<ModelEntityGraph> $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        return result;
    }

    @Generated
    private static class ModelGraphBuilder {
        @Generated
        private ModelDataModel model;
        @Generated
        private ModelVersion version;
        @Generated
        private ArrayList<ModelEntityGraph> entities;
        @Generated
        private long asOfTime;

        @Generated
        ModelGraphBuilder() {
        }

        @Generated
        private ModelGraphBuilder model(ModelDataModel model) {
            this.model = model;
            return this;
        }

        @Generated
        private ModelGraphBuilder version(ModelVersion version) {
            this.version = version;
            return this;
        }

        @Generated
        private ModelGraphBuilder entity(ModelEntityGraph entity) {
            if (this.entities == null) {
                this.entities = new ArrayList();
            }
            this.entities.add(entity);
            return this;
        }

        @Generated
        private ModelGraphBuilder entities(Collection<? extends ModelEntityGraph> entities) {
            if (entities == null) {
                throw new NullPointerException("entities cannot be null");
            }
            if (this.entities == null) {
                this.entities = new ArrayList();
            }
            this.entities.addAll(entities);
            return this;
        }

        @Generated
        private ModelGraphBuilder clearEntities() {
            if (this.entities != null) {
                this.entities.clear();
            }
            return this;
        }

        @Generated
        private ModelGraphBuilder asOfTime(long asOfTime) {
            this.asOfTime = asOfTime;
            return this;
        }

        @Generated
        private ModelGraph build() {
            return new ModelGraph(this.model, this.version, switch (this.entities == null ? 0 : this.entities.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.entities.get(0));
                default -> Collections.unmodifiableList(new ArrayList<ModelEntityGraph>(this.entities));
            }, this.asOfTime);
        }

        @Generated
        public String toString() {
            return "ModelGraph.ModelGraphBuilder(model=" + String.valueOf(this.model) + ", version=" + String.valueOf(this.version) + ", entities=" + String.valueOf(this.entities) + ", asOfTime=" + this.asOfTime + ")";
        }
    }
}

