/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.Credential;
import com.atlan.model.assets.Connection;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.model.packages.AbstractCrawler;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class DbtCrawler
extends AbstractCrawler {
    public static final String PREFIX = AtlanPackageType.DBT.getValue();

    public static DbtCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName) throws AtlanException {
        return DbtCrawler.creator(client, connectionName, List.of(client.getRoleCache().getIdForName("$admin")), null, null);
    }

    public static DbtCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers) throws AtlanException {
        return ((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)DbtCrawler._internal().setup(PREFIX, "@atlan/dbt", client, DbtCrawler.getConnection(client, connectionName, AtlanConnectorType.DBT, adminRoles, adminGroups, adminUsers, false, false, 0L, "https://assets.atlan.com/assets/dbt-new.svg"))).enrichMaterializedAssets(false)).tags(false)).include(null)).exclude(null);
    }

    @Generated
    protected DbtCrawler(DbtCrawlerBuilder<?, ?> b) {
        super((AbstractCrawler.AbstractCrawlerBuilder<?, ?>)b);
    }

    @Generated
    public static DbtCrawlerBuilder<?, ?> _internal() {
        return new DbtCrawlerBuilderImpl();
    }

    @Generated
    public DbtCrawlerBuilder<?, ?> toBuilder() {
        return new DbtCrawlerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbtCrawler)) {
            return false;
        }
        DbtCrawler other = (DbtCrawler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DbtCrawler;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DbtCrawler(super=" + super.toString() + ")";
    }

    public static abstract class DbtCrawlerBuilder<C extends DbtCrawler, B extends DbtCrawlerBuilder<C, B>>
    extends AbstractCrawler.AbstractCrawlerBuilder<C, B> {
        public B cloud(String serviceToken, boolean multiTenant) {
            return this.cloud("https://cloud.getdbt.com", serviceToken, multiTenant);
        }

        public B cloud(String hostname, String serviceToken, boolean multiTenant) {
            String epoch = Connection.getEpochFromQualifiedName(this.connection.getQualifiedName());
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.name("default-dbt-" + epoch + "-1")).host(hostname)).port(443)).authType("token")).username("")).password(serviceToken)).connectorConfigName("atlan-connectors-dbt");
            ((DbtCrawlerBuilder)this._parameter("extraction-method", "api"))._credential(this.localCreds);
            return (B)(multiTenant ? (DbtCrawlerBuilder)this._parameter("deployment-type", "multi") : (DbtCrawlerBuilder)this._parameter("deployment-type", "single"));
        }

        public B core(String s3Bucket, String s3Prefix, String s3Region) {
            return (B)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)this._parameter("extraction-method", "core"))._parameter("deployment-type", "single"))._parameter("core-extraction-s3-bucket", s3Bucket))._parameter("core-extraction-s3-prefix", s3Prefix))._parameter("core-extraction-s3-region", s3Region));
        }

        public B enrichMaterializedAssets(boolean enabled) {
            return (B)((DbtCrawlerBuilder)this._parameter("enrich-materialised-sql-assets", "" + enabled));
        }

        public B tags(boolean include) {
            return (B)((DbtCrawlerBuilder)this._parameter("enable-dbt-tagsync", "" + include));
        }

        public B limitToConnection(String connectionQualifiedName) {
            return (B)((DbtCrawlerBuilder)this._parameter("connection-qualified-name", connectionQualifiedName));
        }

        public B include(String filter) {
            if (filter == null || filter.isEmpty()) {
                return (B)((DbtCrawlerBuilder)((DbtCrawlerBuilder)this._parameter("include-filter", "{}"))._parameter("include-filter-core", "*"));
            }
            return (B)((DbtCrawlerBuilder)((DbtCrawlerBuilder)this._parameter("include-filter", filter))._parameter("include-filter-core", filter));
        }

        public B exclude(String filter) {
            if (filter == null || filter.isEmpty()) {
                return (B)((DbtCrawlerBuilder)((DbtCrawlerBuilder)this._parameter("exclude-filter", "{}"))._parameter("exclude-filter-core", "*"));
            }
            return (B)((DbtCrawlerBuilder)((DbtCrawlerBuilder)this._parameter("exclude-filter", filter))._parameter("exclude-filter-core", filter));
        }

        @Override
        protected B metadata() {
            return (B)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)((DbtCrawlerBuilder)this._label("orchestration.atlan.com/certified", "true"))._label("orchestration.atlan.com/source", "dbt"))._label("orchestration.atlan.com/sourceCategory", "elt"))._label("orchestration.atlan.com/type", "connector"))._label("orchestration.atlan.com/verified", "true"))._label("package.argoproj.io/installer", "argopm"))._label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hdbt"))._label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com"))._label("orchestration.atlan.com/default-dbt-" + this.epoch, "true"))._label("orchestration.atlan.com/atlan-ui", "true"))._annotation("orchestration.atlan.com/allowSchedule", "true"))._annotation("orchestration.atlan.com/dependentPackage", ""))._annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6335824578705"))._annotation("orchestration.atlan.com/emoji", "\ud83d\ude80"))._annotation("orchestration.atlan.com/icon", "https://assets.atlan.com/assets/dbt-new.svg"))._annotation("orchestration.atlan.com/logo", "https://assets.atlan.com/assets/dbt-new.svg"))._annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/dbt"))._annotation("orchestration.atlan.com/name", "dbt Assets"))._annotation("orchestration.atlan.com/usecase", "crawling"))._annotation("package.argoproj.io/author", "Atlan"))._annotation("package.argoproj.io/description", "Package to crawl dbt Assets and publish to Atlan for discovery."))._annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/dbt"))._annotation("package.argoproj.io/keywords", "[\"connector\",\"crawler\",\"dbt\"]"))._annotation("package.argoproj.io/name", "@atlan/dbt"))._annotation("package.argoproj.io/registry", "https://packages.atlan.com"))._annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git"))._annotation("package.argoproj.io/support", "support@atlan.com"))._annotation("orchestration.atlan.com/atlanName", PREFIX + "-default-dbt-" + this.epoch))._parameters(Map.ofEntries(Map.entry("api-credential-guid", "{{credentialGuid}}"), Map.entry("control-config-strategy", "default"), Map.entry("connection", this.connection.toJson(this.client)))));
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DbtCrawlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DbtCrawler instance, DbtCrawlerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DbtCrawler.DbtCrawlerBuilder(super=" + super.toString() + ")";
        }
    }

    @Generated
    private static final class DbtCrawlerBuilderImpl
    extends DbtCrawlerBuilder<DbtCrawler, DbtCrawlerBuilderImpl> {
        @Generated
        private DbtCrawlerBuilderImpl() {
        }

        @Override
        @Generated
        protected DbtCrawlerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DbtCrawler build() {
            return new DbtCrawler(this);
        }
    }
}

