/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.Credential;
import com.atlan.model.assets.Connection;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class LookerCrawler
extends AbstractCrawler {
    public static final String PREFIX = AtlanPackageType.LOOKER.getValue();

    public static LookerCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName) throws AtlanException {
        return LookerCrawler.creator(client, connectionName, List.of(client.getRoleCache().getIdForName("$admin")), null, null);
    }

    public static LookerCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers) throws AtlanException {
        return ((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)LookerCrawler._internal().setup(PREFIX, "@atlan/looker", client, LookerCrawler.getConnection(client, connectionName, AtlanConnectorType.LOOKER, adminRoles, adminGroups, adminUsers, false, false, 0L, "https://www.pngrepo.com/png/354012/512/looker-icon.png"))).includeFolders(null)).excludeFolders(null)).includeProjects(null)).excludeProjects(null);
    }

    @Generated
    protected LookerCrawler(LookerCrawlerBuilder<?, ?> b) {
        super((AbstractCrawler.AbstractCrawlerBuilder<?, ?>)b);
    }

    @Generated
    public static LookerCrawlerBuilder<?, ?> _internal() {
        return new LookerCrawlerBuilderImpl();
    }

    @Generated
    public LookerCrawlerBuilder<?, ?> toBuilder() {
        return new LookerCrawlerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerCrawler)) {
            return false;
        }
        LookerCrawler other = (LookerCrawler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerCrawler;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LookerCrawler(super=" + super.toString() + ")";
    }

    public static abstract class LookerCrawlerBuilder<C extends LookerCrawler, B extends LookerCrawlerBuilder<C, B>>
    extends AbstractCrawler.AbstractCrawlerBuilder<C, B> {
        public B direct(String hostname, int port, String clientId, String clientSecret) {
            String epoch = Connection.getEpochFromQualifiedName(this.connection.getQualifiedName());
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.name("default-looker-" + epoch + "-0")).host(hostname)).port(port)).authType("resource_owner")).username(clientId)).password(clientSecret)).connectorConfigName("atlan-connectors-looker");
            return (B)((LookerCrawlerBuilder)((LookerCrawlerBuilder)this._parameter("extraction-method", "direct"))._credential(this.localCreds));
        }

        public B fieldLevelLineage(String privateKey, String privateKeyPassphrase) {
            ((Credential.CredentialBuilder)this.localCreds.extra("ssh_private_key", privateKey)).extra("passphrase", privateKeyPassphrase);
            return (B)((LookerCrawlerBuilder)((LookerCrawlerBuilder)this._parameter("use-field-level-lineage", "true"))._credential(this.localCreds));
        }

        public B includeFolders(List<String> folders) throws InvalidRequestException {
            Map<String, Map<String, String>> toInclude = AbstractCrawler.buildFlatFilter(folders);
            try {
                return (B)((LookerCrawlerBuilder)this._parameter("include-folders", Serde.allInclusiveMapper.writeValueAsString(toInclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B excludeFolders(List<String> folders) throws InvalidRequestException {
            Map<String, Map<String, String>> toExclude = AbstractCrawler.buildFlatFilter(folders);
            try {
                return (B)((LookerCrawlerBuilder)this._parameter("exclude-folders", Serde.allInclusiveMapper.writeValueAsString(toExclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B includeProjects(List<String> projects) throws InvalidRequestException {
            Map<String, Map<String, String>> toInclude = AbstractCrawler.buildFlatFilter(projects);
            try {
                return (B)((LookerCrawlerBuilder)this._parameter("include-projects", Serde.allInclusiveMapper.writeValueAsString(toInclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B excludeProjects(List<String> projects) throws InvalidRequestException {
            Map<String, Map<String, String>> toExclude = AbstractCrawler.buildFlatFilter(projects);
            try {
                return (B)((LookerCrawlerBuilder)this._parameter("exclude-projects", Serde.allInclusiveMapper.writeValueAsString(toExclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        @Override
        protected B metadata() {
            return (B)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)((LookerCrawlerBuilder)this._label("orchestration.atlan.com/certified", "true"))._label("orchestration.atlan.com/source", "looker"))._label("orchestration.atlan.com/sourceCategory", "bi"))._label("orchestration.atlan.com/type", "connector"))._label("orchestration.atlan.com/verified", "true"))._label("package.argoproj.io/installer", "argopm"))._label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hlooker"))._label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com"))._label("orchestration.atlan.com/default-looker-" + this.epoch, "true"))._label("orchestration.atlan.com/atlan-ui", "true"))._annotation("orchestration.atlan.com/allowSchedule", "true"))._annotation("orchestration.atlan.com/dependentPackage", ""))._annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6330214610193"))._annotation("orchestration.atlan.com/emoji", "\ud83d\ude80"))._annotation("orchestration.atlan.com/icon", "https://www.pngrepo.com/png/354012/512/looker-icon.png"))._annotation("orchestration.atlan.com/logo", "https://looker.com/assets/img/images/logos/looker.svg"))._annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/looker"))._annotation("orchestration.atlan.com/name", "Looker Assets"))._annotation("orchestration.atlan.com/usecase", "crawling,auto-classifications"))._annotation("package.argoproj.io/author", "Atlan"))._annotation("package.argoproj.io/description", "Package to crawl Looker assets and publish to Atlan for discovery"))._annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/looker"))._annotation("package.argoproj.io/keywords", "[\"looker\",\"bi\",\"connector\",\"crawler\",\"lookml\"]"))._annotation("package.argoproj.io/name", "@atlan/looker"))._annotation("package.argoproj.io/registry", "https://packages.atlan.com"))._annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git"))._annotation("package.argoproj.io/support", "support@atlan.com"))._annotation("orchestration.atlan.com/atlanName", PREFIX + "-default-looker-" + this.epoch))._parameters(Map.ofEntries(Map.entry("credential-guid", "{{credentialGuid}}"), Map.entry("connection", this.connection.toJson(this.client)))));
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerCrawlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerCrawler instance, LookerCrawlerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "LookerCrawler.LookerCrawlerBuilder(super=" + super.toString() + ")";
        }
    }

    @Generated
    private static final class LookerCrawlerBuilderImpl
    extends LookerCrawlerBuilder<LookerCrawler, LookerCrawlerBuilderImpl> {
        @Generated
        private LookerCrawlerBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerCrawlerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerCrawler build() {
            return new LookerCrawler(this);
        }
    }
}

