/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.fields.KeywordField;
import com.atlan.model.fields.NumericField;
import com.atlan.model.search.AuditSearch;
import com.atlan.model.search.AuditSearchResponse;
import com.atlan.model.search.IndexSearchDSL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class AuditSearchRequest
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    public static final NumericField CREATED = new NumericField("createTime", "created");
    public static final KeywordField ENTITY_ID = new KeywordField("guid", "entityId");
    public static final KeywordField ENTITY_TYPE = new KeywordField("typeName", "typeName");
    public static final KeywordField QUALIFIED_NAME = new KeywordField("qualifiedName", "entityQualifiedName");
    public static final KeywordField USER = new KeywordField("updatedBy", "user");
    public static final KeywordField ACTION = new KeywordField("action", "action");
    public static final KeywordField AGENT = new KeywordField("headers", "headers.x-atlan-agent");
    public static final KeywordField PACKAGE_NAME = new KeywordField("headers", "headers.x-atlan-agent-package-name");
    public static final KeywordField WORKFLOW_ID = new KeywordField("headers", "headers.x-atlan-agent-workflow-id");
    public static final KeywordField AGENT_ID = new KeywordField("headers", "headers.x-atlan-agent-id");
    private static final SortOptions LATEST_FIRST = CREATED.order(SortOrder.Desc);
    IndexSearchDSL dsl;
    List<String> attributes;

    public AuditSearchResponse search(AtlanClient client) throws AtlanException {
        return client.assets.auditLogs(this);
    }

    public static AuditSearchRequestBuilder<?, ?> byGuid(AtlanClient client, String guid, int size) {
        return ((AuditSearch.AuditSearchBuilder)((AuditSearch.AuditSearchBuilder)((AuditSearch.AuditSearchBuilder)AuditSearch.builder(client).where(ENTITY_ID.eq(guid))).pageSize(size)).sort(LATEST_FIRST)).toRequestBuilder();
    }

    public static AuditSearchRequestBuilder<?, ?> byQualifiedName(AtlanClient client, String typeName, String qualifiedName, int size) {
        return ((AuditSearch.AuditSearchBuilder)((AuditSearch.AuditSearchBuilder)((AuditSearch.AuditSearchBuilder)((AuditSearch.AuditSearchBuilder)AuditSearch.builder(client).where(QUALIFIED_NAME.eq(qualifiedName))).where(ENTITY_TYPE.eq(typeName))).pageSize(size)).sort(LATEST_FIRST)).toRequestBuilder();
    }

    public static AuditSearchRequestBuilder<?, ?> byUser(AtlanClient client, String userName, int size) {
        return ((AuditSearch.AuditSearchBuilder)((AuditSearch.AuditSearchBuilder)((AuditSearch.AuditSearchBuilder)AuditSearch.builder(client).where(USER.eq(userName))).pageSize(size)).sort(LATEST_FIRST)).toRequestBuilder();
    }

    public static AuditSearchRequestBuilder<?, ?> byAction(AtlanClient client, String action, int size) {
        return ((AuditSearch.AuditSearchBuilder)((AuditSearch.AuditSearchBuilder)((AuditSearch.AuditSearchBuilder)AuditSearch.builder(client).where(ACTION.eq(action))).pageSize(size)).sort(LATEST_FIRST)).toRequestBuilder();
    }

    @Generated
    protected AuditSearchRequest(AuditSearchRequestBuilder<?, ?> b) {
        super(b);
        this.dsl = b.dsl;
        this.attributes = switch (b.attributes == null ? 0 : b.attributes.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.attributes.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.attributes));
        };
    }

    @Generated
    public static AuditSearchRequestBuilder<?, ?> builder() {
        return new AuditSearchRequestBuilderImpl();
    }

    @Generated
    public AuditSearchRequestBuilder<?, ?> toBuilder() {
        return new AuditSearchRequestBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public IndexSearchDSL getDsl() {
        return this.dsl;
    }

    @Generated
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditSearchRequest)) {
            return false;
        }
        AuditSearchRequest other = (AuditSearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexSearchDSL this$dsl = this.getDsl();
        IndexSearchDSL other$dsl = other.getDsl();
        if (this$dsl == null ? other$dsl != null : !((Object)this$dsl).equals(other$dsl)) {
            return false;
        }
        List<String> this$attributes = this.getAttributes();
        List<String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuditSearchRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        IndexSearchDSL $dsl = this.getDsl();
        result = result * 59 + ($dsl == null ? 43 : ((Object)$dsl).hashCode());
        List<String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AuditSearchRequest(super=" + super.toString() + ", dsl=" + String.valueOf(this.getDsl()) + ", attributes=" + String.valueOf(this.getAttributes()) + ")";
    }

    @Generated
    public static abstract class AuditSearchRequestBuilder<C extends AuditSearchRequest, B extends AuditSearchRequestBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private IndexSearchDSL dsl;
        @Generated
        private ArrayList<String> attributes;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AuditSearchRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AuditSearchRequest instance, AuditSearchRequestBuilder<?, ?> b) {
            b.dsl(instance.dsl);
            b.attributes(instance.attributes == null ? Collections.emptyList() : instance.attributes);
        }

        @Generated
        public B dsl(IndexSearchDSL dsl) {
            this.dsl = dsl;
            return (B)this.self();
        }

        @Generated
        public B attribute(String attribute) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(attribute);
            return (B)this.self();
        }

        @Generated
        public B attributes(Collection<? extends String> attributes) {
            if (attributes == null) {
                throw new NullPointerException("attributes cannot be null");
            }
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.addAll(attributes);
            return (B)this.self();
        }

        @Generated
        public B clearAttributes() {
            if (this.attributes != null) {
                this.attributes.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AuditSearchRequest.AuditSearchRequestBuilder(super=" + super.toString() + ", dsl=" + String.valueOf(this.dsl) + ", attributes=" + String.valueOf(this.attributes) + ")";
        }
    }

    @Generated
    private static final class AuditSearchRequestBuilderImpl
    extends AuditSearchRequestBuilder<AuditSearchRequest, AuditSearchRequestBuilderImpl> {
        @Generated
        private AuditSearchRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected AuditSearchRequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AuditSearchRequest build() {
            return new AuditSearchRequest(this);
        }
    }
}

