/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.search.AggregationResult;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.SearchLogEntry;
import com.atlan.model.search.SearchLogRequest;
import com.atlan.net.ApiResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchLogResponse
extends ApiResource
implements Iterable<SearchLogEntry> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchLogResponse.class);
    private static final long serialVersionUID = 2L;
    private static final long MASS_EXTRACT_THRESHOLD = 9700L;
    private static final int CHARACTERISTICS = 1296;
    @JsonIgnore
    AtlanClient client;
    SearchLogRequest searchParameters;
    @JsonProperty(value="logs")
    List<SearchLogEntry> logEntries;
    Long approximateCount;
    Map<String, AggregationResult> aggregations;

    @JsonIgnore
    public SearchLogResponse getNextPage() throws AtlanException {
        AtlanObject dsl = this.getSearchParameters().getDsl();
        int from = dsl.getFrom() == null ? 0 : dsl.getFrom();
        int page = dsl.getSize() == null ? 300 : dsl.getSize();
        dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)dsl.toBuilder().from(from + page)).build();
        SearchLogRequest.SearchLogRequestBuilder<?, ?> next = SearchLogRequest.builder(dsl);
        return ((SearchLogRequest)next.build()).search(this.client);
    }

    @JsonIgnore
    public List<SearchLogEntry> getSpecificPage(int offset, int pageSize) throws AtlanException {
        AtlanObject dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)this.getSearchParameters().getDsl().toBuilder().from(offset)).size(pageSize)).build();
        SearchLogRequest.SearchLogRequestBuilder<?, ?> next = SearchLogRequest.builder((IndexSearchDSL)dsl);
        SearchLogResponse response = ((SearchLogRequest)next.build()).search(this.client);
        if (response != null && response.getLogEntries() != null) {
            return response.getLogEntries();
        }
        return Collections.emptyList();
    }

    @JsonIgnore
    protected SearchLogResponse getNextBulkPage() throws AtlanException {
        long lastRecord;
        if (this.getLogEntries() == null) {
            return this;
        }
        AtlanObject dsl = this.getSearchParameters().getDsl();
        Query query = dsl.getQuery();
        ArrayList<Query> rewrittenFilters = new ArrayList<Query>();
        boolean streamed = SearchLogResponse.presortedByTimestamp(dsl.getSort());
        if (query.isBool()) {
            BoolQuery original = query.bool();
            List filters = original.filter();
            for (Query candidate : filters) {
                if (this.isPagingTimestampQuery(candidate)) continue;
                rewrittenFilters.add(candidate);
            }
        }
        int page = dsl.getSize() == null ? 300 : dsl.getSize();
        long firstRecord = -2L;
        if (this.getLogEntries().size() > 1) {
            firstRecord = this.getLogEntries().get(0).getCreatedAt();
            lastRecord = this.getLogEntries().get(this.getLogEntries().size() - 1).getCreatedAt();
        } else {
            lastRecord = -2L;
        }
        if (streamed && firstRecord != lastRecord) {
            rewrittenFilters.add(this.getPagingTimestampQuery(lastRecord));
            BoolQuery original = query.bool();
            BoolQuery rewritten = BoolQuery.of(b -> (ObjectBuilder)b.filter(rewrittenFilters).must(original.must()).mustNot(original.mustNot()).minimumShouldMatch(original.minimumShouldMatch()).should(original.should()).boost(original.boost()));
            dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)dsl.toBuilder().from(0)).size(page)).query(rewritten._toQuery())).build();
        } else {
            int from = dsl.getFrom() == null ? 0 : dsl.getFrom();
            dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)dsl.toBuilder().from(from + this.getLogEntries().size())).size(page)).build();
        }
        return ((SearchLogRequest)SearchLogRequest.builder(dsl).build()).search(this.client);
    }

    private boolean isPagingTimestampQuery(Query candidate) {
        return candidate.isRange() && candidate.range().untyped().field().equals(SearchLogEntry.LOGGED_AT.getNumericFieldName()) && candidate.range().untyped().gte() != null && (Long)((JsonData)candidate.range().untyped().gte()).to(Long.class) > 0L && candidate.range().untyped().lt() == null && candidate.range().untyped().lte() == null;
    }

    private Query getPagingTimestampQuery(long lastTimestamp) {
        return SearchLogEntry.LOGGED_AT.gte(lastTimestamp);
    }

    private SearchLogResponse getFirstPageTimestampOrdered() throws AtlanException {
        AtlanObject dsl = this.getSearchParameters().getDsl();
        List<SortOptions> revisedSort = SearchLogResponse.sortByTimestampFirst(dsl.getSort());
        int page = dsl.getSize() == null ? 300 : dsl.getSize();
        dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)dsl.toBuilder().from(0)).size(page)).clearSort()).sort(revisedSort)).build();
        return ((SearchLogRequest)SearchLogRequest.builder(dsl).build()).search(this.client);
    }

    @Override
    public Iterator<SearchLogEntry> iterator() {
        return new SearchLogResponseIterator(this);
    }

    public Iterator<SearchLogEntry> biterator() {
        return new SearchLogResponseBulkIterator(this);
    }

    @Override
    public Spliterator<SearchLogEntry> spliterator() {
        Integer pageSize = this.getSearchParameters().getDsl().getSize();
        if (pageSize == null) {
            pageSize = 50;
        }
        SearchLogResponseSpliterator spliterator = new SearchLogResponseSpliterator(this, 0L, this.getApproximateCount(), pageSize.intValue());
        List<Object> entries = this.getLogEntries() == null ? Collections.emptyList() : this.getLogEntries();
        spliterator.firstPage = entries.spliterator();
        return spliterator;
    }

    public Stream<SearchLogEntry> stream() {
        if (this.approximateCount > 9700L) {
            log.debug("Results size exceeds threshold ({}), rewriting stream as a bulk stream (ignoring original sorting).", (Object)9700L);
            return this.bulkStream();
        }
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.approximateCount, 1296), false);
    }

    public Stream<SearchLogEntry> parallelStream() {
        if (this.approximateCount > 9700L) {
            log.debug("Results size exceeds threshold ({}), ignoring request for parallelized streaming and falling back to bulk streaming.", (Object)9700L);
            return this.bulkStream();
        }
        return StreamSupport.stream(this::spliterator, 1296, true);
    }

    public Stream<SearchLogEntry> bulkStream() {
        return StreamSupport.stream(Spliterators.spliterator(this.biterator(), (long)this.approximateCount, 1296), false);
    }

    public static boolean presortedByTimestamp(List<SortOptions> sort) {
        return sort != null && !sort.isEmpty() && sort.get(0).isField() && sort.get(0).field().field().equals(SearchLogEntry.LOGGED_AT.getNumericFieldName()) && sort.get(0).field().order() == SortOrder.Asc;
    }

    public static boolean hasUserRequestedSort(List<SortOptions> sort) {
        if (SearchLogResponse.presortedByTimestamp(sort)) {
            return false;
        }
        if (sort != null && !sort.isEmpty() && sort.get(0).isField()) {
            String fieldName = sort.get(0).field().field();
            return !fieldName.equals(SearchLogEntry.ENTITY_ID.getAtlanFieldName()) || sort.size() != 1;
        }
        return true;
    }

    public static List<SortOptions> sortByTimestampFirst(List<SortOptions> sort) {
        if (sort == null || sort.isEmpty()) {
            return List.of(SearchLogEntry.LOGGED_AT.order(SortOrder.Asc));
        }
        ArrayList<SortOptions> rewritten = new ArrayList<SortOptions>();
        rewritten.add(SearchLogEntry.LOGGED_AT.order(SortOrder.Asc));
        for (SortOptions candidate : sort) {
            if (candidate.isField() && candidate.field().field().equals(SearchLogEntry.LOGGED_AT.getNumericFieldName())) continue;
            rewritten.add(candidate);
        }
        return rewritten;
    }

    @Generated
    public AtlanClient getClient() {
        return this.client;
    }

    @Generated
    public SearchLogRequest getSearchParameters() {
        return this.searchParameters;
    }

    @Generated
    public List<SearchLogEntry> getLogEntries() {
        return this.logEntries;
    }

    @Generated
    public Long getApproximateCount() {
        return this.approximateCount;
    }

    @Generated
    public Map<String, AggregationResult> getAggregations() {
        return this.aggregations;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchLogResponse)) {
            return false;
        }
        SearchLogResponse other = (SearchLogResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$approximateCount = this.getApproximateCount();
        Long other$approximateCount = other.getApproximateCount();
        if (this$approximateCount == null ? other$approximateCount != null : !((Object)this$approximateCount).equals(other$approximateCount)) {
            return false;
        }
        AtlanClient this$client = this.getClient();
        AtlanClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        SearchLogRequest this$searchParameters = this.getSearchParameters();
        SearchLogRequest other$searchParameters = other.getSearchParameters();
        if (this$searchParameters == null ? other$searchParameters != null : !((Object)this$searchParameters).equals(other$searchParameters)) {
            return false;
        }
        List<SearchLogEntry> this$logEntries = this.getLogEntries();
        List<SearchLogEntry> other$logEntries = other.getLogEntries();
        if (this$logEntries == null ? other$logEntries != null : !((Object)this$logEntries).equals(other$logEntries)) {
            return false;
        }
        Map<String, AggregationResult> this$aggregations = this.getAggregations();
        Map<String, AggregationResult> other$aggregations = other.getAggregations();
        return !(this$aggregations == null ? other$aggregations != null : !((Object)this$aggregations).equals(other$aggregations));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SearchLogResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $approximateCount = this.getApproximateCount();
        result = result * 59 + ($approximateCount == null ? 43 : ((Object)$approximateCount).hashCode());
        AtlanClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        SearchLogRequest $searchParameters = this.getSearchParameters();
        result = result * 59 + ($searchParameters == null ? 43 : ((Object)$searchParameters).hashCode());
        List<SearchLogEntry> $logEntries = this.getLogEntries();
        result = result * 59 + ($logEntries == null ? 43 : ((Object)$logEntries).hashCode());
        Map<String, AggregationResult> $aggregations = this.getAggregations();
        result = result * 59 + ($aggregations == null ? 43 : ((Object)$aggregations).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SearchLogResponse(super=" + super.toString() + ", client=" + String.valueOf(this.getClient()) + ", searchParameters=" + String.valueOf(this.getSearchParameters()) + ", logEntries=" + String.valueOf(this.getLogEntries()) + ", approximateCount=" + this.getApproximateCount() + ", aggregations=" + String.valueOf(this.getAggregations()) + ")";
    }

    @JsonIgnore
    @Generated
    public void setClient(AtlanClient client) {
        this.client = client;
    }

    private static class SearchLogResponseIterator
    implements Iterator<SearchLogEntry> {
        private SearchLogResponse response;
        private int i;

        public SearchLogResponseIterator(SearchLogResponse response) {
            this.response = response;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.response.getLogEntries() != null && this.response.getLogEntries().size() > this.i) {
                return true;
            }
            try {
                this.response = this.response.getNextPage();
                this.i = 0;
                return this.response.getLogEntries() != null && this.response.getLogEntries().size() > this.i;
            }
            catch (AtlanException e) {
                throw new RuntimeException("Unable to iterate through all pages of search results.", e);
            }
        }

        @Override
        public SearchLogEntry next() {
            return this.response.getLogEntries().get(this.i++);
        }
    }

    private static class SearchLogResponseBulkIterator
    implements Iterator<SearchLogEntry> {
        private SearchLogResponse response;
        private final Set<Integer> processedHashes;
        private int i;

        public SearchLogResponseBulkIterator(SearchLogResponse response) {
            try {
                IndexSearchDSL dsl = response.getSearchParameters().getDsl();
                if (SearchLogResponse.presortedByTimestamp(dsl.getSort())) {
                    this.response = response;
                } else {
                    if (SearchLogResponse.hasUserRequestedSort(dsl.getSort())) {
                        throw new IllegalArgumentException("Bulk searches can only be sorted by timestamp in ascending order - you must remove your own requested sorting to run a bulk search.");
                    }
                    this.response = response.getFirstPageTimestampOrdered();
                }
            }
            catch (AtlanException e) {
                throw new RuntimeException("Unable to rewrite original query in preparation for iteration.", e);
            }
            this.processedHashes = new HashSet<Integer>();
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.response.getLogEntries() == null) {
                return false;
            }
            if (this.response.getLogEntries().size() > this.i) {
                SearchLogEntry candidate = this.response.getLogEntries().get(this.i);
                if (candidate != null && !this.processedHashes.contains(candidate.hashCode())) {
                    return true;
                }
                for (int j = this.i; j < this.response.getLogEntries().size(); ++j) {
                    candidate = this.response.getLogEntries().get(j);
                    if (candidate == null || this.processedHashes.contains(candidate.hashCode())) continue;
                    this.i = j;
                    return true;
                }
            }
            try {
                this.response = this.response.getNextBulkPage();
                this.i = 0;
                return this.response.getLogEntries() != null && this.response.getLogEntries().size() > this.i;
            }
            catch (AtlanException e) {
                throw new RuntimeException("Unable to iterate through all pages of search results.", e);
            }
        }

        @Override
        public SearchLogEntry next() {
            SearchLogEntry candidate = this.response.getLogEntries().get(this.i++);
            this.processedHashes.add(candidate.hashCode());
            return candidate;
        }
    }

    private static class SearchLogResponseSpliterator
    implements Spliterator<SearchLogEntry> {
        private final SearchLogResponse response;
        private long start;
        private final long end;
        private final long pageSize;
        private Spliterator<SearchLogEntry> firstPage;
        private Spliterator<SearchLogEntry> currentPage;

        SearchLogResponseSpliterator(SearchLogResponse response, long start, long end, long pageSize) {
            this.response = response;
            this.start = start;
            this.end = end;
            this.pageSize = pageSize;
        }

        @Override
        public boolean tryAdvance(Consumer<? super SearchLogEntry> action) {
            while (!this.ensurePage().tryAdvance(action)) {
                if (this.start >= this.end) {
                    return false;
                }
                this.currentPage = null;
            }
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super SearchLogEntry> action) {
            do {
                this.ensurePage().forEachRemaining(action);
                this.currentPage = null;
            } while (this.start < this.end);
        }

        @Override
        public Spliterator<SearchLogEntry> trySplit() {
            if (this.firstPage != null) {
                Spliterator<SearchLogEntry> fp = this.firstPage;
                this.firstPage = null;
                this.start = fp.getExactSizeIfKnown();
                return fp;
            }
            if (this.currentPage != null) {
                return this.currentPage.trySplit();
            }
            if (this.end - this.start > this.pageSize) {
                long mid = this.start + this.end >>> 1;
                if ((mid = mid / this.pageSize * this.pageSize) == this.start) {
                    mid += this.pageSize;
                }
                this.start = mid;
                return new SearchLogResponseSpliterator(this.response, this.start, this.start, this.pageSize);
            }
            return this.ensurePage().trySplit();
        }

        private Spliterator<SearchLogEntry> ensurePage() {
            if (this.firstPage != null) {
                Spliterator<SearchLogEntry> fp = this.firstPage;
                this.firstPage = null;
                this.currentPage = fp;
                this.start = fp.getExactSizeIfKnown();
                return fp;
            }
            Spliterator<SearchLogEntry> sp = this.currentPage;
            if (sp == null) {
                List<SearchLogEntry> entries;
                if (this.start >= this.end) {
                    return Spliterators.emptySpliterator();
                }
                try {
                    entries = this.response.getSpecificPage((int)this.start, (int)Math.min(this.end - this.start, this.pageSize));
                }
                catch (AtlanException e) {
                    log.warn("Unable to fetch the specific page from {} to {}", new Object[]{this.start, Math.min(this.end - this.start, this.pageSize), e});
                    entries = Collections.emptyList();
                }
                sp = entries.spliterator();
                this.start = sp.getExactSizeIfKnown() > 0L ? (this.start += sp.getExactSizeIfKnown()) : (this.start += this.pageSize);
                this.currentPage = sp;
            }
            return sp;
        }

        @Override
        public long estimateSize() {
            if (this.currentPage != null) {
                return this.currentPage.estimateSize();
            }
            return this.end - this.start;
        }

        @Override
        public int characteristics() {
            return 1296;
        }
    }
}

