/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.tasks;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.search.AggregationResult;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.tasks.AtlanTask;
import com.atlan.model.tasks.TaskSearchRequest;
import com.atlan.net.ApiResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSearchResponse
extends ApiResource
implements Iterable<AtlanTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskSearchResponse.class);
    private static final long serialVersionUID = 2L;
    private static final int CHARACTERISTICS = 17744;
    @JsonIgnore
    AtlanClient client;
    @JsonIgnore
    TaskSearchRequest request;
    List<AtlanTask> tasks;
    Map<String, AggregationResult> aggregations;
    Long approximateCount;

    @JsonIgnore
    public TaskSearchResponse getNextPage() throws AtlanException {
        AtlanObject dsl = this.getRequest().getDsl();
        int from = dsl.getFrom() == null ? 0 : dsl.getFrom();
        int page = dsl.getSize() == null ? 10 : dsl.getSize();
        dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)dsl.toBuilder().from(from + page)).build();
        TaskSearchRequest.TaskSearchRequestBuilder<?, ?> next = TaskSearchRequest.builder(dsl);
        return ((TaskSearchRequest)next.build()).search(this.client);
    }

    @JsonIgnore
    public List<AtlanTask> getSpecificPage(int offset, int pageSize) throws AtlanException {
        AtlanObject dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)this.getRequest().getDsl().toBuilder().from(offset)).size(pageSize)).build();
        TaskSearchRequest.TaskSearchRequestBuilder<?, ?> next = TaskSearchRequest.builder((IndexSearchDSL)dsl);
        TaskSearchResponse response = ((TaskSearchRequest)next.build()).search(this.client);
        if (response != null && response.getTasks() != null) {
            return response.getTasks();
        }
        return Collections.emptyList();
    }

    @Override
    public Iterator<AtlanTask> iterator() {
        return new TaskSearchResponseIterator(this);
    }

    @Override
    public Spliterator<AtlanTask> spliterator() {
        long pageSize = this.getRequest().getDsl().getSize().intValue();
        TaskSearchResponseSpliterator spliterator = new TaskSearchResponseSpliterator(this, 0L, this.getApproximateCount(), pageSize);
        List<Object> tasks = this.getTasks() == null ? Collections.emptyList() : this.getTasks();
        spliterator.firstPage = tasks.spliterator();
        return spliterator;
    }

    public Stream<AtlanTask> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.approximateCount, 17744), false);
    }

    public Stream<AtlanTask> parallelStream() {
        return StreamSupport.stream(this::spliterator, 17744, true);
    }

    @Generated
    public AtlanClient getClient() {
        return this.client;
    }

    @Generated
    public TaskSearchRequest getRequest() {
        return this.request;
    }

    @Generated
    public List<AtlanTask> getTasks() {
        return this.tasks;
    }

    @Generated
    public Map<String, AggregationResult> getAggregations() {
        return this.aggregations;
    }

    @Generated
    public Long getApproximateCount() {
        return this.approximateCount;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskSearchResponse)) {
            return false;
        }
        TaskSearchResponse other = (TaskSearchResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$approximateCount = this.getApproximateCount();
        Long other$approximateCount = other.getApproximateCount();
        if (this$approximateCount == null ? other$approximateCount != null : !((Object)this$approximateCount).equals(other$approximateCount)) {
            return false;
        }
        AtlanClient this$client = this.getClient();
        AtlanClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        TaskSearchRequest this$request = this.getRequest();
        TaskSearchRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        List<AtlanTask> this$tasks = this.getTasks();
        List<AtlanTask> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        Map<String, AggregationResult> this$aggregations = this.getAggregations();
        Map<String, AggregationResult> other$aggregations = other.getAggregations();
        return !(this$aggregations == null ? other$aggregations != null : !((Object)this$aggregations).equals(other$aggregations));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskSearchResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $approximateCount = this.getApproximateCount();
        result = result * 59 + ($approximateCount == null ? 43 : ((Object)$approximateCount).hashCode());
        AtlanClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        TaskSearchRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        List<AtlanTask> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        Map<String, AggregationResult> $aggregations = this.getAggregations();
        result = result * 59 + ($aggregations == null ? 43 : ((Object)$aggregations).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "TaskSearchResponse(super=" + super.toString() + ", client=" + String.valueOf(this.getClient()) + ", request=" + String.valueOf(this.getRequest()) + ", tasks=" + String.valueOf(this.getTasks()) + ", aggregations=" + String.valueOf(this.getAggregations()) + ", approximateCount=" + this.getApproximateCount() + ")";
    }

    @JsonIgnore
    @Generated
    public void setClient(AtlanClient client) {
        this.client = client;
    }

    @JsonIgnore
    @Generated
    public void setRequest(TaskSearchRequest request) {
        this.request = request;
    }

    private static class TaskSearchResponseIterator
    implements Iterator<AtlanTask> {
        private TaskSearchResponse response;
        private int i;

        public TaskSearchResponseIterator(TaskSearchResponse response) {
            this.response = response;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.response.getTasks() != null && this.response.getTasks().size() > this.i) {
                return true;
            }
            try {
                this.response = this.response.getNextPage();
                this.i = 0;
                return this.response.getTasks() != null && this.response.getTasks().size() > this.i;
            }
            catch (AtlanException e) {
                throw new RuntimeException("Unable to iterate through all pages of search results.", e);
            }
        }

        @Override
        public AtlanTask next() {
            return this.response.getTasks().get(this.i++);
        }
    }

    private static class TaskSearchResponseSpliterator
    implements Spliterator<AtlanTask> {
        private final TaskSearchResponse response;
        private long start;
        private final long end;
        private final long pageSize;
        private Spliterator<AtlanTask> firstPage;
        private Spliterator<AtlanTask> currentPage;

        TaskSearchResponseSpliterator(TaskSearchResponse response, long start, long end, long pageSize) {
            this.response = response;
            this.start = start;
            this.end = end;
            this.pageSize = pageSize;
        }

        @Override
        public boolean tryAdvance(Consumer<? super AtlanTask> action) {
            while (!this.ensurePage().tryAdvance(action)) {
                if (this.start >= this.end) {
                    return false;
                }
                this.currentPage = null;
            }
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super AtlanTask> action) {
            do {
                this.ensurePage().forEachRemaining(action);
                this.currentPage = null;
            } while (this.start < this.end);
        }

        @Override
        public Spliterator<AtlanTask> trySplit() {
            if (this.firstPage != null) {
                Spliterator<AtlanTask> fp = this.firstPage;
                this.firstPage = null;
                this.start = fp.getExactSizeIfKnown();
                return fp;
            }
            if (this.currentPage != null) {
                return this.currentPage.trySplit();
            }
            if (this.end - this.start > this.pageSize) {
                long mid = this.start + this.end >>> 1;
                if ((mid = mid / this.pageSize * this.pageSize) == this.start) {
                    mid += this.pageSize;
                }
                this.start = mid;
                return new TaskSearchResponseSpliterator(this.response, this.start, this.start, this.pageSize);
            }
            return this.ensurePage().trySplit();
        }

        private Spliterator<AtlanTask> ensurePage() {
            if (this.firstPage != null) {
                Spliterator<AtlanTask> fp = this.firstPage;
                this.firstPage = null;
                this.currentPage = fp;
                this.start = fp.getExactSizeIfKnown();
                return fp;
            }
            Spliterator<AtlanTask> sp = this.currentPage;
            if (sp == null) {
                List<AtlanTask> tasks;
                if (this.start >= this.end) {
                    return Spliterators.emptySpliterator();
                }
                try {
                    tasks = this.response.getSpecificPage((int)this.start, (int)Math.min(this.end - this.start, this.pageSize));
                }
                catch (AtlanException e) {
                    log.warn("Unable to fetch the specific page from {} to {}", new Object[]{this.start, Math.min(this.end - this.start, this.pageSize), e});
                    tasks = Collections.emptyList();
                }
                sp = tasks.spliterator();
                this.start = sp.getExactSizeIfKnown() > 0L ? (this.start += sp.getExactSizeIfKnown()) : (this.start += this.pageSize);
                this.currentPage = sp;
            }
            return sp;
        }

        @Override
        public long estimateSize() {
            if (this.currentPage != null) {
                return this.currentPage.estimateSize();
            }
            return this.end - this.start;
        }

        @Override
        public int characteristics() {
            return 17744;
        }
    }
}

