/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.exception.ApiConnectionException;
import com.atlan.exception.ErrorCode;
import com.atlan.net.AtlanEventStreamResponse;
import com.atlan.net.AtlanRequest;
import com.atlan.net.AtlanResponse;
import com.atlan.net.AtlanResponseStream;
import com.atlan.net.HttpClient;
import com.atlan.net.HttpHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpURLConnectionClient
extends HttpClient {
    @Override
    public AtlanResponseStream requestStream(AtlanRequest request) throws ApiConnectionException {
        try {
            HttpURLConnection conn = HttpURLConnectionClient.createAtlanConnection(request);
            int responseCode = conn.getResponseCode();
            HttpHeaders headers = HttpHeaders.of(conn.getHeaderFields());
            InputStream responseStream = responseCode >= 200 && responseCode < 300 ? conn.getInputStream() : conn.getErrorStream();
            return new AtlanResponseStream(responseCode, headers, responseStream);
        }
        catch (IOException e) {
            throw new ApiConnectionException(ErrorCode.CONNECTION_ERROR, (Throwable)e, request.client().getBaseUrl());
        }
    }

    @Override
    public AtlanResponse request(AtlanRequest request) throws ApiConnectionException {
        AtlanResponseStream responseStream = this.requestStream(request);
        try {
            return responseStream.unstream();
        }
        catch (IOException e) {
            throw new ApiConnectionException(ErrorCode.CONNECTION_ERROR, (Throwable)e, request.client().getBaseUrl());
        }
    }

    @Override
    public AtlanEventStreamResponse requestES(AtlanRequest request) throws ApiConnectionException {
        AtlanResponseStream responseStream = this.requestStream(request);
        try {
            return responseStream.toEvents();
        }
        catch (IOException e) {
            throw new ApiConnectionException(ErrorCode.CONNECTION_ERROR, (Throwable)e, request.client().getBaseUrl());
        }
    }

    static HttpHeaders getHeaders(AtlanRequest request) {
        HashMap<String, List<String>> userAgentHeadersMap = new HashMap<String, List<String>>();
        userAgentHeadersMap.put("User-Agent", List.of(HttpURLConnectionClient.buildUserAgentString(request.client())));
        userAgentHeadersMap.put("X-Atlan-Client-User-Agent", List.of(HttpURLConnectionClient.buildXAtlanClientUserAgentString(request.client())));
        userAgentHeadersMap.put("x-atlan-client-origin", List.of("product_sdk"));
        return request.headers().withAdditionalHeaders(request.client().getExtraHeaders()).withAdditionalHeaders(userAgentHeadersMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection createAtlanConnection(final AtlanRequest request) throws IOException, ApiConnectionException {
        HttpURLConnection conn = null;
        if (request.options().getConnectionProxy() != null) {
            conn = (HttpURLConnection)request.url().openConnection(request.options().getConnectionProxy());
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return request.options().getProxyCredential();
                }
            });
        } else {
            conn = (HttpURLConnection)request.url().openConnection();
        }
        conn.setConnectTimeout(request.options().getConnectTimeout());
        conn.setReadTimeout(request.options().getReadTimeout());
        conn.setUseCaches(false);
        for (Map.Entry<String, List<String>> entry : HttpURLConnectionClient.getHeaders(request).map().entrySet()) {
            conn.setRequestProperty(entry.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
        }
        conn.setRequestMethod(request.method().name());
        if (request.content() != null) {
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", request.content().contentType());
            OutputStream output = conn.getOutputStream();
            try {
                output.write(request.content().byteArrayContent());
            }
            finally {
                if (Collections.singletonList(output).get(0) != null) {
                    output.close();
                }
            }
        }
        return conn;
    }
}

