/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.AtlanClient;
import com.atlan.cache.ReflectionCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.IndistinctAsset;
import com.atlan.model.assets.LineageRef;
import com.atlan.model.assets.Meaning;
import com.atlan.model.core.AtlanTag;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.serde.Serde;
import com.atlan.util.JacksonUtils;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetDeserializer
extends StdDeserializer<Asset> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetDeserializer.class);
    private static final long serialVersionUID = 2L;
    private final AtlanClient client;

    public AssetDeserializer(AtlanClient client) {
        this(Asset.class, client);
    }

    public AssetDeserializer(Class<?> t, AtlanClient client) {
        super(t);
        this.client = client;
    }

    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(parser, context);
    }

    public Asset deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        return this.deserialize((JsonNode)parser.getCodec().readTree(parser), Long.MAX_VALUE);
    }

    Asset deserialize(JsonNode root, long minimumTime) throws IOException {
        Object value;
        Method method;
        Object deserializeName;
        Iterator itr;
        List<LineageRef> immediateDownstream;
        List<LineageRef> immediateUpstream;
        TreeSet<String> pendingTasks;
        TreeSet<Meaning> meanings;
        TreeSet<String> meaningNames;
        Class assetClass;
        Asset.AssetBuilder builder;
        JsonNode attributes = root.get("attributes");
        JsonNode relationshipGuid = root.get("relationshipGuid");
        JsonNode relationshipAttributes = root.get("relationshipAttributes");
        JsonNode businessAttributes = root.get("businessAttributes");
        JsonNode classificationNames = root.get("classificationNames");
        JsonNode typeNameJson = root.get("typeName");
        String typeName = null;
        if (typeNameJson == null || typeNameJson.isNull()) {
            builder = IndistinctAsset._internal();
            assetClass = IndistinctAsset.class;
        } else {
            typeName = root.get("typeName").asText();
            try {
                assetClass = Serde.getAssetClassForType(typeName);
                Method method2 = assetClass.getMethod("_internal", new Class[0]);
                Object result = method2.invoke(null, new Object[0]);
                builder = (Asset.AssetBuilder)result;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Unable to dynamically retrieve asset for typeName {}, falling back to an IndistinctAsset.", (Object)typeName, (Object)e);
                builder = IndistinctAsset._internal();
                assetClass = IndistinctAsset.class;
            }
        }
        ((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)builder.typeName(JacksonUtils.deserializeString(root, "typeName"))).guid(JacksonUtils.deserializeString(root, "guid"))).displayText(JacksonUtils.deserializeString(root, "displayText"))).entityStatus(JacksonUtils.deserializeString(root, "entityStatus"))).relationshipType(JacksonUtils.deserializeString(root, "relationshipType"))).relationshipGuid(JacksonUtils.deserializeString(root, "relationshipGuid"))).relationshipStatus(JacksonUtils.deserializeObject(this.client, root, "relationshipStatus", new TypeReference<AtlanStatus>(){}))).uniqueAttributes(JacksonUtils.deserializeObject(this.client, root, "uniqueAttributes", new TypeReference<UniqueAttributes>(){}))).status(JacksonUtils.deserializeObject(this.client, root, "status", new TypeReference<AtlanStatus>(){}))).createdBy(JacksonUtils.deserializeString(root, "createdBy"))).updatedBy(JacksonUtils.deserializeString(root, "updatedBy"))).createTime(JacksonUtils.deserializeLong(root, "createTime"))).updateTime(JacksonUtils.deserializeLong(root, "updateTime"))).deleteHandler(JacksonUtils.deserializeString(root, "deleteHandler"))).isIncomplete(JacksonUtils.deserializeBoolean(root, "isIncomplete"))).depth(JacksonUtils.deserializeLong(root, "depth"));
        Set<AtlanTag> atlanTags = JacksonUtils.deserializeObject(this.client, root, "classifications", new TypeReference<Set<AtlanTag>>(){});
        if (atlanTags != null) {
            builder.atlanTags(atlanTags);
        }
        if ((meaningNames = JacksonUtils.deserializeObject(this.client, root, "meaningNames", new TypeReference<TreeSet<String>>(){})) != null) {
            builder.meaningNames(meaningNames);
        }
        if ((meanings = JacksonUtils.deserializeObject(this.client, root, "meanings", new TypeReference<TreeSet<Meaning>>(){})) != null) {
            builder.meanings(meanings);
        }
        if ((pendingTasks = JacksonUtils.deserializeObject(this.client, root, "pendingTasks", new TypeReference<TreeSet<String>>(){})) != null) {
            builder.pendingTasks(pendingTasks);
        }
        if ((immediateUpstream = JacksonUtils.deserializeObject(this.client, root, "immediateUpstream", new TypeReference<List<LineageRef>>(){})) != null) {
            builder.immediateUpstream(immediateUpstream);
        }
        if ((immediateDownstream = JacksonUtils.deserializeObject(this.client, root, "immediateDownstream", new TypeReference<List<LineageRef>>(){})) != null) {
            builder.immediateDownstream(immediateDownstream);
        }
        TreeMap customAttributes = JacksonUtils.deserializeObject(this.client, root, "customAttributes", new TypeReference<TreeMap<String, String>>(){});
        Class<?> builderClass = builder.getClass();
        HashMap<String, JsonNode> leftOverAttributes = new HashMap<String, JsonNode>();
        HashSet<Object> processedAttributes = new HashSet<Object>();
        if ((relationshipGuid == null || relationshipGuid.isNull()) && relationshipAttributes != null && !relationshipAttributes.isNull()) {
            itr = relationshipAttributes.fieldNames();
            while (itr.hasNext()) {
                String relnKey = (String)itr.next();
                deserializeName = ReflectionCache.getDeserializedName(assetClass, relnKey);
                method = ReflectionCache.getSetter(builderClass, (String)deserializeName);
                if (method == null) continue;
                try {
                    value = Serde.deserialize(this.client, relationshipAttributes.get(relnKey), method, (String)deserializeName);
                    boolean set = ReflectionCache.setValue(builder, (String)deserializeName, value);
                    if (!set) continue;
                    processedAttributes.add(deserializeName);
                }
                catch (NoSuchMethodException e) {
                    throw new IOException("Missing fromValue method for enum.", e);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IOException("Failed to deserialize through reflection.", e);
                }
            }
        }
        if (attributes != null && !attributes.isNull()) {
            itr = attributes.fieldNames();
            while (itr.hasNext()) {
                String attrKey = (String)itr.next();
                deserializeName = ReflectionCache.getDeserializedName(assetClass, attrKey);
                if (processedAttributes.contains(deserializeName)) continue;
                method = ReflectionCache.getSetter(builderClass, (String)deserializeName);
                if (method != null) {
                    if (((String)deserializeName).equals("assetIcon") && typeName != null && (typeName.equals("Catalog") || typeName.equals("CustomEntity"))) {
                        value = attributes.get(attrKey);
                        if (value == null || value.isNull()) continue;
                        builder.iconUrl(value.asText());
                        continue;
                    }
                    try {
                        value = Serde.deserialize(this.client, attributes.get(attrKey), method, (String)deserializeName);
                        ReflectionCache.setValue(builder, (String)deserializeName, value);
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        throw new IOException("Missing fromValue method for enum.", e);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new IOException("Failed to deserialize through reflection.", e);
                    }
                }
                leftOverAttributes.put(attrKey, attributes.get(attrKey));
            }
        }
        Map<String, CustomMetadataAttributes> cm = null;
        if (!leftOverAttributes.isEmpty()) {
            JsonNode caSearch;
            try {
                cm = this.client.getCustomMetadataCache().getCustomMetadataFromSearchResult(leftOverAttributes, minimumTime);
            }
            catch (AtlanException e) {
                throw new IOException(e);
            }
            if (leftOverAttributes.containsKey("__customAttributes") && (caSearch = (JsonNode)leftOverAttributes.get("__customAttributes")) != null && !caSearch.isNull()) {
                customAttributes = (TreeMap)Serde.allInclusiveMapper.readValue(caSearch.asText(), (TypeReference)new TypeReference<TreeMap<String, String>>(){});
            }
        }
        if (customAttributes != null) {
            builder.customAttributes(customAttributes);
        }
        if (businessAttributes != null) {
            try {
                cm = this.client.getCustomMetadataCache().getCustomMetadataFromBusinessAttributes(businessAttributes, minimumTime);
            }
            catch (AtlanException e) {
                throw new IOException(e);
            }
        }
        HashSet<String> clsNames = null;
        if (classificationNames != null && classificationNames.isArray()) {
            clsNames = new HashSet<String>();
            for (JsonNode element : classificationNames) {
                String tagId = element.asText();
                String name = null;
                try {
                    name = this.client.getAtlanTagCache().getNameForSid(tagId, minimumTime);
                }
                catch (NotFoundException e) {
                    log.debug("Unable to find tag with ID {}, deserializing as {}.", new Object[]{tagId, "(DELETED)", e});
                }
                catch (AtlanException e) {
                    throw new IOException(e);
                }
                if (name == null) {
                    name = "(DELETED)";
                }
                clsNames.add(name);
            }
        }
        if (typeName != null && typeName.equals("Readme")) {
            builder.description(StringUtils.decodeContent(((Asset)builder.build()).getDescription()));
        }
        if (cm != null) {
            builder.customMetadataSets(cm);
        }
        if (clsNames != null) {
            builder.atlanTagNames(clsNames);
        }
        Reference result = builder.build();
        result.setRawJsonObject(root);
        return result;
    }
}

