/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.AtlanClient;
import com.atlan.cache.ReflectionCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.CustomEntity;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.relations.Reference;
import com.atlan.serde.Removable;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;

public class AssetSerializer
extends StdSerializer<Asset> {
    private static final long serialVersionUID = 2L;
    private final AtlanClient client;

    public AssetSerializer(AtlanClient client) {
        this(Asset.class, client);
    }

    public AssetSerializer(Class<Asset> t, AtlanClient client) {
        super(t);
        this.client = client;
    }

    public void serializeWithType(Asset value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(value, gen, serializers);
    }

    public void serialize(Asset asset, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
        Class<?> clazz = asset.getClass();
        Set<String> nullFields = asset.getNullFields();
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        LinkedHashMap appendRelationships = new LinkedHashMap();
        LinkedHashMap removeRelationships = new LinkedHashMap();
        LinkedHashMap<String, Map<String, Object>> businessAttributes = new LinkedHashMap<String, Map<String, Object>>();
        gen.writeStartObject();
        try {
            for (String fieldName : ReflectionCache.getFieldNames(clazz)) {
                ArrayList<String> attrValue;
                if (ReflectionCache.isAttribute(clazz, fieldName)) {
                    boolean skip;
                    Class<?> type = ReflectionCache.getFieldType(clazz, fieldName);
                    attrValue = nullFields.contains(fieldName) ? (type == List.class || type == Set.class || type == SortedSet.class ? Removable.EMPTY_LIST : Removable.NULL) : ReflectionCache.getValue(asset, fieldName);
                    if (attrValue == null || (skip = attrValue instanceof Collection && ((Collection)attrValue).isEmpty() || attrValue instanceof Map && ((Map)((Object)attrValue)).isEmpty())) continue;
                    if (fieldName.equals("mappedAtlanTagName")) {
                        String mappedName;
                        try {
                            mappedName = this.client.getAtlanTagCache().getSidForName(((Object)attrValue).toString());
                        }
                        catch (NotFoundException e) {
                            mappedName = "(DELETED)";
                        }
                        catch (AtlanException e) {
                            throw new IOException("Unable to serialize mappedAtlanTagName.", e);
                        }
                        if (mappedName == null) {
                            mappedName = "(DELETED)";
                        }
                        attrValue = mappedName;
                    } else if (fieldName.equals("purposeAtlanTags") && attrValue instanceof Collection) {
                        ArrayList<String> mappedNames = new ArrayList<String>();
                        for (Object one : (Collection)attrValue) {
                            try {
                                String name = this.client.getAtlanTagCache().getSidForName(one.toString());
                                if (name == null) {
                                    name = "(DELETED)";
                                }
                                mappedNames.add(name);
                            }
                            catch (NotFoundException e) {
                                mappedNames.add("(DELETED)");
                            }
                            catch (AtlanException e) {
                                throw new IOException("Unable to serialize purposeAtlanTags.", e);
                            }
                        }
                        attrValue = mappedNames;
                    }
                    String serializeName = ReflectionCache.getSerializedName(clazz, fieldName);
                    if (attrValue instanceof Collection) {
                        Collection values = attrValue;
                        Optional first = values.stream().findFirst();
                        if (first.isPresent() && first.get() instanceof Reference) {
                            ArrayList<Reference> appends = new ArrayList<Reference>();
                            ArrayList<Reference> removes = new ArrayList<Reference>();
                            ArrayList<Reference> replace = new ArrayList<Reference>();
                            block18: for (Object value : values) {
                                Reference relationship = (Reference)value;
                                switch (relationship.getSemantic()) {
                                    case APPEND: {
                                        appends.add(relationship);
                                        continue block18;
                                    }
                                    case REMOVE: {
                                        removes.add(relationship);
                                        continue block18;
                                    }
                                }
                                replace.add(relationship);
                            }
                            if (!appends.isEmpty()) {
                                appendRelationships.put(serializeName, appends);
                            }
                            if (!removes.isEmpty()) {
                                removeRelationships.put(serializeName, removes);
                            }
                            if (replace.isEmpty()) continue;
                            attributes.put(serializeName, replace);
                            continue;
                        }
                        attributes.put(serializeName, attrValue);
                        continue;
                    }
                    if (attrValue instanceof Reference) {
                        Reference relationship = (Reference)((Object)attrValue);
                        switch (relationship.getSemantic()) {
                            case APPEND: {
                                appendRelationships.put(serializeName, attrValue);
                                break;
                            }
                            case REMOVE: {
                                removeRelationships.put(serializeName, attrValue);
                                break;
                            }
                            default: {
                                attributes.put(serializeName, attrValue);
                                break;
                            }
                        }
                        continue;
                    }
                    attributes.put(serializeName, attrValue);
                    continue;
                }
                if (fieldName.equals("customMetadataSets")) {
                    Map<String, CustomMetadataAttributes> cm = asset.getCustomMetadataSets();
                    if (cm == null || cm.isEmpty()) continue;
                    this.client.getCustomMetadataCache().getBusinessAttributesFromCustomMetadata(cm, businessAttributes);
                    continue;
                }
                attrValue = ReflectionCache.getValue(asset, fieldName);
                if (attrValue == null || attrValue instanceof Collection && ((Collection)attrValue).isEmpty() || ((Object)attrValue).equals(Collections.EMPTY_MAP) || ((Object)attrValue).equals(Collections.EMPTY_SET) || ((Object)attrValue).equals(Collections.EMPTY_LIST)) continue;
                String serializeName = ReflectionCache.getSerializedName(clazz, fieldName);
                sp.defaultSerializeField(serializeName, (Object)attrValue, gen);
            }
            String iconUrl = asset.getIconUrl();
            if (iconUrl != null && !iconUrl.isEmpty() && (asset.getTypeName().equals("Catalog") || asset instanceof CustomEntity)) {
                attributes.put("assetIcon", iconUrl);
            }
        }
        catch (AtlanException e) {
            throw new IOException(e);
        }
        if (!attributes.isEmpty()) {
            if (asset.getTypeName() != null && asset.getTypeName().equals("Readme")) {
                Object desc = attributes.get("description");
                if (desc instanceof Removable) {
                    attributes.put("description", desc);
                } else {
                    String unencoded = (String)desc;
                    attributes.put("description", StringUtils.encodeContent(unencoded));
                }
            }
            sp.defaultSerializeField("attributes", attributes, gen);
        }
        if (!appendRelationships.isEmpty()) {
            sp.defaultSerializeField("appendRelationshipAttributes", appendRelationships, gen);
        }
        if (!removeRelationships.isEmpty()) {
            sp.defaultSerializeField("removeRelationshipAttributes", removeRelationships, gen);
        }
        if (!businessAttributes.isEmpty()) {
            sp.defaultSerializeField("businessAttributes", businessAttributes, gen);
        }
        gen.writeEndObject();
    }
}

