/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.AtlanClient;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AuditActionType;
import com.atlan.model.search.AuditDetail;
import com.atlan.model.search.EntityAudit;
import com.atlan.util.JacksonUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.Map;

public class EntityAuditDeserializer
extends StdDeserializer<EntityAudit> {
    private static final long serialVersionUID = 2L;
    private final AtlanClient client;

    public EntityAuditDeserializer(AtlanClient client) {
        this(AuditDetail.class, client);
    }

    public EntityAuditDeserializer(Class<?> t, AtlanClient client) {
        super(t);
        this.client = client;
    }

    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(parser, context);
    }

    public EntityAudit deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode root = (JsonNode)parser.getCodec().readTree(parser);
        Long timestamp = JacksonUtils.deserializeLong(root, "timestamp");
        long ts = timestamp == null ? Long.MAX_VALUE : timestamp;
        Object builder = ((EntityAudit.EntityAuditBuilder)((EntityAudit.EntityAuditBuilder)((EntityAudit.EntityAuditBuilder)((EntityAudit.EntityAuditBuilder)((EntityAudit.EntityAuditBuilder)((EntityAudit.EntityAuditBuilder)((EntityAudit.EntityAuditBuilder)((EntityAudit.EntityAuditBuilder)((EntityAudit.EntityAuditBuilder)EntityAudit.builder().entityQualifiedName(JacksonUtils.deserializeString(root, "entityQualifiedName"))).typeName(JacksonUtils.deserializeString(root, "typeName"))).entityId(JacksonUtils.deserializeString(root, "entityId"))).timestamp(timestamp)).created(JacksonUtils.deserializeLong(root, "created"))).user(JacksonUtils.deserializeString(root, "user"))).action(JacksonUtils.deserializeObject(this.client, root, "action", new TypeReference<AuditActionType>(){}))).eventKey(JacksonUtils.deserializeString(root, "eventKey"))).entityDetail(JacksonUtils.deserializeObject(this.client, root, "entityDetail", new TypeReference<Asset>(){}))).headers(JacksonUtils.deserializeObject(this.client, root, "headers", new TypeReference<Map<String, String>>(){}));
        JsonNode detail = root.get("detail");
        if (detail != null && !detail.isNull()) {
            JsonNode guid = detail.get("guid");
            JsonNode attributes = detail.get("attributes");
            AtlanObject auditDetail = guid != null && guid.isTextual() ? this.client.getAssetDeserializer().deserialize(detail, ts) : (attributes != null ? this.client.getCustomMetadataAuditDeserializer().deserialize(detail, ts) : this.client.getAtlanTagDeserializer().deserialize(detail, ts));
            auditDetail.setRawJsonObject(detail);
            ((EntityAudit.EntityAuditBuilder)builder).detail((AuditDetail)((Object)auditDetail));
        }
        return ((EntityAudit.EntityAuditBuilder)builder).build();
    }
}

