/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.util;

import com.atlan.AtlanClient;
import com.atlan.cache.OffHeapAssetCache;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.AtlanCloseable;
import com.atlan.model.enums.AssetCreationHandling;
import com.atlan.util.AssetBatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ParallelBatch
implements AtlanCloseable {
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtlanClient client;
    private final int maxSize;
    private final boolean replaceAtlanTags;
    private final AssetBatch.CustomMetadataHandling customMetadataHandling;
    private final boolean captureFailures;
    private final boolean track;
    private final boolean updateOnly;
    private final boolean caseSensitive;
    private final AssetCreationHandling creationHandling;
    private final boolean tableViewAgnostic;
    private final ConcurrentHashMap<Long, AssetBatch> batchMap = new ConcurrentHashMap();
    private final List<AssetBatch.FailedBatch> failures = Collections.synchronizedList(new ArrayList());
    private final Map<String, String> resolvedGuids = new ConcurrentHashMap<String, String>();
    private final Map<AssetBatch.AssetIdentity, String> resolvedQualifiedNames = new ConcurrentHashMap<AssetBatch.AssetIdentity, String>();
    private OffHeapAssetCache created = null;
    private OffHeapAssetCache updated = null;
    private OffHeapAssetCache restored = null;
    private OffHeapAssetCache skipped = null;

    public ParallelBatch(AtlanClient client, int maxSize) {
        this(client, maxSize, false, AssetBatch.CustomMetadataHandling.IGNORE);
    }

    public ParallelBatch(AtlanClient client, int maxSize, boolean replaceAtlanTags, AssetBatch.CustomMetadataHandling customMetadataHandling) {
        this(client, maxSize, replaceAtlanTags, customMetadataHandling, false);
    }

    public ParallelBatch(AtlanClient client, int maxSize, boolean replaceAtlanTags, AssetBatch.CustomMetadataHandling customMetadataHandling, boolean captureFailures) {
        this(client, maxSize, replaceAtlanTags, customMetadataHandling, captureFailures, false);
    }

    public ParallelBatch(AtlanClient client, int maxSize, boolean replaceAtlanTags, AssetBatch.CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly) {
        this(client, maxSize, replaceAtlanTags, customMetadataHandling, captureFailures, updateOnly, true);
    }

    public ParallelBatch(AtlanClient client, int maxSize, boolean replaceAtlanTags, AssetBatch.CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track) {
        this(client, maxSize, replaceAtlanTags, customMetadataHandling, captureFailures, updateOnly, track, true);
    }

    public ParallelBatch(AtlanClient client, int maxSize, boolean replaceAtlanTags, AssetBatch.CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track, boolean caseSensitive) {
        this(client, maxSize, replaceAtlanTags, customMetadataHandling, captureFailures, updateOnly, track, caseSensitive, AssetCreationHandling.FULL);
    }

    public ParallelBatch(AtlanClient client, int maxSize, boolean replaceAtlanTags, AssetBatch.CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track, boolean caseSensitive, AssetCreationHandling creationHandling) {
        this(client, maxSize, replaceAtlanTags, customMetadataHandling, captureFailures, updateOnly, track, caseSensitive, creationHandling, false);
    }

    public ParallelBatch(AtlanClient client, int maxSize, boolean replaceAtlanTags, AssetBatch.CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track, boolean caseSensitive, AssetCreationHandling creationHandling, boolean tableViewAgnostic) {
        this.client = client;
        this.maxSize = maxSize;
        this.replaceAtlanTags = replaceAtlanTags;
        this.customMetadataHandling = customMetadataHandling;
        this.creationHandling = creationHandling;
        this.track = track;
        this.captureFailures = captureFailures;
        this.updateOnly = updateOnly;
        this.caseSensitive = caseSensitive;
        this.tableViewAgnostic = tableViewAgnostic;
    }

    public AssetMutationResponse add(Asset single) throws AtlanException {
        long id = Thread.currentThread().getId();
        AssetBatch batch = this.batchMap.computeIfAbsent(id, k -> new AssetBatch(this.client, this.maxSize, this.replaceAtlanTags, this.customMetadataHandling, this.captureFailures, this.updateOnly, this.track, !this.caseSensitive, this.creationHandling, this.tableViewAgnostic));
        return batch.add(single);
    }

    public void flush() throws AtlanException {
        this.lock.writeLock().lock();
        try {
            this.batchMap.values().forEach(batch -> {
                try {
                    batch.flush();
                }
                catch (AtlanException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumCreated() {
        this.lock.readLock().lock();
        try {
            long count = 0L;
            for (AssetBatch batch : this.batchMap.values()) {
                count += batch.getNumCreated().get();
            }
            long l = count;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumUpdated() {
        this.lock.readLock().lock();
        try {
            long count = 0L;
            for (AssetBatch batch : this.batchMap.values()) {
                count += batch.getNumUpdated().get();
            }
            long l = count;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumRestored() {
        this.lock.readLock().lock();
        try {
            long count = 0L;
            for (AssetBatch batch : this.batchMap.values()) {
                count += batch.getNumRestored().get();
            }
            long l = count;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumSkipped() {
        this.lock.readLock().lock();
        try {
            long count = 0L;
            for (AssetBatch batch : this.batchMap.values()) {
                count += batch.getNumSkipped().get();
            }
            long l = count;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffHeapAssetCache getCreated() {
        if (!this.track) {
            return null;
        }
        if (this.created == null) {
            this.lock.writeLock().lock();
            try {
                this.created = new OffHeapAssetCache(this.client, "p-created");
                for (AssetBatch batch : this.batchMap.values()) {
                    if (!batch.getCreated().isNotClosed()) continue;
                    this.created.extendedWith(batch.getCreated(), true);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            OffHeapAssetCache offHeapAssetCache = this.created;
            return offHeapAssetCache;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffHeapAssetCache getUpdated() {
        if (!this.track) {
            return null;
        }
        if (this.updated == null) {
            this.lock.writeLock().lock();
            try {
                this.updated = new OffHeapAssetCache(this.client, "p-updated");
                for (AssetBatch batch : this.batchMap.values()) {
                    if (!batch.getUpdated().isNotClosed()) continue;
                    this.updated.extendedWith(batch.getUpdated(), true);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            OffHeapAssetCache offHeapAssetCache = this.updated;
            return offHeapAssetCache;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffHeapAssetCache getRestored() {
        if (!this.track) {
            return null;
        }
        if (this.restored == null) {
            this.lock.writeLock().lock();
            try {
                this.restored = new OffHeapAssetCache(this.client, "p-restored");
                for (AssetBatch batch : this.batchMap.values()) {
                    if (!batch.getRestored().isNotClosed()) continue;
                    this.restored.extendedWith(batch.getRestored(), true);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            OffHeapAssetCache offHeapAssetCache = this.restored;
            return offHeapAssetCache;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AssetBatch.FailedBatch> getFailures() {
        boolean empty;
        this.lock.readLock().lock();
        try {
            empty = this.failures.isEmpty();
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (empty) {
            this.lock.writeLock().lock();
            try {
                for (AssetBatch batch : this.batchMap.values()) {
                    this.failures.addAll(batch.getFailures());
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            List<AssetBatch.FailedBatch> list = this.failures;
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffHeapAssetCache getSkipped() {
        if (!this.track) {
            return null;
        }
        if (this.skipped == null) {
            this.lock.writeLock().lock();
            try {
                this.skipped = new OffHeapAssetCache(this.client, "p-skipped");
                for (AssetBatch batch : this.batchMap.values()) {
                    if (!batch.getSkipped().isNotClosed()) continue;
                    this.skipped.extendedWith(batch.getSkipped(), true);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            OffHeapAssetCache offHeapAssetCache = this.skipped;
            return offHeapAssetCache;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getResolvedGuids() {
        boolean empty;
        this.lock.readLock().lock();
        try {
            empty = this.resolvedGuids.isEmpty();
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (empty) {
            this.lock.writeLock().lock();
            try {
                for (AssetBatch batch : this.batchMap.values()) {
                    this.resolvedGuids.putAll(batch.getResolvedGuids());
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            Map<String, String> map = this.resolvedGuids;
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<AssetBatch.AssetIdentity, String> getResolvedQualifiedNames() {
        boolean empty;
        this.lock.readLock().lock();
        try {
            empty = this.resolvedQualifiedNames.isEmpty();
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (empty) {
            this.lock.writeLock().lock();
            try {
                for (AssetBatch batch : this.batchMap.values()) {
                    this.resolvedQualifiedNames.putAll(batch.getResolvedQualifiedNames());
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            Map<AssetBatch.AssetIdentity, String> map = this.resolvedQualifiedNames;
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void close() {
        this.lock.writeLock().lock();
        try {
            for (AssetBatch batch : this.batchMap.values()) {
                AtlanCloseable.close(batch);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        AtlanCloseable.close(this.created);
        AtlanCloseable.close(this.updated);
        AtlanCloseable.close(this.restored);
        AtlanCloseable.close(this.skipped);
    }
}

