/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.api.HeraclesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AdminEventRequest;
import com.atlan.model.admin.AdminEventResponse;
import com.atlan.model.admin.KeycloakEventRequest;
import com.atlan.model.admin.KeycloakEventResponse;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import java.util.HashMap;

public class LogsEndpoint
extends HeraclesEndpoint {
    private static final String endpoint = "/events";
    private static final String endpoint_main = "/events/main";
    private static final String endpoint_login = "/events/login";

    public LogsEndpoint(AtlanClient client) {
        super(client);
    }

    public AdminEventResponse getAdminEvents() throws AtlanException {
        return this.getAdminEvents((RequestOptions)null);
    }

    public AdminEventResponse getAdminEvents(RequestOptions options) throws AtlanException {
        return this.getAdminEvents((AdminEventRequest)AdminEventRequest.builder().build(), options);
    }

    public AdminEventResponse getAdminEvents(AdminEventRequest request) throws AtlanException {
        return this.getAdminEvents(request, null);
    }

    public AdminEventResponse getAdminEvents(AdminEventRequest request, RequestOptions options) throws AtlanException {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        if (request.getClientId() != null) {
            queryParams.put("authClient", request.getClientId());
        }
        if (request.getIpAddress() != null) {
            queryParams.put("authIpAddress", request.getIpAddress());
        }
        if (request.getRealmId() != null) {
            queryParams.put("authRealm", request.getRealmId());
        }
        if (request.getUserId() != null) {
            queryParams.put("authUser", request.getUserId());
        }
        if (request.getDateFrom() != null) {
            queryParams.put("dateFrom", request.getDateFrom());
        }
        if (request.getDateTo() != null) {
            queryParams.put("dateTo", request.getDateTo());
        }
        queryParams.put("first", request.getOffset());
        queryParams.put("max", request.getSize());
        if (request.getOperationTypes() != null && !request.getOperationTypes().isEmpty()) {
            queryParams.put("operationTypes", request.getOperationTypes());
        }
        if (request.getResourcePath() != null) {
            queryParams.put("resourcePath", request.getResourcePath());
        }
        if (request.getResourceTypes() != null) {
            queryParams.put("resourceTypes", request.getResourceTypes());
        }
        String url = String.format("%s%s?%s", this.getBaseUrl(), endpoint_main, ApiResource.createQueryString(queryParams));
        AdminEventResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", AdminEventResponse.class, options);
        response.setRequest(request);
        response.setClient(this.client);
        return response;
    }

    public KeycloakEventResponse getEvents() throws AtlanException {
        return this.getEvents((RequestOptions)null);
    }

    public KeycloakEventResponse getEvents(RequestOptions options) throws AtlanException {
        return this.getEvents((KeycloakEventRequest)KeycloakEventRequest.builder().build(), options);
    }

    public KeycloakEventResponse getEvents(KeycloakEventRequest request) throws AtlanException {
        return this.getEvents(request, null);
    }

    public KeycloakEventResponse getEvents(KeycloakEventRequest request, RequestOptions options) throws AtlanException {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        if (request.getClient() != null) {
            queryParams.put("client", request.getClient());
        }
        if (request.getIpAddress() != null) {
            queryParams.put("ipAddress", request.getIpAddress());
        }
        if (request.getDateFrom() != null) {
            queryParams.put("dateFrom", request.getDateFrom());
        }
        if (request.getDateTo() != null) {
            queryParams.put("dateTo", request.getDateTo());
        }
        queryParams.put("first", request.getOffset());
        queryParams.put("max", request.getSize());
        if (request.getTypes() != null) {
            queryParams.put("type", request.getTypes());
        }
        if (request.getUserId() != null) {
            queryParams.put("user", request.getUserId());
        }
        String url = String.format("%s%s?%s", this.getBaseUrl(), endpoint_login, ApiResource.createQueryString(queryParams));
        KeycloakEventResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", KeycloakEventResponse.class, options);
        response.setRequest(request);
        response.setClient(this.client);
        return response;
    }
}

