/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.api.HeraclesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.AtlanGroup;
import com.atlan.model.admin.SSOMapping;
import com.atlan.model.admin.SSOProviderRequest;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import lombok.Generated;

public class SSOEndpoint
extends HeraclesEndpoint {
    private static final String endpoint = "/idp";
    public static final String GROUP_MAPPER_ATTRIBUTE = "memberOf";
    public static final String GROUP_MAPPER_SYNC_MODE = "FORCE";
    public static final String IDP_GROUP_MAPPER = "saml-group-idp-mapper";

    public SSOEndpoint(AtlanClient client) {
        super(client);
    }

    public void configure(SSOProviderRequest request) throws AtlanException {
        this.configure(request, null);
    }

    public void configure(SSOProviderRequest request, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), endpoint);
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, request, options);
    }

    public SSOMapping createMapping(String ssoAlias, SSOMapping mapping) throws AtlanException {
        return this.createMapping(ssoAlias, mapping, null);
    }

    public SSOMapping createMapping(String ssoAlias, SSOMapping mapping, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s/mappers", this.getBaseUrl(), endpoint, ssoAlias);
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, mapping, SSOMapping.class, options);
    }

    public List<SSOMapping> listGroupMappings(String ssoAlias) throws AtlanException {
        return this.listGroupMappings(ssoAlias, null);
    }

    public List<SSOMapping> listGroupMappings(String ssoAlias, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s/mappers", this.getBaseUrl(), endpoint, ssoAlias);
        WrappedMapping mapping = ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", WrappedMapping.class, options);
        return mapping != null ? mapping.getMappings() : null;
    }

    public SSOMapping getGroupMapping(String ssoAlias, String groupMapId) throws AtlanException {
        return this.getGroupMapping(ssoAlias, groupMapId, null);
    }

    public SSOMapping getGroupMapping(String ssoAlias, String groupMapId, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s/mappers/%s", this.getBaseUrl(), endpoint, ssoAlias, groupMapId);
        return ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", SSOMapping.class, options);
    }

    public SSOMapping createGroupMapping(String ssoAlias, AtlanGroup group, String ssoGroupName) throws AtlanException {
        return this.createGroupMapping(ssoAlias, group, ssoGroupName, null);
    }

    public SSOMapping createGroupMapping(String ssoAlias, AtlanGroup group, String ssoGroupName, RequestOptions options) throws AtlanException {
        this.checkExistingGroupMappings(ssoAlias, group);
        SSOMapping request = SSOMapping.builder().name(this.generateGroupMappingName(group.getId())).config(SSOMapping.Config.builder().attributes("[]").syncMode(GROUP_MAPPER_SYNC_MODE).attributeValuesRegex("").attributeName(GROUP_MAPPER_ATTRIBUTE).attributeValue(ssoGroupName).groupName(group.getName()).build()).identityProviderAlias(ssoAlias).identityProviderMapper(IDP_GROUP_MAPPER).build();
        return this.createMapping(ssoAlias, request, options);
    }

    public SSOMapping updateGroupMapping(String ssoAlias, AtlanGroup group, String groupMapId, String ssoGroupName) throws AtlanException {
        return this.updateGroupMapping(ssoAlias, group, groupMapId, ssoGroupName, null);
    }

    public SSOMapping updateGroupMapping(String ssoAlias, AtlanGroup group, String groupMapId, String ssoGroupName, RequestOptions options) throws AtlanException {
        SSOMapping request = SSOMapping.builder().id(groupMapId).config(SSOMapping.Config.builder().attributes("[]").syncMode(GROUP_MAPPER_SYNC_MODE).attributeName(GROUP_MAPPER_ATTRIBUTE).attributeValue(ssoGroupName).groupName(group.getName()).build()).identityProviderAlias(ssoAlias).identityProviderMapper(IDP_GROUP_MAPPER).build();
        String url = String.format("%s%s/%s/mappers/%s", this.getBaseUrl(), endpoint, ssoAlias, groupMapId);
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, request, SSOMapping.class, options);
    }

    public void deleteGroupMapping(String ssoAlias, String groupMapId) throws AtlanException {
        this.deleteGroupMapping(ssoAlias, groupMapId, null);
    }

    public void deleteGroupMapping(String ssoAlias, String groupMapId, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s/mappers/%s/delete", this.getBaseUrl(), endpoint, ssoAlias, groupMapId);
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, "", options);
    }

    private void checkExistingGroupMappings(String ssoAlias, AtlanGroup group) throws AtlanException {
        List<SSOMapping> existing = this.listGroupMappings(ssoAlias);
        if (existing != null) {
            for (SSOMapping mapping : existing) {
                if (mapping.getName() == null || group == null || !mapping.getName().contains(group.getId())) continue;
                throw new InvalidRequestException(ErrorCode.SSO_GROUP_MAPPING_ALREADY_EXISTS, group.getAlias(), mapping.getConfig().getAttributeValue());
            }
        }
    }

    private String generateGroupMappingName(String atlanGroupId) {
        return atlanGroupId + "--" + System.currentTimeMillis();
    }

    @JsonSerialize(using=WrappedMappingSerializer.class)
    @JsonDeserialize(using=WrappedMappingDeserializer.class)
    private static final class WrappedMapping
    extends ApiResource {
        private static final long serialVersionUID = 2L;
        List<SSOMapping> mappings;

        public WrappedMapping(List<SSOMapping> mappings) {
            this.mappings = mappings;
        }

        @Generated
        public List<SSOMapping> getMappings() {
            return this.mappings;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WrappedMapping)) {
                return false;
            }
            WrappedMapping other = (WrappedMapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<SSOMapping> this$mappings = this.getMappings();
            List<SSOMapping> other$mappings = other.getMappings();
            return !(this$mappings == null ? other$mappings != null : !((Object)this$mappings).equals(other$mappings));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WrappedMapping;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<SSOMapping> $mappings = this.getMappings();
            result = result * 59 + ($mappings == null ? 43 : ((Object)$mappings).hashCode());
            return result;
        }
    }

    private static class WrappedMappingSerializer
    extends StdSerializer<WrappedMapping> {
        private static final long serialVersionUID = 2L;
        private final transient AtlanClient client;

        public WrappedMappingSerializer(AtlanClient client) {
            this(WrappedMapping.class, client);
        }

        public WrappedMappingSerializer(Class<WrappedMapping> t, AtlanClient client) {
            super(t);
            this.client = client;
        }

        public void serialize(WrappedMapping wrappedMapping, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
            List<SSOMapping> mappings = wrappedMapping.getMappings();
            this.client.writeValue(gen, mappings);
        }
    }

    private static class WrappedMappingDeserializer
    extends StdDeserializer<WrappedMapping> {
        private static final long serialVersionUID = 2L;

        public WrappedMappingDeserializer() {
            this(WrappedMapping.class);
        }

        public WrappedMappingDeserializer(Class<?> t) {
            super(t);
        }

        public WrappedMapping deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            List mappings = (List)parser.getCodec().readValue(parser, (TypeReference)new TypeReference<List<SSOMapping>>(){});
            return new WrappedMapping(mappings);
        }
    }
}

