/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.api.HeraclesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.workflow.Workflow;
import com.atlan.model.workflow.WorkflowResponse;
import com.atlan.model.workflow.WorkflowRunResponse;
import com.atlan.model.workflow.WorkflowSearchRequest;
import com.atlan.model.workflow.WorkflowSearchResponse;
import com.atlan.model.workflow.WorkflowSearchResultDetail;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import lombok.Generated;

public class WorkflowsEndpoint
extends HeraclesEndpoint {
    private static final String workflows_endpoint = "/workflows";
    private static final String workflows_endpoint_run_existing = "/workflows/submit";
    private static final String workflows_search_endpoint = "/workflows/indexsearch";
    private static final String runs_endpoint = "/runs";
    private static final String runs_search_endpoint = "/runs/indexsearch";

    public WorkflowsEndpoint(AtlanClient client) {
        super(client);
    }

    public WorkflowResponse run(Workflow workflow) throws AtlanException {
        return this.run(workflow, null);
    }

    public WorkflowResponse run(Workflow workflow, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?submit=true", workflows_endpoint));
        WorkflowResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, workflow, WorkflowResponse.class, options);
        response.setClient(this.client);
        return response;
    }

    public WorkflowRunResponse run(WorkflowSearchResultDetail workflow) throws AtlanException {
        return this.run(workflow, null);
    }

    public WorkflowRunResponse run(WorkflowSearchResultDetail workflow, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), workflows_endpoint_run_existing);
        AtlanObject request = ((ReRunRequest.ReRunRequestBuilder)((ReRunRequest.ReRunRequestBuilder)ReRunRequest.builder().namespace(workflow.getMetadata().getNamespace())).resourceName(workflow.getSpec().getWorkflowTemplateRef().get("name"))).build();
        WorkflowRunResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, request, WorkflowRunResponse.class, options);
        response.setClient(this.client);
        return response;
    }

    public WorkflowRunResponse stop(String runName) throws AtlanException {
        return this.stop(runName, null);
    }

    public WorkflowRunResponse stop(String runName, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s/stop", this.getBaseUrl(), runs_endpoint, runName);
        WorkflowRunResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, "", WorkflowRunResponse.class, options);
        response.setClient(this.client);
        return response;
    }

    public void archive(String workflowName) throws AtlanException {
        this.archive(workflowName, null);
    }

    public void archive(String workflowName, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s/%s/archive", workflows_endpoint, workflowName));
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, "", options);
    }

    public WorkflowSearchResponse searchRuns(WorkflowSearchRequest request) throws AtlanException {
        return this.searchRuns(request, null);
    }

    public WorkflowSearchResponse searchRuns(WorkflowSearchRequest request, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), runs_search_endpoint);
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, request, WorkflowSearchResponse.class, options);
    }

    public WorkflowSearchResponse search(WorkflowSearchRequest request) throws AtlanException {
        return this.search(request, null);
    }

    public WorkflowSearchResponse search(WorkflowSearchRequest request, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), workflows_search_endpoint);
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, request, WorkflowSearchResponse.class, options);
    }

    public Workflow update(String workflowName, Workflow request) throws AtlanException {
        return this.update(workflowName, request, null);
    }

    public Workflow update(String workflowName, Workflow request, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s", this.getBaseUrl(), workflows_endpoint, workflowName);
        WrappedWorkflow response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, request, WrappedWorkflow.class, options);
        if (response != null) {
            Workflow workflow = response.getWorkflow();
            workflow.setRawJsonObject(response.getRawJsonObject());
            return workflow;
        }
        return null;
    }

    static class ReRunRequest
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        String namespace;
        String resourceKind;
        String resourceName;

        @Generated
        private static String $default$namespace() {
            return "default";
        }

        @Generated
        private static String $default$resourceKind() {
            return "WorkflowTemplate";
        }

        @Generated
        protected ReRunRequest(ReRunRequestBuilder<?, ?> b) {
            super(b);
            this.namespace = b.namespace$set ? b.namespace$value : ReRunRequest.$default$namespace();
            this.resourceKind = b.resourceKind$set ? b.resourceKind$value : ReRunRequest.$default$resourceKind();
            this.resourceName = b.resourceName;
        }

        @Generated
        public static ReRunRequestBuilder<?, ?> builder() {
            return new ReRunRequestBuilderImpl();
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public String getResourceKind() {
            return this.resourceKind;
        }

        @Generated
        public String getResourceName() {
            return this.resourceName;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReRunRequest)) {
                return false;
            }
            ReRunRequest other = (ReRunRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$resourceKind = this.getResourceKind();
            String other$resourceKind = other.getResourceKind();
            if (this$resourceKind == null ? other$resourceKind != null : !this$resourceKind.equals(other$resourceKind)) {
                return false;
            }
            String this$resourceName = this.getResourceName();
            String other$resourceName = other.getResourceName();
            return !(this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReRunRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $resourceKind = this.getResourceKind();
            result = result * 59 + ($resourceKind == null ? 43 : $resourceKind.hashCode());
            String $resourceName = this.getResourceName();
            result = result * 59 + ($resourceName == null ? 43 : $resourceName.hashCode());
            return result;
        }

        @Generated
        public static abstract class ReRunRequestBuilder<C extends ReRunRequest, B extends ReRunRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private boolean namespace$set;
            @Generated
            private String namespace$value;
            @Generated
            private boolean resourceKind$set;
            @Generated
            private String resourceKind$value;
            @Generated
            private String resourceName;

            @Generated
            public B namespace(String namespace) {
                this.namespace$value = namespace;
                this.namespace$set = true;
                return (B)this.self();
            }

            @Generated
            public B resourceKind(String resourceKind) {
                this.resourceKind$value = resourceKind;
                this.resourceKind$set = true;
                return (B)this.self();
            }

            @Generated
            public B resourceName(String resourceName) {
                this.resourceName = resourceName;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "WorkflowsEndpoint.ReRunRequest.ReRunRequestBuilder(super=" + super.toString() + ", namespace$value=" + this.namespace$value + ", resourceKind$value=" + this.resourceKind$value + ", resourceName=" + this.resourceName + ")";
            }
        }

        @Generated
        private static final class ReRunRequestBuilderImpl
        extends ReRunRequestBuilder<ReRunRequest, ReRunRequestBuilderImpl> {
            @Generated
            private ReRunRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected ReRunRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public ReRunRequest build() {
                return new ReRunRequest(this);
            }
        }
    }

    @JsonSerialize(using=WrappedWorkflowSerializer.class)
    @JsonDeserialize(using=WrappedWorkflowDeserializer.class)
    private static final class WrappedWorkflow
    extends ApiResource {
        private static final long serialVersionUID = 2L;
        Workflow workflow;

        public WrappedWorkflow(Workflow workflow) {
            this.workflow = workflow;
        }

        @Generated
        public Workflow getWorkflow() {
            return this.workflow;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WrappedWorkflow)) {
                return false;
            }
            WrappedWorkflow other = (WrappedWorkflow)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Workflow this$workflow = this.getWorkflow();
            Workflow other$workflow = other.getWorkflow();
            return !(this$workflow == null ? other$workflow != null : !((Object)this$workflow).equals(other$workflow));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WrappedWorkflow;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Workflow $workflow = this.getWorkflow();
            result = result * 59 + ($workflow == null ? 43 : ((Object)$workflow).hashCode());
            return result;
        }
    }

    private static class WrappedWorkflowSerializer
    extends StdSerializer<WrappedWorkflow> {
        private static final long serialVersionUID = 2L;
        private final transient AtlanClient client;

        public WrappedWorkflowSerializer(AtlanClient client) {
            this(WrappedWorkflow.class, client);
        }

        public WrappedWorkflowSerializer(Class<WrappedWorkflow> t, AtlanClient client) {
            super(t);
            this.client = client;
        }

        public void serialize(WrappedWorkflow wrappedWorkflow, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
            Workflow workflow = wrappedWorkflow.getWorkflow();
            this.client.writeValue(gen, workflow);
        }
    }

    private static class WrappedWorkflowDeserializer
    extends StdDeserializer<WrappedWorkflow> {
        private static final long serialVersionUID = 2L;

        public WrappedWorkflowDeserializer() {
            this(WrappedWorkflow.class);
        }

        public WrappedWorkflowDeserializer(Class<?> t) {
            super(t);
        }

        public WrappedWorkflow deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            Workflow workflow = (Workflow)parser.getCodec().readValue(parser, (TypeReference)new TypeReference<Workflow>(){});
            return new WrappedWorkflow(workflow);
        }
    }
}

