/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.cache.OffHeapObjectCache;
import com.atlan.model.assets.Asset;
import java.util.function.Predicate;

public class OffHeapAssetCache
extends OffHeapObjectCache<Asset> {
    public OffHeapAssetCache(AtlanClient client, String name) {
        super(client, name);
    }

    public void add(Asset asset) {
        this.put(asset.getGuid(), asset);
    }

    public void extendedWith(OffHeapAssetCache other, boolean closeOriginal) {
        if (other != null) {
            this.putAll(other);
            if (closeOriginal) {
                other.close();
            }
        }
    }

    public void extendedWith(OffHeapAssetCache other, boolean closeOriginal, Predicate<Asset> isValid) {
        if (other != null) {
            other.values().forEach(one -> {
                if (isValid.test((Asset)one)) {
                    this.put(one.getGuid(), one);
                }
            });
            if (closeOriginal) {
                other.close();
            }
        }
    }
}

