/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.api.RolesEndpoint;
import com.atlan.cache.AbstractMassCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.NotFoundException;
import com.atlan.model.admin.AtlanRole;
import com.atlan.model.admin.RoleResponse;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleCache
extends AbstractMassCache<AtlanRole> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoleCache.class);
    private final RolesEndpoint rolesEndpoint;

    public RoleCache(AtlanClient client) {
        super(client, "role");
        this.rolesEndpoint = client.roles;
    }

    @Override
    protected void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of roles...");
        RoleResponse response = this.rolesEndpoint.list("{\"name\":{\"$ilike\":\"$%\"}}");
        if (response == null || response.getRecords().isEmpty()) {
            throw new NotFoundException(ErrorCode.ROLES_NOT_FOUND, new String[0]);
        }
        this.cacheResponse(response);
    }

    @Override
    protected void lookupById(String id) throws AtlanException {
        RoleResponse response = this.rolesEndpoint.list("{\"id\":\"" + id + "\"}");
        this.cacheResponse(response);
    }

    @Override
    protected void lookupByName(String name) throws AtlanException {
        RoleResponse response = this.rolesEndpoint.list("{\"name\":\"" + name + "\"}");
        this.cacheResponse(response);
    }

    private void cacheResponse(RoleResponse response) {
        List<Object> roles = response != null ? response.getRecords() : Collections.emptyList();
        for (AtlanRole atlanRole : roles) {
            this.cache(atlanRole.getId(), atlanRole.getName(), atlanRole);
        }
    }
}

