/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.api.ApiTokensEndpoint;
import com.atlan.api.UsersEndpoint;
import com.atlan.cache.AbstractMassCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.NotFoundException;
import com.atlan.model.admin.ApiToken;
import com.atlan.model.admin.AtlanUser;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCache
extends AbstractMassCache<AtlanUser> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserCache.class);
    private final UsersEndpoint usersEndpoint;
    private final ApiTokensEndpoint apiTokensEndpoint;

    public UserCache(AtlanClient client) {
        super(client, "user");
        this.usersEndpoint = client.users;
        this.apiTokensEndpoint = client.apiTokens;
        this.bulkRefresh.set(false);
    }

    @Override
    protected void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of users...");
        List<AtlanUser> users = this.usersEndpoint.list();
        for (AtlanUser user : users) {
            String userId = user.getId();
            String userName = user.getUsername();
            String email = user.getEmail();
            if (userId == null || userName == null || email == null) continue;
            this.cache(userId, email, userName, user);
        }
    }

    public AtlanUser getByEmail(String email) throws AtlanException {
        return (AtlanUser)this.getBySid(email);
    }

    @Override
    public String getIdForName(String username, boolean allowRefresh) throws AtlanException {
        try {
            return super.getIdForName(username, false);
        }
        catch (NotFoundException e) {
            if (username.startsWith("service-account-")) {
                ApiToken token = this.apiTokensEndpoint.getById(username);
                if (token == null) {
                    throw new NotFoundException(ErrorCode.API_TOKEN_NOT_FOUND_BY_NAME, username);
                }
                AtlanUser api = UserCache.getUserForApiToken(username, token.getId());
                this.cache(token.getId(), api.getEmail(), username, api);
                return token.getId();
            }
            return super.getIdForName(username, allowRefresh);
        }
    }

    public String getIdForEmail(String email) throws AtlanException {
        return this.getIdForEmail(email, true);
    }

    public String getIdForEmail(String email, boolean allowRefresh) throws AtlanException {
        return this.getIdForSid(email, allowRefresh);
    }

    @Override
    public String getNameForId(String id, boolean allowRefresh) throws AtlanException {
        try {
            return super.getNameForId(id, false);
        }
        catch (NotFoundException e) {
            ApiToken token = this.apiTokensEndpoint.getByGuid(id);
            if (token != null) {
                String username = token.getApiTokenUsername();
                AtlanUser api = UserCache.getUserForApiToken(username, token.getId());
                this.cache(token.getId(), api.getEmail(), username, api);
                return username;
            }
            return super.getNameForId(id, allowRefresh);
        }
    }

    @Override
    protected void lookupByName(String username) throws AtlanException {
        if (username.startsWith("service-account-")) {
            ApiToken token = this.apiTokensEndpoint.getById(username);
            if (token == null) {
                throw new NotFoundException(ErrorCode.API_TOKEN_NOT_FOUND_BY_NAME, username);
            }
            AtlanUser api = UserCache.getUserForApiToken(username, token.getId());
            this.cache(token.getId(), api.getEmail(), username, api);
        } else {
            AtlanUser user = this.usersEndpoint.getByUsername(username);
            if (user != null) {
                this.cache(user.getId(), user.getEmail(), username, user);
            }
        }
    }

    @Override
    protected void lookupById(String id) throws AtlanException {
        block3: {
            try {
                AtlanUser user = this.usersEndpoint.getByGuid(id);
                if (user != null) {
                    this.cache(id, user.getEmail(), user.getUsername(), user);
                }
            }
            catch (NotFoundException e) {
                ApiToken token = this.apiTokensEndpoint.getByGuid(id);
                if (token == null) break block3;
                String username = token.getApiTokenUsername();
                AtlanUser api = UserCache.getUserForApiToken(username, token.getId());
                this.cache(token.getId(), api.getEmail(), username, api);
            }
        }
    }

    @Override
    protected void lookupBySid(String email) throws AtlanException {
        List<AtlanUser> users = this.usersEndpoint.getByEmail(email);
        if (users != null && !users.isEmpty()) {
            for (AtlanUser user : users) {
                this.cache(user.getId(), user.getEmail(), user.getUsername(), user);
            }
        }
    }

    private static AtlanUser getUserForApiToken(String tokenName, String id) {
        return ((AtlanUser.AtlanUserBuilder)((AtlanUser.AtlanUserBuilder)((AtlanUser.AtlanUserBuilder)AtlanUser.builder().id(id)).username(tokenName)).email(id + "@atlan.com")).build();
    }
}

