/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.exception;

import com.atlan.exception.ErrorCode;
import com.atlan.exception.ExceptionMessageDefinition;
import com.atlan.model.core.AtlanError;
import lombok.Generated;

public abstract class AtlanException
extends Exception {
    private static final long serialVersionUID = 2L;
    transient AtlanError atlanError;
    private final String code;
    private final Integer statusCode;

    protected AtlanException(ExceptionMessageDefinition error, int statusCode) {
        super(error.getErrorMessage(new String[0]));
        this.code = error.getErrorId();
        this.statusCode = statusCode;
    }

    protected AtlanException(ExceptionMessageDefinition error, int statusCode, Throwable e) {
        super(error.getErrorMessage(new String[0]), e);
        this.code = error.getErrorId();
        this.statusCode = statusCode;
    }

    protected AtlanException(ErrorCode error, Throwable e) {
        super(error.getMessageDefinition().getErrorMessage(new String[0]), e);
        this.code = error.getMessageDefinition().getErrorId();
        this.statusCode = error.getMessageDefinition().getHttpErrorCode();
    }

    protected AtlanException(ErrorCode error, Throwable e, String ... params) {
        super(error.getMessageDefinition().getErrorMessage(params), e);
        this.code = error.getMessageDefinition().getErrorId();
        this.statusCode = error.getMessageDefinition().getHttpErrorCode();
    }

    @Override
    public String getMessage() {
        if (this.code != null) {
            return this.code + " " + super.getMessage();
        }
        return super.getMessage();
    }

    public String getUserMessage() {
        return super.getMessage();
    }

    @Generated
    public AtlanError getAtlanError() {
        return this.atlanError;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Generated
    public void setAtlanError(AtlanError atlanError) {
        this.atlanError = atlanError;
    }
}

