/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.api.TypeDefsEndpoint;
import com.atlan.model.typedefs.TypeDef;
import com.atlan.util.StringUtils;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeneratorConfig.class);
    private static final Pattern WORD_FINDER = Pattern.compile("(([A-Z]?[a-z0-9]+)|([A-Z0-9]))");
    private static final Map<String, String> DEFAULT_CLASS_RENAMES = Map.ofEntries(Map.entry("google_datastudio_asset_type", "GoogleDataStudioAssetType"), Map.entry("powerbi_endorsement", "PowerBIEndorsementType"), Map.entry("Referenceable", "Asset"), Map.entry("Process", "LineageProcess"), Map.entry("Collection", "AtlanCollection"), Map.entry("Query", "AtlanQuery"), Map.entry("AtlasGlossary", "Glossary"), Map.entry("AtlasGlossaryCategory", "GlossaryCategory"), Map.entry("AtlasGlossaryTerm", "GlossaryTerm"), Map.entry("AtlasGlossaryAntonym", "GlossaryAntonym"), Map.entry("AtlasGlossarySynonym", "GlossarySynonym"), Map.entry("AtlasGlossaryIsARelationship", "GlossaryIsA"), Map.entry("AtlasGlossaryPreferredTerm", "GlossaryPreferredTerm"), Map.entry("AtlasGlossaryRelatedTerm", "GlossaryRelatedTerm"), Map.entry("AtlasGlossaryReplacementTerm", "GlossaryReplacementTerm"), Map.entry("AtlasGlossarySemanticAssignment", "GlossarySemanticAssignment"), Map.entry("AtlasGlossaryTermCategorization", "GlossaryTermCategorization"), Map.entry("AtlasGlossaryTranslation", "GlossaryTranslation"), Map.entry("AtlasGlossaryValidValue", "GlossaryValidValue"), Map.entry("MaterialisedView", "MaterializedView"));
    private static final Map<String, String> DEFAULT_SINGULARS = Map.ofEntries(Map.entry("seeAlso", "seeAlsoOne"), Map.entry("replacedByTerm", "replacedByTerm"), Map.entry("validValuesFor", "validValueFor"), Map.entry("isA", "isATerm"), Map.entry("replacedBy", "replacedByTerm"), Map.entry("childrenCategories", "childCategory"), Map.entry("queryUserMap", "putQueryUserMap"), Map.entry("queryPreviewConfig", "putQueryPreviewConfig"), Map.entry("reportType", "putReportType"), Map.entry("projectHierarchy", "addProjectHierarchy"), Map.entry("certifier", "putCertifier"), Map.entry("presetChartFormData", "putPresetChartFormData"), Map.entry("resourceMetadata", "putResourceMetadata"), Map.entry("adlsObjectMetadata", "putAdlsObjectMetadata"), Map.entry("foreignKeyTo", "addForeignKeyTo"), Map.entry("quickSightFolderHierarchy", "addQuickSightFolderHierarchy"), Map.entry("columnMaxs", "addColumnMax"), Map.entry("columnMins", "addColumnMin"), Map.entry("redashQuerySchedule", "putRedashQuerySchedule"), Map.entry("policyValiditySchedule", "addPolicyValiditySchedule"), Map.entry("authServiceConfig", "putAuthServiceConfig"), Map.entry("microStrategyLocation", "putMicroStrategyLocation"), Map.entry("starredBy", "addStarredBy"), Map.entry("matillionComponentLinkedJob", "putMatillionComponentLinkedJob"), Map.entry("matillionVersions", "addMatillionVersion"), Map.entry("cogniteTimeseries", "addCogniteTimeseries"), Map.entry("exceptionsForBusinessPolicy", "exceptionForBusinessPolicy"), Map.entry("supersetChartFormData", "putSupersetChartFormData"), Map.entry("columnHierarchy", "putColumnHierarchy"), Map.entry("bigqueryTagHierarchy", "putBigqueryTagHierarchy"), Map.entry("applications", "aiApplication"), Map.entry("sapErpFunctionExceptionList", "sapErpFunctionException"), Map.entry("cassandraViewCaching", "putCassandraViewCaching"), Map.entry("cassandraViewCompaction", "putCassandraViewCompaction"), Map.entry("cassandraTableCaching", "putCassandraTableCaching"), Map.entry("cassandraTableCompaction", "putCassandraTableCompaction"), Map.entry("cassandraTableCompression", "putCassandraTableCompression"), Map.entry("cassandraKeyspaceReplication", "putCassandraKeyspaceReplication"), Map.entry("responseValueArrString", "addResponseValueString"), Map.entry("responseValueArrInt", "addResponseValueInt"), Map.entry("responseValueArrBoolean", "addResponseValueBoolean"), Map.entry("responseValueArrJson", "addResponseValueJson"), Map.entry("responseValueArrLong", "addResponseValueLong"), Map.entry("responseValueArrDate", "addResponseValueDate"));
    private static final Map<String, String> DEFAULT_ATTRIBUTE_RENAMES = Map.ofEntries(Map.entry("__hasLineage", "hasLineage"), Map.entry("viewsCount", "viewCount"), Map.entry("materialisedView", "materializedView"), Map.entry("materialisedViews", "materializedViews"), Map.entry("atlanSchema", "schema"), Map.entry("sourceQueryComputeCostList", "sourceQueryComputeCosts"), Map.entry("sourceReadTopUserList", "sourceReadTopUsers"), Map.entry("sourceReadRecentUserList", "sourceReadRecentUsers"), Map.entry("sourceReadRecentUserRecordList", "sourceReadRecentUserRecords"), Map.entry("sourceReadTopUserRecordList", "sourceReadTopUserRecords"), Map.entry("sourceReadPopularQueryRecordList", "sourceReadPopularQueryRecords"), Map.entry("sourceReadExpensiveQueryRecordList", "sourceReadExpensiveQueryRecords"), Map.entry("sourceReadSlowQueryRecordList", "sourceReadSlowQueryRecords"), Map.entry("sourceQueryComputeCostRecordList", "sourceQueryComputeCostRecords"), Map.entry("meanings", "assignedTerms"), Map.entry("sqlAsset", "primarySqlAsset"), Map.entry("mappedClassificationName", "mappedAtlanTagName"), Map.entry("purposeClassifications", "purposeAtlanTags"), Map.entry("starredDetailsList", "starredDetails"), Map.entry("sourceTagValue", "sourceTagValues"), Map.entry("userDefRelationshipFrom", "userDefRelationshipFroms"), Map.entry("userDefRelationshipTo", "userDefRelationshipTos"), Map.entry("adfActivityPrecedingDependency", "adfActivityPrecedingDependencies"), Map.entry("modelEntityImplemented", "modelImplementedEntities"), Map.entry("bprValue", "bprValues"), Map.entry("parentConnectionProcessQualifiedName", "parentConnectionProcessQualifiedNames"));
    private static final Map<String, String> DEFAULT_ATTRIBUTE_ENUMS = Map.ofEntries(Map.entry("announcementType", "AtlanAnnouncementType"), Map.entry("category", "AtlanConnectionCategory"), Map.entry("policyCategory", "AuthPolicyCategory"), Map.entry("policyResourceCategory", "AuthPolicyResourceCategory"), Map.entry("policyActions", "AtlanPolicyAction"), Map.entry("denyAssetTabs", "AssetSidebarTab"), Map.entry("denyAssetFilters", "AssetFilterGroup"), Map.entry("policyMaskType", "DataMaskingType"), Map.entry("assetIcon", "AtlanIcon"));
    private static final Map<String, Map<String, String>> DEFAULT_TYPE_OVERRIDES = Map.of("TableauDatasource", Map.of("fields", "TableauField"));
    private static final Map<String, String> DEFAULT_SEARCHABLE_RELATIONSHIPS = Map.of("readme", "asset_readme", "links", "asset_links");
    static final Set<String> BUILT_IN_STRUCTS = Set.of("Histogram", "ColumnValueFrequencyMap");
    static final Set<String> BUILT_IN_ENUMS = Set.of("AtlanAnnouncementType", "AtlanConnectionCategory", "AtlanConnectorType", "AtlanDeleteType", "AtlanIcon", "AtlanStatus", "AtlanPolicyAction", "PersonaMetadataAction", "PersonaGlossaryAction", "PurposeMetadataAction", "DataAction", "CertificateStatus");
    private Configuration freemarkerConfig;
    private String packageRoot;
    private String packagePath;
    private String testPath;
    private String generatorName;
    private boolean preferTypeDefDescriptions;
    private Set<String> serviceTypes;
    private Map<String, String> renameClasses;
    private Map<String, String> renameEnumValues;
    private Set<String> doNotGenerateAssets;
    private Set<String> forceNonAbstractAssets;
    private Map<String, String> singularForAttributes;
    private Map<String, String> renameAttributes;
    private Map<String, String> attributeToEnums;
    private Map<String, Map<String, String>> retypeAttributes;
    private Map<String, String> searchableRelationships;

    public static GeneratorConfigBuilder creator(Class<?> generatorClass, String packageRoot) throws IOException {
        return GeneratorConfig.creator(generatorClass, null, packageRoot);
    }

    public static GeneratorConfigBuilder creator(Class<?> generatorClass, File directoryForTemplateLoading, String packageRoot) throws IOException {
        return GeneratorConfig.creator(generatorClass, directoryForTemplateLoading, packageRoot, null);
    }

    public static GeneratorConfigBuilder creator(Class<?> generatorClass, File directoryForTemplateLoading, String packageRoot, String projectName) throws IOException {
        return GeneratorConfig.builder().generatorName(generatorClass.getCanonicalName()).packageRoot(packageRoot).freemarkerConfig(GeneratorConfig.createConfig(directoryForTemplateLoading)).packagePath(GeneratorConfig.createPackagePath(packageRoot, projectName)).testPath(GeneratorConfig.createTestPath(packageRoot, projectName)).renameClasses(DEFAULT_CLASS_RENAMES).singularForAttributes(DEFAULT_SINGULARS).renameAttributes(DEFAULT_ATTRIBUTE_RENAMES).attributeToEnums(DEFAULT_ATTRIBUTE_ENUMS).retypeAttributes(DEFAULT_TYPE_OVERRIDES).searchableRelationships(DEFAULT_SEARCHABLE_RELATIONSHIPS);
    }

    public static GeneratorConfigBuilder getDefault(Class<?> generatorClass) throws IOException {
        return GeneratorConfig.getDefault(generatorClass, null);
    }

    public static GeneratorConfigBuilder getDefault(Class<?> generatorClass, String projectName) throws IOException {
        return GeneratorConfig.creator(generatorClass, null, "com.atlan.model", projectName).serviceTypes(TypeDefsEndpoint.RESERVED_SERVICE_TYPES).preferTypeDefDescriptions(false).renameClasses(DEFAULT_CLASS_RENAMES).singularForAttributes(DEFAULT_SINGULARS).renameAttributes(DEFAULT_ATTRIBUTE_RENAMES).attributeToEnums(DEFAULT_ATTRIBUTE_ENUMS).retypeAttributes(DEFAULT_TYPE_OVERRIDES).searchableRelationships(DEFAULT_SEARCHABLE_RELATIONSHIPS).renameEnumValue("ResolvingDNS", "RESOLVING_DNS").renameEnumValue("RA-GRS", "RA_GRS").doNotGenerateAsset("Referenceable").doNotGenerateAsset("AtlasServer").doNotGenerateAsset("DataSet").doNotGenerateAsset("Infrastructure").doNotGenerateAsset("ProcessExecution").doNotGenerateAsset("__AtlasAuditEntry").doNotGenerateAsset("__AtlasUserProfile").doNotGenerateAsset("__AtlasUserSavedSearch").doNotGenerateAsset("__ExportImportAuditEntry").doNotGenerateAsset("__internal").forceNonAbstractAsset("Process").forceNonAbstractAsset("ColumnProcess").forceNonAbstractAsset("QlikSpace").forceNonAbstractAsset("KafkaTopic").forceNonAbstractAsset("KafkaConsumerGroup").forceNonAbstractAsset("Table").forceNonAbstractAsset("Column").forceNonAbstractAsset("Database").forceNonAbstractAsset("MongoDBDatabase").forceNonAbstractAsset("MongoDBCollection").forceNonAbstractAsset("Persona");
    }

    public boolean includeTypedef(TypeDef typeDef) {
        if (typeDef == null || typeDef.getServiceType() == null) {
            return true;
        }
        return this.serviceTypes.contains(typeDef.getServiceType()) && !this.doNotGenerateAssets.contains(typeDef.getName());
    }

    public String resolveClassName(String originalName) {
        return this.renameClasses.getOrDefault(originalName, StringUtils.getUpperCamelCase(originalName));
    }

    public boolean forceNonAbstract(String originalName) {
        return this.forceNonAbstractAssets.contains(originalName);
    }

    public String resolveAttributeName(String originalName) {
        return this.renameAttributes.getOrDefault(originalName, StringUtils.getLowerCamelCase(originalName));
    }

    public String resolveAttributeToEnumeration(String originalName) {
        return this.attributeToEnums.getOrDefault(originalName, null);
    }

    public String resolveAttributeToTypeOverride(String typeName, String attributeName) {
        if (this.retypeAttributes.containsKey(typeName)) {
            return this.retypeAttributes.get(typeName).getOrDefault(attributeName, null);
        }
        return null;
    }

    public String resolveSingular(String originalName) {
        return this.singularForAttributes.getOrDefault(originalName, "");
    }

    public String resolveEnumValue(String value) {
        if (this.renameEnumValues.containsKey(value)) {
            return this.renameEnumValues.get(value);
        }
        if (value.toUpperCase(Locale.ROOT).equals(value) && !value.contains(" ") && !value.contains("-")) {
            return value;
        }
        String[] words = value.split("[-\\s]");
        if (words.length == 1) {
            ArrayList<String> camelCaseWords = new ArrayList<String>();
            Matcher matcher = WORD_FINDER.matcher(value);
            while (matcher.find()) {
                camelCaseWords.add(matcher.group(0));
            }
            words = camelCaseWords.toArray(new String[0]);
        }
        StringBuilder builder = new StringBuilder();
        for (String string : words) {
            String string2 = string.isEmpty() ? string : string.toUpperCase(Locale.ROOT);
            builder.append(string2).append("_");
        }
        String built = builder.toString();
        return built.endsWith("_") ? built.substring(0, built.length() - 1) : built;
    }

    public String getSearchableRelationship(String field) {
        return this.searchableRelationships.getOrDefault(field, null);
    }

    private static Configuration createConfig(File directoryForTemplateLoading) throws IOException {
        Configuration cfg = GeneratorConfig.createConfigBase();
        ClassTemplateLoader ctl = new ClassTemplateLoader(GeneratorConfig.class.getClassLoader(), "templates");
        FileTemplateLoader ftl = null;
        if (directoryForTemplateLoading != null && directoryForTemplateLoading.exists()) {
            ftl = new FileTemplateLoader(directoryForTemplateLoading);
        }
        if (ftl != null) {
            MultiTemplateLoader mtl = new MultiTemplateLoader(new TemplateLoader[]{ctl, ftl});
            cfg.setTemplateLoader((TemplateLoader)mtl);
        } else {
            cfg.setTemplateLoader((TemplateLoader)ctl);
        }
        return cfg;
    }

    private static Configuration createConfigBase() {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_32);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setFallbackOnNullLoopVariable(false);
        cfg.setSQLDateAndTimeTimeZone(TimeZone.getDefault());
        return cfg;
    }

    private static String createPackagePath(String packageRoot, String projectName) {
        return projectName == null ? GeneratorConfig.createPath("src" + File.separator + "main" + File.separator + "java" + File.separator, packageRoot) : GeneratorConfig.createPath(projectName + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator, packageRoot);
    }

    private static String createTestPath(String packageRoot, String projectName) {
        return projectName == null ? GeneratorConfig.createPath("src" + File.separator + "test" + File.separator + "java" + File.separator, packageRoot) : GeneratorConfig.createPath(projectName + File.separator + "src" + File.separator + "test" + File.separator + "java" + File.separator, packageRoot);
    }

    private static String createPath(String prefix, String packageRoot) {
        return prefix + File.separator + packageRoot.replaceAll("\\.", File.separator);
    }

    @Generated
    private static boolean $default$preferTypeDefDescriptions() {
        return true;
    }

    @Generated
    GeneratorConfig(Configuration freemarkerConfig, String packageRoot, String packagePath, String testPath, String generatorName, boolean preferTypeDefDescriptions, Set<String> serviceTypes, Map<String, String> renameClasses, Map<String, String> renameEnumValues, Set<String> doNotGenerateAssets, Set<String> forceNonAbstractAssets, Map<String, String> singularForAttributes, Map<String, String> renameAttributes, Map<String, String> attributeToEnums, Map<String, Map<String, String>> retypeAttributes, Map<String, String> searchableRelationships) {
        this.freemarkerConfig = freemarkerConfig;
        this.packageRoot = packageRoot;
        this.packagePath = packagePath;
        this.testPath = testPath;
        this.generatorName = generatorName;
        this.preferTypeDefDescriptions = preferTypeDefDescriptions;
        this.serviceTypes = serviceTypes;
        this.renameClasses = renameClasses;
        this.renameEnumValues = renameEnumValues;
        this.doNotGenerateAssets = doNotGenerateAssets;
        this.forceNonAbstractAssets = forceNonAbstractAssets;
        this.singularForAttributes = singularForAttributes;
        this.renameAttributes = renameAttributes;
        this.attributeToEnums = attributeToEnums;
        this.retypeAttributes = retypeAttributes;
        this.searchableRelationships = searchableRelationships;
    }

    @Generated
    public static GeneratorConfigBuilder builder() {
        return new GeneratorConfigBuilder();
    }

    @Generated
    public Configuration getFreemarkerConfig() {
        return this.freemarkerConfig;
    }

    @Generated
    public String getPackageRoot() {
        return this.packageRoot;
    }

    @Generated
    public String getPackagePath() {
        return this.packagePath;
    }

    @Generated
    public String getTestPath() {
        return this.testPath;
    }

    @Generated
    public String getGeneratorName() {
        return this.generatorName;
    }

    @Generated
    public boolean getPreferTypeDefDescriptions() {
        return this.preferTypeDefDescriptions;
    }

    @Generated
    public static class GeneratorConfigBuilder {
        @Generated
        private Configuration freemarkerConfig;
        @Generated
        private String packageRoot;
        @Generated
        private String packagePath;
        @Generated
        private String testPath;
        @Generated
        private String generatorName;
        @Generated
        private boolean preferTypeDefDescriptions$set;
        @Generated
        private boolean preferTypeDefDescriptions$value;
        @Generated
        private ArrayList<String> serviceTypes;
        @Generated
        private ArrayList<String> renameClasses$key;
        @Generated
        private ArrayList<String> renameClasses$value;
        @Generated
        private ArrayList<String> renameEnumValues$key;
        @Generated
        private ArrayList<String> renameEnumValues$value;
        @Generated
        private ArrayList<String> doNotGenerateAssets;
        @Generated
        private ArrayList<String> forceNonAbstractAssets;
        @Generated
        private ArrayList<String> singularForAttributes$key;
        @Generated
        private ArrayList<String> singularForAttributes$value;
        @Generated
        private ArrayList<String> renameAttributes$key;
        @Generated
        private ArrayList<String> renameAttributes$value;
        @Generated
        private ArrayList<String> attributeToEnums$key;
        @Generated
        private ArrayList<String> attributeToEnums$value;
        @Generated
        private ArrayList<String> retypeAttributes$key;
        @Generated
        private ArrayList<Map<String, String>> retypeAttributes$value;
        @Generated
        private ArrayList<String> searchableRelationships$key;
        @Generated
        private ArrayList<String> searchableRelationships$value;

        @Generated
        GeneratorConfigBuilder() {
        }

        @Generated
        public GeneratorConfigBuilder freemarkerConfig(Configuration freemarkerConfig) {
            this.freemarkerConfig = freemarkerConfig;
            return this;
        }

        @Generated
        public GeneratorConfigBuilder packageRoot(String packageRoot) {
            this.packageRoot = packageRoot;
            return this;
        }

        @Generated
        public GeneratorConfigBuilder packagePath(String packagePath) {
            this.packagePath = packagePath;
            return this;
        }

        @Generated
        public GeneratorConfigBuilder testPath(String testPath) {
            this.testPath = testPath;
            return this;
        }

        @Generated
        public GeneratorConfigBuilder generatorName(String generatorName) {
            this.generatorName = generatorName;
            return this;
        }

        @Generated
        public GeneratorConfigBuilder preferTypeDefDescriptions(boolean preferTypeDefDescriptions) {
            this.preferTypeDefDescriptions$value = preferTypeDefDescriptions;
            this.preferTypeDefDescriptions$set = true;
            return this;
        }

        @Generated
        public GeneratorConfigBuilder serviceType(String serviceType) {
            if (this.serviceTypes == null) {
                this.serviceTypes = new ArrayList();
            }
            this.serviceTypes.add(serviceType);
            return this;
        }

        @Generated
        public GeneratorConfigBuilder serviceTypes(Collection<? extends String> serviceTypes) {
            if (serviceTypes == null) {
                throw new NullPointerException("serviceTypes cannot be null");
            }
            if (this.serviceTypes == null) {
                this.serviceTypes = new ArrayList();
            }
            this.serviceTypes.addAll(serviceTypes);
            return this;
        }

        @Generated
        public GeneratorConfigBuilder clearServiceTypes() {
            if (this.serviceTypes != null) {
                this.serviceTypes.clear();
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder renameClass(String renameClassKey, String renameClassValue) {
            if (this.renameClasses$key == null) {
                this.renameClasses$key = new ArrayList();
                this.renameClasses$value = new ArrayList();
            }
            this.renameClasses$key.add(renameClassKey);
            this.renameClasses$value.add(renameClassValue);
            return this;
        }

        @Generated
        public GeneratorConfigBuilder renameClasses(Map<? extends String, ? extends String> renameClasses) {
            if (renameClasses == null) {
                throw new NullPointerException("renameClasses cannot be null");
            }
            if (this.renameClasses$key == null) {
                this.renameClasses$key = new ArrayList();
                this.renameClasses$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : renameClasses.entrySet()) {
                this.renameClasses$key.add($lombokEntry.getKey());
                this.renameClasses$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder clearRenameClasses() {
            if (this.renameClasses$key != null) {
                this.renameClasses$key.clear();
                this.renameClasses$value.clear();
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder renameEnumValue(String renameEnumValueKey, String renameEnumValueValue) {
            if (this.renameEnumValues$key == null) {
                this.renameEnumValues$key = new ArrayList();
                this.renameEnumValues$value = new ArrayList();
            }
            this.renameEnumValues$key.add(renameEnumValueKey);
            this.renameEnumValues$value.add(renameEnumValueValue);
            return this;
        }

        @Generated
        public GeneratorConfigBuilder renameEnumValues(Map<? extends String, ? extends String> renameEnumValues) {
            if (renameEnumValues == null) {
                throw new NullPointerException("renameEnumValues cannot be null");
            }
            if (this.renameEnumValues$key == null) {
                this.renameEnumValues$key = new ArrayList();
                this.renameEnumValues$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : renameEnumValues.entrySet()) {
                this.renameEnumValues$key.add($lombokEntry.getKey());
                this.renameEnumValues$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder clearRenameEnumValues() {
            if (this.renameEnumValues$key != null) {
                this.renameEnumValues$key.clear();
                this.renameEnumValues$value.clear();
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder doNotGenerateAsset(String doNotGenerateAsset) {
            if (this.doNotGenerateAssets == null) {
                this.doNotGenerateAssets = new ArrayList();
            }
            this.doNotGenerateAssets.add(doNotGenerateAsset);
            return this;
        }

        @Generated
        public GeneratorConfigBuilder doNotGenerateAssets(Collection<? extends String> doNotGenerateAssets) {
            if (doNotGenerateAssets == null) {
                throw new NullPointerException("doNotGenerateAssets cannot be null");
            }
            if (this.doNotGenerateAssets == null) {
                this.doNotGenerateAssets = new ArrayList();
            }
            this.doNotGenerateAssets.addAll(doNotGenerateAssets);
            return this;
        }

        @Generated
        public GeneratorConfigBuilder clearDoNotGenerateAssets() {
            if (this.doNotGenerateAssets != null) {
                this.doNotGenerateAssets.clear();
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder forceNonAbstractAsset(String forceNonAbstractAsset) {
            if (this.forceNonAbstractAssets == null) {
                this.forceNonAbstractAssets = new ArrayList();
            }
            this.forceNonAbstractAssets.add(forceNonAbstractAsset);
            return this;
        }

        @Generated
        public GeneratorConfigBuilder forceNonAbstractAssets(Collection<? extends String> forceNonAbstractAssets) {
            if (forceNonAbstractAssets == null) {
                throw new NullPointerException("forceNonAbstractAssets cannot be null");
            }
            if (this.forceNonAbstractAssets == null) {
                this.forceNonAbstractAssets = new ArrayList();
            }
            this.forceNonAbstractAssets.addAll(forceNonAbstractAssets);
            return this;
        }

        @Generated
        public GeneratorConfigBuilder clearForceNonAbstractAssets() {
            if (this.forceNonAbstractAssets != null) {
                this.forceNonAbstractAssets.clear();
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder singularForAttribute(String singularForAttributeKey, String singularForAttributeValue) {
            if (this.singularForAttributes$key == null) {
                this.singularForAttributes$key = new ArrayList();
                this.singularForAttributes$value = new ArrayList();
            }
            this.singularForAttributes$key.add(singularForAttributeKey);
            this.singularForAttributes$value.add(singularForAttributeValue);
            return this;
        }

        @Generated
        public GeneratorConfigBuilder singularForAttributes(Map<? extends String, ? extends String> singularForAttributes) {
            if (singularForAttributes == null) {
                throw new NullPointerException("singularForAttributes cannot be null");
            }
            if (this.singularForAttributes$key == null) {
                this.singularForAttributes$key = new ArrayList();
                this.singularForAttributes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : singularForAttributes.entrySet()) {
                this.singularForAttributes$key.add($lombokEntry.getKey());
                this.singularForAttributes$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder clearSingularForAttributes() {
            if (this.singularForAttributes$key != null) {
                this.singularForAttributes$key.clear();
                this.singularForAttributes$value.clear();
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder renameAttribute(String renameAttributeKey, String renameAttributeValue) {
            if (this.renameAttributes$key == null) {
                this.renameAttributes$key = new ArrayList();
                this.renameAttributes$value = new ArrayList();
            }
            this.renameAttributes$key.add(renameAttributeKey);
            this.renameAttributes$value.add(renameAttributeValue);
            return this;
        }

        @Generated
        public GeneratorConfigBuilder renameAttributes(Map<? extends String, ? extends String> renameAttributes) {
            if (renameAttributes == null) {
                throw new NullPointerException("renameAttributes cannot be null");
            }
            if (this.renameAttributes$key == null) {
                this.renameAttributes$key = new ArrayList();
                this.renameAttributes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : renameAttributes.entrySet()) {
                this.renameAttributes$key.add($lombokEntry.getKey());
                this.renameAttributes$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder clearRenameAttributes() {
            if (this.renameAttributes$key != null) {
                this.renameAttributes$key.clear();
                this.renameAttributes$value.clear();
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder attributeToEnum(String attributeToEnumKey, String attributeToEnumValue) {
            if (this.attributeToEnums$key == null) {
                this.attributeToEnums$key = new ArrayList();
                this.attributeToEnums$value = new ArrayList();
            }
            this.attributeToEnums$key.add(attributeToEnumKey);
            this.attributeToEnums$value.add(attributeToEnumValue);
            return this;
        }

        @Generated
        public GeneratorConfigBuilder attributeToEnums(Map<? extends String, ? extends String> attributeToEnums) {
            if (attributeToEnums == null) {
                throw new NullPointerException("attributeToEnums cannot be null");
            }
            if (this.attributeToEnums$key == null) {
                this.attributeToEnums$key = new ArrayList();
                this.attributeToEnums$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : attributeToEnums.entrySet()) {
                this.attributeToEnums$key.add($lombokEntry.getKey());
                this.attributeToEnums$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder clearAttributeToEnums() {
            if (this.attributeToEnums$key != null) {
                this.attributeToEnums$key.clear();
                this.attributeToEnums$value.clear();
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder retypeAttribute(String retypeAttributeKey, Map<String, String> retypeAttributeValue) {
            if (this.retypeAttributes$key == null) {
                this.retypeAttributes$key = new ArrayList();
                this.retypeAttributes$value = new ArrayList();
            }
            this.retypeAttributes$key.add(retypeAttributeKey);
            this.retypeAttributes$value.add(retypeAttributeValue);
            return this;
        }

        @Generated
        public GeneratorConfigBuilder retypeAttributes(Map<? extends String, ? extends Map<String, String>> retypeAttributes) {
            if (retypeAttributes == null) {
                throw new NullPointerException("retypeAttributes cannot be null");
            }
            if (this.retypeAttributes$key == null) {
                this.retypeAttributes$key = new ArrayList();
                this.retypeAttributes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Map<String, String>> $lombokEntry : retypeAttributes.entrySet()) {
                this.retypeAttributes$key.add($lombokEntry.getKey());
                this.retypeAttributes$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder clearRetypeAttributes() {
            if (this.retypeAttributes$key != null) {
                this.retypeAttributes$key.clear();
                this.retypeAttributes$value.clear();
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder searchableRelationship(String searchableRelationshipKey, String searchableRelationshipValue) {
            if (this.searchableRelationships$key == null) {
                this.searchableRelationships$key = new ArrayList();
                this.searchableRelationships$value = new ArrayList();
            }
            this.searchableRelationships$key.add(searchableRelationshipKey);
            this.searchableRelationships$value.add(searchableRelationshipValue);
            return this;
        }

        @Generated
        public GeneratorConfigBuilder searchableRelationships(Map<? extends String, ? extends String> searchableRelationships) {
            if (searchableRelationships == null) {
                throw new NullPointerException("searchableRelationships cannot be null");
            }
            if (this.searchableRelationships$key == null) {
                this.searchableRelationships$key = new ArrayList();
                this.searchableRelationships$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : searchableRelationships.entrySet()) {
                this.searchableRelationships$key.add($lombokEntry.getKey());
                this.searchableRelationships$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public GeneratorConfigBuilder clearSearchableRelationships() {
            if (this.searchableRelationships$key != null) {
                this.searchableRelationships$key.clear();
                this.searchableRelationships$value.clear();
            }
            return this;
        }

        @Generated
        public GeneratorConfig build() {
            Map<Object, Object> searchableRelationships;
            Map<Object, Object> retypeAttributes;
            Map<Object, Object> attributeToEnums;
            Map<Object, Object> renameAttributes;
            Map<Object, Object> singularForAttributes;
            Set<Object> forceNonAbstractAssets;
            Set<Object> doNotGenerateAssets;
            Map<Object, Object> renameEnumValues;
            Map<Object, Object> renameClasses;
            Set<Object> serviceTypes;
            switch (this.serviceTypes == null ? 0 : this.serviceTypes.size()) {
                case 0: {
                    serviceTypes = Collections.emptySet();
                    break;
                }
                case 1: {
                    serviceTypes = Collections.singleton(this.serviceTypes.get(0));
                    break;
                }
                default: {
                    serviceTypes = new LinkedHashSet(this.serviceTypes.size() < 0x40000000 ? 1 + this.serviceTypes.size() + (this.serviceTypes.size() - 3) / 3 : Integer.MAX_VALUE);
                    serviceTypes.addAll(this.serviceTypes);
                    serviceTypes = Collections.unmodifiableSet(serviceTypes);
                }
            }
            switch (this.renameClasses$key == null ? 0 : this.renameClasses$key.size()) {
                case 0: {
                    renameClasses = Collections.emptyMap();
                    break;
                }
                case 1: {
                    renameClasses = Collections.singletonMap(this.renameClasses$key.get(0), this.renameClasses$value.get(0));
                    break;
                }
                default: {
                    renameClasses = new LinkedHashMap(this.renameClasses$key.size() < 0x40000000 ? 1 + this.renameClasses$key.size() + (this.renameClasses$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.renameClasses$key.size(); ++$i) {
                        renameClasses.put(this.renameClasses$key.get($i), this.renameClasses$value.get($i));
                    }
                    renameClasses = Collections.unmodifiableMap(renameClasses);
                }
            }
            switch (this.renameEnumValues$key == null ? 0 : this.renameEnumValues$key.size()) {
                case 0: {
                    renameEnumValues = Collections.emptyMap();
                    break;
                }
                case 1: {
                    renameEnumValues = Collections.singletonMap(this.renameEnumValues$key.get(0), this.renameEnumValues$value.get(0));
                    break;
                }
                default: {
                    renameEnumValues = new LinkedHashMap(this.renameEnumValues$key.size() < 0x40000000 ? 1 + this.renameEnumValues$key.size() + (this.renameEnumValues$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.renameEnumValues$key.size(); ++$i) {
                        renameEnumValues.put(this.renameEnumValues$key.get($i), this.renameEnumValues$value.get($i));
                    }
                    renameEnumValues = Collections.unmodifiableMap(renameEnumValues);
                }
            }
            switch (this.doNotGenerateAssets == null ? 0 : this.doNotGenerateAssets.size()) {
                case 0: {
                    doNotGenerateAssets = Collections.emptySet();
                    break;
                }
                case 1: {
                    doNotGenerateAssets = Collections.singleton(this.doNotGenerateAssets.get(0));
                    break;
                }
                default: {
                    doNotGenerateAssets = new LinkedHashSet(this.doNotGenerateAssets.size() < 0x40000000 ? 1 + this.doNotGenerateAssets.size() + (this.doNotGenerateAssets.size() - 3) / 3 : Integer.MAX_VALUE);
                    doNotGenerateAssets.addAll(this.doNotGenerateAssets);
                    doNotGenerateAssets = Collections.unmodifiableSet(doNotGenerateAssets);
                }
            }
            switch (this.forceNonAbstractAssets == null ? 0 : this.forceNonAbstractAssets.size()) {
                case 0: {
                    forceNonAbstractAssets = Collections.emptySet();
                    break;
                }
                case 1: {
                    forceNonAbstractAssets = Collections.singleton(this.forceNonAbstractAssets.get(0));
                    break;
                }
                default: {
                    forceNonAbstractAssets = new LinkedHashSet(this.forceNonAbstractAssets.size() < 0x40000000 ? 1 + this.forceNonAbstractAssets.size() + (this.forceNonAbstractAssets.size() - 3) / 3 : Integer.MAX_VALUE);
                    forceNonAbstractAssets.addAll(this.forceNonAbstractAssets);
                    forceNonAbstractAssets = Collections.unmodifiableSet(forceNonAbstractAssets);
                }
            }
            switch (this.singularForAttributes$key == null ? 0 : this.singularForAttributes$key.size()) {
                case 0: {
                    singularForAttributes = Collections.emptyMap();
                    break;
                }
                case 1: {
                    singularForAttributes = Collections.singletonMap(this.singularForAttributes$key.get(0), this.singularForAttributes$value.get(0));
                    break;
                }
                default: {
                    singularForAttributes = new LinkedHashMap(this.singularForAttributes$key.size() < 0x40000000 ? 1 + this.singularForAttributes$key.size() + (this.singularForAttributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.singularForAttributes$key.size(); ++$i) {
                        singularForAttributes.put(this.singularForAttributes$key.get($i), this.singularForAttributes$value.get($i));
                    }
                    singularForAttributes = Collections.unmodifiableMap(singularForAttributes);
                }
            }
            switch (this.renameAttributes$key == null ? 0 : this.renameAttributes$key.size()) {
                case 0: {
                    renameAttributes = Collections.emptyMap();
                    break;
                }
                case 1: {
                    renameAttributes = Collections.singletonMap(this.renameAttributes$key.get(0), this.renameAttributes$value.get(0));
                    break;
                }
                default: {
                    renameAttributes = new LinkedHashMap(this.renameAttributes$key.size() < 0x40000000 ? 1 + this.renameAttributes$key.size() + (this.renameAttributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.renameAttributes$key.size(); ++$i) {
                        renameAttributes.put(this.renameAttributes$key.get($i), this.renameAttributes$value.get($i));
                    }
                    renameAttributes = Collections.unmodifiableMap(renameAttributes);
                }
            }
            switch (this.attributeToEnums$key == null ? 0 : this.attributeToEnums$key.size()) {
                case 0: {
                    attributeToEnums = Collections.emptyMap();
                    break;
                }
                case 1: {
                    attributeToEnums = Collections.singletonMap(this.attributeToEnums$key.get(0), this.attributeToEnums$value.get(0));
                    break;
                }
                default: {
                    attributeToEnums = new LinkedHashMap(this.attributeToEnums$key.size() < 0x40000000 ? 1 + this.attributeToEnums$key.size() + (this.attributeToEnums$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.attributeToEnums$key.size(); ++$i) {
                        attributeToEnums.put(this.attributeToEnums$key.get($i), this.attributeToEnums$value.get($i));
                    }
                    attributeToEnums = Collections.unmodifiableMap(attributeToEnums);
                }
            }
            switch (this.retypeAttributes$key == null ? 0 : this.retypeAttributes$key.size()) {
                case 0: {
                    retypeAttributes = Collections.emptyMap();
                    break;
                }
                case 1: {
                    retypeAttributes = Collections.singletonMap(this.retypeAttributes$key.get(0), this.retypeAttributes$value.get(0));
                    break;
                }
                default: {
                    retypeAttributes = new LinkedHashMap(this.retypeAttributes$key.size() < 0x40000000 ? 1 + this.retypeAttributes$key.size() + (this.retypeAttributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.retypeAttributes$key.size(); ++$i) {
                        retypeAttributes.put(this.retypeAttributes$key.get($i), this.retypeAttributes$value.get($i));
                    }
                    retypeAttributes = Collections.unmodifiableMap(retypeAttributes);
                }
            }
            switch (this.searchableRelationships$key == null ? 0 : this.searchableRelationships$key.size()) {
                case 0: {
                    searchableRelationships = Collections.emptyMap();
                    break;
                }
                case 1: {
                    searchableRelationships = Collections.singletonMap(this.searchableRelationships$key.get(0), this.searchableRelationships$value.get(0));
                    break;
                }
                default: {
                    searchableRelationships = new LinkedHashMap(this.searchableRelationships$key.size() < 0x40000000 ? 1 + this.searchableRelationships$key.size() + (this.searchableRelationships$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.searchableRelationships$key.size(); ++$i) {
                        searchableRelationships.put(this.searchableRelationships$key.get($i), this.searchableRelationships$value.get($i));
                    }
                    searchableRelationships = Collections.unmodifiableMap(searchableRelationships);
                }
            }
            boolean preferTypeDefDescriptions$value = this.preferTypeDefDescriptions$value;
            if (!this.preferTypeDefDescriptions$set) {
                preferTypeDefDescriptions$value = GeneratorConfig.$default$preferTypeDefDescriptions();
            }
            return new GeneratorConfig(this.freemarkerConfig, this.packageRoot, this.packagePath, this.testPath, this.generatorName, preferTypeDefDescriptions$value, serviceTypes, renameClasses, renameEnumValues, doNotGenerateAssets, forceNonAbstractAssets, singularForAttributes, renameAttributes, attributeToEnums, retypeAttributes, searchableRelationships);
        }

        @Generated
        public String toString() {
            return "GeneratorConfig.GeneratorConfigBuilder(freemarkerConfig=" + String.valueOf(this.freemarkerConfig) + ", packageRoot=" + this.packageRoot + ", packagePath=" + this.packagePath + ", testPath=" + this.testPath + ", generatorName=" + this.generatorName + ", preferTypeDefDescriptions$value=" + this.preferTypeDefDescriptions$value + ", serviceTypes=" + String.valueOf(this.serviceTypes) + ", renameClasses$key=" + String.valueOf(this.renameClasses$key) + ", renameClasses$value=" + String.valueOf(this.renameClasses$value) + ", renameEnumValues$key=" + String.valueOf(this.renameEnumValues$key) + ", renameEnumValues$value=" + String.valueOf(this.renameEnumValues$value) + ", doNotGenerateAssets=" + String.valueOf(this.doNotGenerateAssets) + ", forceNonAbstractAssets=" + String.valueOf(this.forceNonAbstractAssets) + ", singularForAttributes$key=" + String.valueOf(this.singularForAttributes$key) + ", singularForAttributes$value=" + String.valueOf(this.singularForAttributes$value) + ", renameAttributes$key=" + String.valueOf(this.renameAttributes$key) + ", renameAttributes$value=" + String.valueOf(this.renameAttributes$value) + ", attributeToEnums$key=" + String.valueOf(this.attributeToEnums$key) + ", attributeToEnums$value=" + String.valueOf(this.attributeToEnums$value) + ", retypeAttributes$key=" + String.valueOf(this.retypeAttributes$key) + ", retypeAttributes$value=" + String.valueOf(this.retypeAttributes$value) + ", searchableRelationships$key=" + String.valueOf(this.searchableRelationships$key) + ", searchableRelationships$value=" + String.valueOf(this.searchableRelationships$value) + ")";
        }
    }
}

