/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICassandra;
import com.atlan.model.assets.ICassandraIndex;
import com.atlan.model.assets.ICassandraTable;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.INoSQL;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraIndex
extends Asset
implements ICassandraIndex,
ICassandra,
INoSQL,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CassandraIndex.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CassandraIndex";
    String typeName;
    @Attribute
    String cassandraIndexKind;
    @Attribute
    Map<String, String> cassandraIndexOptions;
    @Attribute
    String cassandraIndexQuery;
    @Attribute
    String cassandraKeyspaceName;
    @Attribute
    ICassandraTable cassandraTable;
    @Attribute
    String cassandraTableName;
    @Attribute
    String cassandraTableQualifiedName;
    @Attribute
    String cassandraViewName;
    @Attribute
    String cassandraViewQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    String noSQLSchemaDefinition;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public CassandraIndex trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return CassandraIndex.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return CassandraIndex.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return CassandraIndex.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return CassandraIndex.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static CassandraIndex refByGuid(String guid) {
        return CassandraIndex.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static CassandraIndex refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((CassandraIndexBuilder)((CassandraIndexBuilder)CassandraIndex._internal().guid(guid)).semantic(semantic)).build();
    }

    public static CassandraIndex refByQualifiedName(String qualifiedName) {
        return CassandraIndex.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static CassandraIndex refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((CassandraIndexBuilder)((CassandraIndexBuilder)CassandraIndex._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static CassandraIndex get(AtlanClient client, String id) throws AtlanException {
        return CassandraIndex.get(client, id, false);
    }

    @JsonIgnore
    public static CassandraIndex get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof CassandraIndex) {
                return (CassandraIndex)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof CassandraIndex) {
            return (CassandraIndex)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static CassandraIndex get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return CassandraIndex.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static CassandraIndex get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CassandraIndex.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof CassandraIndex) {
                return (CassandraIndex)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CassandraIndex.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof CassandraIndex) {
            return (CassandraIndex)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static CassandraIndexBuilder<?, ?> updater(String qualifiedName, String name) {
        return (CassandraIndexBuilder)((CassandraIndexBuilder)((CassandraIndexBuilder)CassandraIndex._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public CassandraIndexBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        CassandraIndex.validateRequired(TYPE_NAME, map);
        return CassandraIndex.updater(this.getQualifiedName(), this.getName());
    }

    public static CassandraIndex removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraIndex)Asset.removeDescription(client, CassandraIndex.updater(qualifiedName, name));
    }

    public static CassandraIndex removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraIndex)Asset.removeUserDescription(client, CassandraIndex.updater(qualifiedName, name));
    }

    public static CassandraIndex removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraIndex)Asset.removeOwners(client, CassandraIndex.updater(qualifiedName, name));
    }

    public static CassandraIndex updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CassandraIndex)Asset.updateCertificate(client, CassandraIndex._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static CassandraIndex removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraIndex)Asset.removeCertificate(client, CassandraIndex.updater(qualifiedName, name));
    }

    public static CassandraIndex updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CassandraIndex)Asset.updateAnnouncement(client, CassandraIndex._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static CassandraIndex removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraIndex)Asset.removeAnnouncement(client, CassandraIndex.updater(qualifiedName, name));
    }

    public static CassandraIndex replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CassandraIndex)Asset.replaceTerms(client, CassandraIndex.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static CassandraIndex appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CassandraIndex)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static CassandraIndex removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CassandraIndex)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static CassandraIndex appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CassandraIndex)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static CassandraIndex appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CassandraIndex)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected CassandraIndex(CassandraIndexBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> cassandraIndexOptions;
        this.typeName = b.typeName$set ? b.typeName$value : CassandraIndex.$default$typeName();
        this.cassandraIndexKind = b.cassandraIndexKind;
        switch (b.cassandraIndexOptions$key == null ? 0 : b.cassandraIndexOptions$key.size()) {
            case 0: {
                cassandraIndexOptions = Collections.emptyMap();
                break;
            }
            case 1: {
                cassandraIndexOptions = Collections.singletonMap(b.cassandraIndexOptions$key.get(0), b.cassandraIndexOptions$value.get(0));
                break;
            }
            default: {
                cassandraIndexOptions = new LinkedHashMap(b.cassandraIndexOptions$key.size() < 0x40000000 ? 1 + b.cassandraIndexOptions$key.size() + (b.cassandraIndexOptions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.cassandraIndexOptions$key.size(); ++$i) {
                    cassandraIndexOptions.put(b.cassandraIndexOptions$key.get($i), b.cassandraIndexOptions$value.get($i));
                }
                cassandraIndexOptions = Collections.unmodifiableMap(cassandraIndexOptions);
            }
        }
        this.cassandraIndexOptions = cassandraIndexOptions;
        this.cassandraIndexQuery = b.cassandraIndexQuery;
        this.cassandraKeyspaceName = b.cassandraKeyspaceName;
        this.cassandraTable = b.cassandraTable;
        this.cassandraTableName = b.cassandraTableName;
        this.cassandraTableQualifiedName = b.cassandraTableQualifiedName;
        this.cassandraViewName = b.cassandraViewName;
        this.cassandraViewQualifiedName = b.cassandraViewQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        this.noSQLSchemaDefinition = b.noSQLSchemaDefinition;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static CassandraIndexBuilder<?, ?> _internal() {
        return new CassandraIndexBuilderImpl();
    }

    @Generated
    public CassandraIndexBuilder<?, ?> toBuilder() {
        return new CassandraIndexBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getCassandraIndexKind() {
        return this.cassandraIndexKind;
    }

    @Override
    @Generated
    public Map<String, String> getCassandraIndexOptions() {
        return this.cassandraIndexOptions;
    }

    @Override
    @Generated
    public String getCassandraIndexQuery() {
        return this.cassandraIndexQuery;
    }

    @Override
    @Generated
    public String getCassandraKeyspaceName() {
        return this.cassandraKeyspaceName;
    }

    @Override
    @Generated
    public ICassandraTable getCassandraTable() {
        return this.cassandraTable;
    }

    @Override
    @Generated
    public String getCassandraTableName() {
        return this.cassandraTableName;
    }

    @Override
    @Generated
    public String getCassandraTableQualifiedName() {
        return this.cassandraTableQualifiedName;
    }

    @Override
    @Generated
    public String getCassandraViewName() {
        return this.cassandraViewName;
    }

    @Override
    @Generated
    public String getCassandraViewQualifiedName() {
        return this.cassandraViewQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public String getNoSQLSchemaDefinition() {
        return this.noSQLSchemaDefinition;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CassandraIndex)) {
            return false;
        }
        CassandraIndex other = (CassandraIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$cassandraIndexKind = this.getCassandraIndexKind();
        String other$cassandraIndexKind = other.getCassandraIndexKind();
        if (this$cassandraIndexKind == null ? other$cassandraIndexKind != null : !this$cassandraIndexKind.equals(other$cassandraIndexKind)) {
            return false;
        }
        Map<String, String> this$cassandraIndexOptions = this.getCassandraIndexOptions();
        Map<String, String> other$cassandraIndexOptions = other.getCassandraIndexOptions();
        if (this$cassandraIndexOptions == null ? other$cassandraIndexOptions != null : !((Object)this$cassandraIndexOptions).equals(other$cassandraIndexOptions)) {
            return false;
        }
        String this$cassandraIndexQuery = this.getCassandraIndexQuery();
        String other$cassandraIndexQuery = other.getCassandraIndexQuery();
        if (this$cassandraIndexQuery == null ? other$cassandraIndexQuery != null : !this$cassandraIndexQuery.equals(other$cassandraIndexQuery)) {
            return false;
        }
        String this$cassandraKeyspaceName = this.getCassandraKeyspaceName();
        String other$cassandraKeyspaceName = other.getCassandraKeyspaceName();
        if (this$cassandraKeyspaceName == null ? other$cassandraKeyspaceName != null : !this$cassandraKeyspaceName.equals(other$cassandraKeyspaceName)) {
            return false;
        }
        ICassandraTable this$cassandraTable = this.getCassandraTable();
        ICassandraTable other$cassandraTable = other.getCassandraTable();
        if (this$cassandraTable == null ? other$cassandraTable != null : !this$cassandraTable.equals(other$cassandraTable)) {
            return false;
        }
        String this$cassandraTableName = this.getCassandraTableName();
        String other$cassandraTableName = other.getCassandraTableName();
        if (this$cassandraTableName == null ? other$cassandraTableName != null : !this$cassandraTableName.equals(other$cassandraTableName)) {
            return false;
        }
        String this$cassandraTableQualifiedName = this.getCassandraTableQualifiedName();
        String other$cassandraTableQualifiedName = other.getCassandraTableQualifiedName();
        if (this$cassandraTableQualifiedName == null ? other$cassandraTableQualifiedName != null : !this$cassandraTableQualifiedName.equals(other$cassandraTableQualifiedName)) {
            return false;
        }
        String this$cassandraViewName = this.getCassandraViewName();
        String other$cassandraViewName = other.getCassandraViewName();
        if (this$cassandraViewName == null ? other$cassandraViewName != null : !this$cassandraViewName.equals(other$cassandraViewName)) {
            return false;
        }
        String this$cassandraViewQualifiedName = this.getCassandraViewQualifiedName();
        String other$cassandraViewQualifiedName = other.getCassandraViewQualifiedName();
        if (this$cassandraViewQualifiedName == null ? other$cassandraViewQualifiedName != null : !this$cassandraViewQualifiedName.equals(other$cassandraViewQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        String this$noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        String other$noSQLSchemaDefinition = other.getNoSQLSchemaDefinition();
        if (this$noSQLSchemaDefinition == null ? other$noSQLSchemaDefinition != null : !this$noSQLSchemaDefinition.equals(other$noSQLSchemaDefinition)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CassandraIndex;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $cassandraIndexKind = this.getCassandraIndexKind();
        result = result * 59 + ($cassandraIndexKind == null ? 43 : $cassandraIndexKind.hashCode());
        Map<String, String> $cassandraIndexOptions = this.getCassandraIndexOptions();
        result = result * 59 + ($cassandraIndexOptions == null ? 43 : ((Object)$cassandraIndexOptions).hashCode());
        String $cassandraIndexQuery = this.getCassandraIndexQuery();
        result = result * 59 + ($cassandraIndexQuery == null ? 43 : $cassandraIndexQuery.hashCode());
        String $cassandraKeyspaceName = this.getCassandraKeyspaceName();
        result = result * 59 + ($cassandraKeyspaceName == null ? 43 : $cassandraKeyspaceName.hashCode());
        ICassandraTable $cassandraTable = this.getCassandraTable();
        result = result * 59 + ($cassandraTable == null ? 43 : $cassandraTable.hashCode());
        String $cassandraTableName = this.getCassandraTableName();
        result = result * 59 + ($cassandraTableName == null ? 43 : $cassandraTableName.hashCode());
        String $cassandraTableQualifiedName = this.getCassandraTableQualifiedName();
        result = result * 59 + ($cassandraTableQualifiedName == null ? 43 : $cassandraTableQualifiedName.hashCode());
        String $cassandraViewName = this.getCassandraViewName();
        result = result * 59 + ($cassandraViewName == null ? 43 : $cassandraViewName.hashCode());
        String $cassandraViewQualifiedName = this.getCassandraViewQualifiedName();
        result = result * 59 + ($cassandraViewQualifiedName == null ? 43 : $cassandraViewQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        String $noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        result = result * 59 + ($noSQLSchemaDefinition == null ? 43 : $noSQLSchemaDefinition.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "CassandraIndex(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", cassandraIndexKind=" + this.getCassandraIndexKind() + ", cassandraIndexOptions=" + String.valueOf(this.getCassandraIndexOptions()) + ", cassandraIndexQuery=" + this.getCassandraIndexQuery() + ", cassandraKeyspaceName=" + this.getCassandraKeyspaceName() + ", cassandraTable=" + String.valueOf(this.getCassandraTable()) + ", cassandraTableName=" + this.getCassandraTableName() + ", cassandraTableQualifiedName=" + this.getCassandraTableQualifiedName() + ", cassandraViewName=" + this.getCassandraViewName() + ", cassandraViewQualifiedName=" + this.getCassandraViewQualifiedName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", noSQLSchemaDefinition=" + this.getNoSQLSchemaDefinition() + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class CassandraIndexBuilder<C extends CassandraIndex, B extends CassandraIndexBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String cassandraIndexKind;
        @Generated
        private ArrayList<String> cassandraIndexOptions$key;
        @Generated
        private ArrayList<String> cassandraIndexOptions$value;
        @Generated
        private String cassandraIndexQuery;
        @Generated
        private String cassandraKeyspaceName;
        @Generated
        private ICassandraTable cassandraTable;
        @Generated
        private String cassandraTableName;
        @Generated
        private String cassandraTableQualifiedName;
        @Generated
        private String cassandraViewName;
        @Generated
        private String cassandraViewQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private String noSQLSchemaDefinition;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CassandraIndexBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CassandraIndex instance, CassandraIndexBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.cassandraIndexKind(instance.cassandraIndexKind);
            b.cassandraIndexOptions(instance.cassandraIndexOptions == null ? Collections.emptyMap() : instance.cassandraIndexOptions);
            b.cassandraIndexQuery(instance.cassandraIndexQuery);
            b.cassandraKeyspaceName(instance.cassandraKeyspaceName);
            b.cassandraTable(instance.cassandraTable);
            b.cassandraTableName(instance.cassandraTableName);
            b.cassandraTableQualifiedName(instance.cassandraTableQualifiedName);
            b.cassandraViewName(instance.cassandraViewName);
            b.cassandraViewQualifiedName(instance.cassandraViewQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.noSQLSchemaDefinition(instance.noSQLSchemaDefinition);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B cassandraIndexKind(String cassandraIndexKind) {
            this.cassandraIndexKind = cassandraIndexKind;
            return (B)this.self();
        }

        @Generated
        public B cassandraIndexOption(String cassandraIndexOptionKey, String cassandraIndexOptionValue) {
            if (this.cassandraIndexOptions$key == null) {
                this.cassandraIndexOptions$key = new ArrayList();
                this.cassandraIndexOptions$value = new ArrayList();
            }
            this.cassandraIndexOptions$key.add(cassandraIndexOptionKey);
            this.cassandraIndexOptions$value.add(cassandraIndexOptionValue);
            return (B)this.self();
        }

        @Generated
        public B cassandraIndexOptions(Map<? extends String, ? extends String> cassandraIndexOptions) {
            if (cassandraIndexOptions == null) {
                throw new NullPointerException("cassandraIndexOptions cannot be null");
            }
            if (this.cassandraIndexOptions$key == null) {
                this.cassandraIndexOptions$key = new ArrayList();
                this.cassandraIndexOptions$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : cassandraIndexOptions.entrySet()) {
                this.cassandraIndexOptions$key.add($lombokEntry.getKey());
                this.cassandraIndexOptions$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearCassandraIndexOptions() {
            if (this.cassandraIndexOptions$key != null) {
                this.cassandraIndexOptions$key.clear();
                this.cassandraIndexOptions$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cassandraIndexQuery(String cassandraIndexQuery) {
            this.cassandraIndexQuery = cassandraIndexQuery;
            return (B)this.self();
        }

        @Generated
        public B cassandraKeyspaceName(String cassandraKeyspaceName) {
            this.cassandraKeyspaceName = cassandraKeyspaceName;
            return (B)this.self();
        }

        @Generated
        public B cassandraTable(ICassandraTable cassandraTable) {
            this.cassandraTable = cassandraTable;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableName(String cassandraTableName) {
            this.cassandraTableName = cassandraTableName;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableQualifiedName(String cassandraTableQualifiedName) {
            this.cassandraTableQualifiedName = cassandraTableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewName(String cassandraViewName) {
            this.cassandraViewName = cassandraViewName;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewQualifiedName(String cassandraViewQualifiedName) {
            this.cassandraViewQualifiedName = cassandraViewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B noSQLSchemaDefinition(String noSQLSchemaDefinition) {
            this.noSQLSchemaDefinition = noSQLSchemaDefinition;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CassandraIndex.CassandraIndexBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", cassandraIndexKind=" + this.cassandraIndexKind + ", cassandraIndexOptions$key=" + String.valueOf(this.cassandraIndexOptions$key) + ", cassandraIndexOptions$value=" + String.valueOf(this.cassandraIndexOptions$value) + ", cassandraIndexQuery=" + this.cassandraIndexQuery + ", cassandraKeyspaceName=" + this.cassandraKeyspaceName + ", cassandraTable=" + String.valueOf(this.cassandraTable) + ", cassandraTableName=" + this.cassandraTableName + ", cassandraTableQualifiedName=" + this.cassandraTableQualifiedName + ", cassandraViewName=" + this.cassandraViewName + ", cassandraViewQualifiedName=" + this.cassandraViewQualifiedName + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", noSQLSchemaDefinition=" + this.noSQLSchemaDefinition + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class CassandraIndexBuilderImpl
    extends CassandraIndexBuilder<CassandraIndex, CassandraIndexBuilderImpl> {
        @Generated
        private CassandraIndexBuilderImpl() {
        }

        @Override
        @Generated
        protected CassandraIndexBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CassandraIndex build() {
            return new CassandraIndex(this);
        }
    }
}

