/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICassandra;
import com.atlan.model.assets.ICassandraColumn;
import com.atlan.model.assets.ICassandraKeyspace;
import com.atlan.model.assets.ICassandraView;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.INoSQL;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraView
extends Asset
implements ICassandraView,
ICassandra,
INoSQL,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CassandraView.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CassandraView";
    String typeName;
    @Attribute
    SortedSet<ICassandraColumn> cassandraColumns;
    @Attribute
    ICassandraKeyspace cassandraKeyspace;
    @Attribute
    String cassandraKeyspaceName;
    @Attribute
    String cassandraTableName;
    @Attribute
    String cassandraTableQualifiedName;
    @Attribute
    Double cassandraViewBloomFilterFPChance;
    @Attribute
    Double cassandraViewCRCCheckChance;
    @Attribute
    Map<String, String> cassandraViewCaching;
    @Attribute
    String cassandraViewComment;
    @Attribute
    Map<String, String> cassandraViewCompaction;
    @Attribute
    Double cassandraViewDCLocalReadRepairChance;
    @Attribute
    Long cassandraViewDefaultTTL;
    @Attribute
    Long cassandraViewGCGraceSeconds;
    @Attribute
    Boolean cassandraViewIncludeAllColumns;
    @Attribute
    Long cassandraViewMaxIndexInterval;
    @Attribute
    Long cassandraViewMembtableFlushPeriodInMS;
    @Attribute
    Long cassandraViewMinIndexInterval;
    @Attribute
    String cassandraViewName;
    @Attribute
    String cassandraViewQualifiedName;
    @Attribute
    String cassandraViewQuery;
    @Attribute
    Long cassandraViewReadRepairInterval;
    @Attribute
    String cassandraViewSpeculativeRetry;
    @Attribute
    String cassandraViewTableId;
    @Attribute
    String cassandraViewWhereClause;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    String noSQLSchemaDefinition;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public CassandraView trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return CassandraView.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return CassandraView.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return CassandraView.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return CassandraView.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static CassandraView refByGuid(String guid) {
        return CassandraView.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static CassandraView refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((CassandraViewBuilder)((CassandraViewBuilder)CassandraView._internal().guid(guid)).semantic(semantic)).build();
    }

    public static CassandraView refByQualifiedName(String qualifiedName) {
        return CassandraView.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static CassandraView refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((CassandraViewBuilder)((CassandraViewBuilder)CassandraView._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static CassandraView get(AtlanClient client, String id) throws AtlanException {
        return CassandraView.get(client, id, false);
    }

    @JsonIgnore
    public static CassandraView get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof CassandraView) {
                return (CassandraView)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof CassandraView) {
            return (CassandraView)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static CassandraView get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return CassandraView.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static CassandraView get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CassandraView.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof CassandraView) {
                return (CassandraView)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CassandraView.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof CassandraView) {
            return (CassandraView)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static CassandraViewBuilder<?, ?> updater(String qualifiedName, String name) {
        return (CassandraViewBuilder)((CassandraViewBuilder)((CassandraViewBuilder)CassandraView._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public CassandraViewBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        CassandraView.validateRequired(TYPE_NAME, map);
        return CassandraView.updater(this.getQualifiedName(), this.getName());
    }

    public static CassandraView removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraView)Asset.removeDescription(client, CassandraView.updater(qualifiedName, name));
    }

    public static CassandraView removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraView)Asset.removeUserDescription(client, CassandraView.updater(qualifiedName, name));
    }

    public static CassandraView removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraView)Asset.removeOwners(client, CassandraView.updater(qualifiedName, name));
    }

    public static CassandraView updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CassandraView)Asset.updateCertificate(client, CassandraView._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static CassandraView removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraView)Asset.removeCertificate(client, CassandraView.updater(qualifiedName, name));
    }

    public static CassandraView updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CassandraView)Asset.updateAnnouncement(client, CassandraView._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static CassandraView removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraView)Asset.removeAnnouncement(client, CassandraView.updater(qualifiedName, name));
    }

    public static CassandraView replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CassandraView)Asset.replaceTerms(client, CassandraView.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static CassandraView appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CassandraView)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static CassandraView removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CassandraView)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static CassandraView appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CassandraView)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static CassandraView appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CassandraView)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected CassandraView(CassandraViewBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> cassandraViewCompaction;
        Map<Object, Object> cassandraViewCaching;
        this.typeName = b.typeName$set ? b.typeName$value : CassandraView.$default$typeName();
        SortedSet<ICassandraColumn> cassandraColumns = new TreeSet<ICassandraColumn>();
        if (b.cassandraColumns != null) {
            cassandraColumns.addAll(b.cassandraColumns);
        }
        cassandraColumns = Collections.unmodifiableSortedSet(cassandraColumns);
        this.cassandraColumns = cassandraColumns;
        this.cassandraKeyspace = b.cassandraKeyspace;
        this.cassandraKeyspaceName = b.cassandraKeyspaceName;
        this.cassandraTableName = b.cassandraTableName;
        this.cassandraTableQualifiedName = b.cassandraTableQualifiedName;
        this.cassandraViewBloomFilterFPChance = b.cassandraViewBloomFilterFPChance;
        this.cassandraViewCRCCheckChance = b.cassandraViewCRCCheckChance;
        switch (b.cassandraViewCaching$key == null ? 0 : b.cassandraViewCaching$key.size()) {
            case 0: {
                cassandraViewCaching = Collections.emptyMap();
                break;
            }
            case 1: {
                cassandraViewCaching = Collections.singletonMap(b.cassandraViewCaching$key.get(0), b.cassandraViewCaching$value.get(0));
                break;
            }
            default: {
                cassandraViewCaching = new LinkedHashMap(b.cassandraViewCaching$key.size() < 0x40000000 ? 1 + b.cassandraViewCaching$key.size() + (b.cassandraViewCaching$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.cassandraViewCaching$key.size(); ++$i) {
                    cassandraViewCaching.put(b.cassandraViewCaching$key.get($i), b.cassandraViewCaching$value.get($i));
                }
                cassandraViewCaching = Collections.unmodifiableMap(cassandraViewCaching);
            }
        }
        this.cassandraViewCaching = cassandraViewCaching;
        this.cassandraViewComment = b.cassandraViewComment;
        switch (b.cassandraViewCompaction$key == null ? 0 : b.cassandraViewCompaction$key.size()) {
            case 0: {
                cassandraViewCompaction = Collections.emptyMap();
                break;
            }
            case 1: {
                cassandraViewCompaction = Collections.singletonMap(b.cassandraViewCompaction$key.get(0), b.cassandraViewCompaction$value.get(0));
                break;
            }
            default: {
                cassandraViewCompaction = new LinkedHashMap(b.cassandraViewCompaction$key.size() < 0x40000000 ? 1 + b.cassandraViewCompaction$key.size() + (b.cassandraViewCompaction$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.cassandraViewCompaction$key.size(); ++$i) {
                    cassandraViewCompaction.put(b.cassandraViewCompaction$key.get($i), b.cassandraViewCompaction$value.get($i));
                }
                cassandraViewCompaction = Collections.unmodifiableMap(cassandraViewCompaction);
            }
        }
        this.cassandraViewCompaction = cassandraViewCompaction;
        this.cassandraViewDCLocalReadRepairChance = b.cassandraViewDCLocalReadRepairChance;
        this.cassandraViewDefaultTTL = b.cassandraViewDefaultTTL;
        this.cassandraViewGCGraceSeconds = b.cassandraViewGCGraceSeconds;
        this.cassandraViewIncludeAllColumns = b.cassandraViewIncludeAllColumns;
        this.cassandraViewMaxIndexInterval = b.cassandraViewMaxIndexInterval;
        this.cassandraViewMembtableFlushPeriodInMS = b.cassandraViewMembtableFlushPeriodInMS;
        this.cassandraViewMinIndexInterval = b.cassandraViewMinIndexInterval;
        this.cassandraViewName = b.cassandraViewName;
        this.cassandraViewQualifiedName = b.cassandraViewQualifiedName;
        this.cassandraViewQuery = b.cassandraViewQuery;
        this.cassandraViewReadRepairInterval = b.cassandraViewReadRepairInterval;
        this.cassandraViewSpeculativeRetry = b.cassandraViewSpeculativeRetry;
        this.cassandraViewTableId = b.cassandraViewTableId;
        this.cassandraViewWhereClause = b.cassandraViewWhereClause;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        this.noSQLSchemaDefinition = b.noSQLSchemaDefinition;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static CassandraViewBuilder<?, ?> _internal() {
        return new CassandraViewBuilderImpl();
    }

    @Generated
    public CassandraViewBuilder<?, ?> toBuilder() {
        return new CassandraViewBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<ICassandraColumn> getCassandraColumns() {
        return this.cassandraColumns;
    }

    @Override
    @Generated
    public ICassandraKeyspace getCassandraKeyspace() {
        return this.cassandraKeyspace;
    }

    @Override
    @Generated
    public String getCassandraKeyspaceName() {
        return this.cassandraKeyspaceName;
    }

    @Override
    @Generated
    public String getCassandraTableName() {
        return this.cassandraTableName;
    }

    @Override
    @Generated
    public String getCassandraTableQualifiedName() {
        return this.cassandraTableQualifiedName;
    }

    @Override
    @Generated
    public Double getCassandraViewBloomFilterFPChance() {
        return this.cassandraViewBloomFilterFPChance;
    }

    @Override
    @Generated
    public Double getCassandraViewCRCCheckChance() {
        return this.cassandraViewCRCCheckChance;
    }

    @Override
    @Generated
    public Map<String, String> getCassandraViewCaching() {
        return this.cassandraViewCaching;
    }

    @Override
    @Generated
    public String getCassandraViewComment() {
        return this.cassandraViewComment;
    }

    @Override
    @Generated
    public Map<String, String> getCassandraViewCompaction() {
        return this.cassandraViewCompaction;
    }

    @Override
    @Generated
    public Double getCassandraViewDCLocalReadRepairChance() {
        return this.cassandraViewDCLocalReadRepairChance;
    }

    @Override
    @Generated
    public Long getCassandraViewDefaultTTL() {
        return this.cassandraViewDefaultTTL;
    }

    @Override
    @Generated
    public Long getCassandraViewGCGraceSeconds() {
        return this.cassandraViewGCGraceSeconds;
    }

    @Override
    @Generated
    public Boolean getCassandraViewIncludeAllColumns() {
        return this.cassandraViewIncludeAllColumns;
    }

    @Override
    @Generated
    public Long getCassandraViewMaxIndexInterval() {
        return this.cassandraViewMaxIndexInterval;
    }

    @Override
    @Generated
    public Long getCassandraViewMembtableFlushPeriodInMS() {
        return this.cassandraViewMembtableFlushPeriodInMS;
    }

    @Override
    @Generated
    public Long getCassandraViewMinIndexInterval() {
        return this.cassandraViewMinIndexInterval;
    }

    @Override
    @Generated
    public String getCassandraViewName() {
        return this.cassandraViewName;
    }

    @Override
    @Generated
    public String getCassandraViewQualifiedName() {
        return this.cassandraViewQualifiedName;
    }

    @Override
    @Generated
    public String getCassandraViewQuery() {
        return this.cassandraViewQuery;
    }

    @Override
    @Generated
    public Long getCassandraViewReadRepairInterval() {
        return this.cassandraViewReadRepairInterval;
    }

    @Override
    @Generated
    public String getCassandraViewSpeculativeRetry() {
        return this.cassandraViewSpeculativeRetry;
    }

    @Override
    @Generated
    public String getCassandraViewTableId() {
        return this.cassandraViewTableId;
    }

    @Override
    @Generated
    public String getCassandraViewWhereClause() {
        return this.cassandraViewWhereClause;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public String getNoSQLSchemaDefinition() {
        return this.noSQLSchemaDefinition;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CassandraView)) {
            return false;
        }
        CassandraView other = (CassandraView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$cassandraViewBloomFilterFPChance = this.getCassandraViewBloomFilterFPChance();
        Double other$cassandraViewBloomFilterFPChance = other.getCassandraViewBloomFilterFPChance();
        if (this$cassandraViewBloomFilterFPChance == null ? other$cassandraViewBloomFilterFPChance != null : !((Object)this$cassandraViewBloomFilterFPChance).equals(other$cassandraViewBloomFilterFPChance)) {
            return false;
        }
        Double this$cassandraViewCRCCheckChance = this.getCassandraViewCRCCheckChance();
        Double other$cassandraViewCRCCheckChance = other.getCassandraViewCRCCheckChance();
        if (this$cassandraViewCRCCheckChance == null ? other$cassandraViewCRCCheckChance != null : !((Object)this$cassandraViewCRCCheckChance).equals(other$cassandraViewCRCCheckChance)) {
            return false;
        }
        Double this$cassandraViewDCLocalReadRepairChance = this.getCassandraViewDCLocalReadRepairChance();
        Double other$cassandraViewDCLocalReadRepairChance = other.getCassandraViewDCLocalReadRepairChance();
        if (this$cassandraViewDCLocalReadRepairChance == null ? other$cassandraViewDCLocalReadRepairChance != null : !((Object)this$cassandraViewDCLocalReadRepairChance).equals(other$cassandraViewDCLocalReadRepairChance)) {
            return false;
        }
        Long this$cassandraViewDefaultTTL = this.getCassandraViewDefaultTTL();
        Long other$cassandraViewDefaultTTL = other.getCassandraViewDefaultTTL();
        if (this$cassandraViewDefaultTTL == null ? other$cassandraViewDefaultTTL != null : !((Object)this$cassandraViewDefaultTTL).equals(other$cassandraViewDefaultTTL)) {
            return false;
        }
        Long this$cassandraViewGCGraceSeconds = this.getCassandraViewGCGraceSeconds();
        Long other$cassandraViewGCGraceSeconds = other.getCassandraViewGCGraceSeconds();
        if (this$cassandraViewGCGraceSeconds == null ? other$cassandraViewGCGraceSeconds != null : !((Object)this$cassandraViewGCGraceSeconds).equals(other$cassandraViewGCGraceSeconds)) {
            return false;
        }
        Boolean this$cassandraViewIncludeAllColumns = this.getCassandraViewIncludeAllColumns();
        Boolean other$cassandraViewIncludeAllColumns = other.getCassandraViewIncludeAllColumns();
        if (this$cassandraViewIncludeAllColumns == null ? other$cassandraViewIncludeAllColumns != null : !((Object)this$cassandraViewIncludeAllColumns).equals(other$cassandraViewIncludeAllColumns)) {
            return false;
        }
        Long this$cassandraViewMaxIndexInterval = this.getCassandraViewMaxIndexInterval();
        Long other$cassandraViewMaxIndexInterval = other.getCassandraViewMaxIndexInterval();
        if (this$cassandraViewMaxIndexInterval == null ? other$cassandraViewMaxIndexInterval != null : !((Object)this$cassandraViewMaxIndexInterval).equals(other$cassandraViewMaxIndexInterval)) {
            return false;
        }
        Long this$cassandraViewMembtableFlushPeriodInMS = this.getCassandraViewMembtableFlushPeriodInMS();
        Long other$cassandraViewMembtableFlushPeriodInMS = other.getCassandraViewMembtableFlushPeriodInMS();
        if (this$cassandraViewMembtableFlushPeriodInMS == null ? other$cassandraViewMembtableFlushPeriodInMS != null : !((Object)this$cassandraViewMembtableFlushPeriodInMS).equals(other$cassandraViewMembtableFlushPeriodInMS)) {
            return false;
        }
        Long this$cassandraViewMinIndexInterval = this.getCassandraViewMinIndexInterval();
        Long other$cassandraViewMinIndexInterval = other.getCassandraViewMinIndexInterval();
        if (this$cassandraViewMinIndexInterval == null ? other$cassandraViewMinIndexInterval != null : !((Object)this$cassandraViewMinIndexInterval).equals(other$cassandraViewMinIndexInterval)) {
            return false;
        }
        Long this$cassandraViewReadRepairInterval = this.getCassandraViewReadRepairInterval();
        Long other$cassandraViewReadRepairInterval = other.getCassandraViewReadRepairInterval();
        if (this$cassandraViewReadRepairInterval == null ? other$cassandraViewReadRepairInterval != null : !((Object)this$cassandraViewReadRepairInterval).equals(other$cassandraViewReadRepairInterval)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<ICassandraColumn> this$cassandraColumns = this.getCassandraColumns();
        SortedSet<ICassandraColumn> other$cassandraColumns = other.getCassandraColumns();
        if (this$cassandraColumns == null ? other$cassandraColumns != null : !this$cassandraColumns.equals(other$cassandraColumns)) {
            return false;
        }
        ICassandraKeyspace this$cassandraKeyspace = this.getCassandraKeyspace();
        ICassandraKeyspace other$cassandraKeyspace = other.getCassandraKeyspace();
        if (this$cassandraKeyspace == null ? other$cassandraKeyspace != null : !this$cassandraKeyspace.equals(other$cassandraKeyspace)) {
            return false;
        }
        String this$cassandraKeyspaceName = this.getCassandraKeyspaceName();
        String other$cassandraKeyspaceName = other.getCassandraKeyspaceName();
        if (this$cassandraKeyspaceName == null ? other$cassandraKeyspaceName != null : !this$cassandraKeyspaceName.equals(other$cassandraKeyspaceName)) {
            return false;
        }
        String this$cassandraTableName = this.getCassandraTableName();
        String other$cassandraTableName = other.getCassandraTableName();
        if (this$cassandraTableName == null ? other$cassandraTableName != null : !this$cassandraTableName.equals(other$cassandraTableName)) {
            return false;
        }
        String this$cassandraTableQualifiedName = this.getCassandraTableQualifiedName();
        String other$cassandraTableQualifiedName = other.getCassandraTableQualifiedName();
        if (this$cassandraTableQualifiedName == null ? other$cassandraTableQualifiedName != null : !this$cassandraTableQualifiedName.equals(other$cassandraTableQualifiedName)) {
            return false;
        }
        Map<String, String> this$cassandraViewCaching = this.getCassandraViewCaching();
        Map<String, String> other$cassandraViewCaching = other.getCassandraViewCaching();
        if (this$cassandraViewCaching == null ? other$cassandraViewCaching != null : !((Object)this$cassandraViewCaching).equals(other$cassandraViewCaching)) {
            return false;
        }
        String this$cassandraViewComment = this.getCassandraViewComment();
        String other$cassandraViewComment = other.getCassandraViewComment();
        if (this$cassandraViewComment == null ? other$cassandraViewComment != null : !this$cassandraViewComment.equals(other$cassandraViewComment)) {
            return false;
        }
        Map<String, String> this$cassandraViewCompaction = this.getCassandraViewCompaction();
        Map<String, String> other$cassandraViewCompaction = other.getCassandraViewCompaction();
        if (this$cassandraViewCompaction == null ? other$cassandraViewCompaction != null : !((Object)this$cassandraViewCompaction).equals(other$cassandraViewCompaction)) {
            return false;
        }
        String this$cassandraViewName = this.getCassandraViewName();
        String other$cassandraViewName = other.getCassandraViewName();
        if (this$cassandraViewName == null ? other$cassandraViewName != null : !this$cassandraViewName.equals(other$cassandraViewName)) {
            return false;
        }
        String this$cassandraViewQualifiedName = this.getCassandraViewQualifiedName();
        String other$cassandraViewQualifiedName = other.getCassandraViewQualifiedName();
        if (this$cassandraViewQualifiedName == null ? other$cassandraViewQualifiedName != null : !this$cassandraViewQualifiedName.equals(other$cassandraViewQualifiedName)) {
            return false;
        }
        String this$cassandraViewQuery = this.getCassandraViewQuery();
        String other$cassandraViewQuery = other.getCassandraViewQuery();
        if (this$cassandraViewQuery == null ? other$cassandraViewQuery != null : !this$cassandraViewQuery.equals(other$cassandraViewQuery)) {
            return false;
        }
        String this$cassandraViewSpeculativeRetry = this.getCassandraViewSpeculativeRetry();
        String other$cassandraViewSpeculativeRetry = other.getCassandraViewSpeculativeRetry();
        if (this$cassandraViewSpeculativeRetry == null ? other$cassandraViewSpeculativeRetry != null : !this$cassandraViewSpeculativeRetry.equals(other$cassandraViewSpeculativeRetry)) {
            return false;
        }
        String this$cassandraViewTableId = this.getCassandraViewTableId();
        String other$cassandraViewTableId = other.getCassandraViewTableId();
        if (this$cassandraViewTableId == null ? other$cassandraViewTableId != null : !this$cassandraViewTableId.equals(other$cassandraViewTableId)) {
            return false;
        }
        String this$cassandraViewWhereClause = this.getCassandraViewWhereClause();
        String other$cassandraViewWhereClause = other.getCassandraViewWhereClause();
        if (this$cassandraViewWhereClause == null ? other$cassandraViewWhereClause != null : !this$cassandraViewWhereClause.equals(other$cassandraViewWhereClause)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        String this$noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        String other$noSQLSchemaDefinition = other.getNoSQLSchemaDefinition();
        if (this$noSQLSchemaDefinition == null ? other$noSQLSchemaDefinition != null : !this$noSQLSchemaDefinition.equals(other$noSQLSchemaDefinition)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CassandraView;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $cassandraViewBloomFilterFPChance = this.getCassandraViewBloomFilterFPChance();
        result = result * 59 + ($cassandraViewBloomFilterFPChance == null ? 43 : ((Object)$cassandraViewBloomFilterFPChance).hashCode());
        Double $cassandraViewCRCCheckChance = this.getCassandraViewCRCCheckChance();
        result = result * 59 + ($cassandraViewCRCCheckChance == null ? 43 : ((Object)$cassandraViewCRCCheckChance).hashCode());
        Double $cassandraViewDCLocalReadRepairChance = this.getCassandraViewDCLocalReadRepairChance();
        result = result * 59 + ($cassandraViewDCLocalReadRepairChance == null ? 43 : ((Object)$cassandraViewDCLocalReadRepairChance).hashCode());
        Long $cassandraViewDefaultTTL = this.getCassandraViewDefaultTTL();
        result = result * 59 + ($cassandraViewDefaultTTL == null ? 43 : ((Object)$cassandraViewDefaultTTL).hashCode());
        Long $cassandraViewGCGraceSeconds = this.getCassandraViewGCGraceSeconds();
        result = result * 59 + ($cassandraViewGCGraceSeconds == null ? 43 : ((Object)$cassandraViewGCGraceSeconds).hashCode());
        Boolean $cassandraViewIncludeAllColumns = this.getCassandraViewIncludeAllColumns();
        result = result * 59 + ($cassandraViewIncludeAllColumns == null ? 43 : ((Object)$cassandraViewIncludeAllColumns).hashCode());
        Long $cassandraViewMaxIndexInterval = this.getCassandraViewMaxIndexInterval();
        result = result * 59 + ($cassandraViewMaxIndexInterval == null ? 43 : ((Object)$cassandraViewMaxIndexInterval).hashCode());
        Long $cassandraViewMembtableFlushPeriodInMS = this.getCassandraViewMembtableFlushPeriodInMS();
        result = result * 59 + ($cassandraViewMembtableFlushPeriodInMS == null ? 43 : ((Object)$cassandraViewMembtableFlushPeriodInMS).hashCode());
        Long $cassandraViewMinIndexInterval = this.getCassandraViewMinIndexInterval();
        result = result * 59 + ($cassandraViewMinIndexInterval == null ? 43 : ((Object)$cassandraViewMinIndexInterval).hashCode());
        Long $cassandraViewReadRepairInterval = this.getCassandraViewReadRepairInterval();
        result = result * 59 + ($cassandraViewReadRepairInterval == null ? 43 : ((Object)$cassandraViewReadRepairInterval).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<ICassandraColumn> $cassandraColumns = this.getCassandraColumns();
        result = result * 59 + ($cassandraColumns == null ? 43 : $cassandraColumns.hashCode());
        ICassandraKeyspace $cassandraKeyspace = this.getCassandraKeyspace();
        result = result * 59 + ($cassandraKeyspace == null ? 43 : $cassandraKeyspace.hashCode());
        String $cassandraKeyspaceName = this.getCassandraKeyspaceName();
        result = result * 59 + ($cassandraKeyspaceName == null ? 43 : $cassandraKeyspaceName.hashCode());
        String $cassandraTableName = this.getCassandraTableName();
        result = result * 59 + ($cassandraTableName == null ? 43 : $cassandraTableName.hashCode());
        String $cassandraTableQualifiedName = this.getCassandraTableQualifiedName();
        result = result * 59 + ($cassandraTableQualifiedName == null ? 43 : $cassandraTableQualifiedName.hashCode());
        Map<String, String> $cassandraViewCaching = this.getCassandraViewCaching();
        result = result * 59 + ($cassandraViewCaching == null ? 43 : ((Object)$cassandraViewCaching).hashCode());
        String $cassandraViewComment = this.getCassandraViewComment();
        result = result * 59 + ($cassandraViewComment == null ? 43 : $cassandraViewComment.hashCode());
        Map<String, String> $cassandraViewCompaction = this.getCassandraViewCompaction();
        result = result * 59 + ($cassandraViewCompaction == null ? 43 : ((Object)$cassandraViewCompaction).hashCode());
        String $cassandraViewName = this.getCassandraViewName();
        result = result * 59 + ($cassandraViewName == null ? 43 : $cassandraViewName.hashCode());
        String $cassandraViewQualifiedName = this.getCassandraViewQualifiedName();
        result = result * 59 + ($cassandraViewQualifiedName == null ? 43 : $cassandraViewQualifiedName.hashCode());
        String $cassandraViewQuery = this.getCassandraViewQuery();
        result = result * 59 + ($cassandraViewQuery == null ? 43 : $cassandraViewQuery.hashCode());
        String $cassandraViewSpeculativeRetry = this.getCassandraViewSpeculativeRetry();
        result = result * 59 + ($cassandraViewSpeculativeRetry == null ? 43 : $cassandraViewSpeculativeRetry.hashCode());
        String $cassandraViewTableId = this.getCassandraViewTableId();
        result = result * 59 + ($cassandraViewTableId == null ? 43 : $cassandraViewTableId.hashCode());
        String $cassandraViewWhereClause = this.getCassandraViewWhereClause();
        result = result * 59 + ($cassandraViewWhereClause == null ? 43 : $cassandraViewWhereClause.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        String $noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        result = result * 59 + ($noSQLSchemaDefinition == null ? 43 : $noSQLSchemaDefinition.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "CassandraView(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", cassandraColumns=" + String.valueOf(this.getCassandraColumns()) + ", cassandraKeyspace=" + String.valueOf(this.getCassandraKeyspace()) + ", cassandraKeyspaceName=" + this.getCassandraKeyspaceName() + ", cassandraTableName=" + this.getCassandraTableName() + ", cassandraTableQualifiedName=" + this.getCassandraTableQualifiedName() + ", cassandraViewBloomFilterFPChance=" + this.getCassandraViewBloomFilterFPChance() + ", cassandraViewCRCCheckChance=" + this.getCassandraViewCRCCheckChance() + ", cassandraViewCaching=" + String.valueOf(this.getCassandraViewCaching()) + ", cassandraViewComment=" + this.getCassandraViewComment() + ", cassandraViewCompaction=" + String.valueOf(this.getCassandraViewCompaction()) + ", cassandraViewDCLocalReadRepairChance=" + this.getCassandraViewDCLocalReadRepairChance() + ", cassandraViewDefaultTTL=" + this.getCassandraViewDefaultTTL() + ", cassandraViewGCGraceSeconds=" + this.getCassandraViewGCGraceSeconds() + ", cassandraViewIncludeAllColumns=" + this.getCassandraViewIncludeAllColumns() + ", cassandraViewMaxIndexInterval=" + this.getCassandraViewMaxIndexInterval() + ", cassandraViewMembtableFlushPeriodInMS=" + this.getCassandraViewMembtableFlushPeriodInMS() + ", cassandraViewMinIndexInterval=" + this.getCassandraViewMinIndexInterval() + ", cassandraViewName=" + this.getCassandraViewName() + ", cassandraViewQualifiedName=" + this.getCassandraViewQualifiedName() + ", cassandraViewQuery=" + this.getCassandraViewQuery() + ", cassandraViewReadRepairInterval=" + this.getCassandraViewReadRepairInterval() + ", cassandraViewSpeculativeRetry=" + this.getCassandraViewSpeculativeRetry() + ", cassandraViewTableId=" + this.getCassandraViewTableId() + ", cassandraViewWhereClause=" + this.getCassandraViewWhereClause() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", noSQLSchemaDefinition=" + this.getNoSQLSchemaDefinition() + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class CassandraViewBuilder<C extends CassandraView, B extends CassandraViewBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<ICassandraColumn> cassandraColumns;
        @Generated
        private ICassandraKeyspace cassandraKeyspace;
        @Generated
        private String cassandraKeyspaceName;
        @Generated
        private String cassandraTableName;
        @Generated
        private String cassandraTableQualifiedName;
        @Generated
        private Double cassandraViewBloomFilterFPChance;
        @Generated
        private Double cassandraViewCRCCheckChance;
        @Generated
        private ArrayList<String> cassandraViewCaching$key;
        @Generated
        private ArrayList<String> cassandraViewCaching$value;
        @Generated
        private String cassandraViewComment;
        @Generated
        private ArrayList<String> cassandraViewCompaction$key;
        @Generated
        private ArrayList<String> cassandraViewCompaction$value;
        @Generated
        private Double cassandraViewDCLocalReadRepairChance;
        @Generated
        private Long cassandraViewDefaultTTL;
        @Generated
        private Long cassandraViewGCGraceSeconds;
        @Generated
        private Boolean cassandraViewIncludeAllColumns;
        @Generated
        private Long cassandraViewMaxIndexInterval;
        @Generated
        private Long cassandraViewMembtableFlushPeriodInMS;
        @Generated
        private Long cassandraViewMinIndexInterval;
        @Generated
        private String cassandraViewName;
        @Generated
        private String cassandraViewQualifiedName;
        @Generated
        private String cassandraViewQuery;
        @Generated
        private Long cassandraViewReadRepairInterval;
        @Generated
        private String cassandraViewSpeculativeRetry;
        @Generated
        private String cassandraViewTableId;
        @Generated
        private String cassandraViewWhereClause;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private String noSQLSchemaDefinition;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CassandraViewBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CassandraView instance, CassandraViewBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.cassandraColumns(instance.cassandraColumns == null ? Collections.emptySortedSet() : instance.cassandraColumns);
            b.cassandraKeyspace(instance.cassandraKeyspace);
            b.cassandraKeyspaceName(instance.cassandraKeyspaceName);
            b.cassandraTableName(instance.cassandraTableName);
            b.cassandraTableQualifiedName(instance.cassandraTableQualifiedName);
            b.cassandraViewBloomFilterFPChance(instance.cassandraViewBloomFilterFPChance);
            b.cassandraViewCRCCheckChance(instance.cassandraViewCRCCheckChance);
            b.cassandraViewCaching(instance.cassandraViewCaching == null ? Collections.emptyMap() : instance.cassandraViewCaching);
            b.cassandraViewComment(instance.cassandraViewComment);
            b.cassandraViewCompaction(instance.cassandraViewCompaction == null ? Collections.emptyMap() : instance.cassandraViewCompaction);
            b.cassandraViewDCLocalReadRepairChance(instance.cassandraViewDCLocalReadRepairChance);
            b.cassandraViewDefaultTTL(instance.cassandraViewDefaultTTL);
            b.cassandraViewGCGraceSeconds(instance.cassandraViewGCGraceSeconds);
            b.cassandraViewIncludeAllColumns(instance.cassandraViewIncludeAllColumns);
            b.cassandraViewMaxIndexInterval(instance.cassandraViewMaxIndexInterval);
            b.cassandraViewMembtableFlushPeriodInMS(instance.cassandraViewMembtableFlushPeriodInMS);
            b.cassandraViewMinIndexInterval(instance.cassandraViewMinIndexInterval);
            b.cassandraViewName(instance.cassandraViewName);
            b.cassandraViewQualifiedName(instance.cassandraViewQualifiedName);
            b.cassandraViewQuery(instance.cassandraViewQuery);
            b.cassandraViewReadRepairInterval(instance.cassandraViewReadRepairInterval);
            b.cassandraViewSpeculativeRetry(instance.cassandraViewSpeculativeRetry);
            b.cassandraViewTableId(instance.cassandraViewTableId);
            b.cassandraViewWhereClause(instance.cassandraViewWhereClause);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.noSQLSchemaDefinition(instance.noSQLSchemaDefinition);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B cassandraColumn(ICassandraColumn cassandraColumn) {
            if (this.cassandraColumns == null) {
                this.cassandraColumns = new ArrayList();
            }
            this.cassandraColumns.add(cassandraColumn);
            return (B)this.self();
        }

        @Generated
        public B cassandraColumns(Collection<? extends ICassandraColumn> cassandraColumns) {
            if (cassandraColumns == null) {
                throw new NullPointerException("cassandraColumns cannot be null");
            }
            if (this.cassandraColumns == null) {
                this.cassandraColumns = new ArrayList();
            }
            this.cassandraColumns.addAll(cassandraColumns);
            return (B)this.self();
        }

        @Generated
        public B clearCassandraColumns() {
            if (this.cassandraColumns != null) {
                this.cassandraColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cassandraKeyspace(ICassandraKeyspace cassandraKeyspace) {
            this.cassandraKeyspace = cassandraKeyspace;
            return (B)this.self();
        }

        @Generated
        public B cassandraKeyspaceName(String cassandraKeyspaceName) {
            this.cassandraKeyspaceName = cassandraKeyspaceName;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableName(String cassandraTableName) {
            this.cassandraTableName = cassandraTableName;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableQualifiedName(String cassandraTableQualifiedName) {
            this.cassandraTableQualifiedName = cassandraTableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewBloomFilterFPChance(Double cassandraViewBloomFilterFPChance) {
            this.cassandraViewBloomFilterFPChance = cassandraViewBloomFilterFPChance;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewCRCCheckChance(Double cassandraViewCRCCheckChance) {
            this.cassandraViewCRCCheckChance = cassandraViewCRCCheckChance;
            return (B)this.self();
        }

        @Generated
        public B putCassandraViewCaching(String putCassandraViewCachingKey, String putCassandraViewCachingValue) {
            if (this.cassandraViewCaching$key == null) {
                this.cassandraViewCaching$key = new ArrayList();
                this.cassandraViewCaching$value = new ArrayList();
            }
            this.cassandraViewCaching$key.add(putCassandraViewCachingKey);
            this.cassandraViewCaching$value.add(putCassandraViewCachingValue);
            return (B)this.self();
        }

        @Generated
        public B cassandraViewCaching(Map<? extends String, ? extends String> cassandraViewCaching) {
            if (cassandraViewCaching == null) {
                throw new NullPointerException("cassandraViewCaching cannot be null");
            }
            if (this.cassandraViewCaching$key == null) {
                this.cassandraViewCaching$key = new ArrayList();
                this.cassandraViewCaching$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : cassandraViewCaching.entrySet()) {
                this.cassandraViewCaching$key.add($lombokEntry.getKey());
                this.cassandraViewCaching$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearCassandraViewCaching() {
            if (this.cassandraViewCaching$key != null) {
                this.cassandraViewCaching$key.clear();
                this.cassandraViewCaching$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cassandraViewComment(String cassandraViewComment) {
            this.cassandraViewComment = cassandraViewComment;
            return (B)this.self();
        }

        @Generated
        public B putCassandraViewCompaction(String putCassandraViewCompactionKey, String putCassandraViewCompactionValue) {
            if (this.cassandraViewCompaction$key == null) {
                this.cassandraViewCompaction$key = new ArrayList();
                this.cassandraViewCompaction$value = new ArrayList();
            }
            this.cassandraViewCompaction$key.add(putCassandraViewCompactionKey);
            this.cassandraViewCompaction$value.add(putCassandraViewCompactionValue);
            return (B)this.self();
        }

        @Generated
        public B cassandraViewCompaction(Map<? extends String, ? extends String> cassandraViewCompaction) {
            if (cassandraViewCompaction == null) {
                throw new NullPointerException("cassandraViewCompaction cannot be null");
            }
            if (this.cassandraViewCompaction$key == null) {
                this.cassandraViewCompaction$key = new ArrayList();
                this.cassandraViewCompaction$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : cassandraViewCompaction.entrySet()) {
                this.cassandraViewCompaction$key.add($lombokEntry.getKey());
                this.cassandraViewCompaction$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearCassandraViewCompaction() {
            if (this.cassandraViewCompaction$key != null) {
                this.cassandraViewCompaction$key.clear();
                this.cassandraViewCompaction$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cassandraViewDCLocalReadRepairChance(Double cassandraViewDCLocalReadRepairChance) {
            this.cassandraViewDCLocalReadRepairChance = cassandraViewDCLocalReadRepairChance;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewDefaultTTL(Long cassandraViewDefaultTTL) {
            this.cassandraViewDefaultTTL = cassandraViewDefaultTTL;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewGCGraceSeconds(Long cassandraViewGCGraceSeconds) {
            this.cassandraViewGCGraceSeconds = cassandraViewGCGraceSeconds;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewIncludeAllColumns(Boolean cassandraViewIncludeAllColumns) {
            this.cassandraViewIncludeAllColumns = cassandraViewIncludeAllColumns;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewMaxIndexInterval(Long cassandraViewMaxIndexInterval) {
            this.cassandraViewMaxIndexInterval = cassandraViewMaxIndexInterval;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewMembtableFlushPeriodInMS(Long cassandraViewMembtableFlushPeriodInMS) {
            this.cassandraViewMembtableFlushPeriodInMS = cassandraViewMembtableFlushPeriodInMS;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewMinIndexInterval(Long cassandraViewMinIndexInterval) {
            this.cassandraViewMinIndexInterval = cassandraViewMinIndexInterval;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewName(String cassandraViewName) {
            this.cassandraViewName = cassandraViewName;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewQualifiedName(String cassandraViewQualifiedName) {
            this.cassandraViewQualifiedName = cassandraViewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewQuery(String cassandraViewQuery) {
            this.cassandraViewQuery = cassandraViewQuery;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewReadRepairInterval(Long cassandraViewReadRepairInterval) {
            this.cassandraViewReadRepairInterval = cassandraViewReadRepairInterval;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewSpeculativeRetry(String cassandraViewSpeculativeRetry) {
            this.cassandraViewSpeculativeRetry = cassandraViewSpeculativeRetry;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewTableId(String cassandraViewTableId) {
            this.cassandraViewTableId = cassandraViewTableId;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewWhereClause(String cassandraViewWhereClause) {
            this.cassandraViewWhereClause = cassandraViewWhereClause;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B noSQLSchemaDefinition(String noSQLSchemaDefinition) {
            this.noSQLSchemaDefinition = noSQLSchemaDefinition;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CassandraView.CassandraViewBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", cassandraColumns=" + String.valueOf(this.cassandraColumns) + ", cassandraKeyspace=" + String.valueOf(this.cassandraKeyspace) + ", cassandraKeyspaceName=" + this.cassandraKeyspaceName + ", cassandraTableName=" + this.cassandraTableName + ", cassandraTableQualifiedName=" + this.cassandraTableQualifiedName + ", cassandraViewBloomFilterFPChance=" + this.cassandraViewBloomFilterFPChance + ", cassandraViewCRCCheckChance=" + this.cassandraViewCRCCheckChance + ", cassandraViewCaching$key=" + String.valueOf(this.cassandraViewCaching$key) + ", cassandraViewCaching$value=" + String.valueOf(this.cassandraViewCaching$value) + ", cassandraViewComment=" + this.cassandraViewComment + ", cassandraViewCompaction$key=" + String.valueOf(this.cassandraViewCompaction$key) + ", cassandraViewCompaction$value=" + String.valueOf(this.cassandraViewCompaction$value) + ", cassandraViewDCLocalReadRepairChance=" + this.cassandraViewDCLocalReadRepairChance + ", cassandraViewDefaultTTL=" + this.cassandraViewDefaultTTL + ", cassandraViewGCGraceSeconds=" + this.cassandraViewGCGraceSeconds + ", cassandraViewIncludeAllColumns=" + this.cassandraViewIncludeAllColumns + ", cassandraViewMaxIndexInterval=" + this.cassandraViewMaxIndexInterval + ", cassandraViewMembtableFlushPeriodInMS=" + this.cassandraViewMembtableFlushPeriodInMS + ", cassandraViewMinIndexInterval=" + this.cassandraViewMinIndexInterval + ", cassandraViewName=" + this.cassandraViewName + ", cassandraViewQualifiedName=" + this.cassandraViewQualifiedName + ", cassandraViewQuery=" + this.cassandraViewQuery + ", cassandraViewReadRepairInterval=" + this.cassandraViewReadRepairInterval + ", cassandraViewSpeculativeRetry=" + this.cassandraViewSpeculativeRetry + ", cassandraViewTableId=" + this.cassandraViewTableId + ", cassandraViewWhereClause=" + this.cassandraViewWhereClause + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", noSQLSchemaDefinition=" + this.noSQLSchemaDefinition + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class CassandraViewBuilderImpl
    extends CassandraViewBuilder<CassandraView, CassandraViewBuilderImpl> {
        @Generated
        private CassandraViewBuilderImpl() {
        }

        @Override
        @Generated
        protected CassandraViewBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CassandraView build() {
            return new CassandraView(this);
        }
    }
}

