/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IAtlanQuery;
import com.atlan.model.assets.ICalculationView;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IColumn;
import com.atlan.model.assets.ICosmosMongoDBCollection;
import com.atlan.model.assets.IDbtMetric;
import com.atlan.model.assets.IDbtModel;
import com.atlan.model.assets.IDbtModelColumn;
import com.atlan.model.assets.IDbtSource;
import com.atlan.model.assets.IDbtTest;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMaterializedView;
import com.atlan.model.assets.IMetric;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISQL;
import com.atlan.model.assets.ISnowflakeDynamicTable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.ITable;
import com.atlan.model.assets.ITablePartition;
import com.atlan.model.assets.IView;
import com.atlan.model.assets.MaterializedView;
import com.atlan.model.assets.SnowflakeDynamicTable;
import com.atlan.model.assets.Table;
import com.atlan.model.assets.TablePartition;
import com.atlan.model.assets.View;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.ColumnValueFrequencyMap;
import com.atlan.model.structs.Histogram;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Column
extends Asset
implements IColumn,
ISQL,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Column.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Column";
    String typeName;
    @Attribute
    ICalculationView calculationView;
    @Attribute
    String calculationViewName;
    @Attribute
    String calculationViewQualifiedName;
    @Attribute
    Double columnAverage;
    @Attribute
    Double columnAverageLength;
    @Attribute
    String columnCompression;
    @Attribute
    SortedSet<IDbtModelColumn> columnDbtModelColumns;
    @Attribute
    Integer columnDepthLevel;
    @Attribute
    Integer columnDistinctValuesCount;
    @Attribute
    Long columnDistinctValuesCountLong;
    @Attribute
    Integer columnDuplicateValuesCount;
    @Attribute
    Long columnDuplicateValuesCountLong;
    @Attribute
    String columnEncoding;
    @Attribute
    List<Map<String, String>> columnHierarchy;
    @Attribute
    Histogram columnHistogram;
    @Attribute
    Double columnMax;
    @Attribute
    Integer columnMaximumStringLength;
    @Attribute
    SortedSet<String> columnMaxs;
    @Attribute
    Double columnMean;
    @Attribute
    Double columnMedian;
    @Attribute
    Double columnMin;
    @Attribute
    Integer columnMinimumStringLength;
    @Attribute
    SortedSet<String> columnMins;
    @Attribute
    Integer columnMissingValuesCount;
    @Attribute
    Long columnMissingValuesCountLong;
    @Attribute
    Double columnMissingValuesPercentage;
    @Attribute
    Double columnStandardDeviation;
    @Attribute
    Double columnSum;
    @Attribute
    List<ColumnValueFrequencyMap> columnTopValues;
    @Attribute
    Integer columnUniqueValuesCount;
    @Attribute
    Long columnUniqueValuesCountLong;
    @Attribute
    Double columnUniquenessPercentage;
    @Attribute
    Double columnVariance;
    @Attribute
    ICosmosMongoDBCollection cosmosMongoDBCollection;
    @Attribute
    SortedSet<IMetric> dataQualityMetricDimensions;
    @Attribute
    String dataType;
    @Attribute
    String databaseName;
    @Attribute
    String databaseQualifiedName;
    @Attribute
    SortedSet<IDbtMetric> dbtMetrics;
    @Attribute
    SortedSet<IDbtModelColumn> dbtModelColumns;
    @Attribute
    SortedSet<IDbtModel> dbtModels;
    @Attribute
    SortedSet<IDbtSource> dbtSources;
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    @Attribute
    String defaultValue;
    @Attribute
    IColumn foreignKeyFrom;
    @Attribute
    SortedSet<IColumn> foreignKeyTo;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    Boolean isClustered;
    @Attribute
    Boolean isDist;
    @Attribute
    Boolean isForeign;
    @Attribute
    Boolean isIndexed;
    @Attribute
    Boolean isNullable;
    @Attribute
    Boolean isPartition;
    @Attribute
    Boolean isPinned;
    @Attribute
    Boolean isPrimary;
    @Attribute
    Boolean isProfiled;
    @Attribute
    Boolean isSort;
    @Attribute
    @Date
    Long lastProfiledAt;
    @Attribute
    @JsonProperty(value="materialisedView")
    IMaterializedView materializedView;
    @Attribute
    Long maxLength;
    @Attribute
    SortedSet<IMetric> metricTimestamps;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    Integer nestedColumnCount;
    @Attribute
    String nestedColumnOrder;
    @Attribute
    SortedSet<IColumn> nestedColumns;
    @Attribute
    String nosqlCollectionName;
    @Attribute
    String nosqlCollectionQualifiedName;
    @Attribute
    Double numericScale;
    @Attribute
    Integer order;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    IColumn parentColumn;
    @Attribute
    String parentColumnName;
    @Attribute
    String parentColumnQualifiedName;
    @Attribute
    Integer partitionOrder;
    @Attribute
    @Date
    Long pinnedAt;
    @Attribute
    String pinnedBy;
    @Attribute
    Integer precision;
    @Attribute
    SortedSet<IAtlanQuery> queries;
    @Attribute
    Long queryCount;
    @Attribute
    @Date
    Long queryCountUpdatedAt;
    @Attribute
    Long queryUserCount;
    @Attribute
    Map<String, Long> queryUserMap;
    @Attribute
    String rawDataTypeDefinition;
    @Attribute
    String schemaName;
    @Attribute
    String schemaQualifiedName;
    @Attribute
    ISnowflakeDynamicTable snowflakeDynamicTable;
    @Attribute
    SortedSet<IDbtSource> sqlDBTSources;
    @Attribute
    SortedSet<IDbtModel> sqlDbtModels;
    @Attribute
    String subDataType;
    @Attribute
    ITable table;
    @Attribute
    String tableName;
    @Attribute
    ITablePartition tablePartition;
    @Attribute
    String tableQualifiedName;
    @Attribute
    Map<String, String> validations;
    @Attribute
    IView view;
    @Attribute
    String viewName;
    @Attribute
    String viewQualifiedName;

    @Override
    public Column trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return Column.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return Column.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return Column.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return Column.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static Column refByGuid(String guid) {
        return Column.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static Column refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((ColumnBuilder)((ColumnBuilder)Column._internal().guid(guid)).semantic(semantic)).build();
    }

    public static Column refByQualifiedName(String qualifiedName) {
        return Column.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static Column refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((ColumnBuilder)((ColumnBuilder)Column._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static Column get(AtlanClient client, String id) throws AtlanException {
        return Column.get(client, id, false);
    }

    @JsonIgnore
    public static Column get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof Column) {
                return (Column)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof Column) {
            return (Column)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static Column get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return Column.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static Column get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Column.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof Column) {
                return (Column)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Column.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof Column) {
            return (Column)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public ISQL getParent() {
        if (this.table != null) {
            return (ISQL)((Object)this.table);
        }
        if (this.view != null) {
            return (ISQL)((Object)this.view);
        }
        if (this.materializedView != null) {
            return (ISQL)((Object)this.materializedView);
        }
        if (this.tablePartition != null) {
            return (ISQL)((Object)this.tablePartition);
        }
        return null;
    }

    public static ColumnBuilder<?, ?> creator(String name, Table table, int order) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("connectionQualifiedName", table.getConnectionQualifiedName());
        map.put("databaseName", table.getDatabaseName());
        map.put("databaseQualifiedName", table.getDatabaseQualifiedName());
        map.put("schemaName", table.getSchemaName());
        map.put("name", table.getName());
        map.put("qualifiedName", table.getQualifiedName());
        Column.validateRelationship("Table", map);
        return Column.creator(name, table.getConnectionQualifiedName(), table.getDatabaseName(), table.getDatabaseQualifiedName(), table.getSchemaName(), table.getSchemaQualifiedName(), table.getName(), table.getQualifiedName(), "Table", null, null, order).table(table.trimToReference());
    }

    public static ColumnBuilder<?, ?> creator(String name, TablePartition partition, int order) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("connectionQualifiedName", partition.getConnectionQualifiedName());
        map.put("databaseName", partition.getDatabaseName());
        map.put("databaseQualifiedName", partition.getDatabaseQualifiedName());
        map.put("schemaName", partition.getSchemaName());
        map.put("schemaQualifiedName", partition.getSchemaQualifiedName());
        map.put("name", partition.getName());
        map.put("qualifiedName", partition.getQualifiedName());
        Column.validateRelationship("TablePartition", map);
        return Column.creator(name, partition.getConnectionQualifiedName(), partition.getDatabaseName(), partition.getDatabaseQualifiedName(), partition.getSchemaName(), partition.getSchemaQualifiedName(), partition.getName(), partition.getQualifiedName(), "TablePartition", null, null, order).tablePartition(partition.trimToReference());
    }

    public static ColumnBuilder<?, ?> creator(String name, View view, int order) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("connectionQualifiedName", view.getConnectionQualifiedName());
        map.put("databaseName", view.getDatabaseName());
        map.put("databaseQualifiedName", view.getDatabaseQualifiedName());
        map.put("schemaName", view.getSchemaName());
        map.put("schemaQualifiedName", view.getSchemaQualifiedName());
        map.put("name", view.getName());
        map.put("qualifiedName", view.getQualifiedName());
        Column.validateRelationship("View", map);
        return Column.creator(name, view.getConnectionQualifiedName(), view.getDatabaseName(), view.getDatabaseQualifiedName(), view.getSchemaName(), view.getSchemaQualifiedName(), view.getName(), view.getQualifiedName(), "View", null, null, order).view(view.trimToReference());
    }

    public static ColumnBuilder<?, ?> creator(String name, MaterializedView view, int order) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("connectionQualifiedName", view.getConnectionQualifiedName());
        map.put("databaseName", view.getDatabaseName());
        map.put("databaseQualifiedName", view.getDatabaseQualifiedName());
        map.put("schemaName", view.getSchemaName());
        map.put("schemaQualifiedName", view.getSchemaQualifiedName());
        map.put("name", view.getName());
        map.put("qualifiedName", view.getQualifiedName());
        Column.validateRelationship("MaterialisedView", map);
        return Column.creator(name, view.getConnectionQualifiedName(), view.getDatabaseName(), view.getDatabaseQualifiedName(), view.getSchemaName(), view.getSchemaQualifiedName(), view.getName(), view.getQualifiedName(), "MaterialisedView", null, null, order).materializedView(view.trimToReference());
    }

    public static ColumnBuilder<?, ?> creator(String name, String parentType, String parentQualifiedName, int order) {
        String parentName = StringUtils.getNameFromQualifiedName(parentQualifiedName);
        String schemaQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(parentQualifiedName);
        String schemaName = StringUtils.getNameFromQualifiedName(schemaQualifiedName);
        String databaseQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(schemaQualifiedName);
        String databaseName = StringUtils.getNameFromQualifiedName(databaseQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(databaseQualifiedName);
        return Column.creator(name, connectionQualifiedName, databaseName, databaseQualifiedName, schemaName, schemaQualifiedName, parentName, parentQualifiedName, parentType, null, null, order);
    }

    public static ColumnBuilder<?, ?> creator(String name, String connectionQualifiedName, String databaseName, String databaseQualifiedName, String schemaName, String schemaQualifiedName, String parentName, String parentQualifiedName, String parentType, String tableName, String tableQualifiedName, int order) {
        Object builder = ((ColumnBuilder)((Asset.AssetBuilder)((ColumnBuilder)((ColumnBuilder)((ColumnBuilder)((ColumnBuilder)((ColumnBuilder)((ColumnBuilder)Column._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).qualifiedName(Column.generateQualifiedName(name, parentQualifiedName))).schemaName(schemaName)).schemaQualifiedName(schemaQualifiedName)).databaseName(databaseName)).databaseQualifiedName(databaseQualifiedName)).connectionQualifiedName(connectionQualifiedName)).order(order);
        switch (parentType) {
            case "Table": {
                ((ColumnBuilder)((ColumnBuilder)((ColumnBuilder)builder).tableName(parentName)).tableQualifiedName(parentQualifiedName)).table(Table.refByQualifiedName(parentQualifiedName));
                break;
            }
            case "View": {
                ((ColumnBuilder)((ColumnBuilder)((ColumnBuilder)builder).viewName(parentName)).viewQualifiedName(parentQualifiedName)).view(View.refByQualifiedName(parentQualifiedName));
                break;
            }
            case "MaterialisedView": {
                ((ColumnBuilder)((ColumnBuilder)((ColumnBuilder)builder).viewName(parentName)).viewQualifiedName(parentQualifiedName)).materializedView(MaterializedView.refByQualifiedName(parentQualifiedName));
                break;
            }
            case "TablePartition": {
                ((ColumnBuilder)((ColumnBuilder)((ColumnBuilder)builder).tableName(parentName)).tableQualifiedName(parentQualifiedName)).tablePartition(TablePartition.refByQualifiedName(parentQualifiedName));
                break;
            }
            case "SnowflakeDynamicTable": {
                ((ColumnBuilder)((ColumnBuilder)((ColumnBuilder)builder).tableName(parentName)).tableQualifiedName(parentQualifiedName)).snowflakeDynamicTable(SnowflakeDynamicTable.refByQualifiedName(parentQualifiedName));
            }
        }
        return builder;
    }

    public static String generateQualifiedName(String name, String parentQualifiedName) {
        return parentQualifiedName + "/" + name;
    }

    public static ColumnBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ColumnBuilder)((ColumnBuilder)((ColumnBuilder)Column._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ColumnBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        Column.validateRequired(TYPE_NAME, map);
        return Column.updater(this.getQualifiedName(), this.getName());
    }

    public static Column removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Column)Asset.removeDescription(client, Column.updater(qualifiedName, name));
    }

    public static Column removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Column)Asset.removeUserDescription(client, Column.updater(qualifiedName, name));
    }

    public static Column removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Column)Asset.removeOwners(client, Column.updater(qualifiedName, name));
    }

    public static Column updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (Column)Asset.updateCertificate(client, Column._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Column removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Column)Asset.removeCertificate(client, Column.updater(qualifiedName, name));
    }

    public static Column updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Column)Asset.updateAnnouncement(client, Column._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Column removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Column)Asset.removeAnnouncement(client, Column.updater(qualifiedName, name));
    }

    public static Column replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (Column)Asset.replaceTerms(client, Column.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static Column appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Column)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static Column removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Column)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static Column appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Column)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static Column appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Column)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Column(ColumnBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> validations;
        Map<Object, Object> queryUserMap;
        this.typeName = b.typeName$set ? b.typeName$value : Column.$default$typeName();
        this.calculationView = b.calculationView;
        this.calculationViewName = b.calculationViewName;
        this.calculationViewQualifiedName = b.calculationViewQualifiedName;
        this.columnAverage = b.columnAverage;
        this.columnAverageLength = b.columnAverageLength;
        this.columnCompression = b.columnCompression;
        SortedSet<IDbtModelColumn> columnDbtModelColumns = new TreeSet<IDbtModelColumn>();
        if (b.columnDbtModelColumns != null) {
            columnDbtModelColumns.addAll(b.columnDbtModelColumns);
        }
        columnDbtModelColumns = Collections.unmodifiableSortedSet(columnDbtModelColumns);
        this.columnDbtModelColumns = columnDbtModelColumns;
        this.columnDepthLevel = b.columnDepthLevel;
        this.columnDistinctValuesCount = b.columnDistinctValuesCount;
        this.columnDistinctValuesCountLong = b.columnDistinctValuesCountLong;
        this.columnDuplicateValuesCount = b.columnDuplicateValuesCount;
        this.columnDuplicateValuesCountLong = b.columnDuplicateValuesCountLong;
        this.columnEncoding = b.columnEncoding;
        this.columnHierarchy = switch (b.columnHierarchy == null ? 0 : b.columnHierarchy.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.columnHierarchy.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.columnHierarchy));
        };
        this.columnHistogram = b.columnHistogram;
        this.columnMax = b.columnMax;
        this.columnMaximumStringLength = b.columnMaximumStringLength;
        SortedSet<String> columnMaxs = new TreeSet<String>();
        if (b.columnMaxs != null) {
            columnMaxs.addAll(b.columnMaxs);
        }
        columnMaxs = Collections.unmodifiableSortedSet(columnMaxs);
        this.columnMaxs = columnMaxs;
        this.columnMean = b.columnMean;
        this.columnMedian = b.columnMedian;
        this.columnMin = b.columnMin;
        this.columnMinimumStringLength = b.columnMinimumStringLength;
        SortedSet<String> columnMins = new TreeSet<String>();
        if (b.columnMins != null) {
            columnMins.addAll(b.columnMins);
        }
        columnMins = Collections.unmodifiableSortedSet(columnMins);
        this.columnMins = columnMins;
        this.columnMissingValuesCount = b.columnMissingValuesCount;
        this.columnMissingValuesCountLong = b.columnMissingValuesCountLong;
        this.columnMissingValuesPercentage = b.columnMissingValuesPercentage;
        this.columnStandardDeviation = b.columnStandardDeviation;
        this.columnSum = b.columnSum;
        this.columnTopValues = switch (b.columnTopValues == null ? 0 : b.columnTopValues.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.columnTopValues.get(0));
            default -> Collections.unmodifiableList(new ArrayList<ColumnValueFrequencyMap>(b.columnTopValues));
        };
        this.columnUniqueValuesCount = b.columnUniqueValuesCount;
        this.columnUniqueValuesCountLong = b.columnUniqueValuesCountLong;
        this.columnUniquenessPercentage = b.columnUniquenessPercentage;
        this.columnVariance = b.columnVariance;
        this.cosmosMongoDBCollection = b.cosmosMongoDBCollection;
        SortedSet<IMetric> dataQualityMetricDimensions = new TreeSet<IMetric>();
        if (b.dataQualityMetricDimensions != null) {
            dataQualityMetricDimensions.addAll(b.dataQualityMetricDimensions);
        }
        dataQualityMetricDimensions = Collections.unmodifiableSortedSet(dataQualityMetricDimensions);
        this.dataQualityMetricDimensions = dataQualityMetricDimensions;
        this.dataType = b.dataType;
        this.databaseName = b.databaseName;
        this.databaseQualifiedName = b.databaseQualifiedName;
        SortedSet<IDbtMetric> dbtMetrics = new TreeSet<IDbtMetric>();
        if (b.dbtMetrics != null) {
            dbtMetrics.addAll(b.dbtMetrics);
        }
        dbtMetrics = Collections.unmodifiableSortedSet(dbtMetrics);
        this.dbtMetrics = dbtMetrics;
        SortedSet<IDbtModelColumn> dbtModelColumns = new TreeSet<IDbtModelColumn>();
        if (b.dbtModelColumns != null) {
            dbtModelColumns.addAll(b.dbtModelColumns);
        }
        dbtModelColumns = Collections.unmodifiableSortedSet(dbtModelColumns);
        this.dbtModelColumns = dbtModelColumns;
        SortedSet<IDbtModel> dbtModels = new TreeSet<IDbtModel>();
        if (b.dbtModels != null) {
            dbtModels.addAll(b.dbtModels);
        }
        dbtModels = Collections.unmodifiableSortedSet(dbtModels);
        this.dbtModels = dbtModels;
        SortedSet<IDbtSource> dbtSources = new TreeSet<IDbtSource>();
        if (b.dbtSources != null) {
            dbtSources.addAll(b.dbtSources);
        }
        dbtSources = Collections.unmodifiableSortedSet(dbtSources);
        this.dbtSources = dbtSources;
        SortedSet<IDbtTest> dbtTests = new TreeSet<IDbtTest>();
        if (b.dbtTests != null) {
            dbtTests.addAll(b.dbtTests);
        }
        dbtTests = Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        this.defaultValue = b.defaultValue;
        this.foreignKeyFrom = b.foreignKeyFrom;
        SortedSet<IColumn> foreignKeyTo = new TreeSet<IColumn>();
        if (b.foreignKeyTo != null) {
            foreignKeyTo.addAll(b.foreignKeyTo);
        }
        foreignKeyTo = Collections.unmodifiableSortedSet(foreignKeyTo);
        this.foreignKeyTo = foreignKeyTo;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isClustered = b.isClustered;
        this.isDist = b.isDist;
        this.isForeign = b.isForeign;
        this.isIndexed = b.isIndexed;
        this.isNullable = b.isNullable;
        this.isPartition = b.isPartition;
        this.isPinned = b.isPinned;
        this.isPrimary = b.isPrimary;
        this.isProfiled = b.isProfiled;
        this.isSort = b.isSort;
        this.lastProfiledAt = b.lastProfiledAt;
        this.materializedView = b.materializedView;
        this.maxLength = b.maxLength;
        SortedSet<IMetric> metricTimestamps = new TreeSet<IMetric>();
        if (b.metricTimestamps != null) {
            metricTimestamps.addAll(b.metricTimestamps);
        }
        metricTimestamps = Collections.unmodifiableSortedSet(metricTimestamps);
        this.metricTimestamps = metricTimestamps;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        this.nestedColumnCount = b.nestedColumnCount;
        this.nestedColumnOrder = b.nestedColumnOrder;
        SortedSet<IColumn> nestedColumns = new TreeSet<IColumn>();
        if (b.nestedColumns != null) {
            nestedColumns.addAll(b.nestedColumns);
        }
        nestedColumns = Collections.unmodifiableSortedSet(nestedColumns);
        this.nestedColumns = nestedColumns;
        this.nosqlCollectionName = b.nosqlCollectionName;
        this.nosqlCollectionQualifiedName = b.nosqlCollectionQualifiedName;
        this.numericScale = b.numericScale;
        this.order = b.order;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.parentColumn = b.parentColumn;
        this.parentColumnName = b.parentColumnName;
        this.parentColumnQualifiedName = b.parentColumnQualifiedName;
        this.partitionOrder = b.partitionOrder;
        this.pinnedAt = b.pinnedAt;
        this.pinnedBy = b.pinnedBy;
        this.precision = b.precision;
        SortedSet<IAtlanQuery> queries = new TreeSet<IAtlanQuery>();
        if (b.queries != null) {
            queries.addAll(b.queries);
        }
        queries = Collections.unmodifiableSortedSet(queries);
        this.queries = queries;
        this.queryCount = b.queryCount;
        this.queryCountUpdatedAt = b.queryCountUpdatedAt;
        this.queryUserCount = b.queryUserCount;
        switch (b.queryUserMap$key == null ? 0 : b.queryUserMap$key.size()) {
            case 0: {
                queryUserMap = Collections.emptyMap();
                break;
            }
            case 1: {
                queryUserMap = Collections.singletonMap(b.queryUserMap$key.get(0), b.queryUserMap$value.get(0));
                break;
            }
            default: {
                queryUserMap = new LinkedHashMap(b.queryUserMap$key.size() < 0x40000000 ? 1 + b.queryUserMap$key.size() + (b.queryUserMap$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryUserMap$key.size(); ++$i) {
                    queryUserMap.put(b.queryUserMap$key.get($i), b.queryUserMap$value.get($i));
                }
                queryUserMap = Collections.unmodifiableMap(queryUserMap);
            }
        }
        this.queryUserMap = queryUserMap;
        this.rawDataTypeDefinition = b.rawDataTypeDefinition;
        this.schemaName = b.schemaName;
        this.schemaQualifiedName = b.schemaQualifiedName;
        this.snowflakeDynamicTable = b.snowflakeDynamicTable;
        SortedSet<IDbtSource> sqlDBTSources = new TreeSet<IDbtSource>();
        if (b.sqlDBTSources != null) {
            sqlDBTSources.addAll(b.sqlDBTSources);
        }
        sqlDBTSources = Collections.unmodifiableSortedSet(sqlDBTSources);
        this.sqlDBTSources = sqlDBTSources;
        SortedSet<IDbtModel> sqlDbtModels = new TreeSet<IDbtModel>();
        if (b.sqlDbtModels != null) {
            sqlDbtModels.addAll(b.sqlDbtModels);
        }
        sqlDbtModels = Collections.unmodifiableSortedSet(sqlDbtModels);
        this.sqlDbtModels = sqlDbtModels;
        this.subDataType = b.subDataType;
        this.table = b.table;
        this.tableName = b.tableName;
        this.tablePartition = b.tablePartition;
        this.tableQualifiedName = b.tableQualifiedName;
        switch (b.validations$key == null ? 0 : b.validations$key.size()) {
            case 0: {
                validations = Collections.emptyMap();
                break;
            }
            case 1: {
                validations = Collections.singletonMap(b.validations$key.get(0), b.validations$value.get(0));
                break;
            }
            default: {
                validations = new LinkedHashMap(b.validations$key.size() < 0x40000000 ? 1 + b.validations$key.size() + (b.validations$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.validations$key.size(); ++$i) {
                    validations.put(b.validations$key.get($i), b.validations$value.get($i));
                }
                validations = Collections.unmodifiableMap(validations);
            }
        }
        this.validations = validations;
        this.view = b.view;
        this.viewName = b.viewName;
        this.viewQualifiedName = b.viewQualifiedName;
    }

    @Generated
    public static ColumnBuilder<?, ?> _internal() {
        return new ColumnBuilderImpl();
    }

    @Generated
    public ColumnBuilder<?, ?> toBuilder() {
        return new ColumnBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public ICalculationView getCalculationView() {
        return this.calculationView;
    }

    @Override
    @Generated
    public String getCalculationViewName() {
        return this.calculationViewName;
    }

    @Override
    @Generated
    public String getCalculationViewQualifiedName() {
        return this.calculationViewQualifiedName;
    }

    @Override
    @Generated
    public Double getColumnAverage() {
        return this.columnAverage;
    }

    @Override
    @Generated
    public Double getColumnAverageLength() {
        return this.columnAverageLength;
    }

    @Override
    @Generated
    public String getColumnCompression() {
        return this.columnCompression;
    }

    @Override
    @Generated
    public SortedSet<IDbtModelColumn> getColumnDbtModelColumns() {
        return this.columnDbtModelColumns;
    }

    @Override
    @Generated
    public Integer getColumnDepthLevel() {
        return this.columnDepthLevel;
    }

    @Override
    @Generated
    public Integer getColumnDistinctValuesCount() {
        return this.columnDistinctValuesCount;
    }

    @Override
    @Generated
    public Long getColumnDistinctValuesCountLong() {
        return this.columnDistinctValuesCountLong;
    }

    @Override
    @Generated
    public Integer getColumnDuplicateValuesCount() {
        return this.columnDuplicateValuesCount;
    }

    @Override
    @Generated
    public Long getColumnDuplicateValuesCountLong() {
        return this.columnDuplicateValuesCountLong;
    }

    @Override
    @Generated
    public String getColumnEncoding() {
        return this.columnEncoding;
    }

    @Override
    @Generated
    public List<Map<String, String>> getColumnHierarchy() {
        return this.columnHierarchy;
    }

    @Override
    @Generated
    public Histogram getColumnHistogram() {
        return this.columnHistogram;
    }

    @Override
    @Generated
    public Double getColumnMax() {
        return this.columnMax;
    }

    @Override
    @Generated
    public Integer getColumnMaximumStringLength() {
        return this.columnMaximumStringLength;
    }

    @Override
    @Generated
    public SortedSet<String> getColumnMaxs() {
        return this.columnMaxs;
    }

    @Override
    @Generated
    public Double getColumnMean() {
        return this.columnMean;
    }

    @Override
    @Generated
    public Double getColumnMedian() {
        return this.columnMedian;
    }

    @Override
    @Generated
    public Double getColumnMin() {
        return this.columnMin;
    }

    @Override
    @Generated
    public Integer getColumnMinimumStringLength() {
        return this.columnMinimumStringLength;
    }

    @Override
    @Generated
    public SortedSet<String> getColumnMins() {
        return this.columnMins;
    }

    @Override
    @Generated
    public Integer getColumnMissingValuesCount() {
        return this.columnMissingValuesCount;
    }

    @Override
    @Generated
    public Long getColumnMissingValuesCountLong() {
        return this.columnMissingValuesCountLong;
    }

    @Override
    @Generated
    public Double getColumnMissingValuesPercentage() {
        return this.columnMissingValuesPercentage;
    }

    @Override
    @Generated
    public Double getColumnStandardDeviation() {
        return this.columnStandardDeviation;
    }

    @Override
    @Generated
    public Double getColumnSum() {
        return this.columnSum;
    }

    @Override
    @Generated
    public List<ColumnValueFrequencyMap> getColumnTopValues() {
        return this.columnTopValues;
    }

    @Override
    @Generated
    public Integer getColumnUniqueValuesCount() {
        return this.columnUniqueValuesCount;
    }

    @Override
    @Generated
    public Long getColumnUniqueValuesCountLong() {
        return this.columnUniqueValuesCountLong;
    }

    @Override
    @Generated
    public Double getColumnUniquenessPercentage() {
        return this.columnUniquenessPercentage;
    }

    @Override
    @Generated
    public Double getColumnVariance() {
        return this.columnVariance;
    }

    @Override
    @Generated
    public ICosmosMongoDBCollection getCosmosMongoDBCollection() {
        return this.cosmosMongoDBCollection;
    }

    @Override
    @Generated
    public SortedSet<IMetric> getDataQualityMetricDimensions() {
        return this.dataQualityMetricDimensions;
    }

    @Override
    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Override
    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    @Generated
    public String getDatabaseQualifiedName() {
        return this.databaseQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IDbtMetric> getDbtMetrics() {
        return this.dbtMetrics;
    }

    @Override
    @Generated
    public SortedSet<IDbtModelColumn> getDbtModelColumns() {
        return this.dbtModelColumns;
    }

    @Override
    @Generated
    public SortedSet<IDbtModel> getDbtModels() {
        return this.dbtModels;
    }

    @Override
    @Generated
    public SortedSet<IDbtSource> getDbtSources() {
        return this.dbtSources;
    }

    @Override
    @Generated
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    @Override
    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @Generated
    public IColumn getForeignKeyFrom() {
        return this.foreignKeyFrom;
    }

    @Override
    @Generated
    public SortedSet<IColumn> getForeignKeyTo() {
        return this.foreignKeyTo;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public Boolean getIsClustered() {
        return this.isClustered;
    }

    @Override
    @Generated
    public Boolean getIsDist() {
        return this.isDist;
    }

    @Override
    @Generated
    public Boolean getIsForeign() {
        return this.isForeign;
    }

    @Override
    @Generated
    public Boolean getIsIndexed() {
        return this.isIndexed;
    }

    @Override
    @Generated
    public Boolean getIsNullable() {
        return this.isNullable;
    }

    @Override
    @Generated
    public Boolean getIsPartition() {
        return this.isPartition;
    }

    @Override
    @Generated
    public Boolean getIsPinned() {
        return this.isPinned;
    }

    @Override
    @Generated
    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    @Override
    @Generated
    public Boolean getIsProfiled() {
        return this.isProfiled;
    }

    @Override
    @Generated
    public Boolean getIsSort() {
        return this.isSort;
    }

    @Override
    @Generated
    public Long getLastProfiledAt() {
        return this.lastProfiledAt;
    }

    @Override
    @Generated
    public IMaterializedView getMaterializedView() {
        return this.materializedView;
    }

    @Override
    @Generated
    public Long getMaxLength() {
        return this.maxLength;
    }

    @Override
    @Generated
    public SortedSet<IMetric> getMetricTimestamps() {
        return this.metricTimestamps;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public Integer getNestedColumnCount() {
        return this.nestedColumnCount;
    }

    @Override
    @Generated
    public String getNestedColumnOrder() {
        return this.nestedColumnOrder;
    }

    @Override
    @Generated
    public SortedSet<IColumn> getNestedColumns() {
        return this.nestedColumns;
    }

    @Override
    @Generated
    public String getNosqlCollectionName() {
        return this.nosqlCollectionName;
    }

    @Override
    @Generated
    public String getNosqlCollectionQualifiedName() {
        return this.nosqlCollectionQualifiedName;
    }

    @Override
    @Generated
    public Double getNumericScale() {
        return this.numericScale;
    }

    @Override
    @Generated
    public Integer getOrder() {
        return this.order;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public IColumn getParentColumn() {
        return this.parentColumn;
    }

    @Override
    @Generated
    public String getParentColumnName() {
        return this.parentColumnName;
    }

    @Override
    @Generated
    public String getParentColumnQualifiedName() {
        return this.parentColumnQualifiedName;
    }

    @Override
    @Generated
    public Integer getPartitionOrder() {
        return this.partitionOrder;
    }

    @Override
    @Generated
    public Long getPinnedAt() {
        return this.pinnedAt;
    }

    @Override
    @Generated
    public String getPinnedBy() {
        return this.pinnedBy;
    }

    @Override
    @Generated
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    @Generated
    public SortedSet<IAtlanQuery> getQueries() {
        return this.queries;
    }

    @Override
    @Generated
    public Long getQueryCount() {
        return this.queryCount;
    }

    @Override
    @Generated
    public Long getQueryCountUpdatedAt() {
        return this.queryCountUpdatedAt;
    }

    @Override
    @Generated
    public Long getQueryUserCount() {
        return this.queryUserCount;
    }

    @Override
    @Generated
    public Map<String, Long> getQueryUserMap() {
        return this.queryUserMap;
    }

    @Override
    @Generated
    public String getRawDataTypeDefinition() {
        return this.rawDataTypeDefinition;
    }

    @Override
    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    @Generated
    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    @Override
    @Generated
    public ISnowflakeDynamicTable getSnowflakeDynamicTable() {
        return this.snowflakeDynamicTable;
    }

    @Override
    @Generated
    public SortedSet<IDbtSource> getSqlDBTSources() {
        return this.sqlDBTSources;
    }

    @Override
    @Generated
    public SortedSet<IDbtModel> getSqlDbtModels() {
        return this.sqlDbtModels;
    }

    @Override
    @Generated
    public String getSubDataType() {
        return this.subDataType;
    }

    @Override
    @Generated
    public ITable getTable() {
        return this.table;
    }

    @Override
    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @Generated
    public ITablePartition getTablePartition() {
        return this.tablePartition;
    }

    @Override
    @Generated
    public String getTableQualifiedName() {
        return this.tableQualifiedName;
    }

    @Override
    @Generated
    public Map<String, String> getValidations() {
        return this.validations;
    }

    @Override
    @Generated
    public IView getView() {
        return this.view;
    }

    @Override
    @Generated
    public String getViewName() {
        return this.viewName;
    }

    @Override
    @Generated
    public String getViewQualifiedName() {
        return this.viewQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$columnAverage = this.getColumnAverage();
        Double other$columnAverage = other.getColumnAverage();
        if (this$columnAverage == null ? other$columnAverage != null : !((Object)this$columnAverage).equals(other$columnAverage)) {
            return false;
        }
        Double this$columnAverageLength = this.getColumnAverageLength();
        Double other$columnAverageLength = other.getColumnAverageLength();
        if (this$columnAverageLength == null ? other$columnAverageLength != null : !((Object)this$columnAverageLength).equals(other$columnAverageLength)) {
            return false;
        }
        Integer this$columnDepthLevel = this.getColumnDepthLevel();
        Integer other$columnDepthLevel = other.getColumnDepthLevel();
        if (this$columnDepthLevel == null ? other$columnDepthLevel != null : !((Object)this$columnDepthLevel).equals(other$columnDepthLevel)) {
            return false;
        }
        Integer this$columnDistinctValuesCount = this.getColumnDistinctValuesCount();
        Integer other$columnDistinctValuesCount = other.getColumnDistinctValuesCount();
        if (this$columnDistinctValuesCount == null ? other$columnDistinctValuesCount != null : !((Object)this$columnDistinctValuesCount).equals(other$columnDistinctValuesCount)) {
            return false;
        }
        Long this$columnDistinctValuesCountLong = this.getColumnDistinctValuesCountLong();
        Long other$columnDistinctValuesCountLong = other.getColumnDistinctValuesCountLong();
        if (this$columnDistinctValuesCountLong == null ? other$columnDistinctValuesCountLong != null : !((Object)this$columnDistinctValuesCountLong).equals(other$columnDistinctValuesCountLong)) {
            return false;
        }
        Integer this$columnDuplicateValuesCount = this.getColumnDuplicateValuesCount();
        Integer other$columnDuplicateValuesCount = other.getColumnDuplicateValuesCount();
        if (this$columnDuplicateValuesCount == null ? other$columnDuplicateValuesCount != null : !((Object)this$columnDuplicateValuesCount).equals(other$columnDuplicateValuesCount)) {
            return false;
        }
        Long this$columnDuplicateValuesCountLong = this.getColumnDuplicateValuesCountLong();
        Long other$columnDuplicateValuesCountLong = other.getColumnDuplicateValuesCountLong();
        if (this$columnDuplicateValuesCountLong == null ? other$columnDuplicateValuesCountLong != null : !((Object)this$columnDuplicateValuesCountLong).equals(other$columnDuplicateValuesCountLong)) {
            return false;
        }
        Double this$columnMax = this.getColumnMax();
        Double other$columnMax = other.getColumnMax();
        if (this$columnMax == null ? other$columnMax != null : !((Object)this$columnMax).equals(other$columnMax)) {
            return false;
        }
        Integer this$columnMaximumStringLength = this.getColumnMaximumStringLength();
        Integer other$columnMaximumStringLength = other.getColumnMaximumStringLength();
        if (this$columnMaximumStringLength == null ? other$columnMaximumStringLength != null : !((Object)this$columnMaximumStringLength).equals(other$columnMaximumStringLength)) {
            return false;
        }
        Double this$columnMean = this.getColumnMean();
        Double other$columnMean = other.getColumnMean();
        if (this$columnMean == null ? other$columnMean != null : !((Object)this$columnMean).equals(other$columnMean)) {
            return false;
        }
        Double this$columnMedian = this.getColumnMedian();
        Double other$columnMedian = other.getColumnMedian();
        if (this$columnMedian == null ? other$columnMedian != null : !((Object)this$columnMedian).equals(other$columnMedian)) {
            return false;
        }
        Double this$columnMin = this.getColumnMin();
        Double other$columnMin = other.getColumnMin();
        if (this$columnMin == null ? other$columnMin != null : !((Object)this$columnMin).equals(other$columnMin)) {
            return false;
        }
        Integer this$columnMinimumStringLength = this.getColumnMinimumStringLength();
        Integer other$columnMinimumStringLength = other.getColumnMinimumStringLength();
        if (this$columnMinimumStringLength == null ? other$columnMinimumStringLength != null : !((Object)this$columnMinimumStringLength).equals(other$columnMinimumStringLength)) {
            return false;
        }
        Integer this$columnMissingValuesCount = this.getColumnMissingValuesCount();
        Integer other$columnMissingValuesCount = other.getColumnMissingValuesCount();
        if (this$columnMissingValuesCount == null ? other$columnMissingValuesCount != null : !((Object)this$columnMissingValuesCount).equals(other$columnMissingValuesCount)) {
            return false;
        }
        Long this$columnMissingValuesCountLong = this.getColumnMissingValuesCountLong();
        Long other$columnMissingValuesCountLong = other.getColumnMissingValuesCountLong();
        if (this$columnMissingValuesCountLong == null ? other$columnMissingValuesCountLong != null : !((Object)this$columnMissingValuesCountLong).equals(other$columnMissingValuesCountLong)) {
            return false;
        }
        Double this$columnMissingValuesPercentage = this.getColumnMissingValuesPercentage();
        Double other$columnMissingValuesPercentage = other.getColumnMissingValuesPercentage();
        if (this$columnMissingValuesPercentage == null ? other$columnMissingValuesPercentage != null : !((Object)this$columnMissingValuesPercentage).equals(other$columnMissingValuesPercentage)) {
            return false;
        }
        Double this$columnStandardDeviation = this.getColumnStandardDeviation();
        Double other$columnStandardDeviation = other.getColumnStandardDeviation();
        if (this$columnStandardDeviation == null ? other$columnStandardDeviation != null : !((Object)this$columnStandardDeviation).equals(other$columnStandardDeviation)) {
            return false;
        }
        Double this$columnSum = this.getColumnSum();
        Double other$columnSum = other.getColumnSum();
        if (this$columnSum == null ? other$columnSum != null : !((Object)this$columnSum).equals(other$columnSum)) {
            return false;
        }
        Integer this$columnUniqueValuesCount = this.getColumnUniqueValuesCount();
        Integer other$columnUniqueValuesCount = other.getColumnUniqueValuesCount();
        if (this$columnUniqueValuesCount == null ? other$columnUniqueValuesCount != null : !((Object)this$columnUniqueValuesCount).equals(other$columnUniqueValuesCount)) {
            return false;
        }
        Long this$columnUniqueValuesCountLong = this.getColumnUniqueValuesCountLong();
        Long other$columnUniqueValuesCountLong = other.getColumnUniqueValuesCountLong();
        if (this$columnUniqueValuesCountLong == null ? other$columnUniqueValuesCountLong != null : !((Object)this$columnUniqueValuesCountLong).equals(other$columnUniqueValuesCountLong)) {
            return false;
        }
        Double this$columnUniquenessPercentage = this.getColumnUniquenessPercentage();
        Double other$columnUniquenessPercentage = other.getColumnUniquenessPercentage();
        if (this$columnUniquenessPercentage == null ? other$columnUniquenessPercentage != null : !((Object)this$columnUniquenessPercentage).equals(other$columnUniquenessPercentage)) {
            return false;
        }
        Double this$columnVariance = this.getColumnVariance();
        Double other$columnVariance = other.getColumnVariance();
        if (this$columnVariance == null ? other$columnVariance != null : !((Object)this$columnVariance).equals(other$columnVariance)) {
            return false;
        }
        Boolean this$isClustered = this.getIsClustered();
        Boolean other$isClustered = other.getIsClustered();
        if (this$isClustered == null ? other$isClustered != null : !((Object)this$isClustered).equals(other$isClustered)) {
            return false;
        }
        Boolean this$isDist = this.getIsDist();
        Boolean other$isDist = other.getIsDist();
        if (this$isDist == null ? other$isDist != null : !((Object)this$isDist).equals(other$isDist)) {
            return false;
        }
        Boolean this$isForeign = this.getIsForeign();
        Boolean other$isForeign = other.getIsForeign();
        if (this$isForeign == null ? other$isForeign != null : !((Object)this$isForeign).equals(other$isForeign)) {
            return false;
        }
        Boolean this$isIndexed = this.getIsIndexed();
        Boolean other$isIndexed = other.getIsIndexed();
        if (this$isIndexed == null ? other$isIndexed != null : !((Object)this$isIndexed).equals(other$isIndexed)) {
            return false;
        }
        Boolean this$isNullable = this.getIsNullable();
        Boolean other$isNullable = other.getIsNullable();
        if (this$isNullable == null ? other$isNullable != null : !((Object)this$isNullable).equals(other$isNullable)) {
            return false;
        }
        Boolean this$isPartition = this.getIsPartition();
        Boolean other$isPartition = other.getIsPartition();
        if (this$isPartition == null ? other$isPartition != null : !((Object)this$isPartition).equals(other$isPartition)) {
            return false;
        }
        Boolean this$isPinned = this.getIsPinned();
        Boolean other$isPinned = other.getIsPinned();
        if (this$isPinned == null ? other$isPinned != null : !((Object)this$isPinned).equals(other$isPinned)) {
            return false;
        }
        Boolean this$isPrimary = this.getIsPrimary();
        Boolean other$isPrimary = other.getIsPrimary();
        if (this$isPrimary == null ? other$isPrimary != null : !((Object)this$isPrimary).equals(other$isPrimary)) {
            return false;
        }
        Boolean this$isProfiled = this.getIsProfiled();
        Boolean other$isProfiled = other.getIsProfiled();
        if (this$isProfiled == null ? other$isProfiled != null : !((Object)this$isProfiled).equals(other$isProfiled)) {
            return false;
        }
        Boolean this$isSort = this.getIsSort();
        Boolean other$isSort = other.getIsSort();
        if (this$isSort == null ? other$isSort != null : !((Object)this$isSort).equals(other$isSort)) {
            return false;
        }
        Long this$lastProfiledAt = this.getLastProfiledAt();
        Long other$lastProfiledAt = other.getLastProfiledAt();
        if (this$lastProfiledAt == null ? other$lastProfiledAt != null : !((Object)this$lastProfiledAt).equals(other$lastProfiledAt)) {
            return false;
        }
        Long this$maxLength = this.getMaxLength();
        Long other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Integer this$nestedColumnCount = this.getNestedColumnCount();
        Integer other$nestedColumnCount = other.getNestedColumnCount();
        if (this$nestedColumnCount == null ? other$nestedColumnCount != null : !((Object)this$nestedColumnCount).equals(other$nestedColumnCount)) {
            return false;
        }
        Double this$numericScale = this.getNumericScale();
        Double other$numericScale = other.getNumericScale();
        if (this$numericScale == null ? other$numericScale != null : !((Object)this$numericScale).equals(other$numericScale)) {
            return false;
        }
        Integer this$order = this.getOrder();
        Integer other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        Integer this$partitionOrder = this.getPartitionOrder();
        Integer other$partitionOrder = other.getPartitionOrder();
        if (this$partitionOrder == null ? other$partitionOrder != null : !((Object)this$partitionOrder).equals(other$partitionOrder)) {
            return false;
        }
        Long this$pinnedAt = this.getPinnedAt();
        Long other$pinnedAt = other.getPinnedAt();
        if (this$pinnedAt == null ? other$pinnedAt != null : !((Object)this$pinnedAt).equals(other$pinnedAt)) {
            return false;
        }
        Integer this$precision = this.getPrecision();
        Integer other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        Long this$queryCount = this.getQueryCount();
        Long other$queryCount = other.getQueryCount();
        if (this$queryCount == null ? other$queryCount != null : !((Object)this$queryCount).equals(other$queryCount)) {
            return false;
        }
        Long this$queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        Long other$queryCountUpdatedAt = other.getQueryCountUpdatedAt();
        if (this$queryCountUpdatedAt == null ? other$queryCountUpdatedAt != null : !((Object)this$queryCountUpdatedAt).equals(other$queryCountUpdatedAt)) {
            return false;
        }
        Long this$queryUserCount = this.getQueryUserCount();
        Long other$queryUserCount = other.getQueryUserCount();
        if (this$queryUserCount == null ? other$queryUserCount != null : !((Object)this$queryUserCount).equals(other$queryUserCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        ICalculationView this$calculationView = this.getCalculationView();
        ICalculationView other$calculationView = other.getCalculationView();
        if (this$calculationView == null ? other$calculationView != null : !this$calculationView.equals(other$calculationView)) {
            return false;
        }
        String this$calculationViewName = this.getCalculationViewName();
        String other$calculationViewName = other.getCalculationViewName();
        if (this$calculationViewName == null ? other$calculationViewName != null : !this$calculationViewName.equals(other$calculationViewName)) {
            return false;
        }
        String this$calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        String other$calculationViewQualifiedName = other.getCalculationViewQualifiedName();
        if (this$calculationViewQualifiedName == null ? other$calculationViewQualifiedName != null : !this$calculationViewQualifiedName.equals(other$calculationViewQualifiedName)) {
            return false;
        }
        String this$columnCompression = this.getColumnCompression();
        String other$columnCompression = other.getColumnCompression();
        if (this$columnCompression == null ? other$columnCompression != null : !this$columnCompression.equals(other$columnCompression)) {
            return false;
        }
        SortedSet<IDbtModelColumn> this$columnDbtModelColumns = this.getColumnDbtModelColumns();
        SortedSet<IDbtModelColumn> other$columnDbtModelColumns = other.getColumnDbtModelColumns();
        if (this$columnDbtModelColumns == null ? other$columnDbtModelColumns != null : !this$columnDbtModelColumns.equals(other$columnDbtModelColumns)) {
            return false;
        }
        String this$columnEncoding = this.getColumnEncoding();
        String other$columnEncoding = other.getColumnEncoding();
        if (this$columnEncoding == null ? other$columnEncoding != null : !this$columnEncoding.equals(other$columnEncoding)) {
            return false;
        }
        List<Map<String, String>> this$columnHierarchy = this.getColumnHierarchy();
        List<Map<String, String>> other$columnHierarchy = other.getColumnHierarchy();
        if (this$columnHierarchy == null ? other$columnHierarchy != null : !((Object)this$columnHierarchy).equals(other$columnHierarchy)) {
            return false;
        }
        Histogram this$columnHistogram = this.getColumnHistogram();
        Histogram other$columnHistogram = other.getColumnHistogram();
        if (this$columnHistogram == null ? other$columnHistogram != null : !((Object)this$columnHistogram).equals(other$columnHistogram)) {
            return false;
        }
        SortedSet<String> this$columnMaxs = this.getColumnMaxs();
        SortedSet<String> other$columnMaxs = other.getColumnMaxs();
        if (this$columnMaxs == null ? other$columnMaxs != null : !this$columnMaxs.equals(other$columnMaxs)) {
            return false;
        }
        SortedSet<String> this$columnMins = this.getColumnMins();
        SortedSet<String> other$columnMins = other.getColumnMins();
        if (this$columnMins == null ? other$columnMins != null : !this$columnMins.equals(other$columnMins)) {
            return false;
        }
        List<ColumnValueFrequencyMap> this$columnTopValues = this.getColumnTopValues();
        List<ColumnValueFrequencyMap> other$columnTopValues = other.getColumnTopValues();
        if (this$columnTopValues == null ? other$columnTopValues != null : !((Object)this$columnTopValues).equals(other$columnTopValues)) {
            return false;
        }
        ICosmosMongoDBCollection this$cosmosMongoDBCollection = this.getCosmosMongoDBCollection();
        ICosmosMongoDBCollection other$cosmosMongoDBCollection = other.getCosmosMongoDBCollection();
        if (this$cosmosMongoDBCollection == null ? other$cosmosMongoDBCollection != null : !this$cosmosMongoDBCollection.equals(other$cosmosMongoDBCollection)) {
            return false;
        }
        SortedSet<IMetric> this$dataQualityMetricDimensions = this.getDataQualityMetricDimensions();
        SortedSet<IMetric> other$dataQualityMetricDimensions = other.getDataQualityMetricDimensions();
        if (this$dataQualityMetricDimensions == null ? other$dataQualityMetricDimensions != null : !this$dataQualityMetricDimensions.equals(other$dataQualityMetricDimensions)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$databaseQualifiedName = this.getDatabaseQualifiedName();
        String other$databaseQualifiedName = other.getDatabaseQualifiedName();
        if (this$databaseQualifiedName == null ? other$databaseQualifiedName != null : !this$databaseQualifiedName.equals(other$databaseQualifiedName)) {
            return false;
        }
        SortedSet<IDbtMetric> this$dbtMetrics = this.getDbtMetrics();
        SortedSet<IDbtMetric> other$dbtMetrics = other.getDbtMetrics();
        if (this$dbtMetrics == null ? other$dbtMetrics != null : !this$dbtMetrics.equals(other$dbtMetrics)) {
            return false;
        }
        SortedSet<IDbtModelColumn> this$dbtModelColumns = this.getDbtModelColumns();
        SortedSet<IDbtModelColumn> other$dbtModelColumns = other.getDbtModelColumns();
        if (this$dbtModelColumns == null ? other$dbtModelColumns != null : !this$dbtModelColumns.equals(other$dbtModelColumns)) {
            return false;
        }
        SortedSet<IDbtModel> this$dbtModels = this.getDbtModels();
        SortedSet<IDbtModel> other$dbtModels = other.getDbtModels();
        if (this$dbtModels == null ? other$dbtModels != null : !this$dbtModels.equals(other$dbtModels)) {
            return false;
        }
        SortedSet<IDbtSource> this$dbtSources = this.getDbtSources();
        SortedSet<IDbtSource> other$dbtSources = other.getDbtSources();
        if (this$dbtSources == null ? other$dbtSources != null : !this$dbtSources.equals(other$dbtSources)) {
            return false;
        }
        SortedSet<IDbtTest> this$dbtTests = this.getDbtTests();
        SortedSet<IDbtTest> other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        IColumn this$foreignKeyFrom = this.getForeignKeyFrom();
        IColumn other$foreignKeyFrom = other.getForeignKeyFrom();
        if (this$foreignKeyFrom == null ? other$foreignKeyFrom != null : !this$foreignKeyFrom.equals(other$foreignKeyFrom)) {
            return false;
        }
        SortedSet<IColumn> this$foreignKeyTo = this.getForeignKeyTo();
        SortedSet<IColumn> other$foreignKeyTo = other.getForeignKeyTo();
        if (this$foreignKeyTo == null ? other$foreignKeyTo != null : !this$foreignKeyTo.equals(other$foreignKeyTo)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        IMaterializedView this$materializedView = this.getMaterializedView();
        IMaterializedView other$materializedView = other.getMaterializedView();
        if (this$materializedView == null ? other$materializedView != null : !this$materializedView.equals(other$materializedView)) {
            return false;
        }
        SortedSet<IMetric> this$metricTimestamps = this.getMetricTimestamps();
        SortedSet<IMetric> other$metricTimestamps = other.getMetricTimestamps();
        if (this$metricTimestamps == null ? other$metricTimestamps != null : !this$metricTimestamps.equals(other$metricTimestamps)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        String this$nestedColumnOrder = this.getNestedColumnOrder();
        String other$nestedColumnOrder = other.getNestedColumnOrder();
        if (this$nestedColumnOrder == null ? other$nestedColumnOrder != null : !this$nestedColumnOrder.equals(other$nestedColumnOrder)) {
            return false;
        }
        SortedSet<IColumn> this$nestedColumns = this.getNestedColumns();
        SortedSet<IColumn> other$nestedColumns = other.getNestedColumns();
        if (this$nestedColumns == null ? other$nestedColumns != null : !this$nestedColumns.equals(other$nestedColumns)) {
            return false;
        }
        String this$nosqlCollectionName = this.getNosqlCollectionName();
        String other$nosqlCollectionName = other.getNosqlCollectionName();
        if (this$nosqlCollectionName == null ? other$nosqlCollectionName != null : !this$nosqlCollectionName.equals(other$nosqlCollectionName)) {
            return false;
        }
        String this$nosqlCollectionQualifiedName = this.getNosqlCollectionQualifiedName();
        String other$nosqlCollectionQualifiedName = other.getNosqlCollectionQualifiedName();
        if (this$nosqlCollectionQualifiedName == null ? other$nosqlCollectionQualifiedName != null : !this$nosqlCollectionQualifiedName.equals(other$nosqlCollectionQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        IColumn this$parentColumn = this.getParentColumn();
        IColumn other$parentColumn = other.getParentColumn();
        if (this$parentColumn == null ? other$parentColumn != null : !this$parentColumn.equals(other$parentColumn)) {
            return false;
        }
        String this$parentColumnName = this.getParentColumnName();
        String other$parentColumnName = other.getParentColumnName();
        if (this$parentColumnName == null ? other$parentColumnName != null : !this$parentColumnName.equals(other$parentColumnName)) {
            return false;
        }
        String this$parentColumnQualifiedName = this.getParentColumnQualifiedName();
        String other$parentColumnQualifiedName = other.getParentColumnQualifiedName();
        if (this$parentColumnQualifiedName == null ? other$parentColumnQualifiedName != null : !this$parentColumnQualifiedName.equals(other$parentColumnQualifiedName)) {
            return false;
        }
        String this$pinnedBy = this.getPinnedBy();
        String other$pinnedBy = other.getPinnedBy();
        if (this$pinnedBy == null ? other$pinnedBy != null : !this$pinnedBy.equals(other$pinnedBy)) {
            return false;
        }
        SortedSet<IAtlanQuery> this$queries = this.getQueries();
        SortedSet<IAtlanQuery> other$queries = other.getQueries();
        if (this$queries == null ? other$queries != null : !this$queries.equals(other$queries)) {
            return false;
        }
        Map<String, Long> this$queryUserMap = this.getQueryUserMap();
        Map<String, Long> other$queryUserMap = other.getQueryUserMap();
        if (this$queryUserMap == null ? other$queryUserMap != null : !((Object)this$queryUserMap).equals(other$queryUserMap)) {
            return false;
        }
        String this$rawDataTypeDefinition = this.getRawDataTypeDefinition();
        String other$rawDataTypeDefinition = other.getRawDataTypeDefinition();
        if (this$rawDataTypeDefinition == null ? other$rawDataTypeDefinition != null : !this$rawDataTypeDefinition.equals(other$rawDataTypeDefinition)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$schemaQualifiedName = this.getSchemaQualifiedName();
        String other$schemaQualifiedName = other.getSchemaQualifiedName();
        if (this$schemaQualifiedName == null ? other$schemaQualifiedName != null : !this$schemaQualifiedName.equals(other$schemaQualifiedName)) {
            return false;
        }
        ISnowflakeDynamicTable this$snowflakeDynamicTable = this.getSnowflakeDynamicTable();
        ISnowflakeDynamicTable other$snowflakeDynamicTable = other.getSnowflakeDynamicTable();
        if (this$snowflakeDynamicTable == null ? other$snowflakeDynamicTable != null : !this$snowflakeDynamicTable.equals(other$snowflakeDynamicTable)) {
            return false;
        }
        SortedSet<IDbtSource> this$sqlDBTSources = this.getSqlDBTSources();
        SortedSet<IDbtSource> other$sqlDBTSources = other.getSqlDBTSources();
        if (this$sqlDBTSources == null ? other$sqlDBTSources != null : !this$sqlDBTSources.equals(other$sqlDBTSources)) {
            return false;
        }
        SortedSet<IDbtModel> this$sqlDbtModels = this.getSqlDbtModels();
        SortedSet<IDbtModel> other$sqlDbtModels = other.getSqlDbtModels();
        if (this$sqlDbtModels == null ? other$sqlDbtModels != null : !this$sqlDbtModels.equals(other$sqlDbtModels)) {
            return false;
        }
        String this$subDataType = this.getSubDataType();
        String other$subDataType = other.getSubDataType();
        if (this$subDataType == null ? other$subDataType != null : !this$subDataType.equals(other$subDataType)) {
            return false;
        }
        ITable this$table = this.getTable();
        ITable other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        ITablePartition this$tablePartition = this.getTablePartition();
        ITablePartition other$tablePartition = other.getTablePartition();
        if (this$tablePartition == null ? other$tablePartition != null : !this$tablePartition.equals(other$tablePartition)) {
            return false;
        }
        String this$tableQualifiedName = this.getTableQualifiedName();
        String other$tableQualifiedName = other.getTableQualifiedName();
        if (this$tableQualifiedName == null ? other$tableQualifiedName != null : !this$tableQualifiedName.equals(other$tableQualifiedName)) {
            return false;
        }
        Map<String, String> this$validations = this.getValidations();
        Map<String, String> other$validations = other.getValidations();
        if (this$validations == null ? other$validations != null : !((Object)this$validations).equals(other$validations)) {
            return false;
        }
        IView this$view = this.getView();
        IView other$view = other.getView();
        if (this$view == null ? other$view != null : !this$view.equals(other$view)) {
            return false;
        }
        String this$viewName = this.getViewName();
        String other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName)) {
            return false;
        }
        String this$viewQualifiedName = this.getViewQualifiedName();
        String other$viewQualifiedName = other.getViewQualifiedName();
        return !(this$viewQualifiedName == null ? other$viewQualifiedName != null : !this$viewQualifiedName.equals(other$viewQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Column;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $columnAverage = this.getColumnAverage();
        result = result * 59 + ($columnAverage == null ? 43 : ((Object)$columnAverage).hashCode());
        Double $columnAverageLength = this.getColumnAverageLength();
        result = result * 59 + ($columnAverageLength == null ? 43 : ((Object)$columnAverageLength).hashCode());
        Integer $columnDepthLevel = this.getColumnDepthLevel();
        result = result * 59 + ($columnDepthLevel == null ? 43 : ((Object)$columnDepthLevel).hashCode());
        Integer $columnDistinctValuesCount = this.getColumnDistinctValuesCount();
        result = result * 59 + ($columnDistinctValuesCount == null ? 43 : ((Object)$columnDistinctValuesCount).hashCode());
        Long $columnDistinctValuesCountLong = this.getColumnDistinctValuesCountLong();
        result = result * 59 + ($columnDistinctValuesCountLong == null ? 43 : ((Object)$columnDistinctValuesCountLong).hashCode());
        Integer $columnDuplicateValuesCount = this.getColumnDuplicateValuesCount();
        result = result * 59 + ($columnDuplicateValuesCount == null ? 43 : ((Object)$columnDuplicateValuesCount).hashCode());
        Long $columnDuplicateValuesCountLong = this.getColumnDuplicateValuesCountLong();
        result = result * 59 + ($columnDuplicateValuesCountLong == null ? 43 : ((Object)$columnDuplicateValuesCountLong).hashCode());
        Double $columnMax = this.getColumnMax();
        result = result * 59 + ($columnMax == null ? 43 : ((Object)$columnMax).hashCode());
        Integer $columnMaximumStringLength = this.getColumnMaximumStringLength();
        result = result * 59 + ($columnMaximumStringLength == null ? 43 : ((Object)$columnMaximumStringLength).hashCode());
        Double $columnMean = this.getColumnMean();
        result = result * 59 + ($columnMean == null ? 43 : ((Object)$columnMean).hashCode());
        Double $columnMedian = this.getColumnMedian();
        result = result * 59 + ($columnMedian == null ? 43 : ((Object)$columnMedian).hashCode());
        Double $columnMin = this.getColumnMin();
        result = result * 59 + ($columnMin == null ? 43 : ((Object)$columnMin).hashCode());
        Integer $columnMinimumStringLength = this.getColumnMinimumStringLength();
        result = result * 59 + ($columnMinimumStringLength == null ? 43 : ((Object)$columnMinimumStringLength).hashCode());
        Integer $columnMissingValuesCount = this.getColumnMissingValuesCount();
        result = result * 59 + ($columnMissingValuesCount == null ? 43 : ((Object)$columnMissingValuesCount).hashCode());
        Long $columnMissingValuesCountLong = this.getColumnMissingValuesCountLong();
        result = result * 59 + ($columnMissingValuesCountLong == null ? 43 : ((Object)$columnMissingValuesCountLong).hashCode());
        Double $columnMissingValuesPercentage = this.getColumnMissingValuesPercentage();
        result = result * 59 + ($columnMissingValuesPercentage == null ? 43 : ((Object)$columnMissingValuesPercentage).hashCode());
        Double $columnStandardDeviation = this.getColumnStandardDeviation();
        result = result * 59 + ($columnStandardDeviation == null ? 43 : ((Object)$columnStandardDeviation).hashCode());
        Double $columnSum = this.getColumnSum();
        result = result * 59 + ($columnSum == null ? 43 : ((Object)$columnSum).hashCode());
        Integer $columnUniqueValuesCount = this.getColumnUniqueValuesCount();
        result = result * 59 + ($columnUniqueValuesCount == null ? 43 : ((Object)$columnUniqueValuesCount).hashCode());
        Long $columnUniqueValuesCountLong = this.getColumnUniqueValuesCountLong();
        result = result * 59 + ($columnUniqueValuesCountLong == null ? 43 : ((Object)$columnUniqueValuesCountLong).hashCode());
        Double $columnUniquenessPercentage = this.getColumnUniquenessPercentage();
        result = result * 59 + ($columnUniquenessPercentage == null ? 43 : ((Object)$columnUniquenessPercentage).hashCode());
        Double $columnVariance = this.getColumnVariance();
        result = result * 59 + ($columnVariance == null ? 43 : ((Object)$columnVariance).hashCode());
        Boolean $isClustered = this.getIsClustered();
        result = result * 59 + ($isClustered == null ? 43 : ((Object)$isClustered).hashCode());
        Boolean $isDist = this.getIsDist();
        result = result * 59 + ($isDist == null ? 43 : ((Object)$isDist).hashCode());
        Boolean $isForeign = this.getIsForeign();
        result = result * 59 + ($isForeign == null ? 43 : ((Object)$isForeign).hashCode());
        Boolean $isIndexed = this.getIsIndexed();
        result = result * 59 + ($isIndexed == null ? 43 : ((Object)$isIndexed).hashCode());
        Boolean $isNullable = this.getIsNullable();
        result = result * 59 + ($isNullable == null ? 43 : ((Object)$isNullable).hashCode());
        Boolean $isPartition = this.getIsPartition();
        result = result * 59 + ($isPartition == null ? 43 : ((Object)$isPartition).hashCode());
        Boolean $isPinned = this.getIsPinned();
        result = result * 59 + ($isPinned == null ? 43 : ((Object)$isPinned).hashCode());
        Boolean $isPrimary = this.getIsPrimary();
        result = result * 59 + ($isPrimary == null ? 43 : ((Object)$isPrimary).hashCode());
        Boolean $isProfiled = this.getIsProfiled();
        result = result * 59 + ($isProfiled == null ? 43 : ((Object)$isProfiled).hashCode());
        Boolean $isSort = this.getIsSort();
        result = result * 59 + ($isSort == null ? 43 : ((Object)$isSort).hashCode());
        Long $lastProfiledAt = this.getLastProfiledAt();
        result = result * 59 + ($lastProfiledAt == null ? 43 : ((Object)$lastProfiledAt).hashCode());
        Long $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Integer $nestedColumnCount = this.getNestedColumnCount();
        result = result * 59 + ($nestedColumnCount == null ? 43 : ((Object)$nestedColumnCount).hashCode());
        Double $numericScale = this.getNumericScale();
        result = result * 59 + ($numericScale == null ? 43 : ((Object)$numericScale).hashCode());
        Integer $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        Integer $partitionOrder = this.getPartitionOrder();
        result = result * 59 + ($partitionOrder == null ? 43 : ((Object)$partitionOrder).hashCode());
        Long $pinnedAt = this.getPinnedAt();
        result = result * 59 + ($pinnedAt == null ? 43 : ((Object)$pinnedAt).hashCode());
        Integer $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        Long $queryCount = this.getQueryCount();
        result = result * 59 + ($queryCount == null ? 43 : ((Object)$queryCount).hashCode());
        Long $queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        result = result * 59 + ($queryCountUpdatedAt == null ? 43 : ((Object)$queryCountUpdatedAt).hashCode());
        Long $queryUserCount = this.getQueryUserCount();
        result = result * 59 + ($queryUserCount == null ? 43 : ((Object)$queryUserCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        ICalculationView $calculationView = this.getCalculationView();
        result = result * 59 + ($calculationView == null ? 43 : $calculationView.hashCode());
        String $calculationViewName = this.getCalculationViewName();
        result = result * 59 + ($calculationViewName == null ? 43 : $calculationViewName.hashCode());
        String $calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        result = result * 59 + ($calculationViewQualifiedName == null ? 43 : $calculationViewQualifiedName.hashCode());
        String $columnCompression = this.getColumnCompression();
        result = result * 59 + ($columnCompression == null ? 43 : $columnCompression.hashCode());
        SortedSet<IDbtModelColumn> $columnDbtModelColumns = this.getColumnDbtModelColumns();
        result = result * 59 + ($columnDbtModelColumns == null ? 43 : $columnDbtModelColumns.hashCode());
        String $columnEncoding = this.getColumnEncoding();
        result = result * 59 + ($columnEncoding == null ? 43 : $columnEncoding.hashCode());
        List<Map<String, String>> $columnHierarchy = this.getColumnHierarchy();
        result = result * 59 + ($columnHierarchy == null ? 43 : ((Object)$columnHierarchy).hashCode());
        Histogram $columnHistogram = this.getColumnHistogram();
        result = result * 59 + ($columnHistogram == null ? 43 : ((Object)$columnHistogram).hashCode());
        SortedSet<String> $columnMaxs = this.getColumnMaxs();
        result = result * 59 + ($columnMaxs == null ? 43 : $columnMaxs.hashCode());
        SortedSet<String> $columnMins = this.getColumnMins();
        result = result * 59 + ($columnMins == null ? 43 : $columnMins.hashCode());
        List<ColumnValueFrequencyMap> $columnTopValues = this.getColumnTopValues();
        result = result * 59 + ($columnTopValues == null ? 43 : ((Object)$columnTopValues).hashCode());
        ICosmosMongoDBCollection $cosmosMongoDBCollection = this.getCosmosMongoDBCollection();
        result = result * 59 + ($cosmosMongoDBCollection == null ? 43 : $cosmosMongoDBCollection.hashCode());
        SortedSet<IMetric> $dataQualityMetricDimensions = this.getDataQualityMetricDimensions();
        result = result * 59 + ($dataQualityMetricDimensions == null ? 43 : $dataQualityMetricDimensions.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $databaseQualifiedName = this.getDatabaseQualifiedName();
        result = result * 59 + ($databaseQualifiedName == null ? 43 : $databaseQualifiedName.hashCode());
        SortedSet<IDbtMetric> $dbtMetrics = this.getDbtMetrics();
        result = result * 59 + ($dbtMetrics == null ? 43 : $dbtMetrics.hashCode());
        SortedSet<IDbtModelColumn> $dbtModelColumns = this.getDbtModelColumns();
        result = result * 59 + ($dbtModelColumns == null ? 43 : $dbtModelColumns.hashCode());
        SortedSet<IDbtModel> $dbtModels = this.getDbtModels();
        result = result * 59 + ($dbtModels == null ? 43 : $dbtModels.hashCode());
        SortedSet<IDbtSource> $dbtSources = this.getDbtSources();
        result = result * 59 + ($dbtSources == null ? 43 : $dbtSources.hashCode());
        SortedSet<IDbtTest> $dbtTests = this.getDbtTests();
        result = result * 59 + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        IColumn $foreignKeyFrom = this.getForeignKeyFrom();
        result = result * 59 + ($foreignKeyFrom == null ? 43 : $foreignKeyFrom.hashCode());
        SortedSet<IColumn> $foreignKeyTo = this.getForeignKeyTo();
        result = result * 59 + ($foreignKeyTo == null ? 43 : $foreignKeyTo.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        IMaterializedView $materializedView = this.getMaterializedView();
        result = result * 59 + ($materializedView == null ? 43 : $materializedView.hashCode());
        SortedSet<IMetric> $metricTimestamps = this.getMetricTimestamps();
        result = result * 59 + ($metricTimestamps == null ? 43 : $metricTimestamps.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        String $nestedColumnOrder = this.getNestedColumnOrder();
        result = result * 59 + ($nestedColumnOrder == null ? 43 : $nestedColumnOrder.hashCode());
        SortedSet<IColumn> $nestedColumns = this.getNestedColumns();
        result = result * 59 + ($nestedColumns == null ? 43 : $nestedColumns.hashCode());
        String $nosqlCollectionName = this.getNosqlCollectionName();
        result = result * 59 + ($nosqlCollectionName == null ? 43 : $nosqlCollectionName.hashCode());
        String $nosqlCollectionQualifiedName = this.getNosqlCollectionQualifiedName();
        result = result * 59 + ($nosqlCollectionQualifiedName == null ? 43 : $nosqlCollectionQualifiedName.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        IColumn $parentColumn = this.getParentColumn();
        result = result * 59 + ($parentColumn == null ? 43 : $parentColumn.hashCode());
        String $parentColumnName = this.getParentColumnName();
        result = result * 59 + ($parentColumnName == null ? 43 : $parentColumnName.hashCode());
        String $parentColumnQualifiedName = this.getParentColumnQualifiedName();
        result = result * 59 + ($parentColumnQualifiedName == null ? 43 : $parentColumnQualifiedName.hashCode());
        String $pinnedBy = this.getPinnedBy();
        result = result * 59 + ($pinnedBy == null ? 43 : $pinnedBy.hashCode());
        SortedSet<IAtlanQuery> $queries = this.getQueries();
        result = result * 59 + ($queries == null ? 43 : $queries.hashCode());
        Map<String, Long> $queryUserMap = this.getQueryUserMap();
        result = result * 59 + ($queryUserMap == null ? 43 : ((Object)$queryUserMap).hashCode());
        String $rawDataTypeDefinition = this.getRawDataTypeDefinition();
        result = result * 59 + ($rawDataTypeDefinition == null ? 43 : $rawDataTypeDefinition.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $schemaQualifiedName = this.getSchemaQualifiedName();
        result = result * 59 + ($schemaQualifiedName == null ? 43 : $schemaQualifiedName.hashCode());
        ISnowflakeDynamicTable $snowflakeDynamicTable = this.getSnowflakeDynamicTable();
        result = result * 59 + ($snowflakeDynamicTable == null ? 43 : $snowflakeDynamicTable.hashCode());
        SortedSet<IDbtSource> $sqlDBTSources = this.getSqlDBTSources();
        result = result * 59 + ($sqlDBTSources == null ? 43 : $sqlDBTSources.hashCode());
        SortedSet<IDbtModel> $sqlDbtModels = this.getSqlDbtModels();
        result = result * 59 + ($sqlDbtModels == null ? 43 : $sqlDbtModels.hashCode());
        String $subDataType = this.getSubDataType();
        result = result * 59 + ($subDataType == null ? 43 : $subDataType.hashCode());
        ITable $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        ITablePartition $tablePartition = this.getTablePartition();
        result = result * 59 + ($tablePartition == null ? 43 : $tablePartition.hashCode());
        String $tableQualifiedName = this.getTableQualifiedName();
        result = result * 59 + ($tableQualifiedName == null ? 43 : $tableQualifiedName.hashCode());
        Map<String, String> $validations = this.getValidations();
        result = result * 59 + ($validations == null ? 43 : ((Object)$validations).hashCode());
        IView $view = this.getView();
        result = result * 59 + ($view == null ? 43 : $view.hashCode());
        String $viewName = this.getViewName();
        result = result * 59 + ($viewName == null ? 43 : $viewName.hashCode());
        String $viewQualifiedName = this.getViewQualifiedName();
        result = result * 59 + ($viewQualifiedName == null ? 43 : $viewQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Column(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", calculationView=" + String.valueOf(this.getCalculationView()) + ", calculationViewName=" + this.getCalculationViewName() + ", calculationViewQualifiedName=" + this.getCalculationViewQualifiedName() + ", columnAverage=" + this.getColumnAverage() + ", columnAverageLength=" + this.getColumnAverageLength() + ", columnCompression=" + this.getColumnCompression() + ", columnDbtModelColumns=" + String.valueOf(this.getColumnDbtModelColumns()) + ", columnDepthLevel=" + this.getColumnDepthLevel() + ", columnDistinctValuesCount=" + this.getColumnDistinctValuesCount() + ", columnDistinctValuesCountLong=" + this.getColumnDistinctValuesCountLong() + ", columnDuplicateValuesCount=" + this.getColumnDuplicateValuesCount() + ", columnDuplicateValuesCountLong=" + this.getColumnDuplicateValuesCountLong() + ", columnEncoding=" + this.getColumnEncoding() + ", columnHierarchy=" + String.valueOf(this.getColumnHierarchy()) + ", columnHistogram=" + String.valueOf(this.getColumnHistogram()) + ", columnMax=" + this.getColumnMax() + ", columnMaximumStringLength=" + this.getColumnMaximumStringLength() + ", columnMaxs=" + String.valueOf(this.getColumnMaxs()) + ", columnMean=" + this.getColumnMean() + ", columnMedian=" + this.getColumnMedian() + ", columnMin=" + this.getColumnMin() + ", columnMinimumStringLength=" + this.getColumnMinimumStringLength() + ", columnMins=" + String.valueOf(this.getColumnMins()) + ", columnMissingValuesCount=" + this.getColumnMissingValuesCount() + ", columnMissingValuesCountLong=" + this.getColumnMissingValuesCountLong() + ", columnMissingValuesPercentage=" + this.getColumnMissingValuesPercentage() + ", columnStandardDeviation=" + this.getColumnStandardDeviation() + ", columnSum=" + this.getColumnSum() + ", columnTopValues=" + String.valueOf(this.getColumnTopValues()) + ", columnUniqueValuesCount=" + this.getColumnUniqueValuesCount() + ", columnUniqueValuesCountLong=" + this.getColumnUniqueValuesCountLong() + ", columnUniquenessPercentage=" + this.getColumnUniquenessPercentage() + ", columnVariance=" + this.getColumnVariance() + ", cosmosMongoDBCollection=" + String.valueOf(this.getCosmosMongoDBCollection()) + ", dataQualityMetricDimensions=" + String.valueOf(this.getDataQualityMetricDimensions()) + ", dataType=" + this.getDataType() + ", databaseName=" + this.getDatabaseName() + ", databaseQualifiedName=" + this.getDatabaseQualifiedName() + ", dbtMetrics=" + String.valueOf(this.getDbtMetrics()) + ", dbtModelColumns=" + String.valueOf(this.getDbtModelColumns()) + ", dbtModels=" + String.valueOf(this.getDbtModels()) + ", dbtSources=" + String.valueOf(this.getDbtSources()) + ", dbtTests=" + String.valueOf(this.getDbtTests()) + ", defaultValue=" + this.getDefaultValue() + ", foreignKeyFrom=" + String.valueOf(this.getForeignKeyFrom()) + ", foreignKeyTo=" + String.valueOf(this.getForeignKeyTo()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", isClustered=" + this.getIsClustered() + ", isDist=" + this.getIsDist() + ", isForeign=" + this.getIsForeign() + ", isIndexed=" + this.getIsIndexed() + ", isNullable=" + this.getIsNullable() + ", isPartition=" + this.getIsPartition() + ", isPinned=" + this.getIsPinned() + ", isPrimary=" + this.getIsPrimary() + ", isProfiled=" + this.getIsProfiled() + ", isSort=" + this.getIsSort() + ", lastProfiledAt=" + this.getLastProfiledAt() + ", materializedView=" + String.valueOf(this.getMaterializedView()) + ", maxLength=" + this.getMaxLength() + ", metricTimestamps=" + String.valueOf(this.getMetricTimestamps()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", nestedColumnCount=" + this.getNestedColumnCount() + ", nestedColumnOrder=" + this.getNestedColumnOrder() + ", nestedColumns=" + String.valueOf(this.getNestedColumns()) + ", nosqlCollectionName=" + this.getNosqlCollectionName() + ", nosqlCollectionQualifiedName=" + this.getNosqlCollectionQualifiedName() + ", numericScale=" + this.getNumericScale() + ", order=" + this.getOrder() + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", parentColumn=" + String.valueOf(this.getParentColumn()) + ", parentColumnName=" + this.getParentColumnName() + ", parentColumnQualifiedName=" + this.getParentColumnQualifiedName() + ", partitionOrder=" + this.getPartitionOrder() + ", pinnedAt=" + this.getPinnedAt() + ", pinnedBy=" + this.getPinnedBy() + ", precision=" + this.getPrecision() + ", queries=" + String.valueOf(this.getQueries()) + ", queryCount=" + this.getQueryCount() + ", queryCountUpdatedAt=" + this.getQueryCountUpdatedAt() + ", queryUserCount=" + this.getQueryUserCount() + ", queryUserMap=" + String.valueOf(this.getQueryUserMap()) + ", rawDataTypeDefinition=" + this.getRawDataTypeDefinition() + ", schemaName=" + this.getSchemaName() + ", schemaQualifiedName=" + this.getSchemaQualifiedName() + ", snowflakeDynamicTable=" + String.valueOf(this.getSnowflakeDynamicTable()) + ", sqlDBTSources=" + String.valueOf(this.getSqlDBTSources()) + ", sqlDbtModels=" + String.valueOf(this.getSqlDbtModels()) + ", subDataType=" + this.getSubDataType() + ", table=" + String.valueOf(this.getTable()) + ", tableName=" + this.getTableName() + ", tablePartition=" + String.valueOf(this.getTablePartition()) + ", tableQualifiedName=" + (this.getTableQualifiedName() + ", validations=" + String.valueOf(this.getValidations()) + ", view=" + String.valueOf(this.getView()) + ", viewName=" + this.getViewName() + ", viewQualifiedName=" + this.getViewQualifiedName() + ")");
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class ColumnBuilder<C extends Column, B extends ColumnBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ICalculationView calculationView;
        @Generated
        private String calculationViewName;
        @Generated
        private String calculationViewQualifiedName;
        @Generated
        private Double columnAverage;
        @Generated
        private Double columnAverageLength;
        @Generated
        private String columnCompression;
        @Generated
        private ArrayList<IDbtModelColumn> columnDbtModelColumns;
        @Generated
        private Integer columnDepthLevel;
        @Generated
        private Integer columnDistinctValuesCount;
        @Generated
        private Long columnDistinctValuesCountLong;
        @Generated
        private Integer columnDuplicateValuesCount;
        @Generated
        private Long columnDuplicateValuesCountLong;
        @Generated
        private String columnEncoding;
        @Generated
        private ArrayList<Map<String, String>> columnHierarchy;
        @Generated
        private Histogram columnHistogram;
        @Generated
        private Double columnMax;
        @Generated
        private Integer columnMaximumStringLength;
        @Generated
        private ArrayList<String> columnMaxs;
        @Generated
        private Double columnMean;
        @Generated
        private Double columnMedian;
        @Generated
        private Double columnMin;
        @Generated
        private Integer columnMinimumStringLength;
        @Generated
        private ArrayList<String> columnMins;
        @Generated
        private Integer columnMissingValuesCount;
        @Generated
        private Long columnMissingValuesCountLong;
        @Generated
        private Double columnMissingValuesPercentage;
        @Generated
        private Double columnStandardDeviation;
        @Generated
        private Double columnSum;
        @Generated
        private ArrayList<ColumnValueFrequencyMap> columnTopValues;
        @Generated
        private Integer columnUniqueValuesCount;
        @Generated
        private Long columnUniqueValuesCountLong;
        @Generated
        private Double columnUniquenessPercentage;
        @Generated
        private Double columnVariance;
        @Generated
        private ICosmosMongoDBCollection cosmosMongoDBCollection;
        @Generated
        private ArrayList<IMetric> dataQualityMetricDimensions;
        @Generated
        private String dataType;
        @Generated
        private String databaseName;
        @Generated
        private String databaseQualifiedName;
        @Generated
        private ArrayList<IDbtMetric> dbtMetrics;
        @Generated
        private ArrayList<IDbtModelColumn> dbtModelColumns;
        @Generated
        private ArrayList<IDbtModel> dbtModels;
        @Generated
        private ArrayList<IDbtSource> dbtSources;
        @Generated
        private ArrayList<IDbtTest> dbtTests;
        @Generated
        private String defaultValue;
        @Generated
        private IColumn foreignKeyFrom;
        @Generated
        private ArrayList<IColumn> foreignKeyTo;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private Boolean isClustered;
        @Generated
        private Boolean isDist;
        @Generated
        private Boolean isForeign;
        @Generated
        private Boolean isIndexed;
        @Generated
        private Boolean isNullable;
        @Generated
        private Boolean isPartition;
        @Generated
        private Boolean isPinned;
        @Generated
        private Boolean isPrimary;
        @Generated
        private Boolean isProfiled;
        @Generated
        private Boolean isSort;
        @Generated
        private Long lastProfiledAt;
        @Generated
        private IMaterializedView materializedView;
        @Generated
        private Long maxLength;
        @Generated
        private ArrayList<IMetric> metricTimestamps;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private Integer nestedColumnCount;
        @Generated
        private String nestedColumnOrder;
        @Generated
        private ArrayList<IColumn> nestedColumns;
        @Generated
        private String nosqlCollectionName;
        @Generated
        private String nosqlCollectionQualifiedName;
        @Generated
        private Double numericScale;
        @Generated
        private Integer order;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private IColumn parentColumn;
        @Generated
        private String parentColumnName;
        @Generated
        private String parentColumnQualifiedName;
        @Generated
        private Integer partitionOrder;
        @Generated
        private Long pinnedAt;
        @Generated
        private String pinnedBy;
        @Generated
        private Integer precision;
        @Generated
        private ArrayList<IAtlanQuery> queries;
        @Generated
        private Long queryCount;
        @Generated
        private Long queryCountUpdatedAt;
        @Generated
        private Long queryUserCount;
        @Generated
        private ArrayList<String> queryUserMap$key;
        @Generated
        private ArrayList<Long> queryUserMap$value;
        @Generated
        private String rawDataTypeDefinition;
        @Generated
        private String schemaName;
        @Generated
        private String schemaQualifiedName;
        @Generated
        private ISnowflakeDynamicTable snowflakeDynamicTable;
        @Generated
        private ArrayList<IDbtSource> sqlDBTSources;
        @Generated
        private ArrayList<IDbtModel> sqlDbtModels;
        @Generated
        private String subDataType;
        @Generated
        private ITable table;
        @Generated
        private String tableName;
        @Generated
        private ITablePartition tablePartition;
        @Generated
        private String tableQualifiedName;
        @Generated
        private ArrayList<String> validations$key;
        @Generated
        private ArrayList<String> validations$value;
        @Generated
        private IView view;
        @Generated
        private String viewName;
        @Generated
        private String viewQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ColumnBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Column instance, ColumnBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.calculationView(instance.calculationView);
            b.calculationViewName(instance.calculationViewName);
            b.calculationViewQualifiedName(instance.calculationViewQualifiedName);
            b.columnAverage(instance.columnAverage);
            b.columnAverageLength(instance.columnAverageLength);
            b.columnCompression(instance.columnCompression);
            b.columnDbtModelColumns(instance.columnDbtModelColumns == null ? Collections.emptySortedSet() : instance.columnDbtModelColumns);
            b.columnDepthLevel(instance.columnDepthLevel);
            b.columnDistinctValuesCount(instance.columnDistinctValuesCount);
            b.columnDistinctValuesCountLong(instance.columnDistinctValuesCountLong);
            b.columnDuplicateValuesCount(instance.columnDuplicateValuesCount);
            b.columnDuplicateValuesCountLong(instance.columnDuplicateValuesCountLong);
            b.columnEncoding(instance.columnEncoding);
            b.columnHierarchy(instance.columnHierarchy == null ? Collections.emptyList() : instance.columnHierarchy);
            b.columnHistogram(instance.columnHistogram);
            b.columnMax(instance.columnMax);
            b.columnMaximumStringLength(instance.columnMaximumStringLength);
            b.columnMaxs(instance.columnMaxs == null ? Collections.emptySortedSet() : instance.columnMaxs);
            b.columnMean(instance.columnMean);
            b.columnMedian(instance.columnMedian);
            b.columnMin(instance.columnMin);
            b.columnMinimumStringLength(instance.columnMinimumStringLength);
            b.columnMins(instance.columnMins == null ? Collections.emptySortedSet() : instance.columnMins);
            b.columnMissingValuesCount(instance.columnMissingValuesCount);
            b.columnMissingValuesCountLong(instance.columnMissingValuesCountLong);
            b.columnMissingValuesPercentage(instance.columnMissingValuesPercentage);
            b.columnStandardDeviation(instance.columnStandardDeviation);
            b.columnSum(instance.columnSum);
            b.columnTopValues(instance.columnTopValues == null ? Collections.emptyList() : instance.columnTopValues);
            b.columnUniqueValuesCount(instance.columnUniqueValuesCount);
            b.columnUniqueValuesCountLong(instance.columnUniqueValuesCountLong);
            b.columnUniquenessPercentage(instance.columnUniquenessPercentage);
            b.columnVariance(instance.columnVariance);
            b.cosmosMongoDBCollection(instance.cosmosMongoDBCollection);
            b.dataQualityMetricDimensions(instance.dataQualityMetricDimensions == null ? Collections.emptySortedSet() : instance.dataQualityMetricDimensions);
            b.dataType(instance.dataType);
            b.databaseName(instance.databaseName);
            b.databaseQualifiedName(instance.databaseQualifiedName);
            b.dbtMetrics(instance.dbtMetrics == null ? Collections.emptySortedSet() : instance.dbtMetrics);
            b.dbtModelColumns(instance.dbtModelColumns == null ? Collections.emptySortedSet() : instance.dbtModelColumns);
            b.dbtModels(instance.dbtModels == null ? Collections.emptySortedSet() : instance.dbtModels);
            b.dbtSources(instance.dbtSources == null ? Collections.emptySortedSet() : instance.dbtSources);
            b.dbtTests(instance.dbtTests == null ? Collections.emptySortedSet() : instance.dbtTests);
            b.defaultValue(instance.defaultValue);
            b.foreignKeyFrom(instance.foreignKeyFrom);
            b.foreignKeyTo(instance.foreignKeyTo == null ? Collections.emptySortedSet() : instance.foreignKeyTo);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.isClustered(instance.isClustered);
            b.isDist(instance.isDist);
            b.isForeign(instance.isForeign);
            b.isIndexed(instance.isIndexed);
            b.isNullable(instance.isNullable);
            b.isPartition(instance.isPartition);
            b.isPinned(instance.isPinned);
            b.isPrimary(instance.isPrimary);
            b.isProfiled(instance.isProfiled);
            b.isSort(instance.isSort);
            b.lastProfiledAt(instance.lastProfiledAt);
            b.materializedView(instance.materializedView);
            b.maxLength(instance.maxLength);
            b.metricTimestamps(instance.metricTimestamps == null ? Collections.emptySortedSet() : instance.metricTimestamps);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.nestedColumnCount(instance.nestedColumnCount);
            b.nestedColumnOrder(instance.nestedColumnOrder);
            b.nestedColumns(instance.nestedColumns == null ? Collections.emptySortedSet() : instance.nestedColumns);
            b.nosqlCollectionName(instance.nosqlCollectionName);
            b.nosqlCollectionQualifiedName(instance.nosqlCollectionQualifiedName);
            b.numericScale(instance.numericScale);
            b.order(instance.order);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.parentColumn(instance.parentColumn);
            b.parentColumnName(instance.parentColumnName);
            b.parentColumnQualifiedName(instance.parentColumnQualifiedName);
            b.partitionOrder(instance.partitionOrder);
            b.pinnedAt(instance.pinnedAt);
            b.pinnedBy(instance.pinnedBy);
            b.precision(instance.precision);
            b.queries(instance.queries == null ? Collections.emptySortedSet() : instance.queries);
            b.queryCount(instance.queryCount);
            b.queryCountUpdatedAt(instance.queryCountUpdatedAt);
            b.queryUserCount(instance.queryUserCount);
            b.queryUserMap(instance.queryUserMap == null ? Collections.emptyMap() : instance.queryUserMap);
            b.rawDataTypeDefinition(instance.rawDataTypeDefinition);
            b.schemaName(instance.schemaName);
            b.schemaQualifiedName(instance.schemaQualifiedName);
            b.snowflakeDynamicTable(instance.snowflakeDynamicTable);
            b.sqlDBTSources(instance.sqlDBTSources == null ? Collections.emptySortedSet() : instance.sqlDBTSources);
            b.sqlDbtModels(instance.sqlDbtModels == null ? Collections.emptySortedSet() : instance.sqlDbtModels);
            b.subDataType(instance.subDataType);
            b.table(instance.table);
            b.tableName(instance.tableName);
            b.tablePartition(instance.tablePartition);
            b.tableQualifiedName(instance.tableQualifiedName);
            b.validations(instance.validations == null ? Collections.emptyMap() : instance.validations);
            b.view(instance.view);
            b.viewName(instance.viewName);
            b.viewQualifiedName(instance.viewQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B calculationView(ICalculationView calculationView) {
            this.calculationView = calculationView;
            return (B)this.self();
        }

        @Generated
        public B calculationViewName(String calculationViewName) {
            this.calculationViewName = calculationViewName;
            return (B)this.self();
        }

        @Generated
        public B calculationViewQualifiedName(String calculationViewQualifiedName) {
            this.calculationViewQualifiedName = calculationViewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B columnAverage(Double columnAverage) {
            this.columnAverage = columnAverage;
            return (B)this.self();
        }

        @Generated
        public B columnAverageLength(Double columnAverageLength) {
            this.columnAverageLength = columnAverageLength;
            return (B)this.self();
        }

        @Generated
        public B columnCompression(String columnCompression) {
            this.columnCompression = columnCompression;
            return (B)this.self();
        }

        @Generated
        public B columnDbtModelColumn(IDbtModelColumn columnDbtModelColumn) {
            if (this.columnDbtModelColumns == null) {
                this.columnDbtModelColumns = new ArrayList();
            }
            this.columnDbtModelColumns.add(columnDbtModelColumn);
            return (B)this.self();
        }

        @Generated
        public B columnDbtModelColumns(Collection<? extends IDbtModelColumn> columnDbtModelColumns) {
            if (columnDbtModelColumns == null) {
                throw new NullPointerException("columnDbtModelColumns cannot be null");
            }
            if (this.columnDbtModelColumns == null) {
                this.columnDbtModelColumns = new ArrayList();
            }
            this.columnDbtModelColumns.addAll(columnDbtModelColumns);
            return (B)this.self();
        }

        @Generated
        public B clearColumnDbtModelColumns() {
            if (this.columnDbtModelColumns != null) {
                this.columnDbtModelColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B columnDepthLevel(Integer columnDepthLevel) {
            this.columnDepthLevel = columnDepthLevel;
            return (B)this.self();
        }

        @Generated
        public B columnDistinctValuesCount(Integer columnDistinctValuesCount) {
            this.columnDistinctValuesCount = columnDistinctValuesCount;
            return (B)this.self();
        }

        @Generated
        public B columnDistinctValuesCountLong(Long columnDistinctValuesCountLong) {
            this.columnDistinctValuesCountLong = columnDistinctValuesCountLong;
            return (B)this.self();
        }

        @Generated
        public B columnDuplicateValuesCount(Integer columnDuplicateValuesCount) {
            this.columnDuplicateValuesCount = columnDuplicateValuesCount;
            return (B)this.self();
        }

        @Generated
        public B columnDuplicateValuesCountLong(Long columnDuplicateValuesCountLong) {
            this.columnDuplicateValuesCountLong = columnDuplicateValuesCountLong;
            return (B)this.self();
        }

        @Generated
        public B columnEncoding(String columnEncoding) {
            this.columnEncoding = columnEncoding;
            return (B)this.self();
        }

        @Generated
        public B putColumnHierarchy(Map<String, String> putColumnHierarchy) {
            if (this.columnHierarchy == null) {
                this.columnHierarchy = new ArrayList();
            }
            this.columnHierarchy.add(putColumnHierarchy);
            return (B)this.self();
        }

        @Generated
        public B columnHierarchy(Collection<? extends Map<String, String>> columnHierarchy) {
            if (columnHierarchy == null) {
                throw new NullPointerException("columnHierarchy cannot be null");
            }
            if (this.columnHierarchy == null) {
                this.columnHierarchy = new ArrayList();
            }
            this.columnHierarchy.addAll(columnHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearColumnHierarchy() {
            if (this.columnHierarchy != null) {
                this.columnHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B columnHistogram(Histogram columnHistogram) {
            this.columnHistogram = columnHistogram;
            return (B)this.self();
        }

        @Generated
        public B columnMax(Double columnMax) {
            this.columnMax = columnMax;
            return (B)this.self();
        }

        @Generated
        public B columnMaximumStringLength(Integer columnMaximumStringLength) {
            this.columnMaximumStringLength = columnMaximumStringLength;
            return (B)this.self();
        }

        @Generated
        public B addColumnMax(String addColumnMax) {
            if (this.columnMaxs == null) {
                this.columnMaxs = new ArrayList();
            }
            this.columnMaxs.add(addColumnMax);
            return (B)this.self();
        }

        @Generated
        public B columnMaxs(Collection<? extends String> columnMaxs) {
            if (columnMaxs == null) {
                throw new NullPointerException("columnMaxs cannot be null");
            }
            if (this.columnMaxs == null) {
                this.columnMaxs = new ArrayList();
            }
            this.columnMaxs.addAll(columnMaxs);
            return (B)this.self();
        }

        @Generated
        public B clearColumnMaxs() {
            if (this.columnMaxs != null) {
                this.columnMaxs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B columnMean(Double columnMean) {
            this.columnMean = columnMean;
            return (B)this.self();
        }

        @Generated
        public B columnMedian(Double columnMedian) {
            this.columnMedian = columnMedian;
            return (B)this.self();
        }

        @Generated
        public B columnMin(Double columnMin) {
            this.columnMin = columnMin;
            return (B)this.self();
        }

        @Generated
        public B columnMinimumStringLength(Integer columnMinimumStringLength) {
            this.columnMinimumStringLength = columnMinimumStringLength;
            return (B)this.self();
        }

        @Generated
        public B addColumnMin(String addColumnMin) {
            if (this.columnMins == null) {
                this.columnMins = new ArrayList();
            }
            this.columnMins.add(addColumnMin);
            return (B)this.self();
        }

        @Generated
        public B columnMins(Collection<? extends String> columnMins) {
            if (columnMins == null) {
                throw new NullPointerException("columnMins cannot be null");
            }
            if (this.columnMins == null) {
                this.columnMins = new ArrayList();
            }
            this.columnMins.addAll(columnMins);
            return (B)this.self();
        }

        @Generated
        public B clearColumnMins() {
            if (this.columnMins != null) {
                this.columnMins.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B columnMissingValuesCount(Integer columnMissingValuesCount) {
            this.columnMissingValuesCount = columnMissingValuesCount;
            return (B)this.self();
        }

        @Generated
        public B columnMissingValuesCountLong(Long columnMissingValuesCountLong) {
            this.columnMissingValuesCountLong = columnMissingValuesCountLong;
            return (B)this.self();
        }

        @Generated
        public B columnMissingValuesPercentage(Double columnMissingValuesPercentage) {
            this.columnMissingValuesPercentage = columnMissingValuesPercentage;
            return (B)this.self();
        }

        @Generated
        public B columnStandardDeviation(Double columnStandardDeviation) {
            this.columnStandardDeviation = columnStandardDeviation;
            return (B)this.self();
        }

        @Generated
        public B columnSum(Double columnSum) {
            this.columnSum = columnSum;
            return (B)this.self();
        }

        @Generated
        public B columnTopValue(ColumnValueFrequencyMap columnTopValue) {
            if (this.columnTopValues == null) {
                this.columnTopValues = new ArrayList();
            }
            this.columnTopValues.add(columnTopValue);
            return (B)this.self();
        }

        @Generated
        public B columnTopValues(Collection<? extends ColumnValueFrequencyMap> columnTopValues) {
            if (columnTopValues == null) {
                throw new NullPointerException("columnTopValues cannot be null");
            }
            if (this.columnTopValues == null) {
                this.columnTopValues = new ArrayList();
            }
            this.columnTopValues.addAll(columnTopValues);
            return (B)this.self();
        }

        @Generated
        public B clearColumnTopValues() {
            if (this.columnTopValues != null) {
                this.columnTopValues.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B columnUniqueValuesCount(Integer columnUniqueValuesCount) {
            this.columnUniqueValuesCount = columnUniqueValuesCount;
            return (B)this.self();
        }

        @Generated
        public B columnUniqueValuesCountLong(Long columnUniqueValuesCountLong) {
            this.columnUniqueValuesCountLong = columnUniqueValuesCountLong;
            return (B)this.self();
        }

        @Generated
        public B columnUniquenessPercentage(Double columnUniquenessPercentage) {
            this.columnUniquenessPercentage = columnUniquenessPercentage;
            return (B)this.self();
        }

        @Generated
        public B columnVariance(Double columnVariance) {
            this.columnVariance = columnVariance;
            return (B)this.self();
        }

        @Generated
        public B cosmosMongoDBCollection(ICosmosMongoDBCollection cosmosMongoDBCollection) {
            this.cosmosMongoDBCollection = cosmosMongoDBCollection;
            return (B)this.self();
        }

        @Generated
        public B dataQualityMetricDimension(IMetric dataQualityMetricDimension) {
            if (this.dataQualityMetricDimensions == null) {
                this.dataQualityMetricDimensions = new ArrayList();
            }
            this.dataQualityMetricDimensions.add(dataQualityMetricDimension);
            return (B)this.self();
        }

        @Generated
        public B dataQualityMetricDimensions(Collection<? extends IMetric> dataQualityMetricDimensions) {
            if (dataQualityMetricDimensions == null) {
                throw new NullPointerException("dataQualityMetricDimensions cannot be null");
            }
            if (this.dataQualityMetricDimensions == null) {
                this.dataQualityMetricDimensions = new ArrayList();
            }
            this.dataQualityMetricDimensions.addAll(dataQualityMetricDimensions);
            return (B)this.self();
        }

        @Generated
        public B clearDataQualityMetricDimensions() {
            if (this.dataQualityMetricDimensions != null) {
                this.dataQualityMetricDimensions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dataType(String dataType) {
            this.dataType = dataType;
            return (B)this.self();
        }

        @Generated
        public B databaseName(String databaseName) {
            this.databaseName = databaseName;
            return (B)this.self();
        }

        @Generated
        public B databaseQualifiedName(String databaseQualifiedName) {
            this.databaseQualifiedName = databaseQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dbtMetric(IDbtMetric dbtMetric) {
            if (this.dbtMetrics == null) {
                this.dbtMetrics = new ArrayList();
            }
            this.dbtMetrics.add(dbtMetric);
            return (B)this.self();
        }

        @Generated
        public B dbtMetrics(Collection<? extends IDbtMetric> dbtMetrics) {
            if (dbtMetrics == null) {
                throw new NullPointerException("dbtMetrics cannot be null");
            }
            if (this.dbtMetrics == null) {
                this.dbtMetrics = new ArrayList();
            }
            this.dbtMetrics.addAll(dbtMetrics);
            return (B)this.self();
        }

        @Generated
        public B clearDbtMetrics() {
            if (this.dbtMetrics != null) {
                this.dbtMetrics.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtModelColumn(IDbtModelColumn dbtModelColumn) {
            if (this.dbtModelColumns == null) {
                this.dbtModelColumns = new ArrayList();
            }
            this.dbtModelColumns.add(dbtModelColumn);
            return (B)this.self();
        }

        @Generated
        public B dbtModelColumns(Collection<? extends IDbtModelColumn> dbtModelColumns) {
            if (dbtModelColumns == null) {
                throw new NullPointerException("dbtModelColumns cannot be null");
            }
            if (this.dbtModelColumns == null) {
                this.dbtModelColumns = new ArrayList();
            }
            this.dbtModelColumns.addAll(dbtModelColumns);
            return (B)this.self();
        }

        @Generated
        public B clearDbtModelColumns() {
            if (this.dbtModelColumns != null) {
                this.dbtModelColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtModel(IDbtModel dbtModel) {
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.add(dbtModel);
            return (B)this.self();
        }

        @Generated
        public B dbtModels(Collection<? extends IDbtModel> dbtModels) {
            if (dbtModels == null) {
                throw new NullPointerException("dbtModels cannot be null");
            }
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.addAll(dbtModels);
            return (B)this.self();
        }

        @Generated
        public B clearDbtModels() {
            if (this.dbtModels != null) {
                this.dbtModels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtSource(IDbtSource dbtSource) {
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.add(dbtSource);
            return (B)this.self();
        }

        @Generated
        public B dbtSources(Collection<? extends IDbtSource> dbtSources) {
            if (dbtSources == null) {
                throw new NullPointerException("dbtSources cannot be null");
            }
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.addAll(dbtSources);
            return (B)this.self();
        }

        @Generated
        public B clearDbtSources() {
            if (this.dbtSources != null) {
                this.dbtSources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtTest(IDbtTest dbtTest) {
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.add(dbtTest);
            return (B)this.self();
        }

        @Generated
        public B dbtTests(Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.addAll(dbtTests);
            return (B)this.self();
        }

        @Generated
        public B clearDbtTests() {
            if (this.dbtTests != null) {
                this.dbtTests.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return (B)this.self();
        }

        @Generated
        public B foreignKeyFrom(IColumn foreignKeyFrom) {
            this.foreignKeyFrom = foreignKeyFrom;
            return (B)this.self();
        }

        @Generated
        public B addForeignKeyTo(IColumn addForeignKeyTo) {
            if (this.foreignKeyTo == null) {
                this.foreignKeyTo = new ArrayList();
            }
            this.foreignKeyTo.add(addForeignKeyTo);
            return (B)this.self();
        }

        @Generated
        public B foreignKeyTo(Collection<? extends IColumn> foreignKeyTo) {
            if (foreignKeyTo == null) {
                throw new NullPointerException("foreignKeyTo cannot be null");
            }
            if (this.foreignKeyTo == null) {
                this.foreignKeyTo = new ArrayList();
            }
            this.foreignKeyTo.addAll(foreignKeyTo);
            return (B)this.self();
        }

        @Generated
        public B clearForeignKeyTo() {
            if (this.foreignKeyTo != null) {
                this.foreignKeyTo.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isClustered(Boolean isClustered) {
            this.isClustered = isClustered;
            return (B)this.self();
        }

        @Generated
        public B isDist(Boolean isDist) {
            this.isDist = isDist;
            return (B)this.self();
        }

        @Generated
        public B isForeign(Boolean isForeign) {
            this.isForeign = isForeign;
            return (B)this.self();
        }

        @Generated
        public B isIndexed(Boolean isIndexed) {
            this.isIndexed = isIndexed;
            return (B)this.self();
        }

        @Generated
        public B isNullable(Boolean isNullable) {
            this.isNullable = isNullable;
            return (B)this.self();
        }

        @Generated
        public B isPartition(Boolean isPartition) {
            this.isPartition = isPartition;
            return (B)this.self();
        }

        @Generated
        public B isPinned(Boolean isPinned) {
            this.isPinned = isPinned;
            return (B)this.self();
        }

        @Generated
        public B isPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return (B)this.self();
        }

        @Generated
        public B isProfiled(Boolean isProfiled) {
            this.isProfiled = isProfiled;
            return (B)this.self();
        }

        @Generated
        public B isSort(Boolean isSort) {
            this.isSort = isSort;
            return (B)this.self();
        }

        @Generated
        public B lastProfiledAt(Long lastProfiledAt) {
            this.lastProfiledAt = lastProfiledAt;
            return (B)this.self();
        }

        @JsonProperty(value="materialisedView")
        @Generated
        public B materializedView(IMaterializedView materializedView) {
            this.materializedView = materializedView;
            return (B)this.self();
        }

        @Generated
        public B maxLength(Long maxLength) {
            this.maxLength = maxLength;
            return (B)this.self();
        }

        @Generated
        public B metricTimestamp(IMetric metricTimestamp) {
            if (this.metricTimestamps == null) {
                this.metricTimestamps = new ArrayList();
            }
            this.metricTimestamps.add(metricTimestamp);
            return (B)this.self();
        }

        @Generated
        public B metricTimestamps(Collection<? extends IMetric> metricTimestamps) {
            if (metricTimestamps == null) {
                throw new NullPointerException("metricTimestamps cannot be null");
            }
            if (this.metricTimestamps == null) {
                this.metricTimestamps = new ArrayList();
            }
            this.metricTimestamps.addAll(metricTimestamps);
            return (B)this.self();
        }

        @Generated
        public B clearMetricTimestamps() {
            if (this.metricTimestamps != null) {
                this.metricTimestamps.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B nestedColumnCount(Integer nestedColumnCount) {
            this.nestedColumnCount = nestedColumnCount;
            return (B)this.self();
        }

        @Generated
        public B nestedColumnOrder(String nestedColumnOrder) {
            this.nestedColumnOrder = nestedColumnOrder;
            return (B)this.self();
        }

        @Generated
        public B nestedColumn(IColumn nestedColumn) {
            if (this.nestedColumns == null) {
                this.nestedColumns = new ArrayList();
            }
            this.nestedColumns.add(nestedColumn);
            return (B)this.self();
        }

        @Generated
        public B nestedColumns(Collection<? extends IColumn> nestedColumns) {
            if (nestedColumns == null) {
                throw new NullPointerException("nestedColumns cannot be null");
            }
            if (this.nestedColumns == null) {
                this.nestedColumns = new ArrayList();
            }
            this.nestedColumns.addAll(nestedColumns);
            return (B)this.self();
        }

        @Generated
        public B clearNestedColumns() {
            if (this.nestedColumns != null) {
                this.nestedColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B nosqlCollectionName(String nosqlCollectionName) {
            this.nosqlCollectionName = nosqlCollectionName;
            return (B)this.self();
        }

        @Generated
        public B nosqlCollectionQualifiedName(String nosqlCollectionQualifiedName) {
            this.nosqlCollectionQualifiedName = nosqlCollectionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B numericScale(Double numericScale) {
            this.numericScale = numericScale;
            return (B)this.self();
        }

        @Generated
        public B order(Integer order) {
            this.order = order;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B parentColumn(IColumn parentColumn) {
            this.parentColumn = parentColumn;
            return (B)this.self();
        }

        @Generated
        public B parentColumnName(String parentColumnName) {
            this.parentColumnName = parentColumnName;
            return (B)this.self();
        }

        @Generated
        public B parentColumnQualifiedName(String parentColumnQualifiedName) {
            this.parentColumnQualifiedName = parentColumnQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B partitionOrder(Integer partitionOrder) {
            this.partitionOrder = partitionOrder;
            return (B)this.self();
        }

        @Generated
        public B pinnedAt(Long pinnedAt) {
            this.pinnedAt = pinnedAt;
            return (B)this.self();
        }

        @Generated
        public B pinnedBy(String pinnedBy) {
            this.pinnedBy = pinnedBy;
            return (B)this.self();
        }

        @Generated
        public B precision(Integer precision) {
            this.precision = precision;
            return (B)this.self();
        }

        @Generated
        public B query(IAtlanQuery query) {
            if (this.queries == null) {
                this.queries = new ArrayList();
            }
            this.queries.add(query);
            return (B)this.self();
        }

        @Generated
        public B queries(Collection<? extends IAtlanQuery> queries) {
            if (queries == null) {
                throw new NullPointerException("queries cannot be null");
            }
            if (this.queries == null) {
                this.queries = new ArrayList();
            }
            this.queries.addAll(queries);
            return (B)this.self();
        }

        @Generated
        public B clearQueries() {
            if (this.queries != null) {
                this.queries.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B queryCount(Long queryCount) {
            this.queryCount = queryCount;
            return (B)this.self();
        }

        @Generated
        public B queryCountUpdatedAt(Long queryCountUpdatedAt) {
            this.queryCountUpdatedAt = queryCountUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B queryUserCount(Long queryUserCount) {
            this.queryUserCount = queryUserCount;
            return (B)this.self();
        }

        @Generated
        public B putQueryUserMap(String putQueryUserMapKey, Long putQueryUserMapValue) {
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            this.queryUserMap$key.add(putQueryUserMapKey);
            this.queryUserMap$value.add(putQueryUserMapValue);
            return (B)this.self();
        }

        @Generated
        public B queryUserMap(Map<? extends String, ? extends Long> queryUserMap) {
            if (queryUserMap == null) {
                throw new NullPointerException("queryUserMap cannot be null");
            }
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Long> $lombokEntry : queryUserMap.entrySet()) {
                this.queryUserMap$key.add($lombokEntry.getKey());
                this.queryUserMap$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearQueryUserMap() {
            if (this.queryUserMap$key != null) {
                this.queryUserMap$key.clear();
                this.queryUserMap$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B rawDataTypeDefinition(String rawDataTypeDefinition) {
            this.rawDataTypeDefinition = rawDataTypeDefinition;
            return (B)this.self();
        }

        @Generated
        public B schemaName(String schemaName) {
            this.schemaName = schemaName;
            return (B)this.self();
        }

        @Generated
        public B schemaQualifiedName(String schemaQualifiedName) {
            this.schemaQualifiedName = schemaQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B snowflakeDynamicTable(ISnowflakeDynamicTable snowflakeDynamicTable) {
            this.snowflakeDynamicTable = snowflakeDynamicTable;
            return (B)this.self();
        }

        @Generated
        public B sqlDBTSource(IDbtSource sqlDBTSource) {
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.add(sqlDBTSource);
            return (B)this.self();
        }

        @Generated
        public B sqlDBTSources(Collection<? extends IDbtSource> sqlDBTSources) {
            if (sqlDBTSources == null) {
                throw new NullPointerException("sqlDBTSources cannot be null");
            }
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.addAll(sqlDBTSources);
            return (B)this.self();
        }

        @Generated
        public B clearSqlDBTSources() {
            if (this.sqlDBTSources != null) {
                this.sqlDBTSources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sqlDbtModel(IDbtModel sqlDbtModel) {
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.add(sqlDbtModel);
            return (B)this.self();
        }

        @Generated
        public B sqlDbtModels(Collection<? extends IDbtModel> sqlDbtModels) {
            if (sqlDbtModels == null) {
                throw new NullPointerException("sqlDbtModels cannot be null");
            }
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.addAll(sqlDbtModels);
            return (B)this.self();
        }

        @Generated
        public B clearSqlDbtModels() {
            if (this.sqlDbtModels != null) {
                this.sqlDbtModels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B subDataType(String subDataType) {
            this.subDataType = subDataType;
            return (B)this.self();
        }

        @Generated
        public B table(ITable table) {
            this.table = table;
            return (B)this.self();
        }

        @Generated
        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        @Generated
        public B tablePartition(ITablePartition tablePartition) {
            this.tablePartition = tablePartition;
            return (B)this.self();
        }

        @Generated
        public B tableQualifiedName(String tableQualifiedName) {
            this.tableQualifiedName = tableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B validation(String validationKey, String validationValue) {
            if (this.validations$key == null) {
                this.validations$key = new ArrayList();
                this.validations$value = new ArrayList();
            }
            this.validations$key.add(validationKey);
            this.validations$value.add(validationValue);
            return (B)this.self();
        }

        @Generated
        public B validations(Map<? extends String, ? extends String> validations) {
            if (validations == null) {
                throw new NullPointerException("validations cannot be null");
            }
            if (this.validations$key == null) {
                this.validations$key = new ArrayList();
                this.validations$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : validations.entrySet()) {
                this.validations$key.add($lombokEntry.getKey());
                this.validations$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearValidations() {
            if (this.validations$key != null) {
                this.validations$key.clear();
                this.validations$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B view(IView view) {
            this.view = view;
            return (B)this.self();
        }

        @Generated
        public B viewName(String viewName) {
            this.viewName = viewName;
            return (B)this.self();
        }

        @Generated
        public B viewQualifiedName(String viewQualifiedName) {
            this.viewQualifiedName = viewQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Column.ColumnBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", calculationView=" + String.valueOf(this.calculationView) + ", calculationViewName=" + this.calculationViewName + ", calculationViewQualifiedName=" + this.calculationViewQualifiedName + ", columnAverage=" + this.columnAverage + ", columnAverageLength=" + this.columnAverageLength + ", columnCompression=" + this.columnCompression + ", columnDbtModelColumns=" + String.valueOf(this.columnDbtModelColumns) + ", columnDepthLevel=" + this.columnDepthLevel + ", columnDistinctValuesCount=" + this.columnDistinctValuesCount + ", columnDistinctValuesCountLong=" + this.columnDistinctValuesCountLong + ", columnDuplicateValuesCount=" + this.columnDuplicateValuesCount + ", columnDuplicateValuesCountLong=" + this.columnDuplicateValuesCountLong + ", columnEncoding=" + this.columnEncoding + ", columnHierarchy=" + String.valueOf(this.columnHierarchy) + ", columnHistogram=" + String.valueOf(this.columnHistogram) + ", columnMax=" + this.columnMax + ", columnMaximumStringLength=" + this.columnMaximumStringLength + ", columnMaxs=" + String.valueOf(this.columnMaxs) + ", columnMean=" + this.columnMean + ", columnMedian=" + this.columnMedian + ", columnMin=" + this.columnMin + ", columnMinimumStringLength=" + this.columnMinimumStringLength + ", columnMins=" + String.valueOf(this.columnMins) + ", columnMissingValuesCount=" + this.columnMissingValuesCount + ", columnMissingValuesCountLong=" + this.columnMissingValuesCountLong + ", columnMissingValuesPercentage=" + this.columnMissingValuesPercentage + ", columnStandardDeviation=" + this.columnStandardDeviation + ", columnSum=" + this.columnSum + ", columnTopValues=" + String.valueOf(this.columnTopValues) + ", columnUniqueValuesCount=" + this.columnUniqueValuesCount + ", columnUniqueValuesCountLong=" + this.columnUniqueValuesCountLong + ", columnUniquenessPercentage=" + this.columnUniquenessPercentage + ", columnVariance=" + this.columnVariance + ", cosmosMongoDBCollection=" + String.valueOf(this.cosmosMongoDBCollection) + ", dataQualityMetricDimensions=" + String.valueOf(this.dataQualityMetricDimensions) + ", dataType=" + this.dataType + ", databaseName=" + this.databaseName + ", databaseQualifiedName=" + this.databaseQualifiedName + ", dbtMetrics=" + String.valueOf(this.dbtMetrics) + ", dbtModelColumns=" + String.valueOf(this.dbtModelColumns) + ", dbtModels=" + String.valueOf(this.dbtModels) + ", dbtSources=" + String.valueOf(this.dbtSources) + ", dbtTests=" + String.valueOf(this.dbtTests) + ", defaultValue=" + this.defaultValue + ", foreignKeyFrom=" + String.valueOf(this.foreignKeyFrom) + ", foreignKeyTo=" + String.valueOf(this.foreignKeyTo) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", isClustered=" + this.isClustered + ", isDist=" + this.isDist + ", isForeign=" + this.isForeign + ", isIndexed=" + this.isIndexed + ", isNullable=" + this.isNullable + ", isPartition=" + this.isPartition + ", isPinned=" + this.isPinned + ", isPrimary=" + this.isPrimary + ", isProfiled=" + this.isProfiled + ", isSort=" + this.isSort + ", lastProfiledAt=" + this.lastProfiledAt + ", materializedView=" + String.valueOf(this.materializedView) + ", maxLength=" + this.maxLength + ", metricTimestamps=" + String.valueOf(this.metricTimestamps) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", nestedColumnCount=" + this.nestedColumnCount + ", nestedColumnOrder=" + this.nestedColumnOrder + ", nestedColumns=" + String.valueOf(this.nestedColumns) + ", nosqlCollectionName=" + this.nosqlCollectionName + ", nosqlCollectionQualifiedName=" + this.nosqlCollectionQualifiedName + ", numericScale=" + this.numericScale + ", order=" + this.order + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", parentColumn=" + String.valueOf(this.parentColumn) + ", parentColumnName=" + this.parentColumnName + ", parentColumnQualifiedName=" + this.parentColumnQualifiedName + ", partitionOrder=" + this.partitionOrder + ", pinnedAt=" + this.pinnedAt + ", pinnedBy=" + this.pinnedBy + ", precision=" + this.precision + ", queries=" + String.valueOf(this.queries) + ", queryCount=" + this.queryCount + ", queryCountUpdatedAt=" + this.queryCountUpdatedAt + ", queryUserCount=" + this.queryUserCount + ", queryUserMap$key=" + String.valueOf(this.queryUserMap$key) + ", queryUserMap$value=" + String.valueOf(this.queryUserMap$value) + ", rawDataTypeDefinition=" + this.rawDataTypeDefinition + ", schemaName=" + this.schemaName + ", schemaQualifiedName=" + this.schemaQualifiedName + ", snowflakeDynamicTable=" + String.valueOf(this.snowflakeDynamicTable) + ", sqlDBTSources=" + String.valueOf(this.sqlDBTSources) + ", sqlDbtModels=" + String.valueOf(this.sqlDbtModels) + ", subDataType=" + this.subDataType + ", table=" + String.valueOf(this.table) + ", tableName=" + this.tableName + ", tablePartition=" + (String.valueOf(this.tablePartition) + ", tableQualifiedName=" + this.tableQualifiedName + ", validations$key=" + String.valueOf(this.validations$key) + ", validations$value=" + String.valueOf(this.validations$value) + ", view=" + String.valueOf(this.view) + ", viewName=" + this.viewName + ", viewQualifiedName=" + this.viewQualifiedName + ")");
        }
    }

    @Generated
    private static final class ColumnBuilderImpl
    extends ColumnBuilder<Column, ColumnBuilderImpl> {
        @Generated
        private ColumnBuilderImpl() {
        }

        @Override
        @Generated
        protected ColumnBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Column build() {
            return new Column(this);
        }
    }
}

