/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IConnection;
import com.atlan.model.assets.IConnectionProcess;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionProcess
extends Asset
implements IConnectionProcess,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionProcess.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ConnectionProcess";
    String typeName;
    @Attribute
    SortedSet<IConnection> inputs;
    @Attribute
    SortedSet<IConnection> outputs;

    @Override
    public ConnectionProcess trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ConnectionProcess.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ConnectionProcess.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ConnectionProcess.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ConnectionProcess.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static ConnectionProcess refByGuid(String guid) {
        return ConnectionProcess.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static ConnectionProcess refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((ConnectionProcessBuilder)((ConnectionProcessBuilder)ConnectionProcess._internal().guid(guid)).semantic(semantic)).build();
    }

    public static ConnectionProcess refByQualifiedName(String qualifiedName) {
        return ConnectionProcess.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static ConnectionProcess refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((ConnectionProcessBuilder)((ConnectionProcessBuilder)ConnectionProcess._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static ConnectionProcess get(AtlanClient client, String id) throws AtlanException {
        return ConnectionProcess.get(client, id, false);
    }

    @JsonIgnore
    public static ConnectionProcess get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ConnectionProcess) {
                return (ConnectionProcess)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof ConnectionProcess) {
            return (ConnectionProcess)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static ConnectionProcess get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return ConnectionProcess.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static ConnectionProcess get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)ConnectionProcess.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof ConnectionProcess) {
                return (ConnectionProcess)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)ConnectionProcess.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof ConnectionProcess) {
            return (ConnectionProcess)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ConnectionProcessBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ConnectionProcessBuilder)((ConnectionProcessBuilder)((ConnectionProcessBuilder)ConnectionProcess._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ConnectionProcessBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        ConnectionProcess.validateRequired(TYPE_NAME, map);
        return ConnectionProcess.updater(this.getQualifiedName(), this.getName());
    }

    public static ConnectionProcess removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ConnectionProcess)Asset.removeDescription(client, ConnectionProcess.updater(qualifiedName, name));
    }

    public static ConnectionProcess removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ConnectionProcess)Asset.removeUserDescription(client, ConnectionProcess.updater(qualifiedName, name));
    }

    public static ConnectionProcess removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ConnectionProcess)Asset.removeOwners(client, ConnectionProcess.updater(qualifiedName, name));
    }

    public static ConnectionProcess updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ConnectionProcess)Asset.updateCertificate(client, ConnectionProcess._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ConnectionProcess removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ConnectionProcess)Asset.removeCertificate(client, ConnectionProcess.updater(qualifiedName, name));
    }

    public static ConnectionProcess updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ConnectionProcess)Asset.updateAnnouncement(client, ConnectionProcess._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ConnectionProcess removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ConnectionProcess)Asset.removeAnnouncement(client, ConnectionProcess.updater(qualifiedName, name));
    }

    public static ConnectionProcess replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ConnectionProcess)Asset.replaceTerms(client, ConnectionProcess.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static ConnectionProcess appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ConnectionProcess)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static ConnectionProcess removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ConnectionProcess)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static ConnectionProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ConnectionProcess)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static ConnectionProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ConnectionProcess)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ConnectionProcess(ConnectionProcessBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ConnectionProcess.$default$typeName();
        SortedSet<IConnection> inputs = new TreeSet<IConnection>();
        if (b.inputs != null) {
            inputs.addAll(b.inputs);
        }
        inputs = Collections.unmodifiableSortedSet(inputs);
        this.inputs = inputs;
        SortedSet<IConnection> outputs = new TreeSet<IConnection>();
        if (b.outputs != null) {
            outputs.addAll(b.outputs);
        }
        outputs = Collections.unmodifiableSortedSet(outputs);
        this.outputs = outputs;
    }

    @Generated
    public static ConnectionProcessBuilder<?, ?> _internal() {
        return new ConnectionProcessBuilderImpl();
    }

    @Generated
    public ConnectionProcessBuilder<?, ?> toBuilder() {
        return new ConnectionProcessBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IConnection> getInputs() {
        return this.inputs;
    }

    @Override
    @Generated
    public SortedSet<IConnection> getOutputs() {
        return this.outputs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionProcess)) {
            return false;
        }
        ConnectionProcess other = (ConnectionProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IConnection> this$inputs = this.getInputs();
        SortedSet<IConnection> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) {
            return false;
        }
        SortedSet<IConnection> this$outputs = this.getOutputs();
        SortedSet<IConnection> other$outputs = other.getOutputs();
        return !(this$outputs == null ? other$outputs != null : !this$outputs.equals(other$outputs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConnectionProcess;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IConnection> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : $inputs.hashCode());
        SortedSet<IConnection> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : $outputs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ConnectionProcess(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputs=" + String.valueOf(this.getInputs()) + ", outputs=" + String.valueOf(this.getOutputs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class ConnectionProcessBuilder<C extends ConnectionProcess, B extends ConnectionProcessBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IConnection> inputs;
        @Generated
        private ArrayList<IConnection> outputs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ConnectionProcessBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ConnectionProcess instance, ConnectionProcessBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputs(instance.inputs == null ? Collections.emptySortedSet() : instance.inputs);
            b.outputs(instance.outputs == null ? Collections.emptySortedSet() : instance.outputs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B input(IConnection input) {
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.add(input);
            return (B)this.self();
        }

        @Generated
        public B inputs(Collection<? extends IConnection> inputs) {
            if (inputs == null) {
                throw new NullPointerException("inputs cannot be null");
            }
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.addAll(inputs);
            return (B)this.self();
        }

        @Generated
        public B clearInputs() {
            if (this.inputs != null) {
                this.inputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B output(IConnection output) {
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.add(output);
            return (B)this.self();
        }

        @Generated
        public B outputs(Collection<? extends IConnection> outputs) {
            if (outputs == null) {
                throw new NullPointerException("outputs cannot be null");
            }
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.addAll(outputs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputs() {
            if (this.outputs != null) {
                this.outputs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ConnectionProcess.ConnectionProcessBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputs=" + String.valueOf(this.inputs) + ", outputs=" + String.valueOf(this.outputs) + ")";
        }
    }

    @Generated
    private static final class ConnectionProcessBuilderImpl
    extends ConnectionProcessBuilder<ConnectionProcess, ConnectionProcessBuilderImpl> {
        @Generated
        private ConnectionProcessBuilderImpl() {
        }

        @Override
        @Generated
        protected ConnectionProcessBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ConnectionProcess build() {
            return new ConnectionProcess(this);
        }
    }
}

