/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDomo;
import com.atlan.model.assets.IDomoCard;
import com.atlan.model.assets.IDomoDashboard;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomoDashboard
extends Asset
implements IDomoDashboard,
IDomo,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DomoDashboard.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DomoDashboard";
    String typeName;
    @Attribute
    SortedSet<IDomoCard> domoCards;
    @Attribute
    Long domoDashboardCardCount;
    @Attribute
    SortedSet<IDomoDashboard> domoDashboardChildren;
    @Attribute
    IDomoDashboard domoDashboardParent;
    @Attribute
    String domoId;
    @Attribute
    String domoOwnerId;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public DomoDashboard trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DomoDashboard.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DomoDashboard.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DomoDashboard.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DomoDashboard.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static DomoDashboard refByGuid(String guid) {
        return DomoDashboard.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static DomoDashboard refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((DomoDashboardBuilder)((DomoDashboardBuilder)DomoDashboard._internal().guid(guid)).semantic(semantic)).build();
    }

    public static DomoDashboard refByQualifiedName(String qualifiedName) {
        return DomoDashboard.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static DomoDashboard refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((DomoDashboardBuilder)((DomoDashboardBuilder)DomoDashboard._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static DomoDashboard get(AtlanClient client, String id) throws AtlanException {
        return DomoDashboard.get(client, id, false);
    }

    @JsonIgnore
    public static DomoDashboard get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DomoDashboard) {
                return (DomoDashboard)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof DomoDashboard) {
            return (DomoDashboard)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static DomoDashboard get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return DomoDashboard.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static DomoDashboard get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DomoDashboard.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof DomoDashboard) {
                return (DomoDashboard)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DomoDashboard.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof DomoDashboard) {
            return (DomoDashboard)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DomoDashboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DomoDashboardBuilder)((DomoDashboardBuilder)((DomoDashboardBuilder)DomoDashboard._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public DomoDashboardBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        DomoDashboard.validateRequired(TYPE_NAME, map);
        return DomoDashboard.updater(this.getQualifiedName(), this.getName());
    }

    public static DomoDashboard removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DomoDashboard)Asset.removeDescription(client, DomoDashboard.updater(qualifiedName, name));
    }

    public static DomoDashboard removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DomoDashboard)Asset.removeUserDescription(client, DomoDashboard.updater(qualifiedName, name));
    }

    public static DomoDashboard removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DomoDashboard)Asset.removeOwners(client, DomoDashboard.updater(qualifiedName, name));
    }

    public static DomoDashboard updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DomoDashboard)Asset.updateCertificate(client, DomoDashboard._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DomoDashboard removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DomoDashboard)Asset.removeCertificate(client, DomoDashboard.updater(qualifiedName, name));
    }

    public static DomoDashboard updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DomoDashboard)Asset.updateAnnouncement(client, DomoDashboard._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DomoDashboard removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DomoDashboard)Asset.removeAnnouncement(client, DomoDashboard.updater(qualifiedName, name));
    }

    public static DomoDashboard replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DomoDashboard)Asset.replaceTerms(client, DomoDashboard.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static DomoDashboard appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DomoDashboard)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static DomoDashboard removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DomoDashboard)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static DomoDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DomoDashboard)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static DomoDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DomoDashboard)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DomoDashboard(DomoDashboardBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DomoDashboard.$default$typeName();
        SortedSet<IDomoCard> domoCards = new TreeSet<IDomoCard>();
        if (b.domoCards != null) {
            domoCards.addAll(b.domoCards);
        }
        domoCards = Collections.unmodifiableSortedSet(domoCards);
        this.domoCards = domoCards;
        this.domoDashboardCardCount = b.domoDashboardCardCount;
        SortedSet<IDomoDashboard> domoDashboardChildren = new TreeSet<IDomoDashboard>();
        if (b.domoDashboardChildren != null) {
            domoDashboardChildren.addAll(b.domoDashboardChildren);
        }
        domoDashboardChildren = Collections.unmodifiableSortedSet(domoDashboardChildren);
        this.domoDashboardChildren = domoDashboardChildren;
        this.domoDashboardParent = b.domoDashboardParent;
        this.domoId = b.domoId;
        this.domoOwnerId = b.domoOwnerId;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static DomoDashboardBuilder<?, ?> _internal() {
        return new DomoDashboardBuilderImpl();
    }

    @Generated
    public DomoDashboardBuilder<?, ?> toBuilder() {
        return new DomoDashboardBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IDomoCard> getDomoCards() {
        return this.domoCards;
    }

    @Override
    @Generated
    public Long getDomoDashboardCardCount() {
        return this.domoDashboardCardCount;
    }

    @Override
    @Generated
    public SortedSet<IDomoDashboard> getDomoDashboardChildren() {
        return this.domoDashboardChildren;
    }

    @Override
    @Generated
    public IDomoDashboard getDomoDashboardParent() {
        return this.domoDashboardParent;
    }

    @Override
    @Generated
    public String getDomoId() {
        return this.domoId;
    }

    @Override
    @Generated
    public String getDomoOwnerId() {
        return this.domoOwnerId;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DomoDashboard)) {
            return false;
        }
        DomoDashboard other = (DomoDashboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$domoDashboardCardCount = this.getDomoDashboardCardCount();
        Long other$domoDashboardCardCount = other.getDomoDashboardCardCount();
        if (this$domoDashboardCardCount == null ? other$domoDashboardCardCount != null : !((Object)this$domoDashboardCardCount).equals(other$domoDashboardCardCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IDomoCard> this$domoCards = this.getDomoCards();
        SortedSet<IDomoCard> other$domoCards = other.getDomoCards();
        if (this$domoCards == null ? other$domoCards != null : !this$domoCards.equals(other$domoCards)) {
            return false;
        }
        SortedSet<IDomoDashboard> this$domoDashboardChildren = this.getDomoDashboardChildren();
        SortedSet<IDomoDashboard> other$domoDashboardChildren = other.getDomoDashboardChildren();
        if (this$domoDashboardChildren == null ? other$domoDashboardChildren != null : !this$domoDashboardChildren.equals(other$domoDashboardChildren)) {
            return false;
        }
        IDomoDashboard this$domoDashboardParent = this.getDomoDashboardParent();
        IDomoDashboard other$domoDashboardParent = other.getDomoDashboardParent();
        if (this$domoDashboardParent == null ? other$domoDashboardParent != null : !this$domoDashboardParent.equals(other$domoDashboardParent)) {
            return false;
        }
        String this$domoId = this.getDomoId();
        String other$domoId = other.getDomoId();
        if (this$domoId == null ? other$domoId != null : !this$domoId.equals(other$domoId)) {
            return false;
        }
        String this$domoOwnerId = this.getDomoOwnerId();
        String other$domoOwnerId = other.getDomoOwnerId();
        if (this$domoOwnerId == null ? other$domoOwnerId != null : !this$domoOwnerId.equals(other$domoOwnerId)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DomoDashboard;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $domoDashboardCardCount = this.getDomoDashboardCardCount();
        result = result * 59 + ($domoDashboardCardCount == null ? 43 : ((Object)$domoDashboardCardCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IDomoCard> $domoCards = this.getDomoCards();
        result = result * 59 + ($domoCards == null ? 43 : $domoCards.hashCode());
        SortedSet<IDomoDashboard> $domoDashboardChildren = this.getDomoDashboardChildren();
        result = result * 59 + ($domoDashboardChildren == null ? 43 : $domoDashboardChildren.hashCode());
        IDomoDashboard $domoDashboardParent = this.getDomoDashboardParent();
        result = result * 59 + ($domoDashboardParent == null ? 43 : $domoDashboardParent.hashCode());
        String $domoId = this.getDomoId();
        result = result * 59 + ($domoId == null ? 43 : $domoId.hashCode());
        String $domoOwnerId = this.getDomoOwnerId();
        result = result * 59 + ($domoOwnerId == null ? 43 : $domoOwnerId.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DomoDashboard(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", domoCards=" + String.valueOf(this.getDomoCards()) + ", domoDashboardCardCount=" + this.getDomoDashboardCardCount() + ", domoDashboardChildren=" + String.valueOf(this.getDomoDashboardChildren()) + ", domoDashboardParent=" + String.valueOf(this.getDomoDashboardParent()) + ", domoId=" + this.getDomoId() + ", domoOwnerId=" + this.getDomoOwnerId() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class DomoDashboardBuilder<C extends DomoDashboard, B extends DomoDashboardBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IDomoCard> domoCards;
        @Generated
        private Long domoDashboardCardCount;
        @Generated
        private ArrayList<IDomoDashboard> domoDashboardChildren;
        @Generated
        private IDomoDashboard domoDashboardParent;
        @Generated
        private String domoId;
        @Generated
        private String domoOwnerId;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DomoDashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DomoDashboard instance, DomoDashboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.domoCards(instance.domoCards == null ? Collections.emptySortedSet() : instance.domoCards);
            b.domoDashboardCardCount(instance.domoDashboardCardCount);
            b.domoDashboardChildren(instance.domoDashboardChildren == null ? Collections.emptySortedSet() : instance.domoDashboardChildren);
            b.domoDashboardParent(instance.domoDashboardParent);
            b.domoId(instance.domoId);
            b.domoOwnerId(instance.domoOwnerId);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B domoCard(IDomoCard domoCard) {
            if (this.domoCards == null) {
                this.domoCards = new ArrayList();
            }
            this.domoCards.add(domoCard);
            return (B)this.self();
        }

        @Generated
        public B domoCards(Collection<? extends IDomoCard> domoCards) {
            if (domoCards == null) {
                throw new NullPointerException("domoCards cannot be null");
            }
            if (this.domoCards == null) {
                this.domoCards = new ArrayList();
            }
            this.domoCards.addAll(domoCards);
            return (B)this.self();
        }

        @Generated
        public B clearDomoCards() {
            if (this.domoCards != null) {
                this.domoCards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B domoDashboardCardCount(Long domoDashboardCardCount) {
            this.domoDashboardCardCount = domoDashboardCardCount;
            return (B)this.self();
        }

        @Generated
        public B domoDashboardChild(IDomoDashboard domoDashboardChild) {
            if (this.domoDashboardChildren == null) {
                this.domoDashboardChildren = new ArrayList();
            }
            this.domoDashboardChildren.add(domoDashboardChild);
            return (B)this.self();
        }

        @Generated
        public B domoDashboardChildren(Collection<? extends IDomoDashboard> domoDashboardChildren) {
            if (domoDashboardChildren == null) {
                throw new NullPointerException("domoDashboardChildren cannot be null");
            }
            if (this.domoDashboardChildren == null) {
                this.domoDashboardChildren = new ArrayList();
            }
            this.domoDashboardChildren.addAll(domoDashboardChildren);
            return (B)this.self();
        }

        @Generated
        public B clearDomoDashboardChildren() {
            if (this.domoDashboardChildren != null) {
                this.domoDashboardChildren.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B domoDashboardParent(IDomoDashboard domoDashboardParent) {
            this.domoDashboardParent = domoDashboardParent;
            return (B)this.self();
        }

        @Generated
        public B domoId(String domoId) {
            this.domoId = domoId;
            return (B)this.self();
        }

        @Generated
        public B domoOwnerId(String domoOwnerId) {
            this.domoOwnerId = domoOwnerId;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DomoDashboard.DomoDashboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", domoCards=" + String.valueOf(this.domoCards) + ", domoDashboardCardCount=" + this.domoDashboardCardCount + ", domoDashboardChildren=" + String.valueOf(this.domoDashboardChildren) + ", domoDashboardParent=" + String.valueOf(this.domoDashboardParent) + ", domoId=" + this.domoId + ", domoOwnerId=" + this.domoOwnerId + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class DomoDashboardBuilderImpl
    extends DomoDashboardBuilder<DomoDashboard, DomoDashboardBuilderImpl> {
        @Generated
        private DomoDashboardBuilderImpl() {
        }

        @Override
        @Generated
        protected DomoDashboardBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DomoDashboard build() {
            return new DomoDashboard(this);
        }
    }
}

