/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IForm;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.FormField;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Form
extends Asset
implements IForm,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Form.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Form";
    String typeName;
    @Attribute
    List<FormField> formFields;
    @Attribute
    Map<String, String> formOptions;

    @Override
    public Form trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return Form.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return Form.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return Form.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return Form.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static Form refByGuid(String guid) {
        return Form.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static Form refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((FormBuilder)((FormBuilder)Form._internal().guid(guid)).semantic(semantic)).build();
    }

    public static Form refByQualifiedName(String qualifiedName) {
        return Form.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static Form refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((FormBuilder)((FormBuilder)Form._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static Form get(AtlanClient client, String id) throws AtlanException {
        return Form.get(client, id, false);
    }

    @JsonIgnore
    public static Form get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof Form) {
                return (Form)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof Form) {
            return (Form)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static Form get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return Form.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static Form get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Form.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof Form) {
                return (Form)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Form.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof Form) {
            return (Form)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static FormBuilder<?, ?> updater(String qualifiedName, String name) {
        return (FormBuilder)((FormBuilder)((FormBuilder)Form._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public FormBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        Form.validateRequired(TYPE_NAME, map);
        return Form.updater(this.getQualifiedName(), this.getName());
    }

    public static Form removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Form)Asset.removeDescription(client, Form.updater(qualifiedName, name));
    }

    public static Form removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Form)Asset.removeUserDescription(client, Form.updater(qualifiedName, name));
    }

    public static Form removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Form)Asset.removeOwners(client, Form.updater(qualifiedName, name));
    }

    public static Form updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (Form)Asset.updateCertificate(client, Form._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Form removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Form)Asset.removeCertificate(client, Form.updater(qualifiedName, name));
    }

    public static Form updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Form)Asset.updateAnnouncement(client, Form._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Form removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Form)Asset.removeAnnouncement(client, Form.updater(qualifiedName, name));
    }

    public static Form replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (Form)Asset.replaceTerms(client, Form.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static Form appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Form)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static Form removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Form)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static Form appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Form)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static Form appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Form)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Form(FormBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> formOptions;
        this.typeName = b.typeName$set ? b.typeName$value : Form.$default$typeName();
        this.formFields = switch (b.formFields == null ? 0 : b.formFields.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.formFields.get(0));
            default -> Collections.unmodifiableList(new ArrayList<FormField>(b.formFields));
        };
        switch (b.formOptions$key == null ? 0 : b.formOptions$key.size()) {
            case 0: {
                formOptions = Collections.emptyMap();
                break;
            }
            case 1: {
                formOptions = Collections.singletonMap(b.formOptions$key.get(0), b.formOptions$value.get(0));
                break;
            }
            default: {
                formOptions = new LinkedHashMap(b.formOptions$key.size() < 0x40000000 ? 1 + b.formOptions$key.size() + (b.formOptions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.formOptions$key.size(); ++$i) {
                    formOptions.put(b.formOptions$key.get($i), b.formOptions$value.get($i));
                }
                formOptions = Collections.unmodifiableMap(formOptions);
            }
        }
        this.formOptions = formOptions;
    }

    @Generated
    public static FormBuilder<?, ?> _internal() {
        return new FormBuilderImpl();
    }

    @Generated
    public FormBuilder<?, ?> toBuilder() {
        return new FormBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public List<FormField> getFormFields() {
        return this.formFields;
    }

    @Override
    @Generated
    public Map<String, String> getFormOptions() {
        return this.formOptions;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Form)) {
            return false;
        }
        Form other = (Form)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        List<FormField> this$formFields = this.getFormFields();
        List<FormField> other$formFields = other.getFormFields();
        if (this$formFields == null ? other$formFields != null : !((Object)this$formFields).equals(other$formFields)) {
            return false;
        }
        Map<String, String> this$formOptions = this.getFormOptions();
        Map<String, String> other$formOptions = other.getFormOptions();
        return !(this$formOptions == null ? other$formOptions != null : !((Object)this$formOptions).equals(other$formOptions));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Form;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        List<FormField> $formFields = this.getFormFields();
        result = result * 59 + ($formFields == null ? 43 : ((Object)$formFields).hashCode());
        Map<String, String> $formOptions = this.getFormOptions();
        result = result * 59 + ($formOptions == null ? 43 : ((Object)$formOptions).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Form(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", formFields=" + String.valueOf(this.getFormFields()) + ", formOptions=" + String.valueOf(this.getFormOptions()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class FormBuilder<C extends Form, B extends FormBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<FormField> formFields;
        @Generated
        private ArrayList<String> formOptions$key;
        @Generated
        private ArrayList<String> formOptions$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FormBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Form instance, FormBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.formFields(instance.formFields == null ? Collections.emptyList() : instance.formFields);
            b.formOptions(instance.formOptions == null ? Collections.emptyMap() : instance.formOptions);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B formField(FormField formField) {
            if (this.formFields == null) {
                this.formFields = new ArrayList();
            }
            this.formFields.add(formField);
            return (B)this.self();
        }

        @Generated
        public B formFields(Collection<? extends FormField> formFields) {
            if (formFields == null) {
                throw new NullPointerException("formFields cannot be null");
            }
            if (this.formFields == null) {
                this.formFields = new ArrayList();
            }
            this.formFields.addAll(formFields);
            return (B)this.self();
        }

        @Generated
        public B clearFormFields() {
            if (this.formFields != null) {
                this.formFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B formOption(String formOptionKey, String formOptionValue) {
            if (this.formOptions$key == null) {
                this.formOptions$key = new ArrayList();
                this.formOptions$value = new ArrayList();
            }
            this.formOptions$key.add(formOptionKey);
            this.formOptions$value.add(formOptionValue);
            return (B)this.self();
        }

        @Generated
        public B formOptions(Map<? extends String, ? extends String> formOptions) {
            if (formOptions == null) {
                throw new NullPointerException("formOptions cannot be null");
            }
            if (this.formOptions$key == null) {
                this.formOptions$key = new ArrayList();
                this.formOptions$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : formOptions.entrySet()) {
                this.formOptions$key.add($lombokEntry.getKey());
                this.formOptions$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearFormOptions() {
            if (this.formOptions$key != null) {
                this.formOptions$key.clear();
                this.formOptions$value.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Form.FormBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", formFields=" + String.valueOf(this.formFields) + ", formOptions$key=" + String.valueOf(this.formOptions$key) + ", formOptions$value=" + String.valueOf(this.formOptions$value) + ")";
        }
    }

    @Generated
    private static final class FormBuilderImpl
    extends FormBuilder<Form, FormBuilderImpl> {
        @Generated
        private FormBuilderImpl() {
        }

        @Override
        @Generated
        protected FormBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Form build() {
            return new Form(this);
        }
    }
}

