/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.ILooker;
import com.atlan.model.assets.ILookerDashboard;
import com.atlan.model.assets.ILookerFolder;
import com.atlan.model.assets.ILookerLook;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookerFolder
extends Asset
implements ILookerFolder,
ILooker,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LookerFolder.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerFolder";
    String typeName;
    @Attribute
    SortedSet<ILookerDashboard> dashboards;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    ILookerFolder lookerParentFolder;
    @Attribute
    String lookerSlug;
    @Attribute
    SortedSet<ILookerFolder> lookerSubFolders;
    @Attribute
    SortedSet<ILookerLook> looks;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    Integer sourceChildCount;
    @Attribute
    Integer sourceContentMetadataId;
    @Attribute
    Integer sourceCreatorId;
    @Attribute
    Integer sourceParentID;

    @Override
    public LookerFolder trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return LookerFolder.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return LookerFolder.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return LookerFolder.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return LookerFolder.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static LookerFolder refByGuid(String guid) {
        return LookerFolder.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static LookerFolder refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((LookerFolderBuilder)((LookerFolderBuilder)LookerFolder._internal().guid(guid)).semantic(semantic)).build();
    }

    public static LookerFolder refByQualifiedName(String qualifiedName) {
        return LookerFolder.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static LookerFolder refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((LookerFolderBuilder)((LookerFolderBuilder)LookerFolder._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static LookerFolder get(AtlanClient client, String id) throws AtlanException {
        return LookerFolder.get(client, id, false);
    }

    @JsonIgnore
    public static LookerFolder get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof LookerFolder) {
                return (LookerFolder)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof LookerFolder) {
            return (LookerFolder)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static LookerFolder get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return LookerFolder.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static LookerFolder get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)LookerFolder.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof LookerFolder) {
                return (LookerFolder)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)LookerFolder.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof LookerFolder) {
            return (LookerFolder)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static LookerFolderBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerFolderBuilder)((LookerFolderBuilder)((LookerFolderBuilder)LookerFolder._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public LookerFolderBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        LookerFolder.validateRequired(TYPE_NAME, map);
        return LookerFolder.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerFolder removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerFolder)Asset.removeDescription(client, LookerFolder.updater(qualifiedName, name));
    }

    public static LookerFolder removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerFolder)Asset.removeUserDescription(client, LookerFolder.updater(qualifiedName, name));
    }

    public static LookerFolder removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerFolder)Asset.removeOwners(client, LookerFolder.updater(qualifiedName, name));
    }

    public static LookerFolder updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LookerFolder)Asset.updateCertificate(client, LookerFolder._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerFolder removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerFolder)Asset.removeCertificate(client, LookerFolder.updater(qualifiedName, name));
    }

    public static LookerFolder updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerFolder)Asset.updateAnnouncement(client, LookerFolder._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerFolder removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerFolder)Asset.removeAnnouncement(client, LookerFolder.updater(qualifiedName, name));
    }

    public static LookerFolder replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerFolder)Asset.replaceTerms(client, LookerFolder.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static LookerFolder appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerFolder)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static LookerFolder removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerFolder)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static LookerFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LookerFolder)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static LookerFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LookerFolder)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerFolder(LookerFolderBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerFolder.$default$typeName();
        SortedSet<ILookerDashboard> dashboards = new TreeSet<ILookerDashboard>();
        if (b.dashboards != null) {
            dashboards.addAll(b.dashboards);
        }
        dashboards = Collections.unmodifiableSortedSet(dashboards);
        this.dashboards = dashboards;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.lookerParentFolder = b.lookerParentFolder;
        this.lookerSlug = b.lookerSlug;
        SortedSet<ILookerFolder> lookerSubFolders = new TreeSet<ILookerFolder>();
        if (b.lookerSubFolders != null) {
            lookerSubFolders.addAll(b.lookerSubFolders);
        }
        lookerSubFolders = Collections.unmodifiableSortedSet(lookerSubFolders);
        this.lookerSubFolders = lookerSubFolders;
        SortedSet<ILookerLook> looks = new TreeSet<ILookerLook>();
        if (b.looks != null) {
            looks.addAll(b.looks);
        }
        looks = Collections.unmodifiableSortedSet(looks);
        this.looks = looks;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.sourceChildCount = b.sourceChildCount;
        this.sourceContentMetadataId = b.sourceContentMetadataId;
        this.sourceCreatorId = b.sourceCreatorId;
        this.sourceParentID = b.sourceParentID;
    }

    @Generated
    public static LookerFolderBuilder<?, ?> _internal() {
        return new LookerFolderBuilderImpl();
    }

    @Generated
    public LookerFolderBuilder<?, ?> toBuilder() {
        return new LookerFolderBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<ILookerDashboard> getDashboards() {
        return this.dashboards;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public ILookerFolder getLookerParentFolder() {
        return this.lookerParentFolder;
    }

    @Override
    @Generated
    public String getLookerSlug() {
        return this.lookerSlug;
    }

    @Override
    @Generated
    public SortedSet<ILookerFolder> getLookerSubFolders() {
        return this.lookerSubFolders;
    }

    @Override
    @Generated
    public SortedSet<ILookerLook> getLooks() {
        return this.looks;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public Integer getSourceChildCount() {
        return this.sourceChildCount;
    }

    @Override
    @Generated
    public Integer getSourceContentMetadataId() {
        return this.sourceContentMetadataId;
    }

    @Override
    @Generated
    public Integer getSourceCreatorId() {
        return this.sourceCreatorId;
    }

    @Override
    @Generated
    public Integer getSourceParentID() {
        return this.sourceParentID;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerFolder)) {
            return false;
        }
        LookerFolder other = (LookerFolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$sourceChildCount = this.getSourceChildCount();
        Integer other$sourceChildCount = other.getSourceChildCount();
        if (this$sourceChildCount == null ? other$sourceChildCount != null : !((Object)this$sourceChildCount).equals(other$sourceChildCount)) {
            return false;
        }
        Integer this$sourceContentMetadataId = this.getSourceContentMetadataId();
        Integer other$sourceContentMetadataId = other.getSourceContentMetadataId();
        if (this$sourceContentMetadataId == null ? other$sourceContentMetadataId != null : !((Object)this$sourceContentMetadataId).equals(other$sourceContentMetadataId)) {
            return false;
        }
        Integer this$sourceCreatorId = this.getSourceCreatorId();
        Integer other$sourceCreatorId = other.getSourceCreatorId();
        if (this$sourceCreatorId == null ? other$sourceCreatorId != null : !((Object)this$sourceCreatorId).equals(other$sourceCreatorId)) {
            return false;
        }
        Integer this$sourceParentID = this.getSourceParentID();
        Integer other$sourceParentID = other.getSourceParentID();
        if (this$sourceParentID == null ? other$sourceParentID != null : !((Object)this$sourceParentID).equals(other$sourceParentID)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<ILookerDashboard> this$dashboards = this.getDashboards();
        SortedSet<ILookerDashboard> other$dashboards = other.getDashboards();
        if (this$dashboards == null ? other$dashboards != null : !this$dashboards.equals(other$dashboards)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        ILookerFolder this$lookerParentFolder = this.getLookerParentFolder();
        ILookerFolder other$lookerParentFolder = other.getLookerParentFolder();
        if (this$lookerParentFolder == null ? other$lookerParentFolder != null : !this$lookerParentFolder.equals(other$lookerParentFolder)) {
            return false;
        }
        String this$lookerSlug = this.getLookerSlug();
        String other$lookerSlug = other.getLookerSlug();
        if (this$lookerSlug == null ? other$lookerSlug != null : !this$lookerSlug.equals(other$lookerSlug)) {
            return false;
        }
        SortedSet<ILookerFolder> this$lookerSubFolders = this.getLookerSubFolders();
        SortedSet<ILookerFolder> other$lookerSubFolders = other.getLookerSubFolders();
        if (this$lookerSubFolders == null ? other$lookerSubFolders != null : !this$lookerSubFolders.equals(other$lookerSubFolders)) {
            return false;
        }
        SortedSet<ILookerLook> this$looks = this.getLooks();
        SortedSet<ILookerLook> other$looks = other.getLooks();
        if (this$looks == null ? other$looks != null : !this$looks.equals(other$looks)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerFolder;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $sourceChildCount = this.getSourceChildCount();
        result = result * 59 + ($sourceChildCount == null ? 43 : ((Object)$sourceChildCount).hashCode());
        Integer $sourceContentMetadataId = this.getSourceContentMetadataId();
        result = result * 59 + ($sourceContentMetadataId == null ? 43 : ((Object)$sourceContentMetadataId).hashCode());
        Integer $sourceCreatorId = this.getSourceCreatorId();
        result = result * 59 + ($sourceCreatorId == null ? 43 : ((Object)$sourceCreatorId).hashCode());
        Integer $sourceParentID = this.getSourceParentID();
        result = result * 59 + ($sourceParentID == null ? 43 : ((Object)$sourceParentID).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<ILookerDashboard> $dashboards = this.getDashboards();
        result = result * 59 + ($dashboards == null ? 43 : $dashboards.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        ILookerFolder $lookerParentFolder = this.getLookerParentFolder();
        result = result * 59 + ($lookerParentFolder == null ? 43 : $lookerParentFolder.hashCode());
        String $lookerSlug = this.getLookerSlug();
        result = result * 59 + ($lookerSlug == null ? 43 : $lookerSlug.hashCode());
        SortedSet<ILookerFolder> $lookerSubFolders = this.getLookerSubFolders();
        result = result * 59 + ($lookerSubFolders == null ? 43 : $lookerSubFolders.hashCode());
        SortedSet<ILookerLook> $looks = this.getLooks();
        result = result * 59 + ($looks == null ? 43 : $looks.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LookerFolder(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dashboards=" + String.valueOf(this.getDashboards()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", lookerParentFolder=" + String.valueOf(this.getLookerParentFolder()) + ", lookerSlug=" + this.getLookerSlug() + ", lookerSubFolders=" + String.valueOf(this.getLookerSubFolders()) + ", looks=" + String.valueOf(this.getLooks()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", sourceChildCount=" + this.getSourceChildCount() + ", sourceContentMetadataId=" + this.getSourceContentMetadataId() + ", sourceCreatorId=" + this.getSourceCreatorId() + ", sourceParentID=" + this.getSourceParentID() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class LookerFolderBuilder<C extends LookerFolder, B extends LookerFolderBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<ILookerDashboard> dashboards;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ILookerFolder lookerParentFolder;
        @Generated
        private String lookerSlug;
        @Generated
        private ArrayList<ILookerFolder> lookerSubFolders;
        @Generated
        private ArrayList<ILookerLook> looks;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private Integer sourceChildCount;
        @Generated
        private Integer sourceContentMetadataId;
        @Generated
        private Integer sourceCreatorId;
        @Generated
        private Integer sourceParentID;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerFolderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerFolder instance, LookerFolderBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dashboards(instance.dashboards == null ? Collections.emptySortedSet() : instance.dashboards);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.lookerParentFolder(instance.lookerParentFolder);
            b.lookerSlug(instance.lookerSlug);
            b.lookerSubFolders(instance.lookerSubFolders == null ? Collections.emptySortedSet() : instance.lookerSubFolders);
            b.looks(instance.looks == null ? Collections.emptySortedSet() : instance.looks);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.sourceChildCount(instance.sourceChildCount);
            b.sourceContentMetadataId(instance.sourceContentMetadataId);
            b.sourceCreatorId(instance.sourceCreatorId);
            b.sourceParentID(instance.sourceParentID);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dashboard(ILookerDashboard dashboard) {
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.add(dashboard);
            return (B)this.self();
        }

        @Generated
        public B dashboards(Collection<? extends ILookerDashboard> dashboards) {
            if (dashboards == null) {
                throw new NullPointerException("dashboards cannot be null");
            }
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.addAll(dashboards);
            return (B)this.self();
        }

        @Generated
        public B clearDashboards() {
            if (this.dashboards != null) {
                this.dashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B lookerParentFolder(ILookerFolder lookerParentFolder) {
            this.lookerParentFolder = lookerParentFolder;
            return (B)this.self();
        }

        @Generated
        public B lookerSlug(String lookerSlug) {
            this.lookerSlug = lookerSlug;
            return (B)this.self();
        }

        @Generated
        public B lookerSubFolder(ILookerFolder lookerSubFolder) {
            if (this.lookerSubFolders == null) {
                this.lookerSubFolders = new ArrayList();
            }
            this.lookerSubFolders.add(lookerSubFolder);
            return (B)this.self();
        }

        @Generated
        public B lookerSubFolders(Collection<? extends ILookerFolder> lookerSubFolders) {
            if (lookerSubFolders == null) {
                throw new NullPointerException("lookerSubFolders cannot be null");
            }
            if (this.lookerSubFolders == null) {
                this.lookerSubFolders = new ArrayList();
            }
            this.lookerSubFolders.addAll(lookerSubFolders);
            return (B)this.self();
        }

        @Generated
        public B clearLookerSubFolders() {
            if (this.lookerSubFolders != null) {
                this.lookerSubFolders.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B look(ILookerLook look) {
            if (this.looks == null) {
                this.looks = new ArrayList();
            }
            this.looks.add(look);
            return (B)this.self();
        }

        @Generated
        public B looks(Collection<? extends ILookerLook> looks) {
            if (looks == null) {
                throw new NullPointerException("looks cannot be null");
            }
            if (this.looks == null) {
                this.looks = new ArrayList();
            }
            this.looks.addAll(looks);
            return (B)this.self();
        }

        @Generated
        public B clearLooks() {
            if (this.looks != null) {
                this.looks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sourceChildCount(Integer sourceChildCount) {
            this.sourceChildCount = sourceChildCount;
            return (B)this.self();
        }

        @Generated
        public B sourceContentMetadataId(Integer sourceContentMetadataId) {
            this.sourceContentMetadataId = sourceContentMetadataId;
            return (B)this.self();
        }

        @Generated
        public B sourceCreatorId(Integer sourceCreatorId) {
            this.sourceCreatorId = sourceCreatorId;
            return (B)this.self();
        }

        @Generated
        public B sourceParentID(Integer sourceParentID) {
            this.sourceParentID = sourceParentID;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "LookerFolder.LookerFolderBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dashboards=" + String.valueOf(this.dashboards) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", lookerParentFolder=" + String.valueOf(this.lookerParentFolder) + ", lookerSlug=" + this.lookerSlug + ", lookerSubFolders=" + String.valueOf(this.lookerSubFolders) + ", looks=" + String.valueOf(this.looks) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", sourceChildCount=" + this.sourceChildCount + ", sourceContentMetadataId=" + this.sourceContentMetadataId + ", sourceCreatorId=" + this.sourceCreatorId + ", sourceParentID=" + this.sourceParentID + ")";
        }
    }

    @Generated
    private static final class LookerFolderBuilderImpl
    extends LookerFolderBuilder<LookerFolder, LookerFolderBuilderImpl> {
        @Generated
        private LookerFolderBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerFolderBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerFolder build() {
            return new LookerFolder(this);
        }
    }
}

