/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMetabase;
import com.atlan.model.assets.IMetabaseCollection;
import com.atlan.model.assets.IMetabaseDashboard;
import com.atlan.model.assets.IMetabaseQuestion;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetabaseCollection
extends Asset
implements IMetabaseCollection,
IMetabase,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetabaseCollection.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MetabaseCollection";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    String metabaseCollectionName;
    @Attribute
    String metabaseCollectionQualifiedName;
    @Attribute
    String metabaseColor;
    @Attribute
    SortedSet<IMetabaseDashboard> metabaseDashboards;
    @Attribute
    Boolean metabaseIsPersonalCollection;
    @Attribute
    String metabaseNamespace;
    @Attribute
    SortedSet<IMetabaseQuestion> metabaseQuestions;
    @Attribute
    String metabaseSlug;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public MetabaseCollection trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return MetabaseCollection.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return MetabaseCollection.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return MetabaseCollection.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return MetabaseCollection.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static MetabaseCollection refByGuid(String guid) {
        return MetabaseCollection.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static MetabaseCollection refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((MetabaseCollectionBuilder)((MetabaseCollectionBuilder)MetabaseCollection._internal().guid(guid)).semantic(semantic)).build();
    }

    public static MetabaseCollection refByQualifiedName(String qualifiedName) {
        return MetabaseCollection.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static MetabaseCollection refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((MetabaseCollectionBuilder)((MetabaseCollectionBuilder)MetabaseCollection._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static MetabaseCollection get(AtlanClient client, String id) throws AtlanException {
        return MetabaseCollection.get(client, id, false);
    }

    @JsonIgnore
    public static MetabaseCollection get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof MetabaseCollection) {
                return (MetabaseCollection)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof MetabaseCollection) {
            return (MetabaseCollection)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static MetabaseCollection get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return MetabaseCollection.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static MetabaseCollection get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)MetabaseCollection.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof MetabaseCollection) {
                return (MetabaseCollection)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)MetabaseCollection.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof MetabaseCollection) {
            return (MetabaseCollection)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static MetabaseCollectionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (MetabaseCollectionBuilder)((MetabaseCollectionBuilder)((MetabaseCollectionBuilder)MetabaseCollection._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public MetabaseCollectionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        MetabaseCollection.validateRequired(TYPE_NAME, map);
        return MetabaseCollection.updater(this.getQualifiedName(), this.getName());
    }

    public static MetabaseCollection removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection)Asset.removeDescription(client, MetabaseCollection.updater(qualifiedName, name));
    }

    public static MetabaseCollection removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection)Asset.removeUserDescription(client, MetabaseCollection.updater(qualifiedName, name));
    }

    public static MetabaseCollection removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection)Asset.removeOwners(client, MetabaseCollection.updater(qualifiedName, name));
    }

    public static MetabaseCollection updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MetabaseCollection)Asset.updateCertificate(client, MetabaseCollection._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static MetabaseCollection removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection)Asset.removeCertificate(client, MetabaseCollection.updater(qualifiedName, name));
    }

    public static MetabaseCollection updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MetabaseCollection)Asset.updateAnnouncement(client, MetabaseCollection._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static MetabaseCollection removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection)Asset.removeAnnouncement(client, MetabaseCollection.updater(qualifiedName, name));
    }

    public static MetabaseCollection replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MetabaseCollection)Asset.replaceTerms(client, MetabaseCollection.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static MetabaseCollection appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MetabaseCollection)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static MetabaseCollection removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MetabaseCollection)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static MetabaseCollection appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MetabaseCollection)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static MetabaseCollection appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MetabaseCollection)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected MetabaseCollection(MetabaseCollectionBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : MetabaseCollection.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.metabaseCollectionName = b.metabaseCollectionName;
        this.metabaseCollectionQualifiedName = b.metabaseCollectionQualifiedName;
        this.metabaseColor = b.metabaseColor;
        SortedSet<IMetabaseDashboard> metabaseDashboards = new TreeSet<IMetabaseDashboard>();
        if (b.metabaseDashboards != null) {
            metabaseDashboards.addAll(b.metabaseDashboards);
        }
        metabaseDashboards = Collections.unmodifiableSortedSet(metabaseDashboards);
        this.metabaseDashboards = metabaseDashboards;
        this.metabaseIsPersonalCollection = b.metabaseIsPersonalCollection;
        this.metabaseNamespace = b.metabaseNamespace;
        SortedSet<IMetabaseQuestion> metabaseQuestions = new TreeSet<IMetabaseQuestion>();
        if (b.metabaseQuestions != null) {
            metabaseQuestions.addAll(b.metabaseQuestions);
        }
        metabaseQuestions = Collections.unmodifiableSortedSet(metabaseQuestions);
        this.metabaseQuestions = metabaseQuestions;
        this.metabaseSlug = b.metabaseSlug;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static MetabaseCollectionBuilder<?, ?> _internal() {
        return new MetabaseCollectionBuilderImpl();
    }

    @Generated
    public MetabaseCollectionBuilder<?, ?> toBuilder() {
        return new MetabaseCollectionBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public String getMetabaseCollectionName() {
        return this.metabaseCollectionName;
    }

    @Override
    @Generated
    public String getMetabaseCollectionQualifiedName() {
        return this.metabaseCollectionQualifiedName;
    }

    @Override
    @Generated
    public String getMetabaseColor() {
        return this.metabaseColor;
    }

    @Override
    @Generated
    public SortedSet<IMetabaseDashboard> getMetabaseDashboards() {
        return this.metabaseDashboards;
    }

    @Override
    @Generated
    public Boolean getMetabaseIsPersonalCollection() {
        return this.metabaseIsPersonalCollection;
    }

    @Override
    @Generated
    public String getMetabaseNamespace() {
        return this.metabaseNamespace;
    }

    @Override
    @Generated
    public SortedSet<IMetabaseQuestion> getMetabaseQuestions() {
        return this.metabaseQuestions;
    }

    @Override
    @Generated
    public String getMetabaseSlug() {
        return this.metabaseSlug;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetabaseCollection)) {
            return false;
        }
        MetabaseCollection other = (MetabaseCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$metabaseIsPersonalCollection = this.getMetabaseIsPersonalCollection();
        Boolean other$metabaseIsPersonalCollection = other.getMetabaseIsPersonalCollection();
        if (this$metabaseIsPersonalCollection == null ? other$metabaseIsPersonalCollection != null : !((Object)this$metabaseIsPersonalCollection).equals(other$metabaseIsPersonalCollection)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        String this$metabaseCollectionName = this.getMetabaseCollectionName();
        String other$metabaseCollectionName = other.getMetabaseCollectionName();
        if (this$metabaseCollectionName == null ? other$metabaseCollectionName != null : !this$metabaseCollectionName.equals(other$metabaseCollectionName)) {
            return false;
        }
        String this$metabaseCollectionQualifiedName = this.getMetabaseCollectionQualifiedName();
        String other$metabaseCollectionQualifiedName = other.getMetabaseCollectionQualifiedName();
        if (this$metabaseCollectionQualifiedName == null ? other$metabaseCollectionQualifiedName != null : !this$metabaseCollectionQualifiedName.equals(other$metabaseCollectionQualifiedName)) {
            return false;
        }
        String this$metabaseColor = this.getMetabaseColor();
        String other$metabaseColor = other.getMetabaseColor();
        if (this$metabaseColor == null ? other$metabaseColor != null : !this$metabaseColor.equals(other$metabaseColor)) {
            return false;
        }
        SortedSet<IMetabaseDashboard> this$metabaseDashboards = this.getMetabaseDashboards();
        SortedSet<IMetabaseDashboard> other$metabaseDashboards = other.getMetabaseDashboards();
        if (this$metabaseDashboards == null ? other$metabaseDashboards != null : !this$metabaseDashboards.equals(other$metabaseDashboards)) {
            return false;
        }
        String this$metabaseNamespace = this.getMetabaseNamespace();
        String other$metabaseNamespace = other.getMetabaseNamespace();
        if (this$metabaseNamespace == null ? other$metabaseNamespace != null : !this$metabaseNamespace.equals(other$metabaseNamespace)) {
            return false;
        }
        SortedSet<IMetabaseQuestion> this$metabaseQuestions = this.getMetabaseQuestions();
        SortedSet<IMetabaseQuestion> other$metabaseQuestions = other.getMetabaseQuestions();
        if (this$metabaseQuestions == null ? other$metabaseQuestions != null : !this$metabaseQuestions.equals(other$metabaseQuestions)) {
            return false;
        }
        String this$metabaseSlug = this.getMetabaseSlug();
        String other$metabaseSlug = other.getMetabaseSlug();
        if (this$metabaseSlug == null ? other$metabaseSlug != null : !this$metabaseSlug.equals(other$metabaseSlug)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetabaseCollection;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $metabaseIsPersonalCollection = this.getMetabaseIsPersonalCollection();
        result = result * 59 + ($metabaseIsPersonalCollection == null ? 43 : ((Object)$metabaseIsPersonalCollection).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        String $metabaseCollectionName = this.getMetabaseCollectionName();
        result = result * 59 + ($metabaseCollectionName == null ? 43 : $metabaseCollectionName.hashCode());
        String $metabaseCollectionQualifiedName = this.getMetabaseCollectionQualifiedName();
        result = result * 59 + ($metabaseCollectionQualifiedName == null ? 43 : $metabaseCollectionQualifiedName.hashCode());
        String $metabaseColor = this.getMetabaseColor();
        result = result * 59 + ($metabaseColor == null ? 43 : $metabaseColor.hashCode());
        SortedSet<IMetabaseDashboard> $metabaseDashboards = this.getMetabaseDashboards();
        result = result * 59 + ($metabaseDashboards == null ? 43 : $metabaseDashboards.hashCode());
        String $metabaseNamespace = this.getMetabaseNamespace();
        result = result * 59 + ($metabaseNamespace == null ? 43 : $metabaseNamespace.hashCode());
        SortedSet<IMetabaseQuestion> $metabaseQuestions = this.getMetabaseQuestions();
        result = result * 59 + ($metabaseQuestions == null ? 43 : $metabaseQuestions.hashCode());
        String $metabaseSlug = this.getMetabaseSlug();
        result = result * 59 + ($metabaseSlug == null ? 43 : $metabaseSlug.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "MetabaseCollection(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", metabaseCollectionName=" + this.getMetabaseCollectionName() + ", metabaseCollectionQualifiedName=" + this.getMetabaseCollectionQualifiedName() + ", metabaseColor=" + this.getMetabaseColor() + ", metabaseDashboards=" + String.valueOf(this.getMetabaseDashboards()) + ", metabaseIsPersonalCollection=" + this.getMetabaseIsPersonalCollection() + ", metabaseNamespace=" + this.getMetabaseNamespace() + ", metabaseQuestions=" + String.valueOf(this.getMetabaseQuestions()) + ", metabaseSlug=" + this.getMetabaseSlug() + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class MetabaseCollectionBuilder<C extends MetabaseCollection, B extends MetabaseCollectionBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private String metabaseCollectionName;
        @Generated
        private String metabaseCollectionQualifiedName;
        @Generated
        private String metabaseColor;
        @Generated
        private ArrayList<IMetabaseDashboard> metabaseDashboards;
        @Generated
        private Boolean metabaseIsPersonalCollection;
        @Generated
        private String metabaseNamespace;
        @Generated
        private ArrayList<IMetabaseQuestion> metabaseQuestions;
        @Generated
        private String metabaseSlug;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MetabaseCollectionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MetabaseCollection instance, MetabaseCollectionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.metabaseCollectionName(instance.metabaseCollectionName);
            b.metabaseCollectionQualifiedName(instance.metabaseCollectionQualifiedName);
            b.metabaseColor(instance.metabaseColor);
            b.metabaseDashboards(instance.metabaseDashboards == null ? Collections.emptySortedSet() : instance.metabaseDashboards);
            b.metabaseIsPersonalCollection(instance.metabaseIsPersonalCollection);
            b.metabaseNamespace(instance.metabaseNamespace);
            b.metabaseQuestions(instance.metabaseQuestions == null ? Collections.emptySortedSet() : instance.metabaseQuestions);
            b.metabaseSlug(instance.metabaseSlug);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metabaseCollectionName(String metabaseCollectionName) {
            this.metabaseCollectionName = metabaseCollectionName;
            return (B)this.self();
        }

        @Generated
        public B metabaseCollectionQualifiedName(String metabaseCollectionQualifiedName) {
            this.metabaseCollectionQualifiedName = metabaseCollectionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B metabaseColor(String metabaseColor) {
            this.metabaseColor = metabaseColor;
            return (B)this.self();
        }

        @Generated
        public B metabaseDashboard(IMetabaseDashboard metabaseDashboard) {
            if (this.metabaseDashboards == null) {
                this.metabaseDashboards = new ArrayList();
            }
            this.metabaseDashboards.add(metabaseDashboard);
            return (B)this.self();
        }

        @Generated
        public B metabaseDashboards(Collection<? extends IMetabaseDashboard> metabaseDashboards) {
            if (metabaseDashboards == null) {
                throw new NullPointerException("metabaseDashboards cannot be null");
            }
            if (this.metabaseDashboards == null) {
                this.metabaseDashboards = new ArrayList();
            }
            this.metabaseDashboards.addAll(metabaseDashboards);
            return (B)this.self();
        }

        @Generated
        public B clearMetabaseDashboards() {
            if (this.metabaseDashboards != null) {
                this.metabaseDashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metabaseIsPersonalCollection(Boolean metabaseIsPersonalCollection) {
            this.metabaseIsPersonalCollection = metabaseIsPersonalCollection;
            return (B)this.self();
        }

        @Generated
        public B metabaseNamespace(String metabaseNamespace) {
            this.metabaseNamespace = metabaseNamespace;
            return (B)this.self();
        }

        @Generated
        public B metabaseQuestion(IMetabaseQuestion metabaseQuestion) {
            if (this.metabaseQuestions == null) {
                this.metabaseQuestions = new ArrayList();
            }
            this.metabaseQuestions.add(metabaseQuestion);
            return (B)this.self();
        }

        @Generated
        public B metabaseQuestions(Collection<? extends IMetabaseQuestion> metabaseQuestions) {
            if (metabaseQuestions == null) {
                throw new NullPointerException("metabaseQuestions cannot be null");
            }
            if (this.metabaseQuestions == null) {
                this.metabaseQuestions = new ArrayList();
            }
            this.metabaseQuestions.addAll(metabaseQuestions);
            return (B)this.self();
        }

        @Generated
        public B clearMetabaseQuestions() {
            if (this.metabaseQuestions != null) {
                this.metabaseQuestions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metabaseSlug(String metabaseSlug) {
            this.metabaseSlug = metabaseSlug;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "MetabaseCollection.MetabaseCollectionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", metabaseCollectionName=" + this.metabaseCollectionName + ", metabaseCollectionQualifiedName=" + this.metabaseCollectionQualifiedName + ", metabaseColor=" + this.metabaseColor + ", metabaseDashboards=" + String.valueOf(this.metabaseDashboards) + ", metabaseIsPersonalCollection=" + this.metabaseIsPersonalCollection + ", metabaseNamespace=" + this.metabaseNamespace + ", metabaseQuestions=" + String.valueOf(this.metabaseQuestions) + ", metabaseSlug=" + this.metabaseSlug + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class MetabaseCollectionBuilderImpl
    extends MetabaseCollectionBuilder<MetabaseCollection, MetabaseCollectionBuilderImpl> {
        @Generated
        private MetabaseCollectionBuilderImpl() {
        }

        @Override
        @Generated
        protected MetabaseCollectionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MetabaseCollection build() {
            return new MetabaseCollection(this);
        }
    }
}

