/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.IResponse;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.ResponseValue;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response
extends Asset
implements IResponse,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Response.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Response";
    String typeName;
    @Attribute
    String formGuid;
    @Attribute
    Map<String, String> responseOptions;
    @Attribute
    List<ResponseValue> responseValues;

    @Override
    public Response trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return Response.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return Response.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return Response.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return Response.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static Response refByGuid(String guid) {
        return Response.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static Response refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((ResponseBuilder)((ResponseBuilder)Response._internal().guid(guid)).semantic(semantic)).build();
    }

    public static Response refByQualifiedName(String qualifiedName) {
        return Response.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static Response refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((ResponseBuilder)((ResponseBuilder)Response._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static Response get(AtlanClient client, String id) throws AtlanException {
        return Response.get(client, id, false);
    }

    @JsonIgnore
    public static Response get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof Response) {
                return (Response)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof Response) {
            return (Response)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static Response get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return Response.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static Response get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Response.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof Response) {
                return (Response)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Response.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof Response) {
            return (Response)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ResponseBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ResponseBuilder)((ResponseBuilder)((ResponseBuilder)Response._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ResponseBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        Response.validateRequired(TYPE_NAME, map);
        return Response.updater(this.getQualifiedName(), this.getName());
    }

    public static Response removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Response)Asset.removeDescription(client, Response.updater(qualifiedName, name));
    }

    public static Response removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Response)Asset.removeUserDescription(client, Response.updater(qualifiedName, name));
    }

    public static Response removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Response)Asset.removeOwners(client, Response.updater(qualifiedName, name));
    }

    public static Response updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (Response)Asset.updateCertificate(client, Response._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Response removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Response)Asset.removeCertificate(client, Response.updater(qualifiedName, name));
    }

    public static Response updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Response)Asset.updateAnnouncement(client, Response._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Response removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Response)Asset.removeAnnouncement(client, Response.updater(qualifiedName, name));
    }

    public static Response replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (Response)Asset.replaceTerms(client, Response.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static Response appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Response)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static Response removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Response)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static Response appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Response)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static Response appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Response)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Response(ResponseBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> responseOptions;
        this.typeName = b.typeName$set ? b.typeName$value : Response.$default$typeName();
        this.formGuid = b.formGuid;
        switch (b.responseOptions$key == null ? 0 : b.responseOptions$key.size()) {
            case 0: {
                responseOptions = Collections.emptyMap();
                break;
            }
            case 1: {
                responseOptions = Collections.singletonMap(b.responseOptions$key.get(0), b.responseOptions$value.get(0));
                break;
            }
            default: {
                responseOptions = new LinkedHashMap(b.responseOptions$key.size() < 0x40000000 ? 1 + b.responseOptions$key.size() + (b.responseOptions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.responseOptions$key.size(); ++$i) {
                    responseOptions.put(b.responseOptions$key.get($i), b.responseOptions$value.get($i));
                }
                responseOptions = Collections.unmodifiableMap(responseOptions);
            }
        }
        this.responseOptions = responseOptions;
        this.responseValues = switch (b.responseValues == null ? 0 : b.responseValues.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.responseValues.get(0));
            default -> Collections.unmodifiableList(new ArrayList<ResponseValue>(b.responseValues));
        };
    }

    @Generated
    public static ResponseBuilder<?, ?> _internal() {
        return new ResponseBuilderImpl();
    }

    @Generated
    public ResponseBuilder<?, ?> toBuilder() {
        return new ResponseBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getFormGuid() {
        return this.formGuid;
    }

    @Override
    @Generated
    public Map<String, String> getResponseOptions() {
        return this.responseOptions;
    }

    @Override
    @Generated
    public List<ResponseValue> getResponseValues() {
        return this.responseValues;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$formGuid = this.getFormGuid();
        String other$formGuid = other.getFormGuid();
        if (this$formGuid == null ? other$formGuid != null : !this$formGuid.equals(other$formGuid)) {
            return false;
        }
        Map<String, String> this$responseOptions = this.getResponseOptions();
        Map<String, String> other$responseOptions = other.getResponseOptions();
        if (this$responseOptions == null ? other$responseOptions != null : !((Object)this$responseOptions).equals(other$responseOptions)) {
            return false;
        }
        List<ResponseValue> this$responseValues = this.getResponseValues();
        List<ResponseValue> other$responseValues = other.getResponseValues();
        return !(this$responseValues == null ? other$responseValues != null : !((Object)this$responseValues).equals(other$responseValues));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $formGuid = this.getFormGuid();
        result = result * 59 + ($formGuid == null ? 43 : $formGuid.hashCode());
        Map<String, String> $responseOptions = this.getResponseOptions();
        result = result * 59 + ($responseOptions == null ? 43 : ((Object)$responseOptions).hashCode());
        List<ResponseValue> $responseValues = this.getResponseValues();
        result = result * 59 + ($responseValues == null ? 43 : ((Object)$responseValues).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Response(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", formGuid=" + this.getFormGuid() + ", responseOptions=" + String.valueOf(this.getResponseOptions()) + ", responseValues=" + String.valueOf(this.getResponseValues()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class ResponseBuilder<C extends Response, B extends ResponseBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String formGuid;
        @Generated
        private ArrayList<String> responseOptions$key;
        @Generated
        private ArrayList<String> responseOptions$value;
        @Generated
        private ArrayList<ResponseValue> responseValues;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Response instance, ResponseBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.formGuid(instance.formGuid);
            b.responseOptions(instance.responseOptions == null ? Collections.emptyMap() : instance.responseOptions);
            b.responseValues(instance.responseValues == null ? Collections.emptyList() : instance.responseValues);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B formGuid(String formGuid) {
            this.formGuid = formGuid;
            return (B)this.self();
        }

        @Generated
        public B responseOption(String responseOptionKey, String responseOptionValue) {
            if (this.responseOptions$key == null) {
                this.responseOptions$key = new ArrayList();
                this.responseOptions$value = new ArrayList();
            }
            this.responseOptions$key.add(responseOptionKey);
            this.responseOptions$value.add(responseOptionValue);
            return (B)this.self();
        }

        @Generated
        public B responseOptions(Map<? extends String, ? extends String> responseOptions) {
            if (responseOptions == null) {
                throw new NullPointerException("responseOptions cannot be null");
            }
            if (this.responseOptions$key == null) {
                this.responseOptions$key = new ArrayList();
                this.responseOptions$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : responseOptions.entrySet()) {
                this.responseOptions$key.add($lombokEntry.getKey());
                this.responseOptions$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearResponseOptions() {
            if (this.responseOptions$key != null) {
                this.responseOptions$key.clear();
                this.responseOptions$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B responseValue(ResponseValue responseValue) {
            if (this.responseValues == null) {
                this.responseValues = new ArrayList();
            }
            this.responseValues.add(responseValue);
            return (B)this.self();
        }

        @Generated
        public B responseValues(Collection<? extends ResponseValue> responseValues) {
            if (responseValues == null) {
                throw new NullPointerException("responseValues cannot be null");
            }
            if (this.responseValues == null) {
                this.responseValues = new ArrayList();
            }
            this.responseValues.addAll(responseValues);
            return (B)this.self();
        }

        @Generated
        public B clearResponseValues() {
            if (this.responseValues != null) {
                this.responseValues.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Response.ResponseBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", formGuid=" + this.formGuid + ", responseOptions$key=" + String.valueOf(this.responseOptions$key) + ", responseOptions$value=" + String.valueOf(this.responseOptions$value) + ", responseValues=" + String.valueOf(this.responseValues) + ")";
        }
    }

    @Generated
    private static final class ResponseBuilderImpl
    extends ResponseBuilder<Response, ResponseBuilderImpl> {
        @Generated
        private ResponseBuilderImpl() {
        }

        @Override
        @Generated
        protected ResponseBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Response build() {
            return new Response(this);
        }
    }
}

