/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISAP;
import com.atlan.model.assets.ISapErpAbapProgram;
import com.atlan.model.assets.ISapErpComponent;
import com.atlan.model.assets.ISapErpFunctionModule;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapErpFunctionModule
extends Asset
implements ISapErpFunctionModule,
ISAP,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SapErpFunctionModule.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SapErpFunctionModule";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    String sapComponentName;
    @Attribute
    String sapDataType;
    @Attribute
    ISapErpAbapProgram sapErpAbapProgram;
    @Attribute
    ISapErpComponent sapErpComponent;
    @Attribute
    List<Map<String, String>> sapErpFunctionExceptionList;
    @Attribute
    Long sapErpFunctionExceptionListCount;
    @Attribute
    List<Map<String, String>> sapErpFunctionModuleExportParams;
    @Attribute
    Long sapErpFunctionModuleExportParamsCount;
    @Attribute
    String sapErpFunctionModuleGroup;
    @Attribute
    List<Map<String, String>> sapErpFunctionModuleImportParams;
    @Attribute
    Long sapErpFunctionModuleImportParamsCount;
    @Attribute
    Long sapFieldCount;
    @Attribute
    Integer sapFieldOrder;
    @Attribute
    String sapLogicalName;
    @Attribute
    String sapPackageName;
    @Attribute
    String sapTechnicalName;

    @Override
    public SapErpFunctionModule trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SapErpFunctionModule.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SapErpFunctionModule.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SapErpFunctionModule.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SapErpFunctionModule.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static SapErpFunctionModule refByGuid(String guid) {
        return SapErpFunctionModule.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static SapErpFunctionModule refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((SapErpFunctionModuleBuilder)((SapErpFunctionModuleBuilder)SapErpFunctionModule._internal().guid(guid)).semantic(semantic)).build();
    }

    public static SapErpFunctionModule refByQualifiedName(String qualifiedName) {
        return SapErpFunctionModule.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static SapErpFunctionModule refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((SapErpFunctionModuleBuilder)((SapErpFunctionModuleBuilder)SapErpFunctionModule._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static SapErpFunctionModule get(AtlanClient client, String id) throws AtlanException {
        return SapErpFunctionModule.get(client, id, false);
    }

    @JsonIgnore
    public static SapErpFunctionModule get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SapErpFunctionModule) {
                return (SapErpFunctionModule)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof SapErpFunctionModule) {
            return (SapErpFunctionModule)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static SapErpFunctionModule get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return SapErpFunctionModule.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static SapErpFunctionModule get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)SapErpFunctionModule.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof SapErpFunctionModule) {
                return (SapErpFunctionModule)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)SapErpFunctionModule.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof SapErpFunctionModule) {
            return (SapErpFunctionModule)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SapErpFunctionModuleBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SapErpFunctionModuleBuilder)((SapErpFunctionModuleBuilder)((SapErpFunctionModuleBuilder)SapErpFunctionModule._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SapErpFunctionModuleBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        SapErpFunctionModule.validateRequired(TYPE_NAME, map);
        return SapErpFunctionModule.updater(this.getQualifiedName(), this.getName());
    }

    public static SapErpFunctionModule removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SapErpFunctionModule)Asset.removeDescription(client, SapErpFunctionModule.updater(qualifiedName, name));
    }

    public static SapErpFunctionModule removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SapErpFunctionModule)Asset.removeUserDescription(client, SapErpFunctionModule.updater(qualifiedName, name));
    }

    public static SapErpFunctionModule removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SapErpFunctionModule)Asset.removeOwners(client, SapErpFunctionModule.updater(qualifiedName, name));
    }

    public static SapErpFunctionModule updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SapErpFunctionModule)Asset.updateCertificate(client, SapErpFunctionModule._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SapErpFunctionModule removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SapErpFunctionModule)Asset.removeCertificate(client, SapErpFunctionModule.updater(qualifiedName, name));
    }

    public static SapErpFunctionModule updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SapErpFunctionModule)Asset.updateAnnouncement(client, SapErpFunctionModule._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SapErpFunctionModule removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SapErpFunctionModule)Asset.removeAnnouncement(client, SapErpFunctionModule.updater(qualifiedName, name));
    }

    public static SapErpFunctionModule replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SapErpFunctionModule)Asset.replaceTerms(client, SapErpFunctionModule.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static SapErpFunctionModule appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SapErpFunctionModule)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static SapErpFunctionModule removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SapErpFunctionModule)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static SapErpFunctionModule appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SapErpFunctionModule)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static SapErpFunctionModule appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SapErpFunctionModule)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SapErpFunctionModule(SapErpFunctionModuleBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SapErpFunctionModule.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.sapComponentName = b.sapComponentName;
        this.sapDataType = b.sapDataType;
        this.sapErpAbapProgram = b.sapErpAbapProgram;
        this.sapErpComponent = b.sapErpComponent;
        this.sapErpFunctionExceptionList = switch (b.sapErpFunctionExceptionList == null ? 0 : b.sapErpFunctionExceptionList.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.sapErpFunctionExceptionList.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.sapErpFunctionExceptionList));
        };
        this.sapErpFunctionExceptionListCount = b.sapErpFunctionExceptionListCount;
        this.sapErpFunctionModuleExportParams = switch (b.sapErpFunctionModuleExportParams == null ? 0 : b.sapErpFunctionModuleExportParams.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.sapErpFunctionModuleExportParams.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.sapErpFunctionModuleExportParams));
        };
        this.sapErpFunctionModuleExportParamsCount = b.sapErpFunctionModuleExportParamsCount;
        this.sapErpFunctionModuleGroup = b.sapErpFunctionModuleGroup;
        this.sapErpFunctionModuleImportParams = switch (b.sapErpFunctionModuleImportParams == null ? 0 : b.sapErpFunctionModuleImportParams.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.sapErpFunctionModuleImportParams.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.sapErpFunctionModuleImportParams));
        };
        this.sapErpFunctionModuleImportParamsCount = b.sapErpFunctionModuleImportParamsCount;
        this.sapFieldCount = b.sapFieldCount;
        this.sapFieldOrder = b.sapFieldOrder;
        this.sapLogicalName = b.sapLogicalName;
        this.sapPackageName = b.sapPackageName;
        this.sapTechnicalName = b.sapTechnicalName;
    }

    @Generated
    public static SapErpFunctionModuleBuilder<?, ?> _internal() {
        return new SapErpFunctionModuleBuilderImpl();
    }

    @Generated
    public SapErpFunctionModuleBuilder<?, ?> toBuilder() {
        return new SapErpFunctionModuleBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public String getSapComponentName() {
        return this.sapComponentName;
    }

    @Override
    @Generated
    public String getSapDataType() {
        return this.sapDataType;
    }

    @Override
    @Generated
    public ISapErpAbapProgram getSapErpAbapProgram() {
        return this.sapErpAbapProgram;
    }

    @Override
    @Generated
    public ISapErpComponent getSapErpComponent() {
        return this.sapErpComponent;
    }

    @Override
    @Generated
    public List<Map<String, String>> getSapErpFunctionExceptionList() {
        return this.sapErpFunctionExceptionList;
    }

    @Override
    @Generated
    public Long getSapErpFunctionExceptionListCount() {
        return this.sapErpFunctionExceptionListCount;
    }

    @Override
    @Generated
    public List<Map<String, String>> getSapErpFunctionModuleExportParams() {
        return this.sapErpFunctionModuleExportParams;
    }

    @Override
    @Generated
    public Long getSapErpFunctionModuleExportParamsCount() {
        return this.sapErpFunctionModuleExportParamsCount;
    }

    @Override
    @Generated
    public String getSapErpFunctionModuleGroup() {
        return this.sapErpFunctionModuleGroup;
    }

    @Override
    @Generated
    public List<Map<String, String>> getSapErpFunctionModuleImportParams() {
        return this.sapErpFunctionModuleImportParams;
    }

    @Override
    @Generated
    public Long getSapErpFunctionModuleImportParamsCount() {
        return this.sapErpFunctionModuleImportParamsCount;
    }

    @Override
    @Generated
    public Long getSapFieldCount() {
        return this.sapFieldCount;
    }

    @Override
    @Generated
    public Integer getSapFieldOrder() {
        return this.sapFieldOrder;
    }

    @Override
    @Generated
    public String getSapLogicalName() {
        return this.sapLogicalName;
    }

    @Override
    @Generated
    public String getSapPackageName() {
        return this.sapPackageName;
    }

    @Override
    @Generated
    public String getSapTechnicalName() {
        return this.sapTechnicalName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SapErpFunctionModule)) {
            return false;
        }
        SapErpFunctionModule other = (SapErpFunctionModule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$sapErpFunctionExceptionListCount = this.getSapErpFunctionExceptionListCount();
        Long other$sapErpFunctionExceptionListCount = other.getSapErpFunctionExceptionListCount();
        if (this$sapErpFunctionExceptionListCount == null ? other$sapErpFunctionExceptionListCount != null : !((Object)this$sapErpFunctionExceptionListCount).equals(other$sapErpFunctionExceptionListCount)) {
            return false;
        }
        Long this$sapErpFunctionModuleExportParamsCount = this.getSapErpFunctionModuleExportParamsCount();
        Long other$sapErpFunctionModuleExportParamsCount = other.getSapErpFunctionModuleExportParamsCount();
        if (this$sapErpFunctionModuleExportParamsCount == null ? other$sapErpFunctionModuleExportParamsCount != null : !((Object)this$sapErpFunctionModuleExportParamsCount).equals(other$sapErpFunctionModuleExportParamsCount)) {
            return false;
        }
        Long this$sapErpFunctionModuleImportParamsCount = this.getSapErpFunctionModuleImportParamsCount();
        Long other$sapErpFunctionModuleImportParamsCount = other.getSapErpFunctionModuleImportParamsCount();
        if (this$sapErpFunctionModuleImportParamsCount == null ? other$sapErpFunctionModuleImportParamsCount != null : !((Object)this$sapErpFunctionModuleImportParamsCount).equals(other$sapErpFunctionModuleImportParamsCount)) {
            return false;
        }
        Long this$sapFieldCount = this.getSapFieldCount();
        Long other$sapFieldCount = other.getSapFieldCount();
        if (this$sapFieldCount == null ? other$sapFieldCount != null : !((Object)this$sapFieldCount).equals(other$sapFieldCount)) {
            return false;
        }
        Integer this$sapFieldOrder = this.getSapFieldOrder();
        Integer other$sapFieldOrder = other.getSapFieldOrder();
        if (this$sapFieldOrder == null ? other$sapFieldOrder != null : !((Object)this$sapFieldOrder).equals(other$sapFieldOrder)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$sapComponentName = this.getSapComponentName();
        String other$sapComponentName = other.getSapComponentName();
        if (this$sapComponentName == null ? other$sapComponentName != null : !this$sapComponentName.equals(other$sapComponentName)) {
            return false;
        }
        String this$sapDataType = this.getSapDataType();
        String other$sapDataType = other.getSapDataType();
        if (this$sapDataType == null ? other$sapDataType != null : !this$sapDataType.equals(other$sapDataType)) {
            return false;
        }
        ISapErpAbapProgram this$sapErpAbapProgram = this.getSapErpAbapProgram();
        ISapErpAbapProgram other$sapErpAbapProgram = other.getSapErpAbapProgram();
        if (this$sapErpAbapProgram == null ? other$sapErpAbapProgram != null : !this$sapErpAbapProgram.equals(other$sapErpAbapProgram)) {
            return false;
        }
        ISapErpComponent this$sapErpComponent = this.getSapErpComponent();
        ISapErpComponent other$sapErpComponent = other.getSapErpComponent();
        if (this$sapErpComponent == null ? other$sapErpComponent != null : !this$sapErpComponent.equals(other$sapErpComponent)) {
            return false;
        }
        List<Map<String, String>> this$sapErpFunctionExceptionList = this.getSapErpFunctionExceptionList();
        List<Map<String, String>> other$sapErpFunctionExceptionList = other.getSapErpFunctionExceptionList();
        if (this$sapErpFunctionExceptionList == null ? other$sapErpFunctionExceptionList != null : !((Object)this$sapErpFunctionExceptionList).equals(other$sapErpFunctionExceptionList)) {
            return false;
        }
        List<Map<String, String>> this$sapErpFunctionModuleExportParams = this.getSapErpFunctionModuleExportParams();
        List<Map<String, String>> other$sapErpFunctionModuleExportParams = other.getSapErpFunctionModuleExportParams();
        if (this$sapErpFunctionModuleExportParams == null ? other$sapErpFunctionModuleExportParams != null : !((Object)this$sapErpFunctionModuleExportParams).equals(other$sapErpFunctionModuleExportParams)) {
            return false;
        }
        String this$sapErpFunctionModuleGroup = this.getSapErpFunctionModuleGroup();
        String other$sapErpFunctionModuleGroup = other.getSapErpFunctionModuleGroup();
        if (this$sapErpFunctionModuleGroup == null ? other$sapErpFunctionModuleGroup != null : !this$sapErpFunctionModuleGroup.equals(other$sapErpFunctionModuleGroup)) {
            return false;
        }
        List<Map<String, String>> this$sapErpFunctionModuleImportParams = this.getSapErpFunctionModuleImportParams();
        List<Map<String, String>> other$sapErpFunctionModuleImportParams = other.getSapErpFunctionModuleImportParams();
        if (this$sapErpFunctionModuleImportParams == null ? other$sapErpFunctionModuleImportParams != null : !((Object)this$sapErpFunctionModuleImportParams).equals(other$sapErpFunctionModuleImportParams)) {
            return false;
        }
        String this$sapLogicalName = this.getSapLogicalName();
        String other$sapLogicalName = other.getSapLogicalName();
        if (this$sapLogicalName == null ? other$sapLogicalName != null : !this$sapLogicalName.equals(other$sapLogicalName)) {
            return false;
        }
        String this$sapPackageName = this.getSapPackageName();
        String other$sapPackageName = other.getSapPackageName();
        if (this$sapPackageName == null ? other$sapPackageName != null : !this$sapPackageName.equals(other$sapPackageName)) {
            return false;
        }
        String this$sapTechnicalName = this.getSapTechnicalName();
        String other$sapTechnicalName = other.getSapTechnicalName();
        return !(this$sapTechnicalName == null ? other$sapTechnicalName != null : !this$sapTechnicalName.equals(other$sapTechnicalName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SapErpFunctionModule;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $sapErpFunctionExceptionListCount = this.getSapErpFunctionExceptionListCount();
        result = result * 59 + ($sapErpFunctionExceptionListCount == null ? 43 : ((Object)$sapErpFunctionExceptionListCount).hashCode());
        Long $sapErpFunctionModuleExportParamsCount = this.getSapErpFunctionModuleExportParamsCount();
        result = result * 59 + ($sapErpFunctionModuleExportParamsCount == null ? 43 : ((Object)$sapErpFunctionModuleExportParamsCount).hashCode());
        Long $sapErpFunctionModuleImportParamsCount = this.getSapErpFunctionModuleImportParamsCount();
        result = result * 59 + ($sapErpFunctionModuleImportParamsCount == null ? 43 : ((Object)$sapErpFunctionModuleImportParamsCount).hashCode());
        Long $sapFieldCount = this.getSapFieldCount();
        result = result * 59 + ($sapFieldCount == null ? 43 : ((Object)$sapFieldCount).hashCode());
        Integer $sapFieldOrder = this.getSapFieldOrder();
        result = result * 59 + ($sapFieldOrder == null ? 43 : ((Object)$sapFieldOrder).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $sapComponentName = this.getSapComponentName();
        result = result * 59 + ($sapComponentName == null ? 43 : $sapComponentName.hashCode());
        String $sapDataType = this.getSapDataType();
        result = result * 59 + ($sapDataType == null ? 43 : $sapDataType.hashCode());
        ISapErpAbapProgram $sapErpAbapProgram = this.getSapErpAbapProgram();
        result = result * 59 + ($sapErpAbapProgram == null ? 43 : $sapErpAbapProgram.hashCode());
        ISapErpComponent $sapErpComponent = this.getSapErpComponent();
        result = result * 59 + ($sapErpComponent == null ? 43 : $sapErpComponent.hashCode());
        List<Map<String, String>> $sapErpFunctionExceptionList = this.getSapErpFunctionExceptionList();
        result = result * 59 + ($sapErpFunctionExceptionList == null ? 43 : ((Object)$sapErpFunctionExceptionList).hashCode());
        List<Map<String, String>> $sapErpFunctionModuleExportParams = this.getSapErpFunctionModuleExportParams();
        result = result * 59 + ($sapErpFunctionModuleExportParams == null ? 43 : ((Object)$sapErpFunctionModuleExportParams).hashCode());
        String $sapErpFunctionModuleGroup = this.getSapErpFunctionModuleGroup();
        result = result * 59 + ($sapErpFunctionModuleGroup == null ? 43 : $sapErpFunctionModuleGroup.hashCode());
        List<Map<String, String>> $sapErpFunctionModuleImportParams = this.getSapErpFunctionModuleImportParams();
        result = result * 59 + ($sapErpFunctionModuleImportParams == null ? 43 : ((Object)$sapErpFunctionModuleImportParams).hashCode());
        String $sapLogicalName = this.getSapLogicalName();
        result = result * 59 + ($sapLogicalName == null ? 43 : $sapLogicalName.hashCode());
        String $sapPackageName = this.getSapPackageName();
        result = result * 59 + ($sapPackageName == null ? 43 : $sapPackageName.hashCode());
        String $sapTechnicalName = this.getSapTechnicalName();
        result = result * 59 + ($sapTechnicalName == null ? 43 : $sapTechnicalName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SapErpFunctionModule(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", sapComponentName=" + this.getSapComponentName() + ", sapDataType=" + this.getSapDataType() + ", sapErpAbapProgram=" + String.valueOf(this.getSapErpAbapProgram()) + ", sapErpComponent=" + String.valueOf(this.getSapErpComponent()) + ", sapErpFunctionExceptionList=" + String.valueOf(this.getSapErpFunctionExceptionList()) + ", sapErpFunctionExceptionListCount=" + this.getSapErpFunctionExceptionListCount() + ", sapErpFunctionModuleExportParams=" + String.valueOf(this.getSapErpFunctionModuleExportParams()) + ", sapErpFunctionModuleExportParamsCount=" + this.getSapErpFunctionModuleExportParamsCount() + ", sapErpFunctionModuleGroup=" + this.getSapErpFunctionModuleGroup() + ", sapErpFunctionModuleImportParams=" + String.valueOf(this.getSapErpFunctionModuleImportParams()) + ", sapErpFunctionModuleImportParamsCount=" + this.getSapErpFunctionModuleImportParamsCount() + ", sapFieldCount=" + this.getSapFieldCount() + ", sapFieldOrder=" + this.getSapFieldOrder() + ", sapLogicalName=" + this.getSapLogicalName() + ", sapPackageName=" + this.getSapPackageName() + ", sapTechnicalName=" + this.getSapTechnicalName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class SapErpFunctionModuleBuilder<C extends SapErpFunctionModule, B extends SapErpFunctionModuleBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private String sapComponentName;
        @Generated
        private String sapDataType;
        @Generated
        private ISapErpAbapProgram sapErpAbapProgram;
        @Generated
        private ISapErpComponent sapErpComponent;
        @Generated
        private ArrayList<Map<String, String>> sapErpFunctionExceptionList;
        @Generated
        private Long sapErpFunctionExceptionListCount;
        @Generated
        private ArrayList<Map<String, String>> sapErpFunctionModuleExportParams;
        @Generated
        private Long sapErpFunctionModuleExportParamsCount;
        @Generated
        private String sapErpFunctionModuleGroup;
        @Generated
        private ArrayList<Map<String, String>> sapErpFunctionModuleImportParams;
        @Generated
        private Long sapErpFunctionModuleImportParamsCount;
        @Generated
        private Long sapFieldCount;
        @Generated
        private Integer sapFieldOrder;
        @Generated
        private String sapLogicalName;
        @Generated
        private String sapPackageName;
        @Generated
        private String sapTechnicalName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SapErpFunctionModuleBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SapErpFunctionModule instance, SapErpFunctionModuleBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.sapComponentName(instance.sapComponentName);
            b.sapDataType(instance.sapDataType);
            b.sapErpAbapProgram(instance.sapErpAbapProgram);
            b.sapErpComponent(instance.sapErpComponent);
            b.sapErpFunctionExceptionList(instance.sapErpFunctionExceptionList == null ? Collections.emptyList() : instance.sapErpFunctionExceptionList);
            b.sapErpFunctionExceptionListCount(instance.sapErpFunctionExceptionListCount);
            b.sapErpFunctionModuleExportParams(instance.sapErpFunctionModuleExportParams == null ? Collections.emptyList() : instance.sapErpFunctionModuleExportParams);
            b.sapErpFunctionModuleExportParamsCount(instance.sapErpFunctionModuleExportParamsCount);
            b.sapErpFunctionModuleGroup(instance.sapErpFunctionModuleGroup);
            b.sapErpFunctionModuleImportParams(instance.sapErpFunctionModuleImportParams == null ? Collections.emptyList() : instance.sapErpFunctionModuleImportParams);
            b.sapErpFunctionModuleImportParamsCount(instance.sapErpFunctionModuleImportParamsCount);
            b.sapFieldCount(instance.sapFieldCount);
            b.sapFieldOrder(instance.sapFieldOrder);
            b.sapLogicalName(instance.sapLogicalName);
            b.sapPackageName(instance.sapPackageName);
            b.sapTechnicalName(instance.sapTechnicalName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sapComponentName(String sapComponentName) {
            this.sapComponentName = sapComponentName;
            return (B)this.self();
        }

        @Generated
        public B sapDataType(String sapDataType) {
            this.sapDataType = sapDataType;
            return (B)this.self();
        }

        @Generated
        public B sapErpAbapProgram(ISapErpAbapProgram sapErpAbapProgram) {
            this.sapErpAbapProgram = sapErpAbapProgram;
            return (B)this.self();
        }

        @Generated
        public B sapErpComponent(ISapErpComponent sapErpComponent) {
            this.sapErpComponent = sapErpComponent;
            return (B)this.self();
        }

        @Generated
        public B sapErpFunctionException(Map<String, String> sapErpFunctionException) {
            if (this.sapErpFunctionExceptionList == null) {
                this.sapErpFunctionExceptionList = new ArrayList();
            }
            this.sapErpFunctionExceptionList.add(sapErpFunctionException);
            return (B)this.self();
        }

        @Generated
        public B sapErpFunctionExceptionList(Collection<? extends Map<String, String>> sapErpFunctionExceptionList) {
            if (sapErpFunctionExceptionList == null) {
                throw new NullPointerException("sapErpFunctionExceptionList cannot be null");
            }
            if (this.sapErpFunctionExceptionList == null) {
                this.sapErpFunctionExceptionList = new ArrayList();
            }
            this.sapErpFunctionExceptionList.addAll(sapErpFunctionExceptionList);
            return (B)this.self();
        }

        @Generated
        public B clearSapErpFunctionExceptionList() {
            if (this.sapErpFunctionExceptionList != null) {
                this.sapErpFunctionExceptionList.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sapErpFunctionExceptionListCount(Long sapErpFunctionExceptionListCount) {
            this.sapErpFunctionExceptionListCount = sapErpFunctionExceptionListCount;
            return (B)this.self();
        }

        @Generated
        public B sapErpFunctionModuleExportParam(Map<String, String> sapErpFunctionModuleExportParam) {
            if (this.sapErpFunctionModuleExportParams == null) {
                this.sapErpFunctionModuleExportParams = new ArrayList();
            }
            this.sapErpFunctionModuleExportParams.add(sapErpFunctionModuleExportParam);
            return (B)this.self();
        }

        @Generated
        public B sapErpFunctionModuleExportParams(Collection<? extends Map<String, String>> sapErpFunctionModuleExportParams) {
            if (sapErpFunctionModuleExportParams == null) {
                throw new NullPointerException("sapErpFunctionModuleExportParams cannot be null");
            }
            if (this.sapErpFunctionModuleExportParams == null) {
                this.sapErpFunctionModuleExportParams = new ArrayList();
            }
            this.sapErpFunctionModuleExportParams.addAll(sapErpFunctionModuleExportParams);
            return (B)this.self();
        }

        @Generated
        public B clearSapErpFunctionModuleExportParams() {
            if (this.sapErpFunctionModuleExportParams != null) {
                this.sapErpFunctionModuleExportParams.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sapErpFunctionModuleExportParamsCount(Long sapErpFunctionModuleExportParamsCount) {
            this.sapErpFunctionModuleExportParamsCount = sapErpFunctionModuleExportParamsCount;
            return (B)this.self();
        }

        @Generated
        public B sapErpFunctionModuleGroup(String sapErpFunctionModuleGroup) {
            this.sapErpFunctionModuleGroup = sapErpFunctionModuleGroup;
            return (B)this.self();
        }

        @Generated
        public B sapErpFunctionModuleImportParam(Map<String, String> sapErpFunctionModuleImportParam) {
            if (this.sapErpFunctionModuleImportParams == null) {
                this.sapErpFunctionModuleImportParams = new ArrayList();
            }
            this.sapErpFunctionModuleImportParams.add(sapErpFunctionModuleImportParam);
            return (B)this.self();
        }

        @Generated
        public B sapErpFunctionModuleImportParams(Collection<? extends Map<String, String>> sapErpFunctionModuleImportParams) {
            if (sapErpFunctionModuleImportParams == null) {
                throw new NullPointerException("sapErpFunctionModuleImportParams cannot be null");
            }
            if (this.sapErpFunctionModuleImportParams == null) {
                this.sapErpFunctionModuleImportParams = new ArrayList();
            }
            this.sapErpFunctionModuleImportParams.addAll(sapErpFunctionModuleImportParams);
            return (B)this.self();
        }

        @Generated
        public B clearSapErpFunctionModuleImportParams() {
            if (this.sapErpFunctionModuleImportParams != null) {
                this.sapErpFunctionModuleImportParams.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sapErpFunctionModuleImportParamsCount(Long sapErpFunctionModuleImportParamsCount) {
            this.sapErpFunctionModuleImportParamsCount = sapErpFunctionModuleImportParamsCount;
            return (B)this.self();
        }

        @Generated
        public B sapFieldCount(Long sapFieldCount) {
            this.sapFieldCount = sapFieldCount;
            return (B)this.self();
        }

        @Generated
        public B sapFieldOrder(Integer sapFieldOrder) {
            this.sapFieldOrder = sapFieldOrder;
            return (B)this.self();
        }

        @Generated
        public B sapLogicalName(String sapLogicalName) {
            this.sapLogicalName = sapLogicalName;
            return (B)this.self();
        }

        @Generated
        public B sapPackageName(String sapPackageName) {
            this.sapPackageName = sapPackageName;
            return (B)this.self();
        }

        @Generated
        public B sapTechnicalName(String sapTechnicalName) {
            this.sapTechnicalName = sapTechnicalName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SapErpFunctionModule.SapErpFunctionModuleBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", sapComponentName=" + this.sapComponentName + ", sapDataType=" + this.sapDataType + ", sapErpAbapProgram=" + String.valueOf(this.sapErpAbapProgram) + ", sapErpComponent=" + String.valueOf(this.sapErpComponent) + ", sapErpFunctionExceptionList=" + String.valueOf(this.sapErpFunctionExceptionList) + ", sapErpFunctionExceptionListCount=" + this.sapErpFunctionExceptionListCount + ", sapErpFunctionModuleExportParams=" + String.valueOf(this.sapErpFunctionModuleExportParams) + ", sapErpFunctionModuleExportParamsCount=" + this.sapErpFunctionModuleExportParamsCount + ", sapErpFunctionModuleGroup=" + this.sapErpFunctionModuleGroup + ", sapErpFunctionModuleImportParams=" + String.valueOf(this.sapErpFunctionModuleImportParams) + ", sapErpFunctionModuleImportParamsCount=" + this.sapErpFunctionModuleImportParamsCount + ", sapFieldCount=" + this.sapFieldCount + ", sapFieldOrder=" + this.sapFieldOrder + ", sapLogicalName=" + this.sapLogicalName + ", sapPackageName=" + this.sapPackageName + ", sapTechnicalName=" + this.sapTechnicalName + ")";
        }
    }

    @Generated
    private static final class SapErpFunctionModuleBuilderImpl
    extends SapErpFunctionModuleBuilder<SapErpFunctionModule, SapErpFunctionModuleBuilderImpl> {
        @Generated
        private SapErpFunctionModuleBuilderImpl() {
        }

        @Override
        @Generated
        protected SapErpFunctionModuleBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SapErpFunctionModule build() {
            return new SapErpFunctionModule(this);
        }
    }
}

